/*
 *	clipxmp1.c
 *
 *	YAMAHA YMZ871 XMP-1 (eXtensible Music Player - 1) ȈՃhCo
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Thu Oct 13 21:52:21 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- ́ATAPV[PT,TAP~LT[,^C}ǗW[pāAYMZ871𐧌䂷ȈՃhCołB
 *	  YMZ871̓ɂẮAȑOɁAcliptaps.c̒ɂRgĂ̂ŁAQƂĉB
 */
#include "clip.h"
#ifndef __RENESAS__
#include "tool/XmpPifCnv/Xmp1.h"	//WindowsP/ECEł́AXmp1.h̓c[tH_̒ɗL܂B
#else //__RENESAS__
#include "Xmp1.h"			//Hewł́AXmp1.hvWFNgtH_ɃRs[ĉB
#endif//__RENESAS__
/*****************************************************************************
 *	[J֐錾
 *****************************************************************************/
static uint8_t Xmp1_Read(ST_Xmp1* pXmp1, uint16_t rb_index/*((rb<<8)|index)*/) __attribute__((unused));		//gp:2016/10/13݂̎ł͎gpĂ܂B
static void Xmp1_Write(ST_Xmp1* pXmp1, uint16_t rb_index/*((rb<<8)|index)*/, uint8_t data);
static ST_Xmp1Trk* Xmp1_GetXmp1Trk(ST_Xmp1* pXmp1, int iDevCh);
static void Xmp1_GetPanVol(ST_Xmp1* pXmp1, int iLogCh, ST_TapLogCh* pLogCh, int* pPan, int* pVol1, int* pVol2);
static void Xmp1_VolUpd(ST_Xmp1* pXmp1, int iDevCh, ST_Xmp1Trk* pXmp1Trk);
static void Xmp1_SetTvo(ST_Xmp1* pXmp1, int iVol);
static void Xmp1_Exec_Xms(void* arg);
static void Xmp1_Exec_X00ms(void* arg);
static void Xmp1_TapSeq_fnPlay(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);
static void Xmp1_TapSeq_fnStop(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);
static void Xmp1_TapSeq_fnLoop(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);
static void Xmp1_TapSeq_fnEnd(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);
static void Xmp1_TapSeq_fnNext(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);
static void Xmp1_TapSeq_fnCtrl(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);
static int Xmp1_TapSeq_fnGetPhrTime(ST_TapSeq* pTapSeq, int iPhr);
static int Xmp1_TapSeq_fnGetPhrNext(ST_TapSeq* pTapSeq, int iPhr);
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//Ǘ\̂B
//[note]
// - pTimMgrST_Xmp1InfoɊ܂߂AXmp1_Init()̈ƂŔAȉ̓̗RłB
//   R1. pTimMgrXmp1_Init()֐̒ŎgpȌ͎gpȂ̂ŁAST_Xmp1InfoɊ܂߂͖̂ʂł邩B
//   R2. (AvP[V̍\ɂ邪)pTimMgr͐ÓIɏłȂ\̂ŁApTimMgrST_Xmp1InfoɊ܂߂ST_Xmp1InfoÓIɒ`oȂȂ邩B
void Xmp1_Init(ST_Xmp1* pXmp1, const ST_Xmp1Info* pInfo, ST_TimMgr* pTimMgr) {
	//Ǘ\̂NAB
	memset(pXmp1, 0, sizeof(ST_Xmp1));
	//ւ̃|C^i[B
	pXmp1->pInfo = pInfo;
ENTER_CS;
	//--- WX^Œl̐ݒ菈 ---
	{
		Xmp1_Write(pXmp1, XMP1_P1_x_7_0,	0x40);		//㉺p|bg	ftHgl0x00łBAvP[V͏0x40ƂĎgp̂ŁAύXĂBȌAύXKv͖B
		//ɒǉo܂B
	}
	//--- {[XCb`̏ ---
	{
		//{[XCb`̏li[B
		pXmp1->Vol = pXmp1->NewVol = (*pXmp1->pInfo->getVolumeSw)();
		//g[^{[ݒ肷B
		Xmp1_SetTvo(pXmp1, pXmp1->Vol);
	}
	//--- gbNz̏ ---
	{
		int iDevCh;
		for(iDevCh = 0; iDevCh <= Xmp1_TapDevCh_Max; iDevCh++) {
			ST_Xmp1Trk* pXmp1Trk = Xmp1_GetXmp1Trk(pXmp1, iDevCh);
		//sv	pXmp1Trk->Flag		= 0;		//tO			ɃNAĂ̂ŖIȏsv
		//sv	pXmp1Trk->BusyTime	= 0;		//rW[[ms]	ɃNAĂ̂ŖIȏsv
			pXmp1Trk->PN		= -1;		//Đt[Yԍ
		//sv	pXmp1Trk->P0		= 0x40;		//Ep			ĐJnyэĐɐݒ肷̂ŏsv
		//sv	pXmp1Trk->V1		= 0x80;		//1{[			~LT[̎Őݒ肷̂ŏsv
		//sv	pXmp1Trk->V2		= 0x80;		//2{[			ĐJnyэĐɐݒ肷̂ŏsv
		//sv	pXmp1Trk->LOOP		= 0xFF;		//[v			ĐJnyэĐɐݒ肷̂ŏsv
		}
	}
	//--- V[PT̏ ---
	{
		static const uint8_t TBL_TapSet[(Xmp1_TapLogCh_Max+1)][2]={
			{ 0,-1},{ 1,-1},{ 2,-1},{ 3,-1},	//
			{ 4,-1},{ 5,-1},{ 6,-1},{ 7,-1},	//2016/10/13݂̎ł́A_`lƃfoCX`l1:1Ŋ蓖ĂĂ܂BXmp1_TapLogCh_Max̒`ύXꍇ́Ãf[^ύXĉB
			{ 8,-1},{ 9,-1},{10,-1},{11,-1},	//
			{12,-1},{13,-1},{14,-1},{15,-1}};	//
		static const struct {
			ST_TapSeqInfo	_stTapSeqInfo;
			const uint8_t*	_TBL_TapSet[(Xmp1_TapLogCh_Max+1)];
		} stTapSeqInfo = {{
			(8191+1),		//nPhr
			(Xmp1_TapDevCh_Max+1),	//nDevCh
			(Xmp1_TapLogCh_Max+1),	//nLogCh
			(Xmp1_TapSeqCh_Max+1),	//nSeqCh
			Xmp1_TapSeq_iCont,	//iCont
			Xmp1_TapSeq_nEvt,	//nEvt
			Xmp1_TapSeq_iEvtMsk,	//iEvtMsk	ύX
			Xmp1_TapSeq_fnPlay,
			Xmp1_TapSeq_fnStop,
			Xmp1_TapSeq_fnLoop,
			Xmp1_TapSeq_fnEnd,
			Xmp1_TapSeq_fnNext,
			Xmp1_TapSeq_fnCtrl,
			Xmp1_TapSeq_fnGetPhrTime,
			Xmp1_TapSeq_fnGetPhrNext,
		},{
			TBL_TapSet[ 0],TBL_TapSet[ 1],TBL_TapSet[ 2],TBL_TapSet[ 3],	//
			TBL_TapSet[ 4],TBL_TapSet[ 5],TBL_TapSet[ 6],TBL_TapSet[ 7],	//2016/10/13݂̎ł́A_`lƃfoCX`l1:1Ŋ蓖ĂĂ܂BXmp1_TapLogCh_Max̒`ύXꍇ́Ãf[^ύXĉB
			TBL_TapSet[ 8],TBL_TapSet[ 9],TBL_TapSet[10],TBL_TapSet[11],	//
			TBL_TapSet[12],TBL_TapSet[13],TBL_TapSet[14],TBL_TapSet[15],	//
		}};
		//V[PTB
		TapSeq_Init(Xmp1_GetTapSeq(pXmp1), &stTapSeqInfo._stTapSeqInfo);
		//V[PT̃^C}֐o^B
		pXmp1->stTimMgrFunc_TapSeq.fn		= Xmp1_Exec_Xms;
		pXmp1->stTimMgrFunc_TapSeq.arg		= pXmp1;
		pXmp1->stTimMgrFunc_TapSeq.uItv		= Xmp1_Exec_Xms_uItv;
		TimMgr_AddFunc(pTimMgr, TimMgrCh_1ms, &pXmp1->stTimMgrFunc_TapSeq);
	}
	//--- ~LT[̏ ---
	{
		//~LT[B
		TapMxr_Init(Xmp1_GetTapMxr(pXmp1), (Xmp1_TapMxrCh_Max+1));
		//~LT[̃^C}֐o^B
		pXmp1->stTimMgrFunc_TapMxr.fn		= Xmp1_Exec_X00ms;
		pXmp1->stTimMgrFunc_TapMxr.arg		= pXmp1;
		pXmp1->stTimMgrFunc_TapMxr.uItv		= Xmp1_Exec_X00ms_uItv;
		TimMgr_AddFunc(pTimMgr, TimMgrCh_100ms, &pXmp1->stTimMgrFunc_TapMxr);
	}
LEAVE_CS;
}
/*--------------------------------------------------------------------------*/
//Ǘ\̂Ɋ܂܂ĂAV[PTւ̃|C^擾B
ST_TapSeq* Xmp1_GetTapSeq(ST_Xmp1* pXmp1) {
	return &pXmp1->_stTapSeq;
}
/*--------------------------------------------------------------------------*/
//Ǘ\̂Ɋ܂܂ĂA~LT[ւ̃|C^擾B
ST_TapMxr* Xmp1_GetTapMxr(ST_Xmp1* pXmp1) {
	return &pXmp1->_stTapMxr;
}
/*****************************************************************************
 *	[J֐
 *****************************************************************************/
//XMP-1̃WX^ǂݏoB
// - 荞݋֎~ԂŌĂяôŁA֐Ŋ荞݋֎~͕svłB
static uint8_t Xmp1_Read(ST_Xmp1* pXmp1, uint16_t rb_index/*((rb<<8)|index)*/) {
	uint8_t rb    = rb_index >> 8;	//rb_index[15:8]=WX^oN(0`6)
	uint8_t index = rb_index;	//rb_index[ 7:0]=WX^Ԓn(0x00`0xFF)
	return (*pXmp1->pInfo->readXmp1Reg)(rb, index);		//ۂ̏́AAvP[V`̊֐ĂяočsB
}
/*---------------------------------------------------------------------------*/
//XMP-1̃WX^ɏށB
// - 荞݋֎~ԂŌĂяôŁA֐Ŋ荞݋֎~͕svłB
static void Xmp1_Write(ST_Xmp1* pXmp1, uint16_t rb_index/*((rb<<8)|index)*/, uint8_t data) {
	uint8_t rb    = rb_index >> 8;	//rb_index[15:8]=WX^oN(0`6)
	uint8_t index = rb_index;	//rb_index[ 7:0]=WX^Ԓn(0x00`0xFF)
	(*pXmp1->pInfo->writeXmp1Reg)(rb, index, data);		//ۂ̏́AAvP[V`̊֐ĂяočsB
}
/*--------------------------------------------------------------------------*/
//gbN\̂擾B
// - ֐́A荞݋ԂŎsĂSłB
static ST_Xmp1Trk* Xmp1_GetXmp1Trk(ST_Xmp1* pXmp1, int iDevCh) {
	if((unsigned)iDevCh > Xmp1_TapDevCh_Max) { DIE(); }
	return &pXmp1->TBL_Xmp1Trk[iDevCh];
}
/*---------------------------------------------------------------------------*/
//_`l̍Epl,1{[l,2{[l߂B
// - ֐́A荞݋ԂŎsĂSłB
static void Xmp1_GetPanVol(ST_Xmp1* pXmp1, int iLogCh, ST_TapLogCh* pLogCh, int* pPan, int* pVol1, int* pVol2) {
	int fMxrChMask, iPan, iVol1, iVol2;
	//Epl߂B
	// - XeIt[Y̏ꍇ́AEpl̓_~[ƂȂB
	iPan = 0x40/*Ep̒l*/ + pLogCh->iPan;
	if(iPan < 0x00) { iPan = 0x00; }
	if(iPan > 0x80) { iPan = 0x80; }
	*pPan = iPan;
	//1{[l߂B
	// - _`lɓKp~LT[`l̍vʂ擾AʁˉʂɕϊB
	if((Xmp1_TapMxrCh_Max + 1) > (sizeof(int) * 8)) { DIE(); }	//TapMxr_GetAtt()̂(~LT[`l>32)ΉĂ邪A֐͊ȒP̂߂(~LT[`l<=32)OƂĂB
	fMxrChMask = (*pXmp1->pInfo->getMxrChMask)(iLogCh);		//~LT[`l}XN擾B(~LT[`l<=32)OƂĂ̂ŁA(int)zł͂Ȃ(int)lƂĎ擾oB
	iVol1 = 0x80/*1{[̍ől*/ - TapMxr_GetAtt(Xmp1_GetTapMxr(pXmp1), &fMxrChMask);	//_`lɓKp~LT[`l̍vʂ擾AʁˉʂɕϊB
	if(iVol1 < 0) { iVol1 = 0; }
	*pVol1 = iVol1;
	//2{[l߂B
	// - _`ľʂ擾AʁˉʂɕϊB
	iVol2 = 0x80/*2{[̍ől*/ - pLogCh->iAtt;
	if(iVol2 < 0) { iVol2 = 0; }
	*pVol2 = iVol2;
}
/*---------------------------------------------------------------------------*/
//gbŃA{[Abvf[gsB
// - Xmp1_Exec_Xms()Xmp1_TapSeq_fnCtrl()̋ʏłB
// - 荞݋֎~ԂŌĂяôŁA֐Ŋ荞݋֎~͕svłB
static void Xmp1_VolUpd(ST_Xmp1* pXmp1, int iDevCh, ST_Xmp1Trk* pXmp1Trk) {
	//XeIt[YȂ΁c
	if(pXmp1Trk->Flag & Xmp1Trk_Flag_Stereo) {
		//{[Abvf[gsB
		Xmp1_Write(pXmp1, XMP1_P0_x_7_0,	0x82);			//Ep			XeI(E)
		Xmp1_Write(pXmp1, XMP1_V1_x_7_0,	pXmp1Trk->V1);		//1{[			XeI(E)
		Xmp1_Write(pXmp1, XMP1_V2_x_7_0,	pXmp1Trk->V2);		//2{[			XeI(E)
		Xmp1_Write(pXmp1, XMP1_LOOP_x_7_0,	pXmp1Trk->LOOP);	//[v			XeI(E)
		Xmp1_Write(pXmp1, XMP1_PVUP_x_PTRK_6_0,	0x81|(iDevCh<<1));	//{[Abvf[g	XeI(E)	gbNԍ=foCX`lԍ*2+1
		Xmp1_Write(pXmp1, XMP1_P0_x_7_0,	0x81);			//Ep			XeI()
	//sv	Xmp1_Write(pXmp1, XMP1_V1_x_7_0,	pXmp1Trk->V1);		//1{[			XeI()	WX^lύXsv
	//sv	Xmp1_Write(pXmp1, XMP1_V2_x_7_0,	pXmp1Trk->V2);		//2{[			XeI()	WX^lύXsv
	//sv	Xmp1_Write(pXmp1, XMP1_LOOP_x_7_0,	pXmp1Trk->LOOP);	//[v			XeI()	WX^lύXsv
		Xmp1_Write(pXmp1, XMP1_PVUP_x_PTRK_6_0,	0x80|(iDevCh<<1));	//{[Abvf[g	XeI()	gbNԍ=foCX`lԍ*2+0
	//mt[YȂ΁c
	} else {
		//{[Abvf[gsB
		Xmp1_Write(pXmp1, XMP1_P0_x_7_0,	pXmp1Trk->P0);		//Ep			m
		Xmp1_Write(pXmp1, XMP1_V1_x_7_0,	pXmp1Trk->V1);		//1{[			m
		Xmp1_Write(pXmp1, XMP1_V2_x_7_0,	pXmp1Trk->V2);		//2{[			m
		Xmp1_Write(pXmp1, XMP1_LOOP_x_7_0,	pXmp1Trk->LOOP);	//[v			m
		Xmp1_Write(pXmp1, XMP1_PVUP_x_PTRK_6_0,	0x80|(iDevCh<<1));	//{[Abvf[g	m	gbNԍ=foCX`lԍ*2
	}
}
/*--------------------------------------------------------------------------*/
//g[^{[ݒ肷B
// - 荞݋֎~ԂŌĂяôŁA֐Ŋ荞݋֎~͕svłB
static void Xmp1_SetTvo(ST_Xmp1* pXmp1, int iVol) {
	Xmp1_Write(pXmp1, XMP1_TV0_7_0,		iVol);		//L0,R0
	Xmp1_Write(pXmp1, XMP1_TV1_7_0,		iVol);		//L1,R1
	Xmp1_Write(pXmp1, XMP1_TV2_7_0,		iVol);		//SUB0
	Xmp1_Write(pXmp1, XMP1_TV3_7_0,		iVol);		//SUB1
}
/*--------------------------------------------------------------------------*/
//1ms^C}֐
// - TimMgr_Intr()犄荞݋֎~ԂŌĂяôŁA֐Ŋ荞݋֎~͕svłB
// - TODO:2016/10/13݂̎ł́Aȉ̐񂪍loĂ܂B
//   QƎuYMZ871 عƭ CATALOG No. LSI-5MZ871A40 2013.9v(5MZ871A40.pdf)́Au7.1.2. t[YĐAV[PT[v(p.232)p
//   7.1.2. t[YĐAV[PT[
//   11. t[YĐ͍ő32mt[YA16XeIt[Y̓ĐsƂł܂B
//       Aȉ̏ɊւẮAt[ŏłt[Y͍ő16mt[YA8XeIt[YɂȂ܂B
//       Et[œɔsł撅DĐA㒅DĐ̐
//       Et[œɔsł|[YAW[v̐
//       Ƃ΁AĐJn^C~O炵Ȃ獇v32mt[Y撅DA㒅DĐ邱Ƃ͂ł܂A32mt[Y̐撅DA㒅DĐJn邱Ƃ͂ł܂B
//   ʂ̎gp@ŏL̐𒴉߂鎖͂܂Ǝv̂ŁAL̐lȂĂ肪݉\͒Ⴂ̂łA͂m̂߂ɂ͍lĂׂłB
//   ĐJn͓֐łsĂ炸,,֐͒IɎs֐Ȃ̂ŁAL̐lĐ𒴂T[Y̍ĐJn͎֒x鎖\Ȃ͂łB(TODO:)
static void Xmp1_Exec_Xms(void* arg) {
	ST_Xmp1* pXmp1 = arg;
	//--- V[PT̏ ---
	{
		//V[PTsB
		TapSeq_Exec(Xmp1_GetTapSeq(pXmp1), Xmp1_Exec_Xms_uItv/*[ms]*/);
	}
	//--- rW[҂t[Y̏ ---
	{
		int iDevCh, t;
		//ݎ擾B
		t = (*pXmp1->pInfo->getMsecTime)();
		//egbNɂāc
		for(iDevCh = 0; iDevCh <= Xmp1_TapDevCh_Max; iDevCh++) {
			ST_Xmp1Trk* pXmp1Trk = Xmp1_GetXmp1Trk(pXmp1, iDevCh);
			//rW[Ȃ΁c
			if(pXmp1Trk->Flag & Xmp1Trk_Flag_Busy) {
				//rW[莞Ԉȏo߂AfBƂB
				if((uint8_t)(t - pXmp1Trk->BusyTime) >= Xmp1_BusyToReady_ms) { pXmp1Trk->Flag &= ~Xmp1Trk_Flag_Busy; }
			}
			//rW[҂t[YL΁c
			if(pXmp1Trk->Flag & Xmp1Trk_Flag_Pending) {
				//fBȂ΁c
				if(!(pXmp1Trk->Flag & Xmp1Trk_Flag_Busy)) {
					//gbN\̂ɒli[B
					pXmp1Trk->Flag		&= ~Xmp1Trk_Flag_Pending;	//rW[҂t[YNAB
					pXmp1Trk->Flag		|=  Xmp1Trk_Flag_Busy;		//rW[ƂB
					pXmp1Trk->BusyTime	= t;				//rW[i[B
					//{[Abvf[gsB
					Xmp1_VolUpd(pXmp1, iDevCh, pXmp1Trk);
					//rW[҂t[YĐJnB
					Xmp1_Write(pXmp1, XMP1_PN_x0_7_0,				pXmp1Trk->PN);		//t[Yԍ
					Xmp1_Write(pXmp1, XMP1_PL_x0_2_0_PN_x0_12_8,			pXmp1Trk->PN>>8);	//
					Xmp1_Write(pXmp1, XMP1_PPLAY_x_1_0_PPLAY_PRI_PNRCL_PNUM_x_2_0,	0x40);			//ĐJn
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
//100ms^C}֐
// - TimMgr_Exec()犄荞݋ԂŌĂяôŁA֐Ŋ荞݋֎~sKvL܂B
static void Xmp1_Exec_X00ms(void* arg) {
	ST_Xmp1* pXmp1 = arg;
ENTER_CS;
	//--- ~LT[̏ ---
	{
		int iDevCh, iLogCh;
		ST_TapLogCh* pLogCh;
		//~LT[sB
		TapMxr_Exec(Xmp1_GetTapMxr(pXmp1), (Xmp1_Exec_X00ms_uItv * 100)/*[ms]*/);
		//efoCX`lɂāc
		for(iDevCh = 0; iDevCh <= Xmp1_TapDevCh_Max; iDevCh++) {
			//̃foCX`l𐧌䂵Ă_`lL΁c
			iLogCh = TapSeq_GetDevCh(Xmp1_GetTapSeq(pXmp1), iDevCh)->iLogCh;
			if(iLogCh != UINT8_MAX) {
				//̃foCX`l𐧌䂵Ă_`l擾B
				pLogCh = TapSeq_GetLogCh(Xmp1_GetTapSeq(pXmp1), iLogCh);
				//foCX`l̉ʂݒ肷B
				// - lωĂȂꍇ́AXmp1_TapSeq_fnCtrl()肵āA{[Abvf[gsȂB
				//   ]āAXmp1_TapSeq_fnCtrl()Ăяoč\ȂB
				Xmp1_TapSeq_fnCtrl(Xmp1_GetTapSeq(pXmp1), iLogCh, pLogCh);
			}
		}
	}
	//--- {[XCb`̏ ---
	{
		int iVol;
		//{[XCb`̃|[gl擾B
		iVol = (*pXmp1->pInfo->getVolumeSw)();
		//{[XCb`̃|[glA{[XCb`̈lƈႤȂ΁c
		if(iVol != pXmp1->Vol) {
			//{[XCb`̃|[glωĂc
			if(iVol != pXmp1->NewVol) {
				//{[XCb`̕ωi[B
				pXmp1->NewVolTime = (*pXmp1->pInfo->getMsecTime)();
			//{[XCb`̃|[glωĂ炸A{[XCb`̕ω莞Ԉȏo߂c
			} else if((uint8_t)((*pXmp1->pInfo->getMsecTime)() - pXmp1->NewVolTime) >= Xmp1_VolumeSw_Stable_ms) {
				//{[XCb`̈li[B
				pXmp1->Vol = iVol;
				//g[^{[ݒ肷B
				Xmp1_SetTvo(pXmp1, pXmp1->Vol);
			}
		}
		//ɂĂA{[XCb`̃|[gli[B
		pXmp1->NewVol = iVol;
	}
LEAVE_CS;
}
/*---------------------------------------------------------------------------*/
//ĐJnʒm
// - 荞݋֎~ԂŌĂяôŁA֐Ŋ荞݋֎~͕svłB
static void Xmp1_TapSeq_fnPlay(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	ST_Xmp1* pXmp1 = CONTAINING_RECORD(pTapSeq, ST_Xmp1, _stTapSeq);
	//_`lfoCX`llĂc
	int iDevCh = pLogCh->iDevCh;
	if(iDevCh != UINT8_MAX) {
		int iPan, iVol1, iVol2, iLoop, No, Channel;
		//gbN\̂擾B
		ST_Xmp1Trk* pXmp1Trk = Xmp1_GetXmp1Trk(pXmp1, iDevCh);
		//_`l̍Epl,1{[l,2{[l߂B
		// - XeIt[Y̏ꍇ́AEpl̓_~[ƂȂB
		Xmp1_GetPanVol(pXmp1, iLogCh, pLogCh, &iPan, &iVol1, &iVol2);
		//[v񐔂̐ݒl߂B
		// - 0(),1(1)`255(255)  0(1)`254(255),255()
		iLoop = pLogCh->iLoop - 1;
		//t[Y}bv擾B
		No      = REG_get_value_l(pXmp1->pInfo->TBL_RegTbl, pXmp1->pInfo->_RegKey_PhrDef, pLogCh->iPhr, pXmp1->pInfo->_RegKey_No,      -1);
		Channel = REG_get_value_l(pXmp1->pInfo->TBL_RegTbl, pXmp1->pInfo->_RegKey_PhrDef, pLogCh->iPhr, pXmp1->pInfo->_RegKey_Channel, -1);
		if(((unsigned)No > 8191) || ((Channel < 1) || (Channel > 2))) { DIE(); }
		//gbN\̂ɒli[B
		if(Channel == 1) {
			pXmp1Trk->Flag		&= ~Xmp1Trk_Flag_Stereo;	//mt[Y
		} else {
			pXmp1Trk->Flag		|=  Xmp1Trk_Flag_Stereo;	//XeIt[Y
		}
		pXmp1Trk->Flag		|=  Xmp1Trk_Flag_Pending;		//rW[҂t[YZbgB	dv!!̉̃RgQƂB
		pXmp1Trk->PN		= No;		//t[Yԍ
		pXmp1Trk->P0		= iPan;		//Ep		XeIt[Y̏ꍇ̓_~[
		pXmp1Trk->V1		= iVol1;	//1{[
		pXmp1Trk->V2		= iVol2;	//2{[
		pXmp1Trk->LOOP		= iLoop;	//[v
		//֐ł́AĐJnsȂB
		// - fBȂ΁AXmp1_Exec_Xms()ōĐJnsB
		//   rW[Ȃ΁AfBɂȂXmp1_Exec_Xms()ōĐJnsB
		//   ɂĂAōśAL̃gbN\̂ɒli[鏈ŗǂB
		// - fBȂ΁AōĐJnsĂ\Ȃ̂AĐJnXmp1_Exec_Xms()܂ŒxĂقƂǈႢ낤B
		//   ĐJn񂩏ɕUĔhȂ鎖邽߂ɁAĐJnXmp1_Exec_Xms()ōsɂB
	}
}
/*---------------------------------------------------------------------------*/
//Đ~ʒm
// - 荞݋֎~ԂŌĂяôŁA֐Ŋ荞݋֎~͕svłB
static void Xmp1_TapSeq_fnStop(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	ST_Xmp1* pXmp1 = CONTAINING_RECORD(pTapSeq, ST_Xmp1, _stTapSeq);
	//_`lfoCX`llĂc
	int iDevCh = pLogCh->iDevCh;
	if(iDevCh != UINT8_MAX) {
		//gbN\̂擾B
		ST_Xmp1Trk* pXmp1Trk = Xmp1_GetXmp1Trk(pXmp1, iDevCh);
		//gbN\̂ɒli[B
		pXmp1Trk->PN		= -1;					//gbN~ƂArW[҂t[YmɃNAB	YȂ!!
		pXmp1Trk->Flag		&= ~Xmp1Trk_Flag_Pending;		//
	//sv	pXmp1Trk->Flag		|=  Xmp1Trk_Flag_Busy;			//rW[Ȃ΁Ã݂rW[pB
	//sv	pXmp1Trk->BusyTime	= (*pXmp1->pInfo->getMsecTime)();	//
		//gbN~B
		Xmp1_Write(pXmp1, XMP1_PVUP_x_PTRK_6_0,				0x00|(iDevCh<<1));	//{[Abvf[g	gbNԍ=foCX`lԍ*2
		Xmp1_Write(pXmp1, XMP1_PPLAY_x_1_0_PPLAY_PRI_PNRCL_PNUM_x_2_0,	0x00);			//~
	}
}
/*---------------------------------------------------------------------------*/
//R[vʒm
// - 荞݋֎~ԂŌĂяôŁA֐Ŋ荞݋֎~͕svłB
static void Xmp1_TapSeq_fnLoop(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
//sv	ST_Xmp1* pXmp1 = CONTAINING_RECORD(pTapSeq, ST_Xmp1, _stTapSeq);
	/** no job **/
}
/*---------------------------------------------------------------------------*/
//R~ʒm
// - 荞݋֎~ԂŌĂяôŁA֐Ŋ荞݋֎~͕svłB
static void Xmp1_TapSeq_fnEnd(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
//sv	ST_Xmp1* pXmp1 = CONTAINING_RECORD(pTapSeq, ST_Xmp1, _stTapSeq);
	/** no job **/
}
/*---------------------------------------------------------------------------*/
//RJڒʒm
// - 荞݋֎~ԂŌĂяôŁA֐Ŋ荞݋֎~͕svłB
static void Xmp1_TapSeq_fnNext(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
//sv	ST_Xmp1* pXmp1 = CONTAINING_RECORD(pTapSeq, ST_Xmp1, _stTapSeq);
	Xmp1_TapSeq_fnPlay(pTapSeq, iLogCh, pLogCh);
}
/*---------------------------------------------------------------------------*/
//Rg[ʒm
// - 荞݋֎~ԂŌĂяôŁA֐Ŋ荞݋֎~͕svłB
static void Xmp1_TapSeq_fnCtrl(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	ST_Xmp1* pXmp1 = CONTAINING_RECORD(pTapSeq, ST_Xmp1, _stTapSeq);
	//_`lfoCX`llĂc
	int iDevCh = pLogCh->iDevCh;
	if(iDevCh != UINT8_MAX) {
		int iPan, iVol1, iVol2;
		//gbN\̂擾B
		ST_Xmp1Trk* pXmp1Trk = Xmp1_GetXmp1Trk(pXmp1, iDevCh);
		//ĐȂ΁c
		// - pXmp1Trk->PN̓rW[҂t[YĂ\L邪ȀꍇgbN\̂ɒli[KvL̂ňȉ̏sB
		if(pXmp1Trk->PN != -1) {
			//_`l̍Epl,1{[l,2{[l߂B
			// - XeIt[Y̏ꍇ́AEpl̓_~[ƂȂB
			Xmp1_GetPanVol(pXmp1, iLogCh, pLogCh, &iPan, &iVol1, &iVol2);
			//lłωĂc
			if((pXmp1Trk->P0 != iPan) ||		//Ep		XeIt[Y̏ꍇ̓_~[
			   (pXmp1Trk->V1 != iVol1) ||		//1{[
			   (pXmp1Trk->V2 != iVol2)) {		//2{[
				//gbN\̂ɒli[B
				pXmp1Trk->P0		= iPan;		//Ep		XeIt[Y̏ꍇ̓_~[
				pXmp1Trk->V1		= iVol1;	//1{[
				pXmp1Trk->V2		= iVol2;	//2{[
				//rW[҂t[Y΁c
				if(!(pXmp1Trk->Flag & Xmp1Trk_Flag_Pending)) {
					//{[Abvf[gsB
					Xmp1_VolUpd(pXmp1, iDevCh, pXmp1Trk);
				//rW[҂t[YL΁c
				} else {
					//pXmp1Trk->PNrW[҂t[Yꍇ́A{[Abvf[gsȂɂ܂B
					//pXmp1Trk->PNrW[҂t[YꍇA{[Abvf[gsĂ\܂񂪁AʂłB
					//fBɂȂXmp1_Exec_Xms()ŁAgbN\̂Ɋi[ĂlpāAĐJns邩łB
					/** no job **/
				}
			}
		}
	}
}
/*---------------------------------------------------------------------------*/
//t[Y[ms]擾B
// - ֐́A荞݋ԂŎsĂSłB
static int Xmp1_TapSeq_fnGetPhrTime(ST_TapSeq* pTapSeq, int iPhr) {
	ST_Xmp1* pXmp1 = CONTAINING_RECORD(pTapSeq, ST_Xmp1, _stTapSeq);
	int Time = REG_get_value_l(
		pXmp1->pInfo->TBL_RegTbl,
		pXmp1->pInfo->_RegKey_PhrDef,
		iPhr,
		pXmp1->pInfo->_RegKey_Time,
		-1);
	if(Time == -1) { DIE(); }
	return Time;
}
/*---------------------------------------------------------------------------*/
//t[Y`FC̎̃t[Yԍ擾B
// - ֐́A荞݋ԂŎsĂSłB
static int Xmp1_TapSeq_fnGetPhrNext(ST_TapSeq* pTapSeq, int iPhr) {
	ST_Xmp1* pXmp1 = CONTAINING_RECORD(pTapSeq, ST_Xmp1, _stTapSeq);
	int iNext = REG_get_value_l(
		pXmp1->pInfo->TBL_RegTbl,
		pXmp1->pInfo->_RegKey_PhrDef,
		iPhr,
		pXmp1->pInfo->_RegKey_Next,
		-1);
	iNext = (iNext << 8) >> 8;	//iNext[23]𕄍gB	YȂ!!
	return iNext;
}
