/*	
 *	clipxm.h
 *
 *	P/ECE XM Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Tue Nov 9 19:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_XM_H__
#define __CLIP_XM_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	XMt@Cdl
 ****************************************************************************/

/* oCgI[_[̓gGfBAłB */

/* General header */
typedef struct _XMGENERALHEADER {
	unsigned char id_text[17];				/* +  0, 17: ID text: 'Extended Module: ' */
								/*           (ɂ'Extended module: 'ƏĂ܂ԈႢB'm'ł͂Ȃ'M'̂悤ł) */
	unsigned char module_name[20];				/* + 17, 20: Module name, padded with spaces */
	unsigned char _1a[1];					/* + 37,  1: $1a */
	unsigned char tracker_name[20];				/* + 38, 20: Tracker name */
	unsigned char version_number[2];			/* + 58,  2: Version number, hi-byte major and low-byte minor */
								/*           The current format is version $0103 */
								/*	     (茳̃t@Cł$0104łB$0103̏ꍇG[Ƃ܂) */
	unsigned char header_size[4];				/* + 60,  4: Header size */
								/*           (Header size疖܂ł̃TCYBHeader sizeg܂݂܂Bʏ276(=336-60)ł) */
	unsigned char song_length[2];				/* + 64,  2: Song length (in pattern order table) */
	unsigned char restart_position[2];			/* + 66,  2: Restart position */
	unsigned char number_of_channels[2];			/* + 68,  2: Number of channels (2,4,6,8,10,...,32) */
	unsigned char number_of_patterns[2];			/* + 70,  2: Number of patterns (max 256) */
	unsigned char number_of_instruments[2];			/* + 72,  2: Number of instruments (max 128) */
	unsigned char flags[2];					/* + 74,  2: Flags: bit 0: 0 = Amiga frequency table, 1 = Linear frequency table */
	unsigned char default_tempo[2];				/* + 76,  2: Default tempo */
								/*           (pꂪĂBMODSpeedɑB1[Row]̃t[BقǑB1-31) */
	unsigned char default_bpm[2];				/* + 78,  2: Default bpm */
								/*           (pꂪĂBMODTempoɑB1̎lB傫قǑB125O) */
	unsigned char pattern_order_table[256];			/* + 80,256: Pattern order table */
} XMGENERALHEADER;						/* =336 */

/* Pattern header */
typedef struct _XMPATTERNHEADER {
	unsigned char pattern_header_length[4];			/* +  0,  4: Pattern header length */
	unsigned char packing_type[1];				/* +  4,  1: Packing type (always 0) */
								/*           (ꉞA茳̃t@Cł0łA{ɏ0sȂ̂ŁAȂƂɂ܂) */
	unsigned char number_of_rows_in_pattern[2];		/* +  5,  2: Number of rows in pattern (1..256) */
	unsigned char packed_pattern_data_size[2];		/* +  7,  2: Packed pattern data size */
} XMPATTERNHEADER;						/* =  9 */

/* Instrument header */
typedef struct _XMINSTRUMENTHEADER {
	unsigned char instrument_size[4];			/* +  0,  4: Instrument size */
								/*           (茳̃t@Cł263łBK29܂252ł͂Ȃ悤ł) */
	unsigned char instrument_name[22];			/* +  4, 22: Instrument name */
	unsigned char instrument_type[1];			/* + 26,  1: Instrument type (always 0) */
								/*           (茳̃t@Cł115łBȂقǂł) */
	unsigned char number_of_samples_in_instrument[2];	/* + 27,  2: Number of samples in instrument */
								/*           If the number of samples > 0, then the this will follow: */
	unsigned char sample_header_size[4];			/* + 29,  4: Sample header size */
	unsigned char sample_number_for_all_notes[96];		/* + 33, 96: Sample number for all notes */
	unsigned char points_for_volume_envelope[48];		/* +129, 48: Points for volume envelope */
	unsigned char points_for_panning_envelope[48];		/* +177, 48: Points for panning envelope */
								/*           Envelope points: x,y...x,y.... in couples (2 words/point => a maximum of 12 points). */
	unsigned char number_of_volume_points[1];		/* +225,  1: Number of volume points */
	unsigned char number_of_panning_points[1];		/* +226,  1: Number of panning points */
	unsigned char volume_sustain_point[1];			/* +227,  1: Volume sustain point */
								/*           (Volume type On = 1  Sustain = 1 ̏ꍇɗLłB                                                ) */
								/*	     (  NoteOnVolume sustain pointɒBAVolume sustain pointֈړ܂B                          ) */
								/*           (  Volume type On = 1  Sustain = 0 ̏ꍇ́AŌpointsustain pointݒ肳Ă̂ƓłB) */
	unsigned char volume_loop_start_point[1];		/* +228,  1: Volume loop start point */
	unsigned char volume_loop_end_point[1];			/* +229,  1: Volume loop end point */
								/*           (Volume type On = 1  Loop = 1 ̏ꍇɗLłB                                                       ) */
								/*           (  NoteOn/NoteOffɂ炸AVolume loop end pointɒBAVolume loop start pointֈړ܂B        ) */
								/*           (  Volume type On = 1  Loop = 0 ̏ꍇ́AŌpointloop start/end pointݒ肳Ă̂ƓłB) */
	unsigned char panning_sustain_point[1];			/* +230,  1: Panning sustain point */
	unsigned char panning_loop_start_point[1];		/* +231,  1: Panning loop start point */
	unsigned char panning_loop_end_point[1];		/* +232,  1: Panning loop end point */
	unsigned char volume_type[1];				/* +233,  1: Volume type: bit 0: On; 1: Sustain; 2: Loop */
	unsigned char panning_type[1];				/* +234,  1: Panning type: bit 0: On; 1: Sustain; 2: Loop */
	unsigned char vibrato_type[1];				/* +235,  1: Vibrato type */
	unsigned char vibrato_sweep[1];				/* +236,  1: Vibrato sweep */
	unsigned char vibrato_depth[1];				/* +237,  1: Vibrato depth */
	unsigned char vibrato_rate[1];				/* +238,  1: Vibrato rate */
	unsigned char volume_fadeout[2];			/* +239,  2: Volume fadeout */
								/*           (16biťŒ菬ŕ\Fadeout voluméATicǩʂłB) */
								/*           (  NoteOńAFadeout volume = (1<<16) ێ܂B                  ) */
								/*           (  NoteOff́ATick Fadeout volume -= Volume fadeout s܂B  ) */
	unsigned char reserved[11];				/* +241, 11: Reserved */
} XMINSTRUMENTHEADER;						/* =252 */

/* Sample header */
typedef struct _XMSAMPLEHEADER {
	unsigned char sample_length[4];				/* +  0,  4: Sample length */
								/*           (8/16bit̏ꍇoCgPʂłB16bitTv͔ƂƂɂȂ܂) */
	unsigned char sample_loop_start[4];			/* +  4,  4: Sample loop start */
								/*           (8/16bit̏ꍇoCgPʂłB16bitTv͔ƂƂɂȂ܂) */
	unsigned char sample_loop_length[4];			/* +  8,  4: Sample loop length */
								/*           Note: If the sample loop length is 0, the sample is *NOT* a looping one, */
								/*                 even if the "Forward loop" bit is set in the "Type" field. */
								/*           (8/16bit̏ꍇoCgPʂłB16bitTv͔ƂƂɂȂ܂) */
	unsigned char volume[1];				/* + 12,  1: Volume */
	unsigned char finetune[1];				/* + 13,  1: Finetune (signed byte -128..+127) */
	unsigned char type[1];					/* + 14,  1: Type: bit 0-1: 0 = No loop, 1 = Forward loop, 2 = Ping-pong loop; bit 4: 16-bit sample data */
	unsigned char panning[1];				/* + 15,  1: Panning (0-255) */
	unsigned char relative_note_number[1];			/* + 16,  1: Relative note number (signed byte) */
	unsigned char reserved[1];				/* + 17,  1: Reserved */
	unsigned char sample_name[22];				/* + 18, 22: Sample name */
} XMSAMPLEHEADER;						/* = 40 */

/****************************************************************************
 *	P/ECE XM Driver
 ****************************************************************************/

#define XMBUFLEN 320	/* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

/* * PeriodFrequencyɂ
 *
 * -  XMdlł́Ả߂邽߂FrequencýÂ悤ɒ߂Ă܂B
 *
 *		Period = 10*12*16*4 - Note*16*4 - Finetune/2
 *		Frequency = 8363 * 2^((6*12*16*4 - Period) / (12*16*4)) Zł
 *
 * - Finetune͒PɁANote1/256P(ɂ1/255)̒Ȃ̂ŁAƂōl邱ƂɂāAO܂B
 *
 *		Period = 10*12*16*4 - Note*16*4
 *		Frequency = 8363 * 2^((6*12*16*4 - Period) / (12*16*4))
 *		          = 8363 * 2^((6*12*16*4 - (10*12*16*4 - Note*16*4)) / (float)(12*16*4))
 *		          = 8363 * 2^((6*12 - (10*12 - Note)) / 12)
 *		          = 8363 * 2^((Note - 48) / 12)
 *		          = 8363 * 2^(Note/12 - 4)
 *		          = 8363 * 2^(Note/12) * 2^(-4)
 *		          = 8363/16 * 2^(Note/12)
 *
 * - āAPorta up/down effectNote1/256Pʂł̂ŁAPeriod̕ωs₷悤ɁA
 *
 *		Period = Note << 8
 *
 *   ƒ߂邱Ƃɂ܂B(ɂ1/255łȒP̂߂1/256Ƃ܂)
 *   XMdlł́APeriod傫ȂƉႭȂAPeriodȂƉȂ̂łA
 *   P/ECE XM DriverPeriod́Aό`Ă邽߁A}tł邱ƂɒӂĂB
 *
 * - ܂AFinetuneNote1/128̌ʂ܂B
 *   Finetune܂߂āAPeriodFrequency߂@́Â悤ɂȂ܂B
 *
 *		Frequency = 8363/16 * 2^((Period + Finetune*2)/(12*256))
 *
 * - _ׂ̂vZP/ECEɂ͏d߂̂ŁA揜Zƃe[uQƂɕό`܂B
 *
 *		Frequency = xm_linear_frequency_table[(Period + Finetune*2) % (12 * 256)]
 *						   << (Period + Finetune*2) / (12 * 256));
 *
 *   xm_linear_frequency_table[]́A8363/16*2^0.0`8363/16*2^1.0 A(12*256)XebvŌvZe[ułB
 *
 * - ȏAڍׂxm_run()xm_mix()̎QƂĂB
 */

/* Note */
typedef struct _XMNOTE {
	int note;						/* Note (1-96, 1 = C-0) */
								/* (0=No note, 1..96=C-0..B-7, 97=NoteOff, 98-=gp(Hɂ݂ł...) ) */
								/* (  ModPlugTracker̓IN^[u\L傫̂ŁA1..96=C-1..B-8ɑ܂B) */
								/* (  ModPlugTrackerB#0ȉC-9ȏ͂ƁANo noteŃZ[u܂B   ) */
	int instrument;						/* Instrument (1-128) */
	int volume_column_byte;					/* Volume column byte */
	int effect_type;					/* Effect type */
	int effect_parameter;					/* Effect parameter */
} XMNOTE;

/* Pattern */
typedef struct _XMPATTERN {
	int number_of_rows_in_pattern;
	const unsigned char* packed_pattern_data;		/* Direct */
} XMPATTERN;

/* Sample */
typedef struct _XMSAMPLE {
	const unsigned char* sample_data;			/* Direct, No loop, Forward loop, Ping-pong loop */
	const unsigned char* sample_end;			/* Direct, No loop                               */
	const unsigned char* sample_loop_start;			/* Direct,          Forward loop, Ping-pong loop */
	const unsigned char* sample_loop_end;			/* Direct,          Forward loop, Ping-pong loop */
	int sample_loop_output;					/*                  Forward loop                 */
	int volume;
	int finetune;
	int type;
	int relative_note_number;
} XMSAMPLE;

/* Envelope point */
typedef struct XMENVELOPEPOINT {
	unsigned short x;					/* Tick */
	unsigned short y;					/* Volume */
} XMENVELOPEPOINT;

/* Instrument */
typedef struct _XMINSTRUMENT {
	int number_of_samples_in_instrument;
	XMSAMPLE* samples/*[number_of_samples_in_instrument]*/;				/* Allocate */
	const unsigned char*  sample_number_for_all_notes/*[96]*/;			/* Direct */
	XMENVELOPEPOINT* points_for_volume_envelope/*[number_of_volume_points]*/;	/* Allocate, Volume type On */
	XMENVELOPEPOINT* volume_sustain_point;						/*           Volume type On, Sustain */
	XMENVELOPEPOINT* volume_loop_start_point;					/*           Volume type On, Loop */
	XMENVELOPEPOINT* volume_loop_end_point;						/*           Volume type On, Loop */
	int volume_fadeout;
} XMINSTRUMENT;

/* Channel */
typedef struct _XMCHANNEL {
/*0*/	int stat;						/* 0 = Silent, 1 = NoteOn, 2 = NoteOff */
/*1*/	XMINSTRUMENT* pending_instrument;			/* ݒ肳ĂInstrument */
/*2*/	XMINSTRUMENT* playing_instrument;			/* Instrument */
/*3*/	XMSAMPLE* playing_sample;				/* Sample */
/*4*/	const unsigned char* sample_position;			/* Sample dataʒu */
/*5*/	int sample_direction;					/* Sample data: 0 = Oi, 1 = (Ping-pong loop) */
/*6*/	int sample_output;					/* Sample data̗ݐϒl (WraparoundςȎdlȂ̂ŁAD31:16͕s!!) */
/*7*/	int volume;						/* Sample̋KlEffectŕω܂ (0`64) */
/*8*/	int period;						/* XMdlƂPeriod,Frequency̌vZ@ςĂ܂AʂFrequency͓ɂȂ܂ */
/*9*/	int finetune;						/* Sample̋KlEffectŕω܂ (}128Ŕ㉺) */
/*A*/	int progress;						/* Sample datap̐isJE^ */
/*B*/	XMENVELOPEPOINT *volume_envelope_position;		/* Points for volume envelopeʒu */
/*C*/	int volume_envelope_progress;				/* Points for volume envelopepTickJE^ */
/*D*/	int envelope_volume;					/* Volume envelopeŕω܂ (0`64) */
/*E*/	int fadeout_volume;					/* NoteOffAVolume fadeoutŕω܂ (655360) */
/*F*/	int volume_column_byte;					/* Volume column byteێ */
/*G*/	int effect_type;					/* Effect typeێ */
/*H*/	int effect_parameter;					/* Effect parameterێ */
/*I*/	int tone_porta;						/* Tone porta̖ڕWPeriod */
} XMCHANNEL;

/* XMCHANNEL.stat */
#define XMCHANNEL_SILENT	0
#define XMCHANNEL_NOTEON	1
#define XMCHANNEL_NOTEOFF	2

typedef struct _XMDRIVER {
	/***** ͕ύXȂtB[h *****/

	/* General header */
	int song_length;
	int restart_position;
	int number_of_channels;
	int number_of_patterns;
	int number_of_instruments;
	int flags;
	const unsigned char* pattern_order_table/*[song_length]*/;	/* Direct */
	/* Patterns */
	XMPATTERN* patterns/*[number_of_patterns]*/;			/* Allocate */
	/* Instruments */
	XMINSTRUMENT* instruments/*[number_of_instruments]*/;		/* Allocate */

	/***** tɐύXtB[h *****/

	XMCHANNEL* channels/*[number_of_channels]*/;	/* Allocate */
	int tempo;					/* Tempoݒl */
	int bpm;					/* BPMݒl */
	int row;					/* ݂Row */
	int order;					/* Pattern order tableʒu(CfNX) */
	XMPATTERN* pattern;				/* ݂Pattern */
	const unsigned char* packed_pattern_position;	/* ݂PatternPacked pattern dataʒu */
	int progress;					/* BPMispJE^ */
	int tick;					/* TempoispJE^ */

	int stat;					/* ʏ0Bt~ɗvi[B */
	int global_volume;				/* Global volumeݒl (0`64) */
	int position_jump;				/* ʏ-1BPosition jumporderݒB */
	int pattern_break;				/* ʏ-1BPattern breakrowݒB */
} XMDRIVER;

extern const short xm_linear_frequency_table[12 * 256];

int xm_init(XMDRIVER* driver, const void* data);
void xm_free(XMDRIVER* driver);
int xm_run(XMDRIVER* driver);
int xm_mix(XMDRIVER* driver, short wbuff[/*XMBUFLEN*/]);
int xm_stream_callback(short* wbuff, int param);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* XMt@C̍ĐJn܂B
 * [in]
 *	data		XMf[^̐擪AhXB
 * [out]
 *	߂l		ĐJnɐ0Ԃ܂B
 *			ĐJnɎs0ȊO̒lԂ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKxm_stop()ĂŁAxN^𕜌ĂB
 */
int xm_play(const void* data);

/* XMt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void xm_stop();

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_XM_H__*/
