/*	
 *	clipsp2.c
 *
 *	P/ECE SPC Driver V2
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Oct 07 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

#if !defined(PIECE) || !defined(SPC2_ASM)
SPC2CPU spc2cpu; /* P/ECȄꍇARAMɒu܂Bframsp2a.s */
#endif /*!defined(PIECE) || !defined(SPC2_ASM)*/
SPC2DSP spc2dsp;
SPC2DRV spc2drv;
unsigned char spc2ram[0x10000];	/* 0x0000`0xffff */
unsigned char spc2ext[64];	/* 0xffc0`0xffff̗RAM? */

/****************************************************************************
 *	SPC2HDR
 ****************************************************************************/

int
spc2hdr_test(const void* romp)
{
	SPC2HDR* hdr = (SPC2HDR*)romp;

	/* VOl`B(minor_ver͌܂) */
	//                         000000000011111111112222222222333
	//                         012345678901234567890123456789012
	if(memcmp(hdr->signature, "SNES-SPC700 Sound File Data v0.30", 27) != 0) return -1;
	//                                                   AA
	//                                                   ||
	//                    ܂Ō邱Ƃɂ܂ --++--ȍ~͌܂

	return 0;
}

/****************************************************************************
 *	SPC2DRV
 ****************************************************************************/

int
spc2drv_init(const void* romp)
{
	SPC2HDR* hdr = (SPC2HDR*)romp;
	SPC2DRV* drv = &spc2drv;
	unsigned char* ram = spc2ram;
	unsigned char* ext = spc2ext;
	//
	int i;

	/* ܂NA܂B */
	memset(drv, 0, sizeof(SPC2DRV));

	/* VOl`B */
	if(spc2hdr_test(hdr) != 0) return -1;

	/* C[Wǂݍ݁B */
	memcpy(ram, hdr->main_ram , 0x10000);	/* 0x0000`0xffff */
	memcpy(ext, hdr->extra_ram,      64);	/* 0xffc0`0xffff̗RAM? */
	ram[0xfd] = ram[0xfe] = ram[0xff] = 0;	/* ^C}JE^Zbg(WinSPCƂ̃g[Xrs߁B{͕sv(?)) */

	/* CPUB */
	spc2cpu_init(
		hdr->pc[0] | hdr->pc[1] << 8,
		hdr->a,
		hdr->x,
		hdr->y,
		hdr->psw,
		hdr->sp);

	/* DSPB
	 * 0x4c:KEY-ON͑̃WX^Ɉˑ邽߁AKEY-ONŌɐݒ肵܂B
	 */
	spc2dsp_init();
	for(i = 0; i < 0x80; i++) {
		if(i != 0x4c) { /* KEY-ONȊO */
			spc2dsp_write(i, hdr->dsp_regs[i]);
		}
	}
	spc2dsp_write(0x4c, hdr->dsp_regs[0x4c]); /* KEY-ON */

	return 0;
}

#if !defined(PIECE) || !defined(SPC2_ASM) || defined(SPC2_DEBUG) && defined(SPC2_TRACE)
int
spc2drv_read(int addr)
{
	unsigned char* ram = spc2ram;
	//
	int data;

#ifdef SPC2_DEBUG
	if(addr < 0xf0 || addr > 0xff) DIE();
#endif /*SPC2_DEBUG*/

	switch(addr) {
	///case 0xf0: /* Test */
	///case 0xf1: /* Control */
	///case 0xf2: /* Register Address */

	case 0xf3: /* Register Data */
		/* DSPWX^ǂݏoB */
		data = spc2dsp_read(ram[0xf2]);
		break;

	///case 0xf4: /* Port-0 */
	///case 0xf5: /* Port-1 */
	///case 0xf6: /* Port-2 */
	///case 0xf7: /* Port-3 */
	///case 0xf8: /* () */
	///case 0xf9: /* () */
	///case 0xfa: /* Timer-0 */
	///case 0xfb: /* Timer-1 */
	///case 0xfc: /* Timer-2 */

	case 0xfd: /* Counter-0 */
	case 0xfe: /* Counter-0 */
	case 0xff: /* Counter-0 */
		/* CounterǂݏoANAB */
		data = ram[addr];
		ram[addr] = 0;
		break;

	default:
		data = ram[addr];
		break;
	}

	return data;
}
#else /*!defined(PIECE) || !defined(SPC2_ASM) || defined(SPC2_DEBUG) && defined(SPC2_TRACE)*/
/*
 * * AZuł́Aӂ̎@ō}Ă܂B
 * - spc2drv_read{addr=0x00`0xff}͈̔͂łĂ΂ȂƂ𗘗pA
 *   0xfd`0xff͈̔̓`FbN̂A0xff̃`FbNȂ܂B
 * - ^C}JE^ǂݏo[ꍇAʃ[vƔfāAc^CXCX܂B
 *   ̓Iɂ́Aspc2cpu_run̖ߎs(%r3)[ɂ܂B
 *   framsp2a.sspc2cpu_runQƂĂB
 *   - ̎@́ACłspc2cpu_run(clipsp2c.c)ł͂ȂAAZułspc2cpu_run(framsp2a.s)
 *     NĂ邱ƂOł!!
 *     AZułspc2cpu_runŃAP/ECESPC2_ASM`Ă邱ƂłB
 *     ̏Ăꍇ̂݁Aspc2drv_read_asmg܂B
 *     ܂AfobOg[Xɖߎs񐔂ςƔrÂ炢̂ŁA
 *     SPC2_DEBUG,SPC2_TRACE`ĂƂ́Aʏłspc2drv_readgƂɂ܂qB
 *   - Ăяo%r3ύX̂ŁAmspc2cpu_runĂяoĂȂ΂܂B
 *     spc2cpu_runȊOĂ΂Ȃ悤A[`spc2dev_read_asmɕύX܂B
 */
asm("
	.code
	.align	1
	.global	spc2drv_read_asm
spc2drv_read_asm:
	xld.w %r11, spc2ram

	xcmp %r12, 0xf3			; if(addr == 0xf3) {
	xjrne spc2drv_read_asm_L10	;
	xld.ub %r12, [%r11+0xf2]	;   return spc2dsp_read(spc2ram[0xf2]);
	xjp spc2dsp_read		; }

spc2drv_read_asm_L10:
	add %r11, %r12			; data = spc2ram[addr]
	xld.ub %r10, [%r11]

	xcmp %r12, 0xfd			; if(addr >= 0xfd) {
	xjrlt spc2drv_read_asm_L20	;
	xld.b [%r11], %r8		;   spc2ram[addr] = 0
	xcmp %r10, 0			;   if(data == 0) {
	xjrne spc2drv_read_asm_L20	;
	xld.w %r3, 0			;     c^CXCX framsp2a.sspc2cpu_runQƁ
spc2drv_read_asm_L20:			;   }
	ret				; }
");
#endif /*!defined(PIECE) || !defined(SPC2_ASM) || defined(SPC2_DEBUG) && defined(SPC2_TRACE)*/

void
spc2drv_write(int addr, int data)
{
	unsigned char* ram = spc2ram;

#ifdef SPC2_DEBUG
	if(addr < 0xf0 || addr > 0xff) DIE();
	if(data <    0 || data > 0xff) DIE();
#endif /*SPC2_DEBUG*/

	switch(addr) {
	///case 0xf0: /* Test */

	case 0xf1: /* Control */
		/* TimertOi[B */
		ram[addr] = data;
		/* PortNAB */
		if(data & 0x10) ram[0xf4] = ram[0xf5] = 0;
		if(data & 0x20) ram[0xf6] = ram[0xf7] = 0;
		break;

	///case 0xf2: /* Register Address */
	case 0xf3: /* Register Data */
		/* DSPWX^݁B */
		spc2dsp_write(ram[0xf2], data);
		break;

	case 0xf4: /* Port-0 */
	case 0xf5: /* Port-1 */
	case 0xf6: /* Port-2 */
	case 0xf7: /* Port-3 */
		/* Port-0`3ւ݂̏́ATEhCPU烁CCPUւ̑Mf[^ɂȂ܂B
		 * CCPUTEhCPUւ̎Mf[^(Port-0`̓ǂݏo)ύXĂ͂܂!!
		 * Ȃ킿ASPCvC[ƂẮł͉Ȃ̂łB
		 * PɃf[^ł܂ƁAF-ZEROtł܂B
		 */
		break;

	///case 0xf8: /* () */
	///case 0xf9: /* () */
	///case 0xfa: /* Timer-0 */
	///case 0xfb: /* Timer-1 */
	///case 0xfc: /* Timer-2 */
	///case 0xfd: /* Counter-0 */
	///case 0xfe: /* Counter-0 */
	///case 0xff: /* Counter-0 */

	default:
		ram[addr] = data;
	}
}

void
spc2drv_mix(short wbuff[/*SPC2BUFLEN*/])
{
	SPC2DRV* drv = &spc2drv;
	unsigned char* ram = spc2ram;
	//
	int i;
	int j;
	int target;

	/* DSP~LVO64TvÂs܂B
	 * CPUs͒ᑬ^C}ɓčs܂B
	 * Ȃ킿 16[KHz:Mix]8[KHz:Timer]2[Tv] ԊułB
	 */
	for(i = 0; i < SPC2BUFLEN / 64; i++) {
		for(j = 0; j < 64 / 2; j++) {
			/* ^C}EJE^i߂܂B */
			/* Timer-0 (8KHz) */
			if(ram[0xf1] & (1 << 0)) {
				if(!(target = ram[0xfa])) target = 0x100;
				drv->timer[0] += 1; /* 8[KHz]8[KHz]1 */
				while(drv->timer[0] >= target) {
					drv->timer[0] -= target;
					if(ram[0xfd] < 0xf) ram[0xfd]++;
				}
			}
			/* Timer-1 (8KHz) */
			if(ram[0xf1] & (1 << 1)) {
				if(!(target = ram[0xfb])) target = 0x100;
				drv->timer[1] += 1; /* 8[KHz]8[KHz]1 */
				while(drv->timer[1] >= target) {
					drv->timer[1] -= target;
					if(ram[0xfe] < 0xf) ram[0xfe]++;
				}
			}
			/* Timer-2 (64KHz) */
			if(ram[0xf1] & (1 << 2)) {
				if(!(target = ram[0xfc])) target = 0x100;
				drv->timer[2] += 8; /* 64[KHz]8[KHz]8 */
				while(drv->timer[2] >= target) {
					drv->timer[2] -= target;
					if(ram[0xff] < 0xf) ram[0xff]++;
				}
			}

			/* CPUs܂B100xłCPUߎs񐔂͎̒ʂłB
			 *    2.048[MHz:CPU]4[Cycle/Inst,Avg]8[KHz] = US[Inst]
			 * P/ECEł͂ƂĂԂɍȂ̂ŁA_ENbNĂB
			 */
#ifndef SPC2CPU_RUN_COUNT
# ifdef PIECE
#  define SPC2CPU_RUN_COUNT 32 /* P/ECE =  50%x */
# else /*PIECE*/
#  define SPC2CPU_RUN_COUNT 64 /* Win32 = 100%x */
# endif /*PIECE*/
#endif /*SPC2CPU_RUN_COUNT*/
			spc2cpu_run(SPC2CPU_RUN_COUNT);
		}

		/* ~LVOs܂B */
		spc2dsp_mix(wbuff);
		wbuff += 64;
	}
}

int
spc2drv_stream_callback(short* wbuff, int param)
{
	spc2drv_mix(wbuff);

	return 0;
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

int
spc2_play(const void* romp)
{
	/* ܂mɒ~܂B */
	spc2_stop();

	/* hCo܂B */
	if(spc2drv_init(romp) != 0) return -1;

	/* Xg[ĐJn܂B */
#ifdef SPC2_TRACE
	/* CPUg[Xo͂sƁAFRAM4GA(0x0e00`0x1000)ł̓X^bNsɂȂ܂B
	 * fobOONCPUg[Xo͂sꍇ́AX^bN؂ւgȂƂɂ܂B
	 */
	stream_play(SPC2BUFLEN, spc2drv_stream_callback, 0, 0/*X^bN؊gȂ*/);
#else /*SPC2_TRACE*/
	stream_play(SPC2BUFLEN, spc2drv_stream_callback, 0, 1/*X^bN؊gp*/);
#endif /*SPC2_TRACE*/

	return 0;
}

void
spc2_stop()
{
	/* Xg[Đ~܂B */
	stream_stop();

	/* hCõN[Abv͕svłB */
}

int
spc2_inf(const void* romp, SPC2INF* inf)
{
	SPC2HDR* hdr = (SPC2HDR*)romp;
	//
	int i;
	int c;
	int mm;
	int dd;
	int yyyy;
	SPC2ID666TXT* txt;
	SPC2ID666BIN* bin;

	/* VOl`B */
	if(spc2hdr_test(hdr) != 0) return -1;

	/* t@C񂪗vĂȂ΁AXe[^X݂̂Ԃ܂B */
	if(!inf) return 0;

	/* ܂NA܂B */
	memset(inf, 0, sizeof(SPC2INF));

	/* ID666^OȂ΁AStB[hNÂ܂ܐԂ܂B */
	if(hdr->has_id666 != 26) return 0;

	/* ID666eLXg`oCi`ʂ܂B
	 * ̕@́ASSDLabo(http://www.ssdlabo.jp/)̃eLXg
	 * uSPC t@C ID666 dlv(http://www.ssdlabo.jp/win/spcplay/ID666.txt)
	 * QlɂĂ܂B肪Ƃ܂B
	 */
	if(((unsigned char*)hdr)[0xd2]) { /* eLXg` */
		txt = &hdr->id666.txt;
		strncpy(inf->song_title, txt->song_title, sizeof inf->song_title - 1);
		strncpy(inf->game_title, txt->game_title, sizeof inf->game_title - 1);
		strncpy(inf->dumper    , txt->dumper    , sizeof inf->dumper     - 1);
		strncpy(inf->comments  , txt->comments  , sizeof inf->comments   - 1);
		strncpy(inf->artist    , txt->artist    , sizeof inf->artist     - 1);
		strncpy(inf->date      , txt->date      , sizeof inf->date       - 1);
		for(i = 0; i < sizeof txt->play_time; i++) {
			c = txt->play_time[i];
			if(!isdigit(c)) break;
			inf->play_time = inf->play_time * 10 + (c - '0');
		}
		for(i = 0; i < sizeof txt->fade_time; i++) {
			c = txt->fade_time[i];
			if(!isdigit(c)) break;
			inf->fade_time = inf->fade_time * 10 + (c - '0');
		}
		if(txt->channel_disable) {
			//inf->channel_disable = txt->channel_disable - '0';
			// (0 or 1)  ('0'or'1') AdlsȂ̂Łc
			inf->channel_disable = txt->channel_disable & 1;
		}
		if(txt->emulator) {
			inf->emulator = txt->emulator - '0';
		}
	} else { /* oCi` */
		bin = &hdr->id666.bin;
		strncpy(inf->song_title, bin->song_title, sizeof inf->song_title - 1);
		strncpy(inf->game_title, bin->game_title, sizeof inf->game_title - 1);
		strncpy(inf->dumper    , bin->dumper    , sizeof inf->dumper     - 1);
		strncpy(inf->comments  , bin->comments  , sizeof inf->comments   - 1);
		strncpy(inf->artist    , bin->artist    , sizeof inf->artist     - 1);
		mm   = bin->date[1];
		dd   = bin->date[0];
		yyyy = bin->date[2] | bin->date[3] << 8;
		if(mm || dd || yyyy) {
			sprintf(inf->date, "%02d/%02d/%04d", mm % 100, dd % 100, yyyy % 10000);
		}
		for(i = 0; i < sizeof bin->play_time; i++) {
			c = bin->play_time[i];
			inf->play_time += c << (8 * i);
		}
		for(i = 0; i < sizeof bin->fade_time; i++) {
			c = bin->fade_time[i];
			inf->fade_time += c << (8 * i);
		}
		inf->channel_disable = bin->channel_disable;
		inf->emulator = bin->emulator;
	}

	return 0;
}
