/*	
 *	clipque.c
 *
 *	[eBeBFCӒpPbgL[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Tue Jan 06 21:26:41 JST 2015 Naoyuki Sawa
 *	- VK쐬B
 *	- u[eBeBFCӒpPbgL[vAclipmisc.*clipque.*֕܂B
 *	  gppxႢ̂ŁAʂɃNėeʂ鎖h߂łB
 */
#include "clip.h"

/*****************************************************************************
 *	[eBeBFCӒpPbgL[
 *****************************************************************************/

QUEUE*
create_queue(int capacity)
{
	QUEUE* queue;

	if(capacity < 0) {
		DIE();
	}

	/* pPbgTCYi[psizeof(int)ZāAۂ̃Xg[WTCYƂ܂B
	 * őŁAcapacityoCg̃pPbgAL[Ɋi[ł悤ɂ邽߂łB
	 */
	capacity += sizeof(int);

	/* wb_ƃXg[W̃mۂ܂B */
	queue = malloc(sizeof(QUEUE) + capacity);
	if(!queue) {
		DIE(); /* s */
	}

	/* wb_܂B */
	queue->capacity = capacity;
	queue->size = 0;

	return queue;
}

void
delete_queue(QUEUE* queue)
{
	/* wb_ƃXg[W̃J܂B */
	free(queue);
}

void
clear_queue(QUEUE* queue)
{
	queue->size = 0;
}

int
write_queue(QUEUE* queue, const void* packet/*[length]*/, int length)
{
	unsigned char* storage = (unsigned char*)(queue + 1);

	if(length < 0) {
		DIE();
	}

	/* pPbgTCYƃpPbgf[^ǉ󂫗eʂ邩H */
	if((int)(queue->size + (sizeof(int) + length)) > queue->capacity) {
		return -1;
	}

	/* L[̖ɃpPbgTCYƃpPbgf[^ǉ܂B */
	PUT_LEWORD(storage + queue->size, length);
	memcpy(storage + queue->size + sizeof(int), packet, length);
	queue->size += (sizeof(int) + length);

	return length;
}

int
read_queue(QUEUE* queue, void* packet/*[maxlength]*/, int maxlength)
{
	unsigned char* storage = (unsigned char*)(queue + 1);
	int length;

	if(maxlength < 0) {
		DIE();
	}

	/* L[łȂH */
	if(!queue->size) {
		return -1;
	}

	/* L[̐擪̃pPbgTCY擾܂B */
	if(queue->size < sizeof(int)) {
		DIE(); /* L[jH */
	}
	length = LEWORD(storage);
	if((length < 0) || ((int)(sizeof(int) + length) > queue->size)) {
		DIE(); /* L[jH */
	}

	/* w肳ꂽ̈Ɋi[ł邩H */
	if(length > maxlength) {
		return -1;
	}

	/* L[̐擪̃pPbgAw肳ꂽ̈ɃRs[܂B
	 * Apacket=NULLȂ΁AǂݏopPbgf[^j܂B
	 */
	if(packet) {
		memcpy(packet, storage + sizeof(int), length);
	}

	/* L[̐擪̃pPbg폜A̕AL[l߂܂B */
	queue->size -= (sizeof(int) + length);
	memmove(storage, storage + (sizeof(int) + length), queue->size);

	return length;
}

const void*
peek_queue(QUEUE* queue, int* _length)
{
	unsigned char* storage = (unsigned char*)(queue + 1);
	int length;

	/* L[󂩁H */
	if(!queue->size) {
		return NULL;
	}

	/* L[̐擪̃pPbgTCY擾܂B */
	if(queue->size < sizeof(int)) {
		DIE(); /* L[jH */
	}
	length = LEWORD(storage);
	if((length < 0) || ((int)(sizeof(int) + length) > queue->size)) {
		DIE(); /* L[jH */
	}

	/* pPbgTCYi[܂B */
	if(_length) {
		*_length = length;
	}

	/* pPbgf[^̐擪AhXԂ܂B */
	return storage + sizeof(int);
}

int
queue_space(QUEUE* queue)
{
	int space = queue->capacity - queue->size - sizeof(int);
	if(space < 0) {
		space = 0;
	}
	return space;
}
