/*	
 *	clipm68.h
 *
 *	P/ECE M6800 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Feb 01 06:23:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_M68_H__
#define __CLIP_M68_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *
 ****************************************************************************/

/* M6800_ASMV{`ǂݍ݂܂B
 * M6800_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipm68a.h"

/* ̃V{`ƁASĂ̖ߎsg[Xo͂܂B
 * ̃V{`Ȃ΁Aeߎs̓g[Xo͂܂B
 * SĂ̖ߎsg[XƂƂĂxȂ̂ŁAʏ͒`ȂłB
 * ȂÃV{`ĂAŜ̃g[XONwgTRACE_ON=1hȂ΁A
 * g[Xo͍͂s܂B
 */
//#define M6800_TRACE

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef M6800_ASM
#endif /*PIECE*/

/* AZuR[h͑S߃g[XɑΉĂȂ̂ŁA
 * AZuR[hgp͊mɑS߃g[XOFFɂ܂B
 */
#ifdef M6800_ASM
#undef M6800_TRACE
#endif /*M6800_ASM*/ 

#ifdef M6800_TRACE
#define M6800TRACE	TRACE
#else /*M6800_TRACE*/
#define M6800TRACE	1 ? ((void)0) : TRACE
#endif /*M6800_TRACE*/

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _M6800 M6800;

/*
 *	M6800RAO֐̌^`
 */
typedef unsigned char M6800READPROC (M6800* m6800, unsigned short addr);
typedef          void M6800WRITEPROC(M6800* m6800, unsigned short addr, unsigned char data);

/*
 *	M6800RA
 */
/*typedef*/ struct _M6800 {
	/*===== WX^ =====*/
	unsigned char cc;		/* + 0, 1 */
	unsigned char _resv1[1];	/* + 1, 1 */
	unsigned short d;		/* + 2, 2 */
	unsigned short x;		/* + 4, 2 */
	unsigned short s;		/* + 6, 2 */
	unsigned short pc;		/* + 8, 2 */
	/*=====  =====*/
	unsigned char pending;		/* +10, 1 */
	unsigned char wait;		/* +11, 1 */
	int cycle;			/* +12, 4 */
	/*===== O֐ =====*/
	M6800READPROC* read;		/* +16, 4 */
	M6800WRITEPROC* write;		/* +20, 4 */
} /*M6800*/;				/* =24    */

/* M6800.pending */
//#define M6800_RESET_PENDING	}XNs
//#define M6800_TRAP_PENDING	}XNs
//#define M6800_NMI_PENDING	}XNs
//#define M6800_SWI_PENDING	}XNs
#define M6800_IRQ1_PENDING	(1 << 0)	/*  */
#define M6800_ICI_PENDING	(1 << 1)	/*  */
#define M6800_OCI_PENDING	(1 << 2)	/* D */
#define M6800_TOI_PENDING	(1 << 3)	/*  */
#define M6800_CMI_PENDING	(1 << 4)	/* x */
#define M6800_IRQ2_PENDING	(1 << 5)	/*  */
#define M6800_SIO_PENDING	(1 << 6)	/*  */

/*
 *	ZbgE荞݃xN^
 */
#define M6800_RESET_VECTOR	0xfffe		/* #RES                                             */
#define M6800_NMI_VECTOR	0xfffc		/* #NMI                                             */
#define M6800_SWI_VECTOR	0xfffa		/* Software Interrupt                               */
#define M6800_IRQ1_VECTOR	0xfff8		/* #IRQ1                                            */
#define M6800_ICI_VECTOR	0xfff6		/* Timer 1 Input Capture  (M6801/03/HD6301/03 only) */
#define M6800_OCI_VECTOR	0xfff4		/* Timer 1 Output Capture (M6801/03/HD6301/03 only) */
#define M6800_TOI_VECTOR	0xfff2		/* Timer 1 Overflow       (M6801/03/HD6301/03 only) */
#define M6800_SIO_VECTOR	0xfff0		/* RDRF+ORFE+TDRE+PER     (M6801/03/HD6301/03 only) */
#define M6800_TRAP_VECTOR	0xffee		/* TRAP                            (HD6301/03 only) */
#define M6800_CMI_VECTOR	0xffec		/* Timer 2 Counter Match           (HD6301/03 only) */
#define M6800_IRQ2_VECTOR	0xffea		/* #IRQ2                           (HD6301/03 only) */

/*
 *	CXgNV֐錾
 */
typedef                  void M6800OPPROC (M6800* m6800, int code, int arg);
#define M6800FN_(OP, FN) void m6800op_##FN(M6800* m6800, int code, int arg);	/* 錾p */
#include "m6800/list.h" /* [m6800.xls]List */
M6800FN_("ERR_INHERENT", ERR_INHERENT)
#undef  M6800FN_
#define M6800FN_(    FN) void m6800op_##FN(M6800* m6800, int code, int arg)	/* `p */

/*
 *	IyR[h}bvECXgNVe[u
 */
typedef struct _M6800OP {
	M6800OPPROC* proc;	/* + 0, 4 */
	unsigned char addr;	/* + 4, 1 */
	unsigned char cycle;	/* + 5, 1 */
	unsigned short name;	/* + 6, 2 m6800_op_name_table[]̕ւ̃ItZbgł */
} M6800OP;			/* = 8    */
#define M6800OP_(CODE, MNEMONIC, ADDRMODE, FUNCTYPE, CYCLE, NAME)	{ m6800op_##MNEMONIC##_##FUNCTYPE, M6800_##ADDRMODE, CYCLE, 0x##NAME },
extern const M6800OP m6800_op_table[256/*opcode*/];
extern const char m6800_op_name_table[];	/* CXgNVe[u */

/***** M6800OP.addr *****/
/*==== operand bytes=0 ====*/
#define M6800_INHERENT		0
/*==== operand bytes=1 ====*/
#define M6800_IMMEDIATE1	1
#define M6800_DIRECT		2
#define M6800_INDEXED		3
#define M6800_RELATIVE		4
/*==== operand bytes=2 ====*/
#define M6800_IMMEDIATE2	5
#define M6800_EXTENDED		6

/****************************************************************************
 *	֐
 ****************************************************************************/

/* M6800Zbgɐݒ肳AM6800RÃCREAD/WRITE̊O֐łB
 * AvP[V璼ڌĂяoƂ͂܂B
 */
unsigned char m6800_internal_read (M6800* m6800, unsigned short addr);
         void m6800_internal_write(M6800* m6800, unsigned short addr, unsigned char data);

/* ۗĂ銄荞݂`FbNAs܂B
 *
 * eF
 * 1. 荞݂(CC(I)=0)Ă
 * 2. }XN\荞݂̂ꂩۗĂA
 * 3. ΂Dx̍荞݂sA
 * 4. s荞݂ۗ̕NA܂B
 *
 * gF
 * ̂ꂩ̏ɊYꍇɁAKĂяoĂB
 * 1. CC(I) 1:֎~0: ɕϊ\̂閽߂sB
 *    ̏ɊY閽߂́ÂƂłB
 *	ERTI	PULL(CC)܂ނ
 *	ECLI	CC(I)0ݒ肷邩B
 *	ETAP	CCA̒lRs[邩B
 * 2. 荞ݕۗrbgZbgB
 *    荞݂ĂAɊ荞݂sł邩łB
 *	Em6800_irq1()
 *	Em6800_ici()
 *	Em6800_oci()
 *	Em6800_toi()
 *	Em6800_sio()
 *	Em6800_cmi()
 *	Em6800_irq2()
 */
void m6800_check_pending(M6800* m6800);

/* 荞݂s܂B
 * m6800_nmi()֐ASWI߁Am6800_check_pending()֐痘p܂B
 */
void m6800_int(M6800* m6800, int vector);

/* 荞݂畜A܂B
 * RTI߂痘p܂B
 */
void m6800_rti(M6800* m6800);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* M6800Zbg܂B
 * [in]
 *	m6800		M6800\́B
 *	read		CREAD O֐ (NULL:RA֐gp)
 *	write		CWRITEO֐ (NULL:RA֐gp)
 * [note]
 *	* read,writeNULLw肷ƁARÅO֐gp܂B
 *	  RÅO֐́Â悤ȓs܂B
 *	  EREAD	M6800\̂̒64KB̃CzuĂƉ肵ACǂݍ݂܂B
 *	  EWRITE	M6800\̂̒64KB̃CzuĂƉ肵ACɏ݂܂B
 */
void m6800_reset(M6800* m6800, M6800READPROC* read, M6800WRITEPROC* write);

/* M6800s܂B
 * [in]
 *	m6800		M6800\́B
 *	cycle		sTCNB
 * [note]
 *	* sTCNcycleɒB邩A܂WAITԂɂȂ܂Ŏs܂B
 *	  O҂̏ꍇAۂ̎sTCŃAcycleȂ\܂B
 *	  ҂̏ꍇAۂ̎sTCŃAcycleȂȂ\܂B
 *	* ̊֐߂ƂAm6800->cycleɎcsTCNi[Ă܂B
 *	  Ⴆ cycle=100 ŌĂяoAۂɂ 105 TCNsꍇAm6800->cycle=-5 ƂȂ܂B
 */
void m6800_run(M6800* m6800, int cycle);

/* }XNs荞݃NGXg𔭍s܂B
 * [in]
 *	m6800		M6800\́B
 */
void m6800_nmi(M6800* m6800);

/* }XN\荞݃NGXg𔭍s܂B
 * [in]
 *	m6800		M6800\́B
 * [note]
 *	* 荞݂֎~ĂA荞݃NGXg͕ۗ܂B
 *	  荞݂ꂽƂɁA荞ݏs܂B
 */
void m6800_irq1(M6800* m6800);
void m6800_ici(M6800* m6800);	/* M6801/03/HD6301/03 only */
void m6800_oci(M6800* m6800);	/* M6801/03/HD6301/03 only */
void m6800_toi(M6800* m6800);	/* M6801/03/HD6301/03 only */
void m6800_sio(M6800* m6800);	/* M6801/03/HD6301/03 only */
void m6800_cmi(M6800* m6800);	/*          HD6301/03 only */
void m6800_irq2(M6800* m6800);	/*          HD6301/03 only */

/* WG[o͂ɁAWX^_vs܂B
 * [in]
 *	m6800		M6800\́B
 */
void m6800_dump(M6800* m6800);

#ifdef PIECE
/* M6800s܂B(X^bNؑցE)
 * [in]
 *	m6800		M6800\́B
 *	cycle		sTCNB
 * [note]
 *	* m6800_run()Ƃ̈Ⴂ́Å֐̎ŝ݁AX^bN0x0e00`0x1000̍RAMɐ؂芷邱ƂłB
 *	- 0x0e00`0x1000́AP/ECEJ[lIɍRAM[`]ĎgpGAłB
 *	  Ⴆ΁ApceLCDTrans()pceFileWriteSct()ÃGAɍRAM[`]܂B
 *	  IɎgp邽߁AAPIɂ0x0e00`0x1000j󂳂邱Ƃ𗯈ӂĂ΁A
 *	  AvP[VvÖ̗gƂ\łB
 *	- m6800_run()̎́Acallgp񐔂ɑ߁AX^bNRAMɈڂƂɂ͈Ӗ܂B
 *	  m6800_run2()̓X^bN0x1000ɈڂAm6800_run()ĂяoAX^bNɖ߂ďԂ܂B
 *	- X^bNGA0x0e00`0x1000512oCgȂ̂ŁAm6800_run2()̎gpɂ͏܂B
 *	  Em6800_run()ƂĂ΂閽ߏ֐́A傫ȃX^bNt[mۂĂ͂܂B
 *	    eߏ̎ύXꍇ́AӂĂB
 *	  Em6800_run()Ă΂O֐(READ/WRITE)ł́A傫ȃX^bNt[mۂĂ͂܂B
 *	  EX^bN悤Ȋ荞݃[`Ƃ̕p͕słB
 *	    X^bN0x0e00`0x1000ɐ؂ւĂƂɊ荞݂ƁAX^bNӂ鋰ꂪ邩łB
 *	  Em6800_run2()荞݃[`ŌĂяoĂ͂܂B
 *	    OʂŁApceLCDTrans()0x0e00`0x1000GAgpł\邩łB
 *	- ȏ̂悤Ȑ񂪂̂ŁAm6800_run2()̎gpɂ͏[ȒӂKvłB
 *	  m6800_run()gꍇɊrׂāAm6800_run2()gꍇ̌ʂ́A20%̍ƂȂ܂B
 */
void m6800_run2(M6800* m6800, int cycle);
#endif /*PIECE*/

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_M68_H__*/
