/*	
 *	clipdms2.h
 *
 *	P/ECE DMG-Sound Emulator ()
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Mon Feb 28 20:00:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_DMS2_H__
#define __CLIP_DMS2_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *
 ****************************************************************************/

#define DMGSOUND2BUFLEN 320 /* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

#define DMGSOUND2_CLOCK (1<<22) /* = 4.19[MHz] (GameBoy}X^[NbN) */

/* Ch1,2: `g */
typedef struct _DMGSOUND2SQUARE {
	/*** Length ***/
	int sound_length;		// + 0,4: c蔭Ԃ(1/256[sec])PʂŎ܂B
					//          -1Ȃ΁AIɒ~܂Ŕ𑱂܂B
					//           0Ȃ΁A~ł邱Ƃ܂B

	/*** Envelope ***/
	unsigned char envelope_time;	// + 4,1: Gx[vsԊu(1/256[sec])PʂŎ܂B
					//          0Ȃ΁AGx[vs܂B
	unsigned char envelope_type;	// + 5,1: Gx[v܂B
					//          0Ȃ΁Aʂ܂B(Ȃ)
					//          1Ȃ΁Aʂ𑝉܂B(傫Ȃ)
	unsigned char envelope_volume;	// + 6,1: ݂̃Gx[vʂ܂B(0..15)
					//          0ŏA15ōő剹ʂƂȂ܂B
	unsigned char envelope_count;	// + 7,1: Gx[vs܂ł̃_EJE^łB

	/*** Sweep (Ch1̂) ***/
	unsigned char sweep_time;	// + 8,1: XC[vsԊu(1/256[sec])PʂŎ܂B
					//          0Ȃ΁AXC[vs܂B
					//          Ch2̓XC[v@\̂ŁA0ŒƂ܂B
	unsigned char sweep_type;	// + 9,1: XC[v܂B
					//          0Ȃ΁Ag𑝉܂B(Ȃ)
					//          1Ȃ΁Ag܂B(ႭȂ)
	unsigned char sweep_shift;	// +10,1: gωʂ̃Vtg܂B
					//          XC[vs邱ƂɂgώA̒ʂłB
					//          frequency(t) = frequency(t-1) } frequency(t-1)>>sweep_shift
	unsigned char sweep_count;	// +11,1: XC[vs܂ł̃_EJE^łB

	/*** Wave ***/
	unsigned char wave_duty;	// +12,1: `g̃f[eB܂B
					//                    01234567
					//          1: 12.5% (_-------)
					//          2: 25  % (__------)
					//          4: 50  % (____----)
					//          6: 75  % (______--)
	unsigned char wave_index;	// +13,1: g`TvPʂ̐isJE^łB(0..7)
					//          (wave_indexwave_duty)Ȃ΁A(-envelope_volume)o͂܂B
					//          (wave_indexwave_duty)Ȃ΁A(+envelope_volume)o͂܂B
	short wave_frequency;		// +14,2: g܂B(0x000..0x7ff)
					//          `g1g`Pʂ̍ĐǵA
					//            Frequency = 4194304/(32*(2048-x))[Hz] (dl)
					//          `g1g`̃TCNA}X^[NbN̔{ŕ\ƁA
					//            Period    = (2048-x)*32
					//          `g1g`8TvƌȂƁA1TṽTCŃA
					//            Period    = (2048-x)*32/8
					//                      = (2048-x)*4
	int wave_count;			// +16,4: }X^[NbNPʂ̐isJE^łB

	/*** Speaker ***/
	unsigned char speaker_volume;	// +20,1: o͐Xs[J[(AEA܂͗)̍v{[ (0..14)
} DMGSOUND2SQUARE;

/* Ch3: g` */
typedef struct _DMGSOUND2WAVE {
	/*** Length ***/
	int sound_length;		// + 0,4: c蔭Ԃ(1/256[sec])PʂŎ܂B
					//          -1Ȃ΁AIɒ~܂Ŕ𑱂܂B
					//           0Ȃ΁A~ł邱Ƃ܂B

	/*** Wave ***/
	unsigned char wave_shift;	// + 4,1: g`f[^̏o̓x܂B
					//          0: 
					//          1: ̂܂܏o
					//          2: 1bitEVtgďo
					//          3: 2bitEVtgďo
	unsigned char wave_index;	// + 5,1: g`TvPʂ̐isJE^łB(0..31)
					//          (wave_pattern[wave_index]>>(wave_shift-1))o͂܂B
	short wave_frequency;		// + 6,2: g܂B(0x000..0x7ff)
					//          `p^[1g`Pʂ̍ĐǵA
					//            Frequency = 4194304/(64*(2048-x))[Hz] (dl)
					//          g`p^[1g`̃TCNA}X^[NbN̔{ŕ\ƁA
					//            Period    = (2048-x)*64
					//          g`p^[1g`32TvƌȂƁA1TṽTCŃA
					//            Period    = (2048-x)*64/32
					//                      = (2048-x)*2
	int wave_count;			// + 8,4: }X^[NbNPʂ̐isJE^łB

	/*** Speaker ***/
	unsigned char speaker_volume;	// +12,1: o͐Xs[J[(AEA܂͗)̍v{[ (0..14)
} DMGSOUND2WAVE;

/* Ch4: mCY */
typedef struct _DMGSOUND2NOISE {
	/*** Length ***/
	int sound_length;		// + 0,4: c蔭Ԃ(1/256[sec])PʂŎ܂B
					//          -1Ȃ΁AIɒ~܂Ŕ𑱂܂B
					//           0Ȃ΁A~ł邱Ƃ܂B

	/*** Envelope ***/
	unsigned char envelope_time;	// + 4,1: Gx[vsԊu(1/256[sec])PʂŎ܂B
					//          0Ȃ΁AGx[vs܂B
	unsigned char envelope_type;	// + 5,1: Gx[v܂B
					//          0Ȃ΁Aʂ܂B(Ȃ)
					//          1Ȃ΁Aʂ𑝉܂B(傫Ȃ)
	unsigned char envelope_volume;	// + 6,1: ݂̃Gx[vʂ܂B(0..15)
					//          0ŏA15ōő剹ʂƂȂ܂B
	unsigned char envelope_count;	// + 7,1: Gx[vs܂ł̃_EJE^łB

	/*** LFSR ***/
	unsigned char lfsr_type;	// + 8,1: 1 = 15 steps (long mode), 6 = 7 steps (short mode)
					//          dl킩Ȃ̂ŁAt@~RAPU݊ŎĂ݂܂B
					// + 9,1: (pfBO)
	unsigned short lfsr;		// +10,2: LFSR (Linear Feedback Shift Register)
	int lfsr_frequency;		// +12,4: }X^[NbNTCNPʂLFSRVtg܂B
					//          {1,2,4,6,8,10,12,14}<<{3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18}
	int lfsr_count;			// +16,4: }X^[NbNPʂ̐isJE^łB

	/*** Speaker ***/
	unsigned char speaker_volume;	// +20,1: o͐Xs[J[(AEA܂͗)̍v{[ (0..14)
} DMGSOUND2NOISE;

typedef struct _DMGSOUND2 {
	short conv_250_256;	/* 16000/64=250256[Hz]ϊp */

	/*** Registers ***/
	unsigned char nr10;	/* $FF10 (NR10) */
	unsigned char nr11;	/* $FF11 (NR11) */
	unsigned char nr12;	/* $FF12 (NR12) */
	unsigned char nr13;	/* $FF13 (NR13) */
	unsigned char nr14;	/* $FF14 (NR14) */
	unsigned char nr21;	/* $FF16 (NR21) */
	unsigned char nr22;	/* $FF17 (NR22) */
	unsigned char nr23;	/* $FF18 (NR23) */
	unsigned char nr24;	/* $FF19 (NR24) */
	unsigned char nr30;	/* $FF1A (NR30) */
	unsigned char nr31;	/* $FF1B (NR31) */
	unsigned char nr32;	/* $FF1C (NR32) */
	unsigned char nr33;	/* $FF1D (NR33) */
	unsigned char nr34;	/* $FF1E (NR34) */
	unsigned char nr41;	/* $FF20 (NR41) */
	unsigned char nr42;	/* $FF21 (NR42) */
	unsigned char nr43;	/* $FF22 (NR43) */
	unsigned char nr44;	/* $FF23 (NR44) */
	unsigned char nr50;	/* $FF24 (NR50) */
	unsigned char nr51;	/* $FF25 (NR51) */
	unsigned char nr52;	/* $FF26 (NR52) */

	/*** Channels ***/
	DMGSOUND2SQUARE ch1;	/* Ch1: `g (SweepL) */
	DMGSOUND2SQUARE ch2;	/* Ch2: `g (Sweep) */
	DMGSOUND2WAVE   ch3;	/* Ch3: g` */
	DMGSOUND2NOISE  ch4;	/* Ch4: mCY */
} DMGSOUND2;

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

extern DMGSOUND2 dmgsound2;

/* $FF30-$FF3F (Wave Pattern RAM)
 * - 炩ߏ4bitA4bit̏ɓWJAe4bitTv
 *   (0..15)-[x2]->(0..30)-[-15]->(-15..+15) ɕϊĂ܂B
 */
extern char dmgsound2_wave_pattern[32];

/****************************************************************************
 *	֐
 ****************************************************************************/

void dmgsound2_square_frame(DMGSOUND2SQUARE* ch);
void dmgsound2_wave_frame  (DMGSOUND2WAVE  * ch);
void dmgsound2_noise_frame (DMGSOUND2NOISE * ch);
void dmgsound2_square_mix  (DMGSOUND2SQUARE* ch, short wbuff[/*64*/]);
void dmgsound2_wave_mix    (DMGSOUND2WAVE  * ch, short wbuff[/*64*/]);
void dmgsound2_noise_mix   (DMGSOUND2NOISE * ch, short wbuff[/*64*/]);
void dmgsound2_volume_shift(short wbuff[/*DMGSOUND2BUFLEN*/]);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* DMG-SoundRAZbg܂B
 */
void dmgsound2_reset();

/* DMG-Sound̃WX^ǂݏo܂B
 * [in]
 *	addr		WX^AhXB($FF10..$FF3F)
 * [out]
 *	߂l		ǂݏof[^B
 */
int dmgsound2_read(int addr);

/* DMG-Sound̃WX^֏݂܂B
 * [in]
 *	addr		WX^AhXB($FF10..$FF3F)
 *	data		ރf[^B
 */
void dmgsound2_write(int addr, int data);

/* o̓TvO[g=SPEAKER_OUTPUT[Hz]ŁADMGSOUND2BUFLENTṽ~LVOs܂B
 * [in]
 *	wbuff		o̓Tvobt@B
 */
void dmgsound2_mix(short wbuff[/*DMGSOUND2BUFLEN*/]);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_DMS2_H__*/
