/*
 *	fram.c
 *
 *	Chain Reaction
 *
 *	* Fri Jan 06 21:25:10 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/****************************************************************************
 *	Cell_GetNeighborCount
 ****************************************************************************/
int Cell_GetNeighborCount(int Col, int Row) {
	int NeighborCount = 0;
	if(Col >               0) { NeighborCount++; }	//ׂL΁c
	if(Col < stGame.Cols - 1) { NeighborCount++; }	//EׂL΁c
	if(Row >               0) { NeighborCount++; }	//ׂL΁c
	if(Row < stGame.Rows - 1) { NeighborCount++; }	//ׂL΁c
	return NeighborCount;
}
/****************************************************************************
 *	Field_TestPutCell
 ****************************************************************************/
//זEu邩ÁAp[𑝂₹邩B
int Field_TestPutCell(ST_Field* pField, int Col, int Row, int Color) {
	ST_Cell* pCell;
	if((unsigned)Col >= stGame.Cols) { DIE(); }	//oO
	if((unsigned)Row >= stGame.Rows) { DIE(); }	//oO
	if((Color < 1) || (Color > 2)) { DIE(); }	//oO
	pCell = &pField->TBL_Cell[Row][Col];
	return !pCell->Color || (pCell->Color == stGame.Turn);
}
/****************************************************************************
 *	AiField_TestPutCell
 ****************************************************************************/
//AȈꍇ́Â߂ɁAׂɕǂזEʒu͑ΏۊOɂB
int AiField_TestPutCell(ST_Field* pField, int Col, int Row, int Color) {
	ST_Cell* pCell;
	if((unsigned)Col >= stGame.Cols) { DIE(); }	//oO
	if((unsigned)Row >= stGame.Rows) { DIE(); }	//oO
	if((Color < 1) || (Color > 2)) { DIE(); }	//oO
	pCell = &pField->TBL_Cell[Row][Col];
	if(pCell->Color && (pCell->Color != stGame.Turn)) { return 0; }
	//܂łField_TestPutCell()Ɠf@łB
	//̃ZזEȂokB
	if(pCell->Color) { return 1; }
	//ׂǂזEȂokB
	if(Col == 0) { return 1; }
	if(pField->TBL_Cell[Row][Col - 1].Color) { return 1; }
	//EׂǂזEȂokB
	if(Col == stGame.Cols - 1) { return 1; }
	if(pField->TBL_Cell[Row][Col + 1].Color) { return 1; }
	//ׂǂזEȂokB
	if(Row == 0) { return 1; }
	if(pField->TBL_Cell[Row - 1][Col].Color) { return 1; }
	//ׂǂזEȂokB
	if(Row == stGame.Rows - 1) { return 1; }
	if(pField->TBL_Cell[Row + 1][Col].Color) { return 1; }
	//㉺EZȂNGB
	return 0;
}
/****************************************************************************
 *	Field_PutCell
 ****************************************************************************/
//זEuÁAp[𑝂₷B
void Field_PutCell(ST_Field* pField, int Col, int Row, int Color) {
	ST_Cell* pCell;
	if((unsigned)Col >= stGame.Cols) { DIE(); }	//oO
	if((unsigned)Row >= stGame.Rows) { DIE(); }	//oO
	if((Color < 1) || (Color > 2)) { DIE(); }	//oO
	pCell = &pField->TBL_Cell[Row][Col];
	if(pCell->Color && (pCell->Color != stGame.Turn)) { DIE(); }	//oO
	pCell->Color = stGame.Turn;
	pCell->Power++;
}
/****************************************************************************
 *	Field_CellDivision
 ****************************************************************************/
//pFieldSrcQƂāAp[ՊEɒBזE𕪗􂵁AʂpFieldDstɊi[B
//􂵂זE̐ԂB
//֐́A(őł)iK̕AAȂB
//֐0ȊO̒lԂꍇ́AA\L̂ŁAēxA֐ĂяoB
int Field_CellDivision(const ST_Field* pFieldSrc, ST_Field* pFieldDst) {
	int Divided = 0;	//􂵂זE̐
	int Col, Row, Power, NeighborCount;
	const ST_Cell* pCellSrc;
	      ST_Cell* pCellDst;
	//ω̃tB[hɁAωÕtB[hRs[ĂB
	memcpy(pFieldDst, pFieldSrc, sizeof(ST_Field));
	//eZɂāc
	for(Row = 0; Row < stGame.Rows; Row++) {
		for(Col = 0; Col < stGame.Cols; Col++) {
			pCellSrc = &pFieldSrc->TBL_Cell[Row][Col];
			Power = pCellSrc->Power;	//'pCellDst->Power'ł͂Ȃɒ!!̔f͕ωO̍זẼp[čsB
			NeighborCount = Cell_GetNeighborCount(Col, Row);
			//̈ʒu̍זE􂷂Ȃ΁c
			if(Power >= NeighborCount) {
				//ׂL΁c
				if(Col > 0) {
					pCellDst = &pFieldDst->TBL_Cell[Row][Col - 1];
					pCellDst->Color = pCellSrc->Color;	//VK,,F̃p[,,G̐Făp[
					pCellDst->Power++;
				}
				//EׂL΁c
				if(Col < stGame.Cols - 1) {
					pCellDst = &pFieldDst->TBL_Cell[Row][Col + 1];
					pCellDst->Color = pCellSrc->Color;	//VK,,F̃p[,,G̐Făp[
					pCellDst->Power++;
				}
				//ׂL΁c
				if(Row > 0) {
					pCellDst = &pFieldDst->TBL_Cell[Row - 1][Col];
					pCellDst->Color = pCellSrc->Color;	//VK,,F̃p[,,G̐Făp[
					pCellDst->Power++;
				}
				//ׂL΁c
				if(Row < stGame.Rows - 1) {
					pCellDst = &pFieldDst->TBL_Cell[Row + 1][Col];
					pCellDst->Color = pCellSrc->Color;	//VK,,F̃p[,,G̐Făp[
					pCellDst->Power++;
				}
				//􂵂Äʒu̍זẼp[炷B
				pCellDst = &pFieldDst->TBL_Cell[Row][Col];
				pCellDst->Power -= NeighborCount;	//'pCellDst->Power=Power-NeighborCount'ł͂Ȃɒ!!ω̃tB[ĥ̈ʒũZ̃p[́Aɗׂ̃Z̕ɂđĂ\L邩B
				//̈ʒũp[0ɂȂÄʒu̍זEB
				if(!pCellDst->Power) { pCellDst->Color = 0; }
				//􂵂זE̐𑝂₷B
				Divided++;
			}
		}
	}
	//􂵂זE̐ԂB
	return Divided;
}
/****************************************************************************
 *	Field_GetWinnerColor
 ****************************************************************************/
//Ֆʂ̏ԂAF(1=,,2=)ԂB
//ǂĂȂ΁A0ԂB
int Field_GetWinnerColor(const ST_Field* pField) {
	int Color = 0;		//ǂ炩̐FŏɏoA̕ϐɊi[B
	int WinnerColor = 0;	//FȏoA̕ϐɊi[B
	int Col, Row;
	const ST_Cell* pCell;
	//eZɂāc
	for(Row = 0; Row < stGame.Rows; Row++) {
		for(Col = 0; Col < stGame.Cols; Col++) {
			pCell = &pField->TBL_Cell[Row][Col];
			//זEL΁c
			if(pCell->Color) {
				//ŏȂ΁c
				if(!Color) {
					//ŏɏoזE̐Fi[B
					Color = pCell->Color;
				//ŏłȂ΁c
				} else {
					//قȂזE̐FoAǂĂȂB
					if(Color != pCell->Color) { return 0; }
					//ȏoזE̐Fi[B
					WinnerColor = Color;
				}
			}
		}
	}
	//ȏoזE̐F,,0ԂB
	return WinnerColor;
}
