/*
 *	app.c
 *
 *	Chain Reaction
 *
 *	* Fri Jan 06 21:25:10 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef USE_SOUND
const void* sound_table[SOUND_COUNT];
#endif /*USE_SOUND*/

#ifdef USE_TEXTURE
TEXTURE texture_table[TEXTURE_COUNT];
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
#define SPRITE_ SPRITE_INIT2
const SPRITE sprite_table[SPRITE_COUNT] = {
#include "sprite.h"
};
#undef SPRITE_
#endif /*USE_SPRITE*/

/****************************************************************************
 *	main
 ****************************************************************************/

int main() {
#ifdef  USE_ARGS
	static char cmdline[128] = PRESCAN_STRINGIFY(PROJECT);	//ur.exevɃR}hCw肵ꍇA܂B
	char** const argv = strsplit(cmdline, " ", 0);
	int    const argc = strv_length(argv);
#else //USE_ARGS
	char** const argv = (char*[]){ PRESCAN_STRINGIFY(PROJECT), NULL };
	int    const argc = 1;
#endif//USE_ARGS
	/* ĂяovŐNɎgpꂽOݒ肵܂B */
	program_invocation_short_name = basename((program_invocation_name = argv[0]));
	/* ߑȂO߂邽߂́AOt[܂B */
	SEH_init();
	/* AvP[V܂B */
	app_init(argc, argv);
	/* C[vs܂B */
	return app_main(argc, argv);
}

/****************************************************************************
 *	app_init
 ****************************************************************************/

#ifdef  USE_SOUND_MANAGER
static void sound_play_stub(int iCh, int iData, int iLoop) {
	if((unsigned)iData >= SOUND_COUNT) { DIE(); }
	sound_play(iCh, sound_table[iData], iLoop);
}
#endif/*USE_SOUND_MANAGER*/

#ifdef  USE_SOUND_MIXER
static const uint8_t TBL_TapMxrChMask[(TapLogCh_Max+1)]={
BIN8(00000111),	//_0ɓKpзقޯϽ	ðBGM
BIN8(00000110),	//_1ɓKpзقޯϽ	oBGM
BIN8(00000110),	//_2ɓKpзقޯϽ	oSE
BIN8(00000110),	//_3ɓKpзقޯϽ	oSE
BIN8(00000110),	//_4ɓKpзقޯϽ	oSE
BIN8(00000110),	//_5ɓKpзقޯϽ	UI
BIN8(00000110),	//_6ɓKpзقޯϽ	UI
BIN8(00000100)};//_7ɓKpзقޯϽ	װ
//        ||+--- TAPз1:oBGMĐ	Ώۘ_:ðBGM
//        |+---- TAPз2:װĐ	Ώۘ_:װȊO
//        +----- TAPз0:İ		Ώۘ_:S
static void set_att(int iLogCh, ST_TapLogCh* pLogCh) {	//̘_ق̌ʂƤ̘_قɓKpзق̍vʂ𤂱̘_ق䂵Ă޲قɓKp	(pLogCh->iDevCh==UINT8_MAX)̎ɌĂяoĂ͂Ȃ
	int iAtt=pLogCh->iAtt;					//̘_ق̌				//2حё
	iAtt+=TapMxr_GetAtt(pTapMxr,&TBL_TapMxrChMask[iLogCh]);	//̘_قɓKpзق̍v	//1حё
	sound_att(pLogCh->iDevCh,iAtt);				//̘_ق䂵Ă޲قɤL2_̍vʂKp
}
static void TapMxr_TimerProc(void* iTime) {	//TAPзpϊ
	int iDevCh,iLogCh;
	if(TapSeq_GetLogCh(pTapSeq,TapLogCh_Bg2)->iPhr!=UINT16_MAX){TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Stg,64, 0,  0);}	//_1ŉoBGMĐȂΤðBGM𑦏		
	else                                                       {TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Stg, 0,64,500);}	//_1ŉoBGM~ȂΤðBGM0.5bŕA		{{TODO:عݒ}}
	if(TapSeq_GetLogCh(pTapSeq,TapLogCh_Err)->iPhr!=UINT16_MAX){TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Err,64, 0,  0);}	//_7ŴװĐȂΤðBGM,oBGM,SE𑦏	
	else                                                       {TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Err, 0, 0,  0);}	//_7Ŵװ~ȂΤðBGM,oBGM,SE𑦕A	
	TapMxr_Exec(pTapMxr,(int)iTime);	//TAPзs
	for(iDevCh=0;iDevCh<pTapSeq->pInfo->nDevCh;iDevCh++){	//޲ق̌ʂݒ肷
		iLogCh=TapSeq_GetDevCh(pTapSeq,iDevCh)->iLogCh;
		if(iLogCh!=UINT8_MAX){		//޲ق𐧌䂵Ă_قL΁c
			ST_TapLogCh* pLogCh=TapSeq_GetLogCh(pTapSeq,iLogCh);
			set_att(iLogCh,pLogCh);	//̘_ق̌ʂƤ̘_قɓKpзق̍vʂ޲قɓKp
		}
	}
}
#endif/*USE_SOUND_MIXER*/

#ifdef  USE_SOUND_SEQUENCER
static void TapSeq_fnPlay(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	set_att(iLogCh,pLogCh);
	sound_play(pLogCh->iDevCh,sound_table[pLogCh->iPhr],pLogCh->iLoop?pLogCh->iLoop:-1);
}
static void TapSeq_fnStop(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	sound_stop(pLogCh->iDevCh);
}
static void TapSeq_fnLoop(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	/** no job **/
}
static void TapSeq_fnEnd(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	/** no job **/
}
static void TapSeq_fnNext(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	set_att(iLogCh,pLogCh);
	sound_play(pLogCh->iDevCh,sound_table[pLogCh->iPhr],pLogCh->iLoop?pLogCh->iLoop:-1);
}
static void TapSeq_fnCtrl(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	set_att(iLogCh,pLogCh);
}
static int TapSeq_fnGetPhrTime(ST_TapSeq* pTapSeq, int iPhr) {
	return ppd_playback_time(sound_table[iPhr]);
}
static int TapSeq_fnGetPhrNext(ST_TapSeq* pTapSeq, int iPhr) {
#ifdef  USE_REG
    #ifdef  RegKey_Next
	//t[YV[PXWXg擾ꍇB
	iPhr++;			//sound.h0x[X,t[YV[PX1x[XȂ̂ŁAꎞI1x[XɕϊBڍׂ́A/clip/tool/dPhrDefC/winapp.c QƂB
	iPhr = REG_get_value_l(TBL_RegTbl,RegKey_PhrDef,iPhr,RegKey_Next,-1)<<8>>8;	//ʏt[Y(-1),ԃt[Y(<>iPhr),[vt[Y(=iPhr),St[Y(-2)
	if(iPhr>=0){iPhr--;}	//ʏt[Y(-1),,St[Y(-2)ȊOȂ΁Asound.h̒l(=0x[X)ɖ߂B
	return iPhr;
    #else //RegKey_Next
	//t[YV[PXWXg擾邪ASĒʏt[Yłꍇ'RegKey_Next'`ȂB
	return -1;
    #endif//RegKey_Next
#else /*USE_REG*/
	//t[YV[PXvOŏꍇB
	return (iPhr==SND_BGM_1G)||(iPhr==SND_BGM_ST)?iPhr:-1;
#endif/*USE_REG*/
}
static void TapSeq_TimerProc(void* iTime) {
	TapSeq_Exec(pTapSeq,(int)iTime);
}
#endif/*USE_SOUND_SEQUENCER*/

#ifdef  USE_EVENT_TIMER
static void EvtTmr_onEvent(int iEvtTmrCh, int iEvent) { //ϗpď֐
	TRACE("%d:%d:%d\n", now/FPS, iEvtTmrCh, iEvent);
}
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_LOG_BUFFER
static int LogBuf_fnDraw(int x, int y, const char* Str) { //عݒ`̕`֐
	render_reduced_string(&render, x, y, Str, 3);
	return 10;
}
#endif/*USE_LOG_BUFFER*/

#ifdef  USE_NVLOG
void nvlog_(const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	nvlog_vprintf(nvlog, fmt, ap);
	va_end(ap);
	pceFileWriteSct(&faNvLog, nvlog, 0, NVLOG_SIZE);
}
#endif//USE_NVLOG

#ifdef  USE_TCL
//srand seed
static int Tcl_SrandCmd(Tcl_Interp* iPtr) {
	if((iPtr->argc < 1) || (iPtr->argc > 2)) { DIE(); }
	srand((iPtr->argc == 2) ? atoi(iPtr->argv[1]) : time(NULL));
	return TCL_OK;
}
//rand
static int Tcl_RandCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { DIE(); }
	iPtr->result = strdup_printf("%d", rand());
	return TCL_OK;
}
//log string
static int Tcl_LogCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 2) { DIE(); }
#ifdef  USE_LOG_BUFFER
	LogBuf_Print(pLogBuf, iPtr->argv[1]);
	update();
#else //USE_LOG_BUFFER
	TRACE("%s\n", iPtr->argv[1]);
#endif//USE_LOG_BUFFER
	return TCL_OK;
}
//schedule
static int Tcl_ScheduleCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { DIE(); }
	schedule();
	return TCL_OK;
}
#endif//USE_TCL

void app_init(int argc, char* argv[]) {
#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈ݒ肵܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_init();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND

	/* ʓIȏB */
	pceAppSetProcPeriod(1000 / FPS);
#ifdef V_SCREEN
	pceLCDSetBuffer(_def_vbuff);
#else /*V_SCREEN*/
	pceLCDSetBuffer(vbuff);
#endif /*V_SCREEN*/
//sv	pceLCDDispStart();	//{{2014/12/31폜:cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B}}
#ifdef USE_REPEAT
	pad_set_repeat(REPEAT_PAD, REPEAT_DELAY, REPEAT_INTERVAL);
#endif /*USE_REPEAT*/

	/* `B */
	surface.w = DISP_X;
	surface.h = DISP_Y;
	surface.vbuff = vbuff;
#ifdef USE_3D
	surface.zbuff = zbuff;
	render_init_3d(&render, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#else /*USE_3D*/
	render_init_2d(&render, &surface, 0, 0, 0, 0);
#endif /*USE_3D*/
#ifdef USE_RENDF
	surface.zbuff = zbuff;
	rendf_init(&rendf, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#endif /*USE_RENDF*/

#if defined(TRACE_ON) && (TRACE_ON)
	/* WG[o͂J܂B */
	stderr_open(9/*WG[o̓j^ڑ҂()*/);
#endif /*TRACE_ON*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VJn܂B */
	ufe_setup(9/*PCt@CT[oڑ҂()*/);
#endif /*USE_UFE*/

#ifdef USE_RESOURCE
	/* pext@CYt\[X擾܂B */
	resource = resource_address(PRESCAN_STRINGIFY(PROJECT) ".pex");
#endif /*USE_RESOURCE*/

#ifdef TURBO
	/* NbNEEFCgؑւ܂B */
	turbo(TURBO);
#endif /*TURBO*/

#ifdef USE_DBG
	/* DBGjbgݒ肵܂B */
	dbg_init();
#endif /*USE_DBG*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_init(GC_LEVEL);
#endif /*GC_LEVEL*/

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Init(BITMAP_GC_UNIT);
#endif /*BITMAP_GC_UNIT*/

#ifdef  USE_PCL
	/* R[`܂B */
	co_thread_init();
#endif//USE_PCL

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_init(LDIRECT_INTERVAL);
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_VQTC
	/* VQkeNX``܂B */
	VqTc_InitDrawing();
#endif /*USE_VQTC*/

#ifdef USE_MUSIC
	/* yCu܂B */
	InitMusic();
#if defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)
	/* - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderƁAyCu𕹗pꍇ́AyCu̎gp`l炷Ƃɂ܂B
	 *   ̑΍sȂƁA`l0gp悤ƂāAnOAbvĂ܂܂B
	 * - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderɌ炸Astream_play()𗘗p@\ƁAyCuƕpꍇ́Al̑΍􂪕KvłB
	 * //{{2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B
	 * //- music_wchύX鏈́AInitMusic()ōsKv܂B
	 * //  InitMusic()Aumusic_wch = 0;vsĂ邩łBInitMusic()ɕύXƁA0ɖ߂Ă܂܂B
	 * //- Amusic_loudness()̋@\music_wchQƂĂ܂A
	 * //  Al擾Ă̂ŁAmusic_loudness()Ăяomusic_wchύXĂA͂܂B
	 * //}}2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B */
	music_wch = 3; /* `l0=2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderA`l1-2=AvP[VgpA`l3=yCuƂ */
#endif /*defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)*/
#endif /*USE_MUSIC*/

	/* N[Abv֐o^B */
	atexit(app_exit);

#ifdef USE_2BIT_ADPCM
	/* 2-bit ADPCM DecoderN܂B */
	adpcm_init(SOUND_MAXCH);
#endif /*USE_2BIT_ADPCM*/

#ifdef USE_TRUESPEECH
	/* DSP Group TrueSpeech DecoderN܂B */
	TrueSpeech_Init(SOUND_MAXCH);
#endif /*USE_TRUESPEECH*/

	/* TEh܂B */
#ifdef USE_SOUND
	{
#define SOUND_(name) { extern const unsigned char name[]; sound_table[SND_##name] = name; }
#define SOUND_RESOURCE_(name,fname) { sound_table[SND_##name] = fpk_address(resource, fname, NULL); }
#include "sound.h"
#undef SOUND_
#undef SOUND_RESOURCE_
	}
#endif /*USE_SOUND*/

	/* Sound Manager܂B */
#ifdef  USE_SOUND_MANAGER
	{
		static const ST_SndMgrInfo stSndMgrInfo = { sound_play_stub, sound_stop, sound_stat, sound_att };
		pSndMgrBgm = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_BGM_MINCH, SOUND_MANAGER_BGM_MAXCH); /* BGM Sound Manager */
		pSndMgrSe1 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE1_MINCH, SOUND_MANAGER_SE1_MAXCH); /* SE1 Sound Manager */
		pSndMgrSe2 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE2_MINCH, SOUND_MANAGER_SE2_MAXCH); /* SE2 Sound Manager */
	}
#endif/*USE_SOUND_MANAGER*/

	/* TAPз܂ */
#ifdef  USE_SOUND_MIXER
	{
		pTapMxr=TapMxr_New(TapMxrCh_Max+1);
		timer_start(100,TapMxr_TimerProc,(void*)100);	//TAPзpϊJn
	}
#endif/*USE_SOUND_MIXER*/

	/* TAPݻ܂ */
#ifdef  USE_SOUND_SEQUENCER
	{
		static struct {
			ST_TapSeqInfo stTapSeqInfo;
			const uint8_t* TBL_TapSet[(TapLogCh_Max+1)];
		} stTapSeqInfo = {{
			SOUND_COUNT,			//nPhr
			TapDevCh_Max+1,			//nDevCh
			TapLogCh_Max+1,			//nLogCh
			TapSeqCh_Max+1,			//nSeqCh
			1000/FPS,			//iCont
			31/**/,			//nEvt
			~(1<<TapEvt_Ctrl)/*ύX*/,	//iEvtMsk
			TapSeq_fnPlay,
			TapSeq_fnStop,
			TapSeq_fnLoop,
			TapSeq_fnEnd,
			TapSeq_fnNext,
			TapSeq_fnCtrl,
			TapSeq_fnGetPhrTime,
			TapSeq_fnGetPhrNext,
		},{
			(uint8_t[]){TapDevCh_Bg1,-1},			//ðBGM
			(uint8_t[]){TapDevCh_Bg2,-1},			//oBGM
			(uint8_t[]){TapDevCh_Se1,TapDevCh_Se2,-1},	//oSE
			(uint8_t[]){TapDevCh_Se1,TapDevCh_Se2,-1},	//oSE
			(uint8_t[]){TapDevCh_Se1,TapDevCh_Se2,-1},	//oSE
			(uint8_t[]){TapDevCh_Ui1,TapDevCh_Ui2,-1},	//UI
			(uint8_t[]){TapDevCh_Ui1,TapDevCh_Ui2,-1},	//UI
			(uint8_t[]){TapDevCh_Ui1,TapDevCh_Ui2,-1},	//װ
		}};
		pTapSeq=TapSeq_New(&stTapSeqInfo.stTapSeqInfo);
		timer_start(10,TapSeq_TimerProc,(void*)10);	//޼ݻpϊJn
	}
#endif/*USE_SOUND_SEQUENCER*/

	/* LEDV[PT܂B */
#ifdef  USE_LED
	pLedSeq = LedSeq_New(LedCh_Max + 1, LedSeqCh_Max + 1);
#endif//USE_LED

	/* Cxg^C}܂B */
#ifdef  USE_EVENT_TIMER
	{
		static ST_EvtTmrFunc stEvtTmrFunc = { EvtTmr_onEvent };
		pEvtTmr = EvtTmr_New(EvtTmrNo_Max+1);	//ς
		EvtTmr_AddFunc(pEvtTmr, &stEvtTmrFunc);	//ď֐o^
	}
#endif/*USE_EVENT_TIMER*/

	/* ėpJE^Ǘ܂B */
#ifdef  USE_COUNTER_MANAGER
	pCntMgr = CntMgr_New(CntCh_Max+1);
#endif/*USE_COUNTER_MANAGER*/

	/* JE^܂B */
#ifdef  USE_DURATION_COUNTER
	pDurCnt = DurCnt_New();
#endif/*USE_DURATION_COUNTER*/

	/* Oobt@܂B */
#ifdef  USE_LOG_BUFFER
	pLogBuf = LogBuf_Init((DISP_Y+9)/10, LogBuf_fnDraw);
#endif/*USE_LOG_BUFFER*/

	//sOobt@܂B
#ifdef  USE_NVLOG
	{
		time_t t;
		pceFileCreate("nvlog.bin", NVLOG_SIZE);
		pceFileOpen(&faNvLog, "nvlog.bin", FOMD_WR);
		pceFileReadSct(&faNvLog, nvlog, 0, NVLOG_SIZE);	//ÕOɒǉ鎖ɂB̏ԂJnꍇ͂̍s폜B
		time(&t);
		NVLOG("Start at %s", strstrip(ctime(&t)));
	}
#endif//USE_NVLOG

#ifdef  USE_TCL
	//TclC^v^邽߂ɁAIɃK[x[WRNVsB
#if     defined(GC_LEVEL)
/*K{*/timer_start(500/**/, gc_run, NULL);//cliptcl.c̃RgQƁBʏGCTclC^v^gpꍇ́A̍ssȂƋɒ[ɒxȂB
#elif   defined(BITMAP_GC_UNIT)
//C	timer_start(500/**/, gc_run, NULL);//cliptcl.c̃RgQƁBBitmap GCgpꍇ͋ɒ[ɒx͂ȂA̍ssł͂B
#else //defined(GC_LEVEL)||defined(BITMAP_GC_UNIT)
	#error TclC^v^̓K[x[WRN^[̕pK{łB
#endif//defined(GC_LEVEL)||defined(BITMAP_GC_UNIT)
	//TclC^v^쐬B
	iPtr = Tcl_CreateInterp();
	//ėpIȃAvP[V`̃R}ho^B
	Tcl_CreateCommand(iPtr, "srand",    Tcl_SrandCmd,    NULL);
	Tcl_CreateCommand(iPtr, "rand",     Tcl_RandCmd,     NULL);
	Tcl_CreateCommand(iPtr, "log",      Tcl_LogCmd,      NULL);
	Tcl_CreateCommand(iPtr, "schedule", Tcl_ScheduleCmd, NULL);
#endif//USE_TCL

	/* eNX`܂B */
#ifdef USE_TEXTURE
	{
#define TEXTURE_(name) extern const unsigned char name[];
#define TEXTURE_RESOURCE_(name,fname) const void* const name = fpk_address(resource, fname, NULL);
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		texture_table_init(texture_table, TEXTURE_COUNT,
#define TEXTURE_(name) name,
#define TEXTURE_RESOURCE_(name,fname) name,
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		NULL/*Ō','z邽߂̃_~[Btexture_table_init()ɑ΂Ă͖ӖłB*/);
	}
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
	/* ȈՃXvCghCo܂B */
	sprite_init(&render, sprite_table, SPRITE_COUNT, texture_table, TEXTURE_COUNT);
#endif /*USE_SPRITE*/

#ifdef  USE_CBKQUE
	/* R[obNL[܂B */
	pCbkQue = DynamicCbkQue_New(2048/**/);	//2048CbkQue_sprite_draw()x100񕪂炢łBCbkQue_render_printf()gƂƏ܂BIR[obNL[Ȃ̂ŏȒlł(0ł)\܂B
#endif//USE_CBKQUE

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gJn܂B */
	tcpip_start(0/*EthernethCoMobt@TCY()*/);
#endif /*USE_TCPIP*/

#ifdef USE_VIDREC
	/* ʏo͂܂B */
	yield(); /* runŎsꍇ̎smFɉ邽߁AUSB@\̐؂ւ͂ɒx点 */
#ifdef LDIRECT_INTERVAL
	cdcacm_start(0, sizeof vbuff / 2, NULL, NULL);
#else /*LDIRECT_INTERVAL*/
	cdcacm_start(0, sizeof vbuff / 4, NULL, NULL);
#endif /*LDIRECT_INTERVAL*/
#endif /*USE_VIDREC*/

#ifdef  USE_TASK
	/* ^XNXPW[܂B
	 * - AChXbhƕpꍇ́Aidle_proc()̒ŏĂB
	 *   AChXbhƕp@́Atask_yield()[note]QƂĂB */
	task_init(INT_MIN);//{{TODO:ѱ̎sDxͱعݒ}}
#endif/*USE_TASK*/

#if     (defined(USE_ENM)&&defined(USE_REG))
	/* 񋓒`L[擾܂B */
	pEnmKey = REG_open_key(TBL_RegTbl, RegKey_EnmDef);
#endif//(defined(USE_ENM)&&defined(USE_REG))

#ifdef  USE_PRP
	/* vpeBe[uL[擾܂B */
	pPrpKey = REG_open_key(TBL_RegTbl, RegKey_PrpTbl);
	if(!pPrpKey) { DIE(); }
	/* vpeBwb_܂B */
	PrpHdr_init(phApp, pPrpKey, PrpTbl_App);	//ڰĂƂ1`܂KvɉĒ`ǉĉ
#endif//USE_PRP

#ifdef  USE_FSM
	/* Lԋ@B}bvL[擾܂B */
	pFsmKey = REG_open_key(TBL_RegTbl, RegKey_FsmMap);
	if(!pFsmKey) { DIE(); }
	/* Lԋ@B܂B */
	FsmObj_Init(&foApp, pFsmKey, FsmMap_App);	//ڰĂƂ1`܂KvɉĒ`ǉĉ
#endif//USE_FSM

#ifdef  USE_ACT
	/* AN^[IuWFNg܂B */
	aoApp = ActObj_New(NULL);
#endif//USE_ACT

#ifdef  USE_RRS
	/* Round Robin Scheduler (RRS)܂B */
	RRS_new_l(&pRRS, 0/*stacksize*/,	//{{TODO:ύX}}
		//{{TODO:ɃWu֐񋓂ĉB}}
		NULL/*I[*/);
#endif//USE_RRS
#ifdef  USE_MSGHSK
	//bZ[WnhVFCNB
	MsgHsk_Init(&stMsgHsk, pRRS);
#endif//USE_MSGHSK

#ifdef  USE_NUKLEAR
	//NuklearReLXg쐬B
	ctx = nk_piece_new();
#endif//USE_NUKLEAR

/*{{AvP[VL̏*/
	srand(pceTimerGetCount());
/*}}AvP[VL̏*/
}

/****************************************************************************
 *	app_exit
 ****************************************************************************/

void app_exit() {
/*{{AvP[VL̃N[Abv*/
	/** no job **/
/*}}AvP[VL̃N[Abv*/

#ifdef USE_VIDREC
	/* ʏo͂I܂B */
	cdcacm_stop();
#endif /*USE_VIDREC*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gI܂B */
	tcpip_stop();
#endif /*USE_TCPIP*/

#ifdef USE_VQTC
	/* VQkeNX``܂B */
	VqTc_ExitDrawing();
#endif /*USE_VQTC*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_free();
#endif /*LDIRECT_INTERVAL*/

#ifdef  USE_PCL
	/* R[`I܂B */
	co_thread_cleanup();
#endif//USE_PCL

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Free();
#endif /*BITMAP_GC_UNIT*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_free();
#endif /*GC_LEVEL*/

#ifdef USE_DBG
	/* DBGjbg̐ݒ܂B */
	dbg_free();
#endif /*USE_DBG*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VI܂B */
	ufe_stop();
#endif /*USE_UFE*/

#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_free();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND
}

/****************************************************************************
 *	update
 ****************************************************************************/

/* * Mon Mar 10 13:29:56 JST 2008 Naoyuki Sawa
 * - update()AʍXV𕪗A܂B
 */
#ifdef V_SCREEN
/* vbuff(c)_def_vbuff()ϊ */
//static void rotate_screen() {
//	unsigned char *src = &vbuff[88 - 1];	/* ]̉ʂ͍ォ瑖Jn܂ */
//	unsigned char *dst = &_def_vbuff[0];	/* ]̏cʂ͉Eォ瑖Jn܂ */
//	int x = 88;
//	do {
//		int y = 128;
//		do {
//			*dst++ = *src;		/* ʂEɑ܂ */
//			src += 88;		/* cʂɑ܂ */
//		} while(--y);
//						/* ʂ͊Ɏ̍sֈړĂ܂ */
//		src -= 88 * 128 + 1;		/* cʂ̗̈ԏֈړ܂ */
//	} while(--x);
//}
// (C = 9.2ms/1call  ASM = 3.2ms/1call)
/*static*/ void rotate_screen();
asm("
	.code
	.align	1
rotate_screen:
	xld.w	%r12, 0x0e00			; %r12 := FRAM4_START
	xld.w	%r13, rotate_screen_DOX		; %r13 := DOY
	xld.w	%r14, rotate_screen_END		; %r14 := END
	xcall.d	memcpy				; %r10 := FRAM4_START = memcpy(FRAM4_START, DOX, END - DOX)
	sub	%r14, %r13			; %r14 := END - DOY			*delay*
	xld.w	%r4, vbuff+87			; %r4  := src = &vbuff[88 - 1]
	xld.w	%r5, _def_vbuff			; %r5  := dst = &_def_vbuff[0]
	xld.w	%r6, 88				; %r6  := 88
	xld.w	%r7, 128			; %r7  := 128
	xld.w	%r11, 11265			; %r11 := 88 * 128 + 1
	ld.w	%r12, %r6			; %r12 := x = 88
	jp	%r10				; goto FRAM4_START			(jp.d͕s!!)
;//{{FRAM4̈֓]
rotate_screen_DOX:				; do {
	ld.w	%r13, %r7			;   %r13 := y = 128
rotate_screen_DOY:				;   do {
	ld.ub	%r9, [%r4]			;     %r9  := c = *src
	sub	%r13, 1				;     %r13 := --y			*anti-interlock*
	ld.b	[%r5]+, %r9			;     %r5  := *dst++ = c
	jrne.d	rotate_screen_DOY		;   } while(--y)
	add	%r4, %r6			;     %r4  := src += 88			*delay*
	sub	%r12, 1				;   %r12 := --x
	jrne.d	rotate_screen_DOX		; } while(--x)
	sub	%r4, %r11			;   %r4  := src -= 88 * 128 + 1		*delay*
	ret
rotate_screen_END:
;//}}܂FRAM4̈֓]
");
#endif /*V_SCREEN*/

/* * Mon Nov 06 17:37:17 JST 2006 Naoyuki Sawa
 * - schedule()AʍXV𕪗܂B
 *   t[҂ʍXVsꍇ́Å֐ĂяoĂB
 * * Thu Dec 21 21:17:56 JST 2014 Naoyuki Sawa
 * - Oobt@`A܂łschedule()ōsĂ܂Aupdate()ōs悤ɕύX܂B
 *   ɉāAOobt@`OŁAzVRAMۑ悤ɂ܂B
 *   ̕ύXɂāAAvP[V́AOobt@`̉e𖳎āAI[o[CƌȂ悤ɂȂ܂B
 *   ȉ̂悤ȏ\ƂȂ܂B
 *   1
 *   void app_main(){
 *     surface_clear(&surface,0);
 *     render_ellipse(&render,0,0,DISP_X,DISP_Y,3);//~`悷
 *     for(;;){
 *       schedule();//~j󂹂۸ޯ̧`݂̂۰قł
 *       LogBuf_Printf(pLogBuf,"%d",now);
 *   } }
 *   2
 *   void test(){
 *     //``
 *     LogBuf_Printf(pLogBuf,"some message");
 *     update();//۸ޯ̧`݂̂XV
 *     //``
 *   } }
 * - ̕ύXɔAOobt@`悪A^ƁAPC̉ʃLv`Ɋ܂܂ȂȂƂɁAӂĂB
 *   ^schedule()̒vidrec()ŁCLv`schedule()̒yield()ōs鏈łB
 *   vidrec()yield()Ă΂鎞_ł́AzVRAM͕ĂAOobt@`͎cĂȂłB
 *   Oobt@`́AɃeXĝ߂̕\ł̂ŁA^Lv`Ɋ܂܂ĂȂĂ肪Ǝv܂A
 *   Kvłꍇ́A֐̍ṒAzVRAM𕜌鏈폜΁AύXOƓlɊ܂܂悤ɂł܂B
 */
void update() {
#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɉzVRAMޔB */
    #ifdef  V_SCREEN
	static unsigned char tmpbuf[sizeof vbuff];	//Oobt@Əcʂ𕹗pꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgȂBrotate_screen()_def_vbuffj󂷂邩łBtmpbuf[]̕gpʂ邱ƂɒӂB
	memcpy(tmpbuf, vbuff, sizeof vbuff);
    #else //V_SCREEN
	memcpy(_def_vbuff, vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgB
    #endif//V_SCREEN
	/* Oobt@`B */
	LogBuf_Draw(pLogBuf, 0, 0);
#endif/*USE_LOG_BUFFER*/

#ifdef V_SCREEN
	rotate_screen();
#endif /*V_SCREEN*/

	/* ʓ] */
	pceLCDTrans();

#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɑޔzVRAM𕜌B */
    #ifdef  V_SCREEN
	memcpy(vbuff, tmpbuf, sizeof vbuff);		//Oobt@Əcʂ𕹗pꍇ
    #else //V_SCREEN
	memcpy(vbuff, _def_vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ
    #endif//V_SCREEN
#endif/*USE_LOG_BUFFER*/
}

/****************************************************************************
 *	vidrec
 ****************************************************************************/

#ifdef USE_VIDREC
static void vidrec() {
#ifdef LDIRECT_INTERVAL
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,4/*[bpp]*/,FPS };
#else /*LDIRECT_INTERVAL*/
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,2/*[bpp]*/,FPS };
#endif /*LDIRECT_INTERVAL*/
	static int active;
	//
	unsigned char buf[128/**/]; /* (sizeof vbuff)/ÑTCYƂ邱 */
	const unsigned char* src;
	unsigned char* dst;

	if(cdcacm_recv(buf, 1) > 0) {
		switch(buf[0]) {
		case 0:
			active = 0; /* ʏo͒~ */
			break;
		case 1:
			active = 1; /* ʏo͊Jn */
			src = hdr;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				src += cdcacm_send(src, &hdr[sizeof hdr] - src);
			} while(src < &hdr[sizeof hdr]);
			break;
		}
	}
	if(active) {
		src = vbuff;
		do {
			dst = buf;
			do {
#ifdef LDIRECT_INTERVAL
				*dst++ = src[0]|(src[1]<<4); 
				src += 2;
#else /*LDIRECT_INTERVAL*/
				*dst++ = src[0]|(src[1]<<2)|(src[2]<<4)|(src[3]<<6);
				src += 4;
#endif /*LDIRECT_INTERVAL*/
			} while(dst < &buf[sizeof buf]);
			dst = buf;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				dst += cdcacm_send(dst, &buf[sizeof buf] - dst);
			} while(dst < &buf[sizeof buf]);
		} while(src < &vbuff[sizeof vbuff]);
	}
}
#endif /*USE_VIDREC*/

/****************************************************************************
 *	schedule
 ****************************************************************************/

/* * Fri Dec 15 00:49:15 JST 2006 Naoyuki Sawa
 * - schedule()֐ɁATEh|[YΉR[hǉ܂B
 *   ł͏肭삵Ă悤łAX[v̕Aɖ肪NȂmFłB
 * - A|[YԂ̂܂܁AȂ킿ATEh|[YԂ̂܂܂ŃAvP[VIĂ܂ꍇɂA
 *   CLiPCupceAppExit()pceWaveStop(1)ĂяoĂATEhԂZbĝŁAvłB
 */

void schedule() {
#ifdef  USE_RRS
	/* Round Robin Scheduler (RRS)B */
	RRS_yield(pRRS);
#endif//USE_RRS

#ifdef  USE_EVENT_TIMER
	/* Cxg^C}B */
	EvtTmr_Exec(pEvtTmr);
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_COUNTER_MANAGER
	/* ėpJE^ǗB */
	CntMgr_Exec(pCntMgr);
#endif/*USE_COUNTER_MANAGER*/

#ifdef  USE_DURATION_COUNTER
	/* JE^B */
	DurCnt_Exec(pDurCnt);
#endif/*USE_DURATION_COUNTER*/

#ifdef  USE_LED
	/* LEDV[PTB */
	{
		unsigned char Buffer[LedCh_Max + 1];
		memset(Buffer, 1/**/, sizeof Buffer);
		LedSeq_Exec(pLedSeq, Buffer);
		//{{TODO:Buffer[]ʂɕ`悵Ă}}
	}
#endif//USE_LED

#ifdef  USE_CBKQUE
	/* R[obNL[B */
	CbkQue_Invoke(pCbkQue);	//o^Ăm[hSČĂяoBAvP[VɂẮȀCbkQue_InvokePri()𕡐񕪂ČĂяo悤ɕύXĉB
	CbkQue_Clear(pCbkQue);	//R[obNL[̏Ԃɖ߂BAvP[VɂẮAxo^R[obNL[xg񂷏ꍇ́A̍s폜ĉB
#endif//USE_CBKQUE

#ifdef  USE_NUKLEAR
	//Nuklear̕`揈B
	// - GUI̕\Dx́Aڕ`R[obNL[`CPAUSEbZ[WK؂Ǝv̂ŁANuklear̕`揈sɂB
	nk_piece_render(ctx, &render);
#endif//USE_NUKLEAR

#ifdef USE_PAUSE
	{
		/* PAUSEbZ[Ẅ̃C[Wޔpobt@́A324oCgKvłB
		 * X^bNɎ̂͊댯łAstaticɎ̖̂ʂłB
		 * ŁAPAUSEɂ̂݃q[vmۂ邱Ƃɂ܂B
		 */
		//unsigned char save[PAUSE_H][PAUSE_W];
		unsigned char (*save)[PAUSE_W] = NULL/*x}*/;
		int pause = 0;
		/*{{2006/12/15:TEh|[YΉ*/
		int sound_pause = 0/*x}*/;
		/*}}2006/12/15:TEh|[YΉ*/
		int x, y;
		for(;;) {
#endif /*USE_PAUSE*/

			/* ʍXVB */
			update();

#ifdef USE_VIDREC
			/* ʏóB */
			vidrec();
#endif /*USE_VIDREC*/

#ifdef  USE_SOUND_MANAGER
			/* Sound ManagerB */
			SndMgr_Exec(pSndMgrBgm); /* BGM Sound Manager */
			SndMgr_Exec(pSndMgrSe1); /* SE1 Sound Manager */
			SndMgr_Exec(pSndMgrSe2); /* SE2 Sound Manager */
#endif/*USE_SOUND_MANAGER*/

//{{AvP[VL̒ǉ
			//`惋[`ׂ̕ĂAvl[`100%̃^CXCX^邱ƂɂB
			//̕t[[g邪Avl҂̊ԂȂ̂ŁAقǋCɂȂȂ낤B
			apptm_wk = pceTimerGetCount();
//}}AvP[VL̒ǉ

#ifdef USE_IDLE
			/* ACh+VXeB */
			idle_yield();
#else /*USE_IDLE*/
			/* VXeB */
			yield();
#endif /*USE_IDLE*/

			/* pbhԍXVB */
			joy = pad_get();
#ifdef V_SCREEN
			joy = (joy & ~(PAD_LF | PAD_RI | PAD_UP | PAD_DN | /* cʗp͕ϊ */
				       TRG_LF | TRG_RI | TRG_UP | TRG_DN))
				| (joy & PAD_LF ? PAD_UP : 0)
				| (joy & PAD_RI ? PAD_DN : 0)
				| (joy & PAD_UP ? PAD_RI : 0)
				| (joy & PAD_DN ? PAD_LF : 0)
				| (joy & TRG_LF ? TRG_UP : 0)
				| (joy & TRG_RI ? TRG_DN : 0)
				| (joy & TRG_UP ? TRG_RI : 0)
				| (joy & TRG_DN ? TRG_LF : 0);
#endif /*V_SCREEN*/

			/* SELECT{^ꂽIB */ /* AvP[VɂĕsvȂ΁A2s폜ĂB */
			if(joy & TRG_SELECT) exit(EXIT_SUCCESS); /* AvP[VɂĕsvȂ΁A2s폜ĂB */

#ifdef USE_PAUSE
			/* PAUSEB */
			if(joy & TRG_START) {
				pause = !pause;	/* PAUSEԐ؂ւ */
				if(pause) {	/* PAUSE IN */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					sound_pause = fINT_EDMA.EHDM1;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 0;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[WޔB */
					save = (unsigned char (*)[PAUSE_W])malloc(PAUSE_W * PAUSE_H); /* C[Wޔpobt@m */
					if(save == NULL) DIE();
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							save[y][x] = vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)];
						}
					}
				} else {	/* PAUSE OUT */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 1;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[W𕜋AB */
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
						}
					}
					free(save); /* C[Wޔpobt@J */
				}
			}
			if(!pause) break;
			/* PAUSEbZ[W_ŕ\B */
			if(pceTimerGetCount() % 1000 < 750) {
				render_string_framed(&render, PAUSE_X, PAUSE_Y, PAUSE_STR, PAUSE_FONT, PAUSE_COLOR);
			} else {
				for(y = 0; y < PAUSE_H; y++) {
					for(x = 0; x < PAUSE_W; x++) {
						vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
					}
				}
			}
		}
	}
#endif /*USE_PAUSE*/

#ifdef  USE_NUKLEAR
	//Nuklear̃CxgB
	nk_input_begin(ctx);
	nk_piece_handle_event(ctx, joy);
	nk_input_end(ctx);
#endif//USE_NUKLEAR

	now++;	/* O[o^C}XV */

/*{{AvP[VL̎*/
	surface_clear(&surface, 2/*ύX*/);	//Öق̃T[tFCXNAsB̏demo_main()̏ƏՓ˂̂ŁAdemo_main()ƓɎgp鎖͏oȂB]āAsimplify.sedɂdemo_main()폜ɁȀL悤ɂBAvP[VɂẮAÖق̃T[tFCXNAsvȏꍇ́A̍s폜ĉB
/*}}AvP[VL̎*/
}

/****************************************************************************
 *	delay
 ****************************************************************************/

void delay(int frame) {
	while(frame > 0) {
		schedule();
		frame--;
	}
}

/****************************************************************************
 *	Game_Init
 ****************************************************************************/
void Game_Init(int Level, int Cols, int Rows) {
	//\̂NAB
	memset(&stGame, 0, sizeof stGame);
	//Փxi[B
	stGame.Level = Level;
	//Zz̗,si[B
	stGame.Cols = Cols;
	stGame.Rows = Rows;
	//tB[hʒɕ`悤ɁA`挴_߂B
	stGame.x0 = (DISP_X - (W__CELL * stGame.Cols)) / 2;
	stGame.y0 = (DISP_Y - (H__CELL * stGame.Rows)) / 2;
	//J[\̏ʒuݒ肷B
	stGame.CurCol = (stGame.Cols - 1) / 2;
	stGame.CurRow = (stGame.Rows - 1) / 2;
	//J[\̏Wݒ肷B
	stGame.CurX = stGame.x0 + (W__CELL * stGame.CurCol);
	stGame.CurY = stGame.y0 + (H__CELL * stGame.CurRow);
	//ԂB
	stGame.Turn = 1/**/;
}
/****************************************************************************
 *	Cell_GetSprNo
 ****************************************************************************/
int Cell_GetAnmSeqNo(int Color, int Power) {
	int AnmSeqNo;
	switch(Color) {
	default:DIE();
	case 1: AnmSeqNo = AnmSeqNo_BLACK1; break;
	case 2: AnmSeqNo = AnmSeqNo_WHITE1; break;
	}
	if(--Power < 0) { DIE(); }
	AnmSeqNo += min(Power, 4);
	return AnmSeqNo_GetVal(TBL_AnmSeqNo, AnmSeqNo, now, NULL);
}
/****************************************************************************
 *	Field_Draw
 ****************************************************************************/
const unsigned char TBL_CellDivOfs[]={3,6,8,10,11,12};	//
/*--------------------------------------------------------------------------*/
void Field_Draw(int iCellDivOfs) {
	int x, y, Col, Row, Power, NeighborCount, Pri, SprNo, Ofs;
	ST_Cell* pCell;
	if(iCellDivOfs) {
		iCellDivOfs--;
		if((unsigned)iCellDivOfs >= (unsigned)ARRAY_SIZE(TBL_CellDivOfs)) { DIE(); }
		Ofs = TBL_CellDivOfs[iCellDivOfs];
	} else {
		Ofs = 0;
	}
	//eZɂāc
	for(Row = 0; Row < stGame.Rows; Row++) {
		for(Col = 0; Col < stGame.Cols; Col++) {
			pCell = &stGame.Field.TBL_Cell[Row][Col];
			//ڂ`B
			x = stGame.x0 + (W__CELL * Col);
			y = stGame.y0 + (H__CELL * Row);
			Pri = PRI__BOARD;
			SprNo = SPR_BOARD;
			CbkQue_sprite_draw(pCbkQue, Pri, x, y, SprNo, DRW_NOMAL);
			//זEL΁c
			if(pCell->Color) {
				Power = pCell->Power;
				//Aj[VȂ΁c
				if(iCellDivOfs) {
					NeighborCount = Cell_GetNeighborCount(Col, Row);
					//̍זE􂷂Ȃ΁c
					if(Power >= NeighborCount) {
						//юUזE`B
						Pri = PRI__CELL_DIV;
						SprNo = Cell_GetAnmSeqNo(pCell->Color, 1);
						if(Col >               0) { CbkQue_sprite_draw(pCbkQue, Pri, x - Ofs, y, SprNo, DRW_NOMAL); }	//ׂL΁c
						if(Col < stGame.Cols - 1) { CbkQue_sprite_draw(pCbkQue, Pri, x + Ofs, y, SprNo, DRW_NOMAL); }	//EׂL΁c
						if(Row >               0) { CbkQue_sprite_draw(pCbkQue, Pri, x, y - Ofs, SprNo, DRW_NOMAL); }	//ׂL΁c
						if(Row < stGame.Rows - 1) { CbkQue_sprite_draw(pCbkQue, Pri, x, y + Ofs, SprNo, DRW_NOMAL); }	//ׂL΁c
						//ɂ̈ʒuɍזẼp[cĂȂ΁A܂ŁB
						Power -= NeighborCount;
						if(!Power) { continue; }
						/* FALLTHRU */
					}
				}
				//̈ʒu̍זE`B
				Pri = PRI__CELL;
				SprNo = Cell_GetAnmSeqNo(pCell->Color, Power);
				CbkQue_sprite_draw(pCbkQue, Pri, x, y, SprNo, DRW_NOMAL);
			}
		}
	}
}
/****************************************************************************
 *	Ready_Draw
 ****************************************************************************/
static void fn_Ready_Draw(ST_CbkQue* pCbkQue, int pri, void* param) {
	static const char sMsg[] = "qd`cxc";
	int x, y, w, h, xy;
	xy = render_string_framed(&null_render, 0, 0, sMsg, 0, 0);
	w = LOHALF(xy);
	h = HIHALF(xy) + 1;
	y = (DISP_Y - (h + 1)) / 2;
	render_rectangle_shadow(&render, 0, y, DISP_X, h, 1, 3);
	x = DISP_X - (now % w);
	do {
		render_string_framed(&render, x, y + 1, sMsg, 0, 0x330);
		x -= w;
	} while(x > -w);
}
void Ready_Draw() {
	CbkQue_Add(pCbkQue, SHRT_MAX, fn_Ready_Draw, NULL);
}
/****************************************************************************
 *	Start_Draw
 ****************************************************************************/
static void fn_Start_Draw(ST_CbkQue* pCbkQue, int pri, void* param) {
	static const char sMsg[] = "rs`qsI@";
	int x, y, w, h, xy;
	xy = render_string_framed(&null_render, 0, 0, sMsg, 0, 0);
	w = LOHALF(xy);
	h = HIHALF(xy) + 1;
	y = (DISP_Y - (h + 1)) / 2;
	render_rectangle_shadow(&render, 0, y, DISP_X, h, 1, 3);
	x = DISP_X - (now % w);
	do {
		render_string_framed(&render, x, y + 1, sMsg, 0, 0x330);
		x -= w;
	} while(x > -w);
}
void Start_Draw() {
	CbkQue_Add(pCbkQue, SHRT_MAX, fn_Start_Draw, NULL);
}
/****************************************************************************
 *	Thinking_Draw
 ****************************************************************************/
static void fn_Thinking_Draw(ST_CbkQue* pCbkQue, int pri, void* param) {
	static const char sMsg[] = "lc@";
	int x, y, w, h, xy;
	xy = render_string_framed(&null_render, 0, 0, sMsg, 0, 0);
	w = LOHALF(xy);
	h = HIHALF(xy) + 1;
	for(y = 0; y < DISP_Y; y += (DISP_Y - h)) {
		render_rectangle_shadow(&render, 0, y, DISP_X, h, 1, 3);
		if(!y) {
			x = (now % w) - w;
			do {
				render_string_framed(&render, x, y + 1, sMsg, 0, 0x330);
				x += w;
			} while(x < DISP_X);
		} else {
			x = DISP_X - (now % w);
			do {
				render_string_framed(&render, x, y + 1, sMsg, 0, 0x330);
				x -= w;
			} while(x > -w);
		}
	}
}
void Thinking_Draw() {
	CbkQue_Add(pCbkQue, SHRT_MAX, fn_Thinking_Draw, NULL);
}
/****************************************************************************
 *	YouWin_Draw
 ****************************************************************************/
static void fn_YouWin_Draw(ST_CbkQue* pCbkQue, int pri, void* param) {
	static const char sMsg[] = "xnt@vhmI@";
	int x, y, w, h, xy;
	xy = render_string_framed(&null_render, 0, 0, sMsg, 0, 0);
	w = LOHALF(xy);
	h = HIHALF(xy) + 1;
	y = (DISP_Y - (h + 1)) / 2;
	render_rectangle_shadow(&render, 0, y, DISP_X, h, 1, 3);
	x = DISP_X - (now % w);
	do {
		render_string_framed(&render, x, y + 1, sMsg, 0, 0x330);
		x -= w;
	} while(x > -w);
}
void YouWin_Draw() {
	CbkQue_Add(pCbkQue, SHRT_MAX, fn_YouWin_Draw, NULL);
}
/****************************************************************************
 *	YouLose_Draw
 ****************************************************************************/
static void fn_YouLose_Draw(ST_CbkQue* pCbkQue, int pri, void* param) {
	static const char sMsg[] = "xnt@knrdc@";
	int x, y, w, h, xy;
	xy = render_string_framed(&null_render, 0, 0, sMsg, 0, 0);
	w = LOHALF(xy);
	h = HIHALF(xy) + 1;
	y = (DISP_Y - (h + 1)) / 2;
	render_rectangle_shadow(&render, 0, y, DISP_X, h, 1, 3);
	x = DISP_X - (now % w);
	do {
		render_string_framed(&render, x, y + 1, sMsg, 0, 0x330);
		x -= w;
	} while(x > -w);
}
void YouLose_Draw() {
	CbkQue_Add(pCbkQue, SHRT_MAX, fn_YouLose_Draw, NULL);
}
/****************************************************************************
 *	Cursor_Exec
 ****************************************************************************/
int Cursor_Exec() {
	int x, y, dx, dy, oldCurCol, oldCurRow;
	//J[\ړB
	oldCurCol = stGame.CurCol;
	oldCurRow = stGame.CurRow;
	if((joy & TRG_LF) && (stGame.CurCol >               0)) { stGame.CurCol--; }
	if((joy & TRG_RI) && (stGame.CurCol < stGame.Cols - 1)) { stGame.CurCol++; }
	if((joy & TRG_UP) && (stGame.CurRow >               0)) { stGame.CurRow--; }
	if((joy & TRG_DN) && (stGame.CurRow < stGame.Rows - 1)) { stGame.CurRow++; }
	if((stGame.CurCol != oldCurCol) || (stGame.CurRow != oldCurRow)) {
		sound_play(0, sound_table[SND_SE_CUR], 1);
	}
	//J[\̍sʒuɑ`W߂B
	x = stGame.x0 + (W__CELL * stGame.CurCol);
	y = stGame.y0 + (H__CELL * stGame.CurRow);
	//{^ꂽc
	if(joy & TRG_AB) {
		//̈ʒuɍזEu邩ÁAp[𑝂₹Ȃ΁c
		if(Field_TestPutCell(&stGame.Field, stGame.CurCol, stGame.CurRow, stGame.Turn)) {
			//J[\̕`WAJ[\̍sʒuɐݒ肷B
			stGame.CurX = x;
			stGame.CurY = y;
			return 1;	//܂
		} else {
			sound_play(0, sound_table[SND_SE_ERR], 1);
			/* FALLTHRU */
		}
	}
	//J[\̕`WAJ[\̍sʒuɒǏ]B
	dx = x - stGame.CurX;
	dx >>= 1/**/;
	stGame.CurX = dx ? (stGame.CurX + dx) : x;
	dy = y - stGame.CurY;
	dy >>= 1/**/;
	stGame.CurY = dy ? (stGame.CurY + dy) : y;
	return 0;
}
/****************************************************************************
 *	Cursor_Draw
 ****************************************************************************/
void Cursor_Draw() {
	int x, y, Pri, SprNo;
	//J[\`B
	x = stGame.CurX;
	y = stGame.CurY;
	Pri = PRI__CURSOR;
	SprNo = SPR_CURSOR;
	CbkQue_sprite_draw(pCbkQue, Pri, x, y, SprNo, DRW_NOMAL);
}
/****************************************************************************
 *	AiCursor_Draw
 ****************************************************************************/
void AiCursor_Draw(int Col, int Row) {
	int x, y, Pri, SprNo;
	//AIuʒu`B
	x = stGame.x0 + (W__CELL * Col);
	y = stGame.y0 + (H__CELL * Row);
	Pri = PRI__CURSOR;
	SprNo = SPR_CURSOR;
	CbkQue_sprite_draw(pCbkQue, Pri, x, y, SprNo, DRW_NOMAL);
}
/****************************************************************************
 *	AiField_CellDivision
 ****************************************************************************/
int AiField_CellDivision(ST_Field* pField) {
	ST_Field tmpField;
	//זE􂪋Nԁc
	while(Field_CellDivision(pField, &tmpField)) {
		//tB[hXVB
		memcpy(pField, &tmpField, sizeof(ST_Field));
		//sm肵1ԂB
		if(Field_GetWinnerColor(pField)) { return 1; }
	}
	//sm肵Ȃ0ԂB
	return 0;
}
/****************************************************************************
 *	Field_GetScore
 ****************************************************************************/
int Field_GetScore(ST_Field* pField, int MyColor, int NextColor) {
	int Col, Row, NeighborCount, MyScore = 0, EnemyScore = 0;
	ST_Cell *pCell1, *pCell2;
	//SĂ̈ʒuɂāc
	for(Row = 0; Row < stGame.Rows; Row++) {
		for(Col = 0; Col < stGame.Cols; Col++) {
			pCell1 = &pField->TBL_Cell[Row][Col];
			//łȂ΁c
			if(pCell1->Color) {
				int CellScore = (1 + pCell1->Power);	//{1_+p[1_
				//ׂɗLtF̐ƁAׂɗLՊEԂ̋tF̐𐔂B
				int EnemyCount = 0, SaturatedEnemyCount = 0;
				if(Col > 0) {	//
					pCell2 = &pField->TBL_Cell[Row][Col - 1];
					if(pCell2->Color == (3 - pCell1->Color)/*tF*/) {
						EnemyCount++;
						NeighborCount = Cell_GetNeighborCount(Col - 1, Row);
						if(pCell2->Power >= (NeighborCount - 1)) {
							SaturatedEnemyCount++;
						}
					}
				}
				if(Col < stGame.Cols - 1) {	//E
					pCell2 = &pField->TBL_Cell[Row][Col + 1];
					if(pCell2->Color == (3 - pCell1->Color)/*tF*/) {
						EnemyCount++;
						NeighborCount = Cell_GetNeighborCount(Col + 1, Row);
						if(pCell2->Power >= (NeighborCount - 1)) {
							SaturatedEnemyCount++;
						}
					}
				}
				if(Row > 0) {	//
					pCell2 = &pField->TBL_Cell[Row - 1][Col];
					if(pCell2->Color == (3 - pCell1->Color)/*tF*/) {
						EnemyCount++;
						NeighborCount = Cell_GetNeighborCount(Col, Row - 1);
						if(pCell2->Power >= (NeighborCount - 1)) {
							SaturatedEnemyCount++;
						}
					}
				}
				if(Row < stGame.Rows - 1) {	//
					pCell2 = &pField->TBL_Cell[Row + 1][Col];
					if(pCell2->Color == (3 - pCell1->Color)/*tF*/) {
						EnemyCount++;
						NeighborCount = Cell_GetNeighborCount(Col, Row + 1);
						if(pCell2->Power >= (NeighborCount - 1)) {
							SaturatedEnemyCount++;
						}
					}
				}
				//ׂɗՊEԂ̋tFL΁c
				if(SaturatedEnemyCount) {
					NeighborCount = Cell_GetNeighborCount(Col, Row);
					//̃ZՊEԂȂ΁c
					if(pCell1->Power >= (NeighborCount - 1)) {
						//̃Z̎ԂȂ΁c
						if(pCell1->Color == NextColor) {
							//̃ZɂƂėLȏԂȂ̂ŁA_ZB	
							CellScore += (SaturatedEnemyCount * 2) + 1;
						//̃Z̎ԂłȂ΁c
						} else {
							//̃ZɂƂĊ댯ȏԂȂ̂ŁA_}CiXɂB	
							CellScore = 1 - CellScore;
						}
					//̃Z͗ՊEԂłȂ΁c
					} else {
						//̃ZɂƂĕsȏԂȂ̂ŁA_ZbgB	
						CellScore = 1;
					}
				//ׂɗՊEԂ̋tF΁c
				} else {
					NeighborCount = Cell_GetNeighborCount(Col, Row);
					//̃ZՊEԂȂ΁c
					if(pCell1->Power >= (NeighborCount - 1)) {
						//̃ZɂƂĂLȏԂȂ̂ŁA_ZB	
						CellScore += EnemyCount + 1;
					}
				}
				//̃Z̐FȂ΁c
				if(pCell1->Color == MyColor) {
					MyScore += CellScore;
				//̃ZG̐FȂ΁c
				} else {
					EnemyScore += CellScore;
				}
			}
		}
	}
#if 1
	if((MyScore < 0) || (EnemyScore < 0)) {
		if(MyScore < EnemyScore) {
			EnemyScore -= MyScore;
			MyScore    -= MyScore;
		} else {
			MyScore    -= EnemyScore;
			EnemyScore -= EnemyScore;
		}
	}
	if(MyScore + EnemyScore) {
		return (MyScore * 100) / (MyScore + EnemyScore);
	} else {
		return 0;
	}
#else
	return MyScore - EnemyScore;
#endif
}
/****************************************************************************
 *	Ai_Proc
 ****************************************************************************/
//x0:_
void Ai_Proc0(int* pCol, int* pRow) {
	int Col, Row;
	const ST_Cell* pCell;
	for(;;) {
		Col = RND32_RANGE(seed, 0, stGame.Cols);
		Row = RND32_RANGE(seed, 0, stGame.Rows);
		pCell = &stGame.Field.TBL_Cell[Row][Col];
		if(!pCell->Color || (pCell->Color == stGame.Turn)) {
			*pCol = Col;
			*pRow = Row;
			idle_exit(0);
		}
	}
}
/*--------------------------------------------------------------------------*/
//x1:1ǂ
void Ai_Proc1(int* pCol, int* pRow) {
	ST_Field tmpField;
	int Col, Row, BestCol, BestRow, Score, BestScore;
	BestCol = BestRow = BestScore = INT_MIN;
	//SĂ̈ʒuɂāc
	for(Row = 0; Row < stGame.Rows; Row++) {
		for(Col = 0; Col < stGame.Cols; Col++) {
			//̈ʒuɒuȂ΁c
			//if(Field_TestPutCell(&stGame.Field, Col, Row, stGame.Turn/*CPU*/)) {
			if(AiField_TestPutCell(&stGame.Field, Col, Row, stGame.Turn/*CPU*/)) {
				//Ֆʂ𕡐B
				memcpy(&tmpField, &stGame.Field, sizeof(ST_Field));
				//זEuB
				Field_PutCell(&tmpField, Col, Row, stGame.Turn/*CPU*/);
				//sm肵c
				if(AiField_CellDivision(&tmpField)) {
					//XRAݒB
					Score = INT_MAX;
				//sm肵Ȃ΁c
				} else {
					//XRAB
					Score = Field_GetScore(&tmpField, stGame.Turn/*CPU*/, (3 - stGame.Turn)/*vC[*/);
				}
				//ߋō̃XRAȂ΁ÄʒuLB
				if(Score >= BestScore) {
					BestCol = Col;
					BestRow = Row;
					BestScore = Score;
				}
			}
		}
	}
	//ʂ̈ʒui[B
	*pCol = BestCol;
	*pRow = BestRow;
}
/*--------------------------------------------------------------------------*/
//x2:2ǂ
void Ai_Proc2(int* pCol, int* pRow) {
	ST_Field tmpField1, tmpField2;
	int Col1, Row1, Col2, Row2, BestCol, BestRow, Score, BestScore, WorstScore;
	BestCol = BestRow = BestScore = INT_MIN;
	//SĂ̈ʒuɂāc
	for(Row1 = 0; Row1 < stGame.Rows; Row1++) {
		for(Col1 = 0; Col1 < stGame.Cols; Col1++) {
			//̈ʒuɒuȂ΁c
			//if(Field_TestPutCell(&stGame.Field, Col1, Row1, stGame.Turn/*CPU*/)) {
			if(AiField_TestPutCell(&stGame.Field, Col1, Row1, stGame.Turn/*CPU*/)) {
				//Ֆʂ𕡐B
				memcpy(&tmpField1, &stGame.Field, sizeof(ST_Field));
				//זEuB
				Field_PutCell(&tmpField1, Col1, Row1, stGame.Turn/*CPU*/);
				//sm肵c
				if(AiField_CellDivision(&tmpField1)) {
					//XRAݒB
					WorstScore = INT_MAX;
				//sm肵Ȃ΁c
				} else {
					WorstScore = INT_MAX;
					//SĂ̈ʒuɂāc
					for(Row2 = 0; Row2 < stGame.Rows; Row2++) {
						for(Col2 = 0; Col2 < stGame.Cols; Col2++) {
							//̈ʒuɒuȂ΁c
							//if(Field_TestPutCell(&tmpField1, Col2, Row2, (3 - stGame.Turn)/*vC[*/)) {
							if(AiField_TestPutCell(&tmpField1, Col2, Row2, (3 - stGame.Turn)/*vC[*/)) {
								//Ֆʂ𕡐B
								memcpy(&tmpField2, &tmpField1, sizeof(ST_Field));
								//זEuB
								Field_PutCell(&tmpField2, Col2, Row2, (3 - stGame.Turn)/*vC[*/);
								//sm肵c
								if(AiField_CellDivision(&tmpField2)) {
									//XRAݒB
									Score = INT_MIN;
								//sm肵Ȃ΁c
								} else {
									//XRAB
									Score = Field_GetScore(&tmpField2, stGame.Turn/*CPU*/, stGame.Turn/*CPU*/);
									//                                 ~~~~~~~~~~~~~~~~~~'(3-stGame.Turn)/*vC[*/'ƂȂ悤ӂB܂łCPU猩XRA߂B
								}
								//ߋŒ̃XRAȂ΁ÃXRALB
								if(Score <= WorstScore) {	//̗p邽߂ɃCR[܂߂B
									WorstScore = Score;
									//Jbg
									if(WorstScore < BestScore) { goto L_ALPHA_CUT; }
								}
							}
						}
					}
L_ALPHA_CUT:
				}
				//ߋō̃XRAȂ΁ÄʒuLB
				if(WorstScore >= BestScore) {	//̗p邽߂ɃCR[܂߂B
					BestCol = Col1;
					BestRow = Row1;
					BestScore = WorstScore;
				}
			}
		}
	}
	//ʂ̈ʒui[B
	*pCol = BestCol;
	*pRow = BestRow;
}
/*--------------------------------------------------------------------------*/
//x3:3ǂ	ȂアBoO?
void Ai_Proc3(int* pCol, int* pRow) {
	ST_Field tmpField1 , tmpField2, tmpField3;
	int Col1, Row1, Col2, Row2, Col3, Row3, BestCol, BestRow, Score, BestScore1, WorstScore, BestScore2;
	BestCol = BestRow = BestScore1 = INT_MIN;
	//SĂ̈ʒuɂāc
	for(Row1 = 0; Row1 < stGame.Rows; Row1++) {
		for(Col1 = 0; Col1 < stGame.Cols; Col1++) {
			//̈ʒuɒuȂ΁c
			//if(Field_TestPutCell(&stGame.Field, Col1, Row1, stGame.Turn/*CPU*/)) {
			if(AiField_TestPutCell(&stGame.Field, Col1, Row1, stGame.Turn/*CPU*/)) {
				//Ֆʂ𕡐B
				memcpy(&tmpField1, &stGame.Field, sizeof(ST_Field));
				//זEuB
				Field_PutCell(&tmpField1, Col1, Row1, stGame.Turn/*CPU*/);
				//sm肵c
				if(AiField_CellDivision(&tmpField1)) {
					//XRAݒB
					WorstScore = INT_MAX;
				//sm肵Ȃ΁c
				} else {
					WorstScore = INT_MAX;
					//SĂ̈ʒuɂāc
					for(Row2 = 0; Row2 < stGame.Rows; Row2++) {
						for(Col2 = 0; Col2 < stGame.Cols; Col2++) {
							//̈ʒuɒuȂ΁c
							//if(Field_TestPutCell(&tmpField1, Col2, Row2, (3 - stGame.Turn)/*vC[*/)) {
							if(AiField_TestPutCell(&tmpField1, Col2, Row2, (3 - stGame.Turn)/*vC[*/)) {
								//Ֆʂ𕡐B
								memcpy(&tmpField2, &tmpField1, sizeof(ST_Field));
								//זEuB
								Field_PutCell(&tmpField2, Col2, Row2, (3 - stGame.Turn)/*vC[*/);
								//sm肵c
								if(AiField_CellDivision(&tmpField2)) {
									//XRAݒB
									BestScore2 = INT_MIN;
								//sm肵Ȃ΁c
								} else {
									BestScore2 = INT_MIN;
									//SĂ̈ʒuɂāc
									for(Row3 = 0; Row3 < stGame.Rows; Row3++) {
										for(Col3 = 0; Col3 < stGame.Cols; Col3++) {
											//̈ʒuɒuȂ΁c
											//if(Field_TestPutCell(&tmpField2, Col3, Row3, stGame.Turn/*CPU*/)) {
											if(AiField_TestPutCell(&tmpField2, Col3, Row3, stGame.Turn/*CPU*/)) {
												//Ֆʂ𕡐B
												memcpy(&tmpField3, &tmpField2, sizeof(ST_Field));
												//זEuB
												Field_PutCell(&tmpField3, Col3, Row3, stGame.Turn/*CPU*/);
												//sm肵c
												if(AiField_CellDivision(&tmpField3)) {
													//XRAݒB
													Score = INT_MAX;
												//sm肵Ȃ΁c
												} else {
													//XRAB
													Score = Field_GetScore(&tmpField3, stGame.Turn/*CPU*/, (3 - stGame.Turn)/*vC[*/);
												}
												//ߋō̃XRAȂ΁ÃXRALB
												if(Score >= BestScore2) {	//̗p邽߂ɃCR[܂߂B
													BestScore2 = Score;
													//Jbg
													if(BestScore2 > WorstScore) { goto L_BETA_CUT; }
												}
											}
										}
									}
L_BETA_CUT:
								}
								//ߋŒ̃XRAȂ΁ÃXRALB
								if(BestScore2 <= WorstScore) {	//̗p邽߂ɃCR[܂߂B
									WorstScore = BestScore2;
									//Jbg
									if(WorstScore < BestScore1) { goto L_ALPHA_CUT; }
								}
							}
						}
					}
L_ALPHA_CUT:
				}
				//ߋō̃XRAȂ΁ÄʒuLB
				if(WorstScore >= BestScore1) {	//̗p邽߂ɃCR[܂߂B
					BestCol = Col1;
					BestRow = Row1;
					BestScore1 = WorstScore;
				}
			}
		}
	}
	//ʂ̈ʒui[B
	*pCol = BestCol;
	*pRow = BestRow;
}
/*--------------------------------------------------------------------------*/
int Ai_Proc(void* param) {
	int* pColRow/*[0=Col,1=Row]*/ = param;
	int Level = stGame.Level;
	//4ڂ܂ł̓x1ȉɂB
	if(stGame.TurnCount < 4) {
		Level = min(Level, 1);
//	//14ڂ܂ł̓x2ȉɂB
//	} else if(stGame.TurnCount < 14) {
//		Level = min(Level, 2);
	}
	//xɂāc
	switch(Level) {
	case 0:  Ai_Proc0(&pColRow[0/*Col*/], &pColRow[1/*Row*/]); break;
	case 1:  Ai_Proc1(&pColRow[0/*Col*/], &pColRow[1/*Row*/]); break;
	case 2:  Ai_Proc2(&pColRow[0/*Col*/], &pColRow[1/*Row*/]); break;
	default: Ai_Proc3(&pColRow[0/*Col*/], &pColRow[1/*Row*/]); break;	//ȂアBoO?
	}
	return 0/*_~[*/;
}
/****************************************************************************
 *	Game_Run
 ****************************************************************************/
void Game_Run() {
	int i, Col, Row, ColRow[2];
	ST_Field tmpField;
	//
	Game_Init(stDemo.Level, stDemo.Cols, stDemo.Rows);
	//҂B
	for(i = 0; i < SEC(0.7); i++) {
		schedule();
		//tB[h`B
		Field_Draw(0);
		//READY`B
		Ready_Draw();
	}
	for(i = 0; i < SEC(0.7); i++) {
		schedule();
		//tB[h`B
		Field_Draw(0);
		//START`B
		Start_Draw();
	}
	//Q[[v
	for(;;) {
		//Ԃɂāc
		switch(stGame.Turn) {
		default:DIE();
		case 1:	//vC[
			for(;;) {
				schedule();
				//tB[h`B
				Field_Draw(0);
				//J[\`B
				Cursor_Draw();
				//vC[̑B
				if(Cursor_Exec()) { break; }	//זEuÁAp[𑝂₷삪sꂽAB
			}
			Col = stGame.CurCol;
			Row = stGame.CurRow;
			break;
		case 2:	//CPU
			//AIJnB
			idle_init(Ai_Proc, ColRow, 0);
			for(i = 0; /** no job **/; i++) {
				schedule();
				//tB[h`B
				Field_Draw(0);
				//l\B
				if(i >= SEC(0.1)) {
					Thinking_Draw();
					if(i == SEC(0.1)) {
						sound_play(0, sound_table[SND_SE_THINK], -1);
						sound_att(0, 8);
					}
				}
				if(!idle_stat()) { break; }	//AIAB
			}
			sound_stop(0);
			sound_att(0, 0);
			Col = ColRow[0/*Col*/];
			Row = ColRow[1/*Row*/];
			//҂B
			for(i = 0; i < (4 * 3/**/); i++) {
				schedule();
				//tB[h`B
				Field_Draw(0);
				//AIuʒu_ŕ\B
				if(!(i & 4)) { AiCursor_Draw(Col, Row); }
			}
			break;
		}
		//זEuÁAp[𑝂₷B
		Field_PutCell(&stGame.Field, Col, Row, stGame.Turn);
		sound_play(0, sound_table[SND_SE_PUT], 1);
		//萔𑝂₷B
		stGame.TurnCount++;
		//҂B
		for(i = 0; i < SEC(0.15)/**/; i++) {
			schedule();
			//tB[h`B
			Field_Draw(0);
		}
		//̍זE􂪋Nc
		if(Field_CellDivision(&stGame.Field, &tmpField)) {
			//҂B
			for(i = 0; i < SEC(0.15)/**/; i++) {
				schedule();
				//tB[h`B
				Field_Draw(0);
			}
			do {
				sound_play(0, sound_table[SND_SE_DIV], 1);
				for(i = 1; i <= ARRAY_SIZE(TBL_CellDivOfs); i++) {
					schedule();
					//tB[h`B
					Field_Draw(i);
				}
				//tB[hXVB
				stGame.Field = tmpField;
				//҂B
				for(i = 0; i < SEC(0.1)/**/; i++) {
					schedule();
					//tB[h`B
					Field_Draw(0);
				}
				//sm肵A[v𔲂B
				if(Field_GetWinnerColor(&stGame.Field)) { break; }
			} while(Field_CellDivision(&stGame.Field, &tmpField));	//A̍זE􂪋Nc
		}
		//sm肵A[v𔲂B
		if(Field_GetWinnerColor(&stGame.Field)) { break; }
		//ԂւB
		stGame.Turn = 3 - stGame.Turn;	//12
	}
	//҂B
	for(i = 0; i < SEC(0.5)/**/; i++) {
		schedule();
		//tB[h`B
		Field_Draw(0);
	}
	switch(stGame.Turn) {
	default:DIE();
	case 1:	//vC[
		sound_play(0, sound_table[SND_SE_WIN], 1);
		break;
	case 2:	//CPU
		sound_play(0, sound_table[SND_SE_LOSE], 1);
		break;
	}
	//҂B
	for(i = 0; i < SEC(10.0); i++) {
		schedule();
		//tB[h`B
		Field_Draw(0);
		switch(stGame.Turn) {
		default:DIE();
		case 1:	//vC[
			//YouWin`B
			YouWin_Draw();
			break;
		case 2:	//CPU
			//YouLose`B
			YouLose_Draw();
			break;
		}
		if(joy & PAD_AB) { break; }
	}
}
/****************************************************************************
 *	Demo_Run
 ****************************************************************************/
static void fn_Demo_Draw(ST_CbkQue* pCbkQue, int pri, void* param) {
	static const char* const TBL_LevelName[]={"RANDOM","EASY","NORMAL","HARD"};
	const char* s;
	int x, y;
	//
	surface_clear(&surface, 1);
	//
	s = "bhain qeaction";
	x = 22;
	y = 15;
	render_string_framed(&render, x, y, s, 0, 0x330);
	//
	s = "%c level: %s";
	x = 22;
	y = 35;
	render_printf_framed(&render, x, y, 0, 0x220, s, (stDemo.Sel == 0) ? '>' : ' ', TBL_LevelName[stDemo.Level]);
	//
	s = "%c field cols: %d";
	x = 22;
	y = 45;
	render_printf_framed(&render, x, y, 0, 0x220, s, (stDemo.Sel == 1) ? '>' : ' ', stDemo.Cols);
	//
	s = "%c field rows: %d";
	x = 22;
	y = 55;
	render_printf_framed(&render, x, y, 0, 0x220, s, (stDemo.Sel == 2) ? '>' : ' ', stDemo.Rows);
	//
	if((now % SEC(1.0)) < SEC(0.67)) {
		s = "PRESS A BUTTON TO START";
		x = 6;
		y = 75;
		render_string_framed(&render, x, y, s, 0, 0x220);
	}
}
void Demo_Run() {
	for(;;) {
		schedule();
		CbkQue_Add(pCbkQue, SHRT_MAX, fn_Demo_Draw, NULL);
		if((joy & TRG_UP) && (stDemo.Sel > 0)) {
			stDemo.Sel--;
			sound_play(0, sound_table[SND_SE_CUR], 1);
		}
		if((joy & TRG_DN) && (stDemo.Sel < 2)) {
			stDemo.Sel++;
			sound_play(0, sound_table[SND_SE_CUR], 1);
		}
		if(stDemo.Sel == 0) {
			if((joy & TRG_LF) && (stDemo.Level > MIN_LEVEL)) {
				stDemo.Level--;
				sound_play(0, sound_table[SND_SE_CUR], 1);
			}
			if((joy & TRG_RI) && (stDemo.Level < MAX_LEVEL)) {
				stDemo.Level++;
				sound_play(0, sound_table[SND_SE_CUR], 1);
			}
		}
		if(stDemo.Sel == 1) {
			if((joy & TRG_LF) && (stDemo.Cols > MIN_COLS)) {
				stDemo.Cols--;
				sound_play(0, sound_table[SND_SE_CUR], 1);
			}
			if((joy & TRG_RI) && (stDemo.Cols < MAX_COLS)) {
				stDemo.Cols++;
				sound_play(0, sound_table[SND_SE_CUR], 1);
			}
		}
		if(stDemo.Sel == 2) {
			if((joy & TRG_LF) && (stDemo.Rows > MIN_ROWS)) {
				stDemo.Rows--;
				sound_play(0, sound_table[SND_SE_CUR], 1);
			}
			if((joy & TRG_RI) && (stDemo.Rows < MAX_ROWS)) {
				stDemo.Rows++;
				sound_play(0, sound_table[SND_SE_CUR], 1);
			}
		}
		if(joy & TRG_AB) { break; }
	}
	sound_play(0, sound_table[SND_SE_START], 1);
}
/****************************************************************************
 *	app_main
 ****************************************************************************/
void test() {
	int Score;
	Game_Init(3, 4, 4);
	stGame.Turn = 2;
#if 0
	stGame.Field.TBL_Cell[0][0].Color = 1;	stGame.Field.TBL_Cell[0][1].Color = 1;	stGame.Field.TBL_Cell[0][2].Color = 2;	stGame.Field.TBL_Cell[0][3].Color = 0;
	stGame.Field.TBL_Cell[0][0].Power = 1;	stGame.Field.TBL_Cell[0][1].Power = 2;	stGame.Field.TBL_Cell[0][2].Power = 2;	stGame.Field.TBL_Cell[0][3].Power = 0;
	stGame.Field.TBL_Cell[1][0].Color = 1;	stGame.Field.TBL_Cell[1][1].Color = 0;	stGame.Field.TBL_Cell[1][2].Color = 0;	stGame.Field.TBL_Cell[1][3].Color = 2;
	stGame.Field.TBL_Cell[1][0].Power = 1;	stGame.Field.TBL_Cell[1][1].Power = 0;	stGame.Field.TBL_Cell[1][2].Power = 0;	stGame.Field.TBL_Cell[1][3].Power = 1;
	stGame.Field.TBL_Cell[2][0].Color = 0;	stGame.Field.TBL_Cell[2][1].Color = 0;	stGame.Field.TBL_Cell[2][2].Color = 0;	stGame.Field.TBL_Cell[2][3].Color = 2;
	stGame.Field.TBL_Cell[2][0].Power = 0;	stGame.Field.TBL_Cell[2][1].Power = 0;	stGame.Field.TBL_Cell[2][2].Power = 0;	stGame.Field.TBL_Cell[2][3].Power = 1;
	stGame.Field.TBL_Cell[3][0].Color = 1;	stGame.Field.TBL_Cell[3][1].Color = 0;	stGame.Field.TBL_Cell[3][2].Color = 2;	stGame.Field.TBL_Cell[3][3].Color = 0;
	stGame.Field.TBL_Cell[3][0].Power = 1;	stGame.Field.TBL_Cell[3][1].Power = 0;	stGame.Field.TBL_Cell[3][2].Power = 1;	stGame.Field.TBL_Cell[3][3].Power = 0;
#else
	stGame.Field.TBL_Cell[0][0].Color = 1;	stGame.Field.TBL_Cell[0][1].Color = 1;	stGame.Field.TBL_Cell[0][2].Color = 2;	stGame.Field.TBL_Cell[0][3].Color = 2;
	stGame.Field.TBL_Cell[0][0].Power = 1;	stGame.Field.TBL_Cell[0][1].Power = 2;	stGame.Field.TBL_Cell[0][2].Power = 1;	stGame.Field.TBL_Cell[0][3].Power = 1;
	stGame.Field.TBL_Cell[1][0].Color = 1;	stGame.Field.TBL_Cell[1][1].Color = 0;	stGame.Field.TBL_Cell[1][2].Color = 0;	stGame.Field.TBL_Cell[1][3].Color = 2;
	stGame.Field.TBL_Cell[1][0].Power = 1;	stGame.Field.TBL_Cell[1][1].Power = 0;	stGame.Field.TBL_Cell[1][2].Power = 0;	stGame.Field.TBL_Cell[1][3].Power = 1;
	stGame.Field.TBL_Cell[2][0].Color = 0;	stGame.Field.TBL_Cell[2][1].Color = 0;	stGame.Field.TBL_Cell[2][2].Color = 0;	stGame.Field.TBL_Cell[2][3].Color = 2;
	stGame.Field.TBL_Cell[2][0].Power = 0;	stGame.Field.TBL_Cell[2][1].Power = 0;	stGame.Field.TBL_Cell[2][2].Power = 0;	stGame.Field.TBL_Cell[2][3].Power = 1;
	stGame.Field.TBL_Cell[3][0].Color = 1;	stGame.Field.TBL_Cell[3][1].Color = 0;	stGame.Field.TBL_Cell[3][2].Color = 2;	stGame.Field.TBL_Cell[3][3].Color = 0;
	stGame.Field.TBL_Cell[3][0].Power = 1;	stGame.Field.TBL_Cell[3][1].Power = 0;	stGame.Field.TBL_Cell[3][2].Power = 1;	stGame.Field.TBL_Cell[3][3].Power = 0;
#endif
	Score = Field_GetScore(&stGame.Field, stGame.Turn/*CPU*/, (3 - stGame.Turn)/*vC[*/);
	die("%d", Score);
}
int app_main(int argc, char* argv[]) {
#if 0
	test();
#endif
	stDemo.Level = 2;
	stDemo.Cols  = 5;
	stDemo.Rows  = 4;
	for(;;) {
		Demo_Run();
		Game_Run();
	}
	return 0;
}
