/*
 *	game.c
 *
 *	EFgXǂ
 *
 *	* Fri Feb 10 20:24:30 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
extern /*const*/ unsigned char MAIN_BGM[];
/****************************************************************************
 *	\
 ****************************************************************************/
typedef struct _ST_Game {
	int		nScore;					//XRA
	int		iLevel;					//x
	int		nLines;					//C
	int		nFallBlocks;				//oubN		xAbvp
	//
	int		iNextBlockType;				//NEXTubN̎		//0`BLOCK_TYPES-1
	int		iNextBlockWall;				//NEXTubNo	//0`3
	//
	int		iBlockType;				//ubN̎		//0`BLOCK_TYPES-1
	int		iBlockRot;				//ubN̉]		//0`3
	int		iBlockCol;				//ubN̗ʒu		//0`WALL_COLS*4-1
	int		iBlockRow;				//ubN̍sʒu		//-2`WALL_ROWS+FLOOR_SIZE-1
	//
	int		iPreFallCnt;				//JnOJE^		//0PREFALL_TIME
	int		iGrueRow;				//ڒs			//-2`WALL_ROWS+FLOOR_SIZE-1
	int		iGrueCnt;				//ڒJE^			//0GRUE_TIME
	double		dFallCnt;				//JE^			//0.01.0
	//
	int		nErase;					//s̐
	int		TBL_ColErase[FLOOR_SIZE];		//s̃tO
	int		TBL_RowErase[FLOOR_SIZE];		//̃tO
	//
	int		nBorderLine;				//{[_[C̍s		//0`WALL_ROWS
	int		iBorderWarn;				//xĐJE^		//0=off,1`=on
	uint8_t		TBL_Wall[4][WALL_ROWS][WALL_COLS];	//̕,E̕,̕,̕
	uint8_t		TBL_Floor[FLOOR_SIZE][FLOOR_SIZE];	//
} ST_Game;
ST_Game stGame;
/****************************************************************************
 *	
 ****************************************************************************/
void Demo_Run() {
	int i;
	StopMusic();	//BGMmɒ~BQ[SELECT{^Ŕꍇ̂߂łB
#if 0
	{
		int iTapSeqNo = 1;
		for(;;) {
			schedule();
			if(joy & TRG_LF) { if(iTapSeqNo > 1) { iTapSeqNo--; } }
			if(joy & TRG_RI) { if(iTapSeqNo < SOUND_COUNT - 1) { iTapSeqNo++; } }
			if(joy & TRG_A) { TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se1, TBL_TapSeqNo, iTapSeqNo); }
			if(joy & TRG_B) { TapSeqCh_Stop(pTapSeq, TapSeqCh_Se1); }
		}
	}
#endif
	for(;;) {
		schedule();
		CbkQue_sprite_draw(pCbkQue,
			0,
			0,
			0,
			SPR_TITLE,
			DRW_NOMAL);
		CbkQue_render_printf_framed(pCbkQue,
			SHRT_MAX,
			&render,
			75,
			48,
			2,
			0x330,
			"ķ");
		CbkQue_render_printf_framed(pCbkQue,
			SHRT_MAX,
			&render,
			75+2,
			48-2,
			2,
			0x330,
			"  ");
		//
		CbkQue_render_printf(pCbkQue,
			0,
			&render,
			40,
			1,
			2,
			0,
			"HI %05d\n"
			"1P %05d",
			hiscore,
			stGame.nScore);
		//
		CbkQue_render_printf(pCbkQue,
			0,
			&render,
			24,
			62,
			2,
			0,
			"%c LEVEL %2d %c",
			(init_level >  1) ? '<' : ' ',
			 init_level,
			(init_level < 99) ? '>' : ' ');
		if(joy & TRG_LF) {
			if(init_level > 1) {
				init_level--;
				TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se1, TBL_TapSeqNo, TapSeqNo_SE_MOVE);
			}
		}
		if(joy & TRG_RI) {
			if(init_level < 99) {
				init_level++;
				TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se1, TBL_TapSeqNo, TapSeqNo_SE_MOVE);
			}
		}
		//
		if((now % SEC(1.0)) < SEC(0.75)) {
			CbkQue_render_printf(pCbkQue,
				0,
				&render,
				2,
				75,
				2,
				0,
				"PRESS A BUTTON TO START");
		}
		if(joy & TRG_AB) { break; }
	}
	TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se4, TBL_TapSeqNo, TapSeqNo_SE_START);
	for(i = 0; i < SEC(1.5); i++) {
		schedule();
		CbkQue_sprite_draw(pCbkQue,
			0,
			0,
			0,
			SPR_TITLE,
			DRW_NOMAL);
		CbkQue_render_printf_framed(pCbkQue,
			SHRT_MAX,
			&render,
			75,
			48,
			2,
			0x330,
			"ķ");
		CbkQue_render_printf_framed(pCbkQue,
			SHRT_MAX,
			&render,
			75+2,
			48-2,
			2,
			0x330,
			"  ");
		//
		CbkQue_render_printf(pCbkQue,
			0,
			&render,
			40,
			1,
			2,
			0,
			"HI %05d\n"
			"1P %05d",
			hiscore,
			stGame.nScore);
		//
		CbkQue_render_printf(pCbkQue,
			0,
			&render,
			24,
			62,
			2,
			0,
			"%c LEVEL %2d %c",
			' ',
			init_level,
			' ');
		//
		if(now & 2) {
			CbkQue_render_printf(pCbkQue,
				0,
				&render,
				2,
				75,
				2,
				0,
				"PRESS A BUTTON TO START");
		}
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
//݂̃xɉAxԂB
double GetFallSpeed() {
	double speed;
	if(stGame.iLevel < 1) { DIE(); }
	speed = LEVEL1_FALLSPEED;
	speed *= pow(FALLSPEED_POW, (stGame.iLevel - 1));
	if(speed > FALLSPEED_LIMIT) { speed = FALLSPEED_LIMIT; }
	return speed;
}
/*--------------------------------------------------------------------------*/
//݂̃xɉAubN̎ސԂB
int GetBlockTypes() {
	int types;
	if(stGame.iLevel < 1) { DIE(); }
	types = LEVEL1_BLOCKTYPES;
	types += (stGame.iLevel - 1);
	if(types > BLOCKTYPES_LIMIT) { types = BLOCKTYPES_LIMIT; }
	return types;
}
/*--------------------------------------------------------------------------*/
//ubŇ`擾B
int Block_GetCell(int iBlockType, int iRot, int iCol, int iRow) {
	if(((unsigned)iBlockType >= ARRAY_SIZE(TBL_BlockForm)) ||
	   ((unsigned)iRow >= ARRAY_SIZE(TBL_BlockForm[iBlockType])) ||
	   ((unsigned)iRot >= ARRAY_SIZE(TBL_BlockForm[iBlockType][iRow])) ||
	   ((unsigned)iCol >= ARRAY_SIZE(TBL_BlockForm[iBlockType][iRow][iRot]))) { DIE(); }
	return TBL_BlockForm[iBlockType][iRow][iRot][iCol];
}
/*--------------------------------------------------------------------------*/
//NEXTubN`B
void NextBlock_Draw() {
	int iCol, iRow, iRowOfs = 0;
	//12,13,14,16,17,18,25,26,29Ԃ́Aɕ΂Ă悤Ɍ̂ŁAɂ炵ĕ\鎖ɂB
	switch(stGame.iNextBlockType) {
	case 12: case 13: case 14:
	case 16: case 17: case 18:
	case 25: case 26: case 29: iRowOfs = -1; break;
	}
	for(iRow = 0; iRow < BLOCK_SIZE; iRow++) {
		for(iCol = 0; iCol < BLOCK_SIZE; iCol++) {
			if(Block_GetCell(stGame.iNextBlockType, 0/*iRot*/, iCol, iRow)) {
				CbkQue_sprite_draw(pCbkQue,
					PRI__NEXT,
					X__NEXT + (W__NEXT *  iCol           ),
					Y__NEXT + (H__NEXT * (iRow + iRowOfs)),
					SPR_NEXT,
					DRW_NOMAL);
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
//`B
void Arrow_Draw() {
	if(now & 4) {
		int x, y, iSprNo;
		switch(stGame.iNextBlockWall) {
		default:DIE();
		case AREA_WU:	//̕
			x = X__ARROW__U;
			y = Y__ARROW__U;
			iSprNo = SPR_ARROW_U;
			break;
		case AREA_WR:	//E̕
			x = X__ARROW__R;
			y = Y__ARROW__R;
			iSprNo = SPR_ARROW_R;
			break;
		case AREA_WD:	//̕
			x = X__ARROW__D;
			y = Y__ARROW__D;
			iSprNo = SPR_ARROW_D;
			break;
		case AREA_WL:	//̕
			x = X__ARROW__L;
			y = Y__ARROW__L;
			iSprNo = SPR_ARROW_L;
			break;
		}
		CbkQue_sprite_draw(pCbkQue,
			PRI__ARROW,
			x,
			y,
			iSprNo,
			DRW_NOMAL);
	}
}
/*--------------------------------------------------------------------------*/
//XRAAxAC`B
void Info_Draw() {
	//XRA
	CbkQue_render_printf(pCbkQue,
		PRI__SCORE,
		&render,
		X__SCORE,
		Y__SCORE,
		2,
		3,
		"%5d",
		stGame.nScore);
	//x
	CbkQue_render_printf(pCbkQue,
		PRI__LEVEL,
		&render,
		X__LEVEL,
		Y__LEVEL,
		2,
		3,
		"%5d",
		stGame.iLevel);
	//C
	CbkQue_render_printf(pCbkQue,
		PRI__LINES,
		&render,
		X__LINES,
		Y__LINES,
		2,
		3,
		"%5d",
		stGame.nLines);
}
/*--------------------------------------------------------------------------*/
//ǂ̃Z`B
void Wall_Draw() {
	int iWall, iCol, iRow;
	for(iWall = 0; iWall < 4; iWall++) {
		int iSprNo = TBL_WallCell[iWall];
		for(iRow = 0; iRow < WALL_ROWS; iRow++) {
			for(iCol = 0; iCol < WALL_COLS; iCol++) {
				if(stGame.TBL_Wall[iWall][iRow][iCol]) {
					int iSprNoOfs = 0;
					if((now & 1) && (stGame.TBL_Wall[iWall][iRow][iCol] == 2)) { iSprNoOfs = (SPR_L_FO_A1 - SPR_C_FO_A1); }	//Game_Run()́AǂɎcubNÂ̏ɂāA2i[Ăc
					CbkQue_sprite_draw(pCbkQue,
						PRI__CELL,
						0,
						0,
						iSprNo + iSprNoOfs,
						DRW_NOMAL);
				}
				iSprNo++;
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
//̃Z`B
void Floor_Draw() {
	int iCol, iRow;
	int iSprNo = SPR_C_FO_A1;
	for(iRow = 0; iRow < FLOOR_SIZE; iRow++) {
		for(iCol = 0; iCol < FLOOR_SIZE; iCol++) {
			if(stGame.TBL_Floor[iRow][iCol]) {
				int iSprNoOfs = 0;
				if((now & 1) && (stGame.TBL_ColErase[iCol] || stGame.TBL_RowErase[iRow])) { iSprNoOfs = (SPR_L_FO_A1 - SPR_C_FO_A1); }
				CbkQue_sprite_draw(pCbkQue,
					PRI__CELL,
					0,
					0,
					iSprNo + iSprNoOfs,
					DRW_NOMAL);
			}
			iSprNo++;
		}
	}
}
/*--------------------------------------------------------------------------*/
//tB[h`B
void Field_Draw() {
	//wi`B
	CbkQue_sprite_draw(pCbkQue,
		PRI__BG,
		0,
		0,
		SPR_BG,
		DRW_NOMAL);
	//{[_[C̕ǂ̍shׂB
	CbkQue_render_rectangle_fill(pCbkQue,
		PRI__WALL,
		&render,
		TBL_WallFill[stGame.nBorderLine][0/*x*/],
		TBL_WallFill[stGame.nBorderLine][1/*y*/],
		TBL_WallFill[stGame.nBorderLine][2/*w*/],
		TBL_WallFill[stGame.nBorderLine][3/*h*/],
		1/*2ł*/);
//{Ɠlɏ_łꍇ́ÃubNLɂĉBłAi珰ڗ߂ĕsRƎv̂ŁAɂ鎖ɂ܂B
#if 0
	//_ł鏰`B
	CbkQue_sprite_draw(pCbkQue,
		PRI__FLOOR,
		X__FLOOR,
		Y__FLOOR,
	    //{{I
	    //	SPR_FLOOR_0 + UPDOWN_MOTION(now>>2,4),
		SPR_FLOOR_1 + UPDOWN_MOTION(now>>3,3),
	    //	SPR_FLOOR_2 + UPDOWN_MOTION(now>>4,2),
	    //}}I
		DRW_NOMAL);
#endif
	//ǂ̃Z`B
	Wall_Draw();
	//̃Z`B
	Floor_Draw();
	//NEXTubN`B
	NextBlock_Draw();
	//XRAAxAC`B
	Info_Draw();
}
/*--------------------------------------------------------------------------*/
//tB[hŜ̍WÄƁÄ̍WɕϊB
int Cell_GetArea(int iCol, int iRow, int* pColOut/*NULL*/, int* pRowOut/*NULL*/) {
	int dummy;
	if(!pColOut) { pColOut = &dummy; }
	if(!pRowOut) { pRowOut = &dummy; }
	if((unsigned)iCol < WALL_COLS) {
		if((unsigned)iRow < WALL_ROWS) {
			//̕
			*pColOut = iCol;
			*pRowOut = iRow;
			return AREA_WU;
		} else {
			iRow -= WALL_ROWS;
			if((unsigned)iRow < FLOOR_SIZE) {
				//(Y+)
				*pColOut = iCol;
				*pRowOut = iRow;
				return AREA_FU;
			}
		}
	} else {
		iCol -= WALL_COLS;
		if((unsigned)iCol < WALL_COLS) {
			if((unsigned)iRow < WALL_ROWS) {
				//E̕
				*pColOut = iCol;
				*pRowOut = iRow;
				return AREA_WR;
			} else {
				iRow -= WALL_ROWS;
				if((unsigned)iRow < FLOOR_SIZE) {
					//(X-)
					*pColOut = (FLOOR_SIZE - 1) - iRow;
					*pRowOut = iCol;
					return AREA_FR;
				}
			}
		} else {
			iCol -= WALL_COLS;
			if((unsigned)iCol < WALL_COLS) {
				if((unsigned)iRow < WALL_ROWS) {
					//̕
					*pColOut = iCol;
					*pRowOut = iRow;
					return AREA_WD;
				} else {
					iRow -= WALL_ROWS;
					if((unsigned)iRow < FLOOR_SIZE) {
						//(Y-)
						*pColOut = (FLOOR_SIZE - 1) - iCol;
						*pRowOut = (FLOOR_SIZE - 1) - iRow;
						return AREA_FD;
					}
				}
			} else {
				iCol -= WALL_COLS;
				if((unsigned)iCol < WALL_COLS) {
					if((unsigned)iRow < WALL_ROWS) {
						//̕
						*pColOut = iCol;
						*pRowOut = iRow;
						return AREA_WL;
					} else {
						iRow -= WALL_ROWS;
						if((unsigned)iRow < FLOOR_SIZE) {
							//(X+)
							*pColOut = iRow;
							*pRowOut = (FLOOR_SIZE - 1) - iCol;
							return AREA_FL;
						}
					}
				}
			}
		}
	}
	DIE();	//oO
}
/*--------------------------------------------------------------------------*/
//Cӂ̃Z`B
void Cell_Draw(int iCol, int iRow, int iSprNoOfs) {
	int iArea, iSprNo;
	//tB[hŜ̍WÄƁÄ̍WɕϊB
	iArea = Cell_GetArea(iCol, iRow, &iCol, &iRow);
	//̈ɑΉAZ̃XvCgԍ擾B
	switch(iArea) {
	default:DIE();
	case AREA_WU:	//̕
	case AREA_WR:	//E̕
	case AREA_WD:	//̕
	case AREA_WL:	//̕
		iSprNo = TBL_WallCell[iArea];
		break;
	case AREA_FU:	//(Y+)
	case AREA_FR:	//(X-)
	case AREA_FD:	//(Y-)
	case AREA_FL:	//(X+)
		iSprNo = SPR_C_FO_A1;
		break;
	}
	//Z`B
	iSprNo += (WALL_COLS * iRow) + iCol;
	CbkQue_sprite_draw(pCbkQue,
		PRI__CELL,
		0,
		0,
		iSprNo + iSprNoOfs,
		DRW_NOMAL);
}
/*--------------------------------------------------------------------------*/
//ubN`B
void Block_Draw() {
	int iCol1, iRow1, iCol2, iRow2;
	for(iRow1 = 0; iRow1 < BLOCK_SIZE; iRow1++) {
		for(iCol1 = 0; iCol1 < BLOCK_SIZE; iCol1++) {
			if(Block_GetCell(stGame.iBlockType, stGame.iBlockRot, iCol1, iRow1)) {
				iCol2 = stGame.iBlockCol + iCol1;
				iRow2 = stGame.iBlockRow + iRow1;
				if(iCol2 >= (WALL_COLS * 4)) { iCol2 -= (WALL_COLS * 4); }
				if(iRow2 >= 0) { Cell_Draw(iCol2, iRow2, (SPR_D_FO_A1 - SPR_C_FO_A1)); }
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
//ubNƁÃubN,,tB[h[Ƃ́AqbgeXgsB
int Block_HitTest(int iRot, int iCol, int iRow) {
	int iCol1, iRow1, iCol2, iRow2, iArea;
	for(iRow1 = 0; iRow1 < BLOCK_SIZE; iRow1++) {
		for(iCol1 = 0; iCol1 < BLOCK_SIZE; iCol1++) {
			if(Block_GetCell(stGame.iBlockType, iRot, iCol1, iRow1)) {
				iCol2 = iCol + iCol1;
				iRow2 = iRow + iRow1;
				if(iCol2 >= (WALL_COLS * 4)) { iCol2 -= (WALL_COLS * 4); }
				if(iRow2 >= 0) {
					if(iRow2 >= (WALL_ROWS + FLOOR_SIZE)) { return 1; }	//tB[h[
					iArea = Cell_GetArea(iCol2, iRow2, &iCol2, &iRow2);
					switch(iArea) {
					default:DIE();
					case AREA_WU:	//̕
					case AREA_WR:	//E̕
					case AREA_WD:	//̕
					case AREA_WL:	//̕
						if(stGame.TBL_Wall[iArea][iRow2][iCol2]) { return 1; }
						break;
					case AREA_FU:	//(Y+)
					case AREA_FR:	//(X-)
					case AREA_FD:	//(Y-)
					case AREA_FL:	//(X+)
						if(stGame.TBL_Floor[iRow2][iCol2]) { return 1; }
						break;
					}
				}
			}
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
//ubN܂܂Ă̈́Arbg}XN擾B
int Block_GetArea(int iRot, int iCol, int iRow) {
	int iCol1, iRow1, iCol2, iRow2, iArea, fAreaMask = 0;
	for(iRow1 = 0; iRow1 < BLOCK_SIZE; iRow1++) {
		for(iCol1 = 0; iCol1 < BLOCK_SIZE; iCol1++) {
			if(Block_GetCell(stGame.iBlockType, iRot, iCol1, iRow1)) {
				iCol2 = iCol + iCol1;
				iRow2 = iRow + iRow1;
				if(iCol2 >= (WALL_COLS * 4)) { iCol2 -= (WALL_COLS * 4); }
				if(iRow2 >= 0) {
					if(iRow2 >= (WALL_ROWS + FLOOR_SIZE)) { DIE(); }	//tB[h[𒴂ubNʒuɑ΂ē֐ĂяoĂ͂ȂB
					iArea = Cell_GetArea(iCol2, iRow2, &iCol2, &iRow2);
					fAreaMask |= (1 << iArea);
				}
			}
		}
	}
	return fAreaMask;
}
/*--------------------------------------------------------------------------*/
//ubN̉B
void Block_Realize() {
	int iCol1, iRow1, iCol2, iRow2, iArea;
	for(iRow1 = 0; iRow1 < BLOCK_SIZE; iRow1++) {
		for(iCol1 = 0; iCol1 < BLOCK_SIZE; iCol1++) {
			if(Block_GetCell(stGame.iBlockType, stGame.iBlockRot, iCol1, iRow1)) {
				iCol2 = stGame.iBlockCol + iCol1;
				iRow2 = stGame.iBlockRow + iRow1;
				if(iCol2 >= (WALL_COLS * 4)) { iCol2 -= (WALL_COLS * 4); }
				if(iRow2 >= 0) {
					if(iRow2 >= (WALL_ROWS + FLOOR_SIZE)) { DIE(); }	//tB[h[𒴂ubNʒuɑ΂ē֐ĂяoĂ͂ȂB
					iArea = Cell_GetArea(iCol2, iRow2, &iCol2, &iRow2);
					switch(iArea) {
					default:DIE();
					case AREA_WU:	//̕
					case AREA_WR:	//E̕
					case AREA_WD:	//̕
					case AREA_WL:	//̕
					//sv	if(stGame.TBL_Wall[iArea][iRow2][iCol2]) { DIE(); }	//ɃubNLʒuɃubN㏑鎖L蓾̂ŁǍ͍sȂ܂BႦ΁ApŃubNēʒuɐڒnꍇA{[_[CႭăubN̏oʒuɃubNLꍇłBȂ݂Ɍ҂̓egXł̓Q[I[o[ɂȂ܂AEFgXł̓Q[I[o[ɂȂ܂BEFgX̃Q[I[o[͂܂łA{[_[CƃubNdȂꍇłB
						stGame.TBL_Wall[iArea][iRow2][iCol2] = 1;
						break;
					case AREA_FU:	//(Y+)
					case AREA_FR:	//(X-)
					case AREA_FD:	//(Y-)
					case AREA_FL:	//(X+)
					//sv	if(stGame.TBL_Floor[iRow2][iCol2]) { DIE(); }	//ɃubNLʒuɃubN㏑鎖L蓾̂ŁǍ͍sȂ܂BႦ΁ApŃubNēʒuɐڒnꍇA{[_[CႭăubN̏oʒuɃubNLꍇłBȂ݂Ɍ҂̓egXł̓Q[I[o[ɂȂ܂AEFgXł̓Q[I[o[ɂȂ܂BEFgX̃Q[I[o[͂܂łA{[_[CƃubNdȂꍇłB
						stGame.TBL_Floor[iRow2][iCol2] = 1;
						break;
					}
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
//ubN𐶐B
void Block_Generate() {
	//ubN𐶐B
	stGame.iBlockType = stGame.iNextBlockType;
	stGame.iBlockRot = 0;
	stGame.iBlockCol = (WALL_COLS * stGame.iNextBlockWall) + (4 - 2);	//85([4])̈ʒuɁAubN53([2])悤ɏoB
	stGame.iBlockRow = stGame.nBorderLine - 2;				//{[_[C̉̍sɁAubN5s3s([2])悤ɏoB
	//JE^B
	stGame.iPreFallCnt = 0;
	stGame.iGrueRow = stGame.iBlockRow;
	stGame.iGrueCnt = 0;
	stGame.dFallCnt = 1.0;	//JnA̗͂ɍs悤ɁB
	stGame.nErase = 0;
	memset(stGame.TBL_ColErase, 0, sizeof stGame.TBL_ColErase);
	memset(stGame.TBL_RowErase, 0, sizeof stGame.TBL_RowErase);
	memset(stGame.TBL_Wall, 0, sizeof stGame.TBL_Wall);
	//NEXTubN𐶐B
	stGame.iNextBlockType = RND32_RANGE(seed, 0, GetBlockTypes());
	stGame.iNextBlockWall = (stGame.iLevel < WALL4_LEVEL) ? 0 : RND32_RANGE(seed, 0, 4);
}
/*--------------------------------------------------------------------------*/
//ubN̈ړ,y,]\𒲂ׂB
int Block_MoveTest(int iRot, int iCol, int iRow) {
	int fAreaMask1, fAreaMask2;
	//̃ubN,,tB[h[ɓȂ΁Aړ,y,]oȂB	܂̔sKvL鎖ɒӂĉBtB[h[𒴂ubNʒuɑ΂Block_GetArea()ĂяoĂ͂ȂłB
	if(Block_HitTest(iRot, iCol, iRow)) { return 0; }
	//ړÕubN܂܂Ă̈́Arbg}XN擾B
	fAreaMask1 = Block_GetArea(stGame.iBlockRot, stGame.iBlockCol, stGame.iBlockRow);
	if(popcount(fAreaMask1 & 0xF0) >= 2) { return 0; }		//pŃubNꂽ́Aړ,y,]͕słB
	//ړ̃ubN܂܂Ă̈́Arbg}XN擾B
	fAreaMask2 = Block_GetArea(iRot, iCol, iRow);
	if( (fAreaMask1 & 0xF0) ==  (fAreaMask2 & 0xF0)) { return 1; }	//̗̈悪ςȂ΁Aړ,y,]\łB
	if(!(fAreaMask1 & 0xF0) || !(fAreaMask2 & 0xF0)) { return 1; }	//̗̈悪ςꍇłAɊ|ĂȂԂ|Ă,,̋tȂ΁Aړ,y,]\łB
	return 0;							//ړOړɊ|Ăꍇ́Ä̗悪ς悤Ȉړ,y,]͕słB
}
/*--------------------------------------------------------------------------*/
int Block_Action() {
	//]ƍEړ
	{
		int iRot = stGame.iBlockRot;
		int iCol = stGame.iBlockCol;
		if(joy & TRG_A) {		//]
			iRot = (iRot + 1) & 3;
		} else if(joy & TRG_UP) {	//ړ
			int fAreaMask = Block_GetArea(stGame.iBlockRot, stGame.iBlockCol, stGame.iBlockRow);
			if(fAreaMask & 0x0F) {	//ǂɎcĂAʒuňړ𔻒fB	{̓ubNꕔłɓǂɎc̈𒴂Ĉړ鎖oȂȂ̂AǂɎcĂ镔͗̈𒴂悤ɂĂǂ낤ƎvĂ鎖ɂB
				int iRelCol = stGame.iBlockCol - ((WALL_COLS * AREA_WU) + (4 - 2));
				while(iRelCol <= -(WALL_COLS * 2)) { iRelCol += (WALL_COLS * 4); }
				while(iRelCol >   (WALL_COLS * 2)) { iRelCol -= (WALL_COLS * 4); }
				if(iRelCol < 0) { iCol++; }
				if(iRelCol > 0) { iCol--; }
			} else {	//ǂɎcĂȂ΁Ä̗ňړ𔻒fB
				switch(fAreaMask) {
				case (1 << AREA_FR): iCol--; break;	//(X-)
				case (1 << AREA_FL): iCol++; break;	//(X+)
				}
			}
			if(iCol < 0) { iCol = (WALL_COLS * 4 - 1); }
			if(iCol > (WALL_COLS * 4 - 1)) { iCol = 0; }
		} else if(joy & TRG_RI) {	//Eړ
			int fAreaMask = Block_GetArea(stGame.iBlockRot, stGame.iBlockCol, stGame.iBlockRow);
			if(fAreaMask & 0x0F) {	//ǂɎcĂAʒuňړ𔻒fB	{̓ubNꕔłɓǂɎc̈𒴂Ĉړ鎖oȂȂ̂AǂɎcĂ镔͗̈𒴂悤ɂĂǂ낤ƎvĂ鎖ɂB
				int iRelCol = stGame.iBlockCol - ((WALL_COLS * AREA_WR) + (4 - 2));
				while(iRelCol <= -(WALL_COLS * 2)) { iRelCol += (WALL_COLS * 4); }
				while(iRelCol >   (WALL_COLS * 2)) { iRelCol -= (WALL_COLS * 4); }
				if(iRelCol < 0) { iCol++; }
				if(iRelCol > 0) { iCol--; }
			} else {	//ǂɎcĂȂ΁Ä̗ňړ𔻒fB
				switch(fAreaMask) {
				case (1 << AREA_FD): iCol--; break;	//(Y-)
				case (1 << AREA_FU): iCol++; break;	//(Y+)
				}
			}
			if(iCol < 0) { iCol = (WALL_COLS * 4 - 1); }
			if(iCol > (WALL_COLS * 4 - 1)) { iCol = 0; }
		} else if(joy & TRG_DN) {	//ړ
			int fAreaMask = Block_GetArea(stGame.iBlockRot, stGame.iBlockCol, stGame.iBlockRow);
			if(fAreaMask & 0x0F) {	//ǂɎcĂAʒuňړ𔻒fB	{̓ubNꕔłɓǂɎc̈𒴂Ĉړ鎖oȂȂ̂AǂɎcĂ镔͗̈𒴂悤ɂĂǂ낤ƎvĂ鎖ɂB
				int iRelCol = stGame.iBlockCol - ((WALL_COLS * AREA_WD) + (4 - 2));
				while(iRelCol <= -(WALL_COLS * 2)) { iRelCol += (WALL_COLS * 4); }
				while(iRelCol >   (WALL_COLS * 2)) { iRelCol -= (WALL_COLS * 4); }
				if(iRelCol < 0) { iCol++; }
				if(iRelCol > 0) { iCol--; }
			} else {	//ǂɎcĂȂ΁Ä̗ňړ𔻒fB
				switch(fAreaMask) {
				case (1 << AREA_FL): iCol--; break;	//(X+)
				case (1 << AREA_FR): iCol++; break;	//(X-)
				}
			}
			if(iCol < 0) { iCol = (WALL_COLS * 4 - 1); }
			if(iCol > (WALL_COLS * 4 - 1)) { iCol = 0; }
		} else if(joy & TRG_LF) {	//ړ
			int fAreaMask = Block_GetArea(stGame.iBlockRot, stGame.iBlockCol, stGame.iBlockRow);
			if(fAreaMask & 0x0F) {	//ǂɎcĂAʒuňړ𔻒fB	{̓ubNꕔłɓǂɎc̈𒴂Ĉړ鎖oȂȂ̂AǂɎcĂ镔͗̈𒴂悤ɂĂǂ낤ƎvĂ鎖ɂB
				int iRelCol = stGame.iBlockCol - ((WALL_COLS * AREA_WL) + (4 - 2));
				while(iRelCol <= -(WALL_COLS * 2)) { iRelCol += (WALL_COLS * 4); }
				while(iRelCol >   (WALL_COLS * 2)) { iRelCol -= (WALL_COLS * 4); }
				if(iRelCol < 0) { iCol++; }
				if(iRelCol > 0) { iCol--; }
			} else {	//ǂɎcĂȂ΁Ä̗ňړ𔻒fB
				switch(fAreaMask) {
				case (1 << AREA_FU): iCol--; break;	//(Y+)
				case (1 << AREA_FD): iCol++; break;	//(Y-)
				}
			}
			if(iCol < 0) { iCol = (WALL_COLS * 4 - 1); }
			if(iCol > (WALL_COLS * 4 - 1)) { iCol = 0; }
		}
		if((iRot != stGame.iBlockRot) ||
		   (iCol != stGame.iBlockCol)) {
			if(Block_MoveTest(iRot, iCol, stGame.iBlockRow)) {
				if(stGame.iBlockRot != iRot) { TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se1, TBL_TapSeqNo, TapSeqNo_SE_ROT); }
				if(stGame.iBlockCol != iCol) { TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se1, TBL_TapSeqNo, TapSeqNo_SE_MOVE); }
				stGame.iBlockRot = iRot;
				stGame.iBlockCol = iCol;
			} else {
				TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se1, TBL_TapSeqNo, TapSeqNo_SE_ERR);
			}
		}
	}
	//
	{
		//JnOJE^܂^CAEgĂȂ΁c
		if(stGame.iPreFallCnt < PREFALL_TIME) {
			//JnOJE^i߂B
			stGame.iPreFallCnt++;
			//B{^̉gKŁAARJnB
			// - B{^̉ł́AARJnȂ悤ɂ܂B
			//   ÕubN̋̂߂B{^𗣂̂xāAӐ}RJnȂ悤ɂ邽߂łB
			if(joy & TRG_B) { stGame.iPreFallCnt = PREFALL_TIME; }
		//RJnȂ΁c
		} else {
			//B|^Ȃ΁AB	NOTE:EFgX̓ZKegXƈċĂXRA͑܂B
			if(joy & PAD_B) { stGame.dFallCnt = FALLSPEED_LIMIT; }
			//,,ȐsB
			stGame.dFallCnt += GetFallSpeed();
			while(stGame.dFallCnt >= 1.0) {
				int iRow = stGame.iBlockRow + 1;
				stGame.dFallCnt -= 1.0;
				if(!Block_HitTest(stGame.iBlockRot, stGame.iBlockCol, iRow)) {
					stGame.iBlockRow = iRow;
				}
			}
		}
	}
	//ڒ
	{
		if(Block_HitTest(stGame.iBlockRot, stGame.iBlockCol, stGame.iBlockRow + 1)) {
			if(stGame.iBlockRow > stGame.iGrueRow) {
				stGame.iGrueRow = stGame.iBlockRow;
				stGame.iGrueCnt = 0;
				TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se2, TBL_TapSeqNo, TapSeqNo_SE_FALL);
			} else {
				if(++stGame.iGrueCnt >= GRUE_TIME) { return 1; }
			/*C*/if(joy & PAD_B) { return 1; }	//ZKegXł͋ꍇ͑ڒ悤Ȃ̂ł܂BĒnꍇڒ܂ł̗]Tꍇ͂̍sRgAEgĉB
			}
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
//s}[NB
void Field_EraseTest() {
	int iCol, iRow;
	//
	for(iCol = 0; iCol < FLOOR_SIZE; iCol++) {
		for(iRow = 0; iRow < FLOOR_SIZE; iRow++) {
			if(!stGame.TBL_Floor[iRow][iCol]) { break; }
		}
		if(iRow == FLOOR_SIZE) {
			stGame.TBL_ColErase[iCol] = 1;
			stGame.nErase++;
		}
	}
	//s
	for(iRow = 0; iRow < FLOOR_SIZE; iRow++) {
		for(iCol = 0; iCol < FLOOR_SIZE; iCol++) {
			if(!stGame.TBL_Floor[iRow][iCol]) { break; }
		}
		if(iCol == FLOOR_SIZE) {
			stGame.TBL_RowErase[iRow] = 1;
			stGame.nErase++;
		}
	}
}
/*--------------------------------------------------------------------------*/
//sl߂B
int Field_DoErase() {
	int iCol, iRow, i, bPack = 0;	//l߂1ɂBTEĥ߂łB
	//(獶)
	for(iCol = 3; iCol >= 0; iCol--) {
		while(stGame.TBL_ColErase[iCol]) {
			for(i = iCol; i >= 0; i--) {
				stGame.TBL_ColErase[i] = (i > 0) ? stGame.TBL_ColErase[i - 1] : 0;
				for(iRow = 0; iRow < FLOOR_SIZE; iRow++) {
					stGame.TBL_Floor[iRow][i] = (i > 0) ? stGame.TBL_Floor[iRow][i - 1] : 0;
					if(!stGame.TBL_ColErase[i] && stGame.TBL_Floor[iRow][i]) { bPack = 1; }	//l߂ʒuOɏȂubNL΋l߂ƌȂB
				}
			}
		}
	}
	//(E)
	for(iCol = 4; iCol <= (FLOOR_SIZE - 1); iCol++) {
		while(stGame.TBL_ColErase[iCol]) {
			for(i = iCol; i <= (FLOOR_SIZE - 1); i++) {
				stGame.TBL_ColErase[i] = (i < (FLOOR_SIZE - 1)) ? stGame.TBL_ColErase[i + 1] : 0;
				for(iRow = 0; iRow < FLOOR_SIZE; iRow++) {
					stGame.TBL_Floor[iRow][i] = (i < (FLOOR_SIZE - 1)) ? stGame.TBL_Floor[iRow][i + 1] : 0;
					if(!stGame.TBL_ColErase[i] && stGame.TBL_Floor[iRow][i]) { bPack = 1; }	//l߂ʒuOɏȂubNL΋l߂ƌȂB
				}
			}
		}
	}
	//s()
	for(iRow = 3; iRow >= 0; iRow--) {
		while(stGame.TBL_RowErase[iRow]) {
			for(i = iRow; i >= 0; i--) {
				stGame.TBL_RowErase[i] = (i > 0) ? stGame.TBL_RowErase[i - 1] : 0;
				for(iCol = 0; iCol < FLOOR_SIZE; iCol++) {
					stGame.TBL_Floor[i][iCol] = (i > 0) ? stGame.TBL_Floor[i - 1][iCol] : 0;
					if(!stGame.TBL_RowErase[i] && stGame.TBL_Floor[i][iCol]) { bPack = 1; }	//l߂ʒuOɏȂubNL΋l߂ƌȂB
				}
			}
		}
	}
	//s(牺)
	for(iRow = 4; iRow <= (FLOOR_SIZE - 1); iRow++) {
		while(stGame.TBL_RowErase[iRow]) {
			for(i = iRow; i <= (FLOOR_SIZE - 1); i++) {
				stGame.TBL_RowErase[i] = (i < (FLOOR_SIZE - 1)) ? stGame.TBL_RowErase[i + 1] : 0;
				for(iCol = 0; iCol < FLOOR_SIZE; iCol++) {
					stGame.TBL_Floor[i][iCol] = (i < (FLOOR_SIZE - 1)) ? stGame.TBL_Floor[i + 1][iCol] : 0;
					if(!stGame.TBL_RowErase[i] && stGame.TBL_Floor[i][iCol]) { bPack = 1; }	//l߂ʒuOɏȂubNL΋l߂ƌȂB
				}
			}
		}
	}
	return bPack;
}
/*--------------------------------------------------------------------------*/
//Q[B
void Game_Init() {
	//\̂NAB
	memset(&stGame, 0, sizeof stGame);
	stGame.iLevel = init_level;
	//ŏ̃ubN_ɂ邽߂ɁANEXTubN𐶐ĂB
	Block_Generate();
	stGame.iNextBlockWall = 0;	//ŏ̈͕K̕ǂoB
}
/*--------------------------------------------------------------------------*/
//xĐJE^̍ĐsB
void Warn_Play() {
	//xĐJE^0łȂ΁A炵0ɂȂc
	if(stGame.iBorderWarn && !--stGame.iBorderWarn) {
		//x炷B
		TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se4, TBL_TapSeqNo, TapSeqNo_SE_WARN);
		//xĐJE^X^[gB
		stGame.iBorderWarn = SEC(1.5/**/);
	}
}
/*--------------------------------------------------------------------------*/
void Game_Run() {
	int i, iWall, iCol, iRow;
	//Q[B
	Game_Init();
	//X^[go
	for(i = 0; i < SEC(2.0); i++) {
		schedule();
		Field_Draw();
		Arrow_Draw();
		if(i == SEC(0.5)) {
			//BGMJn
			PlayMusic(MAIN_BGM);
		}
		if((i % SEC(1.0)) < SEC(0.5)) {
			CbkQue_render_printf_framed(pCbkQue,
				SHRT_MAX,
				&render,
				64,
				15,
				0,
				0x330,
				"PLAYER1");
		}
	}
	for(;;) {
		//ubN𐶐B
		Block_Generate();
		//ubNڒ܂Ń[vB
		for(;;) {
			schedule();
			Warn_Play();
			Field_Draw();
			Block_Draw();
			Arrow_Draw();
			if(Block_Action()) { break; }	//ڒ甲B
		}
		//ubN̉B
		Block_Realize();
		//s}[NB
		Field_EraseTest();
		//s񂪗L΁c
		if(stGame.nErase) {
			//NOTE:ɑ҂Ԃ͗vȂBڒAAłłB(ZKegXł)
			TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se2, TBL_TapSeqNo, TapSeqNo_SE_ERASE);
			//s_ŕ\B
			for(i = 0; i < SEC(0.75); i++) {
				schedule();
				Warn_Play();
				Field_Draw();
				Arrow_Draw();
			}
			//sl߂B
			if(Field_DoErase()) {
				TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se3, TBL_TapSeqNo, TapSeqNo_SE_PAD);
			}
			//XRAZ
			{
				int score = ((1 << (stGame.nErase - 1)) + (stGame.iLevel - 1)) * 10;	//	Level1Ȃ10,20,40,80,160,320ALevel2Ȃ20,30,50,90,170,330ALevel3Ȃ30,40,60,100,180,340AcƂB
				//          <---- 1,2,4,8,16,32 --->|   |<-- 0,1,2,... -->|
				stGame.nScore += score;
				if(stGame.nScore > 99999) { stGame.nScore = 9999; }
				if(stGame.nScore > hiscore) { hiscore = stGame.nScore; }	//nCXRAXV
				stGame.nLines += stGame.nErase;	//CZ
			}
			//҂B
			for(i = 0; i < SEC(0.5); i++) {
				schedule();
				Warn_Play();
				Field_Draw();
				Arrow_Draw();
			}
			//{[_[CĂc
			if(stGame.nBorderLine) {
				//s̐c
				int iErase;
				for(iErase = 0; iErase < stGame.nErase; iErase++) {
					//{[_[C㏸B
					stGame.nBorderLine--;
					TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se2, TBL_TapSeqNo, TapSeqNo_SE_BDUP);
					//҂B
					for(i = 0; i < SEC(0.25); i++) {
						schedule();
						Warn_Play();
						Field_Draw();
						Arrow_Draw();
					}
					if(!stGame.nBorderLine) { break; }	//{[_[CȂrłB
				}
				//҂B
				for(i = 0; i < SEC(0.5); i++) {
					schedule();
					Warn_Play();
					Field_Draw();
					Arrow_Draw();
				}
			}
		}
		{
			//ǂɎcubNÂɂāc
			int iRowMin = WALL_ROWS;	//̕ϐɁAǂɎcubŃAԏ̍sԍ߂B
			for(iWall = 0; iWall < 4; iWall++) {
				for(iRow = 0; iRow < WALL_ROWS; iRow++) {
					for(iCol = 0; iCol < WALL_COLS; iCol++) {
						if(stGame.TBL_Wall[iWall][iRow][iCol]) {
							//ȂΏ҂Bs񂪗Lꍇ͊ɑ҂ԂĂ̂ő҂ȂB
							if((iRowMin == WALL_ROWS) && !stGame.nErase) {
								for(i = 0; i < SEC(0.25); i++) {
									schedule();
									Warn_Play();
									Field_Draw();
									Arrow_Draw();
								}
							}
							//Wall_Draw()̃ubN_ŕ\悤ɁA2i[B
							stGame.TBL_Wall[iWall][iRow][iCol] = 2;
							//ǂɎcubŃAԏ̍sԍXVB
							if(iRow < iRowMin) { iRowMin = iRow; }
							//{[_[C~B
							if(stGame.nBorderLine < WALL_ROWS) { stGame.nBorderLine++; }
							TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se2, TBL_TapSeqNo, TapSeqNo_SE_BDDN);
							//҂B
							for(i = 0; i < SEC(0.25); i++) {
								schedule();
								Warn_Play();
								Field_Draw();	//̃ubN_ŕ\ƂȂBɓ_ŕ\ɂubN_ŕ\ƂȂB
								Arrow_Draw();
							}
						}
					}
				}
			}
			//{[_[Cł~c
			if(iRowMin != WALL_ROWS) {
				//҂B
				for(i = 0; i < SEC(0.5); i++) {
					schedule();
					Warn_Play();
					Field_Draw();
					Arrow_Draw();
				}
			}
			//ԏ̃ubN{[_[CɏdȂAQ[I[o[B
			// - ((iRowMin==WALL_ROWS)&&(iRowMin==stGame.nBorderLine))ɂȂ鎖͖͂(Oɕǂԉ܂ō~肽ɂ̌_@ƂȂǂɎcubNɃ{[_[CăQ[I[o[ɂȂĂ͂Ȃ̂)AꂻȂꍇQ[I[o[Ƃ鎖ɂB
			if(iRowMin <= stGame.nBorderLine) { break; }
		}
		//xAbvB
		if(++stGame.nFallBlocks >= LEVELUP_BLOCKS) {
			stGame.nFallBlocks = 0;
			stGame.iLevel++;
		}
		//{[_[CAc4s̈ʒu܂ŉAx[vJnB
		if(stGame.nBorderLine >= (WALL_ROWS - 4)) {
			if(!stGame.iBorderWarn) {
				stGame.iBorderWarn = 1;
				//ĐJnWarn_Play()ōsB
			}
		} else {
			if(stGame.iBorderWarn) {
				stGame.iBorderWarn = 0;
				TapSeqCh_Stop(pTapSeq, TapSeqCh_Se4);
			}
		}
	}
	//BGM~
	StopMusic();
	TapSeqCh_PlayNo(pTapSeq, TapSeqCh_Se4, TBL_TapSeqNo, TapSeqNo_SE_OVER);
	//Q[I[o[o
	for(i = 0; i < SEC(10.0); i++) {
		schedule();
		Field_Draw();
		CbkQue_render_printf_framed(pCbkQue,
			SHRT_MAX,
			&render,
			44,
			37,
			1,
			(i < SEC(0.1)) ? 0x333 :
			(i < SEC(0.2)) ? 0x332 :
			(i < SEC(0.3)) ? 0x331 : 0x330,
			"GAME OVER");
		if(i >= SEC(1.0)) {
			if(joy & TRG_AB) {
				break;
			}
		}
	}
}
