/*
 *	dsjisutf8 - VtgJISUTF-8ϊtB^
 *	Copyright (C) 2010 Naoyuki Sawa
 *
 *	* Mon Mar 08 23:22:14 JST 2010 Naoyuki Sawa
 *	- 1st [XB
 *	- Wo͂̃eLXgXg[AVtgJISUTF-8ɕR[hϊc[łB
 *	  ̊c[͂L̂łAVtgJISUTF-8ϊ[`̔Y^ƂāA{c[쐬ĂƂɂ܂B
 *	  AP/ECEAṽf[^쐬ɃVtgJISUTF-8ϊKvɂȂꍇ́AMakefile̒Ŗ{c[gƂł܂B
 */
#include <afx.h>

#define VERSION "20100308"

/*****************************************************************************
 *	VtgJISUTF-8ϊ[`
 *****************************************************************************/

/* UTF-8AVtgJISɕϊ܂Bϊ̕񂪁A󕶎łvłB */
CString utf8_to_sjis(const char* utf8_str) {
	/* UTF-8̃oCg擾܂B */
	int utf8_len/*oCg*/ = strlen(utf8_str);

	/* UTF-8AUnicodeɕϊ܂B */
	CWordArray wide_str;
	int wide_len/**/ = MultiByteToWideChar(CP_UTF8, 0, utf8_str, utf8_len/*oCg*/, NULL, 0);
	wide_str.SetSize(wide_len/**/);
	MultiByteToWideChar(CP_UTF8, 0, utf8_str, utf8_len/*oCg*/, wide_str.GetData(), wide_len/**/);

	/* UnicodeAVtgJISɕϊ܂B */
	CString sjis_str;
	int sjis_len/*oCg*/ = WideCharToMultiByte(932/*CP_932*/, 0, wide_str.GetData(), wide_len/**/, NULL, 0, NULL, NULL);
	//                                                               ~~~~~~~~~~~~~~~~~~u&wide_str[0]v͕sBwide_len=0̏ꍇɕsɂȂB
	WideCharToMultiByte(932/*CP_932*/, 0, wide_str.GetData(), wide_len/**/, sjis_str.GetBuffer(sjis_len/*oCg*/), sjis_len/*oCg*/, NULL, NULL);
	//                                    ~~~~~~~~~~~~~~~~~~u&wide_str[0]v͕sBwide_len=0̏ꍇɕsɂȂB
	sjis_str.ReleaseBuffer(sjis_len);

	/* VtgJISԂ܂B */
	return sjis_str;
}

/* VtgJISAUTF-8ɕϊ܂Bϊ̕񂪁A󕶎łvłB */
CString sjis_to_utf8(const char* sjis_str) {
	/* VtgJIS̃oCg擾܂B */
	int sjis_len/*oCg*/ = strlen(sjis_str);

	/* VtgJISAUnicodeɕϊ܂B */
	CWordArray wide_str;
	int wide_len/**/ = MultiByteToWideChar(932/*CP_932*/, 0, sjis_str, sjis_len/*oCg*/, NULL, 0);
	wide_str.SetSize(wide_len/**/);
	MultiByteToWideChar(932/*CP_932*/, 0, sjis_str, sjis_len/*oCg*/, wide_str.GetData(), wide_len/**/);

	/* UnicodeAUTF-8ɕϊ܂B */
	CString utf8_str;
	int utf8_len/*oCg*/ = WideCharToMultiByte(CP_UTF8, 0, wide_str.GetData(), wide_len/**/, NULL, 0, NULL, NULL);
	//                                                         ~~~~~~~~~~~~~~~~~~u&wide_str[0]v͕sBwide_len=0̏ꍇɕsɂȂB
	WideCharToMultiByte(CP_UTF8, 0, wide_str.GetData(), wide_len/**/, utf8_str.GetBuffer(utf8_len/*oCg*/), utf8_len/*oCg*/, NULL, NULL);
	//                              ~~~~~~~~~~~~~~~~~~u&wide_str[0]v͕sBwide_len=0̏ꍇɕsɂȂB
	utf8_str.ReleaseBuffer(utf8_len/*oCg*/);

	/* UTF-8Ԃ܂B */
	return utf8_str;
}

/*****************************************************************************
 *	
 *****************************************************************************/

void
usage()
{
	fprintf(stderr, "dsjisutf8 - VtgJISUTF-8ϊtB^ (%s) Naoyuki Sawa\n", VERSION);
	fprintf(stderr, "Usage: dsjisutf8 -su [̓t@C(VtgJIS) [o̓t@C(UTF-8)]]\n");
	fprintf(stderr, "       dsjisutf8 -us [̓t@C(UTF-8) [o̓t@C(VtgJIS)]]\n");
	fprintf(stderr, "o̓t@Cȗ邩Au-vw肷ƁAWo͂gp܂B\n");
	exit(1);
}

int
main(int argc, char* argv[])
{
	int mode; /* 0 = VtgJISUTF-8, 1 = UTF-8VtgJIS */
	CStdioFile* in;  /* ̓Xg[ */
	CStdioFile* out; /* o̓Xg[ */
	CString str;

	if((argc < 1 + 1) || (argc > 1 + 3)) {
		usage();
	}

	/* ϊ[h擾܂B */
	if(!strcmp(argv[1], "-su")) {
		mode = 0; /* VtgJISUTF-8 */
	
	} else if(!strcmp(argv[1], "-us")) {
		mode = 1; /* UTF-8VtgJIS */
	} else {
		usage();
	}

	/* ̓Xg[J܂B */
	if((argc < 1 + 2) || !strcmp(argv[2], "-")) { /* ̓t@Cȗ邩Au-vw肷ƁAW͂gp܂B */
		in = new CStdioFile(stdin);
	} else {
		TRY {
			in = new CStdioFile(argv[2], CFile::modeRead | CFile::shareDenyWrite | CFile::typeText);
		} CATCH(CFileException, e) {
			fprintf(stderr, "### %sJ܂B\n", argv[2]);
			exit(1);
		} END_CATCH
	}

	/* o̓Xg[J܂B */
	if((argc < 1 + 3) || !strcmp(argv[3], "-")) { /* o̓t@Cȗ邩Au-vw肷ƁAWo͂gp܂B */
		out = new CStdioFile(stdout);
	} else {
		TRY {
			out = new CStdioFile(argv[3], CFile::modeCreate | CFile::modeWrite | CFile::shareExclusive | CFile::typeText);
		} CATCH(CFileException, e) {
			fprintf(stderr, "### %s쐬ł܂B\n", argv[3]);
			exit(1);
		} END_CATCH
	}

	/* ̓Xg[̏I[ɒB܂Łc */
	while(in->ReadString(str)) { /* CStringo[Ŵ̊֐́A'\n'΂菜܂B */
		/* R[hϊ܂B */
		if(mode == 0) {
			str = sjis_to_utf8(str); /* VtgJISUTF-8 */
		} else {
			str = utf8_to_sjis(str); /* UTF-8VtgJIS */
		}
		/* o̓Xg[ɏo܂B */
		out->WriteString(str + '\n');
	}

	/* o̓Xg[܂B */
	delete in;
	delete out;

	return 0;
}
