/*
 *	dpbpe - Byte Pair Encoding compression tool
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Thu Jan 29 21:20:19 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- u/clip/tool/dprcvɂč쐬܂B
 *	* Fri Jan 30 21:08:25 JST 2015 Naoyuki Sawa
 *	- clipbpe.h,clipbpe.c,frambpe.cύX̂ŁAăRpC܂B
 *	* Mon Feb 02 00:23:19 JST 2015 Naoyuki Sawa
 *	- clipbpe.cBytePairEncodingEncoder_Encode()}`XbhɑΉ̂ŁAăRpC܂B
 *	  BytePairEncodingEncoder_Encode()̃}`Xbhłgp邽߂ɁAuvWFNg̐ݒv́u^CCuvɁu}`XbhvI܂B
 *	* Mon Feb 02 21:59:02 JST 2015 Naoyuki Sawa
 *	- clipbpe.c̃}`XbhłBytePairEncodingEncoder_Encode()(srcLen=1)̏ꍇɏIȂoOĈŁAăRpC܂B
 *	* Sat Nov 14 21:55:38 JST 2015 Naoyuki Sawa
 *	- clipbpe.cW[̕ύXɔAc[rh܂B
 *	- "-s"IvVǉ܂BGR[hɁAIɃVOXbhłgp鎖o܂B
 *	  ÂPentium4ŁAHTɂă}`XbhłgpAIɃVOXbhłgp̂ŁÃIvVǉ鎖ɂ܂B
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>
#include <process.h>			//_beginthread()
#define STRICT
#include <windows.h>			//GetSystemInfo()
#define __CLIP_H__
#include "../../include/stdint.h"	//int64_t
#include "../../clipmisc.h"		//DIE,FIELD_SIZEOF
#include "../../clipmisc.c"		//DIE,FIELD_SIZEOF
#include "../../clipbpe.h"
#include "../../clipbpe.c"
#include "../../frambpe.c"

#define VERSION "20151114"

/////////////////////////////////////////////////////////////////////////////

void usage() {
	printf("dpbpe - Byte Pair Encoding compression tool (%s)\n", VERSION);
	printf("Copyright (C) 2015 Naoyuki Sawa All Rights Reserved.\n");
	printf("Usage: [options] <source file name> [<destination file name>]\n");
	printf("Options:\n");
	printf("  -e : encode source file    (default)\n");
	printf("  -d : decode source file\n");
	printf("  -s : force single threaded (only for encoding)\n");
	exit(1);
}

int mode; /* 'd' or 'e' */
int opt_s;
char srcname[_MAX_PATH];
char dstname[_MAX_PATH];

int srclen;
unsigned char* srcbuf;
int dstlen;
unsigned char* dstbuf;
int verlen;
unsigned char* verbuf;

int main(int argc, char* argv[]) {
	int i;
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	FILE* fp;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		switch(argv[i][0]) {
		case '-':
		case '/':
			switch(tolower(argv[i][1])) {
			case 'd':
			case 'e':
				if(!mode) {
					mode = tolower(argv[i][1]);
					break;
				}
				usage();
				break;
			case 's':
				opt_s = 1;
				break;
			default:
				usage();
				break;
			}
			break;
		default:
			if(!srcname[0]) {
				strcpy(srcname, argv[i]);
				break;
			}
			if(!dstname[0]) {
				strcpy(dstname, argv[i]);
				break;
			}
			usage();
			break;
		}
	}
	/* "-d""-e"w肳ĂȂ΁A"-e"Ƃ܂B */
	if(!mode) {
		mode = 'e';
	}
	/* "-s""-e"Ƃpo܂B(Öق"-e"܂) */
	if(opt_s && (mode != 'e')) {
		usage();
	}
	/* ̓t@C͕K{łB */
	if(!srcname[0]) {
		usage();
	}
	if(mode == 'd') {
		/* ̓t@C̊gqȗĂA".bpe"Ƃ܂B
		 * - <>
		 *	̓t@C D:\path\fname -> ̓t@C D:\path\fname.bpe
		 */
		_splitpath(srcname, drive, dir, fname, ext);
		if(!ext[0]) {
			_makepath(srcname, drive, dir, fname, ".bpe");
		}
		/* o̓t@CȗĂꍇA
		 * - ̓t@C̊gq".bpe"Ȃ΁A".bpe"菜̂Ƃ܂B
		 * - ̓t@C̊gq".bpe"łȂ΁Ao̓t@C𐄑łȂ̂ŁAG[Ƃ܂B
		 * - <>
		 *	̓t@C D:\path\fname.ext.bpe -> o̓t@C D:\path\fname.ext
		 *	̓t@C D:\path\fname.ext     -> G[
		 */
		if(!dstname[0]) {
			_splitpath(srcname, drive, dir, fname, ext);
			if(!stricmp(ext, ".bpe")) {
				_makepath(dstname, drive, dir, fname, NULL);
			} else {
				fprintf(stderr, "Error: Destination file could not be supposed.\n");
				exit(1);
			}
		}
	}
	if(mode == 'e') {
		/* o̓t@CȗĂA̓t@CɊgq".bpe"ǉ̂Ƃ܂B
		 * - ̓t@CgqĂꍇǍɂ̊gq".bpe"ǉ܂B
		 *   ̏ꍇAǉgq".bpe"{̊gqɂȂāÅgq̓t@CƂȂ܂B
		 *   <>
		 *	̓t@C D:\path\fname.ext -> o̓t@C D:\path\fname.ext.bpe
		 */
		if(!dstname[0]) {
			_makepath(dstname, NULL, NULL, srcname, ".bpe");
		}
		/* o̓t@C̊gqȗĂA".bpe"Ƃ܂B
		 * - <>
		 *	o̓t@C D:\path\fname -> o̓t@C D:\path\fname.bpe
		 */
		_splitpath(dstname, drive, dir, fname, ext);
		if(!ext[0]) {
			_makepath(dstname, drive, dir, fname, ".bpe");
		}
	}
	/* ̓t@CƏo̓t@CłĂ͂܂B */
	if(!stricmp(srcname, dstname)) {
		fprintf(stderr, "Error: Source file should not be same as destination file.\n");
		exit(1);
	}

	/* ̓t@Cǂݍ݂܂B */
	fp = fopen(srcname, "rb");
	if(!fp) {
		fprintf(stderr, "Error: Failed to open file %s.\n", srcname);
		exit(1);
	}
	fseek(fp, 0, SEEK_END);
	srclen = ftell(fp);
	if(!srclen && (mode == 'd')) {	//WJ('d')Ȃ΁A0oCg̈kf[^͗L蓾Ȃ߁AG[Ƃ܂Bkf[^́A1oCgȏł͂łBBytePairEncodingEncoder_Encode()̎QƂĂBAk('e')Ȃ΁A0oCg̃t@Ck邱Ƃ\Ȃ̂ŁAG[Ƃ͂܂B
		fprintf(stderr, "Error: Source file should not be empty.");
		exit(1);
	}
	rewind(fp);
	srcbuf = malloc(srclen);
	if(!srcbuf) {
		fprintf(stderr, "Error: Failed to allocate source buffer.\n");
		exit(1);
	}
	fread(srcbuf, 1, srclen, fp);
	fclose(fp);

	if(mode == 'e') {
		int (*fnEncode)(const void* _src, int srcLen, void* _dst, int dstCap) = BytePairEncodingEncoder_EncodeST;	//ɁAVOXbhłƂĂB
		if(!opt_s) {													//"-s"w肳Ă炸A
			SYSTEM_INFO si;												//
			GetSystemInfo(&si);											//
			if(si.dwNumberOfProcessors >= 2) { fnEncode = BytePairEncodingEncoder_EncodeMT; }			//vZbT2ȏȂ΁A}`XbhłgpB
		}
		/* kB */
		dstbuf = malloc(srclen/*TCY*/);			//k̕ȂƉ肵1st try
		if(!dstbuf) {
			fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
			exit(1);
		}
		dstlen = (*fnEncode)(srcbuf, srclen, dstbuf, srclen/*TCY*/);
		if(dstlen > srclen) {					//k̕傫Ȃc
			dstbuf = realloc(dstbuf, dstlen/*TCY*/);	//ۂ̈k̃TCY蓖Ă2nd try
			if(!dstbuf) {
				fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
				exit(1);
			}
			if((*fnEncode)(srcbuf, srclen, dstbuf, dstlen/*TCY*/) != dstlen) { DIE(); }	//o̓obt@w肵ĂȂĂkTCY͓ʂɂȂ͂BŎ~܂GR[_̃oOłB
		}
		/* xt@CB */
		verbuf = malloc(srclen);
		if(!verbuf) {
			fprintf(stderr, "Error: Failed to allocate verify buffer.\n");
			exit(1);
		}
		verlen = BytePairEncodingDecoder_Decode(dstbuf, verbuf, srclen);
		if((verlen != srclen) || memcmp(verbuf, srcbuf, srclen)) {
			fprintf(stderr, "Internal error: Verify failed.n");
			exit(1);
		}
	}
	if(mode == 'd') {
		/* WJB */
		dstlen = BytePairEncodingDecoder_Decode(srcbuf, NULL, 0);
		dstbuf = malloc(dstlen);
		if(!dstbuf) {
			fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
			exit(1);
		}
		BytePairEncodingDecoder_Decode(srcbuf, dstbuf, dstlen);
	}

	/* o̓t@C݂܂B */
	fp = fopen(dstname, "wb");
	if(!fp) {
		fprintf(stderr, "Error: Failed to create file %s.\n", dstname);
		exit(1);
	}
	fwrite(dstbuf, 1, dstlen, fp);
	fclose(fp);

	/* |[g\B */
	printf("%s (%d) => %s (%d) : %d%%\n",
		srcname, srclen,
		dstname, dstlen,
		(int)ceil((double)dstlen * 100.0 / (double)srclen));

	return 0;
}
