/*
 *	lexer.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	LEXER
 *****************************************************************************/

typedef struct _LEXER {
	int refcnt;
	LEXER_INTERFACE* lexer_interface;
	//
	int line;			/* ܂ɂłɓǂݍ񂾍s */
	FILE* in;			/* ̓Xg[ */
	TOKEN_INTERFACE** token;	/* ̃g[NA܂́ANULL */
} LEXER;

IMPLEMENT_LEXER_INTERFACE(LEXER, lexer)

const INTERFACE_MAP lexer_interface_map[] = {
	{ LEXER_INTERFACE_ID, offsetof(LEXER, lexer_interface), &lexer_interface },
	{ 0/*I[*/ },
};

LEXER_INTERFACE**
lexer_create(FILE* in)
{
	LEXER* this = calloc(1, sizeof(LEXER));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, lexer_interface_map);

	/* ̓Xg[i[܂B */
	this->in = in;

	return &this->lexer_interface;
}

static void
lexer_delete(LEXER* this)
{
	/* ̃g[NێĂA܂B */
	safe_release(this->token);

	free(this);
}

/*****************************************************************************
 *	LEXER_INTERFACE
 *****************************************************************************/

static int
lexer_getc(LEXER* this)
{
	int c = getc(this->in);
	if(c == '\n') {
		this->line++;
	}
	return c;
}

static void
lexer_ungetc(LEXER* this, int c)
{
	if(ungetc(c, this->in) == EOF) {
		DIE(); /* dungetA܂́AEOF߂ƂÃG[ */
	}
	if(c == '\n') {
		this->line--;
	}
}

static int
lexer_get_line(LEXER_INTERFACE** intf)
{
	LEXER* this = CONTAINING_RECORD(intf, LEXER, lexer_interface);

	return this->line;
}

static TOKEN_INTERFACE**
lexer_get_token(LEXER_INTERFACE** intf)
{
	LEXER* this = CONTAINING_RECORD(intf, LEXER, lexer_interface);
	//
	TOKEN_INTERFACE** token = NULL;
	JTCODE_INTERFACE** code = NULL;
	STRING_BUFFER_INTERFACE** string_buffer = NULL;
	//
	int c;
	int num;
	int type;
	const char* str;

	/* ̃g[NێĂAĂяoɏL܂B */
	if(this->token) {
		return safe_detach(this->token);
	}

	/* s󔒕ǂݔ΂܂B */
	do {
		c = lexer_getc(this);
		if(c == EOF) {
			return NULL; /* vOI */
		}
	} while(isspace(c));

	/* g[Nǂݏo܂B */
	switch(c) {
	case ';':
	case '+':
	case '-':
	case '*':
	case '(':
	case ')':
	case '{':
	case '}':
	case ',':
	case '.':
		/* Pȃg[N쐬܂B */
		safe_attach(token, token_create(c, NULL));
		goto L_EXIT;

	case '/':
		/* RgXLbvA܂́A'/'g[N쐬܂B */
		c = lexer_getc(this);
		if(c != EOF) {
			if(c == '*') { /* CRg */
				for(;;) {
					c = lexer_getc(this);
					if(c == '*') {
						c = lexer_getc(this);
						if(c == '/') {
							break; /* CRgI */
						}
					}
					if(c == EOF) {
						DIE(); /* CRg̒Ńt@CI[ɑ̂NGł */
					}
				}
				safe_attach(token, lexer_get_token(intf));
				goto L_EXIT;
			}
			if(c == '/') { /* C++Rg */
				for(;;) {
					c = lexer_getc(this);
					if(c == '\n') {
						break; /* C++RgsI */
					}
					if(c == EOF) {
						break; /* C++RgsŃt@CI[ɑ̂OKł */
					}
				}
				safe_attach(token, lexer_get_token(intf));
				goto L_EXIT;
			}
			lexer_ungetc(this, c); /* YȂ!! */
		}
		safe_attach(token, token_create('/', NULL)); /* '/' */
		goto L_EXIT;

	case '=':
		/* '=='A܂́A'='g[N𐶐܂B */
		c = lexer_getc(this);
		if(c != EOF) {
			if(c == '=') {
				safe_attach(token, token_create(TOKEN_TYPE_EQ, NULL)); /* '==' */
				goto L_EXIT;
			}
			lexer_ungetc(this, c); /* YȂ!! */
		}
		safe_attach(token, token_create('=', NULL)); /* '=' */
		goto L_EXIT;

	case '!':
		/* '!='A܂́A'!'g[N𐶐܂B */
		c = lexer_getc(this);
		if(c != EOF) {
			if(c == '=') {
				safe_attach(token, token_create(TOKEN_TYPE_NE, NULL)); /* '!=' */
				goto L_EXIT;
			}
			lexer_ungetc(this, c); /* YȂ!! */
		}
		safe_attach(token, token_create('!', NULL)); /* '!' */
		goto L_EXIT;

	case '<':
		/* '<='A܂́A'<'g[N𐶐܂B */
		c = lexer_getc(this);
		if(c != EOF) {
			if(c == '=') {
				safe_attach(token, token_create(TOKEN_TYPE_LE, NULL)); /* '<=' */
				goto L_EXIT;
			}
			lexer_ungetc(this, c); /* YȂ!! */
		}
		safe_attach(token, token_create('<', NULL)); /* '<' */
		goto L_EXIT;

	case '>':
		/* '>='A܂́A'>'g[N𐶐܂B */
		c = lexer_getc(this);
		if(c != EOF) {
			if(c == '=') {
				safe_attach(token, token_create(TOKEN_TYPE_GE, NULL)); /* '>=' */
				goto L_EXIT;
			}
			lexer_ungetc(this, c); /* YȂ!! */
		}
		safe_attach(token, token_create('>', NULL)); /* '>' */
		goto L_EXIT;

	case '&':
		/* '&&'g[N𐶐܂B */
		c = lexer_getc(this);
		if(c == '&') {
			safe_attach(token, token_create(TOKEN_TYPE_AND, NULL)); /* '&&' */
			goto L_EXIT;
		}
		DIE(); /* '&'͎g܂ */

	case '|':
		/* '||'g[N𐶐܂B */
		c = lexer_getc(this);
		if(c == '|') {
			safe_attach(token, token_create(TOKEN_TYPE_OR, NULL)); /* '||' */
			goto L_EXIT;
		}
		DIE(); /* '|'͎g܂ */

	case '"':
		/* g[N쐬܂B */
		safe_attach(string_buffer, string_buffer_create());
		for(;;) {
			c = lexer_getc(this);
			if(c == '\\') {
				c = lexer_getc(this);
			}
			if(c == EOF) {
				DIE(); /* \Ȃt@CI[ */
			}
			if(c == '"') {
				break;
			}
			(*string_buffer)->append_char(string_buffer, c);
		}
		str = (*string_buffer)->lock(string_buffer, 0);
		safe_attach(code, jtstring_create(str));
		safe_attach(token, token_create(TOKEN_TYPE_STRING, code));
		goto L_EXIT;

	default:
		/* lg[N쐬܂B */
		if(isdigit(c)) {
			num = 0;
			do {
				num = (num * 10) + (c - '0');
				c = lexer_getc(this);
				if(c == EOF) {
					DIE(); /* \Ȃt@CI[ */
				}
			} while(isdigit(c));
			lexer_ungetc(this, c); /* YȂ!! */
			safe_attach(code, jtint_create(num));
			safe_attach(token, token_create(TOKEN_TYPE_INT, code));
			goto L_EXIT;
		}

		/* \A܂́AV{g[N쐬܂B */
		if(iscsymf(c)) {
			safe_attach(string_buffer, string_buffer_create());
			do {
				(*string_buffer)->append_char(string_buffer, c);
				c = lexer_getc(this);
				if(c == EOF) {
					DIE(); /* \Ȃt@CI[ */
				}
			} while(iscsym(c));
			lexer_ungetc(this, c); /* YȂ!! */
			str = (*string_buffer)->lock(string_buffer, 0);
			type = joytoy_get_reserved(str);
			if(type >= 0) {
				safe_attach(token, token_create(type, NULL)); /* \ */
			} else {
				safe_attach(code, jtsymbol_intern(str));
				safe_attach(token, token_create(TOKEN_TYPE_SYMBOL, code)); /* V{ */
			}
			goto L_EXIT;
		}

		DIE(); /* sȃg[N */
	}
L_EXIT:

	/* svɂȂC^[tFCX܂B */
	safe_release(code);
	safe_release(string_buffer);

	return token;
}

static void
lexer_unget_token(LEXER_INTERFACE** intf, TOKEN_INTERFACE** token)
{
	LEXER* this = CONTAINING_RECORD(intf, LEXER, lexer_interface);

	/* ߂ꂽg[NÃg[NƂĕێ܂B */
	if(!token) {
		DIE(); /* t@CI[߂Ƃ͂łȂ */
	}
	if(this->token) {
		DIE(); /* dunget֎~ */
	}
	safe_assign(this->token, token);
}

