/*
 *	jtfuncall.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTFUNCALL
 *****************************************************************************/

typedef struct _JTFUNCALL {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	//
	JTSYMBOL_INTERFACE** symbol;			/* ֐\V{ */
	LIST/*<JTCODE_INTERFACE**>*/ * args_list;	/* Xg */
} JTFUNCALL;

IMPLEMENT_JTCODE_INTERFACE(JTFUNCALL, jtfuncall)

const INTERFACE_MAP jtfuncall_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTFUNCALL, jtcode_interface), &jtcode_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtfuncall_create(JTSYMBOL_INTERFACE** symbol, LIST/*<JTCODE_INTERFACE**>*/ * args_list)
{
	JTFUNCALL* this = calloc(1, sizeof(JTFUNCALL));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtfuncall_interface_map);

	/* ֐\V{i[܂B */
	safe_assign(this->symbol, symbol);

	/* Xg𕡐āAi[܂B */
	this->args_list = list_duplicate(args_list);

	return &this->jtcode_interface;
}

static void
jtfuncall_delete(JTFUNCALL* this)
{
	/* ֐\V{܂B */
	safe_release(this->symbol);

	/* Xg폜܂B */
	list_delete(this->args_list);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTFUNCALL* this = CONTAINING_RECORD(intf, JTFUNCALL, jtcode_interface);
	//
	JTCODE_INTERFACE** code = NULL;
	JTFUN_INTERFACE** fun = NULL;
	JTOBJECT_INTERFACE** object = NULL;
	//
	int i;
	int count;
	LIST/*<JTCODE_INTERFACE**>*/ * args_list;

	/* ݂̊֐t[́AsΏۃIuWFNgA܂́ANULL擾܂B */
	safe_attach(object, joytoy_get_object());

	/* V{ɑΉA֐擾܂B */
	safe_attach(code, joytoy_get_symbol_value(this->symbol));
	if(!code) {
		DIE(); /* ` (ǂݍ񂾃vÕG[) */
	}
	safe_assign_interface(fun, code, JTFUN_INTERFACE);
	if(!fun) {
		DIE(); /* ֐łȂ (ǂݍ񂾃vÕG[) */
	}

	/* ꎞIȎXg쐬܂B(]i[邽) */
	args_list = list_create(&jtcode_list_info);

	/* ֐ĂяoÕ^C~OŁA]܂B */
	count = list_size(this->args_list);
	for(i = 0; i < count; i++) {
		safe_attach(code, list_get(this->args_list, i));
		safe_attach(code, (*code)->run(code));
		list_add(args_list, code);
	}

	/* ֐A܂́A\bhĂяo܂B
	 * - ݂̊֐t[ɁAsΏۃIuWFNg΁AȂ킿A\bh̎sȂ΁Aobject͏Ɏw肵܂B
	 *   Aobjectw肵ꍇłĂAĂяo悪ʏ̊֐Ȃ΁AĂяȍɂāA܂B
	 */
	safe_attach(code, (*fun)->call(fun, args_list, object));

	/* ꎞIȎXg폜܂B */
	list_delete(args_list);

	/* svɂȂC^[tFCX܂B */
	safe_release(fun);
	safe_release(object);

	return code;
}

