/*
 *	ght_hash_table.c
 *
 *	Generic Hash Table (GHT)
 *
 *	* Sat Jun 06 15:36:36 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- ulibghthash - Generic Hash Table (GHT)v(http://www.bth.se/people/ska/sim_home/libghthash.html)݊W[łB
 *	  ֐dllibghthashƓŁA͓ƎłB
 *	  IWiłlibghthash͑x\dĎĂ悤łA͏ȃD悵ĒPɎ܂B
 *	- ֐dlgṕAIWiłlibghthash̃hLgQƂĂB
 *	  IWiłlibghthashA/clip/keep/libghthash.7z ɕۑĂ܂B
 *	* Sun Jul 12 21:50:47 JST 2015 Naoyuki Sawa
 *	- ght_set_rehash(),ght_rehash()Ή܂B
 *	  x\dȂjł̊֐ɂ͑ΉĂ܂łAP邽߂ɑΉ鎖ɂ܂B
 *	  ܂ł́Aght_create()̈ɗLx傫Ȓlw肷KvLAۂ̗vfȂɖʂĂ܂B
 *	  ́A'ght_create(0);ght_set_rehash(p_ht,1)'ŗǂAvf̑ɉĎIɃe[uTCY܂B
 *	* Tue Oct 06 21:24:18 JST 2015 Naoyuki Sawa
 *	- ght_size()܂B
 *	  ܂łRAMߖŗD悵i_sizetB[hێɁAght_size()ďoxle_iteratorHėvf𐔂Ă܂B
 *	  ̕ύXi_sizetB[hǉāAght_size()i_sizeԂɂč܂B
 *	  ͂RAMʂ܂AP/ECȄꍇ̓vORAMɓWĴŁAght_size()̃R[hTCYጸŎRAMʂ܂B
 *	* Thu Apr 28 21:03:22 JST 2016 Naoyuki Sawa
 *	- ght_set_bounded_buckets()Ή܂B
 *	- LbVƂĂ̓ɂGg̎폜ŝ́Aght_insert()ĂяoꂽƂdlłB(IWiŃ\[X̓ɏ܂B)
 *	  ght_set_rehash()ĂяoăoPbg̃GgAght_set_bounded_buckets()ĂяoăoPbg~bgƂɂA
 *	  oPbg̃GgoPbg~bg𒴂ƂĂA̎_ł̓Gg̎폜͍s܂B
 *	  Gg̎폜ŝ́Aȍ~ght_insert()ĂяoA̎ɎQƂoPbgoPbg~bg𒴂Ăł鎖ɒӂĉB
 *	- ܂AϓIɗoƎv܂ALbVƂĂ̓ƁAnbV̓́AłB
 *	  oPbg~bg𒴂ăGg̎폜ŝ҂Ă̂ɁȂOɎnbVăoPbgA
 *	  oPbg̃GgA܂ŌoĂGg̎폜sȂ\łB(oPbg~bg̐ݒlɂ܂c)
 *	- ȏ܂Ƃ߂ƁA_ƂĂ:
 *	  LbVƂĎgpꍇ́A]܂菇
 *	  oPbg𖾎ănbVe[u쐬A̒ɃoPbg~bgw肵ăLbVLA
 *	  ȍ~́AoPbg~bg̕ύXAnbV̗LsȂ̂ǂB
 *	  <>
 *	  ght_hash_table_t* p_ht = ght_create(17);
 *	  ght_set_bounded_buckets(p_ht, 8, fnBucketFree);
 *	  //ȍ~Aght_set_bounded_buckets()ght_set_rehash()ĂяoȂB
 *	- ght_set_bounded_buckets()ĂяoăLbVLƁAght_insert()xቺ鎖ɒӂĉB
 *	  Ŝ̃Ggi_sizetB[hɕێĂ܂AoPbg̃Gg͕ێĂȂ̂ŁAoPbg𔻒肷邽߂ɓsx邩łB
 *	  ght_insert()̑xቺhɂ́AoPbgɃGgێ悤ɂΗǂ̂łA͍sȂɂ܂BŔAȉ̒ʂłB
 *	  ER1. oPbg̃Gg͋ɒ[ɑȂƎv̂ŁAsx삵Ăɒ[ɒx͂ȂƎvB
 *	           XnbVe[ugpړÎ߂łA̃oPbgɋɒ[ɑ̃Ggێ̂͌Ił͂ȂA
 *	           ght_set_bounded_buckets()Ɏw肷pPbg~bg̒ĺA1`2炢̌ł͂łB
 *	           ꂮ炢̐Ȃ΁Aght_insert()̓sxĂAقǑ傫Ȗɂ͂ȂȂƎv܂B
 *	           ۂ̂ƂAght_get()qbgȂɑGgƓłAȂɒx͖͂łB
 *	  ER2. ght_insert()̌Ăяopx́AȂƎvB
 *	           ʓIɁAQƂύX̕ȂƎv̂ŁAght_get()ɔׂght_insert()̌Ăяo񐔂͏ȂƎv܂B
 *	           ]āAght_insert()xቺĂAŜւ̉e͏ȂƎv܂B
 *	  ER3. LbVLȂ΁Aght_insert()̑xቺ͋NȂB
 *	           ght_insert()oPbg𑖍̂́Aght_set_bounded_buckets()ĂяoăLbVLꍇłB
 *	           ۂɂ́ALbVLɎg̕Ǝv̂ŁAght_insert()xቺ鎖͏ȂƎv܂B
 *	  ER4. oPbgɃGgێƁAʂĂ܂B
 *	           RȂAoPbgɃGgێƁÂ߂̕ϐKvɂȂA펞ʂ܂B
 *	           R1,2,3̒ʂAght_insert()̑xቺɂe͏Ȃ̂ɁAP邽߂ɏ펞ʂ͖̂ʂƎv܂B
 *	           ALbVLght_insert()xቺ鎖󂯓AǂƎv܂B
 *	  ȏ̗RɂAght_insert()̑xቺh΍͍sȂɂ܂B
 *	  ΂炭gĂ݂āA肪L΍Č悤Ǝv܂A炭̂܂܂Ŗ薳Ǝv܂B
 *	* Sat Apr 30 21:45:42 JST 2016 Naoyuki Sawa
 *	- ght_set_alloc()Ή܂B
 *	* Fri May 06 21:58:10 JST 2016 Naoyuki Sawa
 *	- Ce[Vp̃Xg̒ǉʒuύXȂRɂāAght_insert()ɃRgǋL܂B
 *	  R[hɂ͕ύXL܂B
 *	* Sun Jun 05 21:20:53 JST 2016 Naoyuki Sawa
 *	- ght_first(),ght_first_keysize(),ght_next(),ght_next_keysize()́App_key_dataNULLƂ܂B
 *	  ύXŔAȉ̒ʂłB
 *	- IWiłlibghthashł́Ap_key_sizeNULLłApp_key_dataNULLsłB
 *	  ۂɎgĂ݂ƁA񋓒ɃL[͕svłP[XApp_key_dataw肷邽߂Ƀ_~[ϐpӂȂ΂ȂL܂B
 *	  pp_key_dataNULLƂ́AL̎ԂȂôŁApp_key_dataNULLƂ鎖ɂ܂B
 *	- ̕ύX́AIWiłlibghthashƎdl݊ɂȂĂ܂L̂łAʌ݊狖eėǂƎv܂B
 *	  AIWiłlibghthash̎dlɎKvLꍇ́AAvP[VApp_key_dataNULLw肵Ȃ悤ɒӂΗǂłB
 *	* Sat Oct 01 21:11:57 JST 2016 Naoyuki Sawa
 *	- Hew͗vf[0]̔zɑΉĂȂ̂ŁAvf[1]ƂĒ܂B
 *	  P/ECEJ(GCC)Windows(VC++6.0)́Avf[0]̔zɑΉĂ̂ŁA֌WL܂B
 *	- ght_insert()ɂāAϐ'p_e'ʂɓdɒ`Ă̂C܂B
 *	  ͂̂܂܂ł肠܂񂵁AP/ECEJ(GCC)Windows(VC++6.0,VS2015)ł͌xoȂ̂łAHewŁuC6348 (I) Declaration hides variable "p_e"vƂxołB
 *	  mɖʂ̂ŁAC鎖ɂ܂B
 *	  ̏Cɂ铮̕ω͗L܂B
 */
#include "clip.h"
/****************************************************************************
 *	[J֐
 ****************************************************************************/
static int ght_get_hash_value(ght_hash_table_t* p_ht, int i_key_size, const void* p_key_data) {
	return (unsigned)one_at_a_time_hash(p_key_data, i_key_size) % (unsigned)p_ht->i_table_size;
}
/*--------------------------------------------------------------------------*/
//Search for an element in a bucket.
static ght_hash_entry_t* ght_search_in_bucket(ght_hash_table_t* p_ht, int i_key_size, const void* p_key_data) {
	int l_key = ght_get_hash_value(p_ht, i_key_size, p_key_data);
	LIST_ENTRY* list_head = &p_ht->le_bucket[l_key];
	LIST_ENTRY* list_entry = list_head->Flink;
	while(list_entry != list_head) {
		ght_hash_entry_t* p_e = CONTAINING_RECORD(list_entry, ght_hash_entry_t, le_bucket);
		if((p_e->i_key_size == i_key_size) && !memcmp(p_e->key_data, p_key_data, i_key_size)) {
		    //	//̃nbVe[uALbVƂē쒆Ȃ΁c	//
		    //	if(p_ht->bucket_limit) {					//̃nbVe[uLbVƂē쒆ۂɊ֌WAQƂGg̃oPbg̐擪ֈړ鎖ɂB
				//̃GgÃoPbg̐擪ֈړB	//LbVƂē쒆łȂĂApɂɎQƂGǧȂƂ_邩łB
				RemoveEntryList(&p_e->le_bucket);			//Aght_remove()Ăяoꂽꍇ͖ʏłAɂ͉eL܂B
				InsertHeadList(list_head, &p_e->le_bucket);		//
		    //	}								//
			return p_e;
		}
		list_entry = list_entry->Flink;
	}
	return NULL;
}
/*--------------------------------------------------------------------------*/
static void ght_check_rehash(ght_hash_table_t* p_ht) {
	if(p_ht->flag.b_rehash) {
		//݂̗vf擾BAvf(0)̏ꍇ(1)ƂāAȉ̌vZsB
		int i_size = p_ht->i_size;
		if(!i_size) { i_size = 1; }
		//݂̃e[uTCYAvf̔,,{߂Ȃ΁Avfɍ킹B
		if((p_ht->i_table_size < (i_size / 2)) ||
		   (p_ht->i_table_size > (i_size * 2))) { ght_rehash(p_ht, i_size); }
		//ȏ̏ɂāAe[uTCYvf̔ȏ`{ȉ͈̔͂ɒǏ]B
	}
}
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
//Create a new hash table.
ght_hash_table_t* ght_create(int i_table_size) {
	ght_hash_table_t* p_ht;
	p_ht = calloc(sizeof(ght_hash_table_t), 1);	//łp_ht->fn_alloc,p_ht->fn_freegpȂɒӂĉB
	if(!p_ht) { DIE(); }
	InitializeListHead(&p_ht->le_iterator);
	ght_rehash(p_ht, i_table_size);
	return p_ht;
}
/*--------------------------------------------------------------------------*/
//Get the number of items in the hash table.
int ght_size(ght_hash_table_t* p_ht) {
	return p_ht->i_size;
}
/*--------------------------------------------------------------------------*/
//Get the size of the hash table.
int ght_table_size(ght_hash_table_t* p_ht) {
	return p_ht->i_table_size;
}
/*--------------------------------------------------------------------------*/
//Insert an entry into the hash table.
int ght_insert(ght_hash_table_t* p_ht, void* p_entry_data, int i_key_size, const void* p_key_data) {
	ght_hash_entry_t* p_e;
	int l_key;
	if(!p_entry_data) { DIE(); }
	if(ght_get(p_ht, i_key_size, p_key_data)) { return -1; }	//Don't insert if the key is already present.
	l_key = ght_get_hash_value(p_ht, i_key_size, p_key_data);
	//̃nbVe[uALbVƂē쒆Ȃ΁c
	if(p_ht->bucket_limit) {
		LIST_ENTRY* list_head = &p_ht->le_bucket[l_key];
		LIST_ENTRY* list_entry = list_head->Flink;
		//̃oPbg̐擪(bucket_limit-1)𒴂oPbgSč폜B
		int i = p_ht->bucket_limit;
		while(list_entry != list_head) {
//{{2016/10/01C:ght_insert()ɂāAϐ'p_e'ʂɓdɒ`Ă̂C܂B
//			ght_hash_entry_t* p_e = CONTAINING_RECORD(list_entry, ght_hash_entry_t, le_bucket);
//2016/10/01C:ght_insert()ɂāAϐ'p_e'ʂɓdɒ`Ă̂C܂B
			p_e = CONTAINING_RECORD(list_entry, ght_hash_entry_t, le_bucket);
//}}2016/10/01C:ght_insert()ɂāAϐ'p_e'ʂɓdɒ`Ă̂C܂B
			list_entry = list_entry->Flink;
			if(--i <= 0) {	//bucket_limitڂ폜ΏۂƂ̂ŃvCNgłB
				RemoveEntryList(&p_e->le_iterator);
				RemoveEntryList(&p_e->le_bucket);
				if(p_ht->fn_bucket_free) { (*p_ht->fn_bucket_free)(p_e->p_entry_data, p_e->key_data); }
				if(p_ht->fn_free) {
					(*p_ht->fn_free)(p_e);
				} else {
					free(            p_e);	//'(p_ht->fn_free?p_ht->fn_free:free)(p_e)'͕słBleak_detector.hɂ֐ȗΏۂƂ邽߂ɁAmalloc/free𖼑OŎg킸Ɋ֐Ăяo`ŎgKvL܂Bڍׂ́Agarray.c'Wed Apr 20 10:51:26 JST 2016'̃RgQƂĉB
				}
				p_ht->i_size--;	//YȂ!!
			}
		}
	}
#ifndef __RENESAS__
//Win32P/ECȄꍇ
	if(p_ht->fn_alloc) {
		p_e = (*p_ht->fn_alloc)(sizeof(ght_hash_entry_t) + i_key_size);
	} else {
		p_e = malloc(           sizeof(ght_hash_entry_t) + i_key_size);	//'(p_ht->fn_alloc?p_ht->fn_alloc:malloc)(`)'͕słBleak_detector.hɂ֐ȗΏۂƂ邽߂ɁAmalloc/free𖼑OŎg킸Ɋ֐Ăяo`ŎgKvL܂Bڍׂ́Agarray.c'Wed Apr 20 10:51:26 JST 2016'̃RgQƂĉB
	}
#else //__RENESAS__
//Hew̏ꍇ
	if(p_ht->fn_alloc) {
		p_e = (*p_ht->fn_alloc)(offsetof(ght_hash_entry_t, key_data) + ((i_key_size + 3) & ~3));	//Hew͗vf[0]̔zɑΉĂȂ̂ŁAvf[1]ƂĒ܂B
	} else {
		p_e = malloc(           offsetof(ght_hash_entry_t, key_data) + ((i_key_size + 3) & ~3));	//Hew͗vf[0]̔zɑΉĂȂ̂ŁAvf[1]ƂĒ܂B
	}
#endif//__RENESAS__
	if(!p_e) { DIE(); }
	p_e->p_entry_data = p_entry_data;
	p_e->i_key_size = i_key_size;
	memcpy(p_e->key_data, p_key_data, i_key_size);
	InsertTailList(&p_ht->le_iterator, &p_e->le_iterator);		//Ce[Vp̃Xg𒼐ڎQƂẴAvP[VƂ̌݊̂߂ɁACe[Vp̃Xgւ̒ǉʒu͂܂Œʂ薖ɒǉ鎖ɂB	{{2016/05/06RgǋL:{́Avf̒ǉƃCe[Vp̃Xg͖̏֌WłׂȂ̂AW[̎ɈˑăXg̖ɒǉ鎖҂ɂȂĂ܂Ă郂W[݂(clipstr.cintern_string()BSqliteHelper.c?)B]܂͂Ȃ̂AmɒǉɃCe[gƕ֗ȏʂ̂ŁÂ܂܂ɂ鎖BACe[gOɖIɃ\[gĂ(dlOł͂̂)ꍇ́AXǉɂ͉eȂCe[gƂȂĂ̂ł̌Ƃ͖֌Wł(clipwkst.c)B}}
	InsertHeadList(&p_ht->le_bucket[l_key], &p_e->le_bucket);	//LbVΉ̂߂ɁAoPbg̃Xgւ̒ǉʒu͐擪ɒǉ悤ɕύXB̃AvP[V̓oPbg̃Xg𒼐ڎQƂĂȂ̂ŁA̕ύXɂ̖݊͐Ȃ͂B
	p_ht->i_size++;		//͕̏K{łB
	ght_check_rehash(p_ht);	//
	return 0;
}
/*--------------------------------------------------------------------------*/
//Get an entry from the hash table.
void* ght_get(ght_hash_table_t* p_ht, int i_key_size, const void* p_key_data) {
	ght_hash_entry_t* p_e;
	p_e = ght_search_in_bucket(p_ht, i_key_size, p_key_data);
	if(!p_e) { return NULL; }
	return p_e->p_entry_data;
}
/*--------------------------------------------------------------------------*/
//Replace an entry from the hash table.
void* ght_replace(ght_hash_table_t* p_ht, void* p_entry_data, int i_key_size, const void* p_key_data) {
	ght_hash_entry_t* p_e;
	void* p_old_data;
	p_e = ght_search_in_bucket(p_ht, i_key_size, p_key_data);
	if(!p_e) { return NULL; }
	p_old_data = p_e->p_entry_data;
	p_e->p_entry_data = p_entry_data;
	return p_old_data;
}
/*--------------------------------------------------------------------------*/
//Remove an entry from the hash table.
void* ght_remove(ght_hash_table_t* p_ht, int i_key_size, const void* p_key_data) {
	ght_hash_entry_t* p_e;
	void* p_old_data;
	p_e = ght_search_in_bucket(p_ht, i_key_size, p_key_data);
	if(!p_e) { return NULL; }
	RemoveEntryList(&p_e->le_iterator);
	RemoveEntryList(&p_e->le_bucket);
	p_old_data = p_e->p_entry_data;
	if(p_ht->fn_free) {
		(*p_ht->fn_free)(p_e);
	} else {
		free(            p_e);	//'(p_ht->fn_free?p_ht->fn_free:free)(p_e)'͕słBleak_detector.hɂ֐ȗΏۂƂ邽߂ɁAmalloc/free𖼑OŎg킸Ɋ֐Ăяo`ŎgKvL܂Bڍׂ́Agarray.c'Wed Apr 20 10:51:26 JST 2016'̃RgQƂĉB
	}
	p_ht->i_size--;		//͕̏K{łB
	ght_check_rehash(p_ht);	//
	return p_old_data;
}
/*--------------------------------------------------------------------------*/
//Get the first entry in an iteration.
void* ght_first(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data/*NULL*/) {
	return ght_first_keysize(p_ht, p_iterator, pp_key_data, NULL);
}
void* ght_first_keysize(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data/*NULL*/, int* p_key_size/*NULL*/) {
	LIST_ENTRY* list_head = &p_ht->le_iterator;
	LIST_ENTRY* list_entry = list_head->Flink;
	p_iterator->le_next = list_entry;
	return ght_next_keysize(p_ht, p_iterator, pp_key_data, p_key_size);
}
/*--------------------------------------------------------------------------*/
//Get the next entry in an iteration.
void* ght_next(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data/*NULL*/) {
	return ght_next_keysize(p_ht, p_iterator, pp_key_data, NULL);
}
void* ght_next_keysize(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data/*NULL*/, int* p_key_size/*NULL*/) {
	LIST_ENTRY* list_head = &p_ht->le_iterator;
	LIST_ENTRY* list_entry = p_iterator->le_next;
	if(list_entry != list_head) {
		ght_hash_entry_t* p_e = CONTAINING_RECORD(list_entry, ght_hash_entry_t, le_iterator);
		p_iterator->le_next = list_entry->Flink;											//Ce[^͎̃m[hwĂ̂ŁACe[V̒œYm[hght_remove()ĂSłB
		if(pp_key_data) { *pp_key_data = p_e->key_data; }
		if(p_key_size) { *p_key_size = p_e->i_key_size; }
		return p_e->p_entry_data;
	}
	return NULL;
}
/*--------------------------------------------------------------------------*/
//Finalize (free) a hash table.
void ght_finalize(ght_hash_table_t* p_ht) {
	ght_iterator_t iterator;
	void* p_entry_data;
	const void* p_key_data;
	int i_key_size;
	for(p_entry_data = ght_first_keysize(p_ht, &iterator, &p_key_data, &i_key_size);
	    p_entry_data;
	    p_entry_data = ght_next_keysize( p_ht, &iterator, &p_key_data, &i_key_size)) { ght_remove(p_ht, i_key_size, p_key_data); }		//Ce[^͎̃m[hwĂ̂ŁACe[V̒œYm[hght_remove()ĂSłB
	free(p_ht->le_bucket);	//łp_ht->fn_alloc,p_ht->fn_freegpȂɒӂĉB
	free(p_ht);		//łp_ht->fn_alloc,p_ht->fn_freegpȂɒӂĉB
}
/*--------------------------------------------------------------------------*/
//Set the rehashing status of the table.
void ght_set_rehash(ght_hash_table_t* p_ht, int b_rehash) {
	p_ht->flag.b_rehash = b_rehash;
}
/*--------------------------------------------------------------------------*/
//Rehash the hash table.
void ght_rehash(ght_hash_table_t* p_ht, int i_table_size) {
	LIST_ENTRY* list_head = &p_ht->le_iterator;
	LIST_ENTRY* list_entry = list_head->Flink;
	int i, l_key;
	//Reallocate the new bucket with the new size.
	if(i_table_size < 1) { i_table_size = 1; }
	p_ht->i_table_size = i_table_size;
	p_ht->le_bucket = realloc(p_ht->le_bucket, sizeof(LIST_ENTRY) * i_table_size);	//łp_ht->fn_alloc,p_ht->fn_freegpȂɒӂĉB
	if(!p_ht->le_bucket) { DIE(); }
	for(i = 0; i < i_table_size; i++) { InitializeListHead(&p_ht->le_bucket[i]); }
	//Walk through all elements in the table and insert them into the new bucket.
	while(list_entry != list_head) {
		ght_hash_entry_t* p_e = CONTAINING_RECORD(list_entry, ght_hash_entry_t, le_iterator);
		l_key = ght_get_hash_value(p_ht, p_e->i_key_size, p_e->key_data);
		InsertHeadList(&p_ht->le_bucket[l_key], &p_e->le_bucket);	//LbVΉ̂߂ɁAoPbg̃Xgւ̒ǉʒu͐擪ɒǉ悤ɕύXB̃AvP[V̓oPbg̃Xg𒼐ڎQƂĂȂ̂ŁA̕ύXɂ̖݊͐Ȃ͂B
		list_entry = list_entry->Flink;
	}
}
/*--------------------------------------------------------------------------*/
//Enable or disable bounded buckets.
void ght_set_bounded_buckets(ght_hash_table_t* p_ht, int bucket_limit, void (*fn_bucket_free)(void* data, const void* key)) {
	if((bucket_limit < 0) ||
	  (!bucket_limit && fn_bucket_free)) { DIE(); }
	p_ht->bucket_limit = bucket_limit;
	p_ht->fn_bucket_free = fn_bucket_free;
}
/*--------------------------------------------------------------------------*/
//Set the allocation/freeing functions to use for a hash table.
void ght_set_alloc(ght_hash_table_t* p_ht, void* (*fn_alloc)(size_t size), void (*fn_free)(void* ptr)) {
	p_ht->fn_alloc = fn_alloc;
	p_ht->fn_free = fn_free;
}
