;
;	framuvia.s
;
;	P/ECE Signetics 2637 UVI(Universal Video Interface) Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sat Apr 30 13:14:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
;#define UVI_DEFINE_OFFSET
;#include "clipuvia.h"
;/
;/	clipuvia.h
;/
;/	P/ECE Signetics 2637 UVI(Universal Video Interface) Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2005 Naoyuki Sawa
;/
;/	* Sat Apr 30 13:14:00 JST 2005 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ ̃V{`ƁAAZuR[hgp܂B
;/ ̃V{`Ȃ΁AbR[hgp܂B
;#define UVI_ASM

;* clipuvia.sAframuvia.sincludê݁Aȉ̒`Lɂ܂B */
;#ifdef UVI_DEFINE_OFFSET
;****************************************************************************
;
;****************************************************************************

				; typedef struct _UVIOBJ {
;#define OBJ_SIZE	 0	; 	unsigned char size;				/* + 0,1: TCY (0=W,1=c2{g) */
;#define OBJ_COLOR	 1	; 	unsigned char color;				/* + 1,1: J[ */
;#define OBJ_RESV	 2	; 	short resv;					/* + 2,2: (\) */
;#define OBJ_X		 4	; 	short x;					/* + 4,2: XW */
;#define OBJ_Y		 6	; 	short y;					/* + 6,2: YW */
;#define OBJ_FONT	 8	; 	unsigned char* font/*[8]*/;			/* + 8,4: tHg */
;#define SIZEOF_UVIOBJ	12	; } UVIOBJ;						/* =12 */

				; typedef struct _UVI {
				; 	/*---------- Video ----------*/
;#define RAM		  0	; 	unsigned char* ram/*[0x400]*/;			/* +  0,  4: ORAMAWX^ */
;#define VBUFF		  4	; 	unsigned char* vbuff/*[128*208]*/;		/* +  4,  4: ݂̉z (NULL=`斳) */
;#define SCAN_START	  8	; 	short scan_start;				/* +  8,  2: ÕXLCʒu (`ԏ[  ) */
;#define SCAN_END	 10	; 	short scan_end;					/* + 10,  2: ݂̃XLCʒu (`ԉ[+1) */
;#define SCROLL_Y	 12	; 	short scroll_y;					/* + 12,  2: XN[ (t[P) */
;#define SCROLL_X	 14	; 	char  scroll_x[26/*Row*/];			/* + 14, 26: XN[ (-1:s擾A0..7:擾) */
;#define BG		 40	; 	unsigned short bg[26/*Row*/][16/*Col*/];	/* + 40,832: BG (000000cc0gffffff c=Color,g=GM,f=Code) */
;#define COLOR		872	; 	unsigned char color[4/*B7:6*/][2/*Font*/];	/* +872,  8: BGJ[ */
;#define POT		880	; 	unsigned char pot[4];				/* +880,  4: A/D Potentiometer */
;#define OBJ		884	; 	UVIOBJ obj[4];					/* +884, 48: OBJ1,OBJ2,OBJ3,OBJ4 */
				; 	/*---------- Sound ----------*/
;#define TONE_COUNT	932	; 	int tone_count;					/* +932,  4: Tone  isJE^ */
;#define NOISE_COUNT	936	; 	int noise_count;				/* +936,  4: Noise isJE^ */
;#define TONE_POLAR	940	; 	unsigned short tone_polar;			/* +940,  2: Tone  o͋ɐ */
;#define NOISE_LFSR	942	; 	unsigned short noise_lfsr;			/* +942,  2: Noise Linear Feedback Shift Register */
;#define SIZEOF_UVI	944	; } UVI;						/* =944 */

;****************************************************************************
;
;****************************************************************************
;#endif /*UVI_DEFINE_OFFSET*/
;#ifdef UVI_ASM

	.code
	.align	1

;****************************************************************************
;	֐ (Video)
;****************************************************************************

;
;	void uvi_reduce(unsigned char dst[/*88*128*/], const unsigned char src[/*128*208*/])
;
	.global	uvi_reduce
uvi_reduce:
	ld.w	%r4,0x8		; 	xld.w	%r4, 8				; %r4 = z = 8
uvi_reduce_DO_Z:				; do {
	ld.w	%r5,0x10	; 	xld.w	%r5, 16				;   %r5 = y = 16
	ld.w	%r6,0x1		; 	xld.w	%r6, 1				;   %r6 = i = 1
uvi_reduce_DO_Y:				;   do {
	sub	%r6,0x1		; 	xsub	%r6, %r6, 1			;     if(!--i) {
	jrne.d	uvi_reduce_DO_X1	; 	xjrne.d	uvi_reduce_DO_X1
	ld.w	%r7, 8				;     %r7 = x = 8 *delay*
	;---------------------------------------;
uvi_reduce_DO_X0:				;       do {
	;
	ld.w	%r10, [%r13]+			;         s      = *src++;				// s = [3][2][1][0]
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ; s >>= 8;	// s =    [3][2][1], out =  [0]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =       [3][2], t   =  [1]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =          [3], t   =  [1]+[2]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 2;		//                   out = ([1]+[2])/2
	srl	%r9,0x1		; 	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ;		//                   out =  [3]
	;
	ld.w	%r10, [%r13]+			;         s      = *src++;				// s = [7][6][5][4]
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =    [7][6][5], t   =  [4]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =       [7][6], t   =  [4]+[5]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 2;		//                   out = ([4]+[5])/2
	srl	%r9,0x1		; 	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ; s >>= 8;	// s =          [7], out =  [6]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ;		//                   t   =  [7]
	;
	ld.w	%r10, [%r13]+			;         s      = *src++;				// s = [B][A][9][8]
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =    [B][A][9], t   =  [7]+[8]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 2;		//                   out = ([7]+[8])/2
	srl	%r9,0x1		; 	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ; s >>= 8;	// s =       [B][A], out =  [9]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =          [B], t   =  [A]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ;		//                   t   =  [A]+[B]
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 2;		//                   out = ([A]+[B])/2
	srl	%r9,0x1		; 	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	;
	ld.w	%r10, [%r13]+			;         s      = *src++;				// s = [F][E][D][C]
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ; s >>= 8;	// s =    [F][E][D], out =  [C]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =       [F][E], t   =  [D]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =          [F], t   =  [D]+[E]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 2;		//                   out = ([D]+[E])/2
	srl	%r9,0x1		; 	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	ld.b	[%r12]+, %r10			;         *dst++ =                s    ;		//                   out =  [F]
	;
	sub	%r7,0x1		; 	xsub	%r7, %r7, 1			;       } while(--x)
	jrne	uvi_reduce_DO_X0	; 	xjrne	uvi_reduce_DO_X0
	jp.d	uvi_reduce_LOOP_Y	; 	xjp.d	uvi_reduce_LOOP_Y
	ld.w	%r6, 3				;       i = 3 *delay*
	;---------------------------------------;     } else {
uvi_reduce_DO_X1:				;       do {
	;
	ext	0x80		; 	xld.w	%r10, [%r13+0x80]		;         s      = src[128];
	ld.w	%r10,[%r13]
	ld.w	%r9, [%r13]+			;         s     += *src++;				// s = [3][2][1][0]
	add	%r10, %r9
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2; s >>= 8;	// s =    [3][2][1], out = ([0]    )/2
	srl	%r9,0x1		; 	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =       [3][2], t   =  [1]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =          [3], t   =  [1]+[2]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 4;		//                   out = ([1]+[2])/4
	srl	%r9,0x2		; 	xsrl	%r9, 2
	ld.b	[%r12]+, %r9
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2;		//                   out = ([3]    )/2
	srl	%r9,0x1		; 	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	;
	ext	0x80		; 	xld.w	%r10, [%r13+0x80]		;         s      = src[128];
	ld.w	%r10,[%r13]
	ld.w	%r9, [%r13]+			;         s     += *src++;				// s = [7][6][5][4]
	add	%r10, %r9
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =    [7][6][5], t   =  [4]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =       [7][6], t   =  [4]+[5]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 4;		//                   out = ([4]+[5])/4
	srl	%r9,0x2		; 	xsrl	%r9, 2
	ld.b	[%r12]+, %r9
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2; s >>= 8;	// s =          [7], out = ([6]    )/2
	srl	%r9,0x1		; 	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	ld.w	%r11, %r10			;         t      =                s    ;		//                   t   =  [7]
	;
	ext	0x80		; 	xld.w	%r10, [%r13+0x80]		;         s      = src[128];
	ld.w	%r10,[%r13]
	ld.w	%r9, [%r13]+			;         s     += *src++;				// s = [B][A][9][8]
	add	%r10, %r9
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =    [B][A][9], t   =  [7]+[8]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 4;		//                   out = ([7]+[8])/4
	srl	%r9,0x2		; 	xsrl	%r9, 2
	ld.b	[%r12]+, %r9
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2; s >>= 8;	// s =       [B][A], out = ([9]    )/2
	srl	%r9,0x1		; 	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =          [B], t   =  [A]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ;		//                   t   =  [A]+[B]
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 4;		//                   out = ([A]+[B])/4
	srl	%r9,0x2		; 	xsrl	%r9, 2
	ld.b	[%r12]+, %r9
	;
	ext	0x80		; 	xld.w	%r10, [%r13+0x80]		;         s      = src[128];
	ld.w	%r10,[%r13]
	ld.w	%r9, [%r13]+			;         s     += *src++;				// s = [F][E][D][C]
	add	%r10, %r9
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2; s >>= 8;	// s =    [F][E][D], out = ([C]    )/2
	srl	%r9,0x1		; 	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.w	%r11, %r10			;         t      =                s    ; s >>= 8;	// s =       [F][E], t   =  [D]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	add	%r11, %r10			;         t     +=                s    ; s >>= 8;	// s =          [F], t   =  [D]+[E]
	srl	%r10,0x8	; 	xsrl	%r10, 8
	ld.ub	%r9, %r11			;         *dst++ = (unsigned char)t / 4;		//                   out = ([D]+[E])/4
	srl	%r9,0x2		; 	xsrl	%r9, 2
	ld.b	[%r12]+, %r9
	ld.ub	%r9, %r10			;         *dst++ = (unsigned char)s / 2;		//                   out = ([F]    )/2
	srl	%r9,0x1		; 	xsrl	%r9, 1
	ld.b	[%r12]+, %r9
	;
	sub	%r7,0x1		; 	xsub	%r7, %r7, 1			;       } while(--x)
	jrne	uvi_reduce_DO_X1	; 	xjrne	uvi_reduce_DO_X1
	ext	0x2		; 	xadd	%r13, %r13, 128			;       src += 128
	add	%r13,0x0
	;---------------------------------------;     }
uvi_reduce_LOOP_Y:
	sub	%r5,0x1		; 	xsub	%r5, %r5, 1			;   } while(--y)
	ext	uvi_reduce_DO_Y@rm	; 	xjrne	uvi_reduce_DO_Y
	jrne	uvi_reduce_DO_Y@rl
	sub	%r4,0x1		; 	xsub	%r4, %r4, 1			; } while(--z)
	ext	uvi_reduce_DO_Z@rm	; 	xjrne	uvi_reduce_DO_Z
	jrne	uvi_reduce_DO_Z@rl
	ret

;****************************************************************************

;
;	void uvi_draw_chr_8x8(int x, int y, int code, int color)
;
	.global	uvi_draw_chr_8x8
uvi_draw_chr_8x8:
	ext	uvi+0x8@ah	; 	xld.h	%r4, [uvi+0x8]		; %r4 = uvi.scan_start
	ext	uvi+0x8@al
	ld.h	%r4,[%r8]
	ext	uvi+0xa@ah	; 	xld.h	%r5, [uvi+0xa]		; %r5 = uvi.scan_end
	ext	uvi+0xa@al
	ld.h	%r5,[%r8]
	;
	sub	%r4, 8				; if(y <= y_min-8) goto EXIT
	cmp	%r13, %r4
	jrle.d	uvi_draw_chr_8x8_EXIT	; 	xjrle.d	uvi_draw_chr_8x8_EXIT
	add	%r4, 8				; *delay*
	cmp	%r13, %r5			; if(y >= y_max) goto EXIT
	jrge	uvi_draw_chr_8x8_EXIT	; 	xjrge	uvi_draw_chr_8x8_EXIT
	cmp	%r12,0x38	; 	xcmp	%r12, -8			; if(x <= 0-8) goto EXIT
	jrle	uvi_draw_chr_8x8_EXIT	; 	xjrle	uvi_draw_chr_8x8_EXIT
	ext	0x2		; 	xcmp	%r12, 128			; if(x >= 128) goto EXIT
	cmp	%r12,0x0
	jrge	uvi_draw_chr_8x8_EXIT	; 	xjrge	uvi_draw_chr_8x8_EXIT
	;
	ext	uvi+0x4@ah	; 	xld.w	%r6, [uvi+0x4]		; %r6 = vbuff = &uvi.vbuff[y*128+x]
	ext	uvi+0x4@al
	ld.w	%r6,[%r8]
	sla	%r13,0x7	; 	xsla	%r13, 7
	add	%r6, %r13
	sra	%r13,0x7	; 	xsra	%r13, 7
	add	%r6, %r12
	;
	sll	%r14,0x3	; 	xsll	%r14, 3				; %r14 = font = &uvi_font[code*8]
	ext	uvi_font@ah
	ext	uvi_font@al
	add	%r14, %r14
	;
	sll	%r15,0x1	; 	xsll	%r15, 1				; %r15[ 7:0] = cs = uvi.color[color][0]
	ext	uvi+0x368@ah			; %r15[15:8] = cc = uvi.color[color][1]
	ext	uvi+0x368@al
	ld.uh	%r15, [%r15]
	;
	cmp	%r13, %r4			; if(y < y_min) goto CLIP
	jrlt	uvi_draw_chr_8x8_CLIP	; 	xjrlt	uvi_draw_chr_8x8_CLIP
	sub	%r5, 8				; if(y > y_max-8) goto CLIP
	cmp	%r13, %r5
	jrgt.d	uvi_draw_chr_8x8_CLIP	; 	xjrgt.d	uvi_draw_chr_8x8_CLIP
	add	%r5, 8				; *delay*
	ext	0x1		; 	xcmp	%r12, 0x78			; if((x < 0) || (x > 128-8)) goto CLIP
	cmp	%r12,0x38
	jrugt	uvi_draw_chr_8x8_CLIP	; 	xjrugt	uvi_draw_chr_8x8_CLIP
	;--------------------------------------------------------------------
uvi_draw_chr_8x8_FAST:
	ld.w	%r10,0x8	; 	xld.w	%r10, 8				; %r10 = iy = 8
uvi_draw_chr_8x8_FAST_DO_Y:			; do {
	ld.ub	%r7, [%r14]+			;   %r7 = v = *font++
	rr	%r7,0x8		; 	xrr	%r7, 8				;   %r7[31:24] = v
	ld.w	%r11,0x8	; 	xld.w	%r11, 8				;   %r11 = ix = 8
uvi_draw_chr_8x8_FAST_DO_X:			;   do {
	;
	add	%r7, %r7			;     %r9[7:0] = c = v[31]?cc:cs, v <<= 1
	jruge.d	3				;     (NonCarry)
	ld.w	%r9, %r15			;     *delay*
	srl	%r9, 8				;     (skip?)
	ld.b	[%r6]+, %r9			;     *vbuff++ = c
	;
	sub	%r11,0x1	; 	xsub	%r11, %r11, 1			;   } while(--ix)
	jrne	uvi_draw_chr_8x8_FAST_DO_X	; 	xjrne	uvi_draw_chr_8x8_FAST_DO_X
	ext	0x1		; 	xadd	%r6, %r6, 0x78			;   vbuff += 128-8
	add	%r6,0x38
	sub	%r10,0x1	; 	xsub	%r10, %r10, 1			; } while(--iy)
	jrne	uvi_draw_chr_8x8_FAST_DO_Y	; 	xjrne	uvi_draw_chr_8x8_FAST_DO_Y
	jp	uvi_draw_chr_8x8_EXIT	; 	xjp	uvi_draw_chr_8x8_EXIT
	;--------------------------------------------------------------------
uvi_draw_chr_8x8_CLIP:
	ld.w	%r10,0x8	; 	xld.w	%r10, 8				; %r10 = iy = 8
uvi_draw_chr_8x8_CLIP_DO_Y:			; do {
	cmp	%r13, %r4			;   if(y < y_min) goto SKIP_Y
	jrlt	uvi_draw_chr_8x8_CLIP_SKIP_Y	; 	xjrlt	uvi_draw_chr_8x8_CLIP_SKIP_Y
	cmp	%r13, %r5			;   if(y >= y_max) goto SKIP_Y
	jrge	uvi_draw_chr_8x8_CLIP_SKIP_Y	; 	xjrge	uvi_draw_chr_8x8_CLIP_SKIP_Y
	ld.ub	%r7, [%r14]			;   %r7 = v = *font
	rr	%r7,0x8		; 	xrr	%r7, 8				;   %r7[31:24] = v
	ld.w	%r11,0x8	; 	xld.w	%r11, 8				;   %r11 = ix = 8
uvi_draw_chr_8x8_CLIP_DO_X:			;   do {
	;
	ext	0x2		; 	xcmp	%r12, 128			;     if(x < 0 || x >= 128) goto SKIP_X
	cmp	%r12,0x0
	jruge.d	uvi_draw_chr_8x8_CLIP_SKIP_X	; 	xjruge.d uvi_draw_chr_8x8_CLIP_SKIP_X
	add	%r7, %r7			;     %r9[7:0] = c = v[31]?cc:cs, v <<= 1 *delay*
	jruge.d	3				;     (NonCarry)
	ld.w	%r9, %r15			;     *delay*
	srl	%r9, 8				;     (skip?)
	ld.b	[%r6], %r9			;     *vbuff = c
	;
uvi_draw_chr_8x8_CLIP_SKIP_X:
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			;     vbuff++
	sub	%r11,0x1	; 	xsub	%r11, %r11, 1			;   } while(--ix)
	jrne.d	uvi_draw_chr_8x8_CLIP_DO_X	; 	xjrne.d	uvi_draw_chr_8x8_CLIP_DO_X
	add	%r12, 1				;     x++ *delay*
	sub	%r6,0x8		; 	xsub	%r6, %r6, 8			;   vbuff -= 8
	sub	%r12,0x8	; 	xsub	%r12, %r12, 8			;   x -= 8
uvi_draw_chr_8x8_CLIP_SKIP_Y:
	ext	0x2		; 	xadd	%r6, %r6, 128			;   vbuff += 128
	add	%r6,0x0
	add	%r14,0x1	; 	xadd	%r14, %r14, 1			;   font++
	sub	%r10,0x1	; 	xsub	%r10, %r10, 1			; } while(--iy)
	jrne.d	uvi_draw_chr_8x8_CLIP_DO_Y	; 	xjrne.d	uvi_draw_chr_8x8_CLIP_DO_Y
	add	%r13, 1				;   y++ *delay*
	;--------------------------------------------------------------------
uvi_draw_chr_8x8_EXIT:
	ret

;****************************************************************************

;
;	void uvi_draw_obj_8x8(UVIOBJ* obj)
;
	.global	uvi_draw_obj_8x8
uvi_draw_obj_8x8:
	ld.w	%r15, %r12			; %r15 = obj
	ext	0x4		; 	xld.h	%r12, [%r15+0x4]		; %r12 = obj->xx
	ld.h	%r12,[%r15]
	ext	0x6		; 	xld.h	%r13, [%r15+0x6]		; %r13 = obj->yy
	ld.h	%r13,[%r15]
	ext	uvi+0x8@ah	; 	xld.h	%r4, [uvi+0x8]		; %r4  = uvi.scan_start
	ext	uvi+0x8@al
	ld.h	%r4,[%r8]
	ext	uvi+0xa@ah	; 	xld.h	%r5, [uvi+0xa]		; %r5  = uvi.scan_end
	ext	uvi+0xa@al
	ld.h	%r5,[%r8]
	;
	sub	%r4, 8				; if(y <= y_min-8) goto EXIT
	cmp	%r13, %r4
	jrle.d	uvi_draw_obj_8x8_EXIT	; 	xjrle.d	uvi_draw_obj_8x8_EXIT
	add	%r4, 8				; *delay*
	cmp	%r13, %r5			; if(y >= y_max) goto EXIT
	jrge	uvi_draw_obj_8x8_EXIT	; 	xjrge	uvi_draw_obj_8x8_EXIT
	cmp	%r12,0x38	; 	xcmp	%r12, -8			; if(x <= 0-8) goto EXIT
	jrle	uvi_draw_obj_8x8_EXIT	; 	xjrle	uvi_draw_obj_8x8_EXIT
	ext	0x2		; 	xcmp	%r12, 128			; if(x >= 128) goto EXIT
	cmp	%r12,0x0
	jrge	uvi_draw_obj_8x8_EXIT	; 	xjrge	uvi_draw_obj_8x8_EXIT
	;
	ext	uvi+0x4@ah	; 	xld.w	%r6, [uvi+0x4]		; %r6 = vbuff = &uvi.vbuff[y*128+x]
	ext	uvi+0x4@al
	ld.w	%r6,[%r8]
	sla	%r13,0x7	; 	xsla	%r13, 7
	add	%r6, %r13
	sra	%r13,0x7	; 	xsra	%r13, 7
	add	%r6, %r12
	;
	ext	0x8		; 	xld.w	%r14, [%r15+0x8]		; %r14 = font = obj->font
	ld.w	%r14,[%r15]
	;
	ext	0x1		; 	xld.ub	%r15, [%r15+0x1]		; %r15 = cc = obj->color
	ld.ub	%r15,[%r15]
	;
	cmp	%r13, %r4			; if(y < y_min) goto CLIP
	jrlt	uvi_draw_obj_8x8_CLIP	; 	xjrlt	uvi_draw_obj_8x8_CLIP
	sub	%r5, 8				; if(y > y_max-8) goto CLIP
	cmp	%r13, %r5
	jrgt.d	uvi_draw_obj_8x8_CLIP	; 	xjrgt.d	uvi_draw_obj_8x8_CLIP
	add	%r5, 8				; *delay*
	ext	0x1		; 	xcmp	%r12, 0x78			; if((x < 0) || (x > 128-8)) goto CLIP
	cmp	%r12,0x38
	jrugt	uvi_draw_obj_8x8_CLIP	; 	xjrugt	uvi_draw_obj_8x8_CLIP
	;--------------------------------------------------------------------
uvi_draw_obj_8x8_FAST:
	ld.w	%r10,0x8	; 	xld.w	%r10, 8				; %r10 = iy = 8
uvi_draw_obj_8x8_FAST_DO_Y:			; do {
	ld.ub	%r7, [%r14]+			;   %r7 = v = *font++
	rr	%r7,0x8		; 	xrr	%r7, 8				;   %r7[31:24] = v
	ld.w	%r11,0x8	; 	xld.w	%r11, 8				;   %r11 = ix = 8
uvi_draw_obj_8x8_FAST_DO_X:			;   do {
	;
	add	%r7, %r7			;     if(v[31]) { *vbuff = cc }, v <<= 1
	jruge	uvi_draw_obj_8x8_FAST_SKIP_X	; 	xjruge	uvi_draw_obj_8x8_FAST_SKIP_X	;     (NonCarry)
	ld.b	[%r6], %r15
	;
uvi_draw_obj_8x8_FAST_SKIP_X:
	sub	%r11,0x1	; 	xsub	%r11, %r11, 1			;   } while(--ix)
	jrne.d	uvi_draw_obj_8x8_FAST_DO_X	; 	xjrne.d	uvi_draw_obj_8x8_FAST_DO_X
	add	%r6, 1				;     vbuff++ *delay*
	ext	0x1		; 	xadd	%r6, %r6, 0x78			;   vbuff += 128-8
	add	%r6,0x38
	sub	%r10,0x1	; 	xsub	%r10, %r10, 1			; } while(--iy)
	jrne	uvi_draw_obj_8x8_FAST_DO_Y	; 	xjrne	uvi_draw_obj_8x8_FAST_DO_Y
	jp	uvi_draw_obj_8x8_EXIT	; 	xjp	uvi_draw_obj_8x8_EXIT
	;--------------------------------------------------------------------
uvi_draw_obj_8x8_CLIP:
	ld.w	%r10,0x8	; 	xld.w	%r10, 8				; %r10 = iy = 8
uvi_draw_obj_8x8_CLIP_DO_Y:			; do {
	cmp	%r13, %r4			;   if(y < y_min) goto SKIP_Y
	jrlt	uvi_draw_obj_8x8_CLIP_SKIP_Y	; 	xjrlt	uvi_draw_obj_8x8_CLIP_SKIP_Y
	cmp	%r13, %r5			;   if(y >= y_max) goto SKIP_Y
	jrge	uvi_draw_obj_8x8_CLIP_SKIP_Y	; 	xjrge	uvi_draw_obj_8x8_CLIP_SKIP_Y
	ld.ub	%r7, [%r14]			;   %r7 = v = *font
	rr	%r7,0x8		; 	xrr	%r7, 8				;   %r7[31:24] = v
	ld.w	%r11,0x8	; 	xld.w	%r11, 8				;   %r11 = ix = 8
uvi_draw_obj_8x8_CLIP_DO_X:			;   do {
	;
	ext	0x2		; 	xcmp	%r12, 128			;     if(x < 0 || x >= 128) goto SKIP_X
	cmp	%r12,0x0
	jruge.d	uvi_draw_obj_8x8_CLIP_SKIP_X	; 	xjruge.d uvi_draw_obj_8x8_CLIP_SKIP_X
	add	%r7, %r7			;     if(v[31]) { *vbuff = cc }, v <<= 1 *delay*
	jruge	uvi_draw_obj_8x8_CLIP_SKIP_X	; 	xjruge	uvi_draw_obj_8x8_CLIP_SKIP_X	;     (NonCarry)
	ld.b	[%r6], %r15
	;
uvi_draw_obj_8x8_CLIP_SKIP_X:
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			;     vbuff++
	sub	%r11,0x1	; 	xsub	%r11, %r11, 1			;   } while(--ix)
	jrne.d	uvi_draw_obj_8x8_CLIP_DO_X	; 	xjrne.d	uvi_draw_obj_8x8_CLIP_DO_X
	add	%r12, 1				;     x++ *delay*
	sub	%r6,0x8		; 	xsub	%r6, %r6, 8			;   vbuff -= 8
	sub	%r12,0x8	; 	xsub	%r12, %r12, 8			;   x -= 8
uvi_draw_obj_8x8_CLIP_SKIP_Y:
	ext	0x2		; 	xadd	%r6, %r6, 128			;   vbuff += 128
	add	%r6,0x0
	add	%r14,0x1	; 	xadd	%r14, %r14, 1			;   font++
	sub	%r10,0x1	; 	xsub	%r10, %r10, 1			; } while(--iy)
	jrne.d	uvi_draw_obj_8x8_CLIP_DO_Y	; 	xjrne.d	uvi_draw_obj_8x8_CLIP_DO_Y
	add	%r13, 1				;   y++ *delay*
	;--------------------------------------------------------------------
uvi_draw_obj_8x8_EXIT:
	ret

;****************************************************************************
;
;****************************************************************************

;#endif /*UVI_ASM*/
