;
;	framssma.s
;
;	P/ECE S-SMP (SPC700) Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Sun Jan 07 06:00:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clipssma.h"
;/
;/	clipssma.h
;/
;/	P/ECE S-SMP (SPC700) Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2004 Naoyuki Sawa
;/
;/	* Sun Jan 04 21:33:00 JST 2004 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ ̃V{`ƁAAZuR[hgp܂B
;/ ̃V{`Ȃ΁AbR[hgp܂B
;#define SSMP_ASM
;#ifdef SSMP_ASM

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

;
;	SSMP\
;
;*===== WX^ =====*/
;#define PSW	 0
;#define SP	 1
;#define PC	 2
;#define YA	 4
;#define A	 4
;#define Y	 5
;#define X	 6
;*=====  =====*/
;#define CYCLE	 8
;#define SLEEP	12
;*===== O֐ =====*/
;#define READ	16
;#define WRITE	20

;
;	C33=>S-SMPtOϊ\
;
				; C33(C,V,Z,N) => S-SMP(S,Z,V,C)
				; ====C33====     ===S-SMP===
ssmp_FLAG_CONV:			; ----CVZN        NV----ZC
	.byte	0x00		; 00000000 00     00000000 00
	.byte	0x80		; 00000001 01     10000000 80
	.byte	0x02		; 00000010 02     00000010 02
	.byte	0x82		; 00000011 03     10000010 82
	.byte	0x40		; 00000100 04     01000000 40
	.byte	0xc0		; 00000101 05     11000000 c0
	.byte	0x42		; 00000110 06     01000010 42
	.byte	0xc2		; 00000111 07     11000010 c2
	.byte	0x01		; 00001000 08     00000001 01
	.byte	0x81		; 00001001 09     10000001 81
	.byte	0x03		; 00001010 0a     00000011 03
	.byte	0x83		; 00001011 0b     10000011 83
	.byte	0x41		; 00001100 0c     01000001 41
	.byte	0xc1		; 00001101 0d     11000001 c1
	.byte	0x43		; 00001110 0e     01000011 43
	.byte	0xc3		; 00001111 0f     11000011 c3

;****************************************************************************
;
;****************************************************************************

	.align 2
ssmp_run_table:
	;===== operand bytes=0 =====
	.word ssmp_run_implied				;  0	/* A,X,Y,etc */
	.word ssmp_run_indirect				;  1	/* (X) */
	.word ssmp_run_indirect_auto_increment		;  2	/* (X)+ */
	.word ssmp_run_indirect_page_to_ip		;  3	/* (X),(Y) */
	;===== operand bytes=1 =====
	.word ssmp_run_inmediate_data			;  4	/* #inm */
	.word ssmp_run_direct_page			;  5	/* dp */
	.word ssmp_run_x_indexed_direct_page		;  6	/* dp+X */
	.word ssmp_run_y_indexed_direct_page		;  7	/* dp+Y */
	.word ssmp_run_x_indexed_indirect		;  8	/* (dp+X) */
	.word ssmp_run_indirect_y_indexed_indirect	;  9	/* (dp)+Y */
	.word ssmp_run_relative				; 10	/* rel */
	;===== operand bytes=2 =====
	.word ssmp_run_direct_page_to_dp		; 11	/* dp(d),dp(s) */
	.word ssmp_run_inmediate_data_to_dp		; 12	/* dp,#inm */
	.word ssmp_run_direct_page_relative		; 13	/* dp,rel */
	.word ssmp_run_absolute_boolean_bit		; 14	/* mem.bit */
	.word ssmp_run_absolute				; 15	/* labs */
	.word ssmp_run_x_indexed_absolute		; 16	/* labs+X */
	.word ssmp_run_y_indexed_absolute		; 17	/* labs+Y */
	.word ssmp_run_x_indexed_absolute_indirect	; 18	/* (labs+X) */
	.word ssmp_run_x_indexed_direct_page_relative	; 19	/* dp+X,rel */
	.align 1

;****************************************************************************

;* (X) */
;#macro INDIRECT
;	xld.ub %r14, [%r0+X]		; %r14 = X
	;
;	xbtst [%r0+PSW], 5		; if(P) %r14 |= 0x100
;	xjreq ssmp_run_exec		; !NO-DELAY!
;	xoor %r14, %r14, 0x100
;	xjp ssmp_run_exec		; !NO-DELAY!
;#endm

;* (X)+ */
;#macro INDIRECT_AUTO_INCREMENT
;	xld.ub %r14, [%r0+X]		; %r14 = X
;	xadd %r10, %r14, 1		; X++ (extނINTERLOCKȂ?)
;	xld.b [%r0+X], %r10
	;
;	xbtst [%r0+PSW], 5		; if(P) %r14 |= 0x100
;	xjreq ssmp_run_exec		; !NO-DELAY!
;	xoor %r14, %r14, 0x100
;	xjp ssmp_run_exec		; !NO-DELAY!
;#endm

;* (X),(Y) */
;#macro INDIRECT_PAGE_TO_IP
;	xld.ub %r14, [%r0+X]		; %r14 = X
;	xld.ub %r15, [%r0+Y]		; %r15 = Y
	;
;	xbtst [%r0+PSW], 5		; if(P) %r14 |= 0x100, %r15 |= 0x100
;	xjreq ssmp_run_exec		; !NO-DELAY!
;	xoor %r14, %r14, 0x100
;	xoor %r15, %r15, 0x100
;	xjp ssmp_run_exec		; !NO-DELAY!
;#endm

;* #inm */
;#macro INMEDIATE_DATA
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r14 = #inm
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	ld.ub %r14, %r10
	;
;	xld.ub %r13, [%sp+0]		; (restore code)
;	xjp.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;#endm

;* dp */
;#macro DIRECT_PAGE
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r14 = dp
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	ld.w %r14, %r10
	;
;	xld.ub %r13, [%sp+0]		; (restore code)
	;
;	xbtst [%r0+PSW], 5		; if(P) %r14 |= 0x100
;	xjreq.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;	xoor %r14, %r14, 0x100
;	xjp ssmp_run_exec		; !NO-DELAY!
;#endm

;* dp+X */
;#macro X_INDEXED_DIRECT_PAGE
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = dp
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r14, [%r0+X]		; %r14 = dp+X
;	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
;	add %r14, %r10
;	ld.ub %r14, %r14
	;
;	xbtst [%r0+PSW], 5		; if(P) %r14 |= 0x100
;	xjreq.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;	xoor %r14, %r14, 0x100
;	xjp ssmp_run_exec		; !NO-DELAY!
;#endm

;* dp+Y */
;#macro Y_INDEXED_DIRECT_PAGE
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = dp
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r14, [%r0+Y]		; %r14 = dp+Y
;	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
;	add %r14, %r10
;	ld.ub %r14, %r14
	;
;	xbtst [%r0+PSW], 5		; if(P) %r14 |= 0x100
;	xjreq.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;	xoor %r14, %r14, 0x100
;	xjp ssmp_run_exec		; !NO-DELAY!
;#endm

;* (dp+X) */
;#macro X_INDEXED_INDIRECT
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = dp
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r13, [%r0+X]		; %r13 = dp+X+0
;	xld.w %r14, 1			; *anti-interlock*
;	add %r13, %r10
;	add %r14, %r13			; %r14 = dp+X+1
;	ld.ub %r13, %r13
;	ld.ub %r14, %r14
;	xbtst [%r0+PSW], 5		; if(P) %r13 |= 0x100, %r14 |= 0x100
;	xjreq $$1			; !NO-DELAY!
;	xoor %r13, %r13, 0x100
;	xoor %r14, %r14, 0x100
;$$1:
;	xld.h [%sp+2], %r14		; (save dp+X+1)
	;
;	call.d %r3			; %r10 = (dp+X+0)
;	ld.w %r12, %r0			; *delay*
;	xld.b [%sp+1], %r10		; (save (dp+X+0))
	;
;	xld.uh %r13, [%sp+2]		; (restore dp+X+1)
;	call.d %r3			; %r10 = (dp+X+1)
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r14, [%sp+1]		; (restore (dp+X+0))
;	xsll %r10, 8			; %r14 = (dp+X)
;	or %r14, %r10
	;
;	xld.ub %r13, [%sp+0]		; (restore code)
;	xjp.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;#endm

;* (dp)+Y */
;#macro INDIRECT_Y_INDEXED_INDIRECT
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = dp
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
	;
;	ld.w %r13, %r10			; %r13 = dp+0
;	xadd %r10, %r10, 1		; %r14 = dp+1
;	ld.ub %r14, %r10
;	xbtst [%r0+PSW], 5		; if(P) %r13 |= 0x100, %r14 |= 0x100
;	xjreq $$1			; !NO-DELAY!
;	xoor %r13, %r13, 0x100
;	xoor %r14, %r14, 0x100
;$$1:
;	xld.h [%sp+2], %r14		; (save dp+1)
	;
;	call.d %r3			; %r10 = (dp+0)
;	ld.w %r12, %r0			; *delay*
;	xld.b [%sp+1], %r10		; (save (dp+0))
	;
;	xld.uh %r13, [%sp+2]		; (restore dp+1)
;	call.d %r3			; %r10 = (dp+1)
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r14, [%sp+1]		; (restore (dp+0))
;	xsll %r10, 8			; %r14 = (dp)+Y
;	xld.ub %r11, [%r0+Y]
;	or %r14, %r10			; *anti-interlock*
;	add %r14, %r11
;	ld.uh %r14, %r14
	;
;	xld.ub %r13, [%sp+0]		; (restore code)
;	xjp.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;#endm

;* rel */
;#macro RELATIVE
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r13 = rel
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	xadd %r1, %r1, 1		; PC++
	;
;	ld.b %r14, %r10			; %r14 = PC + (char)rel
;	add %r14, %r1
;	ld.uh %r14, %r14
	;
;	xld.ub %r13, [%sp+0]		; (restore code)
;	xjp ssmp_run_exec		; !NO-DELAY!
;#endm

;* dp(d),dp(s) */
;#macro DIRECT_PAGE_TO_DP
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = dp(s)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	xadd %r1, %r1, 1		; PC++
;	xld.b [%sp+1], %r10		; (save dp(s))
	;
;	ld.uh %r13, %r1			; %r14 = dp(d)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	ld.w %r14, %r10
	;
;	xld.ub %r15, [%sp+1]		; (restore dp(s))
;	xld.ub %r13, [%sp+0]		; (restore code)
	;
;	xbtst [%r0+PSW], 5		; if(P) %r14 |= 0x100, %r15 |= 0x100
;	xjreq.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;	xoor %r14, %r14, 0x100
;	xoor %r15, %r15, 0x100
;	xjp ssmp_run_exec		; !NO-DELAY!
;#endm

;* dp,#inm */
;#macro INMEDIATE_DATA_TO_DP
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = #inm
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	xadd %r1, %r1, 1		; PC++
;	xld.b [%sp+1], %r10		; (save #inm)
	;
;	ld.uh %r13, %r1			; %r14 = dp
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	ld.w %r14, %r10
	;
;	xld.ub %r15, [%sp+1]		; (restore #inm)
;	xld.ub %r13, [%sp+0]		; (restore code)
	;
;	xbtst [%r0+PSW], 5		; if(P) %r14 |= 0x100
;	xjreq.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;	xoor %r14, %r14, 0x100
;	xjp ssmp_run_exec		; !NO-DELAY!
;#endm

;* dp,rel */
;#macro DIRECT_PAGE_RELATIVE
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = dp
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	xadd %r1, %r1, 1		; PC++
;	xld.b [%sp+1], %r10		; (save dp)
	;
;	ld.uh %r13, %r1			; %r10 = rel
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	xadd %r1, %r1, 1		; PC++
	;
;	ld.b %r15, %r10			; %r15 = PC + (char)rel
;	add %r15, %r1
;	ld.uh %r15, %r15
	;
;	xld.ub %r14, [%sp+1]		; (restore dp)
;	xld.ub %r13, [%sp+0]		; (restore code)
	;
;	xbtst [%r0+PSW], 5		; if(P) %r14 |= 0x100
;	xjreq ssmp_run_exec		; !NO-DELAY!
;	xoor %r14, %r14, 0x100
;	xjp ssmp_run_exec		; !NO-DELAY!
;#endm

;* mem.bit */
;#macro ABSOLUTE_BOOLEAN_BIT
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = LO(mem.bit)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	xadd %r1, %r1, 1		; PC++
;	xld.b [%sp+1], %r10		; (save LO(mem.bit))
	;
;	ld.uh %r13, %r1			; %r10 = HI(mem.bit)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r14, [%sp+1]		; (restore LO(mem.bit))
;	xld.ub %r13, [%sp+0]		; (restore code) *anti-interlock*
	;
;	ld.w %r15, %r14			; %r15 = bit
;	xsrl %r15, 5
;	xand %r14, %r14, 0x1f		; %r14 = mem
;	xsll %r14, 8
;	or %r14, %r10
	;
;	xjp.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;#endm

;* labs */
;#macro ABSOLUTE
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = LO(labs)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	xadd %r1, %r1, 1		; PC++
;	xld.b [%sp+1], %r10		; (save LO(labs))
	;
;	ld.uh %r13, %r1			; %r10 = HI(labs)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r14, [%sp+1]		; (restore LO(labs))
;	xsll %r10, 8			; %r14 = labs
;	or %r14, %r10
	;
;	xld.ub %r13, [%sp+0]		; (restore code)
;	xjp.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;#endm

;* labs+X */
;#macro X_INDEXED_ABSOLUTE
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = LO(labs)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	xadd %r1, %r1, 1		; PC++
;	xld.b [%sp+1], %r10		; (save LO(labs))
	;
;	ld.uh %r13, %r1			; %r10 = HI(labs)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r14, [%sp+1]		; (restore LO(labs))
;	xld.ub %r11, [%r0+X]		; %r14 = labs+X
;	xsll %r10, 8
;	or %r14, %r10
;	add %r14, %r11
;	ld.uh %r14, %r14
	;
;	xld.ub %r13, [%sp+0]		; (restore code)
;	xjp.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;#endm

;* labs+Y */
;#macro Y_INDEXED_ABSOLUTE
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = LO(labs)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	xadd %r1, %r1, 1		; PC++
;	xld.b [%sp+1], %r10		; (save LO(labs))
	;
;	ld.uh %r13, %r1			; %r10 = HI(labs)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r14, [%sp+1]		; (restore LO(labs))
;	xld.ub %r11, [%r0+Y]		; %r14 = labs+Y
;	xsll %r10, 8
;	or %r14, %r10
;	add %r14, %r11
;	ld.uh %r14, %r14
	;
;	xld.ub %r13, [%sp+0]		; (restore code)
;	xjp.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;#endm

;* (labs+X) */
;#macro X_INDEXED_ABSOLUTE_INDIRECT
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = LO(labs)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	xadd %r1, %r1, 1		; PC++
;	xld.b [%sp+1], %r10		; (save LO(labs))
	;
;	ld.uh %r13, %r1			; %r10 = HI(labs)
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r13, [%sp+1]		; (restore LO(labs))
;	xld.ub %r11, [%r0+X]		; %r13 = labs+X+0
;	xsll %r10, 8
;	or %r13, %r10
;	add %r13, %r11
;	ld.uh %r13, %r13
;	xadd %r14, %r13, 1		; %r14 = labs+X+1
;	xld.h [%sp+2], %r14		; (save labs+X+1)
	;
;	call.d %r3			; %r10 = (labs+X+0)
;	ld.w %r12, %r0			; *delay*
;	xld.b [%sp+1], %r10		; (save (labs+X+0))
;	xld.uh %r13, [%sp+2]		; (restore labs+X+1)
;	call.d %r3			; %r10 = (labs+X+1)
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r14, [%sp+1]		; (restore (labs+X+0))
;	xsll %r10, 8			; %r14 = (labs+X)
;	or %r14, %r10
	;
;	xld.ub %r13, [%sp+0]		; (restore code)
;	xjp.d ssmp_run_exec
;	add %r1, 1			; PC++ *delay*
;#endm

;* dp+X,rel */
;#macro X_INDEXED_DIRECT_PAGE_RELATIVE
;	xld.b [%sp+0], %r13		; (save code)
	;
;	ld.uh %r13, %r1			; %r10 = dp
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
	;
;	xld.ub %r11, [%r0+X]		; %r10 = dp+X
;	xadd %r1, %r1, 1		; PC++ *anti-interlock*
;	add %r10, %r11
;	xld.b [%sp+1], %r10		; (save dp+X)
	;
;	ld.uh %r13, %r1			; %r10 = rel
;	call.d %r3
;	ld.w %r12, %r0			; *delay*
;	xadd %r1, %r1, 1		; PC++
	;
;	ld.b %r15, %r10			; %r15 = PC + (char)rel
;	add %r15, %r1
;	ld.uh %r15, %r15
	;
;	xld.ub %r14, [%sp+1]		; (restore dp+X)
;	xld.ub %r13, [%sp+0]		; (restore code)
	;
;	xbtst [%r0+PSW], 5		; if(P) %r14 |= 0x100
;	xjreq ssmp_run_exec		; !NO-DELAY!
;	xoor %r14, %r14, 0x100
;	xjp ssmp_run_exec		; !NO-DELAY!
;#endm

;****************************************************************************

	.global ssmp_run
ssmp_run:
	pushn %r3
	sub	%sp,0x1		; 	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; ssmp
	ext	0x10		; 	xld.w %r3, [%r0+0x10]		; ssmp->read
	ld.w	%r3,[%r0]
	ext	0x8		; 	xld.w [%r0+0x8], %r13		; CYCLE
	ld.w	[%r0],%r13
	cmp	%r13,0x0	; 	xcmp %r13, 0			; if(CYCLE <= 0) break
	ext	ssmp_run_exit@rm	; 	xjrle ssmp_run_exit
	jrle	ssmp_run_exit@rl
	;
ssmp_run_L10:
	ext	0xc		; 	xld.ub %r10, [%r0+0xc]	; if(SLEEP) break
	ld.ub	%r10,[%r0]
	ext	0x2		; 	xld.uh %r1, [%r0+0x2]		; PC *anti-interlock*
	ld.uh	%r1,[%r0]
	cmp	%r10,0x0	; 	xcmp %r10, 0
	ext	ssmp_run_exit@rm	; 	xjrne ssmp_run_exit
	jrne	ssmp_run_exit@rl
	;
	ld.uh %r13, %r1			; code = ssmp->read(ssmp, PC++)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.ub %r13, %r10
	;
	ext	ssmp_op_table+0x0@h	; 	xld.w %r2, ssmp_op_table	; op = &ssmp_op_table[code]
	ext	ssmp_op_table+0x0@m
	ld.w	%r2,ssmp_op_table+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; switch(op->addr)
	ld.ub	%r10,[%r2]
	ext	ssmp_run_table+0x0@h	; 	xld.w %r11, ssmp_run_table	; *anti-interlock*
	ext	ssmp_run_table+0x0@m
	ld.w	%r11,ssmp_run_table+0x0@l
	sll	%r10,0x2	; 	xsll %r10, 2
	add %r10, %r11
	ld.w	%r10,[%r10]	; 	xld.w %r10, [%r10]
	add %r1, 1			; *anti-interlock*
	jp %r10
	;
	; "xjp/xjr?? ssmp_run_exec"̋+-256oCgɎ܂΁AextgsvɂȂAł܂B
	; gppx̍̂ssmp_run_execɋ߂Ȃ悤Agppx~(悭ĝقǉ)ŕׂ܂B
	;
ssmp_run_x_indexed_direct_page_relative:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	X_INDEXED_DIRECT_PAGE_RELATIVE
	;
	ld.uh %r13, %r1			; %r10 = dp
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x6		; 	xld.ub %r11, [%r0+0x6]		; %r10 = dp+X
	ld.ub	%r11,[%r0]
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++ *anti-interlock*
	add %r10, %r11
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save dp+X)
	;
	ld.uh %r13, %r1			; %r10 = rel
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b %r15, %r10			; %r15 = PC + (char)rel
	add %r15, %r1
	ld.uh %r15, %r15
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore dp+X)
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	;
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r14 |= 0x100
	ext	ssmp_run_exec@rm	; 	xjreq ssmp_run_exec		; !NO-DELAY!
	jreq	ssmp_run_exec@rl
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
	ext	ssmp_run_exec@rm	; 	xjp ssmp_run_exec		; !NO-DELAY!
	jp	ssmp_run_exec@rl
ssmp_run_x_indexed_absolute_indirect:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	X_INDEXED_ABSOLUTE_INDIRECT
	;
	ld.uh %r13, %r1			; %r10 = LO(labs)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save LO(labs))
	;
	ld.uh %r13, %r1			; %r10 = HI(labs)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r13,[%sp+0x1]	; 	xld.ub %r13, [%sp+0x1]		; (restore LO(labs))
	ext	0x6		; 	xld.ub %r11, [%r0+0x6]		; %r13 = labs+X+0
	ld.ub	%r11,[%r0]
	sll	%r10,0x8	; 	xsll %r10, 8
	or %r13, %r10
	add %r13, %r11
	ld.uh %r13, %r13
	ext	0x1		; 	xadd %r14, %r13, 1		; %r14 = labs+X+1
	add	%r14,%r13
	ld.h	[%sp+0x1],%r14	; 	xld.h [%sp+0x2], %r14		; (save labs+X+1)
	;
	call.d %r3			; %r10 = (labs+X+0)
	ld.w %r12, %r0			; *delay*
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save (labs+X+0))
	ld.uh	%r13,[%sp+0x1]	; 	xld.uh %r13, [%sp+0x2]		; (restore labs+X+1)
	call.d %r3			; %r10 = (labs+X+1)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore (labs+X+0))
	sll	%r10,0x8	; 	xsll %r10, 8			; %r14 = (labs+X)
	or %r14, %r10
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	ssmp_run_exec@rm	; 	xjp.d ssmp_run_exec
	jp.d	ssmp_run_exec@rl
	add %r1, 1			; PC++ *delay*
ssmp_run_y_indexed_absolute:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	Y_INDEXED_ABSOLUTE
	;
	ld.uh %r13, %r1			; %r10 = LO(labs)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save LO(labs))
	;
	ld.uh %r13, %r1			; %r10 = HI(labs)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore LO(labs))
	ext	0x5		; 	xld.ub %r11, [%r0+0x5]		; %r14 = labs+Y
	ld.ub	%r11,[%r0]
	sll	%r10,0x8	; 	xsll %r10, 8
	or %r14, %r10
	add %r14, %r11
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	ssmp_run_exec@rm	; 	xjp.d ssmp_run_exec
	jp.d	ssmp_run_exec@rl
	add %r1, 1			; PC++ *delay*
ssmp_run_x_indexed_absolute:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	X_INDEXED_ABSOLUTE
	;
	ld.uh %r13, %r1			; %r10 = LO(labs)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save LO(labs))
	;
	ld.uh %r13, %r1			; %r10 = HI(labs)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore LO(labs))
	ext	0x6		; 	xld.ub %r11, [%r0+0x6]		; %r14 = labs+X
	ld.ub	%r11,[%r0]
	sll	%r10,0x8	; 	xsll %r10, 8
	or %r14, %r10
	add %r14, %r11
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	ssmp_run_exec@rm	; 	xjp.d ssmp_run_exec
	jp.d	ssmp_run_exec@rl
	add %r1, 1			; PC++ *delay*
ssmp_run_absolute:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	ABSOLUTE
	;
	ld.uh %r13, %r1			; %r10 = LO(labs)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save LO(labs))
	;
	ld.uh %r13, %r1			; %r10 = HI(labs)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore LO(labs))
	sll	%r10,0x8	; 	xsll %r10, 8			; %r14 = labs
	or %r14, %r10
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	ssmp_run_exec@rm	; 	xjp.d ssmp_run_exec
	jp.d	ssmp_run_exec@rl
	add %r1, 1			; PC++ *delay*
ssmp_run_absolute_boolean_bit:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	ABSOLUTE_BOOLEAN_BIT
	;
	ld.uh %r13, %r1			; %r10 = LO(mem.bit)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save LO(mem.bit))
	;
	ld.uh %r13, %r1			; %r10 = HI(mem.bit)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore LO(mem.bit))
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	;
	ld.w %r15, %r14			; %r15 = bit
	srl	%r15,0x5	; 	xsrl %r15, 5
	and	%r14,0x1f	; 	xand %r14, %r14, 0x1f		; %r14 = mem
	sll	%r14,0x8	; 	xsll %r14, 8
	or %r14, %r10
	;
	ext	ssmp_run_exec@rm	; 	xjp.d ssmp_run_exec
	jp.d	ssmp_run_exec@rl
	add %r1, 1			; PC++ *delay*
ssmp_run_direct_page_relative:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	DIRECT_PAGE_RELATIVE
	;
	ld.uh %r13, %r1			; %r10 = dp
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save dp)
	;
	ld.uh %r13, %r1			; %r10 = rel
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b %r15, %r10			; %r15 = PC + (char)rel
	add %r15, %r1
	ld.uh %r15, %r15
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore dp)
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	;
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r14 |= 0x100
	ext	ssmp_run_exec@rm	; 	xjreq ssmp_run_exec		; !NO-DELAY!
	jreq	ssmp_run_exec@rl
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
	ext	ssmp_run_exec@rm	; 	xjp ssmp_run_exec		; !NO-DELAY!
	jp	ssmp_run_exec@rl
ssmp_run_inmediate_data_to_dp:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	INMEDIATE_DATA_TO_DP
	;
	ld.uh %r13, %r1			; %r10 = #inm
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save #inm)
	;
	ld.uh %r13, %r1			; %r14 = dp
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.w %r14, %r10
	;
	ld.ub	%r15,[%sp+0x1]	; 	xld.ub %r15, [%sp+0x1]		; (restore #inm)
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	;
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r14 |= 0x100
	ext	ssmp_run_exec@rm	; 	xjreq.d ssmp_run_exec
	jreq.d	ssmp_run_exec@rl
	add %r1, 1			; PC++ *delay*
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
	ext	ssmp_run_exec@rm	; 	xjp ssmp_run_exec		; !NO-DELAY!
	jp	ssmp_run_exec@rl
ssmp_run_direct_page_to_dp:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	DIRECT_PAGE_TO_DP
	;
	ld.uh %r13, %r1			; %r10 = dp(s)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save dp(s))
	;
	ld.uh %r13, %r1			; %r14 = dp(d)
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.w %r14, %r10
	;
	ld.ub	%r15,[%sp+0x1]	; 	xld.ub %r15, [%sp+0x1]		; (restore dp(s))
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	;
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r14 |= 0x100, %r15 |= 0x100
	ext	ssmp_run_exec@rm	; 	xjreq.d ssmp_run_exec
	jreq.d	ssmp_run_exec@rl
	add %r1, 1			; PC++ *delay*
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
	ext	0x4		; 	xoor %r15, %r15, 0x100
	or	%r15,0x0
	ext	ssmp_run_exec@rm	; 	xjp ssmp_run_exec		; !NO-DELAY!
	jp	ssmp_run_exec@rl
ssmp_run_relative:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	RELATIVE
	;
	ld.uh %r13, %r1			; %r13 = rel
	call.d %r3
	ld.w %r12, %r0			; *delay*
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; PC++
	;
	ld.b %r14, %r10			; %r14 = PC + (char)rel
	add %r14, %r1
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	ext	ssmp_run_exec@rm	; 	xjp ssmp_run_exec		; !NO-DELAY!
	jp	ssmp_run_exec@rl
ssmp_run_indirect_y_indexed_indirect:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	INDIRECT_Y_INDEXED_INDIRECT
	;
	ld.uh %r13, %r1			; %r10 = dp
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r13, %r10			; %r13 = dp+0
	add	%r10,0x1	; 	xadd %r10, %r10, 1		; %r14 = dp+1
	ld.ub %r14, %r10
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r13 |= 0x100, %r14 |= 0x100
	jreq	__LX0001	; 	xjreq __L0001			; !NO-DELAY!
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
__LX0001:				; __L0001:
	ld.h	[%sp+0x1],%r14	; 	xld.h [%sp+0x2], %r14		; (save dp+1)
	;
	call.d %r3			; %r10 = (dp+0)
	ld.w %r12, %r0			; *delay*
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save (dp+0))
	;
	ld.uh	%r13,[%sp+0x1]	; 	xld.uh %r13, [%sp+0x2]		; (restore dp+1)
	call.d %r3			; %r10 = (dp+1)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore (dp+0))
	sll	%r10,0x8	; 	xsll %r10, 8			; %r14 = (dp)+Y
	ext	0x5		; 	xld.ub %r11, [%r0+0x5]
	ld.ub	%r11,[%r0]
	or %r14, %r10			; *anti-interlock*
	add %r14, %r11
	ld.uh %r14, %r14
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	ssmp_run_exec	; 	xjp.d ssmp_run_exec
	add %r1, 1			; PC++ *delay*
ssmp_run_x_indexed_indirect:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	X_INDEXED_INDIRECT
	;
	ld.uh %r13, %r1			; %r10 = dp
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x6		; 	xld.ub %r13, [%r0+0x6]		; %r13 = dp+X+0
	ld.ub	%r13,[%r0]
	ld.w	%r14,0x1	; 	xld.w %r14, 1			; *anti-interlock*
	add %r13, %r10
	add %r14, %r13			; %r14 = dp+X+1
	ld.ub %r13, %r13
	ld.ub %r14, %r14
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r13 |= 0x100, %r14 |= 0x100
	jreq	__LX0002	; 	xjreq __L0002			; !NO-DELAY!
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
__LX0002:				; __L0002:
	ld.h	[%sp+0x1],%r14	; 	xld.h [%sp+0x2], %r14		; (save dp+X+1)
	;
	call.d %r3			; %r10 = (dp+X+0)
	ld.w %r12, %r0			; *delay*
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save (dp+X+0))
	;
	ld.uh	%r13,[%sp+0x1]	; 	xld.uh %r13, [%sp+0x2]		; (restore dp+X+1)
	call.d %r3			; %r10 = (dp+X+1)
	ld.w %r12, %r0			; *delay*
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore (dp+X+0))
	sll	%r10,0x8	; 	xsll %r10, 8			; %r14 = (dp+X)
	or %r14, %r10
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	ssmp_run_exec	; 	xjp.d ssmp_run_exec
	add %r1, 1			; PC++ *delay*
ssmp_run_y_indexed_direct_page:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	Y_INDEXED_DIRECT_PAGE
	;
	ld.uh %r13, %r1			; %r10 = dp
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x5		; 	xld.ub %r14, [%r0+0x5]		; %r14 = dp+Y
	ld.ub	%r14,[%r0]
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.ub %r14, %r14
	;
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r14 |= 0x100
	jreq.d	ssmp_run_exec	; 	xjreq.d ssmp_run_exec
	add %r1, 1			; PC++ *delay*
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
	jp	ssmp_run_exec	; 	xjp ssmp_run_exec		; !NO-DELAY!
ssmp_run_x_indexed_direct_page:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	X_INDEXED_DIRECT_PAGE
	;
	ld.uh %r13, %r1			; %r10 = dp
	call.d %r3
	ld.w %r12, %r0			; *delay*
	;
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]		; %r14 = dp+X
	ld.ub	%r14,[%r0]
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code) *anti-interlock*
	add %r14, %r10
	ld.ub %r14, %r14
	;
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r14 |= 0x100
	jreq.d	ssmp_run_exec	; 	xjreq.d ssmp_run_exec
	add %r1, 1			; PC++ *delay*
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
	jp	ssmp_run_exec	; 	xjp ssmp_run_exec		; !NO-DELAY!
ssmp_run_direct_page:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	DIRECT_PAGE
	;
	ld.uh %r13, %r1			; %r14 = dp
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.w %r14, %r10
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	;
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r14 |= 0x100
	jreq.d	ssmp_run_exec	; 	xjreq.d ssmp_run_exec
	add %r1, 1			; PC++ *delay*
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
	jp	ssmp_run_exec	; 	xjp ssmp_run_exec		; !NO-DELAY!
ssmp_run_inmediate_data:
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)	; 	INMEDIATE_DATA
	;
	ld.uh %r13, %r1			; %r14 = #inm
	call.d %r3
	ld.w %r12, %r0			; *delay*
	ld.ub %r14, %r10
	;
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
	jp.d	ssmp_run_exec	; 	xjp.d ssmp_run_exec
	add %r1, 1			; PC++ *delay*
ssmp_run_indirect_page_to_ip:
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]		; %r14 = X	; 	INDIRECT_PAGE_TO_IP
	ld.ub	%r14,[%r0]
	ext	0x5		; 	xld.ub %r15, [%r0+0x5]		; %r15 = Y
	ld.ub	%r15,[%r0]
	;
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r14 |= 0x100, %r15 |= 0x100
	jreq	ssmp_run_exec	; 	xjreq ssmp_run_exec		; !NO-DELAY!
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
	ext	0x4		; 	xoor %r15, %r15, 0x100
	or	%r15,0x0
	jp	ssmp_run_exec	; 	xjp ssmp_run_exec		; !NO-DELAY!
ssmp_run_indirect_auto_increment:
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]		; %r14 = X	; 	INDIRECT_AUTO_INCREMENT
	ld.ub	%r14,[%r0]
	ext	0x1		; 	xadd %r10, %r14, 1		; X++ (extނINTERLOCKȂ?)
	add	%r10,%r14
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r14 |= 0x100
	jreq	ssmp_run_exec	; 	xjreq ssmp_run_exec		; !NO-DELAY!
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
	jp	ssmp_run_exec	; 	xjp ssmp_run_exec		; !NO-DELAY!
ssmp_run_indirect:
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]		; %r14 = X	; 	INDIRECT
	ld.ub	%r14,[%r0]
	;
	btst	[%r0],0x5	; 	xbtst [%r0+0x0], 0x5		; if(P) %r14 |= 0x100
	jreq	ssmp_run_exec	; 	xjreq ssmp_run_exec		; !NO-DELAY!
	ext	0x4		; 	xoor %r14, %r14, 0x100
	or	%r14,0x0
	jp	ssmp_run_exec	; 	xjp ssmp_run_exec		; !NO-DELAY!
	;
ssmp_run_implied:
ssmp_run_exec:
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(arg)
	ext	0x2		; 	xld.h [%r0+0x2], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x8		; 	xld.w %r10, [%r0+0x8]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11			; !INTERLOCK!
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	ssmp_run_L10@rm	; 	xjrgt ssmp_run_L10		; if(CYCLE <= 0) break
	jrgt	ssmp_run_L10@rl
ssmp_run_exit:
	;
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	popn %r3
	ret

;****************************************************************************
;
;****************************************************************************

; BOP8 ... 8bit Binary Operation

;#macro BOP8_r_DATA $1, $2
;	pushn %r0
	;
;	xld.ub %r13, [%r12+$2]
;	xcall.d ssmp_$1
;	ld.w %r0, %r12			; *delay*
	;
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

;#macro BOP8_r_ADDRESS $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r14, %r10
;	xld.ub %r13, [%r0+$2]
;	xcall.d ssmp_$1
;	ld.w %r0, %r12			; *delay*
	;
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

;#macro BOP8_ADDRESS_DATA $1
;	pushn %r2
	;
;	ld.w %r1, %r14			; (save dest-address)
;	ld.w %r2, %r15			; (save src-data)
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	ld.w %r14, %r2			; (restore src-data)
;	xcall.d ssmp_$1
;	ld.w %r12, %r0			; *delay*
	;
;	ld.w %r14, %r10
;	xld.w %r10, [%r0+WRITE]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	popn %r2
;	ret
;#endm

;#macro BOP8_ADDRESS_ADDRESS $1
;	pushn %r2
	;
;	ld.w %r1, %r14			; (save dest-address)
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r15			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	ld.w %r2, %r10			; (save src-data)
	;
;	xld.w %r10, [%r0+READ]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	ld.w %r14, %r2			; (restore src-data)
;	xcall.d ssmp_$1
;	ld.w %r12, %r0			; *delay*
	;
;	ld.w %r14, %r10
;	xld.w %r10, [%r0+WRITE]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	popn %r2
;	ret
;#endm

;****************************************************************************
;
;****************************************************************************

; UOP8 ... 8bit Unary Operation

;#macro UOP8_r $1, $2
;	pushn %r0
	;
;	xld.ub %r13, [%r12+$2]
;	xcall.d ssmp_$1
;	ld.w %r0, %r12			; *delay*
	;
;	xld.b [%r0+$2], %r10
	;
;	popn %r0
;	ret
;#endm

;#macro UOP8_ADDRESS $1
;	pushn %r1
	;
;	ld.w %r1, %r14			; (save address)
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	xcall.d ssmp_$1
;	ld.w %r12, %r0			; *delay*
	;
;	ld.w %r14, %r10
;	xld.w %r10, [%r0+WRITE]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	popn %r1
;	ret
;#endm

;****************************************************************************
;	8-BIT DATA TRANSMISSION COMMANDS GROUP 1
;****************************************************************************

;#macro MOV_r_DATA $1
;	xld.ub %r11, [%r12+PSW]
;	xld.b [%r12+$1], %r14		; *anti-interlock*
;	xand %r11, %r11, ~0x82		; PSW(N,Z)=0
;	xrr %r14, 8
;	ld.w %r14, %psr			; ????????_??????ZN
;	xsll %r14, 7			; ???????Z_N0000000
;	or %r11, %r14			; PSW(N)
;	xsrl %r14, 7			; ????????_??????ZN
;	xand %r14, %r14, 2		; 00000000_000000Z0
;	or %r11, %r14			; PSW(Z)
;	xld.b [%r12+PSW], %r11
;	ret
;#endm

;#macro MOV_r_ADDRESS $1
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.ub %r11, [%r0+PSW]
;	xld.b [%r0+$1], %r10		; *anti-interlock*
;	xand %r11, %r11, ~0x82		; PSW(N,Z)=0
;	xrr %r10, 8
;	ld.w %r10, %psr			; ????????_??????ZN
;	xsll %r10, 7			; ???????Z_N0000000
;	or %r11, %r10			; PSW(N)
;	xsrl %r10, 7			; ????????_??????ZN
;	xand %r10, %r10, 2		; 00000000_000000Z0
;	or %r11, %r10			; PSW(Z)
;	xld.b [%r0+PSW], %r11
	;
;	popn %r0
;	ret
;#endm

;****************************************************************************

	.global ssmpop_MOV_A_DATA
ssmpop_MOV_A_DATA:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]	; 	MOV_r_DATA A
	ext	0x4		; 	xld.b [%r12+0x4], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSW(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	ret
	.global ssmpop_MOV_X_DATA
ssmpop_MOV_X_DATA:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]	; 	MOV_r_DATA X
	ext	0x6		; 	xld.b [%r12+0x6], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSW(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	ret
	.global ssmpop_MOV_Y_DATA
ssmpop_MOV_Y_DATA:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]	; 	MOV_r_DATA Y
	ext	0x5		; 	xld.b [%r12+0x5], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSW(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	ret
	.global ssmpop_MOV_A_ADDRESS
ssmpop_MOV_A_ADDRESS:
	pushn %r0	; 	MOV_r_ADDRESS A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]
	ext	0x4		; 	xld.b [%r0+0x4], %r10		; *anti-interlock*
	ld.b	[%r0],%r10
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSW(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSW(Z)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret
	.global ssmpop_MOV_X_ADDRESS
ssmpop_MOV_X_ADDRESS:
	pushn %r0	; 	MOV_r_ADDRESS X
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]
	ext	0x6		; 	xld.b [%r0+0x6], %r10		; *anti-interlock*
	ld.b	[%r0],%r10
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSW(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSW(Z)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret
	.global ssmpop_MOV_Y_ADDRESS
ssmpop_MOV_Y_ADDRESS:
	pushn %r0	; 	MOV_r_ADDRESS Y
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.ub	%r11,[%r0]	; 	xld.ub %r11, [%r0+0x0]
	ext	0x5		; 	xld.b [%r0+0x5], %r10		; *anti-interlock*
	ld.b	[%r0],%r10
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	rr	%r10,0x8	; 	xrr %r10, 8
	ld.w %r10, %psr			; ????????_??????ZN
	sll	%r10,0x7	; 	xsll %r10, 7			; ???????Z_N0000000
	or %r11, %r10			; PSW(N)
	srl	%r10,0x7	; 	xsrl %r10, 7			; ????????_??????ZN
	and	%r10,0x2	; 	xand %r10, %r10, 2		; 00000000_000000Z0
	or %r11, %r10			; PSW(Z)
	ld.b	[%r0],%r11	; 	xld.b [%r0+0x0], %r11
	;
	popn %r0
	ret

;****************************************************************************
;	8-BIT DATA TRANSMISSION COMMANDS GROUP 2
;****************************************************************************

;#macro MOV_ADDRESS_r $1
;	xld.w %r10, [%r12+WRITE]
;	ld.w %r13, %r14
;	xld.ub %r14, [%r12+$1]
;	call %r10
;	ret
;#endm

;****************************************************************************

	.global ssmpop_MOV_ADDRESS_A
ssmpop_MOV_ADDRESS_A:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	MOV_ADDRESS_r A
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x4		; 	xld.ub %r14, [%r12+0x4]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global ssmpop_MOV_ADDRESS_X
ssmpop_MOV_ADDRESS_X:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	MOV_ADDRESS_r X
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x6		; 	xld.ub %r14, [%r12+0x6]
	ld.ub	%r14,[%r12]
	call %r10
	ret
	.global ssmpop_MOV_ADDRESS_Y
ssmpop_MOV_ADDRESS_Y:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	MOV_ADDRESS_r Y
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	ext	0x5		; 	xld.ub %r14, [%r12+0x5]
	ld.ub	%r14,[%r12]
	call %r10
	ret

;****************************************************************************
;	8-BIT DATA TRANSMISSION COMMANDS GROUP 3
;****************************************************************************

;#macro MOV_r_r $1, $2
;	xld.ub %r14, [%r12+$2]
;	xld.ub %r11, [%r12+PSW]		; *anti-interlock*
;	xld.b [%r12+$1], %r14		; *anti-interlock*
;	xand %r11, %r11, ~0x82		; PSW(N,Z)=0
;	xrr %r14, 8
;	ld.w %r14, %psr			; ????????_??????ZN
;	xsll %r14, 7			; ???????Z_N0000000
;	or %r11, %r14			; PSW(N)
;	xsrl %r14, 7			; ????????_??????ZN
;	xand %r14, %r14, 2		; 00000000_000000Z0
;	or %r11, %r14			; PSW(Z)
;	xld.b [%r12+PSW], %r11
;	ret
;#endm

;#macro MOV_ADDRESS_DATA
;	xld.w %r10, [%r12+WRITE]
;	ld.w %r13, %r14			; *anti-interlock*
;	call.d %r10
;	ld.w %r14, %r15			; *delay*
;	ret
;#endm

;#macro MOV_ADDRESS_ADDRESS
;	pushn %r1
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r1, %r14			; (save dest)
;	ld.w %r13, %r15
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.w %r11, [%r0+WRITE]
;	ld.w %r13, %r1			; (restore dest)
;	ld.w %r14, %r10
;	call.d %r11
;	ld.w %r12, %r0			; *delay*
	;
;	popn %r1
;	ret
;#endm

;****************************************************************************

	.global ssmpop_MOV_A_X
ssmpop_MOV_A_X:
	ext	0x6		; 	xld.ub %r14, [%r12+0x6]	; 	MOV_r_r A X
	ld.ub	%r14,[%r12]
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; *anti-interlock*
	ext	0x4		; 	xld.b [%r12+0x4], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSW(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	ret
	.global ssmpop_MOV_A_Y
ssmpop_MOV_A_Y:
	ext	0x5		; 	xld.ub %r14, [%r12+0x5]	; 	MOV_r_r A Y
	ld.ub	%r14,[%r12]
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; *anti-interlock*
	ext	0x4		; 	xld.b [%r12+0x4], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSW(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	ret
	.global ssmpop_MOV_X_A
ssmpop_MOV_X_A:
	ext	0x4		; 	xld.ub %r14, [%r12+0x4]	; 	MOV_r_r X A
	ld.ub	%r14,[%r12]
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; *anti-interlock*
	ext	0x6		; 	xld.b [%r12+0x6], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSW(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	ret
	.global ssmpop_MOV_Y_A
ssmpop_MOV_Y_A:
	ext	0x4		; 	xld.ub %r14, [%r12+0x4]	; 	MOV_r_r Y A
	ld.ub	%r14,[%r12]
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; *anti-interlock*
	ext	0x5		; 	xld.b [%r12+0x5], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSW(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	ret
	.global ssmpop_MOV_X_SP
ssmpop_MOV_X_SP:
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]	; 	MOV_r_r X SP
	ld.ub	%r14,[%r12]
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]		; *anti-interlock*
	ext	0x6		; 	xld.b [%r12+0x6], %r14		; *anti-interlock*
	ld.b	[%r12],%r14
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	rr	%r14,0x8	; 	xrr %r14, 8
	ld.w %r14, %psr			; ????????_??????ZN
	sll	%r14,0x7	; 	xsll %r14, 7			; ???????Z_N0000000
	or %r11, %r14			; PSW(N)
	srl	%r14,0x7	; 	xsrl %r14, 7			; ????????_??????ZN
	and	%r14,0x2	; 	xand %r14, %r14, 2		; 00000000_000000Z0
	or %r11, %r14			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	ret
	.global ssmpop_MOV_SP_X
ssmpop_MOV_SP_X:
	ext	0x6		; 	xld.ub %r10, [%r12+0x6]
	ld.ub	%r10,[%r12]
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	;* NO FLAGS AFFECTED */
	ret

	.global ssmpop_MOV_ADDRESS_DATA
ssmpop_MOV_ADDRESS_DATA:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	MOV_ADDRESS_DATA
	ld.w	%r10,[%r12]
	ld.w %r13, %r14			; *anti-interlock*
	call.d %r10
	ld.w %r14, %r15			; *delay*
	ret
	.global ssmpop_MOV_ADDRESS_ADDRESS
ssmpop_MOV_ADDRESS_ADDRESS:
	pushn %r1	; 	MOV_ADDRESS_ADDRESS
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r1, %r14			; (save dest)
	ld.w %r13, %r15
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x14		; 	xld.w %r11, [%r0+0x14]
	ld.w	%r11,[%r0]
	ld.w %r13, %r1			; (restore dest)
	ld.w %r14, %r10
	call.d %r11
	ld.w %r12, %r0			; *delay*
	;
	popn %r1
	ret

;****************************************************************************
;	8-BIT ARITHMETIC OPERATION COMMANDS
;****************************************************************************

	.global ssmp_ADC
ssmp_ADC:
	ld.ub	%r4,[%r12]	; 	xld.ub %r4, [%r12+0x0]		; PSW
	swap %r5, %r13
	swap %r6, %r14
	ld.w %r7, %r4			; c = PSW(C)
	and	%r7,0x1		; 	xand %r7, %r7, 1
	swap %r7, %r7
	ext	0x1ffc		; 	xand %r4, %r4, -204		; PSW(N,V,H,Z,C) = 0
	and	%r4,0x34
	;
	add %r5, %r6			; a + b
	;
	ld.w %r10, %psr			; %psr(C1,V1)
	and	%r10,0xc	; 	xand %r10, %r10, 0xc
	;
	add %r5, %r7			; a + b + c
	;
	ld.w %r11, %psr			; %psr(C1|C2,V1^V2,Z2,N2)
	ext	0x4		; 	xand %r15, %r11, 0x4
	and	%r15,%r11
	xor %r10, %r15
	and	%r11,0xb	; 	xand %r11, %r11, 0xb
	or %r10, %r11
	ext	ssmp_FLAG_CONV+0x0@h	; 	xld.ub %r10, [%r10+ssmp_FLAG_CONV]	; PSW(N,V,Z,C)
	ext	ssmp_FLAG_CONV+0x0@m
	ld.w	%r9,ssmp_FLAG_CONV+0x0@l
	add	%r9,%r10
	ld.ub	%r10,[%r9]
	;
	; TODO: PSW(H)Ή
	;
	or %r4, %r10			; PSW
	ld.b	[%r12],%r4	; 	xld.b [%r12+0x0], %r4
	;
	ret.d
	swap %r10, %r5			; *delay*

	.global ssmp_SBC
ssmp_SBC:
	ld.ub	%r4,[%r12]	; 	xld.ub %r4, [%r12+0x0]		; PSW
	swap %r5, %r13
	swap %r6, %r14
	not %r7, %r4			; c = ~PSW(C)
	and	%r7,0x1		; 	xand %r7, %r7, 1
	swap %r7, %r7
	ext	0x1ffc		; 	xand %r4, %r4, -204		; PSW(N,V,H,Z,C) = 0
	and	%r4,0x34
	;
	sub %r5, %r6			; a - b
	;
	ld.w %r10, %psr			; %psr(C1,V1)
	and	%r10,0xc	; 	xand %r10, %r10, 0xc
	;
	sub %r5, %r7			; a + b + c
	;
	ld.w %r11, %psr			; %psr(C1|C2,V1^V2,Z2,N2)
	ext	0x4		; 	xand %r15, %r11, 0x4
	and	%r15,%r11
	xor %r10, %r15
	and	%r11,0xb	; 	xand %r11, %r11, 0xb
	or %r10, %r11
	ext	ssmp_FLAG_CONV+0x0@h	; 	xld.ub %r10, [%r10+ssmp_FLAG_CONV]	; PSW(N,V,Z,C)
	ext	ssmp_FLAG_CONV+0x0@m
	ld.w	%r9,ssmp_FLAG_CONV+0x0@l
	add	%r9,%r10
	ld.ub	%r10,[%r9]
	;
	; TODO: PSW(H)Ή
	;
	xor	%r10,0x1	; 	xxor %r10, %r10, 1		; PSW(C) = ~PSW(C)
	or %r4, %r10			; PSW
	ld.b	[%r12],%r4	; 	xld.b [%r12+0x0], %r4
	;
	ret.d
	swap %r10, %r5			; *delay*

	.global ssmp_CMP
ssmp_CMP:
	ld.ub	%r4,[%r12]	; 	xld.ub %r4, [%r12+0x0]		; PSW
	swap %r5, %r13
	swap %r6, %r14
	ext	0x1ffd		; 	xand %r4, %r4, -132		; PSW(N,Z,C) = 0
	and	%r4,0x3c
	;
	sub %r5, %r6			; a - b
	;
	ld.w %r10, %psr			; %psr(C,Z,N)
	and	%r10,0xb	; 	xand %r10, %r10, 0xb
	ext	ssmp_FLAG_CONV+0x0@h	; 	xld.ub %r10, [%r10+ssmp_FLAG_CONV]	; PSW(N,Z,C)
	ext	ssmp_FLAG_CONV+0x0@m
	ld.w	%r9,ssmp_FLAG_CONV+0x0@l
	add	%r9,%r10
	ld.ub	%r10,[%r9]
	;
	xor	%r10,0x1	; 	xxor %r10, %r10, 1		; PSW(C) = ~PSW(C) !INTERLOCK!
	or %r4, %r10			; PSW
	ld.b	[%r12],%r4	; 	xld.b [%r12+0x0], %r4
	;
	ret

;****************************************************************************

;#macro CMP_r_DATA $1, $2
;	xld.ub %r13, [%r12+$2]
;	xjp ssmp_$1
;#endm

;#macro CMP_r_ADDRESS $1, $2
;	pushn %r0
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r14
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r14, %r10
;	xld.ub %r13, [%r0+$2]
;	xcall.d ssmp_$1
;	ld.w %r0, %r12			; *delay*
	;
;	popn %r0
;	ret
;#endm

;#macro CMP_ADDRESS_DATA $1
;	pushn %r2
	;
;	ld.w %r1, %r14			; (save dest-address)
;	ld.w %r2, %r15			; (save src-data)
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	ld.w %r14, %r2			; (restore src-data)
;	xcall.d ssmp_$1
;	ld.w %r12, %r0
	;
;	popn %r2
;	ret
;#endm

;#macro CMP_ADDRESS_ADDRESS $1
;	pushn %r2
	;
;	ld.w %r1, %r14			; (save dest-address)
	;
;	xld.w %r10, [%r12+READ]
;	ld.w %r13, %r15			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
;	ld.w %r2, %r10			; (save src-data)
	;
;	xld.w %r10, [%r0+READ]
;	ld.w %r13, %r1			; *anti-interlock*
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	ld.w %r13, %r10
;	ld.w %r14, %r2			; (restore src-data)
;	xcall.d ssmp_$1
;	ld.w %r12, %r0
	;
;	popn %r2
;	ret
;#endm

;****************************************************************************

	.global ssmpop_ADC_A_DATA
ssmpop_ADC_A_DATA:
	pushn %r0	; 	BOP8_r_DATA ADC, A
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	call.d	ssmp_ADC	; 	xcall.d ssmp_ADC
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_SBC_A_DATA
ssmpop_SBC_A_DATA:
	pushn %r0	; 	BOP8_r_DATA SBC, A
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	call.d	ssmp_SBC	; 	xcall.d ssmp_SBC
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_CMP_A_DATA
ssmpop_CMP_A_DATA:
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]	; 	CMP_r_DATA CMP, A
	ld.ub	%r13,[%r12]
	jp	ssmp_CMP	; 	xjp ssmp_CMP
	.global ssmpop_CMP_X_DATA
ssmpop_CMP_X_DATA:
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]	; 	CMP_r_DATA CMP, X
	ld.ub	%r13,[%r12]
	jp	ssmp_CMP	; 	xjp ssmp_CMP
	.global ssmpop_CMP_Y_DATA
ssmpop_CMP_Y_DATA:
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]	; 	CMP_r_DATA CMP, Y
	ld.ub	%r13,[%r12]
	jp	ssmp_CMP	; 	xjp ssmp_CMP

	.global ssmpop_ADC_A_ADDRESS
ssmpop_ADC_A_ADDRESS:
	pushn %r0	; 	BOP8_r_ADDRESS ADC, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x4		; 	xld.ub %r13, [%r0+0x4]
	ld.ub	%r13,[%r0]
	call.d	ssmp_ADC	; 	xcall.d ssmp_ADC
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_SBC_A_ADDRESS
ssmpop_SBC_A_ADDRESS:
	pushn %r0	; 	BOP8_r_ADDRESS SBC, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x4		; 	xld.ub %r13, [%r0+0x4]
	ld.ub	%r13,[%r0]
	call.d	ssmp_SBC	; 	xcall.d ssmp_SBC
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_CMP_A_ADDRESS
ssmpop_CMP_A_ADDRESS:
	pushn %r0	; 	CMP_r_ADDRESS CMP, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x4		; 	xld.ub %r13, [%r0+0x4]
	ld.ub	%r13,[%r0]
	call.d	ssmp_CMP	; 	xcall.d ssmp_CMP
	ld.w %r0, %r12			; *delay*
	;
	popn %r0
	ret
	.global ssmpop_CMP_X_ADDRESS
ssmpop_CMP_X_ADDRESS:
	pushn %r0	; 	CMP_r_ADDRESS CMP, X
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x6		; 	xld.ub %r13, [%r0+0x6]
	ld.ub	%r13,[%r0]
	call.d	ssmp_CMP	; 	xcall.d ssmp_CMP
	ld.w %r0, %r12			; *delay*
	;
	popn %r0
	ret
	.global ssmpop_CMP_Y_ADDRESS
ssmpop_CMP_Y_ADDRESS:
	pushn %r0	; 	CMP_r_ADDRESS CMP, Y
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x5		; 	xld.ub %r13, [%r0+0x5]
	ld.ub	%r13,[%r0]
	call.d	ssmp_CMP	; 	xcall.d ssmp_CMP
	ld.w %r0, %r12			; *delay*
	;
	popn %r0
	ret

	.global ssmpop_ADC_ADDRESS_DATA
ssmpop_ADC_ADDRESS_DATA:
	pushn %r2	; 	BOP8_ADDRESS_DATA ADC
	;
	ld.w %r1, %r14			; (save dest-address)
	ld.w %r2, %r15			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	ext	ssmp_ADC@rm	; 	xcall.d ssmp_ADC
	call.d	ssmp_ADC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r2
	ret
	.global ssmpop_SBC_ADDRESS_DATA
ssmpop_SBC_ADDRESS_DATA:
	pushn %r2	; 	BOP8_ADDRESS_DATA SBC
	;
	ld.w %r1, %r14			; (save dest-address)
	ld.w %r2, %r15			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	ext	ssmp_SBC@rm	; 	xcall.d ssmp_SBC
	call.d	ssmp_SBC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r2
	ret
	.global ssmpop_CMP_ADDRESS_DATA
ssmpop_CMP_ADDRESS_DATA:
	pushn %r2	; 	CMP_ADDRESS_DATA CMP
	;
	ld.w %r1, %r14			; (save dest-address)
	ld.w %r2, %r15			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	ext	ssmp_CMP@rm	; 	xcall.d ssmp_CMP
	call.d	ssmp_CMP@rl
	ld.w %r12, %r0
	;
	popn %r2
	ret

	.global ssmpop_ADC_ADDRESS_ADDRESS
ssmpop_ADC_ADDRESS_ADDRESS:
	pushn %r2	; 	BOP8_ADDRESS_ADDRESS ADC
	;
	ld.w %r1, %r14			; (save dest-address)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r15			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ld.w %r2, %r10			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	ext	ssmp_ADC@rm	; 	xcall.d ssmp_ADC
	call.d	ssmp_ADC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r2
	ret
	.global ssmpop_SBC_ADDRESS_ADDRESS
ssmpop_SBC_ADDRESS_ADDRESS:
	pushn %r2	; 	BOP8_ADDRESS_ADDRESS SBC
	;
	ld.w %r1, %r14			; (save dest-address)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r15			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ld.w %r2, %r10			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	ext	ssmp_SBC@rm	; 	xcall.d ssmp_SBC
	call.d	ssmp_SBC@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r2
	ret
	.global ssmpop_CMP_ADDRESS_ADDRESS
ssmpop_CMP_ADDRESS_ADDRESS:
	pushn %r2	; 	CMP_ADDRESS_ADDRESS CMP
	;
	ld.w %r1, %r14			; (save dest-address)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r15			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ld.w %r2, %r10			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	ext	ssmp_CMP@rm	; 	xcall.d ssmp_CMP
	call.d	ssmp_CMP@rl
	ld.w %r12, %r0
	;
	popn %r2
	ret

;****************************************************************************
;	8-BIT LOGIC OPERATION COMMANDS
;****************************************************************************

	.global ssmp_AND
ssmp_AND:
	and %r13, %r14
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]
	ld.w %r10, %r13			; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	;
	rr	%r13,0x8	; 	xrr %r13, 8
	ld.w %r13, %psr			; ????????_??????ZN
	sll	%r13,0x7	; 	xsll %r13, 7			; ???????Z_N0000000
	or %r11, %r13			; PSW(N)
	srl	%r13,0x7	; 	xsrl %r13, 7			; ????????_??????ZN
	and	%r13,0x2	; 	xand %r13, %r13, 2		; 00000000_000000Z0
	or %r11, %r13			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

	.global ssmp_OR
ssmp_OR:
	or %r13, %r14
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]
	ld.w %r10, %r13			; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	;
	rr	%r13,0x8	; 	xrr %r13, 8
	ld.w %r13, %psr			; ????????_??????ZN
	sll	%r13,0x7	; 	xsll %r13, 7			; ???????Z_N0000000
	or %r11, %r13			; PSW(N)
	srl	%r13,0x7	; 	xsrl %r13, 7			; ????????_??????ZN
	and	%r13,0x2	; 	xand %r13, %r13, 2		; 00000000_000000Z0
	or %r11, %r13			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

	.global ssmp_EOR
ssmp_EOR:
	xor %r13, %r14
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]
	ld.w %r10, %r13			; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	;
	rr	%r13,0x8	; 	xrr %r13, 8
	ld.w %r13, %psr			; ????????_??????ZN
	sll	%r13,0x7	; 	xsll %r13, 7			; ???????Z_N0000000
	or %r11, %r13			; PSW(N)
	srl	%r13,0x7	; 	xsrl %r13, 7			; ????????_??????ZN
	and	%r13,0x2	; 	xand %r13, %r13, 2		; 00000000_000000Z0
	or %r11, %r13			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

;****************************************************************************

	.global ssmpop_AND_A_DATA
ssmpop_AND_A_DATA:
	pushn %r0	; 	BOP8_r_DATA AND, A
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	call.d	ssmp_AND	; 	xcall.d ssmp_AND
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_OR_A_DATA
ssmpop_OR_A_DATA:
	pushn %r0	; 	BOP8_r_DATA OR, A
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	call.d	ssmp_OR		; 	xcall.d ssmp_OR
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_EOR_A_DATA
ssmpop_EOR_A_DATA:
	pushn %r0	; 	BOP8_r_DATA EOR, A
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	call.d	ssmp_EOR	; 	xcall.d ssmp_EOR
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

	.global ssmpop_AND_A_ADDRESS
ssmpop_AND_A_ADDRESS:
	pushn %r0	; 	BOP8_r_ADDRESS AND, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x4		; 	xld.ub %r13, [%r0+0x4]
	ld.ub	%r13,[%r0]
	call.d	ssmp_AND	; 	xcall.d ssmp_AND
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_OR_A_ADDRESS
ssmpop_OR_A_ADDRESS:
	pushn %r0	; 	BOP8_r_ADDRESS OR, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x4		; 	xld.ub %r13, [%r0+0x4]
	ld.ub	%r13,[%r0]
	call.d	ssmp_OR		; 	xcall.d ssmp_OR
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_EOR_A_ADDRESS
ssmpop_EOR_A_ADDRESS:
	pushn %r0	; 	BOP8_r_ADDRESS EOR, A
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r14
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r14, %r10
	ext	0x4		; 	xld.ub %r13, [%r0+0x4]
	ld.ub	%r13,[%r0]
	call.d	ssmp_EOR	; 	xcall.d ssmp_EOR
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

	.global ssmpop_AND_ADDRESS_DATA
ssmpop_AND_ADDRESS_DATA:
	pushn %r2	; 	BOP8_ADDRESS_DATA AND
	;
	ld.w %r1, %r14			; (save dest-address)
	ld.w %r2, %r15			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	call.d	ssmp_AND	; 	xcall.d ssmp_AND
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r2
	ret
	.global ssmpop_OR_ADDRESS_DATA
ssmpop_OR_ADDRESS_DATA:
	pushn %r2	; 	BOP8_ADDRESS_DATA OR
	;
	ld.w %r1, %r14			; (save dest-address)
	ld.w %r2, %r15			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	ext	ssmp_OR@rm	; 	xcall.d ssmp_OR
	call.d	ssmp_OR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r2
	ret
	.global ssmpop_EOR_ADDRESS_DATA
ssmpop_EOR_ADDRESS_DATA:
	pushn %r2	; 	BOP8_ADDRESS_DATA EOR
	;
	ld.w %r1, %r14			; (save dest-address)
	ld.w %r2, %r15			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	ext	ssmp_EOR@rm	; 	xcall.d ssmp_EOR
	call.d	ssmp_EOR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r2
	ret

	.global ssmpop_AND_ADDRESS_ADDRESS
ssmpop_AND_ADDRESS_ADDRESS:
	pushn %r2	; 	BOP8_ADDRESS_ADDRESS AND
	;
	ld.w %r1, %r14			; (save dest-address)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r15			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ld.w %r2, %r10			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	ext	ssmp_AND@rm	; 	xcall.d ssmp_AND
	call.d	ssmp_AND@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r2
	ret
	.global ssmpop_OR_ADDRESS_ADDRESS
ssmpop_OR_ADDRESS_ADDRESS:
	pushn %r2	; 	BOP8_ADDRESS_ADDRESS OR
	;
	ld.w %r1, %r14			; (save dest-address)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r15			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ld.w %r2, %r10			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	ext	ssmp_OR@rm	; 	xcall.d ssmp_OR
	call.d	ssmp_OR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r2
	ret
	.global ssmpop_EOR_ADDRESS_ADDRESS
ssmpop_EOR_ADDRESS_ADDRESS:
	pushn %r2	; 	BOP8_ADDRESS_ADDRESS EOR
	;
	ld.w %r1, %r14			; (save dest-address)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r15			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	ld.w %r2, %r10			; (save src-data)
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	ld.w %r14, %r2			; (restore src-data)
	ext	ssmp_EOR@rm	; 	xcall.d ssmp_EOR
	call.d	ssmp_EOR@rl
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r2
	ret

;****************************************************************************
;	ADDITION & SUBTRACTION COMMANDS
;****************************************************************************

	.global ssmp_INC
ssmp_INC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]
	add	%r13,0x1	; 	xadd %r13, %r13, 1		; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	ld.ub %r13, %r13
	ld.w %r10, %r13
	;
	rr	%r13,0x8	; 	xrr %r13, 8
	ld.w %r13, %psr			; ????????_??????ZN
	sll	%r13,0x7	; 	xsll %r13, 7			; ???????Z_N0000000
	or %r11, %r13			; PSW(N)
	srl	%r13,0x7	; 	xsrl %r13, 7			; ????????_??????ZN
	and	%r13,0x2	; 	xand %r13, %r13, 2		; 00000000_000000Z0
	or %r11, %r13			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

	.global ssmp_DEC
ssmp_DEC:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]
	sub	%r13,0x1	; 	xsub %r13, %r13, 1		; *anti-interlock*
	ext	0x1ffd		; 	xand %r11, %r11, -131		; PSW(N,Z)=0
	and	%r11,0x3d
	ld.ub %r13, %r13
	ld.w %r10, %r13
	;
	rr	%r13,0x8	; 	xrr %r13, 8
	ld.w %r13, %psr			; ????????_??????ZN
	sll	%r13,0x7	; 	xsll %r13, 7			; ???????Z_N0000000
	or %r11, %r13			; PSW(N)
	srl	%r13,0x7	; 	xsrl %r13, 7			; ????????_??????ZN
	and	%r13,0x2	; 	xand %r13, %r13, 2		; 00000000_000000Z0
	or %r11, %r13			; PSW(Z)
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11
	;
	ret

;****************************************************************************

	.global ssmpop_INC_A
ssmpop_INC_A:
	pushn %r0	; 	UOP8_r INC, A
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	call.d	ssmp_INC	; 	xcall.d ssmp_INC
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_INC_X
ssmpop_INC_X:
	pushn %r0	; 	UOP8_r INC, X
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	call.d	ssmp_INC	; 	xcall.d ssmp_INC
	ld.w %r0, %r12			; *delay*
	;
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_INC_Y
ssmpop_INC_Y:
	pushn %r0	; 	UOP8_r INC, Y
	;
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]
	ld.ub	%r13,[%r12]
	call.d	ssmp_INC	; 	xcall.d ssmp_INC
	ld.w %r0, %r12			; *delay*
	;
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

	.global ssmpop_DEC_A
ssmpop_DEC_A:
	pushn %r0	; 	UOP8_r DEC, A
	;
	ext	0x4		; 	xld.ub %r13, [%r12+0x4]
	ld.ub	%r13,[%r12]
	call.d	ssmp_DEC	; 	xcall.d ssmp_DEC
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_DEC_X
ssmpop_DEC_X:
	pushn %r0	; 	UOP8_r DEC, X
	;
	ext	0x6		; 	xld.ub %r13, [%r12+0x6]
	ld.ub	%r13,[%r12]
	call.d	ssmp_DEC	; 	xcall.d ssmp_DEC
	ld.w %r0, %r12			; *delay*
	;
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_DEC_Y
ssmpop_DEC_Y:
	pushn %r0	; 	UOP8_r DEC, Y
	;
	ext	0x5		; 	xld.ub %r13, [%r12+0x5]
	ld.ub	%r13,[%r12]
	call.d	ssmp_DEC	; 	xcall.d ssmp_DEC
	ld.w %r0, %r12			; *delay*
	;
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret

	.global ssmpop_INC_ADDRESS
ssmpop_INC_ADDRESS:
	pushn %r1	; 	UOP8_ADDRESS INC
	;
	ld.w %r1, %r14			; (save address)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	call.d	ssmp_INC	; 	xcall.d ssmp_INC
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r1
	ret
	.global ssmpop_DEC_ADDRESS
ssmpop_DEC_ADDRESS:
	pushn %r1	; 	UOP8_ADDRESS DEC
	;
	ld.w %r1, %r14			; (save address)
	;
	ext	0x10		; 	xld.w %r10, [%r12+0x10]
	ld.w	%r10,[%r12]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r13, %r10
	call.d	ssmp_DEC	; 	xcall.d ssmp_DEC
	ld.w %r12, %r0			; *delay*
	;
	ld.w %r14, %r10
	ext	0x14		; 	xld.w %r10, [%r0+0x14]
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	popn %r1
	ret

;****************************************************************************
;	BRANCHING COMMANDS
;****************************************************************************

;#macro Bcc_ADDRESS $1
;	xbtst [%r12+PSW], $1
;	xjreq $$1
	;
;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 2
;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;	xsub %r10, %r10, 2
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

;#macro BNcc_ADDRESS $1
;	xbtst [%r12+PSW], $1
;	xjrne $$1
	;
;	xld.w %r10, [%r12+CYCLE]	; CYCLE -= 2
;	xld.h [%r12+PC], %r14		; PC *anti-interlock*
;	xsub %r10, %r10, 2
;	xld.w [%r12+CYCLE], %r10
;$$1:
;	ret
;#endm

;****************************************************************************

	.global ssmpop_JMP_ADDRESS
ssmpop_JMP_ADDRESS:
	ext	0x2		; 	xld.h [%r12+0x2], %r14
	ld.h	[%r12],%r14
	ret
	.global ssmpop_BCC_ADDRESS
ssmpop_BCC_ADDRESS:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	BNcc_ADDRESS 0
	jrne	__LX0003	; 	xjrne __L0003
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE -= 2
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.h [%r12+0x2], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x2	; 	xsub %r10, %r10, 2
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0003:				; __L0003:
	ret
	.global ssmpop_BCS_ADDRESS
ssmpop_BCS_ADDRESS:
	btst	[%r12],0x0	; 	xbtst [%r12+0x0], 0x0	; 	Bcc_ADDRESS 0
	jreq	__LX0004	; 	xjreq __L0004
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE -= 2
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.h [%r12+0x2], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x2	; 	xsub %r10, %r10, 2
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0004:				; __L0004:
	ret
	.global ssmpop_BNE_ADDRESS
ssmpop_BNE_ADDRESS:
	btst	[%r12],0x1	; 	xbtst [%r12+0x0], 0x1	; 	BNcc_ADDRESS 1
	jrne	__LX0005	; 	xjrne __L0005
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE -= 2
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.h [%r12+0x2], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x2	; 	xsub %r10, %r10, 2
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0005:				; __L0005:
	ret
	.global ssmpop_BEQ_ADDRESS
ssmpop_BEQ_ADDRESS:
	btst	[%r12],0x1	; 	xbtst [%r12+0x0], 0x1	; 	Bcc_ADDRESS 1
	jreq	__LX0006	; 	xjreq __L0006
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE -= 2
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.h [%r12+0x2], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x2	; 	xsub %r10, %r10, 2
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0006:				; __L0006:
	ret
	.global ssmpop_BVC_ADDRESS
ssmpop_BVC_ADDRESS:
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6	; 	BNcc_ADDRESS 6
	jrne	__LX0007	; 	xjrne __L0007
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE -= 2
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.h [%r12+0x2], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x2	; 	xsub %r10, %r10, 2
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0007:				; __L0007:
	ret
	.global ssmpop_BVS_ADDRESS
ssmpop_BVS_ADDRESS:
	btst	[%r12],0x6	; 	xbtst [%r12+0x0], 0x6	; 	Bcc_ADDRESS 6
	jreq	__LX0008	; 	xjreq __L0008
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE -= 2
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.h [%r12+0x2], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x2	; 	xsub %r10, %r10, 2
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0008:				; __L0008:
	ret
	.global ssmpop_BPL_ADDRESS
ssmpop_BPL_ADDRESS:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	BNcc_ADDRESS 7
	jrne	__LX0009	; 	xjrne __L0009
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE -= 2
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.h [%r12+0x2], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x2	; 	xsub %r10, %r10, 2
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0009:				; __L0009:
	ret
	.global ssmpop_BMI_ADDRESS
ssmpop_BMI_ADDRESS:
	btst	[%r12],0x7	; 	xbtst [%r12+0x0], 0x7	; 	Bcc_ADDRESS 7
	jreq	__LX0010	; 	xjreq __L0010
	;
	ext	0x8		; 	xld.w %r10, [%r12+0x8]	; CYCLE -= 2
	ld.w	%r10,[%r12]
	ext	0x2		; 	xld.h [%r12+0x2], %r14		; PC *anti-interlock*
	ld.h	[%r12],%r14
	sub	%r10,0x2	; 	xsub %r10, %r10, 2
	ext	0x8		; 	xld.w [%r12+0x8], %r10
	ld.w	[%r12],%r10
__LX0010:				; __L0010:
	ret

;****************************************************************************
;	SUB-ROUTINE CALL RETURN COMMANDS
;****************************************************************************

	.global ssmpop_CALL_ADDRESS
ssmpop_CALL_ADDRESS:
	pushn %r2
	;
	ext	0x1		; 	xld.ub %r1, [%r12+0x1]		; SP|0x100
	ld.ub	%r1,[%r12]
	ext	0x2		; 	xld.uh %r2, [%r12+0x2]		; PC *anti-interlock*
	ld.uh	%r2,[%r12]
	ext	0x4		; 	xoor %r1, %r1, 0x100
	or	%r1,0x0
	;
	ext	0x2		; 	xld.h [%r12+0x2], %r14		; PC <= address
	ld.h	[%r12],%r14
	;
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; PUSH(PCH)
	ld.w	%r10,[%r12]
	ld.w %r13, %r1
	ld.w %r14, %r2
	srl	%r14,0x8	; 	xsrl %r14, 8
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	;				; SP|0x100 == 0x100      `0x1ff
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; -1       => 0x0ff      `0x1fe
	ext	0x4		; 	xoor %r1, %r1, 0x100		;   |0x100 => 0x1ff,0x100`0x1fe
	or	%r1,0x0
	;
	ext	0x14		; 	xld.w %r10, [%r0+0x14]		; PUSH(PCL)
	ld.w	%r10,[%r0]
	ld.w %r13, %r1
	ld.ub %r14, %r2
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	sub	%r1,0x1		; 	xsub %r1, %r1, 1		; SP--
	ext	0x1		; 	xld.b [%r0+0x1], %r1
	ld.b	[%r0],%r1
	;
	popn %r2
	ret

	.global ssmpop_RET
ssmpop_RET:
	pushn %r2
	;
	ext	0x1		; 	xld.ub %r1, [%r12+0x1]		; SP         == 0x000`      0x0ff
	ld.ub	%r1,[%r12]
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; SP++       => 0x001`      0x100
	ext	0x4		; 	xoor %r1, %r1, 0x100		; SP++|0x100 => 0x101`0x1ff,0x100
	or	%r1,0x0
	;
	ld.w %r13, %r1			; POP(PCL)
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.w %r2, %r10			; (save PCL)
	;
	;				; SP|0x100 == 0x100`      0x1ff
	add	%r1,0x1		; 	xadd %r1, %r1, 1		; +1       => 0x101`      0x200
	ld.ub %r1, %r1			;          => 0x001`0x0ff,0x000
	ext	0x4		; 	xoor %r1, %r1, 0x100		;   |0x100 => 0x101`0x1ff,0x100
	or	%r1,0x0
	;
	ext	0x10		; 	xld.w %r10, [%r0+0x10]		; POP(PCH)
	ld.w	%r10,[%r0]
	ld.w %r13, %r1			; *anti-interlock*
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	sll	%r10,0x8	; 	xsll %r10, 8			; PC = PCL | PCH << 8
	or %r10, %r2
	ext	0x2		; 	xld.h [%r0+0x2], %r10
	ld.h	[%r0],%r10
	;
	ext	0x1		; 	xld.b [%r0+0x1], %r1		; SP
	ld.b	[%r0],%r1
	;
	popn %r2
	ret

;****************************************************************************
;	STACK OPERATION COMMANDS
;****************************************************************************/

;#macro PUSH_r $1
;	xld.w %r10, [%r12+WRITE]
;	xld.ub %r13, [%r12+SP]
;	xld.ub %r14, [%r12+$1]		; *anti-interlock*
;	xsub %r11, %r13, 1
;	xld.b [%r12+SP], %r11
;	xoor %r13, %r13, 0x100
;	call %r10
;	ret
;#endm

;#macro POP_r $1
;	pushn %r0
	;
;	xld.ub %r13, [%r12+SP]
;	xld.w %r10, [%r12+READ]		; *anti-interlock*
;	xadd %r13, %r13, 1
;	xld.b [%r12+SP], %r13
;	ld.ub %r13, %r13
;	xoor %r13, %r13, 0x100
;	call.d %r10
;	ld.w %r0, %r12			; *delay*
	;
;	xld.b [%r0+$1], %r10
	;
;	popn %r0
;	ret
;#endm

;****************************************************************************

	.global ssmpop_PUSH_A
ssmpop_PUSH_A:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	PUSH_r A
	ld.w	%r10,[%r12]
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	0x4		; 	xld.ub %r14, [%r12+0x4]		; *anti-interlock*
	ld.ub	%r14,[%r12]
	ext	0x1		; 	xsub %r11, %r13, 1
	sub	%r11,%r13
	ext	0x1		; 	xld.b [%r12+0x1], %r11
	ld.b	[%r12],%r11
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call %r10
	ret
	.global ssmpop_PUSH_X
ssmpop_PUSH_X:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	PUSH_r X
	ld.w	%r10,[%r12]
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	0x6		; 	xld.ub %r14, [%r12+0x6]		; *anti-interlock*
	ld.ub	%r14,[%r12]
	ext	0x1		; 	xsub %r11, %r13, 1
	sub	%r11,%r13
	ext	0x1		; 	xld.b [%r12+0x1], %r11
	ld.b	[%r12],%r11
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call %r10
	ret
	.global ssmpop_PUSH_Y
ssmpop_PUSH_Y:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	PUSH_r Y
	ld.w	%r10,[%r12]
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	0x5		; 	xld.ub %r14, [%r12+0x5]		; *anti-interlock*
	ld.ub	%r14,[%r12]
	ext	0x1		; 	xsub %r11, %r13, 1
	sub	%r11,%r13
	ext	0x1		; 	xld.b [%r12+0x1], %r11
	ld.b	[%r12],%r11
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call %r10
	ret
	.global ssmpop_PUSH_PSW
ssmpop_PUSH_PSW:
	ext	0x14		; 	xld.w %r10, [%r12+0x14]	; 	PUSH_r PSW
	ld.w	%r10,[%r12]
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ld.ub	%r14,[%r12]	; 	xld.ub %r14, [%r12+0x0]		; *anti-interlock*
	ext	0x1		; 	xsub %r11, %r13, 1
	sub	%r11,%r13
	ext	0x1		; 	xld.b [%r12+0x1], %r11
	ld.b	[%r12],%r11
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call %r10
	ret

	.global ssmpop_POP_A
ssmpop_POP_A:
	pushn %r0	; 	POP_r A
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	ext	0x1		; 	xld.b [%r12+0x1], %r13
	ld.b	[%r12],%r13
	ld.ub %r13, %r13
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x4		; 	xld.b [%r0+0x4], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_POP_X
ssmpop_POP_X:
	pushn %r0	; 	POP_r X
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	ext	0x1		; 	xld.b [%r12+0x1], %r13
	ld.b	[%r12],%r13
	ld.ub %r13, %r13
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_POP_Y
ssmpop_POP_Y:
	pushn %r0	; 	POP_r Y
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	ext	0x1		; 	xld.b [%r12+0x1], %r13
	ld.b	[%r12],%r13
	ld.ub %r13, %r13
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	;
	popn %r0
	ret
	.global ssmpop_POP_PSW
ssmpop_POP_PSW:
	pushn %r0	; 	POP_r PSW
	;
	ext	0x1		; 	xld.ub %r13, [%r12+0x1]
	ld.ub	%r13,[%r12]
	ext	0x10		; 	xld.w %r10, [%r12+0x10]		; *anti-interlock*
	ld.w	%r10,[%r12]
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	ext	0x1		; 	xld.b [%r12+0x1], %r13
	ld.b	[%r12],%r13
	ld.ub %r13, %r13
	ext	0x4		; 	xoor %r13, %r13, 0x100
	or	%r13,0x0
	call.d %r10
	ld.w %r0, %r12			; *delay*
	;
	ld.b	[%r0],%r10	; 	xld.b [%r0+0x0], %r10
	;
	popn %r0
	ret

;****************************************************************************
;
;****************************************************************************

;#endif /*SSMP_ASM*/
