;
;	framc16a.s
;
;	P/ECE CP1610 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sun May 15 21:34:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clipc16a.h"
;
;	clipc16a.h
;
;	P/ECE CP1610 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sun May 15 21:34:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;

; clipc16a.sAframc16a.sɃCN[hĎg܂B

;****************************************************************************
;	CP1610\
;****************************************************************************

				; typedef struct _CP1610 {
;#define R		 0	; 	unsigned short r[8];	/* + 0,16: R0,R1,R2,R3,R4,R5,R6,R7 */
;#define _SZ_		16	; 	int sz;			/* +16, 4: S------- -------- SZZZZZZZ ZZZZZZZZ */
;#define C		20	; 	int c;			/* +20, 4: -------- -------C -------- -------- */
;#define OV		24	; 	unsigned short ov;	/* +24, 2:                   V------- -------- */
				; 	//
;#define FLAGS		26	; 	unsigned char flags;	/* +26, 1: etO (CP1610_*̑g) */
;#define EBC		27	; 	unsigned char ebc;	/* +27, 1: External Branch Condition (0..15) */
;#define IAB		28	; 	unsigned short iab;	/* +28, 2: 荞݃xN^ ($0000..$FFFF) */
				; 	//			/* +30, 2: (pfBO) */
;#define _CYCLE_		32	; 	int cycle;		/* +32, 4 */
;#define SIZEOF_CP1610	36	; } CP1610;			/* =36 */

;* CP1610.r[0..7] */
;#define R0		(0*2)	; CP1610\̂̐擪Ar[0..7]̊eWX^tB[hւ̃ItZbgłB
;#define R1		(1*2)	;	&cp1610.r[0] == &cp1610
;#define R2		(2*2)	; łAcp1610΂̃ItZbgƌȂƂł܂B
;#define R3		(3*2)	; ]āAƂr[4]ɃANZXꍇA
;#define R4		(4*2)	; 	xld.w %tmp, [%CPU+R+R4]
;#define R5		(5*2)	; ƌɕ\LȂĂA
;#define R6		(6*2)	;	xld.w %tmp, [%CPU+R4]
;#define R7		(7*2)	; ƕ\Lč\܂B

;* CP1610.flags */
;#define IRQ_BIT		 0	; /* 荞݂vꂽ1 */
;#define IFF_BIT		 1	; /* 荞݋ԂȂ1 */
;#define DBD_BIT		 2	; /* SDBDߎsȂ1 */
;#define HLT_BIT		 3	; /* HLTȂ1 */

;****************************************************************************
;	CP1610OP\
;****************************************************************************

; * cp1610_run()ɂāA%opCP1610OP.dstwԂŁAe߂̏֐Ă΂܂B
;   ]āAetB[hւ̃ItZbgV{́ACP1610OP.dst΂Œ`Ă܂B
; * CP1610OP.dst΂ƂŔAߒ̐ߖƍ̂߂łB
;   fncycletB[h́Ae߂̏֐͂QƂȂ̂ŁAANZXsvłB
;   ܂AdsttB[hւ̃ANZXpx΂񍂂̂ŁAdsttB[hItZbg0
;   ANZXł΁AߒZAɂȂ܂B
;   ŁAdsttB[hւ̃ANZXItZbg0ƂȂ悤ɁA%opWX^ݒ肵܂B
; * e߂̏֐߂ɁAcp1610_run()nitB[hɃANZX܂B
;   e߂̏֐́A%opWX^̒lωȂ悤AӂĂB
;
				; typedef struct _CP1610OP {
				; 	void (*fn)();		/* +0,4: ߂֐ */
				; 	unsigned char cycle;	/* +4,1: TCN */
;#define DST		 0	; 	unsigned char dst;	/* +5,1: ]惌WX^A(0/-1) */
;#define SRC		 1	; 	unsigned char src;	/* +6,1: ]WX^ACondition Code */
;#define NI		 2	; 	unsigned char ni;	/* +7,1: bit0=荞݃}XN߂Ȃ1 */
				; 				/*       bit1=SDBDC\Ȗ߂Ȃ1 */
				; } CP1610OP;			/* =8 */

;****************************************************************************
;	WX^蓖
;****************************************************************************

;#define op	r0		; ݂̖߂ɑΉACP1610OP.dstւ̃|C^ێ܂B
				; cp1610_run()ݒ肵Ae߂̏֐p܂B
				; cp1610_run()ȊO̊֐ÃWX^lύXĂ͂܂B
				; ꎞIɃReLXg𔲂ꍇɂAlێ܂B
;#define dst	r1		; ėpBCP1610OP.dst̓ǂݍݓɗp܂B
				; e߂̏֐ATu[`ɂėp܂B
				; ꎞIɃReLXg𔲂ꍇɂAlێ܂B
;#define src	r2		; ėpBCP1610OP.src̓ǂݍݓɗp܂B
				; e߂̏֐ATu[`ɂėp܂B
				; ꎞIɃReLXg𔲂ꍇɂAlێ܂B
;#define tmp	r3		; ėpB
				; e߂̏֐ATu[`ɂėp܂B
				; ꎞIɃReLXg𔲂ꍇɂAlێ܂B
;#define CPU	r4		; cp1610\̂̐擪AhXێ܂B
				; cp1610_enter()ݒ肵Acp1610_leave()܂ŕsςłB
;#define SZ	r5		; CP1610.sztB[h̒lێ܂B
				; cp1610_enter()ɂēǂݏoAcp1610_leave()ɂď߂܂B
;#define CYCLE	r6		; CP1610.cycletB[h̒lێ܂B
				; cp1610_enter()ɂēǂݏoAcp1610_leave()ɂď߂܂B

;****************************************************************************
;
;****************************************************************************

;* CP1610_TRACEV{`ƁAg[Xo͂s܂B */
;/#define CP1610_TRACE

;****************************************************************************
;
;****************************************************************************

; ̂߁ACP1610\̂RAMɔzu܂B
; RAM֔zu邽߂ɁA.codeZNVƂ܂B
	.code
	.align	2
	.global	cp1610
cp1610:
	.space	36

;****************************************************************************
;
;****************************************************************************

	.code
	.align 1

;****************************************************************************
;
;****************************************************************************

; sReLXg֓܂B
; [in]
;	܂B
; [out]
;	K̃WX^ݒ肵܂B
; [use]
;	K̃WX^ݒ肷邱ƈȊÓASWX^ۑ܂B
; [note]
;	* sReLXgÔ݌Ăяo\łB
;	  ̃[`ĂяoƁAsReLXg֓܂B
;
	.global	cp1610_enter
cp1610_enter:
	ext	cp1610+0x0@h	; 	xld.w	%r4  , cp1610
	ext	cp1610+0x0@m
	ld.w	%r4,cp1610+0x0@l
	ext	0x10		; 	xld.w	%r5   , [%r4+0x10   ]
	ld.w	%r5,[%r4]
	ext	0x20		; 	xld.w	%r6, [%r4+0x20]
	ld.w	%r6,[%r4]
	ret

; sReLXg𔲂܂B
; [in]
;	K̃WX^ݒ肳Ă邱ƁB
; [out]
;	܂B
; [use]
;	SWX^ۑ܂B
; [note]
;	* sReLXĝ݌Ăяo\łB
;	  ̃[`ĂяoƁAsReLXg𔲂܂B
;
	.global	cp1610_leave
cp1610_leave:
	ext	0x10		; 	xld.w	[%r4+0x10   ], %r5
	ld.w	[%r4],%r5
	ext	0x20		; 	xld.w	[%r4+0x20], %r6
	ld.w	[%r4],%r6
	ret

;****************************************************************************
;	sReLXgO痘p֐
;****************************************************************************

	.global	cp1610_run
cp1610_run:
	pushn	%r3
	ext	cp1610+0x20@ah	; 	xld.w	[cp1610+0x20], %r12		; cTCNi[܂BKv!!
	ext	cp1610+0x20@al
	ld.w	[%r8],%r12
	call	cp1610_enter	; 	xcall	cp1610_enter			; sReLXg֓܂B
	;
	ext	0x1a		; 	xbtst	[%r4+0x1a], 0x3		; HALTȂ΁AcsTCN0ɂāAɃ[v𔲂܂B
	btst	[%r4],0x3
	jreq	2				; (cp1610.cycle=0Ŋ֐𔲂邱ƁBK{!!)
	ld.w	%r6, 0			; (skip?)
	;
	jp	cp1610_run_LOOP	; 	xjp	cp1610_run_LOOP			; sTCN0w肳ꂽꍇ̂߂ɁA܂肩B
cp1610_run_DO:
;----------------------------------------------------------------------------
;#ifdef CP1610_TRACE
;	; g[XfobOsꍇ́ÃubNLɂĂB
;	; ̍ہAcp1610_trace()́AAvP[VɂĒ`ĂB
;	; cp1610_trace()́ACuł͒`Ă܂B
;	xcall	cp1610_leave
;	xcall	cp1610_trace
;	xcall	cp1610_enter
;#endif /*CP1610_TRACE*/
;----------------------------------------------------------------------------
	ext	0xe		; 	xld.uh	%r12, [%r4+0xe]			; %r12 =  R7
	ld.uh	%r12,[%r4]
	ext	0x1		; 	xadd	%r9, %r12, 1			; %r9  =  R7+1
	add	%r9,%r12
	ext	0xe		; 	xld.h	[%r4+0xe], %r9			; R7   =  R7+1
	ld.h	[%r4],%r9
	ext	cp1610_read@rm	; 	xcall	cp1610_read			; %r10 = [R7]
	call	cp1610_read@rl
	ext	0xf		; 	xand	%r10, %r10, 0x3ff		; %r10 = [R7]&0x3ff = OpCode
	and	%r10,0x3f
	sll	%r10,0x3	; 	xsll	%r10, 3				; %r10 = OpCode*8
	ext	cp1610op@ah
	ext	cp1610op@al
	add	%r0, %r10			; %op  = &cp1610op[OpCode*8]	(op = &op->fn   )
	ld.w	%r9, [%r0]+			; %r9  = op->fn			(op = &op->cycle)
	ld.ub	%r10, [%r0]+			; %r10 = op->cycle		(op = &op->dst  )
	call.d	%r9				; op->fn()
	sub	%r6, %r10			; cycle -= op->cycle		*delay*
	;
	ext	0x1a		; 	xbtst	[%r4+0x1a], 0x0		; if(IRQ) {
	btst	[%r4],0x0
	jreq	cp1610_run_LOOP	; 	xjreq	cp1610_run_LOOP
	ext	0x1a		; 	xbtst	[%r4+0x1a], 0x1		;   if(IFF) {
	btst	[%r4],0x1
	jreq	cp1610_run_LOOP	; 	xjreq	cp1610_run_LOOP
	ext	0x2		; 	xbtst	[%r0+0x2], 0x0			;     if(!(op->ni&1)) {
	btst	[%r0],0x0
	jrne	cp1610_run_LOOP	; 	xjrne	cp1610_run_LOOP
	ext	0x1a		; 	xbclr	[%r4+0x1a], 0x0		;       IRQ=0
	bclr	[%r4],0x0
	sub	%r6, 9			;       cycle -= 9
	ext	0xc		; 	xld.uh	%r12, [%r4+0xc]			;       %r12 = R6
	ld.uh	%r12,[%r4]
	ext	0x1		; 	xadd	%r9, %r12, 1			;       %r9  = R6+1
	add	%r9,%r12
	ext	0xc		; 	xld.h	[%r4+0xc], %r9			;       R6   = R6+1
	ld.h	[%r4],%r9
	ext	0xe		; 	xld.uh	%r13, [%r4+0xe]			;       %r13 = R7
	ld.uh	%r13,[%r4]
	ext	cp1610_write@rm	; 	xcall	cp1610_write			;       [R6] = R7
	call	cp1610_write@rl
	ext	0x1c		; 	xld.uh	%r9, [%r4+0x1c]			;       %r9  = IAB
	ld.uh	%r9,[%r4]
	ext	0xe		; 	xld.h	[%r4+0xe], %r9			;       R7   = IAB
	ld.h	[%r4],%r9
	;
cp1610_run_LOOP:				; } } }
	cmp	%r6,0x0		; 	xcmp	%r6, 0			; csTCN0ȉɂȂ܂ŌJԂ܂B
	jrgt	cp1610_run_DO	; 	xjrgt	cp1610_run_DO
	;
	call	cp1610_leave	; 	xcall	cp1610_leave			; sReLXg𔲂܂B
	popn	%r3
	ret

;****************************************************************************
;	sReLXg痘p֐
;****************************************************************************

; int cp1610_get_status()
; [in]
;	܂B
; [out]
;	%r10		status (00000000 00000000 00000000 SZVC0000)
; [use]
;	gp@K肳ĂȂWX^(%r*)́ASĔjƍlĂB
;
	.global	cp1610_get_status
cp1610_get_status:
	call	cp1610_leave	; 	xcall	cp1610_leave
	ext	cp1610_get_status_C@rm	; 	xcall	cp1610_get_status_C
	call	cp1610_get_status_C@rl
	jp	cp1610_enter	; 	xjp	cp1610_enter

; void cp1610_set_status(int status)
; [in]
;	%r12		status (???????? ???????? ???????? SZVC????)
; [out]
;	܂B
; [use]
;	gp@K肳ĂȂWX^(%r*)́ASĔjƍlĂB
;
	.global	cp1610_set_status
cp1610_set_status:
	call	cp1610_leave	; 	xcall	cp1610_leave
	ext	cp1610_set_status_C@rm	; 	xcall	cp1610_set_status_C
	call	cp1610_set_status_C@rl
	jp	cp1610_enter	; 	xjp	cp1610_enter

;*--------------------------------------------------------------------------*/

; int cp1610_data()
; [in]
;	܂B
; [out]
;	%r10		data
; [use]
;	%src,%dst,%tmp
;	gp@K肳ĂȂWX^(%r*)́ASĔjƍlĂB
;
cp1610_data:
	ext	0x1		; 	xld.ub	%r2, [%r0+0x1]			; %src   =       RS   *2
	ld.ub	%r2,[%r0]
	ext	cp1610_data_TBL@ah		; %r9    = &TBL[ RS   *2]
	ext	cp1610_data_TBL@al
	add	%r9, %r2
	ext	0x1a		; 	xbtst	[%r4+0x1a], 0x2		; if(DBD) {
	btst	[%r4],0x2
	jreq.d	cp1610_data_NO_DBD	; 	xjreq.d	cp1610_data_NO_DBD
	add	%r9, %r2			;   %r9  = &TBL[ RS   *4]				*delay*
	add	%r9, 0x20			;   %r9  = &TBL[(RS+8)*4]
	ext	0x1a		; 	xbclr	[%r4+0x1a], 0x2		;   DBD  = 0
	bclr	[%r4],0x2
	sub	%r6, 2			;   cycle -= 2
cp1610_data_NO_DBD:				; }
	ld.w	%r9, [%r9]			; %r9    =  TBL[ RS   *4] or TBL[(RS+8)*4]
	add	%r2, %r4			; %src   = &RS						*anti-interlock*
	jp	%r9
	;---------------------------------------;
cp1610_data_SBD_0:
	ext	0xe		; 	xld.uh	%r12, [%r4+0xe]			; %r12 =               R7
	ld.uh	%r12,[%r4]
	ext	0x1		; 	xadd	%r9, %r12, 1			; %r9  =               R7+1
	add	%r9,%r12
	ext	0xe		; 	xld.h	[%r4+0xe], %r9			; R7   =               R7+1
	ld.h	[%r4],%r9
	ext	cp1610_read@rm	; 	xcall	cp1610_read			; %r10 =       [       R7   ]
	call	cp1610_read@rl
	ext	cp1610_read@rm	; 	xjp.d	cp1610_read			; %r10 =      [[       R7   ]]
	jp.d	cp1610_read@rl
	ld.w	%r12, %r10			; %r12 =       [       R7   ]				*delay*
	;---------------------------------------;
cp1610_data_SBD_1:
cp1610_data_SBD_2:
cp1610_data_SBD_3:
	ld.uh	%r12, [%r2]			; %r12 =               RS
	ext	cp1610_read@rm	; 	xjp	cp1610_read			; %r10 =       [       RS   ]
	jp	cp1610_read@rl
	;---------------------------------------;
cp1610_data_SBD_4:
cp1610_data_SBD_5:
cp1610_data_SBD_7:
	ld.uh	%r12, [%r2]			; %r12 =               RS
	ext	0x1		; 	xadd	%r9, %r12, 1			; %r9  =               RS+1
	add	%r9,%r12
	ld.h	[%r2], %r9			; RS   =               RS+1
	ext	cp1610_read@rm	; 	xjp	cp1610_read			; %r10 =       [       RS  )]
	jp	cp1610_read@rl
	;---------------------------------------;
cp1610_data_SBD_6:
	ld.uh	%r12, [%r2]			; %r12 =               RS
	sub	%r12, 1				; %r12 =               RS-1
	ld.h	[%r2], %r12			; RS   =               RS-1
	ext	cp1610_read@rm	; 	xjp.d	cp1610_read			; %r10 =       [(half)(RS-1)]
	jp.d	cp1610_read@rl
	ld.uh	%r12, %r12			; %r12 =        (half)(RS-1)				*delay*
	;---------------------------------------;
cp1610_data_DBD_1:
cp1610_data_DBD_2:
cp1610_data_DBD_3:
	ld.uh	%r12, [%r2]			; %r12 =               RS
	ext	cp1610_read@rm	; 	xcall	cp1610_read			; %r10 =       [       RS   ]
	call	cp1610_read@rl
	ld.ub	%r1, %r10			; %dst = (byte)[       RS   ]
	ld.uh	%r12, [%r2]			; %r12 =               RS
	ext	cp1610_read@rm	; 	xcall	cp1610_read			; %r10 =       [       RS   ]
	call	cp1610_read@rl
	ld.ub	%r10, %r10			; %r10 = (byte)[       RS   ]
	sll	%r10,0x8	; 	xsll	%r10, 8				; %r10 = (byte)[       RS   ]<<8
	ret.d
	or	%r10, %r1			; %r10 = (byte)[       RS   ]<<8|(byte)[       RS   ]	*delay*
	;---------------------------------------;
cp1610_data_DBD_4:
cp1610_data_DBD_5:
cp1610_data_DBD_7:
	ld.uh	%r3, [%r2]			; %tmp =               RS
	ext	cp1610_read@rm	; 	xcall.d	cp1610_read			; %r10 =       [       RS   ]
	call.d	cp1610_read@rl
	ld.w	%r12, %r3			; %r12 =               RS				*delay*
	ld.ub	%r1, %r10			; %r10 = (byte)[       RS   ]
	add	%r3, 1				; %tmp =               RS+1
	ext	cp1610_read@rm	; 	xcall.d	cp1610_read			; %r10 =       [(half)(RS+1)]
	call.d	cp1610_read@rl
	ld.uh	%r12, %r3			; %r12 =        (half)(RS+1)				*delay*
	add	%r3, 1				; %tmp =               RS+2
	ld.h	[%r2], %r3			; RS   =               RS+2
	ld.ub	%r10, %r10			; %r10 = (byte)[(half)(RS+1)]
	sll	%r10,0x8	; 	xsll	%r10, 8				; %r10 = (byte)[(half)(RS+1)]<<8
	ret.d
	or	%r10, %r1			; %r10 = (byte)[(half)(RS+1)]<<8|(byte)[       RS   ]	*delay*
	;---------------------------------------;
cp1610_data_DBD_6:
	ld.uh	%r3, [%r2]			; %tmp =               RS
	sub	%r3, 1				; %tmp =               RS-1
	ext	cp1610_read@rm	; 	xcall.d	cp1610_read			; %r10 =       [(half)(RS-1)]
	call.d	cp1610_read@rl
	ld.uh	%r12, %r3			; %r12 =        (half)(RS-1)				*delay*
	ld.ub	%r1, %r10			; %r10 = (byte)[(half)(RS-1)]
	sub	%r3, 1				; %tmp =               RS-2
	ext	cp1610_read@rm	; 	xcall.d	cp1610_read			; %r10 =       [(half)(RS-2)]
	call.d	cp1610_read@rl
	ld.uh	%r12, %r3			; %r12 =        (half)(RS-2)				*delay*
	ld.h	[%r2], %r3			; RS   =               RS-2
	ld.ub	%r10, %r10			; %r10 = (byte)[(half)(RS-2)]
	sll	%r10,0x8	; 	xsll	%r10, 8				; %r10 = (byte)[(half)(RS-2)]<<8
	ret.d
	or	%r10, %r1			; %r10 = (byte)[(half)(RS-2)]<<8|(byte)[(half)(RS-1)]	*delay*
	;---------------------------------------;
	.data					; RAMߖ̂߁Ae[uSRAMɔzu܂B
	.align	2				; <-Kv!!
cp1610_data_TBL:				;
	.word	cp1610_data_SBD_0		;
	.word	cp1610_data_SBD_1		;
	.word	cp1610_data_SBD_2		;
	.word	cp1610_data_SBD_3		;
	.word	cp1610_data_SBD_4		;
	.word	cp1610_data_SBD_5		;
	.word	cp1610_data_SBD_6		;
	.word	cp1610_data_SBD_7		;
	.word	cp1610_ERR			;
	.word	cp1610_data_DBD_1		;
	.word	cp1610_data_DBD_2		;
	.word	cp1610_data_DBD_3		;
	.word	cp1610_data_DBD_4		;
	.word	cp1610_data_DBD_5		;
	.word	cp1610_data_DBD_6		;
	.word	cp1610_data_DBD_7		;
	.code					; ȍ~̔zuRAMɖ߂܂B
	.align	1				; <-̎w͖ĂłB
	;---------------------------------------;

; int cp1610_add(int a, int b)
; [in]
;	%r12		a
;	%r13		b
; [out]
;	%r10		a+b
; [use]
;	gp@K肳ĂȂWX^(%r*)́ASĔjƍlĂB
;
cp1610_add:
	ld.w	%r5, %r12			; SZ   =    a
	add	%r5, %r13			; SZ   =    a+b = t
	ext	0x14		; 	xld.w	[%r4+0x14], %r5			; C    =          t[16]
	ld.w	[%r4],%r5
	xor	%r13, %r12			; %r13 =    a^b
	not	%r13, %r13			; %r13 =  ~(a^b)
	xor	%r12, %r5			; %r12 =          a^t
	and	%r12, %r13			; %r13 =  ~(a^b)&(a^t)
	ext	0x18		; 	xld.h	[%r4+0x18], %r12			; OV   = (~(a^b)&(a^t))[15]
	ld.h	[%r4],%r12
	ld.uh	%r5, %r5			; SZ   = (half)t
	ret.d
	ld.w	%r10, %r5			; return SZ						*delay*

; int cp1610_sub(int a, int b)
; [in]
;	%r12		a
;	%r13		b
; [out]
;	%r10		a-b
; [use]
;	gp@K肳ĂȂWX^(%r*)́ASĔjƍlĂB
;
cp1610_sub:
	ld.w	%r5, %r12			; SZ   =   a
	sub	%r5, %r13			; SZ   =   a-b = t
	not	%r9, %r5			; %r9  =        ~t
	ext	0x14		; 	xld.w	[%r4+0x14], %r9			; C    =        ~t[16]
	ld.w	[%r4],%r9
	xor	%r13, %r12			; %r13 =   a^b
	xor	%r12, %r5			; %r12 =         a^t
	and	%r12, %r13			; %r13 =  (a^b)&(a^t)
	ext	0x18		; 	xld.h	[%r4+0x18], %r12			; OV   = ((a^b)&(a^t))[15]
	ld.h	[%r4],%r12
	ld.uh	%r5, %r5			; SZ   = (half)t
	ret.d
	ld.w	%r10, %r5			; return SZ						*delay*

; void cp1610_bcond(%psr)
; [in]
;	%psr(Z)		1:L or 0:򖳂
; [out]
;	܂B
; [use]
;	%dst,%tmp
;	gp@K肳ĂȂWX^(%r*)́ASĔjƍlĂB
;
	.global	cp1610_bcond
cp1610_bcond:
	ext	0xe		; 	xld.uh	%r3, [%r4+0xe]			; %tmp   =  R7
	ld.uh	%r3,[%r4]
	jrne	cp1610_bcond_NO_BRANCH	; 	xjrne	cp1610_bcond_NO_BRANCH		; if(%psr(Z)) { /* branch taken */
	ext	cp1610_read@rm	; 	xcall.d	cp1610_read			;   %r10 = [R7] = rel
	call.d	cp1610_read@rl
	ld.w	%r12, %r3			;   %r12 =  R7						*delay*
	ld.b	%r1,[%r0]	; 	xld.b	%r1, [%r0+0x0]			;   %dst = 0:O or -1:
	sub	%r6, 2			;   cycle -= 2						*anti-interlock*
	xor	%r10, %r1			;   %r10 =     (rel^(0 or -1))
	add	%r3, %r10			;   %tmp =  R7+(rel^(0 or -1))
cp1610_bcond_NO_BRANCH:				; }
	add	%r3, 1				; %tmp   =  R7+(rel^(0 or -1))+1 or R7+1
	ext	0xe		; 	xld.h	[%r4+0xe], %r3			; R7     =  R7+(rel^(0 or -1))+1 or R7+1
	ld.h	[%r4],%r3
	ret

;****************************************************************************
;	Operation
;****************************************************************************

	.global	cp1610_JSR
cp1610_JSR:
	ext	0xe		; 	xld.uh	%r3, [%r4+0xe]			; %tmp =         R7
	ld.uh	%r3,[%r4]
	ext	cp1610_read@rm	; 	xcall.d	cp1610_read			; %r10 = [       R7   ]
	call.d	cp1610_read@rl
	ld.w	%r12, %r3			; %r12 =         R7			*delay*
	ext	0x3ff		; 	xand	%r1, %r10, 0x3ff		; %dst = bb ppppppii
	and	%r1,%r10
	add	%r3, 1				; %tmp =         R7+1
	ext	cp1610_read@rm	; 	xcall.d	cp1610_read			; %r10 = [(half)(R7+1)]
	call.d	cp1610_read@rl
	ld.uh	%r12, %r3			; %r12 =  (half)(R7+1)			*delay
	ext	0x3ff		; 	xand	%r2, %r10, 0x3ff		; %src = pp pppppppp
	and	%r2,%r10
	add	%r3, 1				; %tmp =         R7+2
	ext	0xe		; 	xld.h	[%r4+0xe], %r3			; R7   =         R7+2
	ld.h	[%r4],%r3
	;
	ext	0x3		; 	xand	%r9, %r1, 3			; %r9  = ii = 0..3
	and	%r9,%r1
	cmp	%r9,0x1		; 	xcmp	%r9, 1
	jrne	3				; if(ii==1) {
	ext	26				;   IFF=1				(skip?)
	bset	[%r4], 1			; }					(skip?)
	cmp	%r9,0x2		; 	xcmp	%r9, 2
	jrne	3				; if(ii==2) {
	ext	26				;   IFF=0				(skip?)
	bclr	[%r4], 1			; }					(skip?)
	;
	ext	0x300		; 	xand	%r9, %r1, 0x300		; %r9  = bb = (0..3)*2
	and	%r9,%r1
	srl	%r9,0x7		; 	xsrl	%r9, 0x7
	ext	0xe		; 	xld.uh	%r10, [%r4+0xe]			; %r10 = R7
	ld.uh	%r10,[%r4]
	ext	cp1610+0x8@ah			; [R4 or R5 or R6 or R7] = R7
	ext	cp1610+0x8@al
	ld.h	[%r9], %r10
	;
	and	%r1,0x3c	; 	xand	%r1, %r1, -4			; %dst = bb pppppp00
	sll	%r1,0x8		; 	xsll	%r1, 8				; %dst = bb pppppp00 00000000
	or	%r1, %r2			; %dst = bb pppppppp pppppppp
	ext	0xe		; 	xld.h	[%r4+0xe], %r1			; R7   =    pppppppp pppppppp
	ld.h	[%r4],%r1
	ret

	.global	cp1610_INCR
cp1610_INCR:
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r5, [%r1]			; SZ   =  RD
	add	%r5, 1				; SZ   =  RD+1
	ld.h	[%r1], %r5			; RD   =  RD+1
	ret.d
	ld.uh	%r5, %r5			; SZ   = (half)SZ			*delay*

	.global	cp1610_DECR
cp1610_DECR:
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r5, [%r1]			; SZ   =  RD
	sub	%r5, 1				; SZ   =  RD-1
	ld.h	[%r1], %r5			; RD   =  RD-1
	ret.d
	ld.uh	%r5, %r5			; SZ   = (half)SZ			*delay*

	.global	cp1610_COMR
cp1610_COMR:
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r5, [%r1]			; SZ   =  RD
	not	%r5, %r5			; SZ   = ~RD
	ld.h	[%r1], %r5			; RD   = ~RD
	ret.d
	ld.uh	%r5, %r5			; SZ   = (half)SZ			*delay*

	.global	cp1610_NEGR
cp1610_NEGR:
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =   RD
	add	%r1, %r4			; %dst =  &RD
	ld.uh	%r13, [%r1]			; %r13 =   RD
	call.d	cp1610_sub	; 	xcall.d	cp1610_sub			; %r10 = 0-RD
	ld.w	%r12, 0				; %r12 = 0				*delay*
	ld.h	[%r1], %r10			; RD   = 0-RD
	ret

	.global	cp1610_ADCR
cp1610_ADCR:
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =     RD
	add	%r1, %r4			; %dst =    &RD
	ld.uh	%r12, [%r1]			; %r12 =     RD
	ext	0x16		; 	xld.ub	%r13, [%r4+0x16]		; %r13 = ???????C
	ld.ub	%r13,[%r4]
	call.d	cp1610_add	; 	xcall.d	cp1610_add			; %r10 =     RD+C
	and	%r13, 1				; %r13 = -------C			*delay*
	ld.h	[%r1], %r10			; RD   =     RD+C
	ret

	.global	cp1610_MOVR
cp1610_MOVR:
	ext	0x1		; 	xld.ub	%r2, [%r0+0x1]			; %src =  RS
	ld.ub	%r2,[%r0]
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD				*anti-interlock*
	add	%r2, %r4			; %src = &RS
	ld.uh	%r5, [%r2]			; SZ   =  RS
	add	%r1, %r4			; %dst = &RD				*anti-interlock*
	ld.h	[%r1], %r5			; RD   =  RS
	ret

	.global	cp1610_ADDR
cp1610_ADDR:
	ext	0x1		; 	xld.ub	%r2, [%r0+0x1]			; %src =  RS
	ld.ub	%r2,[%r0]
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r2, %r4			; %src = &RS
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r13, [%r2]			; %r13 =  RS
	ld.uh	%r12, [%r1]			; %r12 =  RD
	ext	cp1610_add@rm	; 	xcall	cp1610_add			; %r10 =  RD+RS
	call	cp1610_add@rl
	ld.h	[%r1], %r10			; RD   =  RD+RS
	ret

	.global	cp1610_SUBR
cp1610_SUBR:
	ext	0x1		; 	xld.ub	%r2, [%r0+0x1]			; %src =  RS
	ld.ub	%r2,[%r0]
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r2, %r4			; %src = &RS
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r13, [%r2]			; %r13 =  RS
	ld.uh	%r12, [%r1]			; %r12 =  RD
	ext	cp1610_sub@rm	; 	xcall	cp1610_sub			; %r10 =  RD-RS
	call	cp1610_sub@rl
	ld.h	[%r1], %r10			; RD   =  RD-RS
	ret

	.global	cp1610_CMPR
cp1610_CMPR:
	ext	0x1		; 	xld.ub	%r2, [%r0+0x1]			; %src =  RS
	ld.ub	%r2,[%r0]
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r2, %r4			; %src = &RS
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r13, [%r2]			; %r13 =  RS
	ld.uh	%r12, [%r1]			; %r12 =  RD
	ext	cp1610_sub@rm	; 	xjp	cp1610_sub			;         RD-RS
	jp	cp1610_sub@rl

	.global	cp1610_ANDR
cp1610_ANDR:
	ext	0x1		; 	xld.ub	%r2, [%r0+0x1]			; %src =  RS
	ld.ub	%r2,[%r0]
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r2, %r4			; %src = &RS
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r9, [%r2]			; %r9  =  RS
	ld.uh	%r5, [%r1]			; SZ   =  RD
	and	%r5, %r9			; SZ   =  RD&RS
	ld.h	[%r1], %r5			; RD   =  RD&RS
	ret

	.global	cp1610_XORR
cp1610_XORR:
	ext	0x1		; 	xld.ub	%r2, [%r0+0x1]			; %src =  RS
	ld.ub	%r2,[%r0]
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r2, %r4			; %src = &RS
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r9, [%r2]			; %r9  =  RS
	ld.uh	%r5, [%r1]			; SZ   =  RD
	xor	%r5, %r9			; SZ   =  RD^RS
	ld.h	[%r1], %r5			; RD   =  RD^RS
	ret

	.global	cp1610_B
cp1610_B:
	ext	cp1610_get_status@rm	; 	xcall	cp1610_get_status		; %r10    = SZVC0000
	call	cp1610_get_status@rl
	srl	%r10,0x3	; 	xsrl	%r10, 0x3			; %r10    = 000SZVC0
	ext	cp1610_cond@ah			; %r10    = cp1610_cond[(SZVC)*2]
	ext	cp1610_cond@al
	ld.uh	%r10, [%r10]
	ext	0x1		; 	xld.ub	%r2, [%r0+0x1]			; %src    = cond (0..15)
	ld.ub	%r2,[%r0]
	ld.w	%r9,%r2		; 	xsrl	%r10, %r2			; %r10    = cp1610_cond[(SZVC)*2]>>cond (%r9j!!)
	and	%r9,0x1f
	cmp	%r9,0x8
	jrle	4
	srl	%r10,0x8
	jp.d	-3
	sub	%r9,0x8
	srl	%r10,%r9
	ext	cp1610_bcond@rm	; 	xjp.d	cp1610_bcond
	jp.d	cp1610_bcond@rl
	and	%r10, 1				; %psr(Z) = 1:L or 0:򖳂	*delay*

	.global	cp1610_MVO
cp1610_MVO:
	ext	0x1		; 	xld.ub	%r2, [%r0+0x1]			; %src =  RS
	ld.ub	%r2,[%r0]
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	ext	cp1610_MVO_TBL@ah		; %r9  = &TBL[RD*2]
	ext	cp1610_MVO_TBL@al
	add	%r9, %r1
	add	%r9, %r1			; %r9  = &TBL[RD*4]
	ld.w	%r9, [%r9]			; %r9  =  TBL[RD*4]
	add	%r2, %r4			; %src = &RS
	add	%r1, %r4			; %dst = &RD
	jp	%r9
cp1610_MVO_0:
	ext	0xe		; 	xld.uh	%r12, [%r4+0xe]			; %r12   =  R7
	ld.uh	%r12,[%r4]
	ext	0x1		; 	xadd	%r9, %r12, 1			; %r9    =  R7+1
	add	%r9,%r12
	ext	0xe		; 	xld.h	[%r4+0xe], %r9			; R7     =  R7+1
	ld.h	[%r4],%r9
	ext	cp1610_read@rm	; 	xcall	cp1610_read			; %r10   = [R7]
	call	cp1610_read@rl
	ld.uh	%r13, [%r2]			; %r13   =  RS
	ext	cp1610_write@rm	; 	xjp.d	cp1610_write			; [[R7]] =  RS
	jp.d	cp1610_write@rl
	ld.w	%r12, %r10			; %r12   = [R7]				*delay*
cp1610_MVO_1:
cp1610_MVO_2:
cp1610_MVO_3:
	ld.uh	%r12, [%r1]			; %r12   =  RD
	ld.uh	%r13, [%r2]			; %r13   =  RS
	ext	cp1610_write@rm	; 	xjp	cp1610_write			; [RD]   =  RS
	jp	cp1610_write@rl
cp1610_MVO_4:
cp1610_MVO_5:
cp1610_MVO_6:
cp1610_MVO_7:
	ld.uh	%r12, [%r1]			; %r12   =  RD
	ext	0x1		; 	xadd	%r9, %r12, 1			; %r9    =  RD+1
	add	%r9,%r12
	ld.h	[%r1], %r9			; RD     =  RD+1
	ld.uh	%r13, [%r2]			; %r13   =  RS
	ext	cp1610_write@rm	; 	xjp	cp1610_write			; [RD]   =  RS
	jp	cp1610_write@rl
	;---------------------------------------;
	.data					; RAMߖ̂߁Ae[uSRAMɔzu܂B
	.align	2				; <-Kv!!
cp1610_MVO_TBL:					;
	.word	cp1610_MVO_0			;
	.word	cp1610_MVO_1			;
	.word	cp1610_MVO_2			;
	.word	cp1610_MVO_3			;
	.word	cp1610_MVO_4			;
	.word	cp1610_MVO_5			;
	.word	cp1610_MVO_6			;
	.word	cp1610_MVO_7			;
	.code					; ȍ~̔zuRAMɖ߂܂B
	.align	1				; <-̎w͖ĂłB
	;---------------------------------------;

	.global	cp1610_MVI
cp1610_MVI:
	ext	cp1610_data@rm	; 	xcall	cp1610_data			; %r10 =  data
	call	cp1610_data@rl
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r1, %r4			; %dst = &RD
	ld.h	[%r1], %r10			; RD   =  data
	ret

	.global	cp1610_ADD
cp1610_ADD:
	ext	cp1610_data@rm	; 	xcall	cp1610_data			; %r10 =  data
	call	cp1610_data@rl
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r12, [%r1]			; %r12 =  RD
	ext	cp1610_add@rm	; 	xcall.d	cp1610_add			; %r10 =  RD+data
	call.d	cp1610_add@rl
	ld.w	%r13, %r10			; %r13 =  data				*delay*
	ld.h	[%r1], %r10			; RD   =  RD+data
	ret

	.global	cp1610_SUB
cp1610_SUB:
	ext	cp1610_data@rm	; 	xcall	cp1610_data			; %r10 =  data
	call	cp1610_data@rl
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r12, [%r1]			; %r12 =  RD
	ext	cp1610_sub@rm	; 	xcall.d	cp1610_sub			; %r10 =  RD-data
	call.d	cp1610_sub@rl
	ld.w	%r13, %r10			; %r13 =  data				*delay*
	ld.h	[%r1], %r10			; RD   =  RD-data
	ret

	.global	cp1610_CMP
cp1610_CMP:
	ext	cp1610_data@rm	; 	xcall	cp1610_data			; %r10 =  data
	call	cp1610_data@rl
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r12, [%r1]			; %r12 =  RD
	ext	cp1610_sub@rm	; 	xjp.d	cp1610_sub			; %r10 =  RD-data
	jp.d	cp1610_sub@rl
	ld.w	%r13, %r10			; %r13 =  data				*delay*

	.global	cp1610_AND
cp1610_AND:
	ext	cp1610_data@rm	; 	xcall	cp1610_data			; %r10 =  data
	call	cp1610_data@rl
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r5, [%r1]			; SZ   =  RD
	and	%r5, %r10			; SZ   =  RD&data
	ld.h	[%r1], %r5			; RD   =  RD&data
	ret

	.global	cp1610_XOR
cp1610_XOR:
	ext	cp1610_data@rm	; 	xcall	cp1610_data			; %r10 =  data
	call	cp1610_data@rl
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1, [%r0+0x0]			; %dst =  RD
	add	%r1, %r4			; %dst = &RD
	ld.uh	%r5, [%r1]			; SZ   =  RD
	xor	%r5, %r10			; SZ   =  RD^data
	ld.h	[%r1], %r5			; RD   =  RD^data
	ret

;****************************************************************************
;
;****************************************************************************
