;
;	clipsp2a.s
;
;	P/ECE SPC Driver V2
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Mon Oct 11 04:21:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;
;#include "clipsp2a.h"
;/
;/	clipsp2a.h
;/
;/	P/ECE S-SMP (SPC700) Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2004 Naoyuki Sawa
;/
;/	* Mon Oct 11 04:21:00 JST 2004 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ SPC2_ASMV{`ƁAAZuR[hgp܂B
;/ SPC2_ASMV{`Ȃ΁AbR[hgp܂B
;#define SPC2_ASM

;#include "clipsp2b.h"
;
;	clipsp2b.h
;
;	P/ECE SPC Driver V2
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Thu Oct 14 19:00:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;

;
; clipsp2a.sframsp2a.sCN[h܂B 
; b\[XCN[hĂ͂܂B 
;

;****************************************************************************
;	SPC2CPU
;****************************************************************************

;
;	SPC2CPU\
;
;#define PSW_P		 0
;#define PSW_NZ		 2
;#define PSW_C		 3
;#define PSW_CNZ		 2
;#define PSW_V		 4
;#define X		 5
;#define A		 6
;#define Y		 7
;#define YA		 6
;#define SP		 8
;#define PC		12
;#define SPC2CPU_SIZE	16

;
;	֐Ăяo̊ȗ\L
;
;#macro READ
;	xcall spc2cpu_READ
;#endm
;#macro WRITE
;	xcall spc2cpu_WRITE
;#endm
;#macro READW
;	xcall spc2cpu_READW
;#endm
;#macro WRITEW
;	xcall spc2cpu_WRITEW
;#endm
;#macro ADC
;	xcall spc2cpu_ADC
;#endm
;#macro SBC
;	xcall spc2cpu_SBC
;#endm
;#macro ADDW
;	xcall spc2cpu_ADDW
;#endm
;#macro SUBW
;	xcall spc2cpu_SUBW
;#endm
;#macro BEQ
;	xcall spc2cpu_BEQ
;#endm
;#macro BNE
;	xcall spc2cpu_BNE
;#endm
;#macro DIV
;	xcall spc2cpu_DIV
;#endm
;#macro PACK_PSW
;	xcall spc2cpu_PACK_PSW
;#endm
;#macro UNPACK_PSW
;	xcall spc2cpu_UNPACK_PSW
;#endm
;#macro DIE $1
;	xld.w %r12, $1
;	xcall spc2cpu_DIE
;#endm

;
;	AhbVO[h
;
;	*** RELATIVEȊOɊւ ***
;
;	[out]
;		%r12		ЂƂ߂̃AhXB
;		%r13		ӂ߂̃AhXB()
;	[mod]
;		%r12-15		%r12-15̂A߂lƂĎgpȂWX^́A
;				AhbVO[h}N̓vZŔj󂳂ƍlĂB
;				- %r12-15̂A݂̎Ŕj󂳂ĂȂWX^A
;				  ̕ύXɂāAj󂳂悤ɂȂ\܂B
;				- ۂɂ́AAhbVO[h}N̓CXgNV̍ŏ
;				  Ă΂邱ƂقƂǂȂ̂ŁAWX^jCɂKv͂Ȃ͂łB
;
;	[note]
;		* ӂ̃AhXԂAhbVO[h̏ꍇA
;		  ЂƂ߂̃AhX]Aӂ߂̃AhX]ƂȂ邱ƂɒӂĂB
;		  ́ACXgNV\L̈Ƃ͈قȂ܂B
;
;		  <> "dp(d),dp(s)"̏ꍇA%r12=dp(s),%r13=dp(d)
;
;		  ̂悤ɂR͈ȉ̂ƂłB
;
;		  - @B̌㑱oCgтA],]̏łB
;		    Oo̗łƁA߃R[ȟɂdp(s)̃AhXǍdp(d)̃AhX܂B
;		    oIɁA@B̕яƓ킩₷Ɣf܂B
;		  - spc2cpu_READ,spc2cpu_WRITÉA%r12ɃAhXČĂяo܂B
;		    AhbVO[hvZAŏɓ]AhXREADsƂ̂ŁA
;		    %r12ɓ]AhXĂg₷łB
;
;
;	*** RELATIVEɊւ ***
;
;	[out]
;		%r1		XVꂽPCB
;	[mod]
;		%r9		RELATIVE̓CXgNV̓rŌĂ΂邱Ƃ̂ŁA
;				%r12-15Ȃ̈ʃWX^Ȃׂj󂵂܂B
;				ŁAext33̃[NWX^%r9g܂B
;				ʏ̃vO%r9gȂ̂ŁARELATIVE͔j󃌃WX^ƍlč\܂B
;
;* 1. #inm */
;#macro INMEDIATE_DATA
;	ld.ub %r12, [%r1]+		; inm = *PC++
;#endm
;* 2. dp */
;#macro DIRECT_PAGE
;	xld.uh %r15, [%r0+PSW_P]	; mem = PSW_P | *PC++
;	ld.ub %r12, [%r1]+
;	or %r12, %r15
;#endm
;* 3. dp+X */
;#macro X_INDEXED_DIRECT_PAGE
;	xld.uh %r15, [%r0+PSW_P]	; mem = PSW_P | (unsigned char)(*PC++ + X)
;	ld.ub %r12, [%r1]+
;	xld.ub %r13, [%r0+X]
;	add %r12, %r13
;	ld.ub %r12, %r12
;	or %r12, %r15
;#endm
;* 4. dp+Y */
;#macro Y_INDEXED_DIRECT_PAGE
;	xld.uh %r15, [%r0+PSW_P]	; mem = PSW_P | (unsigned char)(*PC++ + Y)
;	ld.ub %r12, [%r1]+
;	xld.ub %r13, [%r0+Y]
;	add %r12, %r13
;	ld.ub %r12, %r12
;	or %r12, %r15
;#endm
;* 5. (X) */
;#macro INDIRECT
;	xld.uh %r15, [%r0+PSW_P]	; mem = PSW_P | X
;	xld.ub %r12, [%r0+X]
;	or %r12, %r15
;#endm
;* 6. (X)+ */
;#macro INDIRECT_AUTO_INCREMENT
;	xld.uh %r15, [%r0+PSW_P]	; mem = PSW_P | X++
;	xld.ub %r12, [%r0+X]
;	xadd %r13, %r12, 1
;	xld.b [%r0+X], %r13
;	or %r12, %r15
;#endm
;* 7. (X),(Y) */
;#macro INDIRECT_PAGE_TO_IP
;	xld.uh %r15, [%r0+PSW_P]
;	xld.ub %r12, [%r0+Y]		; src = PSW_P | Y
;	xld.ub %r13, [%r0+X]		; dst = PSW_P | X
;	or %r12, %r15
;	or %r13, %r15
;#endm
;* 8. dp(d),dp(s) */
;#macro DIRECT_PAGE_TO_DP
;	xld.uh %r15, [%r0+PSW_P]
;	ld.ub %r12, [%r1]+		; src = PSW_P | *PC++
;	ld.ub %r13, [%r1]+		; dst = PSW_P | *PC++
;	or %r12, %r15
;	or %r13, %r15
;#endm
;* 9. dp,#inm */
;#macro INMEDIATE_DATA_TO_DP
;	xld.uh %r15, [%r0+PSW_P]
;	ld.ub %r12, [%r1]+		; inm = *PC++
;	ld.ub %r13, [%r1]+		; mem = PSW_P | *PC++
;	or %r13, %r15
;#endm
;* 10. labs */
;#macro ABSOLUTE
;	ld.ub %r12, [%r1]+		; mem  = *PC++
;	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
;	xsll %r13, 8
;	or %r12, %r13
;#endm
;* 11. labs+X */
;#macro X_INDEXED_ABSOLUTE
;	ld.ub %r12, [%r1]+		; mem  = *PC++
;	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
;	xld.ub %r14, [%r0+X]		; mem  = (unsigned short)(mem + X)
;	xsll %r13, 8
;	or %r12, %r13
;	add %r12, %r14
;	ld.uh %r12, %r12
;#endm
;* 12. labs+Y */
;#macro Y_INDEXED_ABSOLUTE
;	ld.ub %r12, [%r1]+		; mem  = *PC++
;	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
;	xld.ub %r14, [%r0+Y]		; mem  = (unsigned short)(mem + Y)
;	xsll %r13, 8
;	or %r12, %r13
;	add %r12, %r14
;	ld.uh %r12, %r12
;#endm
;* 13. (dp+X) */
;#macro X_INDEXED_INDIRECT
;	xld.uh %r15, [%r0+PSW_P]	; mem = PSW_P | (unsigned char)(*PC++ + X)
;	ld.ub %r13, [%r1]+
;	xld.ub %r14, [%r0+X]
;	add %r13, %r14
;	ld.ub %r13, %r13
;	or %r13, %r15
;	ext spc2ram@ah			; mem = spc2ram[mem] | spc2ram[mem + 1] << 8
;	ext spc2ram@al
;	add %r13, %r13
;	ld.ub %r12, [%r13]+
;	ld.ub %r13, [%r13]
;	xsll %r13, 8
;	or %r12, %r13
;#endm
;* 14. (dp)+Y */
;#macro INDIRECT_Y_INDEXED_INDIRECT
;	xld.uh %r15, [%r0+PSW_P]	; mem = PSW_P | *PC++
;	ld.ub %r13, [%r1]+
;	or %r13, %r15
;	ext spc2ram@ah			; mem = spc2ram[mem] | spc2ram[mem + 1] << 8
;	ext spc2ram@al			; mem = (unsigned short)(mem + Y)
;	add %r13, %r13
;	ld.ub %r12, [%r13]+
;	ld.ub %r13, [%r13]
;	xld.ub %r14, [%r0+Y]
;	xsll %r13, 8
;	or %r12, %r13
;	add %r12, %r14
;	ld.uh %r12, %r12
;#endm
;* 15. rel */
;#macro RELATIVE
	; ̃AhbVO[hCXgNV̐擪ŌĂ΂̂ɑ΂A
	; RELATIVE̓CXgNV̓rŌĂ΂邱Ƃ̂ŁA
	; %r12-15Ȃ̈ʃWX^Ȃׂj󂵂܂B
	; ŁAext33̃[NWX^%r9g܂B
	; RELATIVE̎ɁAext33̊g(xldƂ)gȂ悤ACĂB
;	ld.b %r9, [%r1]+		; tmp = (char)*PC++
;	ext spc2ram@ah			; PC = &spc2ram[(unsigned short)(PC - spc2ram + tmp)]
;	ext spc2ram@al
;	sub %r1, %r1
;	add %r1, %r9
;	ld.uh %r1, %r1
;	ext spc2ram@ah
;	ext spc2ram@al
;	add %r1, %r1
;#endm
;* 16. (labs+X) */
;#macro X_INDEXED_ABSOLUTE_INDIRECT
;	ld.ub %r13, [%r1]+		; mem  = *PC++
;	ld.ub %r14, [%r1]+		; mem |= *PC++ << 8
;	xld.ub %r15, [%r0+X]		; mem  = (unsigned short)(mem + X)
;	xsll %r14, 8
;	or %r13, %r14
;	add %r13, %r15
;	ld.uh %r13, %r13
;	ext spc2ram@ah			; mem  = spc2ram[mem] | spc2ram[mem + 1] << 8
;	ext spc2ram@al
;	add %r13, %r13
;	ld.ub %r12, [%r13]+
;	ld.ub %r13, [%r13]
;	xsll %r13, 8
;	or %r12, %r13
;#endm
;* 17. mem.bit */
;#macro ABSOLUTE_BOOLEAN_BIT
;	ld.ub %r13, [%r1]+		; bit   = *PC++
;	ld.ub %r14, [%r1]+		; bit  |= *PC++ << 8
;	xsll %r14, 8
;	or %r13, %r14
;	xand %r12, %r13, 0x1fff		; mem   = bit & 0x1fff
;	xsrl %r13, 13			; bit >>= 13
;#endm

;****************************************************************************
;	SPC2DSP
;****************************************************************************

;
;	SPC2VCE\
;
;#define STATE		 0
;#define VOL		 4
;#define P		 8
;#define AR		12
;#define DR		16
;#define SR		20
;#define SL		24
;#define GAIN		28
;#define ENVX		32
;#define LSA		36
;#define BRR_ADDR	40
;#define LAST_LOOP	44
;#define PROGRESS	48
;#define SAMPLE		52

;
;	SPC2DSP\
;
;#define MVOL		  0
;#define VCE		  4
;#define REG		676

;****************************************************************************

;#ifdef SPC2_ASM

	.code
	.align 1

;****************************************************************************
;	SPC2CPU
;****************************************************************************

;============================================================================
;	4. 8-BIT ARITHMETIC OPERATION COMMANDS
;============================================================================

	.global spc2cpu_0x88
spc2cpu_0x88: ; ADC A,#inm
	ld.ub %r12, [%r1]+		; inm = *PC++	; 	INMEDIATE_DATA
	ld.w %r15, %r12
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x86
spc2cpu_0x86: ; ADC A,(X)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | X	; 	INDIRECT
	ext	0x5		; 	xld.ub %r12, [%r0+0x5]
	ld.ub	%r12,[%r0]
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x84
spc2cpu_0x84: ; ADC A,dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x94
spc2cpu_0x94: ; ADC A,dp+X
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | (unsigned char)(*PC++ + X)	; 	X_INDEXED_DIRECT_PAGE
	ld.ub %r12, [%r1]+
	ext	0x5		; 	xld.ub %r13, [%r0+0x5]
	ld.ub	%r13,[%r0]
	add %r12, %r13
	ld.ub %r12, %r12
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x85
spc2cpu_0x85: ; ADC A,labs
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x95
spc2cpu_0x95: ; ADC A,labs+X
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	X_INDEXED_ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	ext	0x5		; 	xld.ub %r14, [%r0+0x5]		; mem  = (unsigned short)(mem + X)
	ld.ub	%r14,[%r0]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	add %r12, %r14
	ld.uh %r12, %r12
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x96
spc2cpu_0x96: ; ADC A,labs+Y
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	Y_INDEXED_ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	ext	0x7		; 	xld.ub %r14, [%r0+0x7]		; mem  = (unsigned short)(mem + Y)
	ld.ub	%r14,[%r0]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	add %r12, %r14
	ld.uh %r12, %r12
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x87
spc2cpu_0x87: ; ADC A,(dp+X)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | (unsigned char)(*PC++ + X)	; 	X_INDEXED_INDIRECT
	ld.ub %r13, [%r1]+
	ext	0x5		; 	xld.ub %r14, [%r0+0x5]
	ld.ub	%r14,[%r0]
	add %r13, %r14
	ld.ub %r13, %r13
	or %r13, %r15
	ext spc2ram@ah			; mem = spc2ram[mem] | spc2ram[mem + 1] << 8
	ext spc2ram@al
	add %r13, %r13
	ld.ub %r12, [%r13]+
	ld.ub %r13, [%r13]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x97
spc2cpu_0x97: ; ADC A,(dp)+Y
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	INDIRECT_Y_INDEXED_INDIRECT
	ld.ub %r13, [%r1]+
	or %r13, %r15
	ext spc2ram@ah			; mem = spc2ram[mem] | spc2ram[mem + 1] << 8
	ext spc2ram@al			; mem = (unsigned short)(mem + Y)
	add %r13, %r13
	ld.ub %r12, [%r13]+
	ld.ub %r13, [%r13]
	ext	0x7		; 	xld.ub %r14, [%r0+0x7]
	ld.ub	%r14,[%r0]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	add %r12, %r14
	ld.uh %r12, %r12
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x99
spc2cpu_0x99: ; ADC (X),(Y)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; 	INDIRECT_PAGE_TO_IP
	ext	0x7		; 	xld.ub %r12, [%r0+0x7]		; src = PSW_P | Y
	ld.ub	%r12,[%r0]
	ext	0x5		; 	xld.ub %r13, [%r0+0x5]		; dst = PSW_P | X
	ld.ub	%r13,[%r0]
	or %r12, %r15
	or %r13, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ld.w %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r14, %r10
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x89
spc2cpu_0x89: ; ADC dp(d),dp(s)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; 	DIRECT_PAGE_TO_DP
	ld.ub %r12, [%r1]+		; src = PSW_P | *PC++
	ld.ub %r13, [%r1]+		; dst = PSW_P | *PC++
	or %r12, %r15
	or %r13, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ld.w %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r14, %r10
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x98
spc2cpu_0x98: ; ADC dp,#inm
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; 	INMEDIATE_DATA_TO_DP
	ld.ub %r12, [%r1]+		; inm = *PC++
	ld.ub %r13, [%r1]+		; mem = PSW_P | *PC++
	or %r13, %r15
	ld.w %r15, %r12
	ld.w %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r14, %r10
	ext	spc2cpu_ADC@rm	; 	xcall spc2cpu_ADC	; 	ADC
	call	spc2cpu_ADC@rl
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

;----------------------------------------------------------------------------

	.global spc2cpu_0xA8
spc2cpu_0xA8: ; SBC A,#inm
	ld.ub %r12, [%r1]+		; inm = *PC++	; 	INMEDIATE_DATA
	ld.w %r15, %r12
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xA6
spc2cpu_0xA6: ; SBC A,(X)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | X	; 	INDIRECT
	ext	0x5		; 	xld.ub %r12, [%r0+0x5]
	ld.ub	%r12,[%r0]
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xA4
spc2cpu_0xA4: ; SBC A,dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xB4
spc2cpu_0xB4: ; SBC A,dp+X
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | (unsigned char)(*PC++ + X)	; 	X_INDEXED_DIRECT_PAGE
	ld.ub %r12, [%r1]+
	ext	0x5		; 	xld.ub %r13, [%r0+0x5]
	ld.ub	%r13,[%r0]
	add %r12, %r13
	ld.ub %r12, %r12
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xA5
spc2cpu_0xA5: ; SBC A,labs
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xB5
spc2cpu_0xB5: ; SBC A,labs+X
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	X_INDEXED_ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	ext	0x5		; 	xld.ub %r14, [%r0+0x5]		; mem  = (unsigned short)(mem + X)
	ld.ub	%r14,[%r0]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	add %r12, %r14
	ld.uh %r12, %r12
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xB6
spc2cpu_0xB6: ; SBC A,labs+Y
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	Y_INDEXED_ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	ext	0x7		; 	xld.ub %r14, [%r0+0x7]		; mem  = (unsigned short)(mem + Y)
	ld.ub	%r14,[%r0]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	add %r12, %r14
	ld.uh %r12, %r12
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xA7
spc2cpu_0xA7: ; SBC A,(dp+X)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | (unsigned char)(*PC++ + X)	; 	X_INDEXED_INDIRECT
	ld.ub %r13, [%r1]+
	ext	0x5		; 	xld.ub %r14, [%r0+0x5]
	ld.ub	%r14,[%r0]
	add %r13, %r14
	ld.ub %r13, %r13
	or %r13, %r15
	ext spc2ram@ah			; mem = spc2ram[mem] | spc2ram[mem + 1] << 8
	ext spc2ram@al
	add %r13, %r13
	ld.ub %r12, [%r13]+
	ld.ub %r13, [%r13]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xB7
spc2cpu_0xB7: ; SBC A,(dp)+Y
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	INDIRECT_Y_INDEXED_INDIRECT
	ld.ub %r13, [%r1]+
	or %r13, %r15
	ext spc2ram@ah			; mem = spc2ram[mem] | spc2ram[mem + 1] << 8
	ext spc2ram@al			; mem = (unsigned short)(mem + Y)
	add %r13, %r13
	ld.ub %r12, [%r13]+
	ld.ub %r13, [%r13]
	ext	0x7		; 	xld.ub %r14, [%r0+0x7]
	ld.ub	%r14,[%r0]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	add %r12, %r14
	ld.uh %r12, %r12
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xB9
spc2cpu_0xB9: ; SBC (X),(Y)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; 	INDIRECT_PAGE_TO_IP
	ext	0x7		; 	xld.ub %r12, [%r0+0x7]		; src = PSW_P | Y
	ld.ub	%r12,[%r0]
	ext	0x5		; 	xld.ub %r13, [%r0+0x5]		; dst = PSW_P | X
	ld.ub	%r13,[%r0]
	or %r12, %r15
	or %r13, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ld.w %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r14, %r10
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0xA9
spc2cpu_0xA9: ; SBC dp(d),dp(s)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; 	DIRECT_PAGE_TO_DP
	ld.ub %r12, [%r1]+		; src = PSW_P | *PC++
	ld.ub %r13, [%r1]+		; dst = PSW_P | *PC++
	or %r12, %r15
	or %r13, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ld.w %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r14, %r10
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0xB8
spc2cpu_0xB8: ; SBC dp,#inm
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; 	INMEDIATE_DATA_TO_DP
	ld.ub %r12, [%r1]+		; inm = *PC++
	ld.ub %r13, [%r1]+		; mem = PSW_P | *PC++
	or %r13, %r15
	ld.w %r15, %r12
	ld.w %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r14, %r10
	ext	spc2cpu_SBC@rm	; 	xcall spc2cpu_SBC	; 	SBC
	call	spc2cpu_SBC@rl
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

;----------------------------------------------------------------------------

	.global spc2cpu_0x68
spc2cpu_0x68: ; CMP A,#inm
	ld.ub %r12, [%r1]+		; inm = *PC++	; 	INMEDIATE_DATA
	ld.w %r15, %r12
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x66
spc2cpu_0x66: ; CMP A,(X)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | X	; 	INDIRECT
	ext	0x5		; 	xld.ub %r12, [%r0+0x5]
	ld.ub	%r12,[%r0]
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x64
spc2cpu_0x64: ; CMP A,dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x74
spc2cpu_0x74: ; CMP A,dp+X
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | (unsigned char)(*PC++ + X)	; 	X_INDEXED_DIRECT_PAGE
	ld.ub %r12, [%r1]+
	ext	0x5		; 	xld.ub %r13, [%r0+0x5]
	ld.ub	%r13,[%r0]
	add %r12, %r13
	ld.ub %r12, %r12
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x65
spc2cpu_0x65: ; CMP A,labs
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x75
spc2cpu_0x75: ; CMP A,labs+X
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	X_INDEXED_ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	ext	0x5		; 	xld.ub %r14, [%r0+0x5]		; mem  = (unsigned short)(mem + X)
	ld.ub	%r14,[%r0]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	add %r12, %r14
	ld.uh %r12, %r12
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x76
spc2cpu_0x76: ; CMP A,labs+Y
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	Y_INDEXED_ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	ext	0x7		; 	xld.ub %r14, [%r0+0x7]		; mem  = (unsigned short)(mem + Y)
	ld.ub	%r14,[%r0]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	add %r12, %r14
	ld.uh %r12, %r12
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x67
spc2cpu_0x67: ; CMP A,(dp+X)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | (unsigned char)(*PC++ + X)	; 	X_INDEXED_INDIRECT
	ld.ub %r13, [%r1]+
	ext	0x5		; 	xld.ub %r14, [%r0+0x5]
	ld.ub	%r14,[%r0]
	add %r13, %r14
	ld.ub %r13, %r13
	or %r13, %r15
	ext spc2ram@ah			; mem = spc2ram[mem] | spc2ram[mem + 1] << 8
	ext spc2ram@al
	add %r13, %r13
	ld.ub %r12, [%r13]+
	ld.ub %r13, [%r13]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x77
spc2cpu_0x77: ; CMP A,(dp)+Y
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	INDIRECT_Y_INDEXED_INDIRECT
	ld.ub %r13, [%r1]+
	or %r13, %r15
	ext spc2ram@ah			; mem = spc2ram[mem] | spc2ram[mem + 1] << 8
	ext spc2ram@al			; mem = (unsigned short)(mem + Y)
	add %r13, %r13
	ld.ub %r12, [%r13]+
	ld.ub %r13, [%r13]
	ext	0x7		; 	xld.ub %r14, [%r0+0x7]
	ld.ub	%r14,[%r0]
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	add %r12, %r14
	ld.uh %r12, %r12
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.ub %r14, [%r0+0x6]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x79
spc2cpu_0x79: ; CMP (X),(Y)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; 	INDIRECT_PAGE_TO_IP
	ext	0x7		; 	xld.ub %r12, [%r0+0x7]		; src = PSW_P | Y
	ld.ub	%r12,[%r0]
	ext	0x5		; 	xld.ub %r13, [%r0+0x5]		; dst = PSW_P | X
	ld.ub	%r13,[%r0]
	or %r12, %r15
	or %r13, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r14, %r10
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x69
spc2cpu_0x69: ; CMP dp(d),dp(s)
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; 	DIRECT_PAGE_TO_DP
	ld.ub %r12, [%r1]+		; src = PSW_P | *PC++
	ld.ub %r13, [%r1]+		; dst = PSW_P | *PC++
	or %r12, %r15
	or %r13, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ld.w %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r14, %r10
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x78
spc2cpu_0x78: ; CMP dp,#inm
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; 	INMEDIATE_DATA_TO_DP
	ld.ub %r12, [%r1]+		; inm = *PC++
	ld.ub %r13, [%r1]+		; mem = PSW_P | *PC++
	or %r13, %r15
	ld.w %r15, %r12
	ld.w %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r14, %r10
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0xC8
spc2cpu_0xC8: ; CMP X,#inm
	ld.ub %r12, [%r1]+		; inm = *PC++	; 	INMEDIATE_DATA
	ld.w %r15, %r12
	ext	0x5		; 	xld.ub %r14, [%r0+0x5]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x3E
spc2cpu_0x3E: ; CMP X,dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x5		; 	xld.ub %r14, [%r0+0x5]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x1E
spc2cpu_0x1E: ; CMP X,labs
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x5		; 	xld.ub %r14, [%r0+0x5]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0xAD
spc2cpu_0xAD: ; CMP Y,#inm
	ld.ub %r12, [%r1]+		; inm = *PC++	; 	INMEDIATE_DATA
	ld.w %r15, %r12
	ext	0x7		; 	xld.ub %r14, [%r0+0x7]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x7E
spc2cpu_0x7E: ; CMP Y,dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x7		; 	xld.ub %r14, [%r0+0x7]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

	.global spc2cpu_0x5E
spc2cpu_0x5E: ; CMP Y,labs
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w %r15, %r10
	ext	0x7		; 	xld.ub %r14, [%r0+0x7]
	ld.ub	%r14,[%r0]
	sub %r14, %r15
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

;============================================================================
;	6. ADDITION & SUBTRACTION COMMANDS
;============================================================================

	.global spc2cpu_0xBC
spc2cpu_0xBC: ; INC A
	ext	0x6		; 	xld.ub %r10, [%r0+0x6]
	ld.ub	%r10,[%r0]
	ext	0x1		; 	xadd %r13, %r10, 1
	add	%r13,%r10
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xAB
spc2cpu_0xAB: ; INC dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x1		; 	xadd %r13, %r10, 1
	add	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xBB
spc2cpu_0xBB: ; INC dp+X
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | (unsigned char)(*PC++ + X)	; 	X_INDEXED_DIRECT_PAGE
	ld.ub %r12, [%r1]+
	ext	0x5		; 	xld.ub %r13, [%r0+0x5]
	ld.ub	%r13,[%r0]
	add %r12, %r13
	ld.ub %r12, %r12
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x1		; 	xadd %r13, %r10, 1
	add	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xAC
spc2cpu_0xAC: ; INC labs
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x1		; 	xadd %r13, %r10, 1
	add	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x3D
spc2cpu_0x3D: ; INC X
	ext	0x5		; 	xld.ub %r10, [%r0+0x5]
	ld.ub	%r10,[%r0]
	ext	0x1		; 	xadd %r13, %r10, 1
	add	%r13,%r10
	ext	0x5		; 	xld.b [%r0+0x5], %r13
	ld.b	[%r0],%r13
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xFC
spc2cpu_0xFC: ; INC Y
	ext	0x7		; 	xld.ub %r10, [%r0+0x7]
	ld.ub	%r10,[%r0]
	ext	0x1		; 	xadd %r13, %r10, 1
	add	%r13,%r10
	ext	0x7		; 	xld.b [%r0+0x7], %r13
	ld.b	[%r0],%r13
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

;----------------------------------------------------------------------------

	.global spc2cpu_0x9C
spc2cpu_0x9C: ; DEC A
	ext	0x6		; 	xld.ub %r10, [%r0+0x6]
	ld.ub	%r10,[%r0]
	ext	0x1		; 	xsub %r13, %r10, 1
	sub	%r13,%r10
	ext	0x6		; 	xld.b [%r0+0x6], %r13
	ld.b	[%r0],%r13
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x8B
spc2cpu_0x8B: ; DEC dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x1		; 	xsub %r13, %r10, 1
	sub	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x9B
spc2cpu_0x9B: ; DEC dp-X
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | (unsigned char)(*PC++ + X)	; 	X_INDEXED_DIRECT_PAGE
	ld.ub %r12, [%r1]+
	ext	0x5		; 	xld.ub %r13, [%r0+0x5]
	ld.ub	%r13,[%r0]
	add %r12, %r13
	ld.ub %r12, %r12
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x1		; 	xsub %r13, %r10, 1
	sub	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x8C
spc2cpu_0x8C: ; DEC labs
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x1		; 	xsub %r13, %r10, 1
	sub	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x1D
spc2cpu_0x1D: ; DEC X
	ext	0x5		; 	xld.ub %r10, [%r0+0x5]
	ld.ub	%r10,[%r0]
	ext	0x1		; 	xsub %r13, %r10, 1
	sub	%r13,%r10
	ext	0x5		; 	xld.b [%r0+0x5], %r13
	ld.b	[%r0],%r13
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0xDC
spc2cpu_0xDC: ; DEC Y
	ext	0x7		; 	xld.ub %r10, [%r0+0x7]
	ld.ub	%r10,[%r0]
	ext	0x1		; 	xsub %r13, %r10, 1
	sub	%r13,%r10
	ext	0x7		; 	xld.b [%r0+0x7], %r13
	ld.b	[%r0],%r13
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

;============================================================================
;	8. 16-BIT TRANSMISION COMMANDS
;============================================================================

	.global spc2cpu_0xBA
spc2cpu_0xBA: ; MOVW YA,dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READW@rm	; 	xcall spc2cpu_READW	; 	READW				; YA = READW(mem)
	call	spc2cpu_READW@rl
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	ext	0x7		; 	xand %r15, %r10, 0xffff		; PSW_NZ = (YA >> 8) | (YA != 0)
	ext	0x1fff
	and	%r15,%r10
	jreq.d 3
	srl %r10, 8			; *delay*
	or %r10, 1
	ext	0x2		; 	xld.b [%r0+0x2], %r10
	ld.b	[%r0],%r10
	ret

	.global spc2cpu_0xDA
spc2cpu_0xDA: ; MOVW dp,YA
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	0x6		; 	xld.uh %r13, [%r0+0x6]
	ld.uh	%r13,[%r0]
	ext	spc2cpu_WRITEW@rm	; 	xcall spc2cpu_WRITEW	; 	WRITEW
	call	spc2cpu_WRITEW@rl
	ret

;============================================================================
;	9. 16-BIT OPERATION COMMANDS
;============================================================================

	.global spc2cpu_0x3A
spc2cpu_0x3A: ; INCW dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READW@rm	; 	xcall spc2cpu_READW	; 	READW
	call	spc2cpu_READW@rl
	ext	0x1		; 	xadd %r13, %r10, 1
	add	%r13,%r10
	ext	spc2cpu_WRITEW@rm	; 	xcall spc2cpu_WRITEW	; 	WRITEW
	call	spc2cpu_WRITEW@rl
	ext	0x7		; 	xand %r15, %r13, 0xffff		; PSW_NZ = (YA >> 8) | (YA != 0)
	ext	0x1fff
	and	%r15,%r13
	jreq.d 3
	srl %r13, 8			; *delay*
	or %r13, 1
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x1A
spc2cpu_0x1A: ; DECW dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READW@rm	; 	xcall spc2cpu_READW	; 	READW
	call	spc2cpu_READW@rl
	ext	0x1		; 	xsub %r13, %r10, 1
	sub	%r13,%r10
	ext	spc2cpu_WRITEW@rm	; 	xcall spc2cpu_WRITEW	; 	WRITEW
	call	spc2cpu_WRITEW@rl
	ext	0x7		; 	xand %r15, %r13, 0xffff		; PSW_NZ = (YA >> 8) | (YA != 0)
	ext	0x1fff
	and	%r15,%r13
	jreq.d 3
	srl %r13, 8			; *delay*
	or %r13, 1
	ext	0x2		; 	xld.b [%r0+0x2], %r13
	ld.b	[%r0],%r13
	ret

	.global spc2cpu_0x7A
spc2cpu_0x7A: ; ADDW YA,dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READW@rm	; 	xcall spc2cpu_READW	; 	READW
	call	spc2cpu_READW@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.uh %r14, [%r0+0x6]
	ld.uh	%r14,[%r0]
	ext	spc2cpu_ADDW@rm	; 	xcall spc2cpu_ADDW	; 	ADDW
	call	spc2cpu_ADDW@rl
	ext	0x6		; 	xld.h [%r0+0x6], %r13
	ld.h	[%r0],%r13
	ret

	.global spc2cpu_0x9A
spc2cpu_0x9A: ; SUBW YA,dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READW@rm	; 	xcall spc2cpu_READW	; 	READW
	call	spc2cpu_READW@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.uh %r14, [%r0+0x6]
	ld.uh	%r14,[%r0]
	ext	spc2cpu_SUBW@rm	; 	xcall spc2cpu_SUBW	; 	SUBW
	call	spc2cpu_SUBW@rl
	ext	0x6		; 	xld.h [%r0+0x6], %r13
	ld.h	[%r0],%r13
	ret

	.global spc2cpu_0x5A
spc2cpu_0x5A: ; CMPW YA,dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READW@rm	; 	xcall spc2cpu_READW	; 	READW				; tmp = YA - READW(mem)
	call	spc2cpu_READW@rl
	ld.w %r15, %r10
	ext	0x6		; 	xld.uh %r14, [%r0+0x6]
	ld.uh	%r14,[%r0]
	sub %r14, %r15
	ext	0x7		; 	xand %r15, %r14, 0xffff		; PSW_CNZ = ((tmp >> 8) | ((unsigned short)tmp != 0)) ^ 0x100
	ext	0x1fff
	and	%r15,%r14
	jreq.d 3
	srl %r14, 8			; *delay*
	or %r14, 1
	ext	0x4		; 	xxor %r14, %r14, 0x100
	xor	%r14,0x0
	ext	0x2		; 	xld.h [%r0+0x2], %r14
	ld.h	[%r0],%r14
	ret

;============================================================================
;	10. MULTIPLICATION & DIVISON COMMANDS
;============================================================================

	.global spc2cpu_0xCF
spc2cpu_0xCF: ; MUL YA
	ext	0x6		; 	xld.ub %r10, [%r0+0x6]		; YA = A * Y
	ld.ub	%r10,[%r0]
	ext	0x7		; 	xld.ub %r11, [%r0+0x7]
	ld.ub	%r11,[%r0]
	mltu.h %r10, %r11
	ld.w %r10, %alr
	ext	0x6		; 	xld.h [%r0+0x6], %r10
	ld.h	[%r0],%r10
	ld.w %r11, %r10			; PSW_NZ = (YA >> 8) | (YA != 0)
	ext	0x3ff		; 	xand %r10, %r10, 0xffff
	and	%r10,0x3f
	jreq.d 3
	srl %r11, 8			; *delay*
	or %r11, 1
	ext	0x2		; 	xld.b [%r0+0x2], %r11
	ld.b	[%r0],%r11
	ret

	.global spc2cpu_0x9E
spc2cpu_0x9E: ; DIV YA,X
	ext	spc2cpu_DIV@rm	; 	xcall spc2cpu_DIV	; 	DIV
	call	spc2cpu_DIV@rl
	ret

;============================================================================
;	11. DECIMAL COMPENSATION COMMANDS
;============================================================================

	.global spc2cpu_0xDF
spc2cpu_0xDF: ; DAA A
	ext	0x3		; 	xld.w %r12, 0xDF	; 	DIE 0xDF
	ld.w	%r12,0x1f
	ext	spc2cpu_DIE@rm	; 	xcall spc2cpu_DIE
	call	spc2cpu_DIE@rl
	.global spc2cpu_0xBE
spc2cpu_0xBE: ; DAS A
	ext	0x2		; 	xld.w %r12, 0xBE	; 	DIE 0xBE
	ld.w	%r12,0x3e
	ext	spc2cpu_DIE@rm	; 	xcall spc2cpu_DIE
	call	spc2cpu_DIE@rl

;============================================================================
;	13. SUB-ROUTINE CALL RETURN COMMANDS
;============================================================================

	.global spc2cpu_0x3F
spc2cpu_0x3F: ; CALL labs
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext spc2ram@ah			; tmp = PC - spc2ram
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext spc2ram@ah			; PC = &spc2ram[mem]
	ext spc2ram@al
	add %r1, %r12
	ret

	.global spc2cpu_0x4F
spc2cpu_0x4F: ; PCALL upage
	ld.ub %r12, [%r1]+		; inm = *PC++	; 	INMEDIATE_DATA
	ext spc2ram@ah			; tmp = PC - spc2ram
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext spc2ram+0xff00@ah		; PC = &spc2ram[0xff00 + inm]
	ext spc2ram+0xff00@al
	add %r1, %r12
	ret

;#macro TCALL $1
;	ext spc2ram@ah			; tmp = PC - spc2ram
;	ext spc2ram@al
;	sub %r1, %r1
;	xld.w %r10, [%r0+SP]
;	xrr %r1, 8			; *SP-- = tmp >> 8
;	xld.b [%r10], %r1
;	xsub %r10, %r10, 1
;	xrl %r1, 8			; *SP-- = tmp
;	xld.b [%r10], %r1
;	xsub %r10, %r10, 1
;	xld.w [%r0+SP], %r10
;	xld.ub %r10, [spc2ext+((15-$1)<<1)+0]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
;	xld.ub %r11, [spc2ext+((15-$1)<<1)+1]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
;	xsll %r11, 8
;	or %r10, %r11
;	ext spc2ram@ah
;	ext spc2ram@al
;	add %r1, %r10
;	ret
;#endm

	.global spc2cpu_0x01
spc2cpu_0x01: ; TCALL0
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 0
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x1e@ah	; 	xld.ub %r10, [spc2ext+0x1e]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x1e@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x1f@ah	; 	xld.ub %r11, [spc2ext+0x1f]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x1f@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0x11
spc2cpu_0x11: ; TCALL1
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 1
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x1c@ah	; 	xld.ub %r10, [spc2ext+0x1c]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x1c@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x1d@ah	; 	xld.ub %r11, [spc2ext+0x1d]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x1d@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0x21
spc2cpu_0x21: ; TCALL2
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 2
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x1a@ah	; 	xld.ub %r10, [spc2ext+0x1a]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x1a@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x1b@ah	; 	xld.ub %r11, [spc2ext+0x1b]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x1b@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0x31
spc2cpu_0x31: ; TCALL3
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 3
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x18@ah	; 	xld.ub %r10, [spc2ext+0x18]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x18@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x19@ah	; 	xld.ub %r11, [spc2ext+0x19]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x19@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0x41
spc2cpu_0x41: ; TCALL4
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 4
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x16@ah	; 	xld.ub %r10, [spc2ext+0x16]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x16@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x17@ah	; 	xld.ub %r11, [spc2ext+0x17]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x17@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0x51
spc2cpu_0x51: ; TCALL5
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 5
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x14@ah	; 	xld.ub %r10, [spc2ext+0x14]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x14@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x15@ah	; 	xld.ub %r11, [spc2ext+0x15]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x15@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0x61
spc2cpu_0x61: ; TCALL6
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 6
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x12@ah	; 	xld.ub %r10, [spc2ext+0x12]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x12@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x13@ah	; 	xld.ub %r11, [spc2ext+0x13]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x13@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0x71
spc2cpu_0x71: ; TCALL7
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 7
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x10@ah	; 	xld.ub %r10, [spc2ext+0x10]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x10@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x11@ah	; 	xld.ub %r11, [spc2ext+0x11]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x11@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0x81
spc2cpu_0x81: ; TCALL8
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 8
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0xe@ah	; 	xld.ub %r10, [spc2ext+0xe]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0xe@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0xf@ah	; 	xld.ub %r11, [spc2ext+0xf]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0xf@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0x91
spc2cpu_0x91: ; TCALL9
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 9
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0xc@ah	; 	xld.ub %r10, [spc2ext+0xc]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0xc@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0xd@ah	; 	xld.ub %r11, [spc2ext+0xd]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0xd@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0xA1
spc2cpu_0xA1: ; TCALL10
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 10
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0xa@ah	; 	xld.ub %r10, [spc2ext+0xa]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0xa@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0xb@ah	; 	xld.ub %r11, [spc2ext+0xb]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0xb@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0xB1
spc2cpu_0xB1: ; TCALL11
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 11
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x8@ah	; 	xld.ub %r10, [spc2ext+0x8]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x8@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x9@ah	; 	xld.ub %r11, [spc2ext+0x9]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x9@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0xC1
spc2cpu_0xC1: ; TCALL12
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 12
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x6@ah	; 	xld.ub %r10, [spc2ext+0x6]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x6@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x7@ah	; 	xld.ub %r11, [spc2ext+0x7]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x7@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0xD1
spc2cpu_0xD1: ; TCALL13
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 13
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x4@ah	; 	xld.ub %r10, [spc2ext+0x4]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x4@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x5@ah	; 	xld.ub %r11, [spc2ext+0x5]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x5@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0xE1
spc2cpu_0xE1: ; TCALL14
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 14
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x2@ah	; 	xld.ub %r10, [spc2ext+0x2]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x2@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x3@ah	; 	xld.ub %r11, [spc2ext+0x3]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x3@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
	.global spc2cpu_0xF1
spc2cpu_0xF1: ; TCALL15
	ext spc2ram@ah			; tmp = PC - spc2ram	; 	TCALL 15
	ext spc2ram@al
	sub %r1, %r1
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	rr	%r1,0x8		; 	xrr %r1, 8			; *SP-- = tmp >> 8
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	rl	%r1,0x8		; 	xrl %r1, 8			; *SP-- = tmp
	ld.b	[%r10],%r1	; 	xld.b [%r10], %r1
	sub	%r10,0x1	; 	xsub %r10, %r10, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	ext	spc2ext+0x0@ah	; 	xld.ub %r10, [spc2ext+0x0]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	ext	spc2ext+0x0@al
	ld.ub	%r10,[%r8]
	ext	spc2ext+0x1@ah	; 	xld.ub %r11, [spc2ext+0x1]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	ext	spc2ext+0x1@al
	ld.ub	%r11,[%r8]
	sll	%r11,0x8	; 	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret

	.global spc2cpu_0x0F
spc2cpu_0x0F: ; BRK
	ld.w	%r12,0xf	; 	xld.w %r12, 0x0F	; 	DIE 0x0F
	ext	spc2cpu_DIE@rm	; 	xcall spc2cpu_DIE
	call	spc2cpu_DIE@rl

	.global spc2cpu_0x6F
spc2cpu_0x6F: ; RET
	ext	0x8		; 	xld.w %r10, [%r0+0x8]
	ld.w	%r10,[%r0]
	add	%r10,0x1	; 	xadd %r10, %r10, 1		; tmp  = *++SP
	ld.ub %r12, [%r10]+
	ld.ub %r13, [%r10]		; tmp |= *++SP << 8
	ext	0x8		; 	xld.w [%r0+0x8], %r10
	ld.w	[%r0],%r10
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext spc2ram@ah			; PC = &spc2ram[tmp]
	ext spc2ram@al
	add %r1, %r12
	ret

	.global spc2cpu_0x7F
spc2cpu_0x7F: ; RETI
	ext	0x1		; 	xld.w %r12, 0x7F	; 	DIE 0x7F
	ld.w	%r12,0x3f
	ext	spc2cpu_DIE@rm	; 	xcall spc2cpu_DIE
	call	spc2cpu_DIE@rl

;============================================================================
;	14. STACK OPERATION COMMANDS
;============================================================================

	.global spc2cpu_0x2D
spc2cpu_0x2D: ; PUSH A
	ext	0x6		; 	xld.ub %r10, [%r0+0x6]
	ld.ub	%r10,[%r0]
	ext	0x8		; 	xld.w %r11, [%r0+0x8]
	ld.w	%r11,[%r0]
	ld.b	[%r11],%r10	; 	xld.b [%r11], %r10
	sub	%r11,0x1	; 	xsub %r11, %r11, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r11
	ld.w	[%r0],%r11
	ret

	.global spc2cpu_0x4D
spc2cpu_0x4D: ; PUSH X
	ext	0x5		; 	xld.ub %r10, [%r0+0x5]
	ld.ub	%r10,[%r0]
	ext	0x8		; 	xld.w %r11, [%r0+0x8]
	ld.w	%r11,[%r0]
	ld.b	[%r11],%r10	; 	xld.b [%r11], %r10
	sub	%r11,0x1	; 	xsub %r11, %r11, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r11
	ld.w	[%r0],%r11
	ret

	.global spc2cpu_0x6D
spc2cpu_0x6D: ; PUSH Y
	ext	0x7		; 	xld.ub %r10, [%r0+0x7]
	ld.ub	%r10,[%r0]
	ext	0x8		; 	xld.w %r11, [%r0+0x8]
	ld.w	%r11,[%r0]
	ld.b	[%r11],%r10	; 	xld.b [%r11], %r10
	sub	%r11,0x1	; 	xsub %r11, %r11, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r11
	ld.w	[%r0],%r11
	ret

	.global spc2cpu_0x0D
spc2cpu_0x0D: ; PUSH PSW
	ext	spc2cpu_PACK_PSW@rm	; 	xcall spc2cpu_PACK_PSW	; 	PACK_PSW
	call	spc2cpu_PACK_PSW@rl
	ext	0x8		; 	xld.w %r11, [%r0+0x8]
	ld.w	%r11,[%r0]
	ld.b	[%r11],%r10	; 	xld.b [%r11], %r10
	sub	%r11,0x1	; 	xsub %r11, %r11, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r11
	ld.w	[%r0],%r11
	ret

;----------------------------------------------------------------------------

	.global spc2cpu_0xAE
spc2cpu_0xAE: ; POP A
	ext	0x8		; 	xld.w %r11, [%r0+0x8]
	ld.w	%r11,[%r0]
	add	%r11,0x1	; 	xadd %r11, %r11, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r11
	ld.w	[%r0],%r11
	ld.ub	%r10,[%r11]	; 	xld.ub %r10, [%r11]
	ext	0x6		; 	xld.b [%r0+0x6], %r10
	ld.b	[%r0],%r10
	ret

	.global spc2cpu_0xCE
spc2cpu_0xCE: ; POP X
	ext	0x8		; 	xld.w %r11, [%r0+0x8]
	ld.w	%r11,[%r0]
	add	%r11,0x1	; 	xadd %r11, %r11, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r11
	ld.w	[%r0],%r11
	ld.ub	%r10,[%r11]	; 	xld.ub %r10, [%r11]
	ext	0x5		; 	xld.b [%r0+0x5], %r10
	ld.b	[%r0],%r10
	ret

	.global spc2cpu_0xEE
spc2cpu_0xEE: ; POP Y
	ext	0x8		; 	xld.w %r11, [%r0+0x8]
	ld.w	%r11,[%r0]
	add	%r11,0x1	; 	xadd %r11, %r11, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r11
	ld.w	[%r0],%r11
	ld.ub	%r10,[%r11]	; 	xld.ub %r10, [%r11]
	ext	0x7		; 	xld.b [%r0+0x7], %r10
	ld.b	[%r0],%r10
	ret

	.global spc2cpu_0x8E
spc2cpu_0x8E: ; POP PSW
	ext	0x8		; 	xld.w %r11, [%r0+0x8]
	ld.w	%r11,[%r0]
	add	%r11,0x1	; 	xadd %r11, %r11, 1
	ext	0x8		; 	xld.w [%r0+0x8], %r11
	ld.w	[%r0],%r11
	ld.ub	%r12,[%r11]	; 	xld.ub %r12, [%r11]
	ext	spc2cpu_UNPACK_PSW@rm	; 	xcall spc2cpu_UNPACK_PSW	; 	UNPACK_PSW
	call	spc2cpu_UNPACK_PSW@rl
	ret

;============================================================================
;	15. BIT OPERATION COMMANDS
;============================================================================

	.global spc2cpu_0x02
spc2cpu_0x02: ; SET0 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x1		; 	xoor %r13, %r10, 0x1
	or	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x22
spc2cpu_0x22: ; SET1 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x2		; 	xoor %r13, %r10, 0x2
	or	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x42
spc2cpu_0x42: ; SET2 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x4		; 	xoor %r13, %r10, 0x4
	or	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x62
spc2cpu_0x62: ; SET3 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x8		; 	xoor %r13, %r10, 0x8
	or	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x82
spc2cpu_0x82: ; SET4 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x10		; 	xoor %r13, %r10, 0x10
	or	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0xA2
spc2cpu_0xA2: ; SET5 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x20		; 	xoor %r13, %r10, 0x20
	or	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0xC2
spc2cpu_0xC2: ; SET6 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x40		; 	xoor %r13, %r10, 0x40
	or	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0xE2
spc2cpu_0xE2: ; SET7 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ext	0x80		; 	xoor %r13, %r10, 0x80
	or	%r13,%r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x12
spc2cpu_0x12: ; CLR0 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w	%r13,%r10	; 	xand %r13, %r10, -2
	and	%r13,0x3e
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x32
spc2cpu_0x32: ; CLR1 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w	%r13,%r10	; 	xand %r13, %r10, -3
	and	%r13,0x3d
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x52
spc2cpu_0x52: ; CLR2 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w	%r13,%r10	; 	xand %r13, %r10, -5
	and	%r13,0x3b
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x72
spc2cpu_0x72: ; CLR3 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w	%r13,%r10	; 	xand %r13, %r10, -9
	and	%r13,0x37
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x92
spc2cpu_0x92: ; CLR4 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w	%r13,%r10	; 	xand %r13, %r10, -17
	and	%r13,0x2f
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0xB2
spc2cpu_0xB2: ; CLR5 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w	%r13,%r10	; 	xand %r13, %r10, -33
	ext	0x1fff
	and	%r13,0x1f
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0xD2
spc2cpu_0xD2: ; CLR6 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w	%r13,%r10	; 	xand %r13, %r10, -65
	ext	0x1ffe
	and	%r13,0x3f
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0xF2
spc2cpu_0xF2: ; CLR7 dp
	ld.uh	%r15,[%r0]	; 	xld.uh %r15, [%r0+0x0]	; mem = PSW_P | *PC++	; 	DIRECT_PAGE
	ld.ub %r12, [%r1]+
	or %r12, %r15
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w	%r13,%r10	; 	xand %r13, %r10, -129
	ext	0x1ffd
	and	%r13,0x3f
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x0E
spc2cpu_0x0E: ; TSET1 labs
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ				; %r10 = tmp
	call	spc2cpu_READ@rl
	ext	0x6		; 	xld.ub %r11, [%r0+0x6]		; %r11 = A
	ld.ub	%r11,[%r0]
	ld.w %r13, %r11			; %r13 = A
	or %r13, %r10			; %r13 = tmp | A
	and %r11, %r10			; %r11 = tmp & A
	ext	0x2		; 	xld.b [%r0+0x2], %r11
	ld.b	[%r0],%r11
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x4E
spc2cpu_0x4E: ; TCLR1 labs
	ld.ub %r12, [%r1]+		; mem  = *PC++	; 	ABSOLUTE
	ld.ub %r13, [%r1]+		; mem |= *PC++ << 8
	sll	%r13,0x8	; 	xsll %r13, 8
	or %r12, %r13
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ				; %r10 = tmp
	call	spc2cpu_READ@rl
	ext	0x6		; 	xld.ub %r11, [%r0+0x6]		; %r11 = A
	ld.ub	%r11,[%r0]
	not %r13, %r11			; %r13 = ~A
	and %r13, %r10			; %r13 = tmp & ~A
	and %r11, %r10			; %r11 = tmp & A
	ext	0x2		; 	xld.b [%r0+0x2], %r11
	ld.b	[%r0],%r11
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0x4A
spc2cpu_0x4A: ; AND1 C,mem.bit
	ld.ub %r13, [%r1]+		; bit   = *PC++	; 	ABSOLUTE_BOOLEAN_BIT
	ld.ub %r14, [%r1]+		; bit  |= *PC++ << 8
	sll	%r14,0x8	; 	xsll %r14, 8
	or %r13, %r14
	ext	0x1fff		; 	xand %r12, %r13, 0x1fff		; mem   = bit & 0x1fff
	and	%r12,%r13
	srl	%r13,0x8	; 	xsrl %r13, 13			; bit >>= 13
	srl	%r13,0x5
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	ext	0x3		; 	xld.ub %r11, [%r0+0x3]
	ld.ub	%r11,[%r0]
	and %r11, %r10
	ext	0x3		; 	xld.b [%r0+0x3], %r11
	ld.b	[%r0],%r11
	ret

	.global spc2cpu_0x6A
spc2cpu_0x6A: ; AND1 C,/mem.bit
	ld.ub %r13, [%r1]+		; bit   = *PC++	; 	ABSOLUTE_BOOLEAN_BIT
	ld.ub %r14, [%r1]+		; bit  |= *PC++ << 8
	sll	%r14,0x8	; 	xsll %r14, 8
	or %r13, %r14
	ext	0x1fff		; 	xand %r12, %r13, 0x1fff		; mem   = bit & 0x1fff
	and	%r12,%r13
	srl	%r13,0x8	; 	xsrl %r13, 13			; bit >>= 13
	srl	%r13,0x5
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	not %r10, %r10
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	ext	0x3		; 	xld.ub %r11, [%r0+0x3]
	ld.ub	%r11,[%r0]
	and %r11, %r10
	ext	0x3		; 	xld.b [%r0+0x3], %r11
	ld.b	[%r0],%r11
	ret

	.global spc2cpu_0x0A
spc2cpu_0x0A: ; OR1 C,mem.bit
	ld.ub %r13, [%r1]+		; bit   = *PC++	; 	ABSOLUTE_BOOLEAN_BIT
	ld.ub %r14, [%r1]+		; bit  |= *PC++ << 8
	sll	%r14,0x8	; 	xsll %r14, 8
	or %r13, %r14
	ext	0x1fff		; 	xand %r12, %r13, 0x1fff		; mem   = bit & 0x1fff
	and	%r12,%r13
	srl	%r13,0x8	; 	xsrl %r13, 13			; bit >>= 13
	srl	%r13,0x5
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	ext	0x3		; 	xld.ub %r11, [%r0+0x3]
	ld.ub	%r11,[%r0]
	or %r11, %r10
	ext	0x3		; 	xld.b [%r0+0x3], %r11
	ld.b	[%r0],%r11
	ret

	.global spc2cpu_0x2A
spc2cpu_0x2A: ; OR1 C,/mem.bit
	ld.ub %r13, [%r1]+		; bit   = *PC++	; 	ABSOLUTE_BOOLEAN_BIT
	ld.ub %r14, [%r1]+		; bit  |= *PC++ << 8
	sll	%r14,0x8	; 	xsll %r14, 8
	or %r13, %r14
	ext	0x1fff		; 	xand %r12, %r13, 0x1fff		; mem   = bit & 0x1fff
	and	%r12,%r13
	srl	%r13,0x8	; 	xsrl %r13, 13			; bit >>= 13
	srl	%r13,0x5
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	not %r10, %r10
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	ext	0x3		; 	xld.ub %r11, [%r0+0x3]
	ld.ub	%r11,[%r0]
	or %r11, %r10
	ext	0x3		; 	xld.b [%r0+0x3], %r11
	ld.b	[%r0],%r11
	ret

	.global spc2cpu_0x8A
spc2cpu_0x8A: ; EOR1 C,mem.bit
	ld.ub %r13, [%r1]+		; bit   = *PC++	; 	ABSOLUTE_BOOLEAN_BIT
	ld.ub %r14, [%r1]+		; bit  |= *PC++ << 8
	sll	%r14,0x8	; 	xsll %r14, 8
	or %r13, %r14
	ext	0x1fff		; 	xand %r12, %r13, 0x1fff		; mem   = bit & 0x1fff
	and	%r12,%r13
	srl	%r13,0x8	; 	xsrl %r13, 13			; bit >>= 13
	srl	%r13,0x5
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	ext	0x3		; 	xld.ub %r11, [%r0+0x3]
	ld.ub	%r11,[%r0]
	xor %r11, %r10
	ext	0x3		; 	xld.b [%r0+0x3], %r11
	ld.b	[%r0],%r11
	ret

	.global spc2cpu_0xEA
spc2cpu_0xEA: ; NOT1 mem.bit
	ld.ub %r13, [%r1]+		; bit   = *PC++	; 	ABSOLUTE_BOOLEAN_BIT
	ld.ub %r14, [%r1]+		; bit  |= *PC++ << 8
	sll	%r14,0x8	; 	xsll %r14, 8
	or %r13, %r14
	ext	0x1fff		; 	xand %r12, %r13, 0x1fff		; mem   = bit & 0x1fff
	and	%r12,%r13
	srl	%r13,0x8	; 	xsrl %r13, 13			; bit >>= 13
	srl	%r13,0x5
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	ld.w	%r11,0x1	; 	xld.w %r11, 1
	rl %r11, %r13			; %r13=0`7Ȃ̂extsv
	xor %r10, %r11
	ld.w %r13, %r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

	.global spc2cpu_0xAA
spc2cpu_0xAA: ; MOV1 C,mem.bit
	ld.ub %r13, [%r1]+		; bit   = *PC++	; 	ABSOLUTE_BOOLEAN_BIT
	ld.ub %r14, [%r1]+		; bit  |= *PC++ << 8
	sll	%r14,0x8	; 	xsll %r14, 8
	or %r13, %r14
	ext	0x1fff		; 	xand %r12, %r13, 0x1fff		; mem   = bit & 0x1fff
	and	%r12,%r13
	srl	%r13,0x8	; 	xsrl %r13, 13			; bit >>= 13
	srl	%r13,0x5
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ
	call	spc2cpu_READ@rl
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	ext	0x3		; 	xld.b [%r0+0x3], %r10
	ld.b	[%r0],%r10
	ret

	.global spc2cpu_0xCA
spc2cpu_0xCA: ; MOV1 mem.bit,C
	ld.ub %r13, [%r1]+		; bit   = *PC++	; 	ABSOLUTE_BOOLEAN_BIT
	ld.ub %r14, [%r1]+		; bit  |= *PC++ << 8
	sll	%r14,0x8	; 	xsll %r14, 8
	or %r13, %r14
	ext	0x1fff		; 	xand %r12, %r13, 0x1fff		; mem   = bit & 0x1fff
	and	%r12,%r13
	srl	%r13,0x8	; 	xsrl %r13, 13			; bit >>= 13
	srl	%r13,0x5
	ext	spc2cpu_READ@rm	; 	xcall spc2cpu_READ	; 	READ				; %r10 =  READ(mem)
	call	spc2cpu_READ@rl
	ld.w	%r11,0x3e	; 	xld.w %r11, -2			; %r10 =  READ(mem) & ~(1 << bit)
	rl %r11, %r13			; %r13=0`7Ȃ̂extsv
	and %r10, %r11
	ext	0x3		; 	xld.ub %r11, [%r0+0x3]	; %r10 = (READ(mem) & ~(1 << bit)) | (PSW_C & 1) << bit
	ld.ub	%r11,[%r0]
	and	%r11,0x1	; 	xand %r11, %r11, 1
	rl %r11, %r13			; %r13=0`7Ȃ̂extsv
	or %r10, %r11
	ld.w %r13, %r10
	ext	spc2cpu_WRITE@rm	; 	xcall spc2cpu_WRITE	; 	WRITE
	call	spc2cpu_WRITE@rl
	ret

;============================================================================
;	16. PROGRAM STATUS FLAG OPERATION COMMANDS
;============================================================================

	.global spc2cpu_0x60
spc2cpu_0x60: ; CLRC
	ext	0x3		; 	xbclr [%r0+0x3], 0x0
	bclr	[%r0],0x0
	ret

	.global spc2cpu_0x80
spc2cpu_0x80: ; SETC
	ext	0x3		; 	xbset [%r0+0x3], 0x0
	bset	[%r0],0x0
	ret

	.global spc2cpu_0xED
spc2cpu_0xED: ; NOTC
	ext	0x3		; 	xbnot [%r0+0x3], 0x0
	bnot	[%r0],0x0
	ret

	.global spc2cpu_0xE0
spc2cpu_0xE0: ; CLRV
	ext	0x4		; 	xbclr [%r0+0x4], 0x7
	bclr	[%r0],0x7
	ret

	.global spc2cpu_0x20
spc2cpu_0x20: ; CLRP
	ld.w	%r10,0x0	; 	xld.w %r10, 0x000
	ld.h	[%r0],%r10	; 	xld.h [%r0+0x0], %r10
	ret

	.global spc2cpu_0x40
spc2cpu_0x40: ; SETP
	ext	0x4		; 	xld.w %r10, 0x100
	ld.w	%r10,0x0
	ld.h	[%r0],%r10	; 	xld.h [%r0+0x0], %r10
	ret

	.global spc2cpu_0xA0
spc2cpu_0xA0: ; EI
	ext	0x2		; 	xld.w %r12, 0xA0	; 	DIE 0xA0
	ld.w	%r12,0x20
	ext	spc2cpu_DIE@rm	; 	xcall spc2cpu_DIE
	call	spc2cpu_DIE@rl
	.global spc2cpu_0xC0
spc2cpu_0xC0: ; DI
	ext	0x3		; 	xld.w %r12, 0xC0	; 	DIE 0xC0
	ld.w	%r12,0x0
	ext	spc2cpu_DIE@rm	; 	xcall spc2cpu_DIE
	call	spc2cpu_DIE@rl

;============================================================================
;	17. OTHER COMMANDS
;============================================================================

	.global spc2cpu_0x00
spc2cpu_0x00: ; NOP
	;** no job **
	ret

	.global spc2cpu_0xEF
spc2cpu_0xEF: ; SLEEP
	ext	0x3		; 	xld.w %r12, 0xEF	; 	DIE 0xEF
	ld.w	%r12,0x2f
	ext	spc2cpu_DIE@rm	; 	xcall spc2cpu_DIE
	call	spc2cpu_DIE@rl
	.global spc2cpu_0xFF
spc2cpu_0xFF: ; STOP
	ext	0x3		; 	xld.w %r12, 0xFF	; 	DIE 0xFF
	ld.w	%r12,0x3f
	ext	spc2cpu_DIE@rm	; 	xcall spc2cpu_DIE
	call	spc2cpu_DIE@rl

;****************************************************************************

	.align 2

	.global spc2cpu_TABLE
spc2cpu_TABLE:
	.word spc2cpu_0x00 ; NOP
	.word spc2cpu_0x01 ; TCALL0
	.word spc2cpu_0x02 ; SET0 dp
	.word spc2cpu_0x03 ; BBS0 dp,rel
	.word spc2cpu_0x04 ; OR A,dp
	.word spc2cpu_0x05 ; OR A,labs
	.word spc2cpu_0x06 ; OR A,(X)
	.word spc2cpu_0x07 ; OR A,(dp+X)
	.word spc2cpu_0x08 ; OR A,#inm
	.word spc2cpu_0x09 ; OR dp(d),dp(s)
	.word spc2cpu_0x0A ; OR1 C,mem.bit
	.word spc2cpu_0x0B ; ASL dp
	.word spc2cpu_0x0C ; ASL labs
	.word spc2cpu_0x0D ; PUSH PSW
	.word spc2cpu_0x0E ; TSET1 labs
	.word spc2cpu_0x0F ; BRK
	.word spc2cpu_0x10 ; BPL rel
	.word spc2cpu_0x11 ; TCALL1
	.word spc2cpu_0x12 ; CLR0 dp
	.word spc2cpu_0x13 ; BBC0 dp,rel
	.word spc2cpu_0x14 ; OR A,dp+X
	.word spc2cpu_0x15 ; OR A,labs+X
	.word spc2cpu_0x16 ; OR A,labs+Y
	.word spc2cpu_0x17 ; OR A,(dp)+Y
	.word spc2cpu_0x18 ; OR dp,#inm
	.word spc2cpu_0x19 ; OR (X),(Y)
	.word spc2cpu_0x1A ; DECW dp
	.word spc2cpu_0x1B ; ASL dp+X
	.word spc2cpu_0x1C ; ASL A
	.word spc2cpu_0x1D ; DEC X
	.word spc2cpu_0x1E ; CMP X,labs
	.word spc2cpu_0x1F ; JMP (labs+X)
	.word spc2cpu_0x20 ; CLRP
	.word spc2cpu_0x21 ; TCALL2
	.word spc2cpu_0x22 ; SET1 dp
	.word spc2cpu_0x23 ; BBS1 dp,rel
	.word spc2cpu_0x24 ; AND A,dp
	.word spc2cpu_0x25 ; AND A,labs
	.word spc2cpu_0x26 ; AND A,(X)
	.word spc2cpu_0x27 ; AND A,(dp+X)
	.word spc2cpu_0x28 ; AND A,#inm
	.word spc2cpu_0x29 ; AND dp(d),dp(s)
	.word spc2cpu_0x2A ; OR1 C,/mem.bit
	.word spc2cpu_0x2B ; ROL dp
	.word spc2cpu_0x2C ; ROL labs
	.word spc2cpu_0x2D ; PUSH A
	.word spc2cpu_0x2E ; CBNE dp,rel
	.word spc2cpu_0x2F ; BRA rel
	.word spc2cpu_0x30 ; BMI rel
	.word spc2cpu_0x31 ; TCALL3
	.word spc2cpu_0x32 ; CLR1 dp
	.word spc2cpu_0x33 ; BBC1 dp,rel
	.word spc2cpu_0x34 ; AND A,dp+X
	.word spc2cpu_0x35 ; AND A,labs+X
	.word spc2cpu_0x36 ; AND A,labs+Y
	.word spc2cpu_0x37 ; AND A,(dp)+Y
	.word spc2cpu_0x38 ; AND dp,#inm
	.word spc2cpu_0x39 ; AND (X),(Y)
	.word spc2cpu_0x3A ; INCW dp
	.word spc2cpu_0x3B ; ROL dp+X
	.word spc2cpu_0x3C ; ROL A
	.word spc2cpu_0x3D ; INC X
	.word spc2cpu_0x3E ; CMP X,dp
	.word spc2cpu_0x3F ; CALL labs
	.word spc2cpu_0x40 ; SETP
	.word spc2cpu_0x41 ; TCALL4
	.word spc2cpu_0x42 ; SET2 dp
	.word spc2cpu_0x43 ; BBS2 dp,rel
	.word spc2cpu_0x44 ; EOR A,dp
	.word spc2cpu_0x45 ; EOR A,labs
	.word spc2cpu_0x46 ; EOR A,(X)
	.word spc2cpu_0x47 ; EOR A,(dp+X)
	.word spc2cpu_0x48 ; EOR A,#inm
	.word spc2cpu_0x49 ; EOR dp(d),dp(s)
	.word spc2cpu_0x4A ; AND1 C,mem.bit
	.word spc2cpu_0x4B ; LSR dp
	.word spc2cpu_0x4C ; LSR labs
	.word spc2cpu_0x4D ; PUSH X
	.word spc2cpu_0x4E ; TCLR1 labs
	.word spc2cpu_0x4F ; PCALL upage
	.word spc2cpu_0x50 ; BVC rel
	.word spc2cpu_0x51 ; TCALL5
	.word spc2cpu_0x52 ; CLR2 dp
	.word spc2cpu_0x53 ; BBC2 dp,rel
	.word spc2cpu_0x54 ; EOR A,dp+X
	.word spc2cpu_0x55 ; EOR A,labs+X
	.word spc2cpu_0x56 ; EOR A,labs+Y
	.word spc2cpu_0x57 ; EOR A,(dp)+Y
	.word spc2cpu_0x58 ; EOR dp,#inm
	.word spc2cpu_0x59 ; EOR (X),(Y)
	.word spc2cpu_0x5A ; CMPW YA,dp
	.word spc2cpu_0x5B ; LSR dp+X
	.word spc2cpu_0x5C ; LSR A
	.word spc2cpu_0x5D ; MOV X,A
	.word spc2cpu_0x5E ; CMP Y,labs
	.word spc2cpu_0x5F ; JMP labs
	.word spc2cpu_0x60 ; CLRC
	.word spc2cpu_0x61 ; TCALL6
	.word spc2cpu_0x62 ; SET3 dp
	.word spc2cpu_0x63 ; BBS3 dp,rel
	.word spc2cpu_0x64 ; CMP A,dp
	.word spc2cpu_0x65 ; CMP A,labs
	.word spc2cpu_0x66 ; CMP A,(X)
	.word spc2cpu_0x67 ; CMP A,(dp+X)
	.word spc2cpu_0x68 ; CMP A,#inm
	.word spc2cpu_0x69 ; CMP dp(d),dp(s)
	.word spc2cpu_0x6A ; AND1 C,/mem.bit
	.word spc2cpu_0x6B ; ROR dp
	.word spc2cpu_0x6C ; ROR labs
	.word spc2cpu_0x6D ; PUSH Y
	.word spc2cpu_0x6E ; DBNZ dp,rel
	.word spc2cpu_0x6F ; RET
	.word spc2cpu_0x70 ; BVS rel
	.word spc2cpu_0x71 ; TCALL7
	.word spc2cpu_0x72 ; CLR3 dp
	.word spc2cpu_0x73 ; BBC3 dp,rel
	.word spc2cpu_0x74 ; CMP A,dp+X
	.word spc2cpu_0x75 ; CMP A,labs+X
	.word spc2cpu_0x76 ; CMP A,labs+Y
	.word spc2cpu_0x77 ; CMP A,(dp)+Y
	.word spc2cpu_0x78 ; CMP dp,#inm
	.word spc2cpu_0x79 ; CMP (X),(Y)
	.word spc2cpu_0x7A ; ADDW YA,dp
	.word spc2cpu_0x7B ; ROR dp+X
	.word spc2cpu_0x7C ; ROR A
	.word spc2cpu_0x7D ; MOV A,X
	.word spc2cpu_0x7E ; CMP Y,dp
	.word spc2cpu_0x7F ; RETI
	.word spc2cpu_0x80 ; SETC
	.word spc2cpu_0x81 ; TCALL8
	.word spc2cpu_0x82 ; SET4 dp
	.word spc2cpu_0x83 ; BBS4 dp,rel
	.word spc2cpu_0x84 ; ADC A,dp
	.word spc2cpu_0x85 ; ADC A,labs
	.word spc2cpu_0x86 ; ADC A,(X)
	.word spc2cpu_0x87 ; ADC A,(dp+X)
	.word spc2cpu_0x88 ; ADC A,#inm
	.word spc2cpu_0x89 ; ADC dp(d),dp(s)
	.word spc2cpu_0x8A ; EOR1 C,mem.bit
	.word spc2cpu_0x8B ; DEC dp
	.word spc2cpu_0x8C ; DEC labs
	.word spc2cpu_0x8D ; MOV Y,#inm
	.word spc2cpu_0x8E ; POP PSW
	.word spc2cpu_0x8F ; MOV dp,#inm
	.word spc2cpu_0x90 ; BCC rel
	.word spc2cpu_0x91 ; TCALL9
	.word spc2cpu_0x92 ; CLR4 dp
	.word spc2cpu_0x93 ; BBC4 dp,rel
	.word spc2cpu_0x94 ; ADC A,dp+X
	.word spc2cpu_0x95 ; ADC A,labs+X
	.word spc2cpu_0x96 ; ADC A,labs+Y
	.word spc2cpu_0x97 ; ADC A,(dp)+Y
	.word spc2cpu_0x98 ; ADC dp,#inm
	.word spc2cpu_0x99 ; ADC (X),(Y)
	.word spc2cpu_0x9A ; SUBW YA,dp
	.word spc2cpu_0x9B ; DEC dp+X
	.word spc2cpu_0x9C ; DEC A
	.word spc2cpu_0x9D ; MOV X,SP
	.word spc2cpu_0x9E ; DIV YA,X
	.word spc2cpu_0x9F ; XCN A
	.word spc2cpu_0xA0 ; EI
	.word spc2cpu_0xA1 ; TCALL10
	.word spc2cpu_0xA2 ; SET5 dp
	.word spc2cpu_0xA3 ; BBS5 dp,rel
	.word spc2cpu_0xA4 ; SBC A,dp
	.word spc2cpu_0xA5 ; SBC A,labs
	.word spc2cpu_0xA6 ; SBC A,(X)
	.word spc2cpu_0xA7 ; SBC A,(dp+X)
	.word spc2cpu_0xA8 ; SBC A,#inm
	.word spc2cpu_0xA9 ; SBC dp(d),dp(s)
	.word spc2cpu_0xAA ; MOV1 C,mem.bit
	.word spc2cpu_0xAB ; INC dp
	.word spc2cpu_0xAC ; INC labs
	.word spc2cpu_0xAD ; CMP Y,#inm
	.word spc2cpu_0xAE ; POP A
	.word spc2cpu_0xAF ; MOV (X)+,A
	.word spc2cpu_0xB0 ; BCS rel
	.word spc2cpu_0xB1 ; TCALL11
	.word spc2cpu_0xB2 ; CLR5 dp
	.word spc2cpu_0xB3 ; BBC5 dp,rel
	.word spc2cpu_0xB4 ; SBC A,dp+X
	.word spc2cpu_0xB5 ; SBC A,labs+X
	.word spc2cpu_0xB6 ; SBC A,labs+Y
	.word spc2cpu_0xB7 ; SBC A,(dp)+Y
	.word spc2cpu_0xB8 ; SBC dp,#inm
	.word spc2cpu_0xB9 ; SBC (X),(Y)
	.word spc2cpu_0xBA ; MOVW YA,dp
	.word spc2cpu_0xBB ; INC dp+X
	.word spc2cpu_0xBC ; INC A
	.word spc2cpu_0xBD ; MOV SP,X
	.word spc2cpu_0xBE ; DAS A
	.word spc2cpu_0xBF ; MOV A,(X)+
	.word spc2cpu_0xC0 ; DI
	.word spc2cpu_0xC1 ; TCALL12
	.word spc2cpu_0xC2 ; SET6 dp
	.word spc2cpu_0xC3 ; BBS6 dp,rel
	.word spc2cpu_0xC4 ; MOV dp,A
	.word spc2cpu_0xC5 ; MOV labs,A
	.word spc2cpu_0xC6 ; MOV (X),A
	.word spc2cpu_0xC7 ; MOV (dp+X),A
	.word spc2cpu_0xC8 ; CMP X,#inm
	.word spc2cpu_0xC9 ; MOV labs,X
	.word spc2cpu_0xCA ; MOV1 mem.bit,C
	.word spc2cpu_0xCB ; MOV dp,Y
	.word spc2cpu_0xCC ; MOV labs,Y
	.word spc2cpu_0xCD ; MOV X,#inm
	.word spc2cpu_0xCE ; POP X
	.word spc2cpu_0xCF ; MUL YA
	.word spc2cpu_0xD0 ; BNE rel
	.word spc2cpu_0xD1 ; TCALL13
	.word spc2cpu_0xD2 ; CLR6 dp
	.word spc2cpu_0xD3 ; BBC6 dp,rel
	.word spc2cpu_0xD4 ; MOV dp+X,A
	.word spc2cpu_0xD5 ; MOV labs+X,A
	.word spc2cpu_0xD6 ; MOV labs+Y,A
	.word spc2cpu_0xD7 ; MOV (dp)+Y,A
	.word spc2cpu_0xD8 ; MOV dp,X
	.word spc2cpu_0xD9 ; MOV dp+Y,X
	.word spc2cpu_0xDA ; MOVW dp,YA
	.word spc2cpu_0xDB ; MOV dp+X,Y
	.word spc2cpu_0xDC ; DEC Y
	.word spc2cpu_0xDD ; MOV A,Y
	.word spc2cpu_0xDE ; CBNE dp+X,rel
	.word spc2cpu_0xDF ; DAA A
	.word spc2cpu_0xE0 ; CLRV
	.word spc2cpu_0xE1 ; TCALL14
	.word spc2cpu_0xE2 ; SET7 dp
	.word spc2cpu_0xE3 ; BBS7 dp,rel
	.word spc2cpu_0xE4 ; MOV A,dp
	.word spc2cpu_0xE5 ; MOV A,labs
	.word spc2cpu_0xE6 ; MOV A,(X)
	.word spc2cpu_0xE7 ; MOV A,(dp+X)
	.word spc2cpu_0xE8 ; MOV A,#inm
	.word spc2cpu_0xE9 ; MOV X,labs
	.word spc2cpu_0xEA ; NOT1 mem.bit
	.word spc2cpu_0xEB ; MOV Y,dp
	.word spc2cpu_0xEC ; MOV Y,labs
	.word spc2cpu_0xED ; NOTC
	.word spc2cpu_0xEE ; POP Y
	.word spc2cpu_0xEF ; SLEEP
	.word spc2cpu_0xF0 ; BEQ rel
	.word spc2cpu_0xF1 ; TCALL15
	.word spc2cpu_0xF2 ; CLR7 dp
	.word spc2cpu_0xF3 ; BBC7 dp,rel
	.word spc2cpu_0xF4 ; MOV A,dp+X
	.word spc2cpu_0xF5 ; MOV A,labs+X
	.word spc2cpu_0xF6 ; MOV A,labs+Y
	.word spc2cpu_0xF7 ; MOV A,(dp)+Y
	.word spc2cpu_0xF8 ; MOV X,dp
	.word spc2cpu_0xF9 ; MOV X,dp+Y
	.word spc2cpu_0xFA ; MOV dp(d),dp(s)
	.word spc2cpu_0xFB ; MOV Y,dp+X
	.word spc2cpu_0xFC ; INC Y
	.word spc2cpu_0xFD ; MOV Y,A
	.word spc2cpu_0xFE ; DBNZ Y,rel
	.word spc2cpu_0xFF ; STOP

	.align 1

;****************************************************************************

;#endif /*SPC2_ASM*/
