/*	
 *	clipsort.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Fri Apr 13 00:10:09 JST 2007 Naoyuki Sawa
 *	- VK쐬B
 *	* Thu Apr 19 11:44:36 JST 2007 Naoyuki Sawa
 *	- ɐ[ċAĂяoꍇ̂h߂̕ύXs܂B
 *	* Thu Apr 19 14:58:48 JST 2007 Naoyuki Sawa
 *	- [vꂩAwhile(){...}do{...}while()ɕύXA܂B
 *	* Sun May 13 14:21:21 JST 2007 Naoyuki Sawa
 *	- q[v\[g̎ǉ܂B
 *	  RgAEgĂ܂̂ŁACuvÔɂ͕ω܂B
 *	* Mon Oct 18 21:09:33 JST 2010 Naoyuki Sawa
 *	- msort()ǉ܂B
 *	* Wed Nov 19 20:53:11 JST 2014 Naoyuki Sawa
 *	- qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂B
 *	  qsort_r()̐錾́Ainclude/stdlib.hɗL܂B
 *	- qsort_r()́Aglibco[W2.8Œǉꂽ֐łB
 *	  ڍׂ́AuSection: Linux Programmer's Manual (3) - QSORTv(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/qsort.3.html)QƂĂB
 *	* Thu Jan 08 21:00:51 JST 2015 Naoyuki Sawa
 *	- qsort()qsort_r()AZu܂BR[hTCY24oCgȂAx4.5%Ȃ܂B
 *	- Visual C++ 6.0Ńrh鎞̂߂ɁAqsort_r()̐錾ǉ܂B
 *	  P/ECEŃrh鎞́Ainclude/stdlib.hqsort_r()錾Ă̂ŖL܂񂪁A
 *	  Visual C++ 6.0Ńrh鎞́AVisual C++ 6.0stdlib.hɂqsort_r()܂܂ĂȂ̂ŁAqsort()qsort_r()ւ̑OQƂxɂȂ邽߂łB
 *	  qsort_r()錾邱ƂɂAVisual C++ 6.0Ńrh鎞xoȂȂ܂B
 *	  AP/ECEŃrh鎞Ő錾ĂĂQ͖̂łAŏƂ邽߂ɁAP/ECEŃrh鎞͂ł͐錾ȂƂɂ܂B
 *	* Fri Jan 09 00:00:00 JST 2015 Naoyuki Sawa
 *	- Asmqsort()œK܂BR[hTCY8oCgȂ܂B
 *	* Fri Jun 10 21:42:30 JST 2016 Naoyuki Sawa
 *	- hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
 *	  ڍׂ́Aclipsort.ćuq[v\[gƃ}[W\[gɂ(2016/06/10)vQƂĉB
 *	- clipsort.c̈ԉɁAueXgXC[gvǋL܂B
 *	* Sat Jun 11 20:47:59 JST 2016 Naoyuki Sawa
 *	- clipsort.c̈ԉɁAuxv(2016/06/11)vǋL܂B
 *	  Win10(x64)P/ECEŁAe֐̑xvʂƁAl@łB
 */
#include "clip.h"

/*****************************************************************************
 *	NBbN\[g
 *****************************************************************************/

//{{2016/06/10폜:clipstdw.hŐ錾̂ŁAł̐錾͕svɂȂĂ܂B
//#ifdef  _MSC_VER
//// * Thu Jan 08 21:00:51 JST 2015 Naoyuki Sawa
//// - Visual C++ 6.0Ńrh鎞̂߂ɁAqsort_r()̐錾ǉ܂B
////   P/ECEŃrh鎞́Ainclude/stdlib.hqsort_r()錾Ă̂ŖL܂񂪁A
////   Visual C++ 6.0Ńrh鎞́AVisual C++ 6.0stdlib.hɂqsort_r()܂܂ĂȂ̂ŁAqsort()qsort_r()ւ̑OQƂxɂȂ邽߂łB
////   qsort_r()錾邱ƂɂAVisual C++ 6.0Ńrh鎞xoȂȂ܂B
////   AP/ECEŃrh鎞Ő錾ĂĂQ͖̂łAŏƂ邽߂ɁAP/ECEŃrh鎞͂ł͐錾ȂƂɂ܂B
//void qsort_r(void* base, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void* arg);
//#endif//_MSC_VER
//}}2016/06/10폜:clipstdw.hŐ錾̂ŁAł̐錾͕svɂȂĂ܂B

/* * WCCuEPSONqsort()u܂B
 * - EPSONqsort()ɕs킯ł͖̂ŁÂ܂܂ł삵܂B
 *   AEPSONqsort()ɂ͏ʂȏ܂܂ĂāATCYƎsxɖʂ܂B
 *   NBbN\[gASY̕׋˂āACLiPłĂ݂邱Ƃɂ܂B
 *   قƂEPSONqsort()ƓŁAꕔ̖ʂȏ폜(֐̃RgQ)łB
 * - EPSONŁCLiPłւ̒uɂATCYߖƍ̌ʂ́Aȉ̂ƂłB
 *	qsort()+xchg()Ŝ̃W[TCY
 *		EPSON: 196oCg
 *		CLiP : 128oCg (68oCgߖ)
 *	10000vf̃_intz\[g鎞
 *		EPSON: 1852~b
 *		CLiP : 1682~b (10%)
 * * Thu Apr 19 11:44:36 JST 2007 Naoyuki Sawa
 * - ɐ[ċAĂяoꍇ̂h߂̕ύXsƂɂA
 *   TCYƑx̓ς܂B
 *	qsort()+xchg()Ŝ̃W[TCY
 *		EPSON: 196oCg
 *		CLiP : 140oCg (56oCgߖ)
 *	10000vf̃_intz\[g鎞
 *		EPSON: 1852~b
 *		CLiP : 1645~b (11%)
 * * Thu Apr 19 14:58:48 JST 2007 Naoyuki Sawa
 * - [vꂩAwhile(){...}do{...}while()ɕύXA܂B
 *   킸ɑȂǁATCY͌܂łB
 *	qsort()+xchg()Ŝ̃W[TCY
 *		EPSON: 196oCg
 *		CLiP : 140oCg (56oCgߖ)
 *	10000vf̃_intz\[g鎞
 *		EPSON: 1852~b
 *		CLiP : 1642~b (11%)
 */

#ifndef PIECE
static void xchg(unsigned char* p1, unsigned char* p2, int size) {
	int tmp;
	do {
		tmp = *p1;
		      *p1++ = *p2;
		              *p2++ = tmp;
	} while(--size);
}
#else /*PIECE*/
/*static*/ void xchg(unsigned char* p1, unsigned char* p2, int size);
asm("
		.code
		.align		1
xchg:
		sub		%r14, 1			;//%psr(Z) := size--	
		 ld.b		%r10, [%r12]		;//			@
		 ld.b		%r11, [%r13]		;//			@
		 ld.b		[%r13]+, %r10		;//			@	*anti-interlock*
		 ld.b		[%r12]+, %r11		;//			@
		jrne.d		-4			;//			
		sub		%r14, 1			;//%psr(Z) := size--		*delay
		ret
");
#endif /*PIECE*/

//-------------------------------------------------------------------------------------------------------------
#ifndef PIECE
//void
//qsort(void* base, size_t num, size_t width, int (*compare)(const void*, const void*))
//{
//	unsigned char* pv;	/* s{bgւ̃|C^ */
//	unsigned char* lo;	/* ʃ|C^ (ɒʗvf(s{bgȉ̗vf)i[ʒuւ̃|C^) */
//	unsigned char* hi;	/* ʃ|C^ (ɍʗvf(s{bg߂̗vf)i[ʒuւ̃|C^) */
//	int lo_cnt;		/* ʗvf */
//	int hi_cnt;		/* ʗvf */
//
//	/* vf0܂1Ȃ΁AɋA܂B
//	 * - EPSONł́A2vf̏ꍇʈāAPȔrƓւsĂ܂A̕Kv͂܂B
//	 *   2vf̏ꍇAȏ̗vf̏ꍇƓAʏ̏őΉł܂B
//	 */
//	if(num <= 1) {
//		return;
//	}
//
//	/* |C^Ɨvf܂B
//	 * - EPSONł́Az̒t߂Ɛ擪̗vfւAƂƒt߂ɂls{bgƂĂ܂B
//	 *   炠xɕłƉ肵āAt߂ɒl邱Ƃ҂Ă̂Ǝv܂B
//	 *   ۂɂ͂܂ʂAނ]vȓւ̉񐔂镪A\𗎂ƂĂ悤łB
//	 *   CLiPłł́APɐ擪̗vfs{bgƂč̗p邱Ƃɂ܂B
//	 */
//	pv = base;			/* s{bg     = 擪 */
//	lo = pv + width;		/* ʃ|C^ = s{bg̎ */
//	hi = pv + width * (num - 1);	/* ʃ|C^ =  */
//	lo_cnt = 0;			/* ʗvf   = 0 */
//	hi_cnt = 0;			/* ʗvf   = 0 */
//
//	/* ʃ|C^ƍʃ|C^܂...(As{bgȊȎSvf̒orʂm肷܂)
//	 * - (num-1)̃JEg_EŃ[v@łʂ𓾂܂A(lo<=hi)Ń[vA
//	 *   numϐ̐ԂZAϐ̃WX^蓖čœKLɓƂ҂ł܂B
//	 */
//	while(lo <= hi) { /* !!(lo<hi)ł͂܂!! */
//		/* ʃ|C^̈ʒuɗLvfAs{bgƔr܂B */
//		if((*compare)(lo, pv) <= 0) {
//			/* ʗvfȂ΁Aʃ|C^̈ʒuɊi[܂B
//			 * ʃ|C^̎̈ʒuɗLvfA̔rΏۂƂȂ܂B
//			 */
//			lo += width;
//			lo_cnt++;
//		} else {
//			/* ʗvfȂ΁Aʃ|C^̈ʒuɊi[܂B
//			 * ʃ|C^̈ʒuɗLvfA̔rʒuɈړ܂B
//			 */
//			xchg(lo, hi, width);
//			hi -= width;
//			hi_cnt++;
//		}
//	}
//
//	/* ȏ̏I_[s{bg,[ʗvf̕],[ʗvf̕]]ƂȂĂ܂B
//	 * [[ʗvf̕],s{bg,[ʗvf̕]]ƓւāAs{bg̈ʒum肵܂B
//	 * - ւɒʗvf̕яω܂A܂яɈӖ͂Ȃ̂ŁAvłB
//	 * - ʗvfꍇApv==hiƂȂĂāAxchg()̓_~[ƂȂ܂B
//	 */
//	xchg(pv, hi, width);
//
//	/* [ʗvf̕]\[g܂B */
//	qsort(pv, lo_cnt, width, compare); /* !![ʗvf̕]̐擪wĂ̂́AlołȂpvł!! */
//
//	/* [ʗvf̕]\[g܂B */
//	qsort(lo, hi_cnt, width, compare); /* !![ʗvf̕]̐擪wĂ̂́AhiłȂloł!! */
//}
//-------------------------------------------------------------------------------------------------------------
//* Thu Apr 19 11:44:36 JST 2007 Naoyuki Sawa
//- ɐ[ċAĂяoꍇ̂h߂̕ύXs܂B
//- ̃RgAEǵANCbN\[ĝ΂fȎłB
//  ASYIɂ͂̂܂܂łԈႢł͂܂񂪁Aɐ[ċAĂяoꍇƂ肪܂B
//- ǂ̂悤ȃP[XŔɐ[ċAĂяo邩ƂƁA炩߃\[gꂽ\[g悤ƂꍇłB
//
//	<>	̂悤ȌĂяosꍇlĂ݂܂B
//
//			int array[10000] = { 1,2,3,...,10000 };
//			qsort(array, 10000, sizeof(int), compare);
//
//		ŏ̌ĂяoxŁA[[ʗvf̕],s{bg,[ʗvf̕]]́Aȉ̂悤ɂȂ܂B
//
//			[[()],1,[2,3,4,...,10000]]	(Ăяo̐[=1)
//
//		[ʗvf̕]ɑ΂ċAĂяoɒڂƁÃxŁA[[ʗvf̕],s{bg,[ʗvf̕]]́Aȉ̂悤ɂȂ܂B
//
//			[[()],2,[3,4,5,...,10000]]	(Ăяo̐[=2)
//
//		Ɏ̃xł́A[[ʗvf̕],s{bg,[ʗvf̕]]́Aȉ̂悤ɂȂ܂B
//
//			[[()],3,[4,5,6,...,10000]]	(Ăяo̐[=3)
//
//		Ōɂ́AȂ܂B
//
//			[[()],10000,[()]]	(Ăяo̐[=10000)
//
//		ȏ̗̂悤ɁA炩߃\[gꂽ\[g悤ƂƁAɐ[ċAĂяoꍇ܂B
//		̒NƂƁAőNx̍ċAĂяo܂B(炩ߊSɃ\[gĂ鐔\[g悤Ƃꍇ)
//		炩ߊSɃ\[gĂ鐔Ɍ炸ƂAx\[gĂ΂قǁAċAĂяo[Ȃ\܂B
//
//		ۂɂǂ̂炢[Ȃ邩͐̏ԂɈˑAqsort()sĂ݂܂ł킩Ȃ̂ŁA댯łB
//		ɁAP/ECÊ悤ȃX^bN̈̏ȎsŗpꍇɊ댯łB
//
//- q̖P@́Aȉ̂ƂłB
//	E[ʗvf̕][ʗvf̕]̂AvfȂċAĂяoŃ\[g܂B
//	Evf́Ǎ݂Ăяox̂܂܁Aŏ珈JԂƂŃ\[g܂B
//  ̂悤ɕύX邱ƂŁAċAĂяo̍ő[Aňł log2(N) ɗ}܂B
//- Ƃ΁A10000vf̐\[gꍇAPO͍ň10000x̍ċAĂяoĂ܂AP͍ňł14xɗ}܂B
//  \[gΏۂ̌IȒlƁA20xȏ̍ċAĂяo󋵂͂قڗL蓾Ȃƍl̂ŁAP/ECEł[ɈSłB
//- Aq̉P͂܂ł(=ċAĂяox)Ɋւ̂łAԌ͉PȂƂɒӂĂB
//  10000vfintz\[g鎞ԂvĂ݂ƁA_ȂΖ1600~błA炩߃\[gĂƖ15300~b܂B
//
//	[QlFP.J.vEK[uWbCu ANSI/ISO/JIS CKivigbpj 411`412y[W {]
void qsort(void* base, size_t num, size_t width, int (*compare)(const void*, const void*)) {
//{{2014/11/19ǉ:qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂Bqsort_r()̐錾́Ainclude/stdlib.hɗL܂B
	qsort_r(base, num, width, (int (*)(const void*, const void*, void*))compare, NULL);	//qsort()qsort_r()́Acompare֐̌`قȂ܂A'cdeclďoK'Ȃ΁Aqsort()`compare֐ɂāA]Ȉ̂Ŗ肠܂B
}
void qsort_r(void* base, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void* arg) {
//}}2014/11/19ǉ:qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂Bqsort_r()̐錾́Ainclude/stdlib.hɗL܂B
	unsigned char* pv;	/* s{bgւ̃|C^ */
	unsigned char* lo;	/* ʃ|C^ (ɒʗvf(s{bgȉ̗vf)i[ʒuւ̃|C^) */
	unsigned char* hi;	/* ʃ|C^ (ɍʗvf(s{bg߂̗vf)i[ʒuւ̃|C^) */
	unsigned lo_cnt;	/* ʗvf */
	unsigned hi_cnt;	/* ʗvf */

	/* vf0܂1Ȃ΁AɋA܂B
	 * - EPSONł́A2vf̏ꍇʈāAPȔrƓւsĂ܂A̕Kv͂܂B
	 *   2vf̏ꍇAȏ̗vf̏ꍇƓAʏ̏őΉł܂B
	 */
	while(num >= 2) {
		/* |C^Ɨvf܂B
		 * - EPSONł́Az̒t߂Ɛ擪̗vfւAƂƒt߂ɂls{bgƂĂ܂B
		 *   炠xɕłƉ肵āAt߂ɒl邱Ƃ҂Ă̂Ǝv܂B
		 *   ۂɂ͂܂ʂAނ]vȓւ̉񐔂镪A\𗎂ƂĂ悤łB
		 *   CLiPłł́APɐ擪̗vfs{bgƂč̗p邱Ƃɂ܂B
		 */
		pv = base;			/* s{bg     = 擪 */
		lo = pv + width;		/* ʃ|C^ = s{bg̎ */
		hi = pv + width * (num - 1);	/* ʃ|C^ =  */
		lo_cnt = 0;			/* ʗvf   = 0 */
		hi_cnt = 0;			/* ʗvf   = 0 */

		/* ʃ|C^ƍʃ|C^܂...(As{bgȊȎSvf̒orʂm肷܂)
		 * - (num-1)̃JEg_EŃ[v@łʂ𓾂܂A(lo<=hi)Ń[vA
		 *   numϐ̐ԂZAϐ̃WX^蓖čœKLɓƂ҂ł܂B
		 */
		//while(lo <= hi) { /* !!(lo<hi)ł͂܂!! */
		//* Thu Apr 19 14:58:48 JST 2007 Naoyuki Sawa
		//- (num>=2)̏菉͕K(lo<=hi)ƂȂ̂ŁAwhile(){...}Ido{...}while()ɑւ܂B
		do {
			/* ʃ|C^̈ʒuɗLvfAs{bgƔr܂B */
//{{2014/11/19ύX:qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂Bqsort_r()̐錾́Ainclude/stdlib.hɗL܂B
//			if((*compare)(lo, pv) <= 0) {
//2014/11/19ύX:qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂Bqsort_r()̐錾́Ainclude/stdlib.hɗL܂B
			if((*compare)(lo, pv, arg) <= 0) {
//}}2014/11/19ύX:qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂Bqsort_r()̐錾́Ainclude/stdlib.hɗL܂B
				/* ʗvfȂ΁Aʃ|C^̈ʒuɊi[܂B
				 * ʃ|C^̎̈ʒuɗLvfA̔rΏۂƂȂ܂B
				 */
				lo += width;
				lo_cnt++;
			} else {
				/* ʗvfȂ΁Aʃ|C^̈ʒuɊi[܂B
				 * ʃ|C^̈ʒuɗLvfA̔rʒuɈړ܂B
				 */
				xchg(lo, hi, width);
				hi -= width;
				hi_cnt++;
			}
		//}
		//* Thu Apr 19 14:58:48 JST 2007 Naoyuki Sawa
		//- (num>=2)̏菉͕K(lo<=hi)ƂȂ̂ŁAwhile(){...}Ido{...}while()ɑւ܂B
		} while(lo <= hi); /* !!(lo<hi)ł͂܂!! */

		/* ȏ̏I_[s{bg,[ʗvf̕],[ʗvf̕]]ƂȂĂ܂B
		 * [[ʗvf̕],s{bg,[ʗvf̕]]ƓւāAs{bg̈ʒum肵܂B
		 * - ւɒʗvf̕яω܂A܂яɈӖ͂Ȃ̂ŁAvłB
		 * - ʗvfꍇApv==hiƂȂĂāAxchg()̓_~[ƂȂ܂B
		 */
		xchg(pv, hi, width);

		/* [ʗvf̕][ʗvf̕]̂AvfȂċAĂяoŃ\[g܂B
		 * vf́Ǎ݂Ăяox̂܂܁Aŏ珈JԂƂŃ\[g܂B
		 * - ċAĂяoŃ\[gƁAɐ[ċAĂ܂ꍇh߂łB
		 *   ̓Iɂ́Å֐̏ɏRgQƂĂB
		 */
		if(lo_cnt <= hi_cnt) {
			/* [ʗvf̕]\[g܂B */
//{{2014/11/19ύX:qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂Bqsort_r()̐錾́Ainclude/stdlib.hɗL܂B
//			qsort(pv, lo_cnt, width, compare); /* !![ʗvf̕]̐擪wĂ̂́AlołȂpvł!! */
//2014/11/19ύX:qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂Bqsort_r()̐錾́Ainclude/stdlib.hɗL܂B
			qsort_r(pv, lo_cnt, width, compare, arg); /* !![ʗvf̕]̐擪wĂ̂́AlołȂpvł!! */
//}}2014/11/19ύX:qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂Bqsort_r()̐錾́Ainclude/stdlib.hɗL܂B
			/* [ʗvf̕]\[g܂B */
			base = lo, num = hi_cnt;           /* !![ʗvf̕]̐擪wĂ̂́AhiłȂloł!! */
		} else {
			/* [ʗvf̕]\[g܂B */
//{{2014/11/19ύX:qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂Bqsort_r()̐錾́Ainclude/stdlib.hɗL܂B
//			qsort(lo, hi_cnt, width, compare); /* !![ʗvf̕]̐擪wĂ̂́AhiłȂloł!! */
//2014/11/19ύX:qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂Bqsort_r()̐錾́Ainclude/stdlib.hɗL܂B
			qsort_r(lo, hi_cnt, width, compare, arg); /* !![ʗvf̕]̐擪wĂ̂́AhiłȂloł!! */
//}}2014/11/19ύX:qsort_r()ǉAqsort()qsort_r()ւ̌ĂяoɕύX܂Bqsort_r()̐錾́Ainclude/stdlib.hɗL܂B
			/* [ʗvf̕]\[g܂B */
			base = pv, num = lo_cnt;           /* !![ʗvf̕]̐擪wĂ̂́AlołȂpvł!! */
		}
	}
}
#else //PIECE
// * Thu Jan 08 21:00:51 JST 2015 Naoyuki Sawa
// - qsort()qsort_r()AZu܂BR[hTCY24oCgȂAx4.5%Ȃ܂B
void qsort(void* base, size_t num, size_t width, int (*compare)(const void*, const void*));
void qsort_r(void* base, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void* arg);
asm("
		.code
		.align		1
		.global		qsort
		.global		qsort_r
qsort:
	;//{{2015/01/09ύX:Asmqsort()œK܂BR[hTCY8oCgȂ܂B
	;//	xsub		%sp, %sp, 4		;//
	;//	xld.w		[%sp+ 0], %r8		;//[%sp+ 0] :=                        NULL
	;//	call		qsort_r			;//qsort_r(base, num, width, compare, NULL)
	;//	xadd		%sp, %sp, 4		;//
	;//	ret
	;//2015/01/09ύX:Asmqsort()œK܂BR[hTCY8oCgȂ܂B
	;// * Fri Jan 09 00:00:00 JST 2015 Naoyuki Sawa
	;// - Asmqsort()œK܂BR[hTCY8oCgȂ܂B
	;//   qsort()͕̏svŁÂ܂qsort_r()sokłBR͈ȉ̒ʂłB
	;// - qsort()Ăяoꂽ̃X^bN\́Aȉ̒ʂł:
	;//	[%sp + 0] := %pc
	;//	[%sp + 4] := (sl)
	;//   ̂܂qsort_r()sƁA(*compare)()argƂāA(sl)n邱ƂɂȂ܂B
	;//   Aqsort()Ăяo(*compare)()arg󂯎Ȃ̂ŁA(sl)ō\܂B
	;//   ]āAqsort()͕̏svŁÂ܂qsort_r()sokłB
	;// - ɂ́A(sl)̕ANZX\RAMƂ͕ۏ؂łȂ̂łAIɂ͖肠܂B
	;//   X^bN̐[0̏Ԃqsort()Ăяo悤ȏꍇłȂ΁A(sl)̓X^bNRAMwĂ邩łB
	;//   L̂悤ȂƂsƂĂAP/ECEȂΖAhXɑ΂ǂݏoňʕیO悤ȂƂ͖̂ŁAL܂B
		;//** no job **//
	;//}}2015/01/09ύX:Asmqsort()œK܂BR[hTCY8oCgȂ܂B
qsort_r:
		;//[%sp + 0] := %pc
		;//[%sp + 4] := arg
		xld.w		%r9, [%sp + 4]		;//%r9      := arg
		pushn		%r3			;//
		xsub		%sp, %sp, 16		;//
		xld.w		[%sp+ 0], %r9		;//[%sp+ 0] := arg
		xld.w		[%sp+ 4], %r12		;//[%sp+ 4] := pv = base
		xld.w		[%sp+ 8], %r14		;//[%sp+ 8] := width
		xld.w		[%sp+12], %r15		;//[%sp+12] := compare
		;//%r13      := num
		;//[%sp + 0] := arg	
		;//[%sp + 4] := pv	@
		;//[%sp + 8] := width	@
		;//[%sp +12] := compare	@
		;//[%sp +16] := %r0	@
		;//[%sp +20] := %r1	@
		;//[%sp +24] := %r2	@
		;//[%sp +28] := %r3	@
		;//[%sp +32] := %pc	@
		;//[%sp +36] := arg	
qsort_r_L10:						;//
		sub		%r13, 2			;//%r13 := (num-2)						
		jrult		qsort_r_L60		;//while(  (num-2) >= 0) {					
		xld.w		%r0, [%sp+ 4]		;//  %r0  :=      pv						
		xld.w		%r1, [%sp+ 8]		;//  %r1  :=           width					
		add		%r0, %r1		;//  %r0  := lo = pv + width			!INTERLOCK!	
		mltu.w		%r1, %r13		;//  %alr :=           width * (num-2)				
		ld.w		%r1, %alr		;//  %r1  :=           width * (num-2)				
		add		%r1, %r0		;//  %r1  := hi = pv + width * (num-1)				hǐvZ@HvB
		ld.w		%r2, 0			;//  %r2  := lo_cnt = 0
		ld.w		%r3, 0			;//  %r3  := hi_cnt = 0
qsort_r_L20:						;//  do {
		xld.w		%r9, [%sp+12]		;//    %r9  :=            compare
		xld.w		%r13, [%sp+ 4]		;//    %r13 :=                         pv
		xld.w		%r14, [%sp+ 0]		;//    %r14 :=                             arg
		call.d		%r9			;//    %r10 := retval = (*compare)(lo, pv, arg)
		ld.w		%r12, %r0		;//    %r12 :=                  lo		*delay*
		xld.w		%r14, [%sp+ 8]		;//    %r14 :=           width
		cmp		%r10, 0			;//    if(retval <= 0) {
		jrgt		qsort_r_L30		;//      
		add		%r0, %r14		;//      %r0  := lo +=   width
		jp.d		qsort_r_L40		;//      
		add		%r2, 1			;//      %r2  := lo_cnt++			*delay*
qsort_r_L30:						;//    } else
		ld.w		%r12, %r0		;//      %r12 := lo
		ld.w		%r13, %r1		;//      %r13 :=     hi
		xcall.d		xchg			;//      xchg(   lo, hi, width)
		sub		%r1, %r14		;//      %r1  := hi -=   width			*delay*
		add		%r3, 1			;//      %r3  := hi_cnt++
qsort_r_L40:						;//    }
		cmp		%r0, %r1		;//  } while(lo <= hi)
		jrule		qsort_r_L20		;//  
		xld.w		%r12, [%sp+ 4]		;//  %r12 := pv
		xld.w		%r14, [%sp+ 8]		;//  %r14 :=         width
		xcall.d		xchg			;//  xchg(   pv, hi, width)
		ld.w		%r13, %r1		;//  %r13 :=     hi				*delay*
		xld.w		%r14, [%sp+ 8]		;//  %r14 :=               width
		xld.w		%r15, [%sp+12]		;//  %r15 :=                      compare
		cmp		%r2, %r3		;//  if(lo_cnt <= hi_cnt) {
		jrugt		qsort_r_L50		;//    
		xld.w		%r12, [%sp+ 4]		;//    %r12 := pv
		call.d		qsort_r			;//    qsort_r(pv, lo_cnt, width, compare, arg)
		ld.w		%r13, %r2		;//    %r13 :=     lo_cnt			*delay*
		xld.w		[%sp+ 4], %r0		;//    [%sp+ 4] := pv = lo
		jp.d		qsort_r_L10		;//    
		ld.w		%r13, %r3		;//    %r13 := num = hi_cnt			*delay*
qsort_r_L50:						;//  } else {
		ld.w		%r12, %r0		;//    %r12 := lo
		call.d		qsort_r			;//    qsort_r(lo, hi_cnt, width, compare, arg)
		ld.w		%r13, %r3		;//    %r13 :=     hi_cnt			*delay*
		jp.d		qsort_r_L10		;//    
		ld.w		%r13, %r2		;//    %r13 := num = lo_cnt			*delay*
qsort_r_L60:						;//} }
		xadd		%sp, %sp, 16		;//
		popn		%r3			;//
		ret					;//
");
#endif//PIECE

/*****************************************************************************
 *	q[v\[gƃ}[W\[gɂ(2016/06/10)
 *****************************************************************************/

// * Fri Jun 10 21:42:30 JST 2016 Naoyuki Sawa
// - hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//   q[v\[gƃ}[W\[g͕WIC֐ł͂Ȃ̂ŁA܂łclipsort.hŐ錾Ă̂łA
//   (ANSI/ISOPOSIXł͂Ȃ̂)AFreeBSDlibcł́Aq[v\[gƃ}[W\[g`Ă鎖łB
//   FreeBSDlibc̊֐ɕāAheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾鎖ɂ܂B
//
//	QƎ
//	uFreeBSD Library Functions Manual - QSORTv(http://www.freebsd.org/cgi/man.cgi?query=qsort&sektion=3&apropos=0&manpath=FreeBSD+10.3-RELEASE+and+Ports)
//	uFreeBSD Cu֐}jA QSORT(3)v(http://kaworu.jpn.org/doc/FreeBSD/jman/man3/mergesort.3.php)p:
//	
//		
//				qsort,heapsort,mergesort - \[g֐
//		Cu
//				WCCu(libc,lc)
//		
//				#include <stdlib.h>
//				void qsort(void* base, size_t nmemb, size_t size, int (*compar)(const void*, const void*));
//				int heapsort(void* base, size_t nmemb, size_t size, int (*compar)(const void*, const void*));
//				int mergesort(void* base, size_t nmemb, size_t size, int (*compar)(const void*, const void*));
//		
//				qsort()֐́Ap[eBV\[g̏CŁA悤ɃNCbN\[głB
//				heapsort()֐́AI\[g̏CłłB
//				mergesort()֐́Aɕłӏ̂f[^\[gAwɂ}[W\[g̏CłłB
//	
//				qsort()֐heapsort()֐́AbaseɂďowĂnmembIuWFNg̔z\[g܂B
//				eIuWFNg̃TCÝAsizeŎw肵܂B
//				mergesort()悤ɓ삵܂Asize``sizeof(void*)/2''傫Ȃ΂Ȃ܂B	Cu̎łsize̐͗L܂B
//	
//				zbase̓éAcomparwr֐ɏ]ďŃ\[g܂B
//				̊֐ł́ArIuWFNgwA2̈KvłB
//	
//				r֐́Aŏ̈̈菬ꍇ0菬Aꍇ0A傫ꍇ0傫߂Kv܂B
//	
//				qsort()֐heapsort()֐͕słB
//				܂2̃oꍇA\[gςݔzł͕̏sɂȂ܂B
//				mergesort()֐͈łB
//	
//				qsort()֐́Ap[eBV\[g̈łAC.A.R. Hoare``NCbN\[g''ASYĂ܂B
//				ƂD.E. Knuth̃ASYQQƂĂB
//				qsort()ɂ́AςO N lg N̎Ԃ܂B
//				̎ł́AWAIgpāAON**2ƂňȃP[X̓܂B
//	
//				heapsort()֐́AI\[g̈łAJ.W.J. William``q[v\[g''ASYĂ܂B
//				ƂD.E. Knuth̃ASYHQƂĂB
//				heapsort()ɂ́Aň̃P[XO N lg N̎Ԃ܂B
//				قƂǗ]ɎgpȂƂ_݂̂qsort()DĂ܂B
//				Aqsort()̓蓖Ă܂񂪁AċAgpĎĂ܂B
//	
//				mergesort()֐ł́Anmemb*sizeoCg̃]ɕKvƂȂ܂B
//				Xy[Xɗ]Tꍇ݂̂ɎgpĂB
//				mergesort()́Aɕłӏ̂f[^悤œKĂ܂B
//				ň̃P[X̎ԂO N lg NŁAőP̃P[XO NłB
//	
//				ʏ́Aheapsort()mergesort()̕Amergesort()qsort()̕łB
//				gpł郁ʂɕłf[^ʂɂȀ󋵂͕ω܂B
//		߂l
//				qsort()֐͒l߂܂B
//	
//				֐heapsort()mergesort()́Aƒl0Ԃ܂B
//				łȂꍇAl-1ԂAO[oϐerrnoݒ肳ăG[܂B
//		G[
//				heapsort()֐mergesort()֐́Aȉ̂悤ȏꍇɃG[ƂȂ܂B													
//				[EINVAL]
//					size0ł邩Amergesort()size``sizeof(void*)/2''菬ꍇB		Cu̎łsize̐͗L܂B		
//				[ENOMEM]																				vɓ͏0()Ԃ܂B
//					heapsort()mergesort()蓖ĂȂꍇB				Cu̎ł͏ԂɃG[I܂B	
//		݊
//				o[Wqsort()ł́Ar[`qsort(3)ĂяoƂ͂ł܂łB
//				݂͌Ăяo܂B
//		֘A
//				sort(1),radixsort(3)
//		Ki
//				qsort()֐́AISO/IEC 9899:1990(``ISO C89'')ɓKĂ܂B
//				FreeBSD 10.0 June 4, 1993 FreeBSD 10.0
//	
//
// - ƎgƂāAheapsort_r()mergesort_r()ǉ܂B
//   FreeBSDlibcŒ`Ă܂񂪁AKvƎvłB
//   Ǝgbsearch_r()ǉƓlłB
//   ڍׂ́Acliplibc.c'Wed May 04 21:28:21 JST 2016'̃RgQƂĉB

/*****************************************************************************
 *	q[v\[g
 *****************************************************************************/

#ifndef PIECE	//{{2016/06/10:P/ECEł̓R[hTCYߖ̂߂Ƀq[v\[g𖳌Ă܂BL鎖\łB}}

// * Sun May 13 14:21:21 JST 2007 Naoyuki Sawa
// - uq[v\[g - Wikipediav̋[R[hQlɁAœKč쐬܂B
//   (URL: http://ja.wikipedia.org/w/index.php?title=%E3%83%92%E3%83%BC%E3%83%97%E3%82%BD%E3%83%BC%E3%83%88&oldid=12248591)
//   œKȓ_́Aeq̗vfw߂̃CfNXg킸ɁAׂă|C^ŏč}ƂłB
// - q[v\[gNBbN\[gDĂ_́Af[^̂肪xɂ܂eȂƂłB
//   NBbN\[ǵAlɃ_Ȑ̃\[g΂񑁂AX̃\[g͒xAt̃\[gƂxłB
//   q[v\[ǵAǂ̃P[Xɑ΂Ă悻炢̑xŊ܂B
// - ۂɂ́ANBbN\[gq[v\[gIʂ͖Ǝv܂B
//   NBbN\[gɕsȋt̃\[głĂANBbN\[g̕q[v\[g{炢ł悤łB
//   lɃ_Ȑ̃\[g̏ꍇ́A50{ȏ̑xtĂ܂܂B
//   (WindowsŎꍇ͂܂ł̑x͕tȂ̂łAP/ECEł͂Ȃq̂悤ȑ卷ɂȂĂ܂܂B)
// - ȉ̃R[h́AƂmFς݂łAۂɎgƂ͖Ǝv܂B
//   NTCYȂ悤ɃRgAEgĂ܂̂ŁAgꍇ̓AvP[VɃRs[ĎgĂB
// * Fri Jun 10 21:42:30 JST 2016 Naoyuki Sawa
// - hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//   ܂ł́Aq[v\[g̎̓RgAEgĂ܂AWin32ł͗L܂B
//   AۂɕKvɂȂ鎖͖Ǝv̂ŁAP/ECEł̓R[hTCYߖ̂߂ɖ܂܂Ƃ܂B
//   Aq[v\[gLŔA܂łWin32ł̃eXĝ߂łB

//{{2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//static void make_heap(unsigned char* base, unsigned char* last, size_t width, int (*compare)(const void*, const void*), unsigned char* parent) {
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
static void make_heap(unsigned char* base, unsigned char* last, size_t width, int (*compare)(const void*, const void*, void*), unsigned char* parent, void* arg) {
//}}2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
	unsigned char *child1, *child2;
	/* ̎qL... */
	child1 = (base + (parent - base) * 2) + width;
	if(child1 <= last) {
		/* ̎q̃c[\[g܂B */
//{{2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//		make_heap(base, last, width, compare, child1);
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
		make_heap(base, last, width, compare, child1, arg);
//}}2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
		/* E̎qL... */
		child2 = child1 + width;
		if(child2 <= last) {
			/* E̎q̃c[\[g܂B */
//{{2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//			make_heap(base, last, width, compare, child2);
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
			make_heap(base, last, width, compare, child2, arg);
//}}2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
			/* child1傫̎qw悤ɂ܂B */
//{{2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//			if((*compare)(child1, child2) < 0) {
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
			if((*compare)(child1, child2, arg) < 0) {
//}}2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
				child1 = child2;
			}
		}
		/* 傫̎qe傫... */
//{{2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//		if((*compare)(parent, child1) < 0) {
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
		if((*compare)(parent, child1, arg) < 0) {
//}}2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
			/* 傫̎qƐeւ܂B */
			xchg(parent, child1, width);
			//make_heap(base, last, width, compare, child1);
			//q̃c[̃\[g͎ɍŝŕsvłB
		}
	}
}

//{{2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//void hsort(void* _base, size_t num, size_t width, int (*compare)(const void*, const void*)) {
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
int heapsort(void* _base, size_t num, size_t width, int (*compare)(const void*, const void*)) {	//FreeBSD 10.0 June 4, 1993 FreeBSD 10.0
	return heapsort_r(_base, num, width, (int (*)(const void*, const void*, void*))compare, NULL);
}
int heapsort_r(void* _base, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void* arg) {	//Ǝg
//}}2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
	unsigned char* base = _base;
	unsigned char* last = base + (width * (num - 1));
	while(base < last) {
		/* c[Ŝ~Ƀ\[g܂B */
//{{2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//		make_heap(base, last, width, compare, base);
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
		make_heap(base, last, width, compare, base, arg);
//}}2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
		/* ővfc[̖ɐ؂藣܂B */
		xchg(base, last, width);
		last -= width;
	}
//{{2016/06/10ǉ:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
	return 0;
//}}2016/06/10ǉ:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
}

#endif//PIECE	//{{2016/06/10:P/ECEł̓R[hTCYߖ̂߂Ƀq[v\[g𖳌Ă܂BL鎖\łB}}

/*****************************************************************************
 *	}[W\[g
 *****************************************************************************/

/* * Mon Oct 18 15:12:52 JST 2010 Naoyuki Sawa
 * - msort()֐ۂɎQlɂWebTCgAeLXgċL^ĂƂɂ܂B
 *   wil`wɂjASYIɂ郆[U[C^[tF[X̉ǁx̒́A
 *   @(http://www.th.cs.meiji.ac.jp/researches/2005/omoto/index.html)
 *   u8. }[W\[gṽy[WApĂ܂B
 *   @(http://www.th.cs.meiji.ac.jp/researches/2005/omoto/mergesort.html)
 * - ʓIɃ}[W\[ǵAċApĎ̂łǁALTCg̃Tv\[X́AċApȂŎĂ܂B
 *   ܂Amۂ̎dg݂₷A\[X̌ꂽ}CR̎Ǝv܂B
 * 
 * 	
 * 	}[W\[g														
 * 	
 * 
 * 	
 * 	}[W\[gƂ́H													
 * 	
 * 
 * 	}[W\[ǵAf[^ɕAĂу}[Wijɑ傫̏Ƀf[^oĕׂB
 * 	ꂽꂼꂪ傫̏ɕł΃}[Ŵ傫̏ɕԂ̂ŁAꂽ̂ɑ΂Ă
 * 	}[W\[giȂ̃\[gcႦΕ̃f[^QƂR̏ꍇ͒PȔrōςށjċAIɓKpΗǂB
 * 	\[grIŁAʂ̂̂̏ۑƂB
 * 
 * 	
 * 	l														
 * 	
 * 
 * 	oƂẮAuQ{̔zpӂAꂽm[h\[gsvƂłB
 * 
 * 	Â悤Ȕz񂪑݂ƂB
 * 
 * 		
 * 		SPQUXVRW
 * 		
 * 		
 * 		@@@@@@@@
 * 		
 * 
 * 	ׂĂ̂A܂AQŕB
 * 
 * 		
 * 		SPQUXVRW
 * 		
 * 		
 * 		@@@@@@@@
 * 		
 * 
 * 	ꂽ͈͓ŁAPpӂꂽzɃ\[glĂB
 * 
 * 		
 * 		SPQUXVRW
 * 		
 * 		@@@@@@@@@@@@
 * 		
 * 		PSQUVXRW
 * 		
 * 
 * 	ɐVlێz𕪊̂AQ~QSŕB
 * 
 * 		
 * 		SPQUXVRW
 * 		
 * 		
 * 		PSQUVXRW
 * 		
 * 
 * 	ꂽ͈͓ŁA̔zɃ\[glĂB
 * 
 * 		
 * 		PQSURVWX
 * 		
 * 		@@@@@@@@@@@@@@
 * 		
 * 		PSQUVXRW
 * 		
 * 
 * 	ɐVlێ̔z𕪊BS~QWŕB
 * 
 * 		
 * 		PQSURVWX
 * 		
 * 		
 * 		PSQUVXRW
 * 		
 * 
 * 	ꂽ͈͓ŁAPpӂꂽzɃ\[glĂB
 * 
 * 		
 * 		PQSURVWX
 * 		
 * 		@@@@@@@@@@@@@@@
 * 		
 * 		PQRSUVWX
 * 		
 * 
 * 	ɐVlێz𕪊̂AvfWł̂łWŕB
 * 
 * 		
 * 		PQSURVWX
 * 		
 * 		
 * 		PQRSUVWX
 * 		
 * 
 * 	ꂽ͈͓ŁA̔zɃ\[glĂB
 * 
 * 		
 * 		PQRSUVWX
 * 		
 * 		@@@@@@@@@@@@@@@
 * 		
 * 		PQRSUVWX
 * 		
 * 
 * 	̔z𕪊ۂɁA͈̔͂vf𒴂ĂꍇA\[gIƂȂB
 * 
 * 	ȏオ}[W\[g̗łB
 * 
 * 	}[W\[g̃ASY͈ȉ̂悤ɋLqłB
 * 
 * 		void sort() {							// }[W\[g()
 * 			int seqsize = 1;					// 傫̏l1Ƃ
 * 			while (seqsize < length) {				// \[g傫f[^΁C
 * 				mergeseqs(seqsize, a, b);			// w肳ꂽ傫Ŕzazbփ}[W
 * 				mergeseqs(2 * seqsize, b, a);			// w肳ꂽ2{̑傫Ŕzbzaփ}[W
 * 				seqsize = 4 * seqsize;				// 傫4{ɂD
 * 			}
 * 		}
 * 
 * 		void mergeseqs(int size, int from [], int to []) {		// fromz񂩂}[Wtoz
 * 			int i, j, k, iend, jend;
 * 			int start = 0;
 * 			while (start < length) {
 * 				i = start;					// i: }[W̎n܂
 * 				j = start + size;				// j: }[W̗̎n܂
 * 				k = start;					// k: }[Wʂ̗̎n܂
 * 				iend = Math.min(start + size, length);		// ΏۂƂzvf̍ŌvZ
 * 				jend = Math.min(start + 2 * size, length);	// ΏۂƂzvf̍ŌvZ
 * 				while (i < iend && j < jend) {			// }[W2ꍇ
 * 					if (from[i] <= from[j]) {
 * 						to[k] = from[i];		// l̕Rs[
 * 						i++;
 * 						k++;
 * 					} else {
 * 						to[k] = from[j];		// l̕Rs[
 * 						j++;
 * 						k++;
 * 					}
 * 				}
 * 				while (i < iend) {				// }[W1̏ꍇ
 * 					to[k] = from[i];			// l̃Rs[
 * 					i++;
 * 					k++;
 * 				}
 * 				while (j < jend) {				// }[W1̏ꍇ
 * 					to[k] = from[j];			// l̃Rs[
 * 					j++;
 * 					k++;
 * 				}
 * 				start = start + 2 * size;			// VȊJn_ݒ
 * 			}
 * 		}
 * 
 * 	vOp
 * 	Lecture of Computer Programming I by Hiroshi Ichiji 
 * 	(http://lecture.ecc.u-tokyo.ac.jp/~cichiji/cp-01/cp-01.html)
 */

#if 0
//{{2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//static void mergeseqs(size_t size, const unsigned char* from, unsigned char* to, size_t num, size_t width, int (*compare)(const void*, const void*)) {
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//fȎ
static void mergeseqs(size_t size, const unsigned char* from, unsigned char* to, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void* arg) {
//}}2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
	size_t i, j, k, iend, jend;
	for(jend = 0; jend < num; /** no job **/) {
		i    = k = jend;
		iend = j = i + size;
		jend     = j + size;
		if(iend > num) {
			iend = num;
		}
		if(jend > num) {
			jend = num;
		}
		while((i < iend) && (j < jend)) {
//{{2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//			if((*compare)(&from[i * width], &from[j * width]) <= 0) {
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
			if((*compare)(&from[i * width], &from[j * width], arg) <= 0) {
//}}2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
				memcpy(&to[k++ * width], &from[i++ * width], width);
			} else {
				memcpy(&to[k++ * width], &from[j++ * width], width);
			}
		}
		if(i < iend) {
			memcpy(&to[k * width], &from[i * width], (iend - i) * width);
		}
		if(j < jend) {
			memcpy(&to[k * width], &from[j * width], (jend - j) * width);
		}
	}
}
//{{2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//void msort(void* base, size_t num, size_t width, int (*compare)(const void*, const void*)) {
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
int mergesort(void* base, size_t num, size_t width, int (*compare)(const void*, const void*)) {	//FreeBSD 10.0 June 4, 1993 FreeBSD 10.0
	return mergesort_r(base, num, width, (int (*)(const void*, const void*, void*))compare, NULL);
}
int mergesort_r(void* base, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void* arg) {	//Ǝg
//}}2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
	void *a = base, *b;
	size_t seqsize;
	b = malloc(num * width);
	if(!b) { DIE(); }
	for(seqsize = 1; seqsize < num; /** no job **/) {
//{{2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//		mergeseqs(seqsize, a, b, num, width, compare);
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
		mergeseqs(seqsize, a, b, num, width, compare, arg);
//}}2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
		seqsize *= 2;
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
//		mergeseqs(seqsize, b, a, num, width, compare);
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
		mergeseqs(seqsize, b, a, num, width, compare, arg);
//2016/06/10ύX:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
		seqsize *= 2;
	}
	free(b);
//{{2016/06/10ǉ:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
	return 0;
//}}2016/06/10ǉ:hsort()msort()Aheapsort()mergesort()ɖOύXA/clip/include/stdlib.hŐ錾悤ɂ܂B
}
#else	//{{2016/06/10ύX:AZu܂BR[hTCY72oCgȂ܂BxȂƎv܂AXmalloc/freegĂ̂őŜƂĂ̑x͂܂ςȂƎv܂B}}
//AZu邽߂̏ƂĕύXB
// - 'fȎ'ł̓CfNXx[XłA'AZu邽߂̏ƂĕύX'ł̓|C^x[X̏ɕύX܂B
//   ύXŔAAZu鎞ɁAKvȃWX^炷߂̏łB
// - 'AZu邽߂̏ƂĕύX'AASŶ'fȎ'ƓłB
//   'AZu邽߂̏ƂĕύX'̃R[h́AǂŔÂ炢Ǝv̂ŁAASŶ'fȎ'QƂĉB
#ifndef PIECE
static void mergeseqs(size_t size, const unsigned char* from, unsigned char* to, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void* arg) {
	const int from_to = to - from;							//ȍ~Ato͕svB		ȍ~Afrom_to͕ωȂB		from_to̓ɒuB
	const unsigned char *from_num, *from_i, *from_iend, *from_j, *from_jend;
	unsigned char* to_k;
	size *= width;									//				ȍ~Asize͕ωȂB		size̓ɒuB
	num  *= width;									//				ȍ~Anum͕ωȂB
	from_num = &from[num];								//ȍ~Anum͕svB		ȍ~Afrom_num͕ωȂB	from_num̓ɒuĂǂAWX^]̂ŁAfrom_numWX^ɒuɂBɒuĂǂϐ̂Afrom_numWX^ɒûԌʂƎvłB
	for(from_jend = from; from_jend < from_num; /** no job **/) {			//ȍ~Afrom͕svB
		from_i    = from_jend;							//													from_i̓WX^ɒuB
		from_iend = from_i + size;
		from_j    = from_iend;							//													from_j̓WX^ɒuB
		from_jend = from_j + size;						//ȍ~Asize͕svB
		if(from_iend > from_num) {
			from_iend = from_num;						//				ȍ~Afrom_iend͕ωȂB	from_iend̓ɒuB
		}
		if(from_jend > from_num) {
			from_jend = from_num;						//				ȍ~Afrom_jend͕ωȂB	from_jend̓ɒuB
		}
		to_k = (unsigned char*)(from_i + from_to);				//													to_k̓WX^ɒuB
		while((from_i < from_iend) && (from_j < from_jend)) {
			if((*compare)(from_i, from_j, arg) <= 0) {
				memcpy(to_k, from_i, width);
				from_i += width;
			} else {
				memcpy(to_k, from_j, width);
				from_j += width;
			}
			to_k += width;
		}
		if(from_iend > from_i) {
			memcpy(to_k, from_i, from_iend - from_i);
		}
		if(from_jend > from_j) {
			memcpy(to_k, from_j, from_jend - from_j);
		}
	}
}
int mergesort(void* base, size_t num, size_t width, int (*compare)(const void*, const void*)) {	//FreeBSD 10.0 June 4, 1993 FreeBSD 10.0
	return mergesort_r(base, num, width, (int (*)(const void*, const void*, void*))compare, NULL);
}
int mergesort_r(void* base, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void* arg) {	//Ǝg
	void *a = base, *b;
	size_t seqsize;
	b = malloc(num * width);
	if(!b) { DIE(); }
	for(seqsize = 1; seqsize < num; /** no job **/) {
		mergeseqs(seqsize, a, b, num, width, compare, arg);
		seqsize *= 2;
		mergeseqs(seqsize, b, a, num, width, compare, arg);
		seqsize *= 2;
	}
	free(b);
	return 0;
}
#else //PIECE
/*static*/ void mergeseqs(size_t size, const unsigned char* from, unsigned char* to, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void* arg);
int mergesort(void* base, size_t num, size_t width, int (*compare)(const void*, const void*));	//FreeBSD 10.0 June 4, 1993 FreeBSD 10.0
int mergesort_r(void* base, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void* arg);	//Ǝg
asm("
		.global		mergesort
		.global		mergesort_r
mergesort:
		;//[%sp+0] := retp
		;//[%sp+4] := (arg = sl)
mergesort_r:
		pushn		%r3
		xsub		%sp, %sp, 12
		;//%r0      := (a)
		;//%r1      := (num)
		;//%r2      := (b)
		;//%r3      := (seqsize)
		;//%r12     := base
		;//%r13     := num
		;//%r14     := width
		;//%r15     := compare
		;//[%sp+0]  := (width)		
		;//[%sp+4]  := (compare)	mergeseqs()ւ̑5,6,7ɂȂ܂B
		;//[%sp+8]  := (arg)		
		;//[%sp+12] := %r0
		;//[%sp+16] := %r1
		;//[%sp+20] := %r2
		;//[%sp+24] := %r3
		;//[%sp+28] := retp
		;//[%sp+32] := arg
		ld.w		%r0, %r12			;//%r0     := a = base
		ld.w		%r1, %r13			;//%r1     := num
		xld.w		%r9, [%sp+32]			;//%r9     := arg
		xld.w		[%sp+0], %r14			;//[%sp+0] := width
		xld.w		[%sp+4], %r15			;//[%sp+4] := compare
		xld.w		[%sp+8], %r9			;//[%sp+8] := arg
		mlt.w		%r13, %r14			;//%alr    :=            num * width
		xcall.d		malloc				;//%r10    := b = malloc(num * width)
		ld.w		%r12, %alr			;//%r12    :=            num * width				*delay*
		cmp		%r10, 0				;//if(       !b) { DIE() }
		jreq		mergesort_r_DIE			;//
		ld.w		%r2, %r10			;//%r2     := b
		ld.w		%r3, 1				;//%r3     :=  seqsize = 1
		;//- - - - - - - - - - - - - - - - - - - - - - -;//
mergesort_r_LOOP:						;//for(;;) {
		cmp		%r3, %r1			;//  if(seqsize >= num) { goto EXIT }
		jrge		mergesort_r_EXIT		;//  
		ld.w		%r12, %r3			;//  %r12 :=   seqsize
		ld.w		%r13, %r0			;//  %r13 :=            a
		ld.w		%r14, %r2			;//  %r14 :=               b
		call.d		mergeseqs			;//  mergeseqs(seqsize, a, b, num, width, compare, arg)
		ld.w		%r15, %r1			;//  %r15 :=                  num				*delay*
		add		%r3, %r3			;//  %r3  :=   seqsize *= 2
		ld.w		%r12, %r3			;//  %r12 :=   seqsize
		ld.w		%r13, %r2			;//  %r13 :=            b
		ld.w		%r14, %r0			;//  %r14 :=               a
		call.d		mergeseqs			;//  mergeseqs(seqsize, b, a, num, width, compare, arg)
		ld.w		%r15, %r1			;//  %r15 :=                  num				*delay*
		jp.d		mergesort_r_LOOP		;//}
		add		%r3, %r3			;//  %r3  :=   seqsize *= 2					*delay*
mergesort_r_EXIT:						;//
		;//- - - - - - - - - - - - - - - - - - - - - - -;//
		xcall.d		free				;//free(     b)
		ld.w		%r12, %r2			;//%r12   := b							*delay*
		xadd		%sp, %sp, 12			;//
		popn		%r3				;//
		ret.d						;//return    0
		ld.w		%r10, 0				;//%r10   := 0							*delay*
		;//---------------------------------------------;//
mergeseqs:
		pushn		%r3
		xsub		%sp, %sp, 16
		;//%r0      := (from_num)
		;//%r1      := (from_i)
		;//%r2      := (from_j)
		;//%r3      := (to_k)
		;//%r12     := size
		;//%r13     := from	
		;//%r14     := to													
		;//%r15     := num													
		;//[%sp+0]  := (from_to)												
		;//[%sp+4]  := (size)													
		;//[%sp+8]  := (from_iend)												
		;//[%sp+12] := (from_jend)												
		;//[%sp+16] := %r0													
		;//[%sp+20] := %r1													
		;//[%sp+24] := %r2													
		;//[%sp+28] := %r3													
		;//[%sp+32] := retp													
		;//[%sp+36] := width													
		;//[%sp+40] := compare													
		;//[%sp+44] := arg													
		xld.w		%r9, [%sp+36]			;//%r9      :=         width						
		sub		%r14, %r13			;//%r14     := from_to = to - from					
		xld.w		[%sp+0], %r14			;//[%sp+0]  := from_to							
		mlt.w		%r12, %r9			;//%alr     := size *= width						
		ld.w		%r12, %alr			;//%r12     := size							
		xld.w		[%sp+4], %r12			;//[%sp+4]  := size							
		mlt.w		%r15, %r9			;//%alr     :=                  num *= width				
		ld.w		%r0, %alr			;//%r0      :=                  num					
		add		%r0, %r13			;//%r0      := from_num = &from[num]					
		;//- - - - - - - - - - - - - - - - - - - - - - -;//%r13     := from_jend = from						
mergeseqs_LOOP1:						;//for(;;) {								
		cmp		%r13, %r0			;//  if(from_jend >= from_num) { goto EXIT1 }	
		jruge		mergeseqs_EXIT1			;//  									
		xld.w		%r3, [%sp+0]			;//  %r3      :=                 from_to				
		xld.w		%r4, [%sp+4]			;//  %r4      :=                      size				
		ld.w		%r1, %r13			;//  %r1      := from_i    = from_jend					
		ld.w		%r5, %r1			;//  %r5      :=             from_i					
		add		%r5, %r4			;//  %r5      := from_iend = from_i + size				
		ld.w		%r2, %r5			;//  %r2      := from_j    = from_iend					
		ld.w		%r6, %r2			;//  %r6      :=             from_j					
		add		%r6, %r4			;//  %r6      := from_jend = from_j + size				
		cmp		%r5, %r0			;//  if(from_iend > from_num) {						
		jrule.d		3				;//    									
		 cmp		%r6, %r0			;//   				*delay*
		 ld.w		%r5, %r0			;//    %r5      := from_iend = from_num }				
	;//	cmp		%r6, %r0			;//  if(from_jend > from_num) {					
		jrule.d		3				;//    									
		 add		%r3, %r1			;//  %r3      := to_k = from_i + from_to					*delay*
		 ld.w		%r6, %r0			;//    %r6      := from_jend = from_num }				
		xld.w		[%sp+8], %r5			;//  [%sp+8]  := from_iend						
		xld.w		[%sp+12], %r6			;//  [%sp+12] := from_jend						
		;//- - - - - - - - - - - - - - - - - - - - - - -;//									
mergeseqs_LOOP2:						;//  for(;;) {								
		xld.w		%r14, [%sp+8]			;//    %r14     := from_iend		
		xld.w		%r9, [%sp+12]			;//    %r9      := from_jend							*anti-interlock*
		cmp		%r1, %r14			;//    if(from_i >= from_iend) { goto EXIT2 }				
		jruge		mergeseqs_EXIT2			;//    									
		cmp		%r2, %r9			;//    if(from_j >= from_jend) { goto EXIT2 }				
		jruge		mergeseqs_EXIT2			;//    									
		xld.w		%r9, [%sp+40]			;//    %r9      :=   compare						
		xld.w		%r14, [%sp+44]			;//    %r14     :=                            arg			
		ld.w		%r12, %r1			;//    %r12     :=            from_i					
		call.d		%r9				;//    %r10     := (*compare)(from_i, from_j, arg)			
		ld.w		%r13, %r2			;//    %r13     :=                    from_j					*delay*
		xld.w		%r14, [%sp+36]			;//    %r14     :=                 width				
		cmp		%r10, 0				;//    if(         (*compare)(from_i, from_j, arg) <= 0) {		
		jrgt.d		5		;//		;//      								
		 ld.w		%r12, %r3	;//@		;//    %r12     := to_k								*delay*
		 ld.w		%r13, %r1	;//@		;//      %r13     :=     from_i				
		 jp.d		4		;//@	;//	;//    } else {								
		 add		%r1, %r14	;//@	;//@	;//      %r1      :=     from_i += width					*delay*
		ld.w		%r13, %r2	;//	;//@	;//      %r13     :=     from_j				
		add		%r2, %r14		;//@	;//      %r2      :=     from_j += width				
		call.d		mergeseqs_MEMCPY	;//	;//      memcpy(   to_k, from_?,   width)			
		add		%r3, %r14			;//    %r3      := to_k         += width					*delay*
		jp		mergeseqs_LOOP2			;//  }										*anti-interlock*
mergeseqs_EXIT2:						;//  									
		;//- - - - - - - - - - - - - - - - - - - - - - -;//									
	;//	xld.w		%r14, [%sp+8]			;//  %r14     :=                 from_iend		
		sub		%r14, %r1			;//  %r14     :=                 from_iend - from_i			
		jrule		4				;//  if(                         from_iend > from_i) {			
		 ld.w		%r12, %r3			;//    %r12     := to_k							
		 call.d		mergeseqs_MEMCPY		;//    memcpy(     to_k, from_i, from_iend - from_i) }			
		 ld.w		%r13, %r1			;//    %r13     :=       from_i							*delay*
		xld.w		%r14, [%sp+12]			;//  %r14     :=                 from_jend				
		sub		%r14, %r2			;//  if(                         from_jend - from_j) {				!INTERLOCK!
		jrule		4				;//  if(                         from_jend > from_j) {			
		 ld.w		%r12, %r3			;//    %r12     := to_k							
		 call.d		mergeseqs_MEMCPY		;//    memcpy(     to_k, from_j, from_jend - from_j) }			
		 ld.w		%r13, %r2			;//    %r13     :=       from_j							*delay*
		xld.w		%r13, [%sp+12]			;//  %r13     := from_jend	
		jp		mergeseqs_LOOP1			;//}
mergeseqs_EXIT1:						;//
		;//- - - - - - - - - - - - - - - - - - - - - - -;//
		xadd		%sp, %sp, 16			;//
		popn		%r3				;//
		ret						;//
		;//- - - - - - - - - - - - - - - - - - - - - - -;//
mergeseqs_MEMCPY:						;//
		xjp		memcpy				;//֐ɂmemcpyĂяo3L̂ŁA31(jp)ɂāAɒǉ2(xjp)݂AŜƂĂ1߂̐ߖɂȂB
");
static void __attribute__((noreturn,unused))/*asmubNQ*/ mergesort_r_DIE() { DIE(); }
#endif//PIECE
#endif

/*****************************************************************************
 *	eXgXC[g
 *****************************************************************************/
#if 0
static void test_subr(void (*sort_r)(void*, size_t, size_t, int (*)(const void*,const void*, void*), void*));	//OQ
//2016/06/10݁AWin32P/ECEŐɓ삷鎖mF܂B
void test() {
	int i;
	for(i = 0; i < 100; i++) { test_subr(qsort_r); }											//qsort_r̃eXg
  #ifndef PIECE	//{{2016/06/10:P/ECEł̓R[hTCYߖ̂߂Ƀq[v\[g𖳌Ă܂BL鎖\łB}}
	for(i = 0; i < 100; i++) { test_subr((void (*)(void*, size_t, size_t, int (*)(const void*,const void*, void*), void*))heapsort_r); }	//heapsort_r̃eXg
  #endif//PIECE	//{{2016/06/10:P/ECEł̓R[hTCYߖ̂߂Ƀq[v\[g𖳌Ă܂BL鎖\łB}}
	for(i = 0; i < 100; i++) { test_subr((void (*)(void*, size_t, size_t, int (*)(const void*,const void*, void*), void*))mergesort_r); }	//mergesort_r̃eXg
	puts("ok");
}
static int compar(const void* _x, const void* _y, void* arg) {
	const char* x = _x;
	const char* y = _y;
	int offset = (int)arg;
	return x[offset] - y[offset];
}
static void test_subr(void (*sort_r)(void*, size_t, size_t, int (*)(const void*,const void*, void*), void*)) {
    #define N 127
	char data[N][2+1/*nul*/];
	int i;
	//_ȕ("0A"`"9Z")쐬B
	for(i = 0; i < N; i++) {
		data[i][0] = RND32_RANGE(seed, '0', '9' + 1);
		data[i][1] = RND32_RANGE(seed, 'A', 'Z' + 1);
		data[i][2] = '\0';
	}
	//ɁA2ڂŃ\[gB
	(*sort_r)(&data[0][0], N, 2+1/*nul*/, compar, (void*)1);
	//ɁA1ڂŃ\[gB
	(*sort_r)(&data[0][0], N, 2+1/*nul*/, compar, (void*)0);
	//ʂmFB
	for(i = 0; i < N; i++) {
	    //	printf("%s\n", data[i]);
		if(i && (strncmp(data[i - 1], data[i], 1) > 0)) { DIE(); }										//ǂ̃\[głAŃ\[g(1)͏ɂȂĂ͂B
		if(i && ( strcmp(data[i - 1], data[i]   ) > 0)) { if((void*)sort_r == (void*)mergesort_r) { DIE(); } /*else { printf("*"); }*/ }	//mergesort_r͈\[gȂ̂ŐɃ\[g(2)͈ێĂ͂Bqsort_r,heapsort_r͕s\[gȂ̂ŐɃ\[g(2)͕słB
	}
    #undef  N
}
#endif

/****************************************************************************
 *	xv(2016/06/11)
 ****************************************************************************/
// * Sat Jun 11 20:47:59 JST 2016 Naoyuki Sawa
// - clipsort.c̈ԉɁAuxv(2016/06/11)vǋL܂B
//   Win10(x64)P/ECEŁAe֐̑xvʂƁAl@łB
//   {{vvO:
#if 0
#define N 32768
static uint8_t data[N][2];
static int compar(const void* _x, const void* _y, void* arg) {
	int offset = (int)arg;
	int x = ((uint8_t*)_x)[offset];
	int y = ((uint8_t*)_y)[offset];
	if(x < y) { return -1; }
	if(x > y) { return  1; }
	return 0;
}
static void test(void (*sort)(void*,size_t,size_t,int (*)(const void*,const void*,void*), void*)) {
	int i, t, seed = 0;
	for(i = 0; i < N; i++) {
		data[i][0] = RND8(seed);
		data[i][1] = RND8(seed);
	}
    #ifdef  PIECE
	t = pceTimerGetCount();
    #else //PIECE
	t = GetTickCount();
    #endif//PIECE
	for(i = 0; i < 3; i++) {
		(*sort)(data, N, 2, compar, (void*)0);
		(*sort)(data, N, 2, compar, (void*)1);
	}
    #ifdef  PIECE
	t = pceTimerGetCount() - t;
	die("%d", t);
    #else //PIECE
	t = GetTickCount() - t;
	printf("%d\n", t);
	getch();
    #endif//PIECE
}
int app_main(int argc, char* argv[]) {
	test(qsort_r);
   //	test(heapsort_r);
   //	test(qsort_r);
	return 0;
}
#endif
//   }}vvO:܂
// - 
//   test(qsort_r)̌:
//   ECore i7-4500U	   78[ms]	VC++6.0,[Xsh
//   EP/ECE		43407[ms]	Cqsort_r()
//   EP/ECE		41404[ms]	AZuqsort_r()
//   test(heapsort_r)̌:
//   ECore i7-4500U	45953[ms]	VC++6.0,[Xsh
//   EP/ECE		(Ή)
//   test(mergesort_r)̌:
//   ECore i7-4500U	   63[ms]	VC++6.0,[Xsh
//   EP/ECE		12119[ms]	Cqsort_r()
//   EP/ECE		11377[ms]	AZuqsort_r()
// - l@
//   EӊOɂqsort_r()mergesort_r()̕B
//     Ľʂmergesort_r()malloc/free̎Ԃ܂ł邪Ałmergesort_r()̕B
//     A̓f[^傫̂malloc/free߂銄ŁAf[^malloc/free߂銄傫ȂČʂt]\͗LB
//   EIȃmۂsĂƂ_΁Amergesort_r()\[g\ǂ݂B
//     ܂ł͖qsort_r()gĂAmergesort_r()̎gpϋɓIɌ悤B
//     ɁAImۂ̃RXgPCł́Amergesort_r()ϋɓIɎgĂǂB
//   Ełheapsort_r()ɒ[ɒxB
//     ݂heapsort_r()͓{ŃEBLyfBÃq[v\[g̃y[Wč̂AǂEBLyfBÃTv͂Ȃxł悤B
//     QƎ:uDreamHopev(http://www.dreamhope.net/)́wq[v\[głȂċAH`{ŃEBLyfBA̖_ƍŋő̃q[v\[g`x(http://www.dreamhope.net/soliloquies/HeapSort/)
//     AL̋LQlɂāAheapsort_r()蒼B	TODO:
