/*	
 *	clipslip.c
 *
 *	SLIP(Serial Line Internet Protocol)T[o
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sun Jul 24 11:35:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sun Jul 31 05:41:00 JST 2005 Naoyuki Sawa
 *	- clipuioɑ΂A{̎dlύX:
 *	  > M荞ݔɁAMobt@󂾂ꍇɂ̂݁AMR[obNs悤ύX܂B
 *	  > ܂ł́A1pPbgM(0oCgpPbg̑M܂)ɑMR[obNsĂ܂B
 *	  ɒǏ]܂B
 *	  ܂ł́AclipslipɂāA0oCgMR[obN}΍̂Ă̂łA
 *	  clipuio̎dlύXɂAclipslip̑΍R[hsvƂȂ߁A菜܂B
 *	* Mon Aug 22 04:24:00 JST 2005 Naoyuki Sawa
 *	- slip_open(),slip_close()->slip_start(),slip_stop()ɖOύX܂B
 *	- uio_open(),uio_close()->uio_start(),uio_stop()̖OύXɒǏ]܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

typedef struct _SLIP {
	int mtu;				/* ő]P (l=1006oCg) */
	//
	unsigned char* rxbuf/*[mtu]*/;		/* Mobt@ */
	int rxphase;				/* MtF[Y */
	int rxlen;				/* MoCg */
	int rxlog;				/* MpPbg (G[pPbg܂݂܂) */
	void (*rxdone)();			/* MR[obN (NULL=) */
	//
	unsigned char* txbuf/*[mtu]*/;		/* Mobt@ */
	int txphase;				/* MtF[Y */
	int txlen;				/* MoCg */
	int txlog;				/* MpPbg */
	void (*txdone)();			/* MR[obN (NULL=) */
	//
	char client[6];				/* "CLIENT"opobt@ */
	int cslog;				/* "CLIENT""CLIENTSERVER"nhVFCN */
	//					/* (MpPbgɋR܂܂ꂽ"CLIENT"ɑ΂Apȉ񐔂܂݂܂) */
} SLIP;
static SLIP slip;

/* SLIP.phase */
#define SLIP_IDLE		0x00		/* M~A܂́AM~ */
//
#define SLIP_RX_NORMAL		0x10		/* ʏ̎M */
#define SLIP_RX_ESCAPE		0x11		/* ESC($DB)̎M */
#define SLIP_RX_DONE		0x12		/* MpPbgAǂݏo҂ */
//
#define SLIP_TX_CLIENTSERVER	0x20		/* "CLIENTSERVER"o */
#define SLIP_TX_START		0x21		/* 擪END($C0)o҂ */
#define SLIP_TX_NORMAL		0x22		/* ʏ̑M */
#define SLIP_TX_ESCAPE		0x23		/* ESC($DB)̑M */

/****************************************************************************
 *	荞݋֎~ԁŎgpA֐
 ****************************************************************************/

static void rx_isr();
static void tx_isr();
static void rx_sub();
static void tx_sub();

static void
rx_isr()
{
	for(;;) {
		/* MpPbggݗĂ܂B */
		rx_sub();

		/* MpPbgȂ΁A܂B */
		if(slip.rxphase != SLIP_RX_DONE) {
			break;
		}

		/* MR[obN֒ʒm܂B */
		if(slip.rxdone) {
			slip.rxdone();
		}

		/* MpPbgǂݏoꂸɎcĂA܂B */
		if(slip.rxphase == SLIP_RX_DONE) {
			break;
		}
	}
}

static void
tx_isr()
{
	for(;;) {
		/* MpPbg𑗏o܂B */
		tx_sub();

		/* MpPbgcĂA܂B */
		if(slip.txphase != SLIP_IDLE) {
			break;
		}

		/* MR[obN֒ʒm܂B */
		if(slip.txdone) {
			slip.txdone();
		}

		/* ̑MpPbgǉĂȂA܂B */
		if(slip.txphase == SLIP_IDLE) {
			break;
		}
	}
}

static void
rx_sub()
{
	int retval;
	unsigned char v;

	/* MpPbg邩A܂́AIɃ[v𔲂܂... */
	while(slip.rxphase != SLIP_RX_DONE) {

		/* USB I/O1oCgM܂B */
		retval = uio_recv(&v, 1);

		/* UIO I/O̎Mobt@Ƀf[^ȂA܂B */
		if(!retval) {
			break;
		}

		/* USB I/O̎MI[o[Ȃ΁AZbg܂B */
		if(retval < 0) {
			uio_reset();
			break;
		}

		/* "CLIENT"o`҂ȊOȂ΁A"CLIENT"opobt@փVtgC܂B */
		if(memcmp(slip.client, "CLIENT", 6) != 0) {
			memmove(&slip.client[0], &slip.client[1], 6 - 1);
			slip.client[5] = v;

			/* "CLIENT"oA"CLIENTSERVER"̑oJn݂܂B
			 * őoJnłȂ΁Aȍ~tx_isr()őoJn܂B
			 * * MpPbgɋR܂܂ꂽ"CLIENT"ɑ΂ĂA"CLIENTSERVER"Ă܂܂A肠܂B
			 *   ȎMt[̏I[END($C0)ƁȂMt[̐擪END($C0)ɋ܂ꂽt[Ƃĉ߂A
			 *   MɂSLIPt[IPpPbgWJAsIPwb_G[pPbgƂĔj͂łB
			 */
			if(memcmp(slip.client, "CLIENT", 6) == 0) {
				tx_sub();
				/* oJnłꍇɂ́Atx_sub()ɂ"CLIENT"oNA܂B */
			}
		}

		switch(slip.rxphase) {
		case SLIP_IDLE:
			/* ʏԂֈڍs܂B */
			slip.rxphase = SLIP_RX_NORMAL;
			slip.rxlen = 0; /* Kv */
			/* FALLTHRU */
		case SLIP_RX_NORMAL:
			switch(v) {
			case 0xc0:
				/* END($C0)Ȃ΁AIPf[^Ő؂łB */
				if(slip.rxlen) {
					/* MԂֈڍs܂B */
					slip.rxphase = SLIP_RX_DONE;
					/* MpPbgJEgAbv܂B */
					slip.rxlog++;
				} else {
					/* pPbgȂ΁AɃAChԂ֖߂܂B */
					slip.rxphase = SLIP_IDLE;
				}
				break;
			case 0xdb:
				/* ESC($DB)Ȃ΁AGXP[vԂֈڍs܂B */
				slip.rxphase = SLIP_RX_ESCAPE;
				break;
			default:
				/* Mobt@֊i[܂B */
				if(slip.rxlen < slip.mtu) {
					slip.rxbuf[slip.rxlen++] = v;
				}
				break;
			}
			break;
		case SLIP_RX_ESCAPE:
			switch(v) {
			case 0xdc:
				/* $DB,$DC -> $C0 */
				if(slip.rxlen < slip.mtu) {
					slip.rxbuf[slip.rxlen++] = 0xc0;
				}
				break;
			case 0xdd:
				/* $DB,$DD -> $DB */
				if(slip.rxlen < slip.mtu) {
					slip.rxbuf[slip.rxlen++] = 0xdb;
				}
				break;
			default:
				/* L蓾ȂoCgтłBł͒Pɖ܂B
				 * ʃCɂāAG[pPbgƔf͂łB
				 */
				break;
			}
			/* ʏԂ֖߂܂B */
			slip.rxphase = SLIP_RX_NORMAL;
			break;
		}
	}
}

static void
tx_sub()
{
	int retval;
	unsigned char v;

L_REDO:

	/* MpPbgȂ邩A܂́AIɃ[v𔲂܂... */
	while(slip.txphase != SLIP_IDLE) {

		switch(slip.txphase) {
		case SLIP_TX_CLIENTSERVER:
			/* "CLIENTSERVER"𑗏o܂B */
			v = "CLIENTSERVER"[slip.txlen];
			retval = uio_send(&v, 1);
			/* USB I/ȎMobt@ɋ󂫂΁A܂B */
			if(!retval) {
				goto L_EXIT;
			}
			/* ̑oʒui߂܂B */
			slip.txlen++;
			/* "CLIENTSERVER"𑗏oAAChԂ֖߂܂B */
			if(slip.txlen == 12) {
				slip.txphase = SLIP_IDLE;
				/* "CLIENT""CLIENTSERVER"nhVFCN񐔂JEgAbv܂B */
				slip.cslog++;
			}
			break;

		case SLIP_TX_START:
			/* 擪END($C0)𑗏o܂B */
			v = 0xc0;
			retval = uio_send(&v, 1);
			/* USB I/ȎMobt@ɋ󂫂΁A܂B */
			if(!retval) {
				goto L_EXIT;
			}
			/* ʏԂֈڍs܂B */
			slip.txphase = SLIP_TX_NORMAL;
			break;

		case SLIP_TX_NORMAL:
			if(slip.txlen < slip.mtu) {
				/* ̑oLN^擾܂B */
				v = slip.txbuf[slip.txlen];
				switch(v) {
				case 0xc0:
				case 0xdb:
					/* ESC($DB)𑗏o܂B */
					v = 0xdb;
					retval = uio_send(&v, 1);
					/* USB I/ȎMobt@ɋ󂫂΁A܂B */
					if(!retval) {
						goto L_EXIT;
					}
					/* GXP[vԂֈڍs܂B(oʒu͂̂܂) */
					slip.txphase = SLIP_TX_ESCAPE;
					break;
				default:
					/* USB I/O֑o܂B */
					retval = uio_send(&v, 1);
					/* USB I/ȎMobt@ɋ󂫂΁A܂B */
					if(!retval) {
						goto L_EXIT;
					}
					/* ̑oʒui߂܂B */
					slip.txlen++;
					break;
				}
			} else {
				/* I[END($C0)𑗏o܂B */
				v = 0xc0;
				retval = uio_send(&v, 1);
				/* USB I/ȎMobt@ɋ󂫂΁A܂B */
				if(!retval) {
					goto L_EXIT;
				}
				/* AChԂ֖߂܂B */
				slip.txphase = SLIP_IDLE;
				/* MpPbgJEgAbv܂B */
				slip.txlog++;
			}
			break;

		case SLIP_TX_ESCAPE:
			/* ESC($DB)̌㑱LN^肵܂B */
			v = slip.txbuf[slip.txlen];
			switch(v) {
			case 0xc0:
				/* $C0 -> $DB,$DC */
				v = 0xdc;
				break;
			case 0xdb:
				/* $DB -> $DB,$DD */
				v = 0xdd;
				break;
			}
			/* USB I/O֑o܂B */
			retval = uio_send(&v, 1);
			/* USB I/ȎMobt@ɋ󂫂΁A܂B */
			if(!retval) {
				goto L_EXIT;
			}
			/* ʏԂ֖߂܂B */
			slip.txphase = SLIP_TX_NORMAL;
			/* ̑oʒui߂܂B */
			slip.txlen++;
			break;
		}
	}

L_EXIT:

	/* MpPbg... */
	if(slip.txphase == SLIP_IDLE) {

		/* "CLIENT"oĂA"CLIENTSERVER"Ԃֈڍs܂B */
		if(memcmp(slip.client, "CLIENT", 6) == 0) {
			memset(slip.client, 0, 6); /* "CLIENT"oNA */
			slip.txphase = SLIP_TX_CLIENTSERVER;
			slip.txlen = 0; /* 0`11ڂ܂őA12Ŋ */
			goto L_REDO;
		}
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

void
slip_start(int mtu/*=1006*/, void (*rxdone)(), void (*txdone)())
{
	/* ܂Amɐؒf܂B */
	slip_stop();

	/* MTUȗĂAlƂ܂B */
	if(!mtu) {
		mtu = 1006; /* RFC 1055 */
	}

	/* hCo\̂܂B */
	memset(&slip, 0, sizeof slip);
	//
	slip.mtu = mtu;
	slip.rxbuf = malloc(mtu);
	if(!slip.rxbuf) {
		DIE();
	}
	slip.rxdone = rxdone;
	//
	slip.txbuf = malloc(mtu);
	if(!slip.txbuf) {
		DIE();
	}
	slip.txdone = txdone;

	/* USB I/OJn܂B */
	uio_start(0/*lgpA*/, 0/*lgpA*/, rx_isr, tx_isr);
}

void
slip_stop()
{
	/* USB I/Oؒf܂B */
	uio_stop();

	/* Mobt@J܂B */
	free(slip.rxbuf); /* free(NULL)͈S */

	/* Mobt@J܂B */
	free(slip.txbuf); /* free(NULL)͈S */

	/* hCo\̂NA܂B */
	memset(&slip, 0, sizeof slip);
}

int
slip_recv(void* dat/*[len]*/, int len)
{
ENTER_CS;
	/* MpPbgĂȂ... */
	if(slip.rxphase != SLIP_RX_DONE) {
		/* MpPbg݂̊܂B */
		rx_sub();

		/* łȂ΁A܂B */
		if(slip.rxphase != SLIP_RX_DONE) {
			len = 0;
		}
	}
	if(len) {
		/* MpPbgǂݏo܂B */
		if(len > slip.rxlen) {
			len = slip.rxlen;
		}
		memcpy(dat, slip.rxbuf, len);

		/* AChԂ֖߂܂B */
		slip.rxphase = SLIP_IDLE;
	}
LEAVE_CS;
	return len;
}

int
slip_send(const void* dat/*[len]*/, int len)
{
ENTER_CS;
	/* MpPbgcĂA */
	if(slip.txphase != SLIP_IDLE) {
		/* MpPbg̑o݂܂B */
		tx_sub();

		/* łcĂA܂B */
		if(slip.txphase != SLIP_IDLE) {
			len = 0;
		}
	}
	if(len) {
		/* MpPbgi[܂B */
		if(len > slip.mtu) {
			len = slip.mtu;
		}
		slip.txlen = slip.mtu - len; /* l */
		memcpy(&slip.txbuf[slip.txlen], dat, len);

		/* 擪$C0o҂Ԃֈڍs܂B */
		slip.txphase = SLIP_TX_START;

		/* MpPbg̑oJn݂܂B
		 * őoJnłȂ΁Aȍ~tx_isr()őoJn܂B
		 */
		tx_sub();
	}
LEAVE_CS;
	return len;
}

void
slip_stat(SLIPSTAT* stat)
{
ENTER_CS;

	stat->cslog = slip.cslog;
	stat->rxlog = slip.rxlog;
	stat->txlog = slip.txlog;

LEAVE_CS;
}

