/*	
 *	clipn2.h
 *
 *	P/ECE YM2612(OPN2) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Dec 05 03:03:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_N2_H__
#define __CLIP_N2_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *
 ****************************************************************************/

/* YM2612_ASMV{`ǂݍ݂܂B
 * YM2612_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipn2a.h"

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef YM2612_ASM
#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _YM2612OP YM2612OP;
typedef struct _YM2612CH YM2612CH;
typedef struct _YM2612   YM2612  ;

extern const short ym2612op_pg_table[256]; /* t9bit */

/* YM2612OP.env */
typedef int YM2612OP_ENV(YM2612OP* op, int eg_cnt);
int ym2612op_env_attack(YM2612OP* op, int eg_cnt);
int ym2612op_env_decay(YM2612OP* op, int eg_cnt);
int ym2612op_env_sustain(YM2612OP* op, int eg_cnt);
int ym2612op_env_release(YM2612OP* op, int eg_cnt);
int ym2612op_env_silent(YM2612OP* op, int eg_cnt);

struct _YM2612OP {
	/* ɎgptB[h */
	YM2612OP_ENV* eg_env;		/* + 0, 4: ԂɉGx[v֐ */
	int eg_cnt;			/* + 4, 4: Gx[vJE^(0..127A16bit) */
	int eg_ar;			/* + 8, 4: A^bN[g	(0..127A16bit) */
	int eg_tl;			/* +12, 4: g[^x	(0..127A16bit) */
	int eg_dr;			/* +16, 4: fBPC[g	(0..127A16bit) */
	int eg_sl;			/* +20, 4: TXeBx	(0..127A16bit) */
	int eg_sr;			/* +24, 4: TXeB[g	(0..127A16bit) */
	int eg_rr;			/* +28, 4: [X[g	(0..127A16bit) */
	int pg_cnt;			/* +32, 4: tF[YJE^	(0..255A16bit) */
	int pg_spd;			/* +36, 4: tF[YXs[h	(0..255A16bit) */
	/* ɎgpȂtB[h (WX^ݒꎞۑp) */
	unsigned char mul;		/* +40, 1: MUL */
	unsigned char tl;		/* +41, 1: TL */
	unsigned char sl;		/* +42, 1: SL */
	unsigned char resv[1];		/* +43, 1: (\) */
};					/* =44 (dv!! 'add %r12,YM2612OP_SIZE'xXbgɓ邽߁A63ȉK{!!) */

/* YM2612CH.mix */
typedef void YM2612CH_MIX(YM2612CH* ch, int mixbuf[/*count*/], int count);
void ym2612ch_mix0(YM2612CH* ch, int mixbuf[/*count*/], int count);
void ym2612ch_mix1(YM2612CH* ch, int mixbuf[/*count*/], int count);
void ym2612ch_mix2(YM2612CH* ch, int mixbuf[/*count*/], int count);
void ym2612ch_mix3(YM2612CH* ch, int mixbuf[/*count*/], int count);
void ym2612ch_mix4(YM2612CH* ch, int mixbuf[/*count*/], int count);
void ym2612ch_mix5(YM2612CH* ch, int mixbuf[/*count*/], int count);
void ym2612ch_mix6(YM2612CH* ch, int mixbuf[/*count*/], int count);
void ym2612ch_mix7(YM2612CH* ch, int mixbuf[/*count*/], int count);
extern YM2612CH_MIX* const ym2612ch_mix_table[8];

struct _YM2612CH {
	/* ɎgptB[h */
	YM2612OP op[4];				/* +  0,44*4: Iy[^1..4 */
						/*            dv!! AZu̎AYM2612CH擪YM2612OPz񂪂邱Ƃz肵Ă܂B */
						/*                   YM2612OPz̈ʒuYM2612CH擪ړĂ͂܂!!                 */
	YM2612CH_MIX* mix;			/* +176,   4: ASYɉ~LVO֐ */
	int fb_in;				/* +180,   4: tB[hobN͒l (2Α) */
	unsigned char fb;			/* +184,   1: tB[hobN (0:Off,1:1/16,2:1/8,3:1/4,4:1/2,5:,6:2,7:4) */
	unsigned char lr;			/* +185,   1: p (bit0=R, bit1=L) */
	/* ɎgpȂtB[h (WX^ݒꎞۑp) */
	unsigned char f_number_lsb;		/* +186,   1: F-number[ 7..0] */
	unsigned char f_number_msb;		/* +187,   1: F-number[10..8] */
	unsigned char block;			/* +188,   1: Block */
	unsigned char resv2[3];			/* +189,   3: (\) */
};						/* =192 */

struct _YM2612 {
	int f_sam;				/* TvOg = }X^NbN(12~12) */
	int dac;				/* DAC (XP[OĂi[܂) */
	unsigned char dac_en;			/* DAC en (0=disable, 1=enable) */
	unsigned char ch3_mode;			/* Channel 3 has 4 separate frequency (0=Off, 1=On) */
	unsigned char ch3_f_number_lsb[3];	/* Ch3 F-number[ 7..0] ([0]=Op3, [1]=Op1, [2]=Op2) */
	unsigned char ch3_f_number_msb[3];	/* Ch3 F-number[10..8] ([0]=Op3, [1]=Op1, [2]=Op2) */
	unsigned char ch3_block[3];		/* Ch3 Block           ([0]=Op3, [1]=Op1, [2]=Op2) */
	unsigned char i_reg[2];			/* ރWX^I ([0]=Part I, [1]=Part II) */
	YM2612CH ch[2][3];			/* `l1..6 */
};

short* ym2612_copy(short* wbuff, const int* mixbuf, int count);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void ym2612_init(YM2612* ym2612, int f_m);
int ym2612_read(YM2612* ym2612, int addr);
void ym2612_write(YM2612* ym2612, int addr, int data);
void ym2612_mix(YM2612* ym2612, short wbuff[/*count*/], int count);

#define ym2612_write_reg(ym2612, i_part, i_reg, data) do {	\
	ym2612_write((ym2612), (i_part) * 2 + 0, (i_reg));	\
	ym2612_write((ym2612), (i_part) * 2 + 1, ( data));	\
} while(0)

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_N2_H__*/
