/*	
 *	clipmath.c
 *
 *	[eBeBFw֐
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Thu Dec 31 09:54:58 JST 2015 Naoyuki Sawa
 *	- 쐬JnB
 *	- math.hɂ͊܂܂ȂẂAw֐܂Ƃ߂邽߂̃W[łB
 *	  AW̐w֐ǉꍇ́AW[ɒǉĉB
 *	* Sat Mar 19 21:19:21 JST 2016 Naoyuki Sawa
 *	- determinant(),cofactor(),solve()ǉ܂B
 */
#include "clip.h"
/*****************************************************************************
 *	`
 *****************************************************************************/
#ifndef PIECE
double lerp(double x, double y, double s) {
    //{{ό`čœK܂B
    //	return (x * (1.0 - s)) + (y * s);	//Z~2,Z~2
    //ό`čœK܂B
	return x - (s * (x - y));		//Z~1,Z~2
    //}}ό`čœK܂B
}
#else //PIECE
double lerp(double x, double y, double s);
asm("
		.code
		.align		1
		.global		lerp
lerp:
		pushn		%r1
		;//%r12     := xl
		;//%r13     := xh
		;//%r14     := yl
		;//%r15     := yh
		;//[%sp+ 0] := %r0
		;//[%sp+ 4] := %r1
		;//[%sp+ 8] := retp
		;//[%sp+12] := sl
		;//[%sp+16] := sh
		ld.w		%r0, %r12		;//%r0       := xl
		xcall.d		__subdf3		;//%r11:%r10 :=          (x - y)
		ld.w		%r1, %r13		;//%r1       := xh			*delay*
		xld.w		%r12, [%sp+12]		;//%r12      :=      sl
		xld.w		%r13, [%sp+16]		;//%r13      :=      sh
		ld.w		%r14, %r10		;//%r14      :=          (x - y)l
		xcall.d		__muldf3		;//%r11:%r10 :=     (s * (x - y))
		ld.w		%r15, %r11		;//%r15      :=          (x - y)h	*delay*
		ld.w		%r12, %r0		;//%r12      := xl
		ld.w		%r13, %r1		;//%r13      := xh
		popn		%r1
		ld.w		%r14, %r10		;//%r14      :=     (s * (x - y))l
		xjp.d		__subdf3		;//%r11:%r10 := x - (s * (x - y))
		ld.w		%r15, %r11		;//%r15      :=     (s * (x - y))h	*delay*
");
#endif//PIECE
/*****************************************************************************
 *	A
 *****************************************************************************/
//matnf_determinant()APx˔{xɕύX֐łB
//gASÝAmatnf_determinant()ƓłB
//ڍׂ́Aclipflt1.cmatnf_determinant()̎QƂĉB
double determinant(const double* m/*[n][n]*/, int n) {
	int i;
	double d;
	if(n < 1) { DIE(); }
	//]qWJpāAs(determinant)߂܂B
	d = 0.0;
	for(i = 0; i < n; i++) {
		d += (m[(n * i) + 0/*j*/] * cofactor(m, n, i, 0/*j*/));
	}
	return d;
}
/*---------------------------------------------------------------------------*/
//matnf_cofactor()APx˔{xɕύX֐łB
//gASÝAmatnf_cofactor()ƓłB
//ڍׂ́Aclipflt1.cmatnf_cofactor()̎QƂĉB
double cofactor(const double* m/*[n][n]*/, int n, int i, int j) {
	int k, l;
	double d;
	double* s/*[n-1][n-1]*/;
	double* t/*[n-1][n-1]*/;
	if((n < 1) ||
	   (i < 0) || (i > (n - 1)) ||
	   (j < 0) || (j > (n - 1))) { DIE(); }
	//m[ns][n]isjAs(submatrix)쐬܂B
	if(n == 1) { return 1; } //s0s0ɂȂꍇ
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
	s = malloc(sizeof(double) * ((n - 1) * (n - 1)));
	if(!s) { DIE(); }
#else //!(defined(_WIN32)&&defined(_MT))
//Win32}`Xbh̏ꍇɗLȃubN
	s = alloca(sizeof(double) * ((n - 1) * (n - 1)));
#endif//!(defined(_WIN32)&&defined(_MT))
	t = s;
	for(k = 0; k < n; k++) {
		for(l = 0; l < n; l++) {
			if((k != i) && (l != j)) {
				*t++ = *m;
			}
			m++;
		}
	}
	//s(minor determinant)߂܂B
	d = determinant(s, (n - 1));
	//]q(cofactor)߂܂B
	if((i ^ j) & 1) { d = -d; }
	//s܂B
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
	free(s);
#endif//!(defined(_WIN32)&&defined(_MT))
	return d;
}
/*---------------------------------------------------------------------------*/
//solve_simultaneous_equations()APx˔{xɕύX֐łB
//gASÝAsolve_simultaneous_equations()ƓłB
//ڍׂ́Aclipflt1.csolve_simultaneous_equations()̎QƂĉB
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
double solve(const double* A/*[n][n]*/, const double* b/*[n]*/, double* x/*[n]*/, int n) {
	int i, j;
	double d;
	//s(determinant)߂܂B
	d = determinant(A, n);
	//ŇpāAA̋ts߂ȂAb|āAx߂܂B
	for(i = 0; i < n; i++) {
		x[i] = 0.0;
		for(j = 0; j < n; j++) {
			x[i] += (cofactor(A, n, j, i) / d) * b[j];
			//            !!~~~~
		}
	}
	//s񎮂Ԃ܂B
	return d;
}
#else //!(defined(_WIN32)&&defined(_MT))
//Win32}`Xbh̏ꍇɗLȃubN
struct _ST_solve {
	const double*		A/*[n][n]*/;	//solve()̈ƓłBsolve_start_routine()͎QƐpłBĂ͂܂B
	const double*		b/*[n]*/;	//
	double*			x/*[n]*/;	//
	int			n;		//
	double			d;		//solve()li[܂Bsolve_start_routine()͎QƐpłBĂ͂܂B
	volatile int		i;		//i0nBsolve_start_routine()ǂݏ܂Biǂݏ鎞csbNĉB
	CRITICAL_SECTION 	cs;		//
};
static unsigned __stdcall solve_start_routine(void* _arg) {
	struct _ST_solve* arg = _arg;
	const double* const A = arg->A;
	const double* const b = arg->b;
	double*       const x = arg->x;
	int           const n = arg->n;
	double        const d = arg->d;
	for(;;) {
		int i, j;
	    EnterCriticalSection(&arg->cs);	//{{arg->i̓ǂݏ:
		i = arg->i;
		if(i != n) { arg->i = (i + 1); }
	    LeaveCriticalSection(&arg->cs);	//}}arg->i̓ǂݏ:܂
		if(i == n) { break; }
		x[i] = 0.0;
		for(j = 0; j < n; j++) {
			x[i] += (cofactor(A, n, j, i) / d) * b[j];
			//            !!~~~~
		}
	}
	return 0;
}
double solve(const double* A/*[n][n]*/, const double* b/*[n]*/, double* x/*[n]*/, int n) {
	struct _ST_solve arg;
	HANDLE hThread[16/**/];	//֐쐬Xbh̐͂̔zTCYƂȂB2016/03/19݂16XbhƂB16RAȏCPUʓIɂȂꍇ͂̔zTCY𑝂₹B
	int nThread, iThread;
	SYSTEM_INFO si;
	//\̂B
	arg.A = A;
	arg.b = b;
	arg.x = x;
	arg.n = n;
	arg.d = determinant(A, n);	//s(determinant)߂܂B
	arg.i = 0;
	//NeBJZNV쐬B
	InitializeCriticalSection(&arg.cs);
	//Xbh߂邽߂ɁACPU̘_RA擾B
	GetSystemInfo(&si);
	nThread = si.dwNumberOfProcessors;
	//CPU̘_RAAhThread[]z̃TCYꍇ́A؂l߂B
	if(nThread > ARRAY_SIZE(hThread)) { nThread = ARRAY_SIZE(hThread); }
	//CPU̘_RAAz̎ꍇ́A؂l߂B
	// - z̎葽Xbh𐶐ĂA͖薳AȂXbhĖʂłB
	if(nThread > n) { nThread = n; }
	//Xbh쐬B
	for(iThread = 0; iThread < nThread; iThread++) {
		hThread[iThread] = (HANDLE)_beginthreadex(NULL,
			0,
			solve_start_routine,
			&arg,
			0,
			NULL);
		if(!hThread[iThread]) { DIE(); }	//oO,,\[Xs
	}
	//Xbh̊҂B
	iThread = WaitForMultipleObjects(nThread, hThread, TRUE, INFINITE);
	if((unsigned)(iThread - WAIT_OBJECT_0) >= (unsigned)nThread) { DIE(); }	//oO
	//XbhJB
	for(iThread = 0; iThread < nThread; iThread++) {
		if(!CloseHandle(hThread[iThread])) { DIE(); }	//oO
	}
	//NeBJZNV폜B
	DeleteCriticalSection(&arg.cs);	//YȂ!!
	//s񎮂Ԃ܂B
	return arg.d;
}
#endif//!(defined(_WIN32)&&defined(_MT))
