/*	
 *	clipemu.c
 *
 *	G~[^pTu[`WB
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Thu Dec 25 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Mar 15 12:30:00 JST 2004 Naoyuki Sawa
 *	- ZipWJAIWiZlibCuZlib/Zip݊CuɕύX܂B
 *	  ZipWJɈꎞIɊmۂƗpTCYA35KB5KBxɌ܂B
 *	* Sun Dec 19 20:21:00 JST 2004 Naoyuki Sawa
 *	- clippzlW[̖̕ύX(=>W[clipzipB֐A\̖ύX)ɔA
 *	  ZipWJ֐Ăяoƍ\̖C܂B
 *	  clipemuW[g̖{IȕύX͂܂B
 */
#include "clip.h"

/* ܂܂eXgĂ܂BSĂ܂B */

/****************************************************************************
 *	LN^`
 ****************************************************************************/

static void
render_gfx_8x8(RENDER* render, const GFX* gfx, int dx, int dy, int code, int palette, int param)
{
	SURFACE* surface = render->surface;
	int planes = gfx->planes;
	const unsigned char** plane_address = (const unsigned char**)gfx->plane_address;
	//
	unsigned char* dst;
	const unsigned char* src[GFX_MAX_PLANES];
	//
	int i, x, y, offset;
	unsigned char pixel[8];
	unsigned char plane[GFX_MAX_PLANES];

	/* T[tFX̎n_AhX߂܂B */
	offset = surface->w * dy + dx;
	dst = surface->vbuff + offset;

	/* LN^̃v[AhX߂܂B
	 * v[#0rbg0Av[#(planes-1)rbg(planes-1)ɍ邽߂ɁA
	 * 炩߃v[AhX̔zтtɂĂ܂B
	 * v[Aɏv[قǏʃrbgɃVtg邩łB
	 */
	if(!(param & GFX_REVY)) {
		offset = code * 8;	/* C0`7̏ɕ` */
	} else {
		offset = code * 8 + 7;	/* C7`0̏ɕ` */
	}
	for(i = 0; i < planes; i++) {
		src[i] = plane_address[(planes - 1) - i] + offset;
	}

	/* v[A`揈B */
	palette <<= planes;
	for(y = 0; y < 8; y++) {
		/* Cf[^擾B */
		for(i = 0; i < planes; i++) {
			if(!(param & GFX_REVY)) {
				plane[i] = *src[i]++;	/* C0`7̏ɕ` */
			} else {
				plane[i] = *src[i]--;	/* C7`0̏ɕ` */
			}
		}

		/* NbsOB */
		if(param & GFX_CLIPY) {
			if(dy + y < render->top || dy + y >= render->bottom) {
				dst += surface->w;
				continue;	/* ̃CցB */
			}
		}

		/* sNZ`B */
		for(x = 0; x < 8; x++, dst++) {
			/* v[B */
			pixel[x] = 0;
			for(i = 0; i < planes; i++) {
				if(!(param & GFX_REVX)) {
					pixel[x] <<= 1;
					pixel[x] |= plane[i] >> 7 & 1;	/* rbg7`0̏ɕ` */
					plane[i] <<= 1;
				} else {
					pixel[x] <<= 1;
					pixel[x] |= plane[i] & 1;	/* rbg0`7̏ɕ` */
					plane[i] >>= 1;
				}
			}

			/* NbsOB */
			if(param & GFX_CLIPX) {
				if(dx + x < render->left || dx + x >= render->right) {
					continue;
				}
			}

			/* ߐFH */
			if(param & GFX_TRANSPARENT) {
				if(!pixel[x]) {
					continue;
				}
			}

			/* `B */
			*dst = palette | pixel[x];
		}
		dst += surface->w - 8;	/* ̃CցB */
	}
}

void
render_gfx(RENDER* render, const GFX* gfx, int dx, int dy, int code, int palette, int param)
{
	int w = gfx->width;
	int h = gfx->height;
	//
	int x1 = dx;
	int x2 = dx + w;
	int y1 = dy;
	int y2 = dy + h;

	/* 1v[1sNZ1rbgȊO͖ΉłB */
	if(gfx->bits != 1) DIE();

	/* ܂ȃNbsOs܂B */
	if(x2 <= render->left  ) return; /* SɉʊO() */
	if(x1 >= render->right ) return; /* SɉʊO(E) */
	if(y2 <= render->top   ) return; /* SɉʊO() */
	if(y1 >= render->bottom) return; /* SɉʊO() */

	/* ȂƂꕔʓłBNbsO̗vorsv𔻒f܂B */
	if(x1 < render->left || x2 > render->right ) param |= GFX_CLIPX; /* vNbsO */
	if(y1 < render->top  || y2 > render->bottom) param |= GFX_CLIPY; /* vNbsO */

	/* LN^TCYɑΉ郋[`Ăяo܂B */
	switch(w | h << 8) {
	case 0x0808:
		render_gfx_8x8(render, gfx, dx, dy, code, palette, param);
		break;
	default:
		DIE();
	}
}

/****************************************************************************
 *	J[bNAbv
 ****************************************************************************/

void
clut_init(unsigned clut[/*count*/], int count)
{
	/* OCXP[ɏAg(=vXV)h}[N܂B */
	int i, v;
	for(i = 0; i < count; i++) {
		v = 0xff * i / (count - 1); /* count>=2K{ */
		clut[i] = v | v << 8 | v << 16 | 0xff << 24;
	}
}

void
clut_set_b(unsigned clut[], int i, unsigned char v)
{
	unsigned char* p = (unsigned char*)(clut + i);
	if(p[0] != v) {
		p[0] = v;
		p[3] = 0xff;
	}
}

void
clut_set_g(unsigned clut[], int i, unsigned char v)
{
	unsigned char* p = (unsigned char*)(clut + i);
	if(p[1] != v) {
		p[1] = v;
		p[3] = 0xff;
	}
}

void
clut_set_r(unsigned clut[], int i, unsigned char v)
{
	unsigned char* p = (unsigned char*)(clut + i);
	if(p[2] != v) {
		p[2] = v;
		p[3] = 0xff;
	}
}

void
clut_set_rgb(unsigned clut[], int i, int v)
{
	if((clut[i] & 0x00ffffff) != v) {
		clut[i] = 0xff000000 | v;
	}
}

int
clut_update(unsigned clut[/*count*/], int count)
{
	int result = 0;
	unsigned char* p = (unsigned char*)clut;
	while(count--) {
		if(p[3] == 0xff) {
			p[3] = (p[2] * 5 + p[1] * 8 + p[0] * 3) >> 10 ^ 3;
			//     -------------------------------+ ----+ --+
			//                                    |     |   +- Px]
			//                                    |     +----- 0`3ɕϊ
			//                                    +----------- R:G:B5:8:3
			result++; /* XVGgJEgAbv */
		}
		p += 4;
	}
	return result;
}

void
render_clut(RENDER* render, const unsigned clut[], int x, int y, int w, int h)
{
	SURFACE* surface;
	unsigned char* p;
	int n;

	/*{{render_rectangle_fill()Rs[ĎĂ܂*/

	/* T[tFCXoĂ܂B */
	surface = render->surface;

	/* K܂B(`Ě`) */
	if(w < 0) { x += w; w = -w; }
	if(h < 0) { y += h; h = -h; }

	/* NbsO܂B */
	if(x < render->left) {
		n = render->left - x; /* ɂ͂ݏosNZ */
		x = render->left;
		w -= n;
	}
	if(x + w > render->right) {
		w = render->right - x;
	}
	if(w <= 0) return; /* ʊO */
	if(y < render->top) {
		n = render->top - y; /* ɂ͂ݏosNZ */
		y = render->top;
		h -= n;
	}
	if(y + h > render->bottom) {
		h = render->bottom - y;
	}
	if(h <= 0) return; /* ʊO */

	/*}}render_rectangle_fill()Rs[ĎĂ܂*/

	/* ẅ̃J[bNAbvsB */
	p = &surface->vbuff[surface->w * y + x];
	for(y = 0; y < h; y++, p += surface->w - w) {
		for(x = 0; x < w; x++, p++) {
			*p = ((unsigned char*)&clut[*p])[3];
		}
	}
}

/****************************************************************************
 *	ROMZbgt@C
 ****************************************************************************/

int
rom_load(const char* fname, const ROM* rom, int count, unsigned char* mem)
{
	int retval, size, i;
	const void* romp;
	ZIP zip;
	ZIPDIR dir;

	/* Zipt@CJ܂B(Closesvł) */
	romp = mmap(fname, &size, 1/*Defrag*/);
	if(!romp) return -1; /* Zipt@CȂ */
	retval = zip_init(&zip, romp, size);
	if(retval < 0) return retval; /* sZipt@C */

	/* et@CWJ܂B */
	for(i = 0; i < count; i++, rom++) {
		/* t@C擾܂B */
		retval = zip_find(&zip, rom->name, &dir);
		if(retval < 0) return retval; /* t@C񂪌Ȃ */
		if(dir.uncompressed_size != rom->size) return -1; /* TCYsv */
		if(dir.crc32 != rom->crc) return -1; /* CRCsv */

		/* t@CWJ܂B */
		retval = zip_uncompress(&zip, rom->name, &mem[rom->base], rom->size);
		if(retval < 0) return retval; /* WJs */
	}

	return 0;
}

