/*
 *	game.c
 *
 *	2Fuseǂ
 *
 *	* Wed Aug 09 21:35:35 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"
//*****************************************************************************
//	
//*****************************************************************************
//ST_Game.stat
#define GAME_STAT_READY		0				//Q[JnO		SELECT1
#define GAME_STAT_SELECT1	1				//ڑI		SELECT2,GAMEOVER
#define GAME_STAT_SELECT2	2				//ڑI		SELECT1,MISS,GAMEOVER
#define GAME_STAT_MISS		3				//~Xhꒆ		SELECT1,GAMEOVER
#define GAME_STAT_GAMEOVER	4				//Q[I[o[
//-----------------------------------------------------------------------------
//ST_Cell.stat
#define CELL_STAT_WIRE		1				//C[t[o
#define CELL_STAT_APPEAR	2				//o
#define CELL_STAT_NORMAL	3				//ʏ
#define CELL_STAT_SELECT	4				//I
#define CELL_STAT_CHANGE	5				//ω
#define CELL_STAT_MISS		6				//~Xhꒆ
//ST_Cell.panel_color
//#define PANEL_COLOR_A		0				//	pl̃ACe=pl̏oxȂB
//#define PANEL_COLOR_B		1				//	pl̃ACe=_{AbvB
//#define PANEL_COLOR_C		2				//	pl̃ACe=Ԃ̌肪xȂB
//ST_Cell.effect
#define EFFECT_S		1				//GtFNg
#define EFFECT_M		2				//GtFNg
#define EFFECT_L		3				//GtFNg
//-----------------------------------------------------------------------------
#define FIRE_CNT_DIV		4/**/			//ɃAj[VJE^̏
#define FIRE_MAX		(16*FIRE_CNT_DIV)		//̍őo
//-----------------------------------------------------------------------------
//ST_Game.game_time
#define GAME_TIME_MAX		SEC(60.0)			//Q[Ԃ̏l
#define GAME_TIME_WARN		SEC(5.0)			//xJnQ[
//ST_Game.item_time
#define ITEM_TIME_MAX		SEC(6.0)			//ACeʎԂ̏l
#define COMBO_TIME_MAX		SEC(1.5)			//R{pԂ̏l
//-----------------------------------------------------------------------------
#define FIELD_COLS		4				//tB[h
#define FIELD_ROWS		4				//tB[hs
//-----------------------------------------------------------------------------
#define WIRE_CNT_DIV		SEC(0.67)			//C[t[õJE^̏
//-----------------------------------------------------------------------------
#define READY_CNT_MAX		SEC(2.0)			//Q[JnOo
//-----------------------------------------------------------------------------
#define GAMEOVER_CNT_MAX	SEC(1.5)			//Q[I[o[o
#define GAMEOVER_CNT_MID	SEC(0.5)			//Q[I[o[oɃplW܂鎞
//-----------------------------------------------------------------------------
#define MISS_CNT_MAX		SEC(0.5)			//~Xo
//-----------------------------------------------------------------------------
#define EFFECT_S_CNT_MAX	SEC(0.4)			//GtFNgp
#define EFFECT_M_CNT_MAX	SEC(0.5)			//GtFNgp
#define EFFECT_L_CNT_MAX	SEC(0.5)			//GtFNgp
#define EFFECT_G_CNT_MAX	SEC(0.75)			//Q[I[o[GtFNgp
//*****************************************************************************
//	
//*****************************************************************************
typedef struct _ST_Cell {
	uint8_t		stat;					//	CELL_STAT_*
	uint8_t		panel_color;				//PANEL_COLOR_*
	uint8_t		panel_number;				//0=[P],1=[Q],2=[]
	uint8_t		cnt;					//ėpJE^
	uint8_t		effect;					//GtFNg	EFFECT_*
	uint8_t		effect_cnt;				//GtFNgJE^
	int		effect_seed;				//GtFNg̗V[h
} ST_Cell;
//-----------------------------------------------------------------------------
typedef struct _ST_Fire {
	uint8_t		stat;					//	0=,1=,2=(㉺]),3=E,4=E(㉺])
	 int8_t		x, y;					//W
	uint8_t		cnt;					//Aj[VJE^
} ST_Fire;
//-----------------------------------------------------------------------------
typedef struct _ST_Game {
	int		stat;					//	GAME_STAT_*
	int		score;					//XRA
	int		score_disp;				//\XRA
	int		combo;					//R{
	int		combo_time;				//R{pc莞
	int		game_time;				//Q[c莞
	int		item_time[3];				//ACeʎc莞
	int		game_warn;				//xC^[o
	//
	int		cursor_col;				//J[\
	int		cursor_row;				//J[\s
	int		select_col;				//I
	int		select_row;				//Is
	//
	ST_Cell		TBL_Cell[FIELD_ROWS][FIELD_COLS];	//tB[h
	//--- ACeGtFNg ---
	//t[Aj[V
	int		frame_anm_cnt;				//t[Aj[VJE^
	//Aj[V
	ST_Fire		TBL_Fire[FIRE_MAX];			//
	//XAj[V
	int		ice_anm_cnt;				//XAj[VJE^
	//--- Q[JnOo ---
	int		ready_cnt;				//Q[JnOoJE^
	//--- ~Xo ---
	int		miss_cnt;				//~XoJE^
	//--- Q[I[o[o ---
	int		gameover_cnt;				//Q[I[o[oJE^
} ST_Game;
//*****************************************************************************
//	
//*****************************************************************************
ST_Game		stGame;
//*****************************************************************************
//	
//*****************************************************************************
const uint16_t TBL_ItemSpr[3]={
	SPR_ITEM_A_0,	//
	SPR_ITEM_B_0,	//
	SPR_ITEM_C_0,	//
};
//-----------------------------------------------------------------------------
const uint16_t TBL_WireSpr[7/*cnt/WIRE_CNT_DIV*/]={
	SPR_WIRE_A_0,	//4x4
	SPR_WIRE_B_0,	//6x6
	SPR_WIRE_C_0,	//8x8
	SPR_WIRE_D_0,	//10x10
	SPR_WIRE_E_0,	//12x12
	SPR_WIRE_F_0,	//14x14
	SPR_WIRE_G_0,	//16x16
};
//-----------------------------------------------------------------------------
const uint16_t TBL_PanelSmallSpr[3/*panel_color*/][3/*panel_number*/]={
	{SPR_PANEL_SMALL_A_1_0,SPR_PANEL_SMALL_A_2_0,SPR_PANEL_SMALL_A_S_0},
	{SPR_PANEL_SMALL_B_1_0,SPR_PANEL_SMALL_B_2_0,SPR_PANEL_SMALL_B_S_0},
	{SPR_PANEL_SMALL_C_1_0,SPR_PANEL_SMALL_C_2_0,SPR_PANEL_SMALL_C_S_0},
};
const uint16_t TBL_PanelNormalSpr[3/*panel_color*/][3/*panel_number*/]={
	{SPR_PANEL_NORMAL_A_1_0,SPR_PANEL_NORMAL_A_2_0,SPR_PANEL_NORMAL_A_S_0},
	{SPR_PANEL_NORMAL_B_1_0,SPR_PANEL_NORMAL_B_2_0,SPR_PANEL_NORMAL_B_S_0},
	{SPR_PANEL_NORMAL_C_1_0,SPR_PANEL_NORMAL_C_2_0,SPR_PANEL_NORMAL_C_S_0},
};
const uint16_t TBL_PanelSelectSpr[3/*panel_color*/][3/*panel_number*/]={
	{SPR_PANEL_SELECT_A_1_0,SPR_PANEL_SELECT_A_2_0,SPR_PANEL_SELECT_A_S_0},
	{SPR_PANEL_SELECT_B_1_0,SPR_PANEL_SELECT_B_2_0,SPR_PANEL_SELECT_B_S_0},
	{SPR_PANEL_SELECT_C_1_0,SPR_PANEL_SELECT_C_2_0,SPR_PANEL_SELECT_C_S_0},
};
//*****************************************************************************
//	
//*****************************************************************************
static void fnRenderCircle(int x, int y, int r, void* arg) {
	int c = rnd8((int*)arg) & 1;	//0`1					̐Fŕ`߂̃V[hłBPFŗǂꍇ͕͂svłB
	CbkQue_render_ellipse_fill(pCbkQue, PRI__EFFECT, &render, x - (r - 1), y - (r - 1), (r * 2) - 1, (r * 2) - 1, c);
}
static void fnRenderPolygon(const int xy[/*n*/][2/*x,y*/], int n/*3or4*/, void* arg) {
	VERTEX v[]={{xy[0][0],xy[0][1]},{xy[1][0],xy[1][1]},{xy[2][0],xy[2][1]},{xy[3][0],xy[3][1]}};
	CbkQue_render_polygon(pCbkQue, PRI__EFFECT, &render, v, n, (int)arg);
}
//*****************************************************************************
//	
//*****************************************************************************
void game_draw_ui() {
	//LOGO
	{
		CbkQue_sprite_draw(pCbkQue,
			PRI__LOGO,
			  X__LOGO,
			  Y__LOGO,
			 SPR_LOGO, 0);
	}
	//HI
	{
		CbkQue_render_font(pCbkQue,
			PRI__HI,
			&render,
			  X__HI__H,
			  Y__HI,
			'H',
			2,
			0);
		CbkQue_render_font(pCbkQue,
			PRI__HI,
			&render,
			  X__HI__I,
			  Y__HI,
			'i',
			2,
			0);
		CbkQue_render_printf(pCbkQue,
			PRI__HI,
			&render,
			  X__HI__SCORE,
			  Y__HI,
			2,
			2,
			"%06d", hi_score);
		CbkQue_render_printf(pCbkQue,
			PRI__HI,
			&render,
			  X__HI__SCORE,
			  Y__HI,
			2,
			1,
			"%6d", hi_score);
	}
	//1P
	{
		CbkQue_render_printf(pCbkQue,
			PRI__1P,
			&render,
			  X__1P__SCORE,
			  Y__1P,
			0,
			2,
			"%06d", stGame.score_disp);
		CbkQue_render_printf(pCbkQue,
			PRI__1P,
			&render,
			  X__1P__SCORE,
			  Y__1P,
			0,
			0,
			"%6d", stGame.score_disp);
	}
	//TIME
	{
		div_t d = div(stGame.game_time, FPS);
		int sec = d.quot;
		int csec = (d.rem * 100 + (FPS - 1)) / FPS;
		int w = (stGame.game_time * W__TIME__BAR + (GAME_TIME_MAX - 1)) / GAME_TIME_MAX;
		CbkQue_render_printf(pCbkQue,
			PRI__TIME,
			&render,
			  X__TIME__SEC,
			  Y__TIME,
			2,
			0,
			"%02d", sec);
		CbkQue_render_font(pCbkQue,
			PRI__TIME,
			&render,
			  X__TIME__COLON,
			  Y__TIME,
			':',
			2,
			0);
		CbkQue_render_printf(pCbkQue,
			PRI__TIME,
			&render,
			  X__TIME__CSEC,
			  Y__TIME,
			2,
			0,
			"%02d", csec);
		CbkQue_render_rectangle(pCbkQue,
			PRI__TIME,
			&render,
			  X__TIME__BAR - 1,
			  Y__TIME__BAR - 1,
			  W__TIME__BAR + 2,
			  H__TIME__BAR + 2,
			2);
		CbkQue_render_rectangle_fill(pCbkQue,
			PRI__TIME,
			&render,
			  X__TIME__BAR,
			  Y__TIME__BAR,
			  w,
			  H__TIME__BAR,
			0);
	}
	//COMBO
	{
		int x;
		if(stGame.combo >= 3) {
			CbkQue_render_string(pCbkQue,
				PRI__COMBO,
				&render,
				  X__COMBO__TITLE,
				  Y__COMBO__TITLE,
				"COMBO",
				2,
				1);
			if(stGame.combo <= 9) {
				x = X__COMBO__COUNT__1;
			} else if(stGame.combo <= 99) {
				x = X__COMBO__COUNT__2;
			} else {
				x = X__COMBO__COUNT__3;
			}
			CbkQue_render_printf(pCbkQue,
				PRI__COMBO,
				&render,
				  x,
				  Y__COMBO__COUNT,
				0,
				0,
				"%d", stGame.combo);
		}
	}
	//ITEM
	{
		int i, t, h, iSprNo;
		for(i = 0; i < 3; i++) {
			t = stGame.item_time[i];
			h = (t * H__ITEM + (ITEM_TIME_MAX - 1)) / ITEM_TIME_MAX;
			iSprNo = TBL_ItemSpr[i] + h;
			CbkQue_sprite_draw(pCbkQue,
				PRI__ITEM,
				  X__ITEM + W__ITEM * i,
				  Y__ITEM,
				iSprNo, 0);
		}
	}
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void game_draw_message() {
	//Q[JnOo
	{
		int x, y, c;
		if(stGame.ready_cnt < READY_CNT_MAX) {
			CbkQue_render_rectangle_shadow(pCbkQue,
				PRI__MESSAGE_BACK,
				&render,
				  X__MESSAGE_BACK,
				  Y__MESSAGE_BACK,
				  W__MESSAGE_BACK,
				  H__MESSAGE_BACK,
				((stGame.ready_cnt <                  SEC(0.1)/**/) ||
				 (stGame.ready_cnt >= READY_CNT_MAX - SEC(0.1)/**/)) ? 1 : 2, 3);
			x = easeOutIn_i(DISP_X, -60, stGame.ready_cnt, READY_CNT_MAX);
			y = Y__MESSAGE;
			CbkQue_render_string_framed(pCbkQue,
				PRI__MESSAGE,
				&render,
				x,
				y,
				"GET READY...",
				0,
				0x330);
			c = 2 - (stGame.ready_cnt / SEC(0.1));
			if(c >= 0) {
				CbkQue_render_rectangle_shadow(pCbkQue,
					PRI__FADE,
					&render,
					0,
					0,
					DISP_X,
					DISP_Y,
					c, 3);
			}
			stGame.ready_cnt++;
		}
	}
	//Q[I[o[o
	{
		if(stGame.gameover_cnt >= GAMEOVER_CNT_MID) {
			int x, y, c;
			x = (DISP_X - (5 * 9 + 1)) / 2;
			y = Y__MESSAGE;
			CbkQue_render_string_framed(pCbkQue,
				PRI__MESSAGE,
				&render,
				x,
				y,
				"TIME'S UP",
				0,
				0x330);
			c = 0;
			if(stGame.gameover_cnt >= GAMEOVER_CNT_MAX - SEC(0.3)) { c = 1; }
			if(stGame.gameover_cnt >= GAMEOVER_CNT_MAX - SEC(0.2)) { c = 2; }
			if(stGame.gameover_cnt >= GAMEOVER_CNT_MAX - SEC(0.1)) { c = 3; }
			if(c) {
				CbkQue_render_rectangle_shadow(pCbkQue,
					PRI__FADE,
					&render,
					0,
					0,
					DISP_X,
					DISP_Y,
					c, 3);
			}
		}
	}
	//Q[I[o[GtFNg
	{
		if((stGame.gameover_cnt >= GAMEOVER_CNT_MID) &&
		   (stGame.gameover_cnt <= GAMEOVER_CNT_MID + EFFECT_G_CNT_MAX)) {
			int c = (GAMEOVER_CNT_MID + EFFECT_G_CNT_MAX) - stGame.gameover_cnt;
			if(c < 3) {
				c = 2;
			} else if(c < 6) {
				c = 1;
			} else {
				c = 0;
			}
			EffAnm_RadLar(
				X__CELL + ((W__CELL * (FIELD_COLS - 1)) >> 1) + 11,	//x
				Y__CELL + ((H__CELL * (FIELD_ROWS - 1)) >> 1) + 11,	//y
				stGame.gameover_cnt - GAMEOVER_CNT_MID,			//t
				EFFECT_G_CNT_MAX,					//duration
	//			max(DISP_X,DISP_Y),					//screenSize
	/*߂ɒ*/	max(DISP_X,DISP_Y)/3,					//screenSize
				0,							//seed
				fnRenderPolygon,					//fnRenderPolygon
				(void*)c);						//arg
			if(stGame.gameover_cnt == GAMEOVER_CNT_MID) {
				//Q[I[o[GtFNg
				{
					TapLogCh_Play(pTapSeq,
						TapLogCh_Se3,
						SND_SE_GAMEOVER,
						1,
						0,
						0);
				}
			}
		}
	}
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void game_draw_item_effect() {
	//FRAME
	{
		static const uint8_t TBL_FrameAnmPtn[]={0,0,0,1,1,1,2,2,2,3,3,3,2,2,2,1,1,1};
		int iSprNo;
		//΃ACeLȂ΁c
		if(stGame.item_time[0]) {
			//t[Aj[V`悷B
			iSprNo = SPR_FRAME_B_0 + TBL_FrameAnmPtn[stGame.frame_anm_cnt];
			CbkQue_sprite_draw(pCbkQue,
				PRI__FRAME,
				  X__FRAME,
				  Y__FRAME,
				iSprNo, 0);
			//t[Aj[VJE^i߂B
			if(++stGame.frame_anm_cnt >= ARRAY_SIZE(TBL_FrameAnmPtn)) { stGame.frame_anm_cnt = 0; }
		//΃ACeȂ΁c
		} else {
			//t[Aj[VJE^ԈÂp^[wĂȂ΁c
			if(TBL_FrameAnmPtn[stGame.frame_anm_cnt]) {
				//t[Aj[V`悷B
				iSprNo = SPR_FRAME_B_0 + TBL_FrameAnmPtn[stGame.frame_anm_cnt];
				CbkQue_sprite_draw(pCbkQue,
					PRI__FRAME,
					  X__FRAME,
					  Y__FRAME,
					iSprNo, 0);
				//t[Aj[VJE^i߂B
				if(++stGame.frame_anm_cnt >= ARRAY_SIZE(TBL_FrameAnmPtn)) { stGame.frame_anm_cnt = 0; }
			//t[Aj[VJE^ԈÂp^[wĂc
			} else {
				//ʏt[`悷B
				iSprNo = SPR_FRAME_A;
				CbkQue_sprite_draw(pCbkQue,
					PRI__FRAME,
					  X__FRAME,
					  Y__FRAME,
					iSprNo, 0);
				//t[Aj[VJE^NAB
				stGame.frame_anm_cnt = 0;
			}
		}
	}
	//FIRE
	{
		int iFire;
		//ԃACeLȂ΁c
		if(stGame.item_time[1]) {
			//̋󂫂B
			for(iFire = 0; iFire < FIRE_MAX; iFire++) {
				ST_Fire* pFire = &stGame.TBL_Fire[iFire];
				//̋󂫂L΁c
				if(!pFire->stat) {
					//𐶐B
					pFire->stat = RND32_RANGE(seed, 1, 4 + 1);		//1=,2=(㉺]),3=E,4=E(㉺])
					if(pFire->stat <= 2) {					//1=,2=(㉺])
						pFire->x =      0 - RND32_RANGE(seed, 0, 16);
					} else {						//3=E,4=E(㉺])
						pFire->x = DISP_X + RND32_RANGE(seed, 0, 16);
					}
					pFire->y = RND32_RANGE(seed, Y__FIRE__MIN, Y__FIRE__MAX);
					pFire->cnt = 0;
					break;	//܂
				}
			}
		}
		//`悷B
		for(iFire = 0; iFire < FIRE_MAX; iFire++) {
			ST_Fire* pFire = &stGame.TBL_Fire[iFire];
			//oȂ΁c
			if(pFire->stat) {
				static const uint8_t TBL_Param[5]={0/*_~[*/,0,DRW_REVY,DRW_REVX,DRW_REVX|DRW_REVY};	//1=,2=(㉺]),3=E,4=E(㉺])
				int iSprNo = SPR_FIRE_0 + (pFire->cnt / FIRE_CNT_DIV);
				int iParam = TBL_Param[pFire->stat];
				CbkQue_sprite_draw(pCbkQue,
					PRI__FIRE,
					pFire->x,
					pFire->y,
					iSprNo, iParam);
				//ړB
				if(now & 1) {	//ړ鎖ɂBB
					if(pFire->stat <= 2) {
						pFire->x++;
					} else {
						pFire->x--;
					}
				}
				//Aj[Vp^[̖𒴂ẢB
				if(++pFire->cnt >= (16 * FIRE_CNT_DIV)) { pFire->stat = 0; }
			}
		}
	}
	//ICE
	{
		//ACeLȂ΁c
		if(stGame.item_time[2]) {
			//XAj[VJE^𑝂₷B
			if(stGame.ice_anm_cnt < 16) { stGame.ice_anm_cnt++; }
		//ACeȂ΁c
		} else {
			//XAj[VJE^炷B
			if(stGame.ice_anm_cnt) { stGame.ice_anm_cnt--; }
		}
		//XoȂ΁c
		if(stGame.ice_anm_cnt) {
			//X`B
			CbkQue_sprite_draw(pCbkQue,	//
				PRI__ICE,
				DISP_X - 1,
				stGame.ice_anm_cnt,
				 SPR_ICE, DRW_REVX);		//ĥ߂ɏ㑤Ɖł͍Etŕ`ɂB㑤͍E]㉺ʏA͍Eʏ㉺]ŕ`B
			CbkQue_sprite_draw(pCbkQue,	//
				PRI__ICE,
				0,
				DISP_Y - 1 - stGame.ice_anm_cnt,
				 SPR_ICE, DRW_REVY);
		}
	}
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void game_draw_cell() {
	//plAGtFNg
	{
		int col, row, x, y, iSprNo;
		for(row = 0; row < FIELD_ROWS; row++) {
			for(col = 0; col < FIELD_COLS; col++) {
				ST_Cell* pCell = &stGame.TBL_Cell[row][col];
				if(pCell->stat) {
					x = W__CELL * col;
					y = H__CELL * row;
					if(stGame.gameover_cnt) {
						x = X__CELL + lerp_i(x, (W__CELL * (FIELD_COLS - 1)) >> 1, stGame.gameover_cnt, GAMEOVER_CNT_MID);
						y = Y__CELL + lerp_i(y, (H__CELL * (FIELD_ROWS - 1)) >> 1, stGame.gameover_cnt, GAMEOVER_CNT_MID);
					} else {
						x = X__CELL + W__CELL * col;
						y = Y__CELL + H__CELL * row;
						if((pCell->stat == CELL_STAT_CHANGE) ||	//ω
						   (pCell->stat == CELL_STAT_SELECT) ||	//I
						   (pCell->stat == CELL_STAT_MISS  )) {	//~Xhꒆ
							CbkQue_sprite_draw(pCbkQue,
								PRI__SELECT,
								x,
								y,
								SPR_SELECT_0 + ((now >> 1) & 3), 0);
						}
						if(pCell->effect) {
							int tmp = pCell->effect_seed;
							switch(pCell->effect) {
							default:DIE();
							case EFFECT_S:
								{
									EffAnm_RadSma(
										x + 11,			//x
										y + 11,			//y
										pCell->effect_cnt,	//t
										EFFECT_S_CNT_MAX,	//duration
							//			max(DISP_X,DISP_Y),	//screenSize
							/*傫߂ɒ*/	max(DISP_X,DISP_Y)*2,	//screenSize
										tmp,			//seed
										fnRenderCircle,		//fnRenderCircle
										&tmp);			//arg			̐Fŕ`߂̃V[hłBPFŗǂꍇ͕͂svłB
									if(++pCell->effect_cnt > EFFECT_S_CNT_MAX) { pCell->effect = 0; }
								}
								break;
							case EFFECT_M:
								{
									EffAnm_RadMed(
										x + 11,			//x
										y + 11,			//y
										pCell->effect_cnt,	//t
										EFFECT_M_CNT_MAX,	//duration
										max(DISP_X,DISP_Y),	//screenSize
										tmp,			//seed
										fnRenderPolygon,	//fnRenderPolygon
										NULL);			//arg
									if(++pCell->effect_cnt > EFFECT_M_CNT_MAX) { pCell->effect = 0; }
								}
								break;
							case EFFECT_L:
								{
									EffAnm_RadBo2(
										x + 11,			//x
										y + 11,			//y
										pCell->effect_cnt,	//t
										EFFECT_L_CNT_MAX,	//duration
										max(DISP_X,DISP_Y),	//screenSize
										tmp,			//seed
										fnRenderPolygon,	//fnRenderPolygon
										NULL);			//arg
									if(++pCell->effect_cnt > EFFECT_L_CNT_MAX) { pCell->effect = 0; }
								}
								break;
							}
						}
					}
					if(stGame.gameover_cnt <= GAMEOVER_CNT_MID) {
						iSprNo = 0;
						if(stGame.game_time < GAME_TIME_WARN) {
							static const uint8_t TBL_PanelAnmPtn[]={0,1,2,1,0,3,4,3};
							int tmp = col + row * FIELD_COLS;
							tmp = RND32_RANGE(tmp, 0, ARRAY_SIZE(TBL_PanelAnmPtn));
							tmp += now;
							tmp %= ARRAY_SIZE(TBL_PanelAnmPtn);
							iSprNo = TBL_PanelAnmPtn[tmp];
						}
						switch(pCell->stat) {
						default:DIE();
						case CELL_STAT_WIRE:	//C[t[o
							{
								iSprNo += TBL_WireSpr[pCell->cnt / WIRE_CNT_DIV];
								CbkQue_sprite_draw(pCbkQue,
									PRI__CELL,
									x,
									y,
									iSprNo, 0);
							}
							break;
						case CELL_STAT_APPEAR:	//o
						case CELL_STAT_CHANGE:	//ω
							{
								iSprNo += TBL_PanelSmallSpr[pCell->panel_color][pCell->panel_number];
								CbkQue_sprite_draw(pCbkQue,
									PRI__CELL,
									x,
									y,
									iSprNo, 0);
							}
							break;
						case CELL_STAT_NORMAL:	//ʏ
							{
								iSprNo += TBL_PanelNormalSpr[pCell->panel_color][pCell->panel_number];
								CbkQue_sprite_draw(pCbkQue,
									PRI__CELL,
									x,
									y,
									iSprNo, 0);
							}
							break;
						case CELL_STAT_SELECT:	//I
							{
								iSprNo += TBL_PanelSelectSpr[pCell->panel_color][pCell->panel_number];
								CbkQue_sprite_draw(pCbkQue,
									PRI__CELL,
									x,
									y,
									iSprNo, 0);
							}
							break;
						case CELL_STAT_MISS:	//~Xhꒆ
							{
								x += RND32_RANGE(seed, -2, 2 + 1);
								y += RND32_RANGE(seed, -2, 2 + 1);
								iSprNo += TBL_PanelSmallSpr[pCell->panel_color][pCell->panel_number];
								CbkQue_sprite_draw(pCbkQue,
									PRI__CELL,
									x,
									y,
									iSprNo, 0);
							}
							break;
						}
					}
				}
			}
		}
	}
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void game_draw_cursor() {
	int i, x, y, iSprNo;
	//J[\
	{
		if((stGame.stat == GAME_STAT_SELECT1) ||
		   (stGame.stat == GAME_STAT_SELECT2)) {
			static const uint8_t TBL_CursorAnmPtn[]={0,0,1,1,2,2,1,1};
			x = X__CELL + (W__CELL * stGame.cursor_col);
			y = Y__CELL + (H__CELL * stGame.cursor_row);
			i = now % ARRAY_SIZE(TBL_CursorAnmPtn);
			iSprNo = SPR_CURSOR_0 + TBL_CursorAnmPtn[i];
			CbkQue_sprite_draw(pCbkQue,
				PRI__CURSOR,
				x,
				y,
				iSprNo, 0);
		}
	}
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void game_draw() {
	game_draw_ui();
	game_draw_message();
	game_draw_item_effect();
	game_draw_cell();
	game_draw_cursor();
}
//-----------------------------------------------------------------------------
void game_exec() {
	//R{
	{
		if( stGame.combo_time) { stGame.combo_time--; }
		if(!stGame.combo_time) { stGame.combo = 0; }
	}
	//ACe
	{
		if(stGame.item_time[0]) { stGame.item_time[0]--; }
		if(stGame.item_time[1]) { stGame.item_time[1]--; }
		if(stGame.item_time[2]) { stGame.item_time[2]--; }
	}
	//pl
	{
		if(stGame.stat != GAME_STAT_GAMEOVER) {
			int col, row;
			for(row = 0; row < FIELD_ROWS; row++) {
				for(col = 0; col < FIELD_COLS; col++) {
					ST_Cell* pCell = &stGame.TBL_Cell[row][col];
					if(pCell->stat) {
						switch(pCell->stat) {
						default:DIE();
						case CELL_STAT_WIRE:	//C[t[o
							{
								if(stGame.item_time[0]) { pCell->cnt = (WIRE_CNT_DIV * 7) - 1; }	//łɃC[̃pl鎞ɗ΃ACe瑦C[B(1t[xꂾڏ͖薳낤)
								if(++pCell->cnt >= (WIRE_CNT_DIV * 7)) {
									pCell->stat = CELL_STAT_APPEAR;
									pCell->panel_color = RND32_RANGE(seed, 0, 3);
									pCell->panel_number = 0;
									pCell->cnt = 0;
								}
							}
							break;
						case CELL_STAT_APPEAR:	//o
							{
								if(++pCell->cnt >= 4/**/) {
									pCell->stat = CELL_STAT_NORMAL;
									pCell->cnt = 0;
								}
							}
							break;
						case CELL_STAT_NORMAL:	//ʏ
							{
								/** no job **/
							}
							break;
						case CELL_STAT_SELECT:	//I
							{
								/** no job **/
							}
							break;
						case CELL_STAT_CHANGE:	//ω
							{
								if(++pCell->cnt >= 4/**/) {
									pCell->stat = CELL_STAT_NORMAL;
									pCell->cnt = 0;
								}
							}
							break;
						case CELL_STAT_MISS:	//~Xhꒆ
							{
								/** no job **/
							}
							break;
						}
					}
				}
			}
		}
	}
	//
	{
		switch(stGame.stat) {
		case GAME_STAT_SELECT1:		//ڑI
		case GAME_STAT_SELECT2:		//ڑI
			if(joy & TRG_LRUD) {
				if(joy & TRG_LF) {
					if(--stGame.cursor_col < 0) { stGame.cursor_col = FIELD_COLS - 1; }
				} else if(joy & TRG_RI) {
					if(++stGame.cursor_col > FIELD_COLS - 1) { stGame.cursor_col = 0; }
				}
				if(joy & TRG_UP) {
					if(--stGame.cursor_row < 0) { stGame.cursor_row = FIELD_ROWS - 1; }
				} else if(joy & TRG_DN) {
					if(++stGame.cursor_row > FIELD_ROWS - 1) { stGame.cursor_row = 0; }
				}
				//J[\ړ
				{
					TapLogCh_Play(pTapSeq,
						TapLogCh_Se1,
						SND_SE_CURSOR,
						1,
						0,
						0);
				}
			}
			break;
		}
		switch(stGame.stat) {
		default:DIE();
		case GAME_STAT_READY:		//Q[JnO
			/** no job **/
			break;
		case GAME_STAT_SELECT1:		//ڑI
			if(joy & TRG_A) {
				ST_Cell* pCell = &stGame.TBL_Cell[stGame.cursor_row][stGame.cursor_col];
				if((pCell->stat == CELL_STAT_NORMAL) ||
				   (pCell->stat == CELL_STAT_CHANGE)) {
					pCell->stat = CELL_STAT_SELECT;
					pCell->cnt = 0;
					stGame.stat = GAME_STAT_SELECT2;
					stGame.select_col = stGame.cursor_col;
					stGame.select_row = stGame.cursor_row;
					//ڑI
					{
						PlayMusic(music_table[MUS_NOTE0]);
					}
				} else {
					//yieB̒Zx
					{
						TapLogCh_Play(pTapSeq,
							TapLogCh_Se2,
							SND_SE_ERROR,
							1,
							0,
							0);
					}
				}
			}
			break;
		case GAME_STAT_SELECT2:		//ڑI
			if(joy & TRG_A) {
				ST_Cell* pCell1 = &stGame.TBL_Cell[stGame.cursor_row][stGame.cursor_col];
				ST_Cell* pCell2 = &stGame.TBL_Cell[stGame.select_row][stGame.select_col];
				if((pCell1->stat == CELL_STAT_NORMAL) ||
				   (pCell1->stat == CELL_STAT_CHANGE)) {
					if((pCell1->panel_color  == pCell2->panel_color ) &&
					   (pCell1->panel_number == pCell2->panel_number)) {
						stGame.combo++;
						stGame.combo_time = COMBO_TIME_MAX;
						{
							//{2fuse̓_VXeƂ悭킩Ȃ̂ŁA^ɒPȓ_VXeɂ܂B
							int point = (pCell1->panel_color + stGame.combo);	//combo=1[P]=1,[Q]=2,[]=3Acombo=2[P]=2,[Q]=3,[]=4Acombo=3[P]=3,[Q]=4,[]=5Ac
							if(stGame.item_time[1]) { point *= 2; }		//{̐ԃACe(ACe̕\Ƃ͗)2{ł͂Ȃ悤łAł͔₷2{ɂ܂B
							stGame.score += (point * 10);
						}
						//ڑI
						{
							static const uint16_t TBL_Note[]={
								MUS_NOTE1,	//1R{
								MUS_NOTE2,	//2R{
								MUS_NOTE3,	//3R{
								MUS_NOTE4,	//4R{
								MUS_NOTE5,	//5R{
								MUS_NOTE6,	//6R{
								MUS_NOTE7,	//7R{
								MUS_NOTE8,	//8R{
								MUS_NOTE9,	//9R{
								MUS_NOTE10,	//10R{ȏ
							};
							int i = stGame.combo - 1/*YȂ!!*/;
							if(i >= ARRAY_SIZE(TBL_Note)) { i = ARRAY_SIZE(TBL_Note) - 1; }
							PlayMusic(music_table[TBL_Note[i]]);
						}
						if(pCell1->panel_number < 2) {	//l
							pCell1->stat = CELL_STAT_CHANGE;
							pCell1->panel_number++;
							pCell1->cnt = 0;
							if(stGame.combo >= 3) {	//R{GtFNg3B2ł(Iɂ̓R{)GtFNg͕\ȂB
								pCell1->effect = EFFECT_M;
								pCell1->effect_cnt = 0;
								pCell1->effect_seed = RND32(seed);
								//R{GtFNg
								{
									TapLogCh_Play(pTapSeq,
										TapLogCh_Se3,
										SND_SE_COMBO,
										1,
										0,
										0);
								}
							}
						} else {	//
							stGame.item_time[pCell1->panel_color] = ITEM_TIME_MAX;
							if(stGame.item_time[0]) {
								pCell1->stat = CELL_STAT_APPEAR;
								pCell1->panel_color = RND32_RANGE(seed, 0, 3);
								pCell1->panel_number = 0;
								pCell1->cnt = 0;
							} else {
								pCell1->stat = CELL_STAT_WIRE;
								pCell1->cnt = 0;
							}
							pCell1->effect = EFFECT_L;
							pCell1->effect_cnt = 0;
							pCell1->effect_seed = RND32(seed);
							//ACeʔ
							{
								TapLogCh_Play(pTapSeq,
									TapLogCh_Se3,
									SND_SE_ITEM,
									1,
									0,
									0);
							}
						}
						if(stGame.item_time[0]) {
							pCell2->stat = CELL_STAT_APPEAR;
							pCell2->panel_color = RND32_RANGE(seed, 0, 3);
							pCell2->panel_number = 0;
							pCell2->cnt = 0;
						} else {
							pCell2->stat = CELL_STAT_WIRE;
							pCell2->cnt = 0;
						}
						pCell2->effect = EFFECT_S;
						pCell2->effect_cnt = 0;
						pCell2->effect_seed = RND32(seed);
						stGame.stat = GAME_STAT_SELECT1;
					} else {
						pCell1->stat = CELL_STAT_MISS;
						pCell1->cnt = 0;
						pCell2->stat = CELL_STAT_MISS;
						pCell2->cnt = 0;
						stGame.stat = GAME_STAT_MISS;
						stGame.miss_cnt = 0;
						//yieBL̒x
						{
							TapLogCh_Play(pTapSeq,
								TapLogCh_Se2,
								SND_SE_MISS,
								1,
								0,
								0);
						}
					}
				} else {
					//yieB̒Zx
					{
						TapLogCh_Play(pTapSeq,
							TapLogCh_Se2,
							SND_SE_ERROR,
							1,
							0,
							0);
					}
				}
			} else if(joy & TRG_B) {
				ST_Cell* pCell = &stGame.TBL_Cell[stGame.select_row][stGame.select_col];
				pCell->stat = CELL_STAT_NORMAL;
				pCell->cnt = 0;
				stGame.stat = GAME_STAT_SELECT1;
				//I
				{
					TapLogCh_Play(pTapSeq,
						TapLogCh_Se2,
						SND_SE_UNSEL,
						1,
						0,
						0);
				}
			}
			break;
		case GAME_STAT_MISS:		//~Xhꒆ
			{
				if(++stGame.miss_cnt >= MISS_CNT_MAX) {
					ST_Cell* pCell1 = &stGame.TBL_Cell[stGame.cursor_row][stGame.cursor_col];
					ST_Cell* pCell2 = &stGame.TBL_Cell[stGame.select_row][stGame.select_col];
					pCell1->stat = CELL_STAT_NORMAL;
					pCell1->cnt = 0;
					pCell2->stat = CELL_STAT_NORMAL;
					pCell2->cnt = 0;
					stGame.stat = GAME_STAT_SELECT1;
				}
			}
			break;
		case GAME_STAT_GAMEOVER:	//Q[I[o[
			{
				/** no job **/
			}
			break;
		}
	}
	//XRA
	{
		if(stGame.stat == GAME_STAT_GAMEOVER) {
			stGame.score_disp = stGame.score;
		} else {
			int diff;
			diff = stGame.score - stGame.score_disp;
			if(diff >= 10000) {
				stGame.score_disp += 1000;
			} else if(diff >= 1000) {
				stGame.score_disp += 100;
			} else if(diff >= 100) {
				stGame.score_disp += 10;
			} else if(diff >= 10) {
				stGame.score_disp += 5;
			} else if(diff >= 1) {
				stGame.score_disp++;
			}
		}
		if(stGame.score_disp > hi_score) {
			hi_score = stGame.score_disp;
		}
	}
	//x
	{
		if(stGame.stat != GAME_STAT_GAMEOVER) {
			if(stGame.game_time < SEC(10)) {
				stGame.game_warn++;
				if(stGame.game_warn >= ((stGame.game_time / SEC(0.5)) + SEC(0.5))) {
					stGame.game_warn = 0;
					TapLogCh_Play(pTapSeq,
						TapLogCh_Se4,
						SND_SE_WARN,
						1,
						0,
						0);
				}
			}
		}
	}
}
//-----------------------------------------------------------------------------
void game_init() {
	memset(&stGame, 0, sizeof stGame);
	stGame.game_time = GAME_TIME_MAX;
}
//-----------------------------------------------------------------------------
void game_run() {
	game_init();
	//Q[JnOo
	{
		int i, col, row, att = 0;
		for(i = 0; i < SEC(0.34); i++) {
			schedule();
			game_exec();
			game_draw();
			pceWaveSetChAtt(music_wch, att++);
		}
		for(row = 0; row < FIELD_ROWS; row++) {
			for(col = 0; col < FIELD_COLS; col++) {
				schedule();
				game_exec();
				game_draw();
				pceWaveSetChAtt(music_wch, att++);
				{
					ST_Cell* pCell = &stGame.TBL_Cell[row][col];
					pCell->stat = CELL_STAT_APPEAR;
					pCell->panel_color = RND32_RANGE(seed, 0, 3);
					pCell->panel_number = 0;
					pCell->cnt = 0;
				}
				schedule();
				game_exec();
				game_draw();
				pceWaveSetChAtt(music_wch, att++);
			}
		}
		StopMusic();
		pceWaveSetChAtt(music_wch, 0);	//plyŖ炷̂Ń{[߂ĂB
	}
	stGame.stat = GAME_STAT_SELECT1;
	//Q[
	{
		while(stGame.game_time) {
			schedule();
			game_draw();
			game_exec();
			if(stGame.ready_cnt >= READY_CNT_MAX) {	//T[rXƂāAGET READY...܂ł́A͏o邪Ԃ炳ȂB
				if(stGame.item_time[2]) {	//ACe
					if(!(now % 3)) {
						stGame.game_time--;
					}
				} else {
					stGame.game_time--;
				}
			}
		}
	}
	//Q[I[o[o
	stGame.stat = GAME_STAT_GAMEOVER;
	stGame.item_time[0] = stGame.item_time[1] = stGame.item_time[2] = 0;
	{
		while(stGame.gameover_cnt < (GAMEOVER_CNT_MAX + SEC(0.5))) {
			schedule();
			game_draw();
			game_exec();
			if(stGame.gameover_cnt >= GAMEOVER_CNT_MAX) {
				if(joy & TRG_AB) { break; }
			}
			stGame.gameover_cnt++;
		}
	}
}
//*****************************************************************************
//	demo_run
//*****************************************************************************
void demo_run() {
	int i, fade_cnt = SEC(0.5), bStart = 0, iBlink = 0;
	//Q[BGMSEmɎ~߂B
	for(i = 0; i <= TapLogCh_Max; i++) { TapLogCh_Stop(pTapSeq, i); }
	StopMusic();
	pceWaveSetChAtt(music_wch, 0);
	//ȂfʂɂȂƌڂ̂ŏEFCgꂽB
	delay(SEC(0.5));
	//fBGMJnB
	PlayMusic(music_table[MUS_DEMO]);
	for(;;) {
		schedule();
		{
			int x, y;
			for(x = (( now / 2) + 0) & 15; x < DISP_X; x += 16) {
				CbkQue_render_line(pCbkQue,
					0,
					&render,
					x,
					0,
					x,
					DISP_Y,
					2);
			}
			for(y = ((-now / 2) + 8) & 15; y < DISP_Y; y += 16) {
				CbkQue_render_line(pCbkQue,
					0,
					&render,
					0,
					y,
					DISP_X,
					y,
					2);
			}
			for(x = ((-now / 4) + 4) & 15; x < DISP_X; x += 16) {
				CbkQue_render_line(pCbkQue,
					0,
					&render,
					x,
					0,
					x,
					DISP_Y,
					1);
			}
			for(y = (( now / 4) + 12) & 15; y < DISP_Y; y += 16) {
				CbkQue_render_line(pCbkQue,
					0,
					&render,
					0,
					y,
					DISP_X,
					y,
					1);
			}
		}
		//TITLE
		{
			CbkQue_sprite_draw(pCbkQue,
				PRI__TITLE,
				  X__TITLE,
				  Y__TITLE,
				 SPR_TITLE, 0);
			CbkQue_render_string_framed(pCbkQue,
				PRI__TITLE,
				&render,
				  X__TITLE+45,
				  Y__TITLE+1,
				"ķ",
				2,
				0x330);
			CbkQue_render_string_framed(pCbkQue,
				PRI__TITLE,
				&render,
				  X__TITLE+45+6,
				  Y__TITLE+1-2,
				"",
				2,
				0x330);
		}
		//HI
		{
			CbkQue_render_font_framed(pCbkQue,
				PRI__HI,
				&render,
				  X__HI__H-1	+27,
				  Y__HI-1,
				'H',
				2,
				0x330);
			CbkQue_render_font_framed(pCbkQue,
				PRI__HI,
				&render,
				  X__HI__I-1	+27,
				  Y__HI-1,
				'i',
				2,
				0x330);
			CbkQue_render_printf_framed(pCbkQue,
				PRI__HI,
				&render,
				  X__HI__SCORE-1	+27,
				  Y__HI-1,
				2,
				0x332,
				"%06d", hi_score);
			CbkQue_render_printf_framed(pCbkQue,
				PRI__HI,
				&render,
				  X__HI__SCORE-1	+27,
				  Y__HI-1,
				2,
				0x331,
				"%6d", hi_score);
		}
		//1P
		{
			CbkQue_render_printf_framed(pCbkQue,
				PRI__1P,
				&render,
				  X__1P__SCORE-1	+27,
				  Y__1P-1,
				0,
				0x332,
				"%06d", stGame.score);
			CbkQue_render_printf_framed(pCbkQue,
				PRI__1P,
				&render,
				  X__1P__SCORE-1	+27,
				  Y__1P-1,
				0,
				0x330,
				"%6d", stGame.score);
		}
		//PRESS TO START
		{
			int c = 3;
			if(!bStart) {
				if(!fade_cnt) {
					if((iBlink++ % SEC(1.0)) >= SEC(0.5)) { c = 0; }
				}
			} else {
				if(now & 2) { c = 0; }
			}
			if(c != 3) {
				CbkQue_render_string_framed(pCbkQue,
					PRI__1P,
					&render,
					(DISP_X-56)/2,
					77,
					"PRESS TO START",
					2,
					c|0x330);
			}
		}
		{
			int c = 0;
			if(!bStart) {
				if(fade_cnt) { fade_cnt--; }
			} else {
				if(bStart < SEC(1.0)) {
					bStart++;
				} else {
					if(fade_cnt < SEC(0.5)) { fade_cnt++; }
				}
			}
			c = fade_cnt / SEC(0.1);
			c = clamp(c, 0, 3);
			if(c) {
				CbkQue_render_rectangle_shadow(pCbkQue,
					PRI__FADE,
					&render,
					0,
					0,
					DISP_X,
					DISP_Y,
					c, 3);
			}
		}
		if(!bStart) {
			if(joy & TRG_AB) {
				TapLogCh_Play(pTapSeq,
					TapLogCh_Se4,
					SND_SE_WARN,
					1,
					0,
					0);
				bStart = 1;
				fade_cnt = 0;
			}
		} else {
			if(fade_cnt == SEC(0.5)) {
				break;
			}
		}
	}
}
//*****************************************************************************
//	app_main
//*****************************************************************************
int app_main(int argc, char* argv[]) {
//{{BR}hBBȂNƓdr\BfobOɓdr\₷悤ɂ邽߂łB
	delay(1);
	if(joy & PAD_B) {
		pceWaveSetMasterAtt(0);
		pcePowerSetReport(PWR_RPTOFF);
	}
//}}BR}hBBȂNƓdr\BfobOɓdr\₷悤ɂ邽߂łB
	for(;;) {
		SEH_use_shared;
		SEH_try_shared {
			demo_run();
		} SEH_catch(MAKEFOURCC('T','R','G','D')) {
			break;
		} SEH_end
		SEH_try_shared {
			game_run();
		} SEH_catch(MAKEFOURCC('T','R','G','D')) {
			/** no job **/
		} SEH_end
	}
	return 0;
}
