#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
__declspec(noreturn) static void usage();
static void ShiftJisToUtf8(FILE* fp);
static void Utf8ToShiftJis(FILE* fp);
/****************************************************************************
 *	
 ****************************************************************************/
int main(int argc, char* argv[]) {
	int opt;
	void (*fn)(FILE* fp) = &ShiftJisToUtf8;
	//R}hCIvVB
	opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
	while((opt = getopt(argc, argv, "ush")) != -1) {
		switch(opt) {
		case 'u': fn = &ShiftJisToUtf8; break;
		case 's': fn = &Utf8ToShiftJis; break;
		case 'h':
		default:  usage();
		}
	}
	//t@Cw肳ĂȂ΁AW͂ǂݍށB
	if(optind == argc) {
		(*fn)(stdin);
	//t@Cw肳ĂAet@CǂݍށB
	} else {
		int i;
		for(i = optind; i < argc; i++) {
			FILE* fp = fopen(argv[i], "r");
			if(!fp) { die("%s J܂B\n", argv[i]); }
			(*fn)(fp);
			fclose(fp);
		}
	}
	return EXIT_SUCCESS;
}
/*---------------------------------------------------------------------------*/
__declspec(noreturn) static void usage() {
	fprintf(stderr, "dpunicnv - VtgJISUTF-8ϊtB^ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2015-2017 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  dpunicnv [option] [filename ...]\n");
	fprintf(stderr, "  Efilenamew肵Ȃ΁AW͂ǂݍ݂܂B\n");
	fprintf(stderr, "  EfilenaméAChJ[hɂ镡w\łB\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
	fprintf(stderr, "  -u VtgJISUTF-8ϊs܂B(ftHg)\n");
	fprintf(stderr, "  -s UTF-8˃VtgJISϊs܂B\n");
	fprintf(stderr, "  -h g\܂B\n");
	exit(EXIT_FAILURE);
}
/****************************************************************************
 *	
 ****************************************************************************/
static void ShiftJisToUtf8(FILE* fp) {
	char*    glbuf = NULL;	//getline()p
	int      glcap = 0;	//
    //{{2015/03/06폜:clipunic.cstrdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉƂɔAc[̊֐𗘗p悤ɕύX܂B
    //	char*    buf1;		//UTF-8p
    //	int      len1;		//
    //	wchar_t* buf2;		//UCS-2p
    //	int      len2;		//
    //}}2015/03/06폜:clipunic.cstrdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉƂɔAc[̊֐𗘗p悤ɕύX܂B
	while(getline(&glbuf, &glcap, fp) != EOF) {
    //{{2015/03/06ύX:clipunic.cstrdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉƂɔAc[̊֐𗘗p悤ɕύX܂B
    //		//VtgJISUnicode(UCS-2)
    //		len2 = ShiftJisToUnicodeStr(glbuf, NULL, 0);
    //		buf2 = malloc((len2 + 1) * sizeof(wchar_t));
    //		if(!buf2) { DIE(); }
    //		ShiftJisToUnicodeStr(glbuf, buf2, len2 + 1);
    //		//UCS-2UTF-8
    //		len1 = Ucs2ToUtf8Str(buf2, NULL, 0);
    //		buf1 = malloc(len1 + 1);
    //		if(!buf1) { DIE(); }
    //		Ucs2ToUtf8Str(buf2, buf1, len1 + 1);
    //		printf("%s", buf1);
    //		//obt@J
    //		free(buf1);
    //		free(buf2);
    //2015/03/06ύX:clipunic.cstrdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉƂɔAc[̊֐𗘗p悤ɕύX܂B
		//VtgJISUTF-8
		unsigned char* buf = strdup_ShiftJisToUtf8(glbuf);
		printf("%s", buf);
		//obt@J
		free(buf);
    //}}2015/03/06ύX:clipunic.cstrdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉƂɔAc[̊֐𗘗p悤ɕύX܂B
	}
	//obt@J
	free(glbuf);
}
/*--------------------------------------------------------------------------*/
static void Utf8ToShiftJis(FILE* fp) {
	char*    glbuf = NULL;	//getline()p
	int      glcap = 0;	//
    //{{2015/03/06폜:clipunic.cstrdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉƂɔAc[̊֐𗘗p悤ɕύX܂B
    //	char*    buf1;		//VtgJISp
    //	int      len1;		//
    //	wchar_t* buf2;		//UCS-2p
    //	int      len2;		//
    //}}2015/03/06폜:clipunic.cstrdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉƂɔAc[̊֐𗘗p悤ɕύX܂B
	while(getline(&glbuf, &glcap, fp) != EOF) {
    //{{2015/03/06ύX:clipunic.cstrdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉƂɔAc[̊֐𗘗p悤ɕύX܂B
    //		//UTF-8UCS-2
    //		len2 = Utf8ToUcs2Str(glbuf, NULL, 0);
    //		buf2 = malloc((len2 + 1) * sizeof(wchar_t));
    //		if(!buf2) { DIE(); }
    //		Utf8ToUcs2Str(glbuf, buf2, len2 + 1);
    //		//Unicode(UCS-2)˃VtgJIS
    //		len1 = UnicodeToShiftJisStr(buf2, NULL, 0);
    //		buf1 = malloc(len1 + 1);
    //		if(!buf1) { DIE(); }
    //		UnicodeToShiftJisStr(buf2, buf1, len1 + 1);
    //		printf("%s", buf1);
    //		//obt@J
    //		free(buf1);
    //		free(buf2);
    //2015/03/06ύX:clipunic.cstrdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉƂɔAc[̊֐𗘗p悤ɕύX܂B
		//UTF-8˃VtgJIS
		char* buf = strdup_Utf8ToShiftJis(glbuf);
		printf("%s", buf);
		//obt@J
		free(buf);
    //}}2015/03/06ύX:clipunic.cstrdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉƂɔAc[̊֐𗘗p悤ɕύX܂B
	}
	//obt@J
	free(glbuf);
}
