;#//	
;#//	dPrpTblD.tcl - dPrpTblD.exe߰
;#//	
;#//	* Fri Oct 02 21:21:49 JST 2015 Naoyuki Sawa
;#//	- 1st ذ
;#//	
set VERSION 20151002	;#//ŏIXV
;#//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;#//̧ق礼ٖ̱ڽ擾
proc getSymAddr {symFname symName} {					;#//PrpTblȂoffset=0,PrpHdrȂoffset=8w肹BAvP[V͑PrpHdrgƎv̂Ŋl=8ƂB
	set fp [open $symFname]
	while {[gets $fp line] >= 0} {
		set flds [regexp -all -inline {[^[:blank:]]+} $line]
		set name [lindex $flds 0]
		set addr [lindex $flds end]
		if {$name eq $symName} then {break}
	}
	if {[eof $fp]} then {error "### $symFname ̒ $symName ܂"}
	close $fp
	scan $addr {%x} addr
	;#//ٖPrpTblPrpHdr𐄑ĤKvɉĵ̾ĂZ鏈
	if {[string match {ph*} $symName]} then {
		;#//ϐ'ph`'ȂΤPrpHdr_def()ŏꂽϐƉ肵Ĥsizeof(ST_PrpHdr)̵̾ĂZ
		incr addr 8
	} elseif {[string match {pt*} $symName]} then {
		;#//ϐ'pt`'ȂΤPrpTbl_def()ŏꂽϐƉ肵Ĥ̾ĂZȂ
		;#** no job **
	} else {
		;#//ϐ'ph`'ł'pt`'łȂΤoȂ̂Ť̾ĂZȂɂ
		;#// - ͤۂ̱ع݂PrpHdr_def()̕ǂgƎv̂ŤPrpHdr_def()ƍlĵ̾ĂZ헪L肾Ǝv̕ǂΕύX
		;#** no job **
	}
	return $addr
}
;#//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;#//RegTbl.hRegKey_PrpTbl̒l擾
proc getRegKey {} {
	set fp [open "RegTbl.h"]
	while {[gets $fp line] >= 0} {
		set flds [regexp -all -inline {[^[:blank:]]+} $line]
		set name [lindex $flds 1]
		set no   [lindex $flds end]
		if {$name eq "RegKey_PrpTbl"} then {break}
	}
	if {[eof $fp]} then {error "### RegTbl.h ̒ RegKey_PrpTbl ܂"}
	close $fp
	return $no
}
;#//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;#//PrpTbl.hðٖ̒l擾
proc getPrpTbl {tblName} {
	set fp [open "PrpTbl.h"]
	while {[gets $fp line] >= 0} {
		set flds [regexp -all -inline {[^[:blank:]]+} $line]
		set name [lindex $flds 1]
		set no   [lindex $flds end]
		if {$name eq "PrpTbl_$tblName"} then {break}
	}
	if {[eof $fp]} then {error "### PrpTbl.h ̒ PrpTbl_$tblName ܂"}
	close $fp
	return $no
}
;#//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;#//èðق̐擪8KB'core.'ɕۑ
proc coreDump {addr {size 8192}} {						;#//èðق̍ő廲ނ(65536/8)=8192޲ĂȂ̂š
	file delete "core"							;#//܂mcore폜Ă֐̍Ōcore쐬omF
	set top [format {%x} $addr]
	set end [format {%x} [expr {$addr + $size - 1}]]
	set cmdLine "isd.exe w* core. $top $end"				;#//'.'tȂisd.exe'.bin'Ă܂
  ;#//{{---
  ;#//	exec {*}$cmdLine							;#//̂ɎsoĂװɂȂisdExit()̒ŉNĂ݂(?)
  ;#//---
  ;#//	if {[catch {exec {*}$cmdLine} msg]} then {				;#//sߑĉ鎖ɂ
  ;#//		if {[string first "writting core." $msg]} then {error $msg}	;#//Ɏsło͕Ŕf鎖ɂ
  ;#//	}
  ;#//---
	#//܂execŌĂяostderrɏo͂Ƥނ̏IނɊ֌WexecװƌȂ悤ł
	#//TIP #267: Allow 'exec' to Ignore Stderr(http://www.tcl.tk/cgi-bin/tct/tip/267.html)
	#//Currently the exec command will always fail if the process writes to standard error.
	#//Since various applications use stderr for debug output it would be useful to retain this output without having to resort to redirecting stderr to stdout (which can cause interleaving).
	#//execŌĂяostderrɏo͂ĂװƌȂȂ悤ɂɂͤ'-ignorestderr'߼݂w肷Ηǂł
	exec -ignorestderr {*}$cmdLine	;#//Tcl8.5ȍ~̏ꍇ
    ;#	exec {*}$cmdLine 2>@stderr	;#//Tcl8.4ȑȌꍇTcl8.5łok
  ;#//}}---
	if {![file exists "core"]} then {error "### core 쐬o܂łP/ECEڑĂȂ\L܂"}
}
;#//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;#//L̊֐œꂽgèðق߂
proc prpTblDump {regNo tblNo} {
	set cmdLine "dPrpTblD.exe core RegTbl.bin $regNo $tblNo"
	set msg [exec {*}$cmdLine]
	return $msg
}
;#//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
if {($argc < 2) || ($argc > 3)} then {
	puts "dPrpTblD.tcl - dPrpTblD.exe߰ ($VERSION)"
	puts "Copyright (C) 2015 Naoyuki Sawa"
	puts ""
	puts "USAGE:"
	puts "  tclsh.exe $argv0 ̧.sym ðٖ ٖ"
	puts "  ðٖ 'PrpTbl_Foo''Foo'̕w肵ĉ"
	puts "  ٖ ̧قSymbol̖Ow肵ĉ"
	puts ""
	puts "  tclsh.exe $argv0 ̧.sym ðٖ"
	puts "  ٖȗƤٖ='phðٖ'łƔf܂"
	puts "  قƂǂ̱ع݂ŏL̂悤ɕϐ𖽖Ǝv̂Ťޓ͂̎ԂȂ߂ɂ܂"
	puts ""
	puts "EXAMPLE:"
	puts "  tclsh.exe $argv0 sample.sym Foo phBar"
	puts "  'PrpHdr_def(Foo,phBar)'Œ`èðق߂܂"
	puts "  ̫ނ'RegTbl.h''PrpTbl.h'Kvł"
	puts ""
	puts "  tclsh.exe $argv0 sample.sym Foo"
	puts "  'PrpHdr_def(Foo,phFoo)'Œ`èðق߂܂"
	puts "  ̫ނ'RegTbl.h''PrpTbl.h'Kvł"
	exit 1
}
lassign $argv symFname tblName symName
if {$symName eq ""} then {set symName "ph$tblName"}	;#//ٖȗꂽ礼ٖ='phðٖ'łƔf
set addr [getSymAddr $symFname $symName]
set regNo [getRegKey]
set tblNo [getPrpTbl $tblName]
coreDump $addr
set msg [prpTblDump $regNo $tblNo]
puts $msg
