/*
 *	mqueue.h
 *
 *	POSIX Message Queue for Windows NT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Fri Mar 18 21:34:32 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	  pthreads-win32ɂPOSIX Message Queue܂܂ĂȂ̂ŁAǉ鎖ɂ܂B
 *	  ̃W[Win32płBP/ECEł͎gpo܂B	
 *	- ȉ̎QlɂĒAȗɂ܂B
 *	  Ql
 *	  uPOSIX Message Queues for Win32!v(https://sourceware.org/ml/pthreads-win32/2000/msg00131.html)
 *	  Ɋȗ_́Aȉ̒ʂłB
 *	  EIWił̎́AvZXԂŃbZ[W̑Ms悤ɁALgĎĂ܂B
 *	    ́AvZX̃XbhԂŃbZ[W̑MsΏ[Ȃ̂ŁAʂ̃mۂgp܂B
 *	  E̓vZXԒʐMT|[gȂ̂ŁAbZ[WL[̖O͖ӖɂȂAmq_open()name,y,mode𖳎܂B
 *	    ɔāAmq_unlink()AȂ_~[֐Ƃ܂B
 *	  EIWił̎́A{̊֐dlʂɁAG[́AG[R[hԂ悤ɂȂĂ܂B
 *	    ́AG[ɁA'DIE()'Œ~悤ɂ܂B
 *	  Emq_notify()͖ΉłAĂяoƃG[~܂B
 *	    mq_notify()Ήł鎖́AIWił̎łB
 *	- ֐dlɂẮAȉ̎QƂ܂B
 *	  QƎ
 *	  uLinux Programmer's Manual - MQ_OVERVIEWv(https://linuxjm.osdn.jp/html/LDP_man-pages/man7/mq_overview.7.html)
 *	  yсAL̃y[W烊NĂAe֐̐̃y[W
 *	* Sat Mar 19 21:19:21 JST 2016 Naoyuki Sawa
 *	- /clip/include/sys/types.h(/clip/clipstdw.h)ssize_t̒`ǉɔA܂ssize_t̑intgĂ𐳎ssize_tɏC܂B
 *	  2016/03/19_intssize_tɏCӏ́Agetline(),getdelim(),mq_receive()łB
 */
#ifndef __mqueue_h
#define __mqueue_h
#ifdef	__cplusplus
extern "C" {
#endif//__cplusplus
/****************************************************************************
 *	
 ****************************************************************************/
#ifndef O_NONBLOCK
#define O_NONBLOCK	04000		//uLinux Kernel History - Linux 0.01 - root/include/fcntl.hv(http://kernelhistory.sourcentral.org/linux-0.01/S/11.html)̒lɕ키ɂ܂B
#endif//O_NONBLOCK
/****************************************************************************
 *	
 ****************************************************************************/
typedef struct mq_hdr*	mqd_t;		//opaque datatype
/*--------------------------------------------------------------------------*/
struct mq_attr {
	long		mq_flags;	//tO: 0O_NONBLOCK
	long		mq_maxmsg;	//L[̍ő僁bZ[W
	long		mq_msgsize;	//ő僁bZ[WTCY(oCgP)
	long		mq_curmsgs;	//L[ɌݓĂ郁bZ[W
};
/****************************************************************************
 *	
 ****************************************************************************/
mqd_t mq_open(const char* name, int oflag, .../*mode_t mode, struct mq_attr* attr*/);
int mq_close(mqd_t mqdes);
int mq_unlink(const char* name);
int mq_send(mqd_t mqdes, const char* msg_ptr, size_t msg_len, unsigned msg_prio);
ssize_t mq_receive(mqd_t mqdes, char* msg_ptr, size_t msg_len, unsigned* msg_prio);
int mq_notify(mqd_t mqdes, const struct sigevent* notification);
int mq_setattr(mqd_t mqdes, const struct mq_attr* newattr, struct mq_attr* oldattr);
int mq_getattr(mqd_t mqdes, struct mq_attr* attr);
#ifdef	__cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__mqueue_h
