//
//	ToolLib_SpaceManage.cs
//
//	エディター共通処理 - ツールのGUI処理のスペース管理
//
//	* Wed Apr 26 21:33:29 JST 2017 Naoyuki Sawa
//	- 1st リリース。
//	* Tue May 02 22:54:46 JST 2017 Naoyuki Sawa
//	- 各モジュール内のサイズ定義の倍率を一律で調整出来るように、ToolLib.csにTOOL_SCALEの定義を追加しました。
//	  詳細は、/clip/ToolLib/ToolLib.hの同日のコメントを参照して下さい。
//
using System;
namespace org.piece_me {
	public static partial class libclip {
		//*****************************************************************************
		//	定数、マクロ、構造体
		//*****************************************************************************
		//スペース情報構造体
		public class SToolSpace {
			public bool	LockSpace;	//スペースが固定タイプかどうか。(0以外:固定タイプ,0:通常タイプ)
			public int	UseSpace;	//使用するスペースサイズ。
			public int	SpaceStart;	//使用するスペースの開始位置。
			public int	InitUseSpace;	//初期化時のスペースサイズ。
		}
		//-----------------------------------------------------------------------------
		//スペース管理情報構造体
		public class SToolSpaceManage {			//【C#版特有のコメント】C言語版ではopaque datatypeにしていたが、C#では出来ないので仕方無くpublicにした。
			public GSList	Space;			//登録されているスペース情報へのアドレスを格納しているポインタ変数。
			public int	NextSpace;		//次のスペースに割り当てるスペース座標。
			public int	TotalLockSpace;		//固定で確保されている総スペースサイズ。
			public int	TotalSpace;		//総スペースサイズ。
			public int	InitTotalSpace;		//初期化時の総スペースサイズ。
		}
		//*****************************************************************************
		//	ローカル変数
		//*****************************************************************************
		private static GSList	g_TSpaceManage;
		//*****************************************************************************
		//	アプリケーション用関数
		//*****************************************************************************
		//スペース管理情報を作成する。
		public static SToolSpaceManage ToolSpaceManage_Create(int TotalSpace) {
			SToolSpaceManage TSpaceManage;
			//新しいスペース管理情報を格納するためのメモリの確保。
			TSpaceManage = new SToolSpaceManage();
			//確保したメモリ領域を保存。
			g_TSpaceManage = g_slist_append(g_TSpaceManage, TSpaceManage);
			//情報を初期化。
		//不要	TSpaceManage.NextSpace      = 0;
		//不要	TSpaceManage.TotalLockSpace = 0;
			TSpaceManage.TotalSpace     = TotalSpace;
			TSpaceManage.InitTotalSpace = TotalSpace;
			//スペース管理情報を返す。
			return TSpaceManage;
		}
		//-----------------------------------------------------------------------------
		//スペース管理情報を削除する。
		public static void ToolSpaceManage_Delete(SToolSpaceManage TSpaceManage) {
			//登録されているスペース情報へのアドレスを格納しているポインタ変数のリストを解放する。
			g_slist_free(TSpaceManage.Space);
			//確保していたメモリを解放する。
			g_TSpaceManage = g_slist_remove(g_TSpaceManage, TSpaceManage);
		}
		//-----------------------------------------------------------------------------
		//全てのスペース管理情報を削除する。
		public static void ToolSpaceManage_Delete_All() {
			//有効な全てのスペース管理を削除する。
			while(g_TSpaceManage != null) { ToolSpaceManage_Delete((SToolSpaceManage)g_TSpaceManage.data); }
		}
		//-----------------------------------------------------------------------------
		//スペース管理情報にスペース情報を追加する。
		public static void ToolSpaceManage_AddSpace(SToolSpaceManage TSpaceManage, SToolSpace Space, int UseSpace, bool LockSpace) {
			//使用するスペースサイズが-1だった場合は残りの全てのスペースを割り当てる。
			if(UseSpace == -1) { UseSpace = TSpaceManage.TotalSpace - TSpaceManage.NextSpace; }
			//情報を初期化。
			Space.LockSpace    = LockSpace;
			Space.UseSpace     = UseSpace;
			Space.InitUseSpace = UseSpace;
			Space.SpaceStart   = TSpaceManage.NextSpace;
			//次のスペースに割り当てるスペース開始位置を使用されるスペース分だけ移動する。
			TSpaceManage.NextSpace += UseSpace;
			//固定型スペースの場合は固定型スペースの総サイズに追加するスペースサイズを加算する。
			if(LockSpace) { TSpaceManage.TotalLockSpace += UseSpace; }
			//スペース管理情報にスペース情報を追加する。
			TSpaceManage.Space = g_slist_append(TSpaceManage.Space, Space);
		}
		//-----------------------------------------------------------------------------
		//総スペースサイズを変更する。
		public static void ToolSpaceManage_ChangeTotalSpace(SToolSpaceManage TSpaceManage, int TotalSpace) {
			int FreeSpace, NextFreeSpace, SpaceStart;
			GSList list;
			//今までの総スペースサイズでの固定型ではないスペースのサイズを算出。
			FreeSpace = TSpaceManage.InitTotalSpace - TSpaceManage.TotalLockSpace;
			//新しい総スペースサイズでの固定型ではないスペースのサイズを算出。
			NextFreeSpace =              TotalSpace - TSpaceManage.TotalLockSpace;
			//スペースの数だけ繰り返し。
			SpaceStart = 0;
			for(list = TSpaceManage.Space; list != null; list = list.next) {
				SToolSpace Space = (SToolSpace)list.data;
				//スペース開始位置のセット。
				Space.SpaceStart = SpaceStart;
				//固定型スペースではない場合は総スペースサイズに対する割合から新しいスペースサイズを決定する。
				if(!Space.LockSpace) { Space.UseSpace = Space.InitUseSpace * NextFreeSpace / FreeSpace; }
				//スペース開始位置を移動する。
				SpaceStart += Space.UseSpace;
			}
			//新しい総スペースサイズを保存。
			TSpaceManage.TotalSpace = TotalSpace;
		}
		//-----------------------------------------------------------------------------
		//総スペースサイズを取得する。
		public static int ToolSpaceManage_GetTotalSpace(SToolSpaceManage TSpaceManage) {
			return TSpaceManage.TotalSpace;
		}
		//-----------------------------------------------------------------------------
		//次のスペース情報に割り当てる開始位置を取得する。
		public static int ToolSpaceManage_GetNextSpace(SToolSpaceManage TSpaceManage) {
			return TSpaceManage.NextSpace;
		}
	}
}
