/*
 *	getopt.c
 *
 *	IvV
 *
 *	* Sun Mar 10 19:53:04 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	- POSIXWgetopt()݊֐܂B
 *	- GNUggetopt_long()getopt_long_only()́A錾̂ݍs܂B
 *	  ́AłBAKvɉĎ\łB
 *	- UNIXł́Agetopt()<unistd.h>,getopt_long()getopt_long_only()<getopt.h>Ő錾Ă܂B
 *	  AP/ECEWindowsɂ<unistd.h>̂ŁAׂ͂<getopt.h>Ő錾邱Ƃɂ܂B
 *	- getopt()AP/ECẼAvP[VŎgp邱Ƃ́AقږƎv܂B
 *	  ɁAWindows̃c[vOgpړIŁApӂ܂B
 *	* Fri Nov 20 21:44:18 JST 2015 Naoyuki Sawa
 *	- GNUg'IvVĂȂĂǂIvV'ɑΉ܂B
 *	* Tue Apr 11 21:34:28 JST 2017 Naoyuki Sawa
 *	- getopt_long()܂B
 *	- getopt_long_only()́Â܂܂łB
 *	* Wed Apr 12 22:29:29 JST 2017 Naoyuki Sawa
 *	- ugetopt_long()̃eXgvǋL܂B
 *	  W[̏ɂ͕ύXL܂B
 */
#include "clip.h"

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

char* optarg;
int   optind = 1;
int   optopt;
int   opterr = 1;
int   optreset;

/****************************************************************************
 *	getopt/getopt_long
 ****************************************************************************/

//uGETOPT(3)v(http://www.unix.com/man-page/FreeBSD/3/getopt/)p:
//The getopt() function incrementally parses a command line argument list argv and returns the next known option character.
//An option character is known if it has been specified in the string of accepted option characters, optstring.
//
//The option string optstring may contain the following elements:
// individual characters, and characters followed by a colon to indicate an option argument is to follow.
//For example, an option string "x" recognizes an option "-x", and an option string "x:" recognizes an option and argument "-x argument".
//It does not matter to getopt() if a following argument has leading white space.
//
//On return from getopt(), optarg points to an option argument, if it is anticipated,
// and the variable optind contains the index to the next argv argument for a subsequent call to getopt().
//The variable optopt saves the last known option character returned by getopt().
//
//The variables opterr and optind are both initialized to 1.
//The optind variable may be set to another value before a set of calls to getopt() in order to skip over more or less argv entries.
//
//In order to use getopt() to evaluate multiple sets of arguments, or to evaluate a single set of arguments multiple times,
// the variable optreset must be set to 1 before the second and each additional set of calls to getopt(), and the variable optind must be reinitialized.
//
//The getopt() function returns -1 when the argument list is exhausted.
//The interpretation of options in the argument list may be cancelled by the option '--' (double dash)
// which causes getopt() to signal the end of argument processing and return -1.
//When all options have been processed (i.e., up to the first non-option argument), getopt() returns -1.

// * Fri Nov 20 21:44:18 JST 2015 Naoyuki Sawa
// - GNUg'IvVĂȂĂǂIvV'ɑΉ܂B
//   uLinux Programmer's Manual - GETOPTv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/getopt.3.html)p:
//   optstring͎󂯕tIvVȂ镶łB														
//   ̂ƂɃR(:)uĂꍇ́AIvVɂ͈Kvł邱ƂB											̓͊ɑΉĂB
//   ̂Ƃgetopt()́AݒڂĂargvvfŁAIvVɈeLXgւ̃|C^[A邢͎argvvf̃eLXgւ̃|C^[optargɑB	
//   2AăRuĂꍇ́ÃIvV͈ƂĂƂȂĂ悢B										
//   ݂argvvfɃeLXg(܂A"-oarg"̂悤ɁAIvVgƓ[hɃeLXgꍇ)AꂪoptargɕԂB					̓{ǉΉB
//   Ȃoptarg0ɐݒ肳BGNUɂgłB														

// * Tue Apr 11 21:34:28 JST 2017 Naoyuki Sawa
// - getopt_long()܂B
//   ̓Iɂ́Agetopt()̃R[hɒIvV̏ǉgetopt_long()ƂAgetopt()longoptsNULLɂgetopt_long()Ăяo悤ɕύX܂B
//   getopt_long()AZIvV̏͊getopt()ƓłAʁXɎL̂悤ɎAʉoăR[h̗ʂȂȂ邩łB
// - getopt_long_only()́Â܂܂łB
//   ̃c[getopt_long_only()gP[X͑Ǝv̂ŁÂ܂܂ō\ȂƎv܂B
// - uLinux Programmer's Manual - GETOPTv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/getopt.3.html)p:
//   ygetopt_long()getopt_long_only()z
//   getopt_long()֐́AIvV(2̃_bV"--"Ŏn܂IvV)󂯓邱Ƃgetopt()Ɠ悤ɓ삷(vOɒIvVnꂽꍇAoptstringNULLł͂Ȃ󕶎("")ƂȂ)B
//   IvV̖ÓAƏdȂȂ͈͂ɂĒZkłB
//   邢͒`ꂽIvVɐmɃ}b`̂ł(R)܂ȂB
//   IvV͈邱ƂłA--arg=param܂--arg paramƌ`Ŏw肷B
//   longoptsstruct option̗vfȂźA擪vfւ̃|C^[łB
//   struct option<getopt.h>ňȉ̂悤ɒ`ĂB
//       struct option {
//           const char *name;
//           int         has_arg;
//           int        *flag;
//           int         val;
//       };
//   ꂼ̃tB[ḧӖ͈ȉ̒ʂB
//       name        IvV̖OB
//       has_arg     no_argument(܂0)ȂAIvV͈ƂȂB
//                   required_argument(܂1)ȂAIvV͈KvƂB
//                   optional_argument(܂2)ȂAIvV͈ƂĂƂȂĂǂB
//       flag        IvVɑ΂錋ʂ̕Ԃw肷B
//                   flagNULLȂgetopt_long()valԂ(ႦΌĂяõvÓAvalɓȃIvV邱Ƃł)B
//                   NULLȊȌꍇɂ́Agetopt_long()0ԂB
//                   ̂ƂIvVflag|CgϐvalB
//                   ȂƂ̕ϐ͕ύXȂB
//       val         ԂlA܂flag|Cgϐփ[hlB
//   z̍Ō̗vf́AS0Ŗ߂ĂȂ΂ȂȂB
//   longindex́ANULLłȂ΁AIvṼCfbNXlongopts̑ΈʒuƂĕێĂϐւ̃|C^[ƂȂB
//   getopt_long_only()getopt_long()Ɠl̓邪A'-'"--"ƓlɁAIvVƂĈB
//   '-'Ŏn܂("--"ȊO)IvVÂɂ̓}b`ȂẐɃ}b`ꍇɂẮA͒ZIvVƂĉ߂B
//   yԂlz
//   IvVɌgetopt()͂̃IvVԂB
//   ׂẴR}hCIvV̉͂IAgetopt()-1ԂB
//   optstringɊ܂܂ȂIvVƁA'?'ԂB
//   ȂIvVꍇAԂloptstring̍ŏ̕ɂقȂ:ŏ̕':'ł':'ԂAȊȌꍇ'?'ԂB
//   getopt_long()getopt_long_only()AZIvVFꍇɂ͂̕ԂB
//   IvVɑ΂ẮAflagNULLȂvalԂAflagNULLȊOȂ0ԂB
//   G[-1̕Ԃlgetopt()ƓłB
//   '?'́A}b`młȂꍇ]ȃp[^[ꍇɂԂB
// - ݂̎ł́AGNUgdĺAIȈ̕ёւɂ͖ΉłB
//   glibcgetopt()getopt_long()ɂ́Aʏ̈IvV̕ɗLĂAIvVIɑO֕ёւ@\L̂łA̎ł͑Ή܂łB		v
//   glibcgetopt()getopt_long()łPOSIXLY_CORRECT[hŎsΏL̋@\͖ɂȂ܂̂ŁA݂̎POSIXLY_CORRECT[h݊łƍlĉB
// - ݂̎ł́AIvV̕IȈvɂ͖ΉłB
//   glibcgetopt()getopt_long()ł́AႦ"--foobar"ƂIvV`LA"--foo"ƂIvVw肵ꍇA(ꂪŒvȂ)"--foobar"ɈvƂ@\L܂B
//   mɕ֗ł͂̂łA╡GɂȂ邵AԈIvVw肪Ӑ}ʂ̃IvV`ɋRvĂ܂Ƃ댯L̂ŁA͂̋@\͖Ƃ܂B		v

int getopt(int argc, char* const argv[], const char* optstring) {
//{{2017/04/11ǉ:getopt_long()܂B
	return getopt_long(argc, argv, optstring, NULL/*longopts*/, NULL/*longindex*/);
}
int getopt_long(int argc, char* const argv[], const char* optstring, const struct option* longopts, int* longindex) {
//}}2017/04/11ǉ:getopt_long()܂B
	static char* scanptr = ""; /* |C^ */
	//
	int optstring_first_character; /* optstring̐擪 */
	/* optstring̐擪擾Aꂪ':'Ȃ΁Aoptstring':'̌w悤ɂ܂B */
	if((optstring_first_character = *optstring) == ':') { optstring++; }
	/* optresetZbgĂc */
	if(optreset != 0) {
		/* optresetNA܂B */
		optreset = 0;
		/* |C^܂B */
		scanptr = "";
	}
    //{{2015/11/20ǉ:GNUg'IvVĂȂĂǂIvV'ɑΉ܂B
	/* IvVNAĂ܂B */
	optarg = NULL;
    //}}2015/11/20ǉ:GNUg'IvVĂȂĂǂIvV'ɑΉ܂B
	for(;;) {
		/* IvV擾܂B */
		optopt = *scanptr++;
		/* IvVL΁A܂ */
		if(optopt != '\0') { break; }
		/* optindXg𒴂ĂAIvV͂I܂B */
		if((unsigned)optind >= (unsigned)argc) { goto L_END; }
		/* |C^擾܂B */
		scanptr = argv[optind];
		/* vf1ڂ'-'łȂ΁AIvV͂I܂B */
		if(*scanptr++ != '-') { goto L_END; }
		/* |C^I[Ȃ΁Aoptind֐i߂Ă܂B(P"-"𖳎A[v邽) */
		if(*scanptr == '\0') { optind++; }
	}
	/* "--"ɑIvVwȂ΁c */
	if(optopt == '-') {
//{{2017/04/11ǉ:getopt_long()܂B
		//"--"ɑ񂪗L΁AIvVƌȂB
		if(*scanptr != '\0') {
			//IvV`̔z񂪎w肳Ăc
			if(longopts) {
				const struct option* p;
				for(p = longopts; p->name; p++) {
					int len = strlen(p->name);
					if(!strncmp(scanptr, p->name, len)) {
						//"--name(I[)"Ɉvc
						if(scanptr[len] == '\0') {
							//optoptɁAIvV̕Ԃli[B(G[̏ꍇKvȂ̂łŊi[ĂB)
							optopt = p->val;
							//optind֐i߂B
							optind++;
							//|C^B
							scanptr = "";
							//IvV̎ނɂāc
							switch(p->has_arg) {
							default:DIE();
							case no_argument:
							case optional_argument:
								/** no job **/
								break;
							case required_argument:
								//optindXg𒴂Ăc
								if((unsigned)optind >= (unsigned)argc) {
									//optstring̐擪':'Ȃ΁AG[bZ[W\':'ԂB
									if(optstring_first_character == ':') { return ':'; }
									//opterrZbgĂAG[bZ[W\B
									if(opterr != 0) { die("option '%c' requires an argument", optopt); }
									//'?'ԂB
									return '?';
								}
								//̈AIvVƂB
								optarg = argv[optind];
								//optind֐i߂B
								optind++;
								//|C^B
							//sv	scanptr = "";	ifubN̍ŏ̕ŁAɁuscanptr = "";vsĂ̂ŕsvB
								break;
							}
							goto L_LONG_OK;
						//"--name=(0ȏ)(I[)"Ɉvc
						} else if(scanptr[len] == '=') {
							//optoptɁAIvV̕Ԃli[B(G[̏ꍇKvȂ̂łŊi[ĂB)
							optopt = p->val;
							//IvV̎ނɂāc
							switch(p->has_arg) {
							default:DIE();
							case no_argument:
								//opterrZbgĂAG[bZ[W\B
								if(opterr != 0) { die("option '%s' doesn't allow an argument", p->name); };
								//'?'ԂB
								return '?';
							case required_argument:
							case optional_argument:
								//'='ȍ~̕(󕶎ł)AIvVƂB
								optarg = &scanptr[len + 1];
								//optind֐i߂B
								optind++;
								//|C^B
								scanptr = "";
								break;
							}
							goto L_LONG_OK;
						} else {
							//p
						}
					}
				}
				//opterrZbgĂAG[bZ[W\B
				if(opterr != 0) { die("illegal option '%s'", scanptr); };
				//'?'ԂB
				return '?';
L_LONG_OK:
				//longindexNULLłȂ΁AIvṼCfNXi[B
				if(longindex) { *longindex = p - longopts; }
				//IvV`flagtB[hNULLłȂ΁AflagwϐɒIvV̕Ԃli[A0ԂB
				if(p->flag) {
					*p->flag = p->val;
					return 0;
				}
				//IvV`flagtB[hNULLȂ΁AIvV̕ԂlԂB
				return p->val;
			}
		}
//}}2017/04/11ǉ:getopt_long()܂B
		/* optind֐i߂܂B */
		optind++;
		/* IvV͂I܂B */
		goto L_END;
	}
	/* |C^I[Ȃ΁Aoptind֐i߂Ă܂B */
	if(*scanptr == '\0') { optind++; }
	/* optstringAIvV܂B */
	optstring = strchr(optstring, optopt);
	/* optstring̒ɁAIvV΁c */
	if(optstring == NULL) {
		/* opterrZbgĂAG[bZ[W\܂B */
		if(opterr != 0) { die("illegal option '%c'", optopt); }
		/* '?'Ԃ܂B */
		return '?';
	}
    //{{2015/11/20RgύX:GNUg'IvVĂȂĂǂIvV'ɑΉ܂B
    //	/* IvVKvȃIvVȂ΁c */
    //2015/11/20RgύX:GNUg'IvVĂȂĂǂIvV'ɑΉ܂B
	/* IvVKvȃIvV,,IvVĂȂĂǂIvVȂ΁c */
    //}}2015/11/20RgύX:GNUg'IvVĂȂĂǂIvV'ɑΉ܂B
	if(*(optstring + 1) == ':') {
		/* |C^I[Ȃ΁c */
		if(*scanptr == '\0') {
    //{{2015/11/20ǉ:GNUg'IvVĂȂĂǂIvV'ɑΉ܂B
			/* IvVĂȂĂǂIvVȂ΁c */
			if(*(optstring + 2) == ':') {
				/* IvVԂ܂B */
				return optopt;
			}
    //}}2015/11/20ǉ:GNUg'IvVĂȂĂǂIvV'ɑΉ܂B
			/* optindXg𒴂Ăc */
			if((unsigned)optind >= (unsigned)argc) {
				/* optstring̐擪':'Ȃ΁AG[bZ[W\':'Ԃ܂B */
				if(optstring_first_character == ':') { return ':'; }
				/* opterrZbgĂAG[bZ[W\܂B */
				if(opterr != 0) { die("option '%c' requires an argument", optopt); }
				/* '?'Ԃ܂B */
				return '?';
			}
			/* |C^擾܂B */
			scanptr = argv[optind];
		}
		/* vf̎c蕶AIvVƂ܂B */
		optarg = scanptr;
		/* optind֐i߂܂B */
		optind++;
		/* |C^܂B */
		scanptr = "";
	}
	/* IvVԂ܂B */
	return optopt;
L_END:
	/* |C^܂B */
	scanptr = "";
	/* -1Ԃ܂B */
	return -1;
}

/*---------------------------------------------------------------------------*/
#if 0
/* getopt()̃eXg */
static void test(const char* cmdline, const char* optstring) {
	int c;
	int argc = 0;
	char* argv[10];
	char* tmp = strdup(cmdline);
	char* ptr = strtok(tmp, " ");
	while(ptr != NULL) { argv[argc++] = ptr; ptr = strtok(NULL, " "); }
	printf("--- %s ---\n", argv[0]);
	while((c = getopt(argc, argv, optstring)) != -1) {
		ptr = strchr(optstring, c);
		printf("%c %c %s\n", c, optopt, ((ptr != NULL) && (*(ptr + 1) == ':')) ? optarg : "");
	}
	while(optind < argc) { printf("[%d] %s\n", optind, argv[optind]); optind++; }
	free(tmp);
	optreset = optind = 1; //̈Zbg̕]̂߂ɁAďwĂ
}
int main() {
	//IvVʂɎw肷ၬ
	test("test1 -a -b one two", "ab");
	//
	//a a
	//b b
	//[3] one
	//[4] two
	//IvV܂Ƃ߂Ďw肷ၬ
	test("test2 -ab one two", "ab");
	//
	//a a
	//b b
	//[2] one
	//[3] two
	//"--"ŃIvV͂Iၬ
	test("test3 -a -- -b one two", "ab");
	//
	//a a
	//[3] -b
	//[4] one
	//[5] two
	//󔒖ŃIvVt^ၬ
	test("test4 -a -barg one two", "ab:");
	//
	//a a
	//b b arg
	//[3] one
	//[4] two
	//󔒗LŃIvVt^ၬ
	test("test5 -a -b arg one two", "ab:");
	//
	//a a
	//b b arg
	//[4] one
	//[5] two
	//IvVsĂ鎞̓(1)
	test("test6 -a", "a:");
	//
	//option 'a' requires an argument
	//? a
	//IvVsĂ鎞̓(2)
	test("test7 -a", ":a:");
	//
	//: a
    //{{2015/11/20ǉ:GNUg'IvVĂȂĂǂIvV'ɑΉ܂B
	//'IvVĂȂĂǂIvV'̗ၬ
	test("test8 -a -aone -a two", "a::");
	//                ~~~'IvVĂȂĂǂIvV'̏ꍇA󔒂ނƃIvVƌȂȂɒӂB
	//a a (null)
	//a a one
	//a a (null)
	//[4] two
    //}}2015/11/20ǉ:GNUg'IvVĂȂĂǂIvV'ɑΉ܂B
	return 0;
}
#endif
/*---------------------------------------------------------------------------*/
#if 0
//getopt_long()̃eXg
static void test(const char* cmdline, const char* optstring, const struct option* longopts) {
	int c, longindex = -1;
	char** argv = parse_cmdline(cmdline);
	int argc = strv_length(argv);
	printf("--- %s ---\n", argv[0]);
	while((c = getopt_long(argc, argv, optstring, longopts, &longindex)) != -1) {
		printf("%c %c %s %d\n",
			isprint(c) ? c : '_',
			isprint(optopt) ? optopt : '_',
			optarg ? optarg : "_",
			longindex);
	}
	while(optind < argc) { printf("[%d] %s\n", optind, argv[optind]); optind++; }
	strv_free(argv);
	optreset = optind = 1; //̈Zbg̕]̂߂ɁAďwĂ
}
int app_main(int argc, char* argv[]) {
	static int warn = -1;
	static const struct option longopts[] = {
	{ "zer", no_argument,       NULL, 'z' },
	{ "one", required_argument, NULL, 'o' },
	{ "two", optional_argument, NULL, 't' },
	{ "warn",    no_argument,   &warn, 0  },
	{ "no-warn", no_argument,   &warn, 1  },
	{0}};
	//IvV̒PƃeXg
	test("test1 --zer arg1 arg2 arg3", "", longopts);
	//
	//--- test1 ---
	//z z _ 0
	//[2] arg1
	//[3] arg2
	//[4] arg3
	test("test2 --one arg1 arg2 arg3", "", longopts);
	//
	//--- test2 ---
	//o o arg1 1
	//[3] arg2
	//[4] arg3
	test("test3 --one=arg1 arg2 arg3", "", longopts);
	//
	//--- test3 ---
	//o o arg1 1
	//[2] arg2
	//[3] arg3
	test("test4 --two arg1 arg2 arg3", "", longopts);
	//      
	//
	//--- test4 ---
	//t t _ 2
	//[2] arg1
	//[3] arg2
	//[4] arg3
	//IvV̕eXg
	test("test5 --two=arg1 arg2 arg3", "", longopts);
	//
	//--- test5 ---
	//t t arg1 2
	//[2] arg2
	//[3] arg3
	test("test6 --zer      --one arg1 arg2 arg3", "", longopts);
	//
	//--- test6 ---
	//z z _ 0
	//o o arg1 1
	//[4] arg2
	//[5] arg3
	test("test7 --one arg1 --two arg2 arg3",      "", longopts);
	//
	//--- test7 ---
	//o o arg1 1
	//t t _ 2
	//[4] arg2
	//[5] arg3
	test("test8 --two      --zer arg1 arg2 arg3", "", longopts);
	//
	//--- test8 ---
	//t t _ 2
	//z z _ 0
	//[3] arg1
	//[4] arg2
	//[5] arg3
	test("test9 --two arg1 --zer arg2 arg3",      "", longopts);
	//         ^IvV͂͂܂ŁB
	//--- test9 ---
	//t t _ 2
	//[2] arg1
	//[3] --zer
	//[4] arg2
	//[5] arg3
	test("testA --two=arg1 --one=arg2 arg3",      "", longopts);
	//
	//--- testA ---
	//t t arg1 2
	//o o arg2 1
	//[3] arg3
	//IvVƒZIvV̕eXg
	test("testB --zer      -x arg1 arg2 arg3", "x",  longopts);
	//
	//--- testB ---
	//z z _ 0
	//x x _ 0
	//[3] arg1
	//[4] arg2
	//[5] arg3
	test("testC --one arg1 -y arg2 arg3",      "y:", longopts);
	//         ^IvV͂͂܂ŁB
	//--- testC ---
	//o o arg1 1
	//y y arg2 1
	//[5] arg3
	test("testD -x      --zer arg1 arg2 arg3", "x",  longopts);
	//
	//--- testD ---
	//x x _ -1
	//z z _ 0
	//[3] arg1
	//[4] arg2
	//[5] arg3
	test("testE -y arg1 --one arg1 arg2 arg3", "y:", longopts);
	//
	//--- testE ---
	//y y arg1 -1
	//o o arg1 1
	//[5] arg2
	//[6] arg3
	//flagtB[h̎gpၬ
	test("testF --warn",    "", longopts);
	printf("warn = %d\n", warn);
	//
	//--- testF ---
	//_ _ _ 3
	//warn = 0
	test("testG --no-warn", "", longopts);
	printf("warn = %d\n", warn);
	//
	//--- testG ---
	//_ _ _ 4
	//warn = 1
	return 0;
}
#endif

/****************************************************************************
 *	getopt_long_only
 ****************************************************************************/

int getopt_long_only(int argc, char* const argv[], const char* optstring, const struct option* longopts, int* longindex); /*  */
