/*
 *	framtsp.c
 *
 *	DSP Group TrueSpeech Decoder
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Mon Jul 07 01:54:09 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Thu Jul 17 00:00:07 JST 2014 Naoyuki Sawa
 *	- t@C̑SĂ̊֐AZuAƏȃ܂B
 *	  CłƃAZułAlXȏŔrʂ́Aȉ̂Ƃł:
 *	  
 *	   107760ؕbTrueSpeechް޺ނ鎞 
 *	  
 *	                       C    ה  
 *	  
 *	  CPUۯބބ  ބ  
 *	  [MHz]zuzuބ[ؕb]ބ[ؕb]
 *	  
 *	    24  SRAMSRAM     31445     15885
 *	    48  SRAMSRAM     19844     10061
 *	    24  FRAMSRAM1716 160141204  9622
 *	    24  SRAMFRAM     27237     13290
 *	    48  FRAMFRAM      7006      4076őP̏CPU3.8%ł
 *	  
 */
#include "clip.h"

//
//W[gp̒ӎ@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//W[̍Đ[`́AX^bN̎gpʂ⑽߂łB(800oCg) @@@@@@@@@@@@
//@W[̋@\gpAvP[V́AX^bN𑽂߂ɊmۂĂB@@@@@@@@@
//@ڈƂẮAW[gpȂꍇA1LoCg炢mۂĂB @@@@@
//̓Iɂ́AL̎Oނ̃X^bNA߂ɊmۂĂ: @@@@@@@@@@@@@@@@@@@
//@@VXeX^bN@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@AvP[VMakefileSYSSTACKŒ`X^bNTCYłB@@@@@@@@@@@@@@@@@
//@A[U[X^bN@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@AvP[VMakefileUSRSTACKŒ`X^bNTCYłB@@@@@@@@@@@@@@@@@
//@@USRSTACK`Ȃꍇ́ARAM̎ceʂ[ł邱ƂmFĂB @@@@@@@@
//@B^XNX^bN@@!!v!!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@task_create()̈Ŏw肷X^bNTCYłB(^XN@\gpAvP[V̂) @@@
//@@ɂ̃X^bNꂽꍇɁA肵Â炢oOƂȂ̂ŁAӂĂB@@@@@@@
//@@X^bNꂽꍇ̏Ǐ̗ƂẮAtask_select()̒ŃAhXG[A @@@@@
//@@^XNXg𑀍삷ۂInsertTailList()̊֐̒ŃAhXG[܂B@@@@@@@
//W[̋@\gpAvP[V́Astack_switch_FRAM4gpȂłB@@@@@
//@FRAM4̃TCY512łAW[̍Đ[`̃X^bNgpʂłB@@@@@
//@X^bNFRAM4֐؂ւĂԂɁA荞݂Đ[`sƁAX^bN܂B 
//@A荞݂֎~ɂăX^bNFRAM4֐؂ւ邱Ƃ́A肠܂B @@@@@@@@@@
//

/****************************************************************************
 *	֐
 ****************************************************************************/
#ifndef PIECE
void TrueSpeech_DecodeFrame(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pWorkN, const uint32_t in[/*8*/], int16_t out[/*240*/]) {
	memcpy(pWorkV->prevfilt, pWorkN->cvector, sizeof(int16_t) * 8);
	TrueSpeech_ReadFrame(pWorkV, in);
	TrueSpeech_CorrelateFilter(pWorkV, pWorkN);
	TrueSpeech_FiltersMerge(pWorkV, pWorkN);

	memset(out, 0, sizeof(int16_t) * 240);
	pWorkV->quart = 0;
	do {
		TrueSpeech_ApplyTwopointFilter(pWorkV, pWorkN);
		TrueSpeech_PlacePulses(pWorkV, out);
		TrueSpeech_UpdateFilters(pWorkV, pWorkN, out);
		TrueSpeech_Synth(pWorkV, out);
		out += 60;
	} while(++pWorkV->quart < 4);
}
#else /*PIECE*/
void TrueSpeech_DecodeFrame(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pWorkN, const uint32_t in[/*8*/], int16_t out[/*240*/]);
asm("
		.code
		.align		1
		.global		TrueSpeech_DecodeFrame
TrueSpeech_DecodeFrame:
		pushn		%r3
		;//-------------------------------------------------------------;//
		ld.w		%r0, %r12					;//%r0  := pWorkV
		ld.w		%r1, %r13					;//%r1  := pWorkN
		ld.w		%r2, %r14					;//%r2  := in
		ld.w		%r3, %r15					;//%r3  := out
		;//%r0  := pWorkV
		;//%r1  := pWorkN
		;//%r2  := in
		;//%r3  := out
		;//-------------------------------------------------------------;//
		xadd		%r12, %r0, 64					;//%r12 := prevfilt
		xcall.d		memcpy						;//memcpy( prevfilt, cvector, 8 * sizeof(int16_t))	'%r13=pWorkN=cvector'ł
		ld.w		%r14, 16					;//%r14 :=                    8 * sizeof(int16_t)	*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=              pWorkV
		xcall.d		TrueSpeech_ReadFrame				;//TrueSpeech_ReadFrame(pWorkV, in);
		ld.w		%r13, %r2					;//%r13 :=                      in			*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=                    pWorkV
		xcall.d		TrueSpeech_CorrelateFilter			;//TrueSpeech_CorrelateFilter(pWorkV, pWorkN);
		ld.w		%r13, %r1					;//%r13 :=                            pWorkN		*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=                 pWorkV
		xcall.d		TrueSpeech_FiltersMerge				;//TrueSpeech_FiltersMerge(pWorkV, pWorkN);
		ld.w		%r13, %r1					;//%r13 :=                         pWorkN		*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r3					;//%r12 := out
		xld.w		%r14, 480					;//%r14 :=         240 * sizeof(int16_t)
		xcall.d		memset						;//memset( out, 0, 240 * sizeof(int16_t))
		ld.w		%r13, 0						;//%r13 :=      0					*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r4, 0						;//%r4  :=         quart = 0
		ld.h		[%r0], %r4					;//pWorkV->quart = quart
TrueSpeech_DecodeFrame_L1:							;//do {
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=                        pWorkV
		xcall.d		TrueSpeech_ApplyTwopointFilter			;//TrueSpeech_ApplyTwopointFilter(pWorkV, pWorkN)
		ld.w		%r13, %r1					;//%r13 :=                                pWorkN	*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=                pWorkV
		xcall.d		TrueSpeech_PlacePulses				;//TrueSpeech_PlacePulses(pWorkV, out)
		ld.w		%r13, %r3					;//%r13 :=                        out			*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=                  pWorkV
		ld.w		%r13, %r1					;//%r13 :=                          pWorkN
		xcall.d		TrueSpeech_UpdateFilters			;//TrueSpeech_UpdateFilters(pWorkV, pWorkN, out)
		ld.w		%r14, %r3					;//%r14 :=                                  out		*delay*
		;//-------------------------------------------------------------;//
		ld.w		%r12, %r0					;//%r12 :=          pWorkV
		xcall.d		TrueSpeech_Synth				;//TrueSpeech_Synth(pWorkV, out);
		ld.w		%r13, %r3					;//%r13 :=                  out				*delay*
		;//-------------------------------------------------------------;//
;//		xadd		%r3, %r3, 120					;//%r3  := out += 60 * sizeof(int16_t)	
		add		%r3, 60						;// 
		ld.h		%r4, [%r0]					;//%r4  :=         quart = pWorkV->quart	
		add		%r4, 1						;//%r4  :=         quart++			
		ld.h		[%r0], %r4					;//pWorkV->quart = quart			
		cmp		%r4, 4						;//} while(quart < 4)				
		jrlt.d		TrueSpeech_DecodeFrame_L1			;//						
		add		%r3, 60						;// 	*delay*
		;//-------------------------------------------------------------;//
		popn		%r3
		ret
");
#endif/*PIECE*/
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void TrueSpeech_ReadFrame(ST_TrueSpeechWorkV* pWorkV, const uint32_t in[/*8*/]) {
	uint16_t* p = (uint16_t*)in;
	unsigned t;

	// * ǏoA32rbgPʂłȂ16rbgPʂōsŔAwavt@C̍ĐT|[g邽߂łB
	// - wavt@CɑSēǍ񂾏ꍇAf[^ʒu[hACgĂȂB(mFς)
	//   RIFFt@C̎dlŁAe`ÑACgPʂ́A[hł͂ȂAn[t[hłB
	//   32rbgPʂŉroƁAsG[\B
	// - Appdt@CɑSēǍ񂾏ꍇ́AKf[^ʒu[hACgĂB
	//   ppdt@C̍ĐΉȂ΁A32rbgPʂŉroĂǂ̂A
	//   ́Appdt@Cwavt@C̗Ή邽߂ɁA16rbgPʂŉroƂɂB

	//[0]
	t  = *p++;
	t |= *p++ << 16;
	pWorkV->flag      =                          t & 0x00000001 ; t >>= 1;	//-------- -------- -------- -------x
	pWorkV->vector[0] = TBL_TrueSpeech_Codebook0[t & 0x0000001F]; t >>= 5;	//-------- -------- -------- --xxxxx-
	pWorkV->vector[1] = TBL_TrueSpeech_Codebook1[t & 0x0000001F]; t >>= 5;	//-------- -------- -----xxx xx------
	pWorkV->vector[2] = TBL_TrueSpeech_Codebook2[t & 0x0000000F]; t >>= 4;	//-------- -------- -xxxx--- --------
	pWorkV->vector[3] = TBL_TrueSpeech_Codebook3[t & 0x0000000F]; t >>= 4;	//-------- -----xxx x------- --------
	pWorkV->vector[4] = TBL_TrueSpeech_Codebook4[t & 0x0000000F]; t >>= 4;	//-------- -xxxx--- -------- --------
	pWorkV->vector[5] = TBL_TrueSpeech_Codebook5[t & 0x00000007]; t >>= 3;	//------xx x------- -------- --------
	pWorkV->vector[6] = TBL_TrueSpeech_Codebook6[t & 0x00000007]; t >>= 3;	//---xxx-- -------- -------- --------
	pWorkV->vector[7] = TBL_TrueSpeech_Codebook7[t             ];		//xxx----- -------- -------- --------
	//[1]
	t  = *p++;
	t |= *p++ << 16;
	pWorkV->offset2[0]  = t & 0x0000007F; t >>=  7;				//-------- -------- -------- -xxxxxxx
	pWorkV->offset2[1]  = t & 0x0000007F; t >>=  7;				//-------- -------- --xxxxxx x-------
	pWorkV->offset2[2]  = t & 0x0000007F; t >>=  7;				//-------- ---xxxxx xx------ --------
	pWorkV->offset2[3]  = t & 0x0000007F; t >>=  7;				//----xxxx xxx----- -------- --------
	pWorkV->offset1[0]  = t << 4;	//offset1[0]̃rbg[7:4]		//xxxx---- -------- -------- --------
	//[2]
	t  = *p++;
	t |= *p++ << 16;
	pWorkV->pulseval[0] = t & 0x00003FFF; t >>= 14;				//-------- -------- --xxxxxx xxxxxxxx
	pWorkV->pulseval[1] = t & 0x00003FFF; t >>= 14;				//----xxxx xxxxxxxx xx------ --------
	pWorkV->offset1[1]  = t;	//offset1[1]̃rbg[3:0]		//xxxx---- -------- -------- --------
	//[3]
	t  = *p++;
	t |= *p++ << 16;
	pWorkV->pulseval[2] = t & 0x00003FFF; t >>= 14;				//-------- -------- --xxxxxx xxxxxxxx
	pWorkV->pulseval[3] = t & 0x00003FFF; t >>= 14;				//----xxxx xxxxxxxx xx------ --------
	pWorkV->offset1[1] |= t << 4;	//offset1[1]̃rbg[7:4]		//xxxx---- -------- -------- --------
	//[4]
	t  = *p++;
	t |= *p++ << 16;
	pWorkV->pulseoff[0] = t & 0x0000000F; t >>=  4;				//-------- -------- -------- ----xxxx
	pWorkV->pulsepos[0] = t & 0x07FFFFFF; t >>= 27;				//-xxxxxxx xxxxxxxx xxxxxxxx xxxx----
	pWorkV->offset1[0] |= t;	//offset1[0]̃rbg[0]		//x------- -------- -------- --------
	//[5]
	t  = *p++;
	t |= *p++ << 16;
	pWorkV->pulseoff[1] = t & 0x0000000F; t >>=  4;				//-------- -------- -------- ----xxxx
	pWorkV->pulsepos[1] = t & 0x07FFFFFF; t >>= 27;				//-xxxxxxx xxxxxxxx xxxxxxxx xxxx----
	pWorkV->offset1[0] |= t << 1;	//offset1[0]̃rbg[1]		//x------- -------- -------- --------
	//[6]
	t  = *p++;
	t |= *p++ << 16;
	pWorkV->pulseoff[2] = t & 0x0000000F; t >>=  4;				//-------- -------- -------- ----xxxx
	pWorkV->pulsepos[2] = t & 0x07FFFFFF; t >>= 27;				//-xxxxxxx xxxxxxxx xxxxxxxx xxxx----
	pWorkV->offset1[0] |= t << 2;	//offset1[0]̃rbg[2]		//x------- -------- -------- --------
	//[7]
	t  = *p++;
	t |= *p++ << 16;
	pWorkV->pulseoff[3] = t & 0x0000000F; t >>=  4;				//-------- -------- -------- ----xxxx
	pWorkV->pulsepos[3] = t & 0x07FFFFFF; t >>= 27;				//-xxxxxxx xxxxxxxx xxxxxxxx xxxx----
	pWorkV->offset1[0] |= t << 3;	//offset1[0]̃rbg[3]		//x------- -------- -------- --------
}
#else /*PIECE*/
void TrueSpeech_ReadFrame(ST_TrueSpeechWorkV* pWorkV, const uint32_t in[/*8*/]);
asm("
		.code
		.align		1
		.global		TrueSpeech_ReadFrame
TrueSpeech_ReadFrame:
		;//-------------------------------------------------------------;//
		;//%r12 := &quart
		;//%r13 := in
		add		%r12, 2						;//%r12 := &flag
		ld.uh		%r4, [%r13]+					;//%r4  :=           t       = *p++
		ld.uh		%r5, [%r13]+					;//%r5  :=                hi = *p++
		xsll		%r5, 16						;//%r5  :=                hi <<= 16
		or		%r4, %r5					;//%r4  :=           t |= hi
		xand		%r5, %r4, 0x00000001				;//%r5  :=       x = t & 0x00000001
		ld.h		[%r12]+, %r5					;//flag       =  x
		srl		%r4, 1						;//%r4  :=           t >>= 1
		xand		%r5, %r4, 0x0000001F				;//%r5  :=       x = t & 0x0000001F
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook0@ah			;//
		ext		TBL_TrueSpeech_Codebook0@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook0[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 5						;//%r4  :=           t >>= 5					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[0]  =  x				@
;//		srl		%r4, 5						;//%r4  :=           t >>= 5			
		xand		%r5, %r4, 0x0000001F				;//%r5  :=       x = t & 0x0000001F
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook1@ah			;//
		ext		TBL_TrueSpeech_Codebook1@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook1[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 5						;//%r4  :=           t >>= 5					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[1]  =  x				@
;//		srl		%r4, 5						;//%r4  :=           t >>= 5			
		xand		%r5, %r4, 0x0000000F				;//%r5  :=       x = t & 0x0000000F
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook2@ah			;//
		ext		TBL_TrueSpeech_Codebook2@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook2[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 4						;//%r4  :=           t >>= 4					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[2]  =  x				@
;//		srl		%r4, 4						;//%r4  :=           t >>= 4			
		xand		%r5, %r4, 0x0000000F				;//%r5  :=       x = t & 0x0000000F
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook3@ah			;//
		ext		TBL_TrueSpeech_Codebook3@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook3[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 4						;//%r4  :=           t >>= 4					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[3]  =  x				@
;//		srl		%r4, 4						;//%r4  :=           t >>= 4			
		xand		%r5, %r4, 0x0000000F				;//%r5  :=       x = t & 0x0000000F
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook4@ah			;//
		ext		TBL_TrueSpeech_Codebook4@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook4[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 4						;//%r4  :=           t >>= 4					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[4]  =  x				@
;//		srl		%r4, 4						;//%r4  :=           t >>= 4			
		xand		%r5, %r4, 0x00000007				;//%r5  :=       x = t & 0x00000007
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook5@ah			;//
		ext		TBL_TrueSpeech_Codebook5@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook5[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 3						;//%r4  :=           t >>= 3					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[5]  =  x				@
;//		srl		%r4, 3						;//%r4  :=           t >>= 3			
		xand		%r5, %r4, 0x00000007				;//%r5  :=       x = t & 0x00000007
		sll		%r5, 1						;//%r5  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook6@ah			;//
		ext		TBL_TrueSpeech_Codebook6@al			;//%r5  :=       x = TBL_TrueSpeech_Codebook6[x]
		ld.h		%r5, [%r5]					;//
		srl		%r4, 3						;//%r4  :=       x = t >>= 3					*anti-interlock*
		ld.h		[%r12]+, %r5					;//vector[6]  =  x				@
;//		srl		%r4, 3						;//%r4  :=       x = t >>= 3			
		sll		%r4, 1						;//%r4  :=       x *= sizeof(short)
		ext		TBL_TrueSpeech_Codebook7@ah			;//
		ext		TBL_TrueSpeech_Codebook7@al			;//%r4  :=       x = TBL_TrueSpeech_Codebook7[x]
		ld.h		%r4, [%r4]					;//
		ld.w		%r7, 0						;//%r7  := z = 0						*anti-interlock*
		ld.h		[%r12]+, %r4					;//vector[7]  =  x				@
		;//-------------------------------------------------------------;//						@
		;//%r12 := &offset1[0]												@
		;//%r13 := in													@
		add		%r12, 4						;//%r12 := &offset2[0]				@
		ld.uh		%r6, [%r13]+					;//%r6  :=           t       = *p++		@
		ld.uh		%r5, [%r13]+					;//%r5  :=                hi = *p++		@
		xsll		%r5, 16						;//%r5  :=                hi <<= 16		@
		or		%r6, %r5					;//%r6  :=           t |= hi			@
		xand		%r5, %r6, 0x0000007F				;//%r5  :=       y = t & 0x0000007F		@
		ld.h		[%r12]+, %r5					;//offset2[0]  = y				@
		srl		%r6, 7						;//%r6  :=           t >>= 7			@
		xand		%r5, %r6, 0x0000007F				;//%r5  :=       y = t & 0x0000007F		@
		ld.h		[%r12]+, %r5					;//offset2[1]  = y				@
		srl		%r6, 7						;//%r6  :=           t >>= 7			@
		xand		%r5, %r6, 0x0000007F				;//%r5  :=       y = t & 0x0000007F		@
		ld.h		[%r12]+, %r5					;//offset2[2]  = y				@
		srl		%r6, 7						;//%r6  :=           t >>= 7			@
		xand		%r5, %r6, 0x0000007F				;//%r5  :=       y = t & 0x0000007F		@
		ld.h		[%r12]+, %r5					;//offset2[3]  = y				@
		srl		%r6, 7						;//%r6  :=       y = t >>= 7			@
		;//%r6  := y =  offset1[0][7:4]											@
		;//-------------------------------------------------------------;//						@
		;//%r6  := y =  offset1[0][7:4]											@
		;//%r12 := &pulseval[0]												@
		;//%r13 := in													@
;//		ld.w		%r7, 0						;//%r7  := z = 0				
		ld.w		%r9, 8						;//%r9  := i = (4*2)
TrueSpeech_ReadFrame_L1:							;//do {
		ld.uh		%r4, [%r13]+					;//%r4  :=           t       = *p++
		ld.uh		%r5, [%r13]+					;//%r5  :=                hi = *p++
		xsll		%r5, 16						;//%r5  :=                hi <<= 16
		or		%r4, %r5					;//%r4  :=           t |= hi
		xand		%r5, %r4, 0x00003FFF				;//%r5  :=       x = t & 0x00003FFF
		ld.h		[%r12]+, %r5					;//pulseval[0] = x						pulseval[2]
		xsrl		%r4, 14						;//%r4  :=           t >>= 14
		xand		%r5, %r4, 0x00003FFF				;//%r5  :=       x = t & 0x00003FFF
		ld.h		[%r12]+, %r5					;//pulseval[1] = x						pulseval[3]
		xsrl		%r4, 14						;//%r4  :=           t >>= 14
		rr		%r4, %r9					;//%r4  :=           t >>= i
		sub		%r9, 4						;//%r9  := i -= 4
		jrne.d		TrueSpeech_ReadFrame_L1				;//} while(i)
		or		%r7, %r4					;//%r7  := z  |=     t						*delay*
		;//%r7  := z = (offset1[1] rr 8)
		rl		%r7, 8						;//%r7  := z rl= 8
		;//%r7  := z =  offset1[1]
		;//-------------------------------------------------------------;//
		;//%r6  := y =  offset1[0][7:4]
		;//%r7  := z =  offset1[1]
		;//%r12 := &pulseoff[0]
		;//%r13 := in
		xadd		%r14, %r12, 8					;//%r14 := &pulsepos[0]
		ld.w		%r9, 8						;//%r9  := i = 1<<(4-1)						%psr(C)ωȂ߂ɁA[vJE^ɃVtgpB
TrueSpeech_ReadFrame_L2:							;//do {
		ld.uh		%r4, [%r13]+					;//%r4  :=           t       = *p++
		ld.uh		%r5, [%r13]+					;//%r5  :=                hi = *p++
		xsll		%r5, 16						;//%r5  :=                hi <<= 16
		or		%r4, %r5					;//%r4  :=           t |= hi
		xand		%r5, %r4, 0x0000000F				;//%r5  :=       x = t & 0x0000000F
		ld.h		[%r12]+, %r5					;//pulseoff[0] = x						pulseoff[1]	pulseoff[2]	pulseoff[3]
		add		%r4, %r4					;//%r4  :=           t <<=  1, %psr(C) = c	
		srl		%r4, 5						;//%r4  :=           t >>= (1+4)		@
		ld.w		[%r14]+, %r4					;//pulsepos[0] =     t				@		pulsepos[1]	pulsepos[2]	pulsepos[3]
		srl		%r9, 1						;//%r9  := i >>= 1				@		%psr(C)ωȂ߂ɁA[vJE^ɃVtgpB
		jrne.d		TrueSpeech_ReadFrame_L2				;//} while(i)					@
		adc		%r6, %r6					;//%r6  := y =  (y << 1) |               c			*delay*
		;//%r6  := y = (offset1[0][7:4] << 4) | offset1[0][0:3]
		mirror		%r9, %r6					;//%r9 :=                             (offset1[0][3:0] << 4)
		srl		%r9, 4						;//%r9 :=                              offset1[0][3:0]
		and		%r6, -16					;//%r6 := y = (offset1[0][7:4] << 4)
		or		%r6, %r9					;//%r6 := y = (offset1[0][7:4] << 4) | offset1[0][3:0]
		;//%r6  := y =  offset1[0]
		;//-------------------------------------------------------------;//
		;//%r6  := y =  offset1[0]
		;//%r7  := z =  offset1[1]
		;//%r12 := &pulsepos[0]
		sub		%r12, 28					;//%r12 := &offset1[0]
		ld.h		[%r12]+, %r6					;//offset1[0] = y
		ld.h		[%r12]+, %r7					;//offset1[1] = z
		;//-------------------------------------------------------------;//
		ret
");
#endif/*PIECE*/
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void TrueSpeech_CorrelateFilter(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pWorkN) {
	int16_t tmpbuf[8], *ptmp, *pvec, *pcvec1, *pcvec2;
	int i, j, vec;

	pvec   = pWorkV->vector;
	pcvec1 = pWorkN->cvector;
	for(i = 0; i < 8; i++) {
		vec = *pvec++;
		if(i) {
			ptmp = memcpy(tmpbuf, pWorkN->cvector, sizeof(int16_t) * i);
			ptmp += (i - 1);	//=&tmpbuf[i - 1]
			pcvec2 = pWorkN->cvector;
			j = i;
			do {
				*pcvec2++ += (*ptmp * vec) >> 15;	//asmłmlt.hgB
				ptmp--;	//asmłł͒xXbgɓB
			} while(--j);
		}
		*pcvec1++ = -(vec >> 3);
	}
}
#else /*PIECE*/
void TrueSpeech_CorrelateFilter(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pWorkN);
asm("
		.code
		.align		1
		.global		TrueSpeech_CorrelateFilter
TrueSpeech_CorrelateFilter:
		pushn		%r3
		xsub		%sp, %sp, 20
		;//-------------------------------------------------------------;//
		xld.w		[%sp+16], %r13					;//[%sp+16] := cvector = pWorkN
		xadd		%r0, %r12, 4					;//%r0      := pvec    = vector
		ld.w		%r1, %r13					;//%r1      := pcvec1  = cvector
		ld.w		%r2, 0						;//%r2      := i = 0
		;//%r0      := pvec
		;//%r1      := pcvec1
		;//%r2      := i
		;//[%sp+ 0] := tmpbuf[8]
		;//[%sp+16] := cvector
TrueSpeech_CorrelateFilter_L1:
		ld.h		%r3, [%r0]+					;//%r3  := vec = *pvec++;
		cmp		%r2, 0						;//if(i) {
		jreq		TrueSpeech_CorrelateFilter_L2			;//
		;//-------------------------------------------------------------;//
		ld.w		%r12, %sp					;//%r12 :=               tmpbuf
		xld.w		%r13, [%sp+16]					;//%r13 :=                       cvector
		ld.w		%r14, %r2					;//%r14 :=                                i
		xcall.d		memcpy						;//%r10 := ptmp = memcpy(tmpbuf, cvector, i * sizeof(int16_t))
		sll		%r14, 1						;//%r14 :=                                i * sizeof(int16_t)	*delay*
		sub		%r10, 2						;//%r10 :=        ptmp + (    - 1) * sizeof(int16_t)
		add		%r10, %r2					;//%r10 :=        ptmp + (i/2 - 1) * sizeof(int16_t)
		add		%r10, %r2					;//%r10 := ptmp = ptmp + (i   - 1) * sizeof(int16_t)
		xld.w		%r4, [%sp+16]					;//%r4  := pcvec2 = cvector
		ld.w		%r5, %r2					;//%r5  := j = i
TrueSpeech_CorrelateFilter_L3:							;//
		ld.h		%r6, [%r10]					;//%r6  := *ptmp
		ld.h		%r7, [%r4]					;//%r7  := *pcvec2						*anti-interlock*
		mlt.h		%r6, %r3					;//%alr :=              *ptmp * vec
		ld.w		%r6, %alr					;//%r6  :=              *ptmp * vec
		xsra		%r6, 15						;//%r6  :=             (*ptmp * vec) >> 15
		add		%r7, %r6					;//%r7  := *pcvec2 +  ((*ptmp * vec) >> 15)
		ld.h		[%r4]+, %r7					;//%r7  := *pcvec2 += ((*ptmp * vec) >> 15)
		sub		%r5, 1						;//%r5  := j--
		jrne.d		TrueSpeech_CorrelateFilter_L3			;//} while(j)
		sub		%r10, 2						;//%r10 := ptmp--						*delay*
		;//-------------------------------------------------------------;//
TrueSpeech_CorrelateFilter_L2:							;//
		sra		%r3, 3						;//
		not		%r3, %r3					;//%r3  :=     -(vec >> 3)
		add		%r3, 1						;//
		ld.h		[%r1]+, %r3					;//*pcvec1++ = -(vec >> 3)
		cmp		%r2, 7						;//} while(i < (8 - 1))
		jrlt.d		TrueSpeech_CorrelateFilter_L1			;//
		add		%r2, 1						;//%r2  := i++							*delay*
		;//-------------------------------------------------------------;//
		xadd		%sp, %sp, 20
		popn		%r3
		ret
");
#endif/*PIECE*/
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void TrueSpeech_FiltersMerge(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pWorkN) {
	int16_t *pflt1, *pflt2, *pcvec, *pprev;
	int i, cvec, prev;

	pflt1 = pWorkV->filters[0];
	pflt2 = pflt1 + 8;	//=filters[1]
	pcvec = pWorkN->cvector;
	pprev = pWorkV->prevfilt;
	i = 8;
	if(pWorkV->flag) {
		do {
			cvec = *pcvec++;
			prev = *pprev++;
			*pflt1++ = (cvec * 21846 + prev * 10923) >> 15;	//asmłmlt.hgB
			*pflt2++ = (cvec * 10923 + prev * 21846) >> 15;	//asmłmlt.hgB
		} while(--i);
		pcvec -= 8;	//=cvector
	} else {
		do {
			prev = *pprev++;
			*pflt1++ = prev;
			*pflt2++ = prev;
		} while(--i);
	}

	pflt1 = pflt2;		//=filters[2]
	pflt2 = pflt1 + 8;	//=filters[3]
	i = 8;
	do {
		cvec = *pcvec++;
		*pflt1++ = cvec;
		*pflt2++ = cvec;
	} while(--i);
}
#else /*PIECE*/
void TrueSpeech_FiltersMerge(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pWorkN);
asm("
		.code
		.align		1
		.global		TrueSpeech_FiltersMerge
TrueSpeech_FiltersMerge:
		;//-------------------------------------------------------------;//
		;//%r12 := pWorkV
		;//%r13 := pcvec = cvector = pWorkN
		xadd		%r4, %r12, 80					;//%r4  := pflt1 = pWorkV->filters[0]
		xadd		%r5, %r4, 16					;//%r5  := pflt2 = pflt1 + 8 * sizeof(int16_t)
		xadd		%r6, %r12, 64					;//%r6  := pprev = pWorkV->prevfilt
		xbtst		[%r12+2], 0					;//if(flag) {
		jreq.d		TrueSpeech_FiltersMerge_L2			;//
		ld.w		%r10, 8						;//%r10 := i = 8					*delay*
		;//-------------------------------------------------------------;//
		;//%r4  := pflt1
		;//%r5  := pflt2
		;//%r6  := pprev
		;//%r13 := pcvec
		xld.w		%r7, 21846					;//%r7  := 21846
		xld.w		%r9, 10923					;//%r9  := 10923
TrueSpeech_FiltersMerge_L1:							;//do {
		ld.h		%r11, [%r13]+					;//%r11 :=     cvec = *pcvec++
		ld.h		%r12, [%r6]+					;//%r12 :=                    prev = *pprev++
		mlt.h		%r11, %r7					;//%alr :=     cvec * 21846
		ld.w		%r14, %alr					;//%r14 :=     cvec * 21846
		mlt.h		%r12, %r9					;//%alr :=                    prev * 10923
		ld.w		%r15, %alr					;//%r15 :=                    prev * 10923
		add		%r14, %r15					;//%r14 :=    (cvec * 21846 + prev * 10923)
		xsra		%r14, 15					;//%r14 :=    (cvec * 21846 + prev * 10923) >> 15
		ld.h		[%r4]+, %r14					;//*pflt1++ = (cvec * 21846 + prev * 10923) >> 15
		mlt.h		%r11, %r9					;//%alr :=     cvec * 10923
		ld.w		%r14, %alr					;//%r14 :=     cvec * 10923
		mlt.h		%r12, %r7					;//%alr :=                    prev * 21846
		ld.w		%r15, %alr					;//%r15 :=                    prev * 21846
		add		%r14, %r15					;//%r14 :=    (cvec * 10923 + prev * 21846)
		xsra		%r14, 15					;//%r14 :=    (cvec * 10923 + prev * 21846) >> 15
		ld.h		[%r5]+, %r14					;//*pflt2++ = (cvec * 10923 + prev * 21846) >> 15
		sub		%r10, 1						;//%r10 := i--
		jrne		TrueSpeech_FiltersMerge_L1			;//} while(i)
		jp.d		TrueSpeech_FiltersMerge_L3			;//
		sub		%r13, 16					;//%r13 := pcvec -= 8 * sizeof(int16_t)			*delay*
		;//-------------------------------------------------------------;//} else {
TrueSpeech_FiltersMerge_L2:							;//
		ld.h		%r11, [%r6]+					;//%r11 :=    prev = *pprev++
		ld.h		[%r4]+, %r11					;//*pflt1++ = prev
		ld.h		[%r5]+, %r11					;//*pflt2++ = prev
		sub		%r10, 1						;//%r10 := i--
		jrne		TrueSpeech_FiltersMerge_L2			;//} while(i)
		;//-------------------------------------------------------------;//
TrueSpeech_FiltersMerge_L3:							;//}
		;//%r5  := pflt1 = pflt2
		;//%r13 := pcvec
		xadd		%r4, %r5, 16					;//%r4  := pflt2 = pflt1 + 8 * sizeof(int16_t)
		ld.w		%r10, 8						;//%r10 := i = 8
		;//-------------------------------------------------------------;//
TrueSpeech_FiltersMerge_L4:
		ld.h		%r11, [%r13]+					;//%r11 :=    cvec = *pcvec++
		ld.h		[%r5]+, %r11					;//*pflt1++ = cvec
		ld.h		[%r4]+, %r11					;//*pflt2++ = cvec
		sub		%r10, 1						;//%r10 := i--
		jrne		TrueSpeech_FiltersMerge_L4			;//} while(i)
		;//-------------------------------------------------------------;//
		ret
");
#endif/*PIECE*/
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void TrueSpeech_ApplyTwopointFilter(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pWorkN) {
	int16_t tmpbuf[60 + 86 + 60], *ptr1, *ptr2, *pnv;
	const int16_t* ptr3;
	int i, t;

	if((t = pWorkV->offset2[pWorkV->quart]) == 127) {
		memset(pWorkV->newvec, 0, sizeof(int16_t) * 60);
		return;
	}
	ptr1 = memcpy(tmpbuf, pWorkN->filtbuf, sizeof(int16_t) * (60 + 86));	//tmpbuf[(60+86)`(60+86+60-1)]͕sō\ȂBptr2ǏoOɁAptr1ނB
	ptr1 += (60 + 86);	//=&tmpbuf[60 + 86]
	ptr2 = ptr1 - (pWorkV->offset1[pWorkV->quart >> 1] + (t / 25) + (18 + 1));
	ptr3 = TBL_TrueSpeech_Order2Coeffs[t % 25];
	pnv  = pWorkV->newvec;
	i = 60;
	do {
		t = (ptr2[0] * ptr3[0]) + (ptr2[1] * ptr3[1]);	//asmłmacgB		:macgȂBJԂ񐔂ȂAmacgȂptr3[0]ptr3[1]WX^ɒu邩B
		t >>= 14;
		*ptr1++ = t;
		*pnv++  = t;
		ptr2++;
	} while(--i);
}
#else /*PIECE*/
void TrueSpeech_ApplyTwopointFilter(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pWorkN);
asm("
		.code
		.align		1
		.global		TrueSpeech_ApplyTwopointFilter
TrueSpeech_ApplyTwopointFilter:
		pushn		%r1
		xsub		%sp, %sp, 412
		;//-------------------------------------------------------------;//
		;//%r12    := pWorkV
		;//%r13    := pWorkN
		;//[%sp+0] := tmpbuf[60+86+60]
		ld.h		%r4, [%r12]					;//%r4  :=             quart
		ld.w		%r0, %r12					;//%r0  := pWorkV								*anti-interlock*
		sll		%r4, 1						;//%r4  :=             quart * sizeof(int16_t)
		add		%r4, %r12					;//%r4  :=             quart * sizeof(int16_t) + pWorkV
		xld.h		%r1, [%r4+24]					;//%r1  := t = offset2[quart]
		xcmp		%r1, 127					;//if(t == 127) {
		jrne		TrueSpeech_ApplyTwopointFilter_L1		;//
		xadd		%r12, %r12, 144					;//%r12 := newvec
		xld.w		%r14, 120					;//%r14 :=            sizeof(int16_t) * 60
		xcall.d		memset						;//memset( newvec, 0, sizeof(int16_t) * 60)
		ld.w		%r13, 0						;//%r13 :=         0								*delay*
		jp		TrueSpeech_ApplyTwopointFilter_L2		;//
TrueSpeech_ApplyTwopointFilter_L1:						;//}
		;//-------------------------------------------------------------;//
		;//%r0     := pWorkV
		;//%r1     := t
		;//%r13    := pWorkN
		;//[%sp+0] := tmpbuf[60+86+60]
		ld.w		%r12, %sp					;//%r12 :=               tmpbuf
		xld.w		%r14, 292					;//%r14 :=                                sizeof(int16_t) * (60 + 86)
		xcall.d		memcpy						;//%r10 := ptr1 = memcpy(tmpbuf, filtbuf, sizeof(int16_t) * (60 + 86))
		add		%r13, 16					;//%r13 :=                       filtbuf					*delay*
		ld.h		%r7, [%r0]					;//%r7  :=                        quart
		xadd		%r4, %r10, 292					;//%r4  := ptr1 += (60 + 86)							*anti-interlock*
		and		%r7, -2						;//%r7  :=                       (quart >> 1) * sizeof(int16_t)
		add		%r7, %r0					;//%r7  :=                       (quart >> 1) * sizeof(int16_t) + pWorkV
		xld.h		%r7, [%r7+20]					;//%r7  :=                offset1[quart >> 1]
		ld.w		%r12, %r1					;//%r12 :=                                       t
		xcall.d		__divsi3					;//%r10 :=                                      (t / 25), %ahr = (t % 25)	__divsi3'%r9,%r10,%alr,%ahr,%psr'ȊÕWX^j󂵂ȂB__divsi3ԂA'%ahr'ɏ]ĂBclipidiv.sQƂB
		ld.w		%r13, 25					;//%r13 :=                                           25				*delay*
		add		%r7, %r10					;//%r7  :=                offset1[quart >> 1] + (t / 25)
		add		%r7, 19						;//%r7  :=                offset1[quart >> 1] + (t / 25) + (18 + 1)
		sll		%r7, 1						;//%r7  :=               (offset1[quart >> 1] + (t / 25) + (18 + 1)) * sizeof(int16_t)
		ld.w		%r5, %r4					;//%r5  :=        ptr1
		sub		%r5, %r7					;//%r5  := ptr2 = ptr1 - (offset1[quart >> 1] + (t / 25) + (18 + 1))
		ld.w		%r7, %ahr					;//%r7  :=                                      (t % 25)
		sll		%r7, 2						;//%r7  :=                                      (t % 25) * (sizeof TBL_TrueSpeech_Order2Coeffs[0])
		ext		TBL_TrueSpeech_Order2Coeffs+0@ah		;//
		ext		TBL_TrueSpeech_Order2Coeffs+0@al		;//%r6  := ptr3[0]
		ld.h		%r6, [%r7]					;//
		ext		TBL_TrueSpeech_Order2Coeffs+2@ah		;//
		ext		TBL_TrueSpeech_Order2Coeffs+2@al		;//%r7  := ptr3[1]
		ld.h		%r7, [%r7]					;//
		xadd		%r0, %r0, 144					;//%r0  := pnv  = newvec							*anti-interlock*
		;//-------------------------------------------------------------;//
		;//%r0  := pnv
		;//%r4  := ptr1
		;//%r5  := ptr2
		;//%r6  := ptr3[0]
		;//%r7  := ptr3[1]
		xld.w		%r9, 60						;//%r9  := i = 60
		ld.h		%r12, [%r5]+					;//%r12 :=      ptr2[0]
TrueSpeech_ApplyTwopointFilter_L3:						;//do {
		ld.h		%r13, [%r5]+					;//%r13 :=                            ptr2[1]	
		mlt.h		%r12, %r6					;//%alr :=     (ptr2[0] * ptr3[0])				Õ[vptr2[1]Ã[vptr2[0]Ɏg񂵂āAANZX팸B
		ld.w		%r14, %alr					;//%r14 :=     (ptr2[0] * ptr3[0])				@ptr1ptr2(18+1)ȏ㗣ĂAptr1ւ݂̏Ã[vptr2ɉe鎖͖B
		mlt.h		%r13, %r7					;//%alr :=                           (ptr2[1] * ptr3[1])	@
		ld.w		%r15, %alr					;//%r15 :=                           (ptr2[1] * ptr3[1])	@
		add		%r14, %r15					;//%r14 := t = (ptr2[0] * ptr3[0]) + (ptr2[1] * ptr3[1])	@
		xsra		%r14, 14					;//%r14 := t >>= 14						@
		ld.h		[%r4]+, %r14					;//*ptr1++ = t							@
		ld.h		[%r0]+, %r14					;//*pnv++  = t							@
		sub		%r9, 1						;//%r9  := i--							@
		jrne.d		TrueSpeech_ApplyTwopointFilter_L3		;//} while(i)							@
		ld.w		%r12, %r13					;//%r12 :=      ptr2[0]             = ptr2[1]					*delay*
		;//-------------------------------------------------------------;//
TrueSpeech_ApplyTwopointFilter_L2:
		xadd		%sp, %sp, 412
		popn		%r1
		ret
");
#endif/*PIECE*/
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void TrueSpeech_PlacePulses(ST_TrueSpeechWorkV* pWorkV, int16_t out[/*60*/]) {
	int16_t tmpbuf[7], *ptmp;
	const int16_t* ppv;
	int pval, poff, coef;
	int i, t, ntmp;

	//pXB
	pval = pWorkV->pulseval[pWorkV->quart];
	poff = pWorkV->pulseoff[pWorkV->quart];
	ptmp = &tmpbuf[7];
	i = 7;
	do {
		*--ptmp = TBL_TrueSpeech_PulseScales[poff][pval & 3];
		pval >>= 2;	//asmłł͒xXbgɓB
	} while(--i);

	//out[0`29]ɃpXzuB
	coef = pWorkV->pulsepos[pWorkV->quart] >> 15;
	ppv  = TBL_TrueSpeech_PulseValues[1];
//sv	ptmp = &tmpbuf[0];	//̃[vI'ptmp=&tmpbuf[0]'ɂȂĂBIȍĐݒ͕svłB
	ntmp = 3;
	i = 30;
	do {
		if((coef -= (t = *ppv++)) < 0) {
			coef += t;
			ppv += 30;
			*out = *ptmp++;
			if(!--ntmp) { break; }
		}
		out++;	//asmłł͒xXbgɓB
	} while(--i);

	out += i;

	//out[30`59]ɃpXzuB
	coef = pWorkV->pulsepos[pWorkV->quart] & ((1<<15)-1);
	ppv  = TBL_TrueSpeech_PulseValues[0];
	ptmp = &tmpbuf[3];
	ntmp = 4;
	i = 30;
	do {
		if((coef -= (t = *ppv++)) < 0) {
			coef += t;
			ppv += 30;
			*out = *ptmp++;
			if(!--ntmp) { break; }
		}
		out++;	//asmłł͒xXbgɓB
	} while(--i);
}
#else /*PIECE*/
void TrueSpeech_PlacePulses(ST_TrueSpeechWorkV* pWorkV, int16_t out[/*60*/]);
asm("
		.code
		.align		1
		.global		TrueSpeech_PlacePulses
TrueSpeech_PlacePulses:
		xsub		%sp, %sp, 16
		;//-------------------------------------------------------------;//
		ld.h		%r9, [%r12]					;//%r9  :=                 quart
		ld.w		%r7, 7						;//%r7  := i = 7		*anti-interlock*
		sll		%r9, 1						;//%r9  :=                 quart * sizeof(int16_t)						
		add		%r12, %r9					;//%r12 :=        pWorkV + quart * sizeof(int16_t)						
		xld.h		%r4, [%r12+32]					;//%r4  := pval = pulseval[quart]								
		xld.h		%r5, [%r12+40]					;//%r5  := poff = pulseoff[quart]									*anti-interlock*
		add		%r12, %r9					;//%r12 :=        pWorkV + quart * sizeof(int32_t)						
		xld.w		%r12, [%r12+48]					;//%r12 := ppos = pulsepos[quart]								
		;//%r4        := pval = pulseval[quart]																
		;//%r5        := poff = pulseoff[quart]																
		;//%r12       := ppos = pulsepos[quart]																
		;//%r13       := out																		
		;//[%sp+ 0]   := tmpbuf[7]																	
		;//[%sp+14].h := (pfBO)																	
		sll		%r4, 1						;//%r4  := ( pval      * sizeof(int16_t))								*anti-interlock*
		sll		%r5, 3						;//%r5  :=                                  (poff * sizeof TBL_TrueSpeech_PulseScales[0])	
		xadd		%r6, %sp, 14					;//%r6  := ptmp = &tmpbuf[7]									
;//		ld.w		%r7, 7						;//%r7  := i = 7	
TrueSpeech_PlacePulses_L1:							;//do {
		xand		%r9, %r4, 6					;//%r9  := ((pval & 3) * sizeof(int16_t))
		add		%r9, %r5					;//%r9  := ((pval & 3) * sizeof(int16_t)) + (poff * sizeof TBL_TrueSpeech_PulseScales[0])
		ext		TBL_TrueSpeech_PulseScales@ah			;//
		ext		TBL_TrueSpeech_PulseScales@al			;//%r9  := TBL_TrueSpeech_PulseScales[poff][pval & 3]
		ld.h		%r9, [%r9]					;//
		sub		%r6, 2						;//%r6  := ptmp--											*anti-interlock*
		ld.h		[%r6], %r9					;//       *ptmp = TBL_TrueSpeech_PulseScales[poff][pval & 3]
		sub		%r7, 1						;//%r7  := i--
		jrne.d		TrueSpeech_PlacePulses_L1			;//} while(i)
		sra		%r4, 2						;//%r4  := pval >>= 2											*delay*
		;//-------------------------------------------------------------;//
		;//%r6        := ptmp = &tmpbuf[0]
		;//%r12       := ppos = pulsepos[quart]
		;//%r13       := out
		;//[%sp+ 0]   := tmpbuf[7]
		;//[%sp+14].h := (pfBO)
		ld.w		%r14, %r12					;//%r14 :=        ppos = pulsepos[quart]
		xsra		%r14, 15					;//%r14 := coef = ppos >> 15
		xld.w		%r4, TBL_TrueSpeech_PulseValues+60		;//%r4  := ppv  = TBL_TrueSpeech_PulseValues[1]
		ld.w		%r5, 3						;//%r5  := ntmp = 3
		ld.w		%r7, 30						;//%r7  := i = 30
TrueSpeech_PlacePulses_L2:							;//do {
		ld.h		%r9, [%r4]+					;//%r9  :=         t = *ppv++
		sub		%r14, %r9					;//%r14 := coef -= t
		jrge		TrueSpeech_PlacePulses_L3			;//if(     coef < 0) {
		add		%r14, %r9					;//%r14 := coef += t
		add		%r4, 60						;//%r4  := ppv  += 30 * sizeof(int16_t)
		ld.h		%r9, [%r6]+					;//%r6  := x = *ptmp++
		ld.h		[%r13], %r9					;//*out  = x
		sub		%r5, 1						;//%r5  := ntmp--
		jreq		TrueSpeech_PlacePulses_L4			;//if(    !ntmp) { break }
TrueSpeech_PlacePulses_L3:							;//}
		sub		%r7, 1						;//%r7  := i--
		jrne.d		TrueSpeech_PlacePulses_L2			;//} while(i)
		add		%r13, 2						;//%r13 := out++											*delay*
TrueSpeech_PlacePulses_L4:							;//
		sll		%r7, 1						;//%r7  :=        i * sizeof(int16_t)
		add		%r13, %r7					;//%r7  := out += i
		;//-------------------------------------------------------------;//
		;//%r12       := ppos = pulsepos[quart]
		;//%r13       := out
		;//[%sp+ 0]   := tmpbuf[7]
		;//[%sp+14].h := (pfBO)
		xand		%r12, %r12, 0x7FFF				;//%r12 := coef = ppos & ((1<<15)-1)
		xld.w		%r4, TBL_TrueSpeech_PulseValues			;//%r4  := ppv  = TBL_TrueSpeech_PulseValues[0]
		xadd		%r6, %sp, 6					;//%r6  := ptmp = &tmpbuf[3]
		ld.w		%r5, 4						;//%r5  := ntmp = 4
		ld.w		%r7, 30						;//%r7  := i = 30
TrueSpeech_PlacePulses_L5:							;//do {
		ld.h		%r9, [%r4]+					;//%r9  :=         t = *ppv++
		sub		%r12, %r9					;//%r12 := coef -= t
		jrge		TrueSpeech_PlacePulses_L6			;//if(     coef < 0) {
		add		%r12, %r9					;//%r12 := coef += t
		add		%r4, 60						;//%r4  := ppv  += 30 * sizeof(int16_t)
		ld.h		%r9, [%r6]+					;//%r9  := x = *ptmp++
		ld.h		[%r13], %r9					;//*out  = x
		sub		%r5, 1						;//%r5  := ntmp--
		jreq		TrueSpeech_PlacePulses_L7			;//if(    !ntmp) { break }
TrueSpeech_PlacePulses_L6:							;//}
		sub		%r7, 1						;//%r7  := i--
		jrne.d		TrueSpeech_PlacePulses_L5			;//} while(i)
		add		%r13, 2						;//%r13 := out++											*delay*
TrueSpeech_PlacePulses_L7:							;//
		;//-------------------------------------------------------------;//
		xadd		%sp, %sp, 16
		ret
");
#endif/*PIECE*/
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void TrueSpeech_UpdateFilters(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pWorkN, int16_t out[/*60*/]) {
	int16_t *pfb, *pnv;
	int i, x, y;

	pfb = memcpy(&pWorkN->filtbuf[0], &pWorkN->filtbuf[60], sizeof(int16_t) * 86);	//Oւ̏dړȂ̂memmovesvB
	pfb += 86;	//=&filtbuf[86]
	pnv = pWorkV->newvec;
	i = 60;
	do {
		x = *out;
		y = *pnv++;
		x += y;
		*out++ = x;
		x -= y >> 3;
		*pfb++ = x;
	} while(--i);
}
#else /*PIECE*/
void TrueSpeech_UpdateFilters(ST_TrueSpeechWorkV* pWorkV, ST_TrueSpeechWorkN* pWorkN, int16_t out[/*60*/]);
asm("
		.code
		.align		1
		.global		TrueSpeech_UpdateFilters
TrueSpeech_UpdateFilters:
		pushn		%r1
		;//-------------------------------------------------------------;//
		;//%r12 := pWorkV
		;//%r13 := pWorkN
		;//%r14 := out
		ld.w		%r0, %r12					;//%r0  :=  pWorkV
		ld.w		%r1, %r14					;//%r1  :=  out
		ld.w		%r12, %r13					;//%r12 :=  pWorkV
;//		add		%r12, 16					;//%r12 :=               &filtbuf[0]	
		xadd		%r13, %r13, 136					;//%r13 :=                            &filtbuf[60]				
		xld.w		%r14, 172					;//%r14 :=                                          sizeof(int16_t) * 86	
		xcall.d		memcpy						;//%r10 :=  pfb = memcpy(&filtbuf[0], &filtbuf[60], sizeof(int16_t) * 86)	
		add		%r12, 16					;//%r12 :=               &filtbuf[0]		*delay*
		;//-------------------------------------------------------------;//
		;//%r0  := pWorkV
		;//%r1  := out
		;//%r10 := pfb
		xadd		%r10, %r10, 172					;//%r10 :=  pfb += 86
		xadd		%r0, %r0, 144					;//%r0  :=  pnv = &newvec;
		xld.w		%r4, 60						;//%r4  :=  i = 60
TrueSpeech_UpdateFilters_L1:							;//do {
		ld.h		%r5, [%r1]					;//%r5  :=  x = *out
		ld.h		%r6, [%r0]+					;//%r6  :=       y = *pnv++								*anti-interlock*
		add		%r5, %r6					;//%r5  :=  x += y
		ld.h		[%r1]+, %r5					;//*out++ = x
		sra		%r6, 3						;//%r6  :=       y >> 3
		sub		%r5, %r6					;//%r5  :=  x -= y >> 3
		ld.h		[%r10]+, %r5					;//*pfb++ = x
		sub		%r4, 1						;//%r4  :=  i--
		jrne		TrueSpeech_UpdateFilters_L1			;//} while( i)
		;//-------------------------------------------------------------;//
		popn		%r1
		ret
");
#endif/*PIECE*/
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void TrueSpeech_Synth(ST_TrueSpeechWorkV* pWorkV, int16_t out[/*60*/]) {
	int16_t* const filter = pWorkV->filters[pWorkV->quart];
	int16_t tmpbuf[60 + 8], *ptmp;
	int i, k, sum;

	ptmp = memset(&tmpbuf[60], 0, sizeof(int16_t) * 8);	//=&tmpbuf[60]	//{̓t[ԂňێKvLf[^ł邪Aߖ̂߂ɈێȂƂɂBƂAt[ɃNAĂɑ傫ȉe悤ł邩B
	i = 60;
	do {
		sum = 0;
		for(k = 0; k < 8; k++) { sum += ptmp[k] * filter[k]; }	//asmłmacgBϐk͕svɂȂB
		sum = (sum >> 12) + *out;
		if(sum < INT16_MIN) { sum = INT16_MIN; }	//Kv
		if(sum > INT16_MAX) { sum = INT16_MAX; }	//Kv
		*out++  = sum;
		*--ptmp = sum;
	} while(--i);

	//{3񍇐sKvL邪Aȗ1񂾂sƂɂBƂA2ڂ3ڂ̍sȂĂAɑ傫ȉe悤ł邩B̏ȗɂAƁA2ڂ3ڗp̌We[usvɂȂ胁ߖłB
}
#else /*PIECE*/
void TrueSpeech_Synth(ST_TrueSpeechWorkV* pWorkV, int16_t out[/*60*/]);
asm("
		.code
		.align		1
		.global		TrueSpeech_Synth
TrueSpeech_Synth:
		pushn		%r1
		xsub		%sp, %sp, 136
		;//-------------------------------------------------------------;//
		;//%r12 := pWorkV
		;//%r13 := out
		;//%sp  := tmpbuf
		ld.h		%r4, [%r12]					;//%r4  :=                  quart
		sla		%r4, 4						;//%r4  :=                  quart * (sizeof filters[0])
		xadd		%r12, %r12, 80					;//%r12 :=          filters
		add		%r12, %r4					;//%r12 :=          filters[quart]
		ld.w		%r0, %r12					;//%r0  := filter = filters[quart]
		ld.w		%r1, %r13					;//%r1  := out
		xadd		%r12, %sp, 120					;//%r12 :=               &tmpbuf[60]
		ld.w		%r13, 0						;//%r13 :=                            0
		xcall.d		memset						;//%r10 := ptmp = memset(&tmpbuf[60], 0, sizeof(int16_t) * 8)
		ld.w		%r14, 16					;//%r14 :=                               sizeof(int16_t) * 8	*delay*
		;//-------------------------------------------------------------;//
		;//%r0  := filter
		;//%r1  := out
		;//%r10 := ptmp
		xld.w		%r4, 60						;//%r4     := i = 60
		xld.w		%r5, 32767					;//%r5     := SHRT_MAX
		not		%r6, %r5					;//%r6     := SHRT_MIN
TrueSpeech_Synth_L1:								;//do {
		ld.w		%alr, %r8					;//%alr    := sum  =  0
		ld.w		%r9, 8						;//%r9     :=             k
		ld.w		%r11, %r0					;//%r11    :=                                                   filter
		mac		%r9						;//%alr    := sum  =  for(k = 0; k < 8; k++) { sum += *ptmp++ * *filter++ }
		sub		%r10, 18					;//%r10    :=                                          ptmp -= (8+1)
		ld.w		%r7, %alr					;//%r7     :=         sum
		ld.h		%r9, [%r1]					;//%r9     :=                      *out
		xsra		%r7, 12						;//%r7     :=        (sum >> 12)
		add		%r7, %r9					;//%r7     := sum  = (sum >> 12) + *out
		;//-------------------------------------------------------------;//
		cmp		%r7, %r5					;//%psr    := sum <=> INT16_MAX
		jrle.d		3						;//if(        sum   > INT16_MAX) {
		 cmp		%r7, %r6					;//%psr    := sum <=> INT16_MIN				*delay*
		 ld.w		%r7, %r5					;//  %r7   := sum  =  INT16_MAX  }	@
		jrge.d		3						;//if(        sum <   INT16_MIN) {	
		 sub		%r4, 1						;//%r4     := i--					*delay*
		 ld.w		%r7, %r6					;//  %r7   := sum  =  INT16_MIN  }	@
		ld.h		[%r1]+, %r7					;//*wbuff++ = sum			@
		ld.h		[%r10], %r7					;//*ptmp = sum				@
		jrne		TrueSpeech_Synth_L1				;//} while(   i)			
		;//-------------------------------------------------------------;//
		xadd		%sp, %sp, 136
		popn		%r1
		ret
");
#endif/*PIECE*/
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void TrueSpeech_Mix1(ST_TrueSpeechCh* pCh, int mixbuf[/*160*/]) {
	ST_TrueSpeechWorkV WorkV;
	int i, n;
	short* p;

	i = 160;
	do {
		if(!pCh->nOutLeft) {
			if(!pCh->nFrame) {
				if(!(pCh->iLoop -= (pCh->iLoop != -1))) { break; }	//asmł́uxld.w %r?,[iLoop];cmp %r?,-1;sbc %r?,%r8;jreq `vƂłB
				pCh->pData  = pCh->pInitData;
				pCh->nFrame = pCh->nInitFrame;
			}
			TrueSpeech_DecodeFrame(&WorkV, &pCh->WorkN, pCh->pData, pCh->OutBuf);
			pCh->nOutLeft = 240;
			pCh->pData += 8;
			pCh->nFrame--;
		}
		n = pCh->nOutLeft;
		p = &pCh->OutBuf[240 - n];
		if((i -= n) < 0) { n += i; }
		pCh->nOutLeft -= n;
		do {
			*mixbuf++ += *p++ * pCh->iVol;	//asmłmlt.hgB
		} while(--n);
	} while(i > 0);
}
#else /*PIECE*/
void TrueSpeech_Mix1(ST_TrueSpeechCh* pCh, int mixbuf[/*160*/]);
asm("
		.code
		.align		1
		.global		TrueSpeech_Mix1
TrueSpeech_Mix1:
		pushn		%r3
		xsub		%sp, %sp, 276
		;//-------------------------------------------------------------;//
		xld.w		[%sp+264], %r12					;//[%sp+264] := pCh
		xld.w		[%sp+268], %r13					;//[%sp+268] := mixbuf
		ld.w		%r0, [%r12]+					;//%r0       := iLoop
		ld.h		%r4, [%r12]+					;//%r4       := iVol
		ld.uh		%r1, [%r12]+					;//%r1       := nOutLeft
		ld.w		%r2, [%r12]+					;//%r2       := pData
		ld.w		%r3, [%r12]					;//%r3       := nFrame
		xld.h		[%sp+272], %r4					;//[%sp+272] := iVol
		xld.w		%r4, 160					;// %r4      := i = 160
		xld.h		[%sp+274], %r4					;//[%sp+274] := i = 160
TrueSpeech_Mix1_L1:								;//do {
		;//-------------------------------------------------------------;//
		xld.w		%r15, [%sp+264]					;//%r15 := pCh
		;//%r0         := iLoop
		;//%r1         := nOutLeft
		;//%r2         := pData
		;//%r3         := nFrame
		;//%r15        := pCh
		;//[%sp+  0].w := WorkV
		;//[%sp+264].w := pCh
		;//[%sp+268].w := mixbuf
		;//[%sp+272].h := iVol
		;//[%sp+274].h := i
		cmp		%r1, 0						;//if(!nOutLeft) {
		jrne		TrueSpeech_Mix1_L2				;//
		cmp		%r3, 0						;//if(!nFrame) {
		jrne		TrueSpeech_Mix1_L3				;//
		cmp		%r0, -1						;//%psr(C) :=            (iLoop != -1)
		sbc		%r0, %r8					;//%r0  :=      iLoop -= (iLoop != -1)
		jreq		TrueSpeech_Mix1_L4				;//if(    !iLoop) { break }
		xld.w		%r2, [%r15+16]					;//%r2  := pData  = pInitData
		xld.w		%r3, [%r15+20]					;//%r3  := nFrame = nInitFrame
TrueSpeech_Mix1_L3:								;//}
		ld.w		%r12, %sp					;//%r12 :=                &WorkV
		xadd		%r13, %r15, 504					;//%r13 :=                        &WorkN
		ld.w		%r14, %r2					;//%r14 :=                                pData
		xcall.d		TrueSpeech_DecodeFrame				;//TrueSpeech_DecodeFrame(&WorkV, &WorkN, pData, OutBuf)
		add		%r15, 24					;//%r15 :=                                       OutBuf		*delay*
		xld.w		%r1, 240					;//%r1  := nOutLeft
		add		%r2, 32						;//%r2  := pData += (8 * sizeof(uint32_t))
		sub		%r3, 1						;//%r3  := nFrame--
		xld.w		%r15, [%sp+264]					;//%r15 := pCh
TrueSpeech_Mix1_L2:								;//}
		;//-------------------------------------------------------------;//
		;//%r0         := iLoop
		;//%r1         := nOutLeft
		;//%r2         := pData
		;//%r3         := nFrame
		;//%r15        := pCh
		;//[%sp+  0].w := WorkV
		;//[%sp+264].w := pCh
		;//[%sp+268].w := mixbuf
		;//[%sp+272].h := iVol
		;//[%sp+274].h := i
		ld.w		%r4, %r1					;//%r4  :=                    n = nOutLeft
		xadd		%r5, %r15, 504					;//%r5  :=     &OutBuf[240                        ]
;//		sub		%r5, %r4					;//%r5  :=     &OutBuf[240 - (n / sizeof(int16_t))]	
;//		sub		%r5, %r4					;//%r5  := p = &OutBuf[240 -  n                   ]	
		xld.h		%r6, [%sp+274]					;//%r6  := i						@
		sub		%r5, %r4					;//%r5  :=     &OutBuf[240 - (n / sizeof(int16_t))]		*anti-interlock*
		sub		%r6, %r4					;//%r6  := i -= n					@@
		jrge.d		3						;//if(     i < 0) {					@@
		 sub		%r5, %r4					;//%r5  := p = &OutBuf[240 -  n                   ]		*delay*
		 add		%r4, %r6					;//%r4  := n += i }
		sub		%r1, %r4					;//%r1  := nOutLeft -= n
		xld.w		%r7, [%sp+268]					;//%r7  := mixbuf
		xld.h		%r9, [%sp+272]					;//%r9  := iVol
TrueSpeech_Mix1_L5:								;//do {
		ld.w		%r12, [%r7]					;//%r12 := x  = *mixbuf
		ld.h		%r13, [%r5]+					;//%r13 :=      y  = *p++
		mlt.h		%r13, %r9					;//%alr :=      y *= iVol
		ld.w		%r13, %alr					;//%r13 :=      y
		add		%r12, %r13					;//%r12 := x += y
		ld.w		[%r7]+, %r12					;//*mixbuf++ = x
		sub		%r4, 1						;//%r4  := n--
		jrne		TrueSpeech_Mix1_L5				;//} while(n)
		;//-------------------------------------------------------------;//
		;//%r0         := iLoop
		;//%r1         := nOutLeft
		;//%r2         := pData
		;//%r3         := nFrame
		;//%r6         := i		ύX
		;//%r7         := mixbuf	ύX
		;//%r15        := pCh
		;//[%sp+  0].w := WorkV
		;//[%sp+264].w := pCh
		;//[%sp+268].w := mixbuf	ύXO
		;//[%sp+272].h := iVol
		;//[%sp+274].h := i		ύXO
		xld.w		[%sp+268], %r7					;//[%sp+268] := mixbuf
		xld.h		[%sp+274], %r6					;//[%sp+274] := i
		cmp		%r6, 0						;//} while(i > 0)
		jrgt		TrueSpeech_Mix1_L1				;//
TrueSpeech_Mix1_L4:								;//
		;//-------------------------------------------------------------;//
		;//%r0         := iLoop
		;//%r1         := nOutLeft
		;//%r2         := pData
		;//%r3         := nFrame
		;//%r15        := pCh
		ld.w		[%r15], %r0					;//pCh->iLoop    = iLoop
		add		%r15, 6						;//%r15 :=   &pCh->nOutLeft
		ld.h		[%r15]+, %r1					;//pCh->nOutLeft = nOutLeft
		ld.w		[%r15]+, %r2					;//pCh->pData    = pData
		ld.w		[%r15], %r3					;//pCh->nFrame   = nFrame
		;//-------------------------------------------------------------;//
		xadd		%sp, %sp, 276
		popn		%r3
		ret
");
#endif/*PIECE*/
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void TrueSpeech_Mix2(short wbuff[/*320*/], int mixbuf[/*160*/]) {
	int i, x;

	i = 160;
	do {
		x = *mixbuf++ >> 8;
		if(x > SHRT_MAX) { x = SHRT_MAX; }
		if(x < SHRT_MIN) { x = SHRT_MIN; }
		*wbuff++ = x;	//
		*wbuff++ = x;	//8kHz16kHzϊ
	} while(--i);
}
#else /*PIECE*/
void TrueSpeech_Mix2(short wbuff[/*320*/], int mixbuf[/*160*/]);
asm("
		.code
		.align		1
		.global		TrueSpeech_Mix2
TrueSpeech_Mix2:
		;//-------------------------------------------------------------;//
		;//%r12 = wbuff
		;//%r13 = mixbuf
		xld.w		%r4, 160					;//%r4     := i  = 160
		xld.w		%r5, 32767					;//%r5     := SHRT_MAX
		not		%r6, %r5					;//%r6     := SHRT_MIN
TrueSpeech_Mix2_L1:								;//do {
		ld.w		%r7, [%r13]+					;//%r7     := x  =  *mixbuf++
		sra		%r7, 8						;//%r7     := x >>= 8
		cmp		%r7, %r5					;//%psr    := x <=> SHRT_MAX
		jrle.d		3						;//if(        x   > SHRT_MAX) {
		 cmp		%r7, %r6					;//%psr    := x <=> SHRT_MIN				*delay*
		 ld.w		%r7, %r5					;//  %r7   := x  =  SHRT_MAX  }		@
		jrge.d		3						;//if(        x <   SHRT_MIN) {		
		 sub		%r4, 1						;//%r4     := i--					*delay*
		 ld.w		%r7, %r6					;//  %r7   := x  =  SHRT_MIN  }		@
		ld.h		[%r12]+, %r7					;//*wbuff++ = x				@
		ld.h		[%r12]+, %r7					;//*wbuff++ = x				@
		jrne		TrueSpeech_Mix2_L1				;//} while(   i)			
		;//-------------------------------------------------------------;//
		ret
");
#endif/*PIECE*/
