/*	
 *	framfix.c
 *
 *	RAM]FŒ菬ZCu
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2003-2017 Naoyuki Sawa
 *
 *	* Tue Apr  2 12:30:00 JST 2003 Naoyuki Sawa
 *	- clipfix.cړĂ܂B
 *	* Tue Jul 11 06:51:46 JST 2006 Naoyuki Sawa
 *	- AZułfmulfdiv܂B
 *	  ret߂̒xXbg𗘗pAꂼ1NbN̍łB
 *	  fmuĺA3.25%Ȃ܂Bfdiv́A1.36%Ȃ܂B
 *	* Sun Jul 20 00:42:36 JST 2008 Naoyuki Sawa
 *	- ASMfdiv()ȃ܂B
 *	- ASMmxform()ȃ܂B
 *	- fsqrt()framfix.cclipfix.c֖߂܂B
 *	  ܂łɍAvP[VŎgppxႭAdvŖƔfARAMߖ񂷂邽߂łB
 *	* Sun Jul 20 08:11:21 JST 2008 Naoyuki Sawa
 *	- ASMvxform()ȃ܂B
 *	* Sat Jul 22 22:21:25 JST 2017 Naoyuki Sawa
 *	- clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
 *	  ̓Iɂ́Aȉ̂悤ȓ_C܂B
 *	- COFIX_NOASMV{̒`/`ƂŕύX悤ɂĂAAFIX_NOASM͏ɖ`ƂȂĂ܂B
 *	  ĆAP/ECEȂFIX_NOASM͖`AP/ECEȊOȂFIX_NOASM`悤ɂ܂B
 *	- Œ菬f[^^̒`AĒʏ̉ZqKpȂ悤ɖ`\̂ւ̃|C^^ƂĂ܂AWin64̏ꍇ(d)unsigned^ɂ܂B
 *	  Win64ł|C^^ɂƁA64bitɂȂĂ܂ɁAP(int)ւ̃LXgƌxoāA(intptr_t)oRKvLĎghłB
 *	  Win64ł͌Œ菬f[^^unsigned^ɂ̂ŁAĒʏ̉ZqKpĂxoȂ̂ŁAWin32,,P/ECEŃrh鎞ɌxmFĉB
 *	  Ȃ݂ɁAint^ł͂Ȃunsigned^ƂŔA|C^^ɋ߂̌^ɂŁA[Ӗ͂܂B(ǁAI(int)ɃLXgĎĝŁB)
 *	- GCCg@\̐֐gpvector,matrix\̂𐶐ĂӏAVɒ`vector_(),matrix_()gp悤ɏC܂B
 *	  vector_(),matrix_()́AGCCȂ΂܂Œʂ萶֐ɓWJAGCCȊOȂvector,matrix\̂𐶐CC֐ɓWJ܂B
 *	- 'long long'gpĂA'int64_t'ɏC܂B
 *	  TtBbNX'll'gpĂA'INT64_C'ɏC܂B
 */
#include "clip.h"

/****************************************************************************
 *	fmul
 ****************************************************************************/

#ifdef FIX_NOASM
fixed
fmul(fixed a, fixed b)
{
//{{2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	long long aa, bb, cc;
//2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	int64_t aa, bb, cc;
//}}2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	aa = (int)a;
	bb = (int)b;
	cc = (aa * bb) >> FRACT_BITS;
	/*                   fedcba9876543210 */
	//if(cc < (long long)0xffffffff80000000ll || cc > (long long)0x000000007fffffffll) {
	//	die("##fmul\n%08x*%08x\n%08x:%08x", (int)aa, (int)bb, (int)(cc >> 32), (int)(cc));
	//}long long͈͔̔rgcc33̃oOŐȂBႦcc=0x3f8łG[ɂȂĂ܂B
	//   ͈͔ŕA0ɂȂ悤ɃoCAXĂ畄Ȃrs悤łB
	//   Ƃ낪AoCAXl̃RpCǗ32rbgȂɂȂĂ炵A
	//   ̗ł 0x80000000ll 𑫂Ȃ΂Ȃ̂ɁAۂɐꂽR[hł 0xffffffff80000000ll 𑫂Ă܂Ă܂B
	//   炭 (int)0x80000000 ̍ŏʃrbggĂ܂Ă̂Ǝv܂B
	//   ȏ̂悤ȗRɂAƂlong long^̕ϐłA32rbgtŕ\Ȃ萔lp͈͔rׂ͔łB
//{{2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	if((cc & 0xffffffff80000000ll) != 0x0000000000000000ll &&
//	   (cc & 0xffffffff80000000ll) != 0xffffffff80000000ll) {
//2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	if((cc & INT64_C(0xffffffff80000000)) != INT64_C(0x0000000000000000) &&
	   (cc & INT64_C(0xffffffff80000000)) != INT64_C(0xffffffff80000000)) {
//}}2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
		die("##fmul\n%08x*%08x\n%08x:%08x", (int)aa, (int)bb, (int)(cc >> 32), (int)(cc));
	}
	return (fixed)(int)cc;
}
#else /*FIX_NOASM*/
#if (FRACT_BITS != 10) || (VALUE_BITS != 22)
#error Œ菬p[^zlƈقȂ܂B
#endif
	asm("
	.code
	.align 1
	.global fmul
fmul:
	mlt.w %r12, %r13
	ld.w %r10, %alr
	ld.w %r11, %ahr
	xsrl %r10, 10			; 10=FRACT_BITS
	xsll %r11, 22			; 22=VALUE_BITS
	;//or %r10, %r11
	;//ret
	;//2006/07/11 ܂B
	ret.d
	or %r10, %r11			; *delay*
	");
#endif /*FIX_NOASM*/

/****************************************************************************
 *	fdiv
 ****************************************************************************/

#ifdef FIX_NOASM
fixed
fdiv(fixed a, fixed b)
{
//{{2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	long long aa, bb, cc;
//2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	int64_t aa, bb, cc;
//}}2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	aa = (int)a;
	bb = (int)b;
	cc = (aa << FRACT_BITS) / bb;
	/*                   fedcba9876543210 */
	//if(cc < (long long)0xffffffff80000000ll || cc > (long long)0x000000007fffffffll) {
	//	die("##fdiv\n%08x/%08x\n%08x:%08x", (int)aa, (int)bb, (int)(cc >> 32), (int)(cc));
	//}long long͈͔̔rgcc33̃oOŐȂBႦcc=0x3f8łG[ɂȂĂ܂B
	//   ͈͔ŕA0ɂȂ悤ɃoCAXĂ畄Ȃrs悤łB
	//   Ƃ낪AoCAXl̃RpCǗ32rbgȂɂȂĂ炵A
	//   ̗ł 0x80000000ll 𑫂Ȃ΂Ȃ̂ɁAۂɐꂽR[hł 0xffffffff80000000ll 𑫂Ă܂Ă܂B
	//   炭 (int)0x80000000 ̍ŏʃrbggĂ܂Ă̂Ǝv܂B
	//   ȏ̂悤ȗRɂAƂlong long^̕ϐłA32rbgtŕ\Ȃ萔lp͈͔rׂ͔łB
//{{2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	if((cc & 0xffffffff80000000ll) != 0x0000000000000000ll &&
//	   (cc & 0xffffffff80000000ll) != 0xffffffff80000000ll) {
//2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	if((cc & INT64_C(0xffffffff80000000)) != INT64_C(0x0000000000000000) &&
	   (cc & INT64_C(0xffffffff80000000)) != INT64_C(0xffffffff80000000)) {
//}}2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
		die("##fdiv\n%08x/%08x\n%08x:%08x", (int)aa, (int)bb, (int)(cc >> 32), (int)(cc));
	}
	return (fixed)(int)cc;
}
#else /*FIX_NOASM*/
#if (FRACT_BITS != 10) || (~FRACT_MASK != -1024)
#error Œ菬p[^zlƈقȂ܂B
#endif
//{{2008/07/20:ȃ̂ߍ폜
//	asm("
//	.code
//	.align 1
//	.global fdiv
//fdiv:
//	ld.w %alr, %r12
//	div0s %r13
//	div1 %r13			;  1
//	div1 %r13			;  2
//	div1 %r13			;  3
//	div1 %r13			;  4
//	div1 %r13			;  5
//	div1 %r13			;  6
//	div1 %r13			;  7
//	div1 %r13			;  8
//	div1 %r13			;  9
//	div1 %r13			; 10=FRACT_BITS
//	ld.w %r11, %psr			; %psr(N)ۑ
//	ld.w %r10, %alr
//	xand %r10, %r10, -1024		; -1024=~FRACT_MASK(-1023Ȃ!)
//	ld.w %alr, %r10
//	ld.w %psr, %r11			; %psr(N)
//	div1 %r13			;  1
//	div1 %r13			;  2
//	div1 %r13			;  3
//	div1 %r13			;  4
//	div1 %r13			;  5
//	div1 %r13			;  6
//	div1 %r13			;  7
//	div1 %r13			;  8
//	div1 %r13			;  9
//	div1 %r13			; 10
//	div1 %r13			; 11
//	div1 %r13			; 12
//	div1 %r13			; 13
//	div1 %r13			; 14
//	div1 %r13			; 15
//	div1 %r13			; 16
//	div1 %r13			; 17
//	div1 %r13			; 18
//	div1 %r13			; 19
//	div1 %r13			; 20
//	div1 %r13			; 21
//	div1 %r13			; 22
//	div1 %r13			; 23
//	div1 %r13			; 24
//	div1 %r13			; 25
//	div1 %r13			; 26
//	div1 %r13			; 27
//	div1 %r13			; 28
//	div1 %r13			; 29
//	div1 %r13			; 30
//	div1 %r13			; 31
//	div1 %r13			; 32
//	div2s %r13
//	div3s
//	;//ld.w %r10, %alr
//	;//ret
//	;//2006/07/11 ܂B
//	ret.d
//	ld.w %r10, %alr			; *delay* (undoc'd)
//	");
//}}2008/07/20:ȃ̂ߍ폜
// * Sun Jul 20 00:42:36 JST 2008 Naoyuki Sawa
// - ASMfdiv()ȃ܂B
//   uClock=48MHzACode=FRAMAStack=FRAMv̍őŁAύXOƕύX̃R[hrꍇA11`12%̐\ቺŁA40oCg̏ȃłB
// - fdiv()́A3D`̃NbsO[`AW̌vZʂɎgp̂ŁAdvł͂̂łǁA
//   fdiv()WIɎgp̂ł͖̂ŁA\ቺ100%ڋ킯ł͖ARAM̐ߖĂ΁AȃLƔf܂B
asm("
		.code
		.align		1
		.global		fdiv
fdiv:
		ld.w		%alr, %r12
		div0s		%r13
		;//
		div1		%r13				;  1
		div1		%r13				;  2
		div1		%r13				;  3
		div1		%r13				;  4
		div1		%r13				;  5
		div1		%r13				;  6
		div1		%r13				;  7
		div1		%r13				;  8
		div1		%r13				;  9
		div1		%r13				; 10=FRACT_BITS
		;//
		ld.w		%r10, %psr			; %psr(DS,N)ۑ
		ld.w		%r11, %alr
		xand		%r11, %r11, -1024		; -1024=~FRACT_MASK(-1023Ȃ!)
		ld.w		%alr, %r11
		ld.w		%psr, %r10			; %psr(DS,N)
		;//
		ld.w		%r11, 4
fdiv_loop:
		div1		%r13				;  1, 9,17,25
		div1		%r13				;  2,10,18,26
		div1		%r13				;  3,11,19,27
		div1		%r13				;  4,12,20,28
		div1		%r13				;  5,13,21,29
		div1		%r13				;  6,14,22,30
		div1		%r13				;  7,15,23,31
		div1		%r13				;  8,16,24,32
		sub		%r11, 1
		jrne.d		fdiv_loop
		ld.w		%psr, %r10			; %psr(DS,N)				*delay*
		;//
		div2s		%r13
		div3s
		ret.d
		ld.w		%r10, %alr			;						*delay*
");
#endif /*FIX_NOASM*/

/****************************************************************************
 *	vxform
 ****************************************************************************/

#ifdef FIX_NOASM
vector
vxform(matrix a, vector b)
{
//{{2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (vector){
//		fadd(fadd(fadd(fmul(a.a00, b.x), fmul(a.a01, b.y)), fmul(a.a02, b.z)), a.a03),
//		fadd(fadd(fadd(fmul(a.a10, b.x), fmul(a.a11, b.y)), fmul(a.a12, b.z)), a.a13),
//		fadd(fadd(fadd(fmul(a.a20, b.x), fmul(a.a21, b.y)), fmul(a.a22, b.z)), a.a23)};
//2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return vector_(
		fadd(fadd(fadd(fmul(a.a00, b.x), fmul(a.a01, b.y)), fmul(a.a02, b.z)), a.a03),
		fadd(fadd(fadd(fmul(a.a10, b.x), fmul(a.a11, b.y)), fmul(a.a12, b.z)), a.a13),
		fadd(fadd(fadd(fmul(a.a20, b.x), fmul(a.a21, b.y)), fmul(a.a22, b.z)), a.a23));
//}}2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}
#else /*FIX_NOASM*/
/* C[`ł́AZƂɏrbg킹̂߂̃Vtg܂B
 * asm[`ł́AϘaɂ܂Ƃ߂ăVtgsAvĂ܂B
 */
//{{2008/07/20:ȃ̂ߍ폜
//	asm("
//	.code
//	.align 1
//	.global vxform
//vxform:
//	ld.w	%r10, %r12		; %r10=ʊi[|C^߂liS5U1C33000C_J.pdf p.85 \̂Ԃ֐ւ̈n QƁj
//	;				; %r12ɓnꂽB̌ʊi[p|C^A%r10ɂ̂܂ܕԂȂ΂ȂKłB
//	;
//	xld.w	%r4, [%sp+52]		; %r4=Bx
//	xld.w	%r5, [%sp+56]		; %r5=By
//	xld.w	%r6, [%sp+60]		; %r6=Bz
//	;
//	xld.w	%r11, [%sp+ 4]		; %r13:12=A00*Bx
//	mlt.w	%r11, %r4
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+ 8]		; %r13:%r12+=A01*By
//	mlt.w	%r11, %r5
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+12]		; %r13:%r12+=A02*Bz
//	mlt.w	%r11, %r6
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	%r11, [%sp+16]		; %r12+=A03
//	add	%r12, %r11
//	xld.w	[%r10+ 0], %r12
//	;
//	xld.w	%r11, [%sp+20]		; %r13:12=A10*Bx
//	mlt.w	%r11, %r4
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+24]		; %r13:%r12+=A11*By
//	mlt.w	%r11, %r5
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+28]		; %r13:%r12+=A12*Bz
//	mlt.w	%r11, %r6
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	%r11, [%sp+32]		; %r12+=A13
//	add	%r12, %r11
//	xld.w	[%r10+ 4], %r12
//	;
//	xld.w	%r11, [%sp+36]		; %r13:12=A20*Bx
//	mlt.w	%r11, %r4
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+40]		; %r13:%r12+=A21*By
//	mlt.w	%r11, %r5
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+44]		; %r13:%r12+=A22*Bz
//	mlt.w	%r11, %r6
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	%r11, [%sp+48]		; %r12+=A23
//	add	%r12, %r11
//	xld.w	[%r10+ 8], %r12
//	;
//	ret
//	");
//}}2008/07/20:ȃ̂ߍ폜
// * Sun Jul 20 08:11:21 JST 2008 Naoyuki Sawa
// - ASMvxform()ȃ܂B
//   uClock=48MHzACode=FRAMAStack=FRAMv̍őŁAύXOƕύX̃R[hrꍇA2`3%̐\ቺŁA96oCg̏ȃłB
// - vxform()́A3D`̒_ϊʂɎgp̂ŁAdvł͂̂łǁA
//   vxform()P̂̐\ቺAAvP[V̐\100%ڋ킯ł͖ARAM̐ߖĂ΁AȃLƔf܂B
asm("
		.code
		.align		1
		.global		vxform
vxform:
		ld.w		%r10, %r12		; %r10 := ʊi[|C^߂l(S5U1C33000C_J.pdf p.85 \̂Ԃ֐ւ̈n Q)
		;					; %r12ɓnꂽB̌ʊi[p|C^A%r10ɂ̂܂ܕԂȂ΂ȂKłB
		;//
		xadd		%r4, %sp, 4		; %r4  := &mat->a00
		xld.w		%r5, [%sp+52]		; %r5  := vec->x
		xld.w		%r6, [%sp+56]		; %r6  := vec->y
		xld.w		%r7, [%sp+60]		; %r7  := vec->z
		ld.w		%r13, 3			; %r13 := cnt
vxform_loop:
		ld.w		%r9, [%r4]+		; %r9       :=        mat->a00
		mlt.w		%r5, %r9		; %alr:%ahr :=        mat->a00 * vec->x
		ld.w		%r14, %alr		; %r14:%r15 := sum  = mat->a00 * vec->x
		ld.w		%r15, %ahr
		;//
		ld.w		%r9, [%r4]+		; %r9       :=        mat->a01
		mlt.w		%r6, %r9		; %alr:%ahr :=        mat->a01 * vec->y
		ld.w		%r9, %alr		; %r14:%r15 := sum += mat->a01 * vec->y
		add		%r14, %r9
		ld.w		%r9, %ahr
		adc		%r15, %r9
		;//
		ld.w		%r9, [%r4]+		; %r9       :=        mat->a02
		mlt.w		%r7, %r9		; %alr:%ahr :=        mat->a02 * vec->z
		ld.w		%r9, %alr		; %r14:%r15 := sum += mat->a02 * vec->z
		add		%r14, %r9
		ld.w		%r9, %ahr
		adc		%r15, %r9
		;//
		xsrl		%r14, 10		; %r14 := sum >>= FRACT_BITS
		xsll		%r15, 22
		or		%r14, %r15
		;//
		ld.w		%r9, [%r4]+		; %r9    :=        mat->a03
		add		%r14, %r9		; %r14   := sum += mat->a03
		ld.w		[%r12]+, %r14		; out->x := sum
		;//
		sub		%r13, 1			; cnt--
		jrne		vxform_loop
		;//
		ret
");
#endif /*FIX_NOASM*/

/****************************************************************************
 *	mxform
 ****************************************************************************/

#ifdef FIX_NOASM
matrix
mxform(matrix a, matrix b)
{
//{{2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//	return (matrix){
//		     fadd(fadd(fmul(a.a00, b.a00), fmul(a.a01, b.a10)), fmul(a.a02, b.a20)),
//		     fadd(fadd(fmul(a.a00, b.a01), fmul(a.a01, b.a11)), fmul(a.a02, b.a21)),
//		     fadd(fadd(fmul(a.a00, b.a02), fmul(a.a01, b.a12)), fmul(a.a02, b.a22)),
//		fadd(fadd(fadd(fmul(a.a00, b.a03), fmul(a.a01, b.a13)), fmul(a.a02, b.a23)), a.a03),
//		     fadd(fadd(fmul(a.a10, b.a00), fmul(a.a11, b.a10)), fmul(a.a12, b.a20)),
//		     fadd(fadd(fmul(a.a10, b.a01), fmul(a.a11, b.a11)), fmul(a.a12, b.a21)),
//		     fadd(fadd(fmul(a.a10, b.a02), fmul(a.a11, b.a12)), fmul(a.a12, b.a22)),
//		fadd(fadd(fadd(fmul(a.a10, b.a03), fmul(a.a11, b.a13)), fmul(a.a12, b.a23)), a.a13),
//		     fadd(fadd(fmul(a.a20, b.a00), fmul(a.a21, b.a10)), fmul(a.a22, b.a20)),
//		     fadd(fadd(fmul(a.a20, b.a01), fmul(a.a21, b.a11)), fmul(a.a22, b.a21)),
//		     fadd(fadd(fmul(a.a20, b.a02), fmul(a.a21, b.a12)), fmul(a.a22, b.a22)),
//		fadd(fadd(fadd(fmul(a.a20, b.a03), fmul(a.a21, b.a13)), fmul(a.a22, b.a23)), a.a23)};
//2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
	return matrix_(
		     fadd(fadd(fmul(a.a00, b.a00), fmul(a.a01, b.a10)), fmul(a.a02, b.a20)),
		     fadd(fadd(fmul(a.a00, b.a01), fmul(a.a01, b.a11)), fmul(a.a02, b.a21)),
		     fadd(fadd(fmul(a.a00, b.a02), fmul(a.a01, b.a12)), fmul(a.a02, b.a22)),
		fadd(fadd(fadd(fmul(a.a00, b.a03), fmul(a.a01, b.a13)), fmul(a.a02, b.a23)), a.a03),
		     fadd(fadd(fmul(a.a10, b.a00), fmul(a.a11, b.a10)), fmul(a.a12, b.a20)),
		     fadd(fadd(fmul(a.a10, b.a01), fmul(a.a11, b.a11)), fmul(a.a12, b.a21)),
		     fadd(fadd(fmul(a.a10, b.a02), fmul(a.a11, b.a12)), fmul(a.a12, b.a22)),
		fadd(fadd(fadd(fmul(a.a10, b.a03), fmul(a.a11, b.a13)), fmul(a.a12, b.a23)), a.a13),
		     fadd(fadd(fmul(a.a20, b.a00), fmul(a.a21, b.a10)), fmul(a.a22, b.a20)),
		     fadd(fadd(fmul(a.a20, b.a01), fmul(a.a21, b.a11)), fmul(a.a22, b.a21)),
		     fadd(fadd(fmul(a.a20, b.a02), fmul(a.a21, b.a12)), fmul(a.a22, b.a22)),
		fadd(fadd(fadd(fmul(a.a20, b.a03), fmul(a.a21, b.a13)), fmul(a.a22, b.a23)), a.a23));
//}}2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
}
#else /*FIX_NOASM*/
/* C[`ł́AZƂɏrbg킹̂߂̃Vtg܂B
 * asm[`ł́AϘaɂ܂Ƃ߂ăVtgsAvĂ܂B
 */
//{{2008/07/20:ȃ̂ߍ폜
//	asm("
//	.code
//	.align 1
//	.global mxform
//mxform:
//	ld.w	%r10, %r12		; %r10=ʊi[|C^߂liS5U1C33000C_J.pdf p.85 \̂Ԃ֐ւ̈n QƁj
//	;				; %r12ɓnꂽB̌ʊi[p|C^A%r10ɂ̂܂ܕԂȂ΂ȂKłB
//	;
//	xld.w	%r4, [%sp+ 4]		; %r4=A00
//	xld.w	%r5, [%sp+ 8]		; %r5=A01
//	xld.w	%r6, [%sp+12]		; %r6=A02
//	xld.w	%r7, [%sp+16]		; %r7=A03
//	;
//	xld.w	%r11, [%sp+52]		; %r13:%r12=A00*B00
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+68]		; %r13:%r12+=A01*B10
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+84]		; %r13:%r12+=A02*B20
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	[%r10+ 0], %r12
//	;
//	xld.w	%r11, [%sp+56]		; %r13:%r12=A00*B01
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+72]		; %r13:%r12+=A01*B11
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+88]		; %r13:%r12+=A02*B21
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	[%r10+ 4], %r12
//	;
//	xld.w	%r11, [%sp+60]		; %r13:%r12=A00*B02
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+76]		; %r13:%r12+=A01*B12
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+92]		; %r13:%r12+=A02*B22
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	[%r10+ 8], %r12
//	;
//	xld.w	%r11, [%sp+64]		; %r13:%r12=A00*B03
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+80]		; %r13:%r12+=A01*B13
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+96]		; %r13:%r12+=A02*B23
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	add	%r12, %r7		; %r12+=A03
//	xld.w	[%r10+12], %r12
//	;
//	xld.w	%r4, [%sp+20]		; %r4=A10
//	xld.w	%r5, [%sp+24]		; %r5=A11
//	xld.w	%r6, [%sp+28]		; %r6=A12
//	xld.w	%r7, [%sp+32]		; %r7=A13
//	;
//	xld.w	%r11, [%sp+52]		; %r13:%r12=A10*B00
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+68]		; %r13:%r12+=A11*B10
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+84]		; %r13:%r12+=A12*B20
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	[%r10+16], %r12
//	;
//	xld.w	%r11, [%sp+56]		; %r13:%r12=A10*B01
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+72]		; %r13:%r12+=A11*B11
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+88]		; %r13:%r12+=A12*B21
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	[%r10+20], %r12
//	;
//	xld.w	%r11, [%sp+60]		; %r13:%r12=A10*B02
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+76]		; %r13:%r12+=A11*B12
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+92]		; %r13:%r12+=A12*B22
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	[%r10+24], %r12
//	;
//	xld.w	%r11, [%sp+64]		; %r13:%r12=A10*B03
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+80]		; %r13:%r12+=A11*B13
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+96]		; %r13:%r12+=A12*B23
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	add	%r12, %r7		; %r12+=A13
//	xld.w	[%r10+28], %r12
//	;
//	xld.w	%r4, [%sp+36]		; %r4=A20
//	xld.w	%r5, [%sp+40]		; %r5=A21
//	xld.w	%r6, [%sp+44]		; %r6=A22
//	xld.w	%r7, [%sp+48]		; %r7=A23
//	;
//	xld.w	%r11, [%sp+52]		; %r13:%r12=A20*B00
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+68]		; %r13:%r12+=A21*B10
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+84]		; %r13:%r12+=A22*B20
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	[%r10+32], %r12
//	;
//	xld.w	%r11, [%sp+56]		; %r13:%r12=A20*B01
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+72]		; %r13:%r12+=A21*B11
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+88]		; %r13:%r12+=A22*B21
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	[%r10+36], %r12
//	;
//	xld.w	%r11, [%sp+60]		; %r13:%r12=A20*B02
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+76]		; %r13:%r12+=A21*B12
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+92]		; %r13:%r12+=A22*B22
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	xld.w	[%r10+40], %r12
//	;
//	xld.w	%r11, [%sp+64]		; %r13:%r12=A20*B03
//	mlt.w	%r4, %r11
//	ld.w	%r12, %alr
//	ld.w	%r13, %ahr
//	xld.w	%r11, [%sp+80]		; %r13:%r12+=A21*B13
//	mlt.w	%r5, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xld.w	%r11, [%sp+96]		; %r13:%r12+=A22*B23
//	mlt.w	%r6, %r11
//	ld.w	%r11, %alr
//	add	%r12, %r11
//	ld.w	%r11, %ahr
//	adc	%r13, %r11
//	xsrl	%r12, 10		; 10=FRACT_BITS
//	xsll	%r13, 22		; 22=VALUE_BITS
//	or	%r12, %r13
//	add	%r12, %r7		; %r12+=A23
//	xld.w	[%r10+44], %r12
//	;
//	ret
//	");
//}}2008/07/20:ȃ̂ߍ폜
// * Sun Jul 20 00:42:36 JST 2008 Naoyuki Sawa
// - ASMmxform()ȃ܂B
//   uClock=48MHzACode=FRAMAStack=FRAMv̍őŁAύXOƕύX̃R[hrꍇA8`9%̐\ቺŁA512oCg̏ȃłB
// - A_[`̂ŁA͍s~s̉Z𕂓_ňAmxform()̏dv͒ႭȂ\łB
//   ]āA̐\ቺߖD悵āAmxform()̏ȃs܂B
//   (vxform()͈dvłBxNg~s̉Z͕`掞̒_ϊőʂɎgp̂ŁA_Ɛ\ቺ傫邩łB)
asm("
		.code
		.align		1
		.global		mxform
mxform:
		xadd		%r4, %sp, 4			; %r4  := &in1->a00
		xadd		%r5, %sp, 52			; %r5  := &in2->a00
		ld.w		%r6, 3				; %r6  := cnt1
mxform_loop1:	;-----------------------------------------------;
		ld.w		%r7, 4				; %r7  := cnt2
		ld.w		%r13, [%r4]+			; %r13 := in1->a00
		ld.w		%r14, [%r4]+			; %r14 := in1->a01
		ld.w		%r15, [%r4]+			; %r15 := in1->a02
mxform_loop2:	;-----------------------------------------------;
		xld.w		%r9, [%r5+0]			; %r9       :=                   in2->a00
		mlt.w		%r13, %r9			; %alr:%ahr :=        in1->a00 * in2->a00
		ld.w		%r10, %alr			; %r10:%r11 := sum  = in1->a00 * in2->a00
		ld.w		%r11, %ahr
		;//
		xld.w		%r9, [%r5+16]			; %r9       :=                   in2->a10
		mlt.w		%r14, %r9			; %alr:%ahr :=        in1->a01 * in2->a10
		ld.w		%r9, %alr			; %r10:%r11 := sum += in1->a01 * in2->a10
		add		%r10, %r9
		ld.w		%r9, %ahr
		adc		%r11, %r9
		;//
		xld.w		%r9, [%r5+32]			; %r9       :=                   in2->a20
		mlt.w		%r15, %r9			; %alr:%ahr :=        in1->a02 * in2->a20
		ld.w		%r9, %alr			; %r10:%r11 := sum += in1->a02 * in2->a20
		add		%r10, %r9
		ld.w		%r9, %ahr
		adc		%r11, %r9
		;//
		xsrl		%r10, 10			; %r10 := sum >>= FRACT_BITS
		xsll		%r11, 22
;//		or		%r10, %r11			; ---------------+
		;//						;                |
		sub		%r7, 1				; %r7  := cnt2-- |
		jreq.d		5				;                |
		 or		%r10, %r11			; <--------------+				*delay*
		 ld.w		[%r12]+, %r10			; out->a00 := sum
		 jp.d		mxform_loop2
		 add		%r5, 4				; %r5  := &in2->a01				*delay*
		;-----------------------------------------------;
		ld.w		%r9, [%r4]+			; %r9  :=        in1->a03
		add		%r10, %r9			; %r10 := sum += in1->a03
		ld.w		[%r12]+, %r10			; out->a00 := sum
		;//
		sub		%r6, 1				; %r6  := cnt1--
		jrne.d		mxform_loop1
		sub		%r5, 12				; %r5  := &in2->a00				*delay*
		;-----------------------------------------------;
		sub		%r12, 48			; %r10 := ʊi[|C^߂l(S5U1C33000C_J.pdf p.85 \̂Ԃ֐ւ̈n Q)
		ret.d						; %r12ɓnꂽB̌ʊi[p|C^A%r10ɂ̂܂ܕԂȂ΂ȂKłB
		ld.w		%r10, %r12			;						*delay*
");
#endif /*FIX_NOASM*/

