/*
 *	clipxmp1.h
 *
 *	YAMAHA YMZ871 XMP-1 (eXtensible Music Player - 1) ȈՃhCo
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Thu Oct 13 21:52:21 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- ́ATAPV[PT,TAP~LT[,^C}ǗW[pāAYMZ871𐧌䂷ȈՃhCołB
 *	  YMZ871̓ɂẮAȑOɁAcliptaps.c̒ɂRgĂ̂ŁAQƂĉB
 *	* Thu Feb 09 23:42:37 JST 2017 Naoyuki Sawa
 *	- cliptaps.cW[ɂST_TapSeqInfo\̂ύXɔAXmp1_Init()̏ύX܂B
 *	* Sun Apr 02 22:50:54 JST 2017 Naoyuki Sawa
 *	- cliptaps.cɍĐʒmǉɔAXmp1_Init()stTapSeqInfo̒`ύX܂B
 *	  W[ł͍Đʒm𗘗p܂B
 *	  RpCG[h߂ɕύX܂B
 */
#ifndef __CLIP_XMP1_H__
#define __CLIP_XMP1_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/*****************************************************************************
 *	萔
 *****************************************************************************/
//V[PT̃RtBO[V
#define Xmp1_TapDevCh_Max		((32/2)-1)				//foCX`lԍ̍ől		ύXs	XMP-1̑S32gbNA2gbN̃yAɂāAmt[Y/XeIt[YΉ̃foCX`lƂĎgp鎖ɂ܂B		mt[YĐꍇ2gbNL鎖ɂȂA͗ǂȂBȒPɂ邽߂ɂ̂悤ɂAAύXׂłB
#define Xmp1_TapLogCh_Max		Xmp1_TapDevCh_Max			//_`lԍ̍ől		ύXs	_`lƃfoCX`lA1:1Ŋ蓖Ă鎖ɂ܂B܂ATAP̋@\͎gpȂɂ܂B
#define Xmp1_TapSeqCh_Max		Xmp1_TapLogCh_Max/**/		//V[PT`lԍ̍ől			V[PT`lƘ_`lA1:1Ő䂷鎖\Ȑ́AV[PT`lmۂ鎖ɂ܂BK̂悤ɎgpKv͖A̃V[PT`lŕ̘_`l𐧌䂵Ă\܂BAvP[V`(ST_Xmp1Info.getMxrChMask)ԂlɂĕύX\łB
#define Xmp1_TapSeq_iCont		((1000+(30-1))/30)/**/		//[vt[Yp[ms]	
#define Xmp1_TapSeq_nEvt		31/**/				//CxgL^			
#define Xmp1_TapSeq_iEvtMsk		(~(1<<TapEvt_Ctrl))/**/		//Cxg}XN			
/*---------------------------------------------------------------------------*/
//~LT̃RtBO[V
#define Xmp1_TapMxrCh_Max		Xmp1_TapLogCh_Max/**/		//~LT[`lԍ̍ől				~LT[`lƘ_`lA1:1Ő䂷鎖\Ȑ́A~LT[`lmۂ鎖ɂ܂BK̂悤ɎgpKv͖A̃~LT[`lŕ̘_`l𐧌䂵Ă\܂B
/*---------------------------------------------------------------------------*/
#define Xmp1_Exec_Xms_uItv		8/**/				//1ms^C}֐̃C^[o				V[PT̏́A^C}荞ݏƂĐmȎŎŝŁA1ms^C}֐Ƃēo^BC^[o͑傫ׂB̐؂ւňaoȂŁAȂׂ傫ȒlɒB
#define Xmp1_Exec_X00ms_uItv		1/**/				//100ms^C}֐̃C^[o				~LT[̏͑eĂڗȂ̂ŁA^C}荞ݏł͂ȂTimMgr_Exec()Ăяo悤ɁA100ms^C}֐Ƃēo^BۂɒĂ݂đeڗꍇ́A10ms^C}֐ɕύXĂ\ȂB
#define Xmp1_VolumeSw_Stable_ms		10/**/				//{[XCb`̈莞[ms]	
#define Xmp1_BusyToReady_ms		10/**/				//rW[Ԃ̎[ms]					10[ms]ƂRɂāAL̃RgQƂB
//QƎuYMZ871 عƭ CATALOG No. LSI-5MZ871A40 2013.9v(5MZ871A40.pdf)́Au7.1.2. t[YĐAV[PT[v(p.232)p
//7.1.2. t[YĐAV[PT[
//8. łɃt[YĐ̃gbNɂČ㒅DĐsAɑĐ撅E㒅DĐsꍇɂ́A㒅DĐƑ撅E㒅DĐ̊Ԃ96TvԂ̊ԊuĂB
//96TvƂ́u(1/44100[Hz])*96[Tv]=2.18[ms]vłAdl̓rW[Ԃ̎Ԃ3[ms]ł͂Ȃ̂AۂɎ3[ms]ł͕sȂ悤ŉĂ܂LB
//5[ms]ł܂słA10[ms]҂Ƃ悤₭鎖ȂBdl̒lƍ傫_䂾Ad̂10[ms]҂ɂB
/*---------------------------------------------------------------------------*/
//ST_Xmp1Trk.Flag
#define Xmp1Trk_Flag_Busy		(1<<0)					//̃gbNrW[ł鎖BrW[Ƃ́AĐJn96Tv(2.2ms)ȓ̊ԂӖBuYMZ871 عƭ CATALOG No. LSI-5MZ871A40 2013.9v(5MZ871A40.pdf)́Au7.1.2. t[YĐAV[PT[v(p.231)QƂB
#define Xmp1Trk_Flag_Pending		(1<<1)					//rW[҂t[YL鎖BrW[҂t[YƂ́ÃgbNrW[łԂɁAĐvsꂽt[YӖB̃gbNrW[łԂɕ̍Đvsꂽꍇ́AŌɍĐvsꂽt[YB
#define Xmp1Trk_Flag_Stereo		(1<<2)					//Đ̃t[Y,,rW[҂t[YXeIt[Ył鎖B̃tOZbgĂȂ΃mt[YłB
/*****************************************************************************
 *	\
 *****************************************************************************/
//
typedef struct _ST_Xmp1Info {
	uint8_t			(*readXmp1Reg)(uint8_t rb, uint8_t index);			//XMP-1̃WX^ǂݏoB				rb=0`6(WX^oN),index=0x00`0xFF(WX^Ԓn)				gp:2016/10/13݂̎ł͎gpĂ܂B
	void			(*writeXmp1Reg)(uint8_t rb, uint8_t index, uint8_t data);	//XMP-1̃WX^ɏށB				rb=0`6(WX^oN),index=0x00`0xFF(WX^Ԓn),data=0x00`0xFF(f[^)
	uint8_t			(*getMsecTime)();						//ݎ[ms]ԂB					߂l0x00`0xFFŃI[o[bvlƂĉB				LSI(XMP-1)̃rW[Ԃ𔻒肷鏈ɂgpĂB]āAxdvłB}CR̃n[hEFA^C}̃WX^lAړǂݏoĕԂ̂]܂B荞݋쓮̃\tgEFAJE^ł́A荞݋֎~ɂ덷邽ߖ]܂ȂB
	uint8_t			(*getVolumeSw)();						//{[XCb`̃|[glԂB			߂l0x00`0xFF(`)ƂĉB					ۂ̃{[XCb`̃n[hEFẢ𑜓x0x00`0xFFłȂꍇ́A0x00`0xFFɕϊĕԂĂB
	int			(*getMxrChMask)(int iLogCh);					//_`lɓKp~LT[`l}XNԂB	߂l(1<<0)`(1<<Xmp1_TapMxrCh_Max)0ȏ̑gݍ킹ƂĉB	Ⴆ΁A~LT[`lƘ_`l1:1Ő䂷Pȍ\Ȃ΁Aureturn 1<<iLogCh;vł\܂B
	uint16_t		_RegKey_PhrDef;							//RegKey_PhrDef						
	uint16_t		_RegKey_Next;							//RegKey_Next						u/clip/test.win/snd/MkPhrNo.batvŐłB
	uint16_t		_RegKey_No;							//RegKey_No						
	uint16_t		_RegKey_Channel;						//RegKey_Channel					u/clip/tool/XmpPmiCnv.bat -xvŐłB
	uint16_t		_RegKey_Time;							//RegKey_Time						
	//܂ł̃tB[h̓AvP[ṼrhɐÓIɒ`\łB
	const uint8_t*		TBL_RegTbl;							//WXge[uւ̃|C^			Win32vWFNgŁAWXge[u\[X擾ꍇ́ÃtB[h͓Iɐݒ肷KvLAST_Xmp1Infoconstɂ͏o܂BP/ECEHewvWFNgŁAWXge[uoCiNꍇ́ÃtB[hÓIɒ`\łAST_Xmp1InfoŜconstƂROMɔzu鎖o܂B
} ST_Xmp1Info;
/*---------------------------------------------------------------------------*/
//gbN\
typedef struct _ST_Xmp1Trk {
	uint8_t			Flag;						//tO				(Xmp1Trk_Flag_*)0ȏ̑gݍ킹B
	uint8_t			BusyTime;					//rW[[ms]		((Flag&Xmp1Trk_Flag_Busy)<>0)Ȃ΁ArW[[ms]B((Flag&Xmp1Trk_Flag_Busy)==0)Ȃ΁ÃtB[h͈ӖȂB
	int16_t			PN;						//Đt[Yԍ			0`8191=Đt[Yԍ,-1=	((Flag&Xmp1Trk_Flag_Pending)<>0)Ȃ΁ArW[҂t[Ỹt[YԍB
	uint8_t			P0;						//Ep				Xs[J[̉:0x00`0x7F=`,0x80=,0x81=(XeI),0x82=(XeIE),0x83`0xFF=^EXs[J[̉:0x00=,0x01`0x7F=`,0x81=(XeI),0x82=(XeIE),0x83`0xFF=
	uint8_t			V1;						//1{[				0x00=,0x01`0x80=`,0x81`0xFF=ݒ֎~(ۂɂ0x00Ɠ)
	uint8_t			V2;						//2{[				0x00=,0x01`0x80=`,0x81`0xFF=ݒ֎~(ۂɂ0x00Ɠ)
	uint8_t			LOOP;						//[v				0x00`0xFE=1`255,0xFF=
} ST_Xmp1Trk;
/*---------------------------------------------------------------------------*/
//Ǘ\
typedef struct _ST_Xmp1 {
	const ST_Xmp1Info*	pInfo;						//ւ̃|C^
	uint8_t			Vol;						//{[XCb`̈l
	uint8_t			NewVol;						//{[XCb`̃|[gl
	uint8_t			NewVolTime;					//{[XCb`̕ω[ms]
	ST_Xmp1Trk		TBL_Xmp1Trk[(Xmp1_TapDevCh_Max+1)];		//gbNz				foCX`lƃgbNA1:1ɑΉ܂B(ύXs)
	//qV[PT
	ST_TapSeq		_stTapSeq;					//V[PT
	ST_TapDevCh		_TBL_DevCh[(Xmp1_TapDevCh_Max+1)];		//foCX`lz			foCX`lƃgbNA1:1ɑΉ܂B(ύXs)
	ST_TapLogCh		_TBL_LogCh[(Xmp1_TapLogCh_Max+1)];		//_`lz			2016/10/13݂̎ł́A_`lƃfoCX`lA1:1ɑΉĂ܂B(ύX\)
	ST_TapSeqCh		_TBL_SeqCh[(Xmp1_TapSeqCh_Max+1)];		//V[PT`lz
	ST_TapEvtBuf		_EvtBuf;					//Cxgobt@
	ST_TapEvt		_TBL_Buf[(Xmp1_TapSeq_nEvt+1)];			//Cxgz
	//~LT[
	ST_TapMxr		_stTapMxr;					//~LT[
	ST_TapMxrCh		_TBL_MxrCh[(Xmp1_TapMxrCh_Max+1)];		//~LT[`lz
	//֐m[h
	ST_TimMgrFunc		stTimMgrFunc_TapSeq;				//V[PT̃^C}֐o^p
	ST_TimMgrFunc		stTimMgrFunc_TapMxr;				//~LT[̃^C}֐o^p
} ST_Xmp1;
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
void Xmp1_Init(ST_Xmp1* pXmp1, const ST_Xmp1Info* pInfo, ST_TimMgr* pTimMgr);
ST_TapSeq* Xmp1_GetTapSeq(ST_Xmp1* pXmp1);
ST_TapMxr* Xmp1_GetTapMxr(ST_Xmp1* pXmp1);
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__CLIP_XMP1_H__
