/*
 *	cliptsp.c
 *
 *	DSP Group TrueSpeech Decoder
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Mon Jul 07 01:54:09 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Sun Sep 04 21:41:17 JST 2016 Naoyuki Sawa
 *	- u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
 *	  ڍׂ́Aclipstd.h ̓̃RgQƂĉB
 */
#include "clip.h"

//
//W[gp̒ӎ@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//W[̍Đ[`́AX^bN̎gpʂ⑽߂łB(800oCg) @@@@@@@@@@@@
//@W[̋@\gpAvP[V́AX^bN𑽂߂ɊmۂĂB@@@@@@@@@
//@ڈƂẮAW[gpȂꍇA1LoCg炢mۂĂB @@@@@
//̓Iɂ́AL̎Oނ̃X^bNA߂ɊmۂĂ: @@@@@@@@@@@@@@@@@@@
//@@VXeX^bN@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@AvP[VMakefileSYSSTACKŒ`X^bNTCYłB@@@@@@@@@@@@@@@@@
//@A[U[X^bN@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@AvP[VMakefileUSRSTACKŒ`X^bNTCYłB@@@@@@@@@@@@@@@@@
//@@USRSTACK`Ȃꍇ́ARAM̎ceʂ[ł邱ƂmFĂB @@@@@@@@
//@B^XNX^bN@@!!v!!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@task_create()̈Ŏw肷X^bNTCYłB(^XN@\gpAvP[V̂) @@@
//@@ɂ̃X^bNꂽꍇɁA肵Â炢oOƂȂ̂ŁAӂĂB@@@@@@@
//@@X^bNꂽꍇ̏Ǐ̗ƂẮAtask_select()̒ŃAhXG[A @@@@@
//@@^XNXg𑀍삷ۂInsertTailList()̊֐̒ŃAhXG[܂B@@@@@@@
//W[̋@\gpAvP[V́Astack_switch_FRAM4gpȂłB@@@@@
//@FRAM4̃TCY512łAW[̍Đ[`̃X^bNgpʂłB@@@@@
//@X^bNFRAM4֐؂ւĂԂɁA荞݂Đ[`sƁAX^bN܂B 
//@A荞݂֎~ɂăX^bNFRAM4֐؂ւ邱Ƃ́A肠܂B @@@@@@@@@@
//

/****************************************************************************
 *	[Jϐ
 ****************************************************************************/
typedef struct _ST_TrueSpeech {
	int nCh;
	ST_TrueSpeechCh TBL_Ch[0/*nCh*/];
} ST_TrueSpeech;
static ST_TrueSpeech* pTrueSpeech;
/****************************************************************************
 *	֐
 ****************************************************************************/
#ifdef  WIN32
//{{2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
//#pragma warning(disable: 4305)	//'identifier':'type1''type2'֐؂l߂܂B
//2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#pragma warning(push)
#pragma warning(disable: 4305)	//'identifier':'type1''type2'֐؂l߂܂B
//}}2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#endif//WIN32
/*--------------------------------------------------------------------------*/
//Codebooks fo expanding input filter
const int16_t TBL_TrueSpeech_Codebook0[32]=
{0x8240,0x8364,0x84CE,0x865D,0x8805,0x89DE,0x8BD7,0x8DF4,0x9051,0x92E2,0x95DE,0x990F,0x9C81,0xA079,0xA54C,0xAAD2,
 0xB18A,0xB90A,0xC124,0xC9CC,0xD339,0xDDD3,0xE9D6,0xF893,0x096F,0x1ACA,0x29EC,0x381F,0x45F9,0x546A,0x63C3,0x73B5};
const int16_t TBL_TrueSpeech_Codebook1[32]=
{0x9F65,0xB56B,0xC583,0xD371,0xE018,0xEBB4,0xF61C,0xFF59,0x085B,0x1106,0x1952,0x214A,0x28C9,0x2FF8,0x36E6,0x3D92,
 0x43DF,0x49BB,0x4F46,0x5467,0x5930,0x5DA3,0x61EC,0x65F9,0x69D4,0x6D5A,0x709E,0x73AD,0x766B,0x78F0,0x7B5A,0x7DA5};
const int16_t TBL_TrueSpeech_Codebook2[16]=
{0x96F8,0xA3B4,0xAF45,0xBA53,0xC4B1,0xCECC,0xD86F,0xE21E,0xEBF3,0xF640,0x00F7,0x0C20,0x1881,0x269A,0x376B,0x4D60};
const int16_t TBL_TrueSpeech_Codebook3[16]=
{0xC654,0xDEF2,0xEFAA,0xFD94,0x096A,0x143F,0x1E7B,0x282C,0x3176,0x3A89,0x439F,0x4CA2,0x557F,0x5E50,0x6718,0x6F8D};
const int16_t TBL_TrueSpeech_Codebook4[16]=
{0xABE7,0xBBA8,0xC81C,0xD326,0xDD0E,0xE5D4,0xEE22,0xF618,0xFE28,0x064F,0x0EB7,0x17B8,0x21AA,0x2D8B,0x3BA2,0x4DF9};
const int16_t TBL_TrueSpeech_Codebook5[8]=
{0xD51B,0xF12E,0x042E,0x13C7,0x2260,0x311B,0x40DE,0x5385};
const int16_t TBL_TrueSpeech_Codebook6[8]=
{0xB550,0xC825,0xD980,0xE997,0xF883,0x0752,0x1811,0x2E18};
const int16_t TBL_TrueSpeech_Codebook7[8]=
{0xCEF0,0xE4F9,0xF6BB,0x0646,0x14F5,0x23FF,0x356F,0x4A8D};
/*--------------------------------------------------------------------------*/
//two-point filters table
const int16_t TBL_TrueSpeech_Order2Coeffs[25][2]={
{0xED2F,0x5239},{0x54F1,0xE4A9},{0x2620,0xEE3E},{0x09D6,0x2C40},{0xEFB5,0x2BE0},
{0x3FE1,0x3339},{0x442F,0xE6FE},{0x4458,0xF9DF},{0xF231,0x43DB},{0x3DB0,0xF705},
{0x4F7B,0xFEFB},{0x26AD,0x0CDC},{0x33C2,0x0739},{0x12BE,0x43A2},{0x1BDF,0x1F3E},
{0x0211,0x0796},{0x2AEB,0x163F},{0x050D,0x3A38},{0x0D1E,0x0D78},{0x150F,0x3346},
{0x38A4,0x0B7D},{0x2D5D,0x1FDF},{0x19B7,0x2822},{0x0D99,0x1F12},{0x194C,0x0CE6}};
/*--------------------------------------------------------------------------*/
//possible pulse values
const int16_t TBL_TrueSpeech_PulseScales[16][4]={
{0x0002,0x0006,0xFFFE,0xFFFA},{0x0004,0x000C,0xFFFC,0xFFF4},{0x0006,0x0012,0xFFFA,0xFFEE},{0x000A,0x001E,0xFFF6,0xFFE2},
{0x0010,0x0030,0xFFF0,0xFFD0},{0x0019,0x004B,0xFFE7,0xFFB5},{0x0028,0x0078,0xFFD8,0xFF88},{0x0040,0x00C0,0xFFC0,0xFF40},
{0x0065,0x012F,0xFF9B,0xFED1},{0x00A1,0x01E3,0xFF5F,0xFE1D},{0x0100,0x0300,0xFF00,0xFD00},{0x0196,0x04C2,0xFE6A,0xFB3E},
{0x0285,0x078F,0xFD7B,0xF871},{0x0400,0x0C00,0xFC00,0xF400},{0x0659,0x130B,0xF9A7,0xECF5},{0x0A14,0x1E3C,0xF5EC,0xE1C4}};
/*--------------------------------------------------------------------------*/
//table used for decoding pulse positions
const int16_t TBL_TrueSpeech_PulseValues[4][30]={
{0x0E46,0x0CCC,0x0B6D,0x0A28,0x08FC,0x07E8,0x06EB,0x0604,0x0532,0x0474,0x03C9,0x0330,0x02A8,0x0230,0x01C7,
 0x016C,0x011E,0x00DC,0x00A5,0x0078,0x0054,0x0038,0x0023,0x0014,0x000A,0x0004,0x0001,0x0000,0x0000,0x0000},
{0x0196,0x017A,0x015F,0x0145,0x012C,0x0114,0x00FD,0x00E7,0x00D2,0x00BE,0x00AB,0x0099,0x0088,0x0078,0x0069,
 0x005B,0x004E,0x0042,0x0037,0x002D,0x0024,0x001C,0x0015,0x000F,0x000A,0x0006,0x0003,0x0001,0x0000,0x0000},
{0x001D,0x001C,0x001B,0x001A,0x0019,0x0018,0x0017,0x0016,0x0015,0x0014,0x0013,0x0012,0x0011,0x0010,0x000F,
 0x000E,0x000D,0x000C,0x000B,0x000A,0x0009,0x0008,0x0007,0x0006,0x0005,0x0004,0x0003,0x0002,0x0001,0x0000},
{0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,
 0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001}};
/*--------------------------------------------------------------------------*/
#ifdef  WIN32
//{{2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
//#pragma warning(default: 4305)	//'identifier':'type1''type2'֐؂l߂܂B
//2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#pragma warning(pop)
//}}2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#endif//WIN32
/*--------------------------------------------------------------------------*/
static int TrueSpeech_StreamCallback(short wbuff[/*320*/], int param) {
	static int mixbuf[160]; /* ~LVOobt@Brs`shbłII */
	int iCh;
	memset(mixbuf, 0, sizeof mixbuf);
	for(iCh = 0; iCh < pTrueSpeech->nCh; iCh++) {
		ST_TrueSpeechCh* pCh = &pTrueSpeech->TBL_Ch[iCh];
		if(pCh->iLoop) { TrueSpeech_Mix1(pCh, mixbuf); }
	}
	TrueSpeech_Mix2(wbuff, mixbuf);
	return 0;
}
/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/
void TrueSpeech_Init(int nCh) {
	int iCh;
	TrueSpeech_Exit();
	pTrueSpeech = calloc(sizeof(ST_TrueSpeech) + sizeof(ST_TrueSpeechCh) * nCh, 1);
	if(!pTrueSpeech) { DIE(); }
	pTrueSpeech->nCh = nCh;
	for(iCh = 0; iCh < pTrueSpeech->nCh; iCh++) {
		TrueSpeech_SetChAtt(iCh, 0);
	}
	stream_play(320, TrueSpeech_StreamCallback, 0, 0);
}
/*--------------------------------------------------------------------------*/
void TrueSpeech_Exit() {
	stream_stop();
	free(pTrueSpeech);
	pTrueSpeech = NULL;
}
/*--------------------------------------------------------------------------*/
void TrueSpeech_PlayCh(int iCh, const void* pData, int iLoop) {
	ST_TrueSpeechCh* pCh;
	int nFrame;
	if(!pTrueSpeech || ((unsigned)iCh >= (unsigned)pTrueSpeech->nCh)) { DIE(); }
	pCh = &pTrueSpeech->TBL_Ch[iCh];
	nFrame = 0;
	//ppd
	if(!memcmp(pData, "MCPP", 4)) {
		const PCEWAVEINFO* pwi;
		pwi = (const PCEWAVEINFO*)((char*)pData + (4 + 4));
		if((pwi->type & 0x0F) != PW_TYPE_TRUESPEECH) { DIE(); }
		pData  = pwi + 1;
		nFrame = pwi->len / (240 * 2);
		//                         ~PCEWAVEINFO.len16kHzZ̃Tvł̂ŁATrueSpeechdl8kHz(Œ)ɕϊKvLB
	//wav
	} else if(!memcmp(pData, "RIFF", 4)) {
		const uint8_t *ptr, *end, *fmt, *data;
		int size;
		ptr = pData;				ptr += 4;
		size = LEWORD(ptr);			ptr += 4;
		end = ptr + size;
		if(memcmp(ptr, "WAVE", 4)) { DIE(); }	ptr += 4;
		fmt = data = NULL;
		while(ptr < end) {
			if(!memcmp(ptr, "fmt ", 4)) { fmt  = ptr + 8; }
			if(!memcmp(ptr, "data", 4)) { data = ptr + 8; }
							ptr += 4;
			size = LEWORD(ptr);		ptr += 4;
			ptr += size;
		}
		if(!fmt || !data) { DIE(); }
		if(LEHALF(fmt) != 0x0022/*WAVE_FORMAT_DSPGROUP_TRUESPEECH*/) { DIE(); }
		pData  = data;
		nFrame = LEWORD(data - 4) >> 5;
	}
	if(!nFrame) { DIE(); }
	((volatile ST_TrueSpeechCh*)pCh)->iLoop = 0;
	//{{̊ԂŊ݂ĂA~`lƌȂ̂ňSłB
//	pCh->iVol	= pCh->iVol;	//ĐJnɉʂAݒ肳Ă鉹ʂpB
	pCh->nOutLeft	= 0;
	pCh->pData	= pData;
	pCh->nFrame	= nFrame;
	pCh->pInitData	= pData;
	pCh->nInitFrame	= nFrame;
//	memset( pCh->OutBuf, 0, sizeof pCh->OutBuf);	//sv
	memset(&pCh->WorkN , 0, sizeof pCh->WorkN );	//Kv
	//}}̊ԂŊ݂ĂA~`lƌȂ̂ňSłB
	((volatile ST_TrueSpeechCh*)pCh)->iLoop = iLoop;
}
/*--------------------------------------------------------------------------*/
void TrueSpeech_StopCh(int iCh) {
	ST_TrueSpeechCh* pCh;
	if(!pTrueSpeech || ((unsigned)iCh >= (unsigned)pTrueSpeech->nCh)) { DIE(); }
	pCh = &pTrueSpeech->TBL_Ch[iCh];
	pCh->iLoop = 0;
}
/*--------------------------------------------------------------------------*/
void TrueSpeech_StopAll() {
	int iCh;
	if(!pTrueSpeech) { DIE(); }
	for(iCh = 0; iCh < pTrueSpeech->nCh; iCh++) {
		TrueSpeech_StopCh(iCh);
	}
}
/*--------------------------------------------------------------------------*/
int TrueSpeech_GetChStat(int iCh) {
	ST_TrueSpeechCh* pCh;
	if(!pTrueSpeech || ((unsigned)iCh >= (unsigned)pTrueSpeech->nCh)) { DIE(); }
	pCh = &pTrueSpeech->TBL_Ch[iCh];
	return pCh->iLoop;
}
/*--------------------------------------------------------------------------*/
void TrueSpeech_SetChAtt(int iCh, int iAtt) {
	static const unsigned char dbtbl[64] = {
		256/*(1<<8)/(10^( 0/20))*/-1,229/*(1<<8)/(10^( 1/20))*/-1,204/*(1<<8)/(10^( 2/20))*/-1,182/*(1<<8)/(10^( 3/20))*/-1,
		162/*(1<<8)/(10^( 4/20))*/-1,144/*(1<<8)/(10^( 5/20))*/-1,129/*(1<<8)/(10^( 6/20))*/-1,115/*(1<<8)/(10^( 7/20))*/-1,
		102/*(1<<8)/(10^( 8/20))*/-1, 91/*(1<<8)/(10^( 9/20))*/-1, 81/*(1<<8)/(10^(10/20))*/-1, 73/*(1<<8)/(10^(11/20))*/-1,
		 65/*(1<<8)/(10^(12/20))*/-1, 58/*(1<<8)/(10^(13/20))*/-1, 52/*(1<<8)/(10^(14/20))*/-1, 46/*(1<<8)/(10^(15/20))*/-1,
		 41/*(1<<8)/(10^(16/20))*/-1, 37/*(1<<8)/(10^(17/20))*/-1, 33/*(1<<8)/(10^(18/20))*/-1, 29/*(1<<8)/(10^(19/20))*/-1,
		 26/*(1<<8)/(10^(20/20))*/-1, 23/*(1<<8)/(10^(21/20))*/-1, 21/*(1<<8)/(10^(22/20))*/-1, 19/*(1<<8)/(10^(23/20))*/-1,
		 17/*(1<<8)/(10^(24/20))*/-1, 15/*(1<<8)/(10^(25/20))*/-1, 13/*(1<<8)/(10^(26/20))*/-1, 12/*(1<<8)/(10^(27/20))*/-1,
		 11/*(1<<8)/(10^(28/20))*/-1, 10/*(1<<8)/(10^(29/20))*/-1,  9/*(1<<8)/(10^(30/20))*/-1,  8/*(1<<8)/(10^(31/20))*/-1,
		  7/*(1<<8)/(10^(32/20))*/-1,  6/*(1<<8)/(10^(33/20))*/-1,  6/*(1<<8)/(10^(34/20))*/-1,  5/*(1<<8)/(10^(35/20))*/-1,
		  5/*(1<<8)/(10^(36/20))*/-1,  4/*(1<<8)/(10^(37/20))*/-1,  4/*(1<<8)/(10^(38/20))*/-1,  3/*(1<<8)/(10^(39/20))*/-1,
		  3/*(1<<8)/(10^(40/20))*/-1,  3/*(1<<8)/(10^(41/20))*/-1,  3/*(1<<8)/(10^(42/20))*/-1,  2/*(1<<8)/(10^(43/20))*/-1,
		  2/*(1<<8)/(10^(44/20))*/-1,  2/*(1<<8)/(10^(45/20))*/-1,  2/*(1<<8)/(10^(46/20))*/-1,  2/*(1<<8)/(10^(47/20))*/-1,
		  2/*(1<<8)/(10^(48/20))*/-1,  1/*(1<<8)/(10^(49/20))*/-1,  1/*(1<<8)/(10^(50/20))*/-1,  1/*(1<<8)/(10^(51/20))*/-1,
		  1/*(1<<8)/(10^(52/20))*/-1,  1/*(1<<8)/(10^(53/20))*/-1,  1/*(1<<8)/(10^(54/20))*/-1,  1/*(1<<8)/(10^(55/20))*/-1,
		  1/*(1<<8)/(10^(56/20))*/-1,  1/*(1<<8)/(10^(57/20))*/-1,  1/*(1<<8)/(10^(58/20))*/-1,  1/*(1<<8)/(10^(59/20))*/-1,
		  1/*(1<<8)/(10^(60/20))*/-1,  1/*(1<<8)/(10^(61/20))*/-1,  1/*(1<<8)/(10^(62/20))*/-1,  1/*(1<<8)/(10^(63/20))*/-1,
	};
	ST_TrueSpeechCh* pCh;
	if(!pTrueSpeech || ((unsigned)iCh >= (unsigned)pTrueSpeech->nCh)) { DIE(); }
	pCh = &pTrueSpeech->TBL_Ch[iCh];
	pCh->iVol = ((unsigned)iAtt < 64) ? ((dbtbl[iAtt]+1)<<1) : 0;
	//         dbtbl[]1oCgzɂ邽߂̕␳~~ ~~~Xs[J[ʑ̂߁Amȉʂ2{̉ʂɂ
}
