/*	
 *	clips26.h
 *
 *	P/ECE Signetics 2650 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Mon Apr 25 20:42:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_S26_H__
#define __CLIP_S26_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	萔E\
 ****************************************************************************/

/* */
/* AZu[`ɂāAregtB[h̃ItZbgZAxXbgɔzu܂B     */
/* "ext""add"1߂ŉZł悤AregtB[hItZbg63ȓɔzuĂB  */
/* 2005/05/02݁A\̂̃TCY64oCgȉȂ̂ŁA܂ItZbg63𒴂Sz͖łB*/
/* */

typedef struct _S2650 {
	unsigned char psl;		// + 0, 1: Program Status Lower
					//           psl[1]=COM (logical/arith COMpare)
					//           psl[3]=WC  (With/without Carry)
					//           psl[4]=RS  (Register bank Select)
					//           ̑̃rbg͕słB
	unsigned char psu;		// + 1, 1: Program Status Upper
					//           psu[5]=II (Interrupt Inhibit)
					//           psu[6]=F  (Flag)
					//           psu[7]=S  (Sense)
					//           ̑̃rbg͕słB
	unsigned short cc;		// + 2, 2: Condition Code
					//           cc=0x0000         Ȃ CC=0 Ӗ܂B
					//           cc=0x0001..0x007f Ȃ CC=1 Ӗ܂B
					//           cc=0x0080..0x00ff Ȃ CC=2 Ӗ܂B
					//           cc=0x0100..0xffff Ȃ CC=3 Ӗ܂B
	unsigned short c;		// + 4, 2: Carry
					//           c[8]=0 Ȃ C=0 Ӗ܂B
					//           c[8]=1 Ȃ C=1 Ӗ܂B
					//           ̑̃rbg͕słB
	unsigned char ovf;		// + 6, 1: OVerFlow
					//           ovf[7]=0 Ȃ OVF=0 Ӗ܂B
					//           ovf[7]=1 Ȃ OVF=1 Ӗ܂B
					//           ̑̃rbg͕słB
	unsigned char idc;		// + 7, 1: Inter Digit Carry
					//           idc[4]=0 Ȃ IDC=0 Ӗ܂B
					//           idc[4]=1 Ȃ IDC=1 Ӗ܂B
					//           ̑̃rbg͕słB
 	unsigned char reg[7];		// + 8, 7: REGister stack
	unsigned char sp;		// +15, 1: Pointer for the return address Stack
					//           sp=0..7
 	unsigned short ras[8];		// +16,16: Return Address Stack
 					//           ras[*]=0x0000..0x7fff
	unsigned short iar;		// +32, 2: Instruction Address Register
					//           iar=0x0000..0x7fff
	//------------------------------//
	unsigned char flags;		// +34, 1: ------hi
					//           flg[0]=IRQ (#INTREQ[q̏Ԃɑ܂)
					//           flg[1]=HALT
	unsigned char vector;		// +35, 1: 荞݃xN^
					//           IRQ=1 ̏ꍇ̂ݗLłB
	int cycle;			// +36, 4: csTCN
} S2650;				// =40

/* S2650.flags */
#define S2650_IRQ	(1<<0)
#define S2650_HALT	(1<<1)

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

extern S2650 s2650; /* P/ECȄꍇ͍RAMɔzu -> frams26a.s */

typedef struct _S2650SEQ {
	unsigned char resv0;	/* (\) */
	unsigned char resv1;	/* (\) */
	unsigned char resv2;	/* (\) */
	unsigned char cycle;	/* TCN */
	void (*fn1)();		/* ŏɌĂԊ֐ */
	void (*fn2)();		/* [ɌĂԊ֐] */
	void (*fn3)();		/* [ɌĂԊ֐] */
} S2650SEQ;
extern const S2650SEQ s2650seq[0x100]; /* V[PXe[u */

/****************************************************************************
 *	AvP[V`
 ****************************************************************************/

#ifndef PIECE
int s2650_read(int addr);		/* Read */
void s2650_write(int addr, int data);	/* Write */
int s2650_read_io(int addr);		/* I/O Read */
void s2650_write_io(int addr, int data);/* I/O Write */
#else /*PIECE*/
/* %r10 s2650_read(%r12); */		/* Read */
/* void s2650_write(%r12, %r13); */	/* Write */
/* %r10 s2650_read_io(%r12); */		/* I/O Read */
/* void s2650_write_io(%r12, %r13); */	/* I/O Write */
#endif /*PIECE*/

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* CPUZbg܂B
 */
void s2650_reset();

/* PSUWX^l擾܂B
 * [out]
 *	߂l		PSUWX^lB(S|F|II|0|0|SP2|SP1|SP0)
 */
#define s2650_get_psu s2650_get_psu_C /* AZu֐Ƃ̖OՓˉ */
int s2650_get_psu();

/* PSUWX^lݒ肵܂B
 * [in]
 *	psu		PSUWX^lB(S|F|II|-|-|SP2|SP1|SP0)
 */
#define s2650_set_psu s2650_set_psu_C /* AZu֐Ƃ̖OՓˉ */
void s2650_set_psu(int psu);

/* PSLWX^l擾܂B
 * [out]
 *	߂l		PSLWX^lB(CC1|CC0|IDC|RS|WC|OVF|COM|C)
 */
#define s2650_get_psl s2650_get_psl_C /* AZu֐Ƃ̖OՓˉ */
int s2650_get_psl();

/* PSLWX^lݒ肵܂B
 * [in]
 *	psl		PSLWX^lB(CC1|CC0|IDC|RS|WC|OVF|COM|C)
 */
#define s2650_set_psl s2650_set_psl_C /* AZu֐Ƃ̖OՓˉ */
void s2650_set_psl(int psl);

/* SENSE[q̓͏Ԃݒ肵܂B
 * [in]
 *	sense		0܂1B
 * [note]
 *	* PSU(S)tOɔf܂B
 */
void s2650_set_sense(int sense);

/* CPUs܂B
 * [in]
 *	cycle		sTCNB
 */
void s2650_run(int cycle);

/* IRQsA܂͕ۗ܂B
 */
void s2650_irq(int vector);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_S26_H__*/
