
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
	.code
	.align	2
__LC0:
	.ascii	"PMBP\000"
	.align	2
__LC1:
	.ascii	"clipren2.$\000"
	.code
	.align	1
	.global	texture_init
texture_init:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r2,%r12
	ld.w	%r0,%r13
	ld.w	%r12,%r0
	ext	__LC0+0x0@h	; 	xld.w	%r13,__LC0
	ext	__LC0+0x0@m
	ld.w	%r13,__LC0+0x0@l
	ld.w	%r14,0x4	; 	xld.w	%r14,0x00000004		; 4
	ext	strncmp@rm	; 	xcall	strncmp
	call	strncmp@rl
	cmp	%r10,0x0
	jreq	__LX71		; 	xjreq	__L71
	int	2
	.word	__LC1
	.half	0x000000ab
__LX71:				; __L71:
	ext	0x8		; 	xld.uh	%r10,[%r0+0x8]
	ld.uh	%r10,[%r0]
	cmp	%r10,0x0
	jreq	__LX77		; 	xjreq	__L77
	ext	0x8		; 	xld.ub	%r11,[%r0+0x8]
	ld.ub	%r11,[%r0]
	ext	0x1		; 	xsub	%r10,%r11,1
	sub	%r10,%r11
	ld.ub	%r10,%r10
	cmp	%r10,0x1	; 	xcmp	%r10,1
	jrule	__LX73		; 	xjrule	__L73
	ld.ub	%r10,%r11
	cmp	%r10,0x4	; 	xcmp	%r10,4
	jreq	__LX73		; 	xjreq	__L73
	int	2
	.word	__LC1
	.half	0x000000af
__LX73:				; __L73:
	ext	0x9		; 	xld.ub	%r10,[%r0+0x9]
	ld.ub	%r10,[%r0]
	cmp	%r10,0x1	; 	xcmp	%r10,1
	jrule	__LX74		; 	xjrule	__L74
	int	2
	.word	__LC1
	.half	0x000000b0
__LX74:				; __L74:
	ext	0xa		; 	xld.uh	%r11,[%r0+0xa]
	ld.uh	%r11,[%r0]
	ld.h	%r10,%r11
	cmp	%r10,0x7	; 	xcmp	%r10,7
	jrle	__LX76		; 	xjrle	__L76
	ld.w	%r10,%r11
	and	%r10,0x7	; 	xand	%r10,%r10,0x00000007
	jreq	__LX77		; 	xjreq	__L77
__LX76:				; __L76:
	int	2
	.word	__LC1
	.half	0x000000b1
__LX77:				; __L77:
	ld.w	%r12,%r2
	ld.w	%r13,0x0
	ld.w	%r14,0x1c	; 	xld.w	%r14,0x0000001c		; 28
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	%r12,%r2
	ld.w	%r13,%r0
	ld.w	%r14,0x14	; 	xld.w	%r14,0x00000014		; 20
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ext	0x14		; 	xadd	%r10,%r0,20
	add	%r10,%r0
	ext	0x14		; 	xld.w	[%r2+0x14],%r10
	ld.w	[%r2],%r10
	ext	0x9		; 	xld.ub	%r10,[%r0+0x9]
	ld.ub	%r10,[%r0]
	cmp	%r10,0x0
	jreq	__LX78		; 	xjreq	__L78
	ext	0xa		; 	xld.h	%r11,[%r0+0xa]
	ld.h	%r11,[%r0]
	ext	0xc		; 	xld.h	%r10,[%r0+0xc]
	ld.h	%r10,[%r0]
	mlt.w	%r11,%r10
	ld.w	%r1,%alr
	ext	0x8		; 	xld.ub	%r13,[%r0+0x8]
	ld.ub	%r13,[%r0]
	ld.w	%r12,0x8	; 	xld.w	%r12,0x00000008		; 8
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r12,%r1
	ld.w	%r13,%r10
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	add	%r10,0x14	; 	xadd	%r10,%r10,20
	add	%r0,%r10
	ld.w	%r10,%r0
	ext	0x18		; 	xld.w	[%r2+0x18],%r10
	ld.w	[%r2],%r10
__LX78:				; __L78:
	ld.w	%r10,%r2
	popn	%r2
	ret
	.align	1
	.global	texture_table_init
texture_table_init:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r10,[%sp+0x3]	; 	xld.w	%r10,[%sp+0xc]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ld.w	[%sp+0x3],%r10	; 	xld.w	[%sp+0xc],%r10
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jreq	__LX81		; 	xjreq	__L81
	ld.w	%r0,%sp		; 	xadd	%r0,%sp,12
	add	%r0,0xc
__LX82:				; __L82:
	add	%r0,0x4		; 	xadd	%r0,%r0,4
	ld.w	%r12,%r1
	add	%r1,0x1c	; 	xadd	%r1,%r1,28
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	call	texture_init	; 	xcall	texture_init
	ld.w	%r10,[%sp+0x3]	; 	xld.w	%r10,[%sp+0xc]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ld.w	[%sp+0x3],%r10	; 	xld.w	[%sp+0xc],%r10
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX82		; 	xjrne	__L82
__LX81:				; __L81:
	popn	%r1
	ret
	.align	1
	.global	surface_clear
surface_clear:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.h	%r11,[%r0]	; 	xld.h	%r11,[%r0]
	ext	0x2		; 	xld.h	%r10,[%r0+0x2]
	ld.h	%r10,[%r0]
	mlt.w	%r11,%r10
	ld.w	%r1,%alr
	ext	0x4		; 	xld.w	%r12,[%r0+0x4]
	ld.w	%r12,[%r0]
	cmp	%r12,0x0
	jreq	__LX85		; 	xjreq	__L85
	ld.w	%r14,%r1
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
__LX85:				; __L85:
	ext	0x8		; 	xld.w	%r12,[%r0+0x8]
	ld.w	%r12,[%r0]
	cmp	%r12,0x0
	jreq	__LX86		; 	xjreq	__L86
	ld.w	%r13,0x3f	; 	xld.w	%r13,-1			; 0xffffffff
	ld.w	%r14,%r1
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
__LX86:				; __L86:
	popn	%r1
	ret
; APP

	.code
	.align	1
	.global	surface_point
surface_point:
;//	ld.w	%r10, -1		; %r10 = -1 (߂l) ----------------------+
	ld.h	%r4, [%r12]+		; %r4  = w                                 |
	cmp	%r13, %r4		; if((unsigned)x >= (unsigned)w) return -1 |
	jruge.d	surface_point_RET	;                                          |
	ld.w	%r10, -1		; <----------------------------------------+	*delay*
	ld.h	%r9, [%r12]+		; %r9  = h
	cmp	%r14, %r9		; if((unsigned)y >= (unsigned)h) return -1
	jruge	surface_point_RET
	;
	ld.w	%r12, [%r12]		; %r12 = vbuff
	mlt.h	%r4, %r14		; %alr =         w * y
	ld.w	%r9, %alr		; %r9  =         w * y
	add	%r12, %r9		; %r12 = vbuff + w * y
	add	%r12, %r13		; %r12 = vbuff + w * y + x
	ld.ub	%r10, [%r12]		; %r10 = pixel (߂l)
surface_point_RET:
	ret


	.code
	.align	1
	.global	surface_stretch
surface_stretch:
	pushn	%r3
	sub	%sp,0x7		; 	xsub	%sp, %sp, 28
	ld.h	%r5, [%r12]+			; %r5      := dw = dst->w
	ld.h	%r2, [%r12]+			; %r2      := dh = dst->h
	ld.w	%r0, [%r12]			; %r0      := dp = dst->vbuff
	ld.h	%r6, [%r13]+			; %r6      := sw = src->w
	ld.h	%r3, [%r13]+			; %r3      := sh = src->h
	ld.w	%r1, [%r13]			; %r1      := save_sy = src->vbuff
	ld.h	[%sp+0x4],%r5	; 	xld.h	[%sp+0x8], %r5			; [%sp+8]  := dw
	ld.h	[%sp+0x5],%r6	; 	xld.h	[%sp+0xa], %r6			; [%sp+10] := sw
	ld.h	[%sp+0x6],%r2	; 	xld.h	[%sp+0xc], %r2			; [%sp+12] := dy = dh
	;// %r0      := dp
	;// %r1      := save_sy
	;// %r2      := dh
	;// %r3      := sh
	;// %r5      := dw
	;// %r6      := sw
	;// [%sp+8]  := dw
	;// [%sp+10] := sw
	;// [%sp+12] := dy
	cmp	%r2, %r3			; if(dh > sh)
	jrle.d	5
	 ld.w	%r4, %r3			;   %r4  := sh					*delay*
	 sub	%r2, 1				;   %r2  := init_y1 = dh - 1
	 ld.w	%r3, %r2			;   %r3  := init_y2 = dh - 1
	 sub	%r4, 1				;   %r4  := init_y3 = sh - 1
	cmp	%r5, %r6			; if(dw > sw)
	jrle.d	5
	 ld.w	%r7, %r6			;   %r7  := sw					*delay*
	 sub	%r5, 1				;   %r5  := init_x1 = dw - 1
	 ld.w	%r6, %r5			;   %r6  := init_x2 = dw - 1
	 sub	%r7, 1				;   %r7  := init_x3 = sw - 1
	;// %r0      := dp
	;// %r1      := save_sy
	;// %r2      := init_y1
	;// %r3      := init_y2
	;// %r4      := init_y3
	;// %r5      := init_x1
	;// %r6      := init_x2
	;// %r7      := init_x3
	;// [%sp+8]  := dw
	;// [%sp+10] := sw
	;// [%sp+12] := dy
	mlt.h	%r3, %r6			; %alr     := init_c2 = init_x2 * init_y2
	ld.w	%r9, %alr			; %r9      := init_c2
	ld.w	[%sp+0x1],%r9	; 	xld.w	[%sp+0x4], %r9			; [%sp+4]  := init_c2
	ld.h	[%sp+0x7],%r2	; 	xld.h	[%sp+0xe], %r2			; [%sp+14] := init_y1
	ld.h	[%sp+0x8],%r3	; 	xld.h	[%sp+0x10], %r3			; [%sp+16] := init_y2
	ld.h	[%sp+0x9],%r4	; 	xld.h	[%sp+0x12], %r4			; [%sp+18] := init_y3
	ld.h	[%sp+0xa],%r5	; 	xld.h	[%sp+0x14], %r5			; [%sp+20] := init_x1
	ld.h	[%sp+0xb],%r6	; 	xld.h	[%sp+0x16], %r6			; [%sp+22] := init_x2
	ld.h	[%sp+0xc],%r7	; 	xld.h	[%sp+0x18], %r7			; [%sp+24] := init_x3
	;// %r0      := dp
	;// %r1      := save_sy
	;// %r2      := save_y1
	;// [%sp+4]  := init_c2
	;// [%sp+8]  := dw
	;// [%sp+10] := sw
	;// [%sp+12] := dy
	;// [%sp+14] := init_y1
	;// [%sp+16] := init_y2
	;// [%sp+18] := init_y3
	;// [%sp+20] := init_x1
	;// [%sp+22] := init_x2
	;// [%sp+24] := init_x3
	ext	0x38		; 	xld.w	%r12, 0x0e00			; %r12 := FRAM4_START
	ld.w	%r12,0x0
	ext	surface_stretch_LOOP_DY+0x0@h	; 	xld.w	%r13, surface_stretch_LOOP_DY	; %r13 := LOOP_DY
	ext	surface_stretch_LOOP_DY+0x0@m
	ld.w	%r13,surface_stretch_LOOP_DY+0x0@l
	ext	surface_stretch_END+0x0@h	; 	xld.w	%r14, surface_stretch_END	; %r14 := END
	ext	surface_stretch_END+0x0@m
	ld.w	%r14,surface_stretch_END+0x0@l
	ld.w	[%sp+0x0],%r12	; 	xld.w	[%sp+0x0], %r12			; retp := FRAM4_START
	ext	memcpy@rm	; 	xjp.d	memcpy				; memcpy(FRAM4_START, LOOP_DY, END - LOOP_DY)
	jp.d	memcpy@rl
	sub	%r14, %r13			; %r14 := END - LOOP_DY				*delay*
	;// %r0      := dp
	;// %r1      := save_sy
	;// %r2      := save_y1
	;// [%sp+0]  := init_c2
	;// [%sp+4]  := dw
	;// [%sp+6]  := sw
	;// [%sp+8]  := dy
	;// [%sp+10] := init_y1
	;// [%sp+12] := init_y2
	;// [%sp+14] := init_y3
	;// [%sp+16] := init_x1
	;// [%sp+18] := init_x2
	;// [%sp+20] := init_x3
;//{{FRAM4̈֓]
;//{{LOOP_DY
surface_stretch_LOOP_DY:
	ld.w	%r3,0x0		; 	xld.w	%r3, 0				; %r3      := save_sx = 0
	ld.h	%r9,[%sp+0x2]	; 	xld.h	%r9, [%sp+0x4]			; %r9      := dw
	ld.h	%r4,[%sp+0x8]	; 	xld.h	%r4, [%sp+0x10]			; %r4      := save_x1 = init_x1			*anti-interlock*
	ld.h	[%sp+0xb],%r9	; 	xld.h	[%sp+0x16], %r9			; [%sp+22] := dx = dw
	;// %r0      := dp
	;// %r1      := save_sy
	;// %r2      := save_y1
	;// %r3      := save_sx
	;// %r4      := save_x1
	;// [%sp+0]  := init_c2
	;// [%sp+4]  := dw
	;// [%sp+6]  := sw
	;// [%sp+8]  := dy
	;// [%sp+10] := init_y1
	;// [%sp+12] := init_y2
	;// [%sp+14] := init_y3
	;// [%sp+16] := init_x1
	;// [%sp+18] := init_x2
	;// [%sp+20] := init_x3
	;// [%sp+22] := dx
;//{{LOOP_DX
surface_stretch_LOOP_DX:
	ld.w	%r5, %r1			; %r5  := sy = save_sy
	ld.w	%r6, %r2			; %r6  := y1 = save_y1
	ld.h	%r7,[%sp+0x6]	; 	xld.h	%r7, [%sp+0xc]			; %r7  := y2 = init_y2
	ld.w	%r12,0x0	; 	xld.w	%r12, 0				; %r12 := c1 = 0
	;// %r0      := dp
	;// %r1      := save_sy
	;// %r2      := save_y1
	;// %r3      := save_sx
	;// %r4      := save_x1
	;// %r5      := sy
	;// %r6      := y1
	;// %r7      := y2
	;// %r12     := c1
	;// [%sp+0]  := init_c2
	;// [%sp+4]  := dw
	;// [%sp+6]  := sw
	;// [%sp+8]  := dy
	;// [%sp+10] := init_y1
	;// [%sp+12] := init_y2
	;// [%sp+14] := init_y3
	;// [%sp+16] := init_x1
	;// [%sp+18] := init_x2
	;// [%sp+20] := init_x3
	;// [%sp+22] := dx
;//{{LOOP_SY
surface_stretch_LOOP_SY:
	ld.w	%r10, %r3			; %r10 := sx = save_sx
	add	%r10, %r5			; %r10 := sx = save_sx + sy
	ld.w	%r11, %r4			; %r11 := x1 = save_x1
	ld.h	%r13,[%sp+0x9]	; 	xld.h	%r13, [%sp+0x12]			; %r13 := x2 = init_x2
	cmp	%r6, %r7			; %r14 := y3 = y1 < y2 ? y1 : y2
	jrlt.d	3
	 ld.w	%r14, %r6			;						*delay*
	 ld.w	%r14, %r7
	;// %r0      := dp
	;// %r1      := save_sy
	;// %r2      := save_y1
	;// %r3      := save_sx
	;// %r4      := save_x1
	;// %r5      := sy
	;// %r6      := y1
	;// %r7      := y2
	;// %r10     := sx
	;// %r11     := x1
	;// %r12     := c1
	;// %r13     := x2
	;// %r14     := y3
	;// [%sp+0]  := init_c2
	;// [%sp+4]  := dw
	;// [%sp+6]  := sw
	;// [%sp+8]  := dy
	;// [%sp+10] := init_y1
	;// [%sp+12] := init_y2
	;// [%sp+14] := init_y3
	;// [%sp+16] := init_x1
	;// [%sp+18] := init_x2
	;// [%sp+20] := init_x3
	;// [%sp+22] := dx
;//{{LOOP_SX
surface_stretch_LOOP_SX:
	ld.ub	%r9, [%r10]			; <------------------------------+
	cmp	%r11, %r13			; %r15 := x3 = x1 < x2 ? x1 : x2 |
	jrlt.d	3				;                                |
	 ld.w	%r15, %r11			;                                |		*delay*
	 ld.w	%r15, %r13			;                                |
;//	ld.ub	%r9, [%r10]			; %r9  := [sx] ------------------+		*anti-interlock*
	mlt.h	%r9, %r15			; %alr := [sx] * x3
	ld.w	%r9, %alr			; %r9  := [sx] * x3
;//	mlt.h	%r9, %r14			; %alr := [sx] * x3 * y3 -------+
;//	ld.w	%r9, %alr			; %r9  := [sx] * x3 * y3 -------|-+
;//	add	%r12, %r9			; %r12 := c1 += [sx] * x3 * y3 -|-|-+
	sub	%r11, %r15			; %r11 := x1 -= x3              | | |
	jrne.d	5				;                               | | |
	 mlt.h	%r9, %r14			; <-----------------------------+ | |		*delay*
	ld.h	%r9,[%sp+0x8]	; 	 xld.h	%r9, [%sp+0x10]			; %r9  := init_x1                 | |
	 add	%r10, 1				; %r10 := sx++                    | |		*anti-interlock*
	 add	%r11, %r9			; %r11 := x1 += init_x1           | |
	ld.w	%r9, %alr			; <-------------------------------+ |
	sub	%r13, %r15			; %r13 := x2 -= x3                  |
	jrne.d	surface_stretch_LOOP_SX	; 	xjrne.d	surface_stretch_LOOP_SX		; while(x2 -= x3)                   |
	add	%r12, %r9			; <---------------------------------+		*delay*
;//}}LOOP_SX
	sub	%r6, %r14			; %r6  := y1 -= y3
	jrne	5
	ld.h	%r9,[%sp+0x5]	; 	 xld.h	%r9, [%sp+0xa]			; %r9  := init_y1
	ld.h	%r15,[%sp+0x3]	; 	 xld.h	%r15, [%sp+0x6]			; %r15 := sw					*anti-interlock*
	 add	%r6, %r9			; %r6  := y1 += init_y1				*anti-interlock*
	 add	%r5, %r15			; %r5  := sy += sw
	sub	%r7, %r14			; %r7  := y2 -= y3
	jrne	surface_stretch_LOOP_SY	; 	xjrne	surface_stretch_LOOP_SY		; while(y2 -= y3)
;//}}LOOP_SY
	sla	%r12, 1				; %r12 := c1<<1
	ld.w	%r13,[%sp+0x0]	; 	xld.w	%r13, [%sp+0x0]			; %r13 := init_c2
	ext	__udivsi3+0x0@h	; 	xld.w	%r10, __udivsi3			; %r10 := __udivsi3
	ext	__udivsi3+0x0@m
	ld.w	%r10,__udivsi3+0x0@l
	call.d	%r10				; %r10 := ((c1<<1)+init_c2)/init_c2
	add	%r12, %r13			; %r12 := (c1<<1)+init_c2			*delay*
;//	sra	%r10, 1				; %r10 := ((c1<<1)+init_c2)>>1 --+
;//	ld.b	[%r0]+, %r10			; *dp++ = ((c1<<1)+init_c2)>>1 --|-+
	ld.h	%r9,[%sp+0xa]	; 	xld.h	%r9, [%sp+0x14]			; %r9  := init_x3                | |
	ld.h	%r14,[%sp+0xb]	; 	xld.h	%r14, [%sp+0x16]			; <------------------------------|-|-+		*anti-interlock*
	sub	%r4, %r9			; %r4  := save_x1 -= init_x3     | | |
	jrgt.d	6				; if(save_x1 <= 0)               | | |
	 sra	%r10, 1				; <------------------------------+ | |		*delay*
	ld.h	%r9,[%sp+0x8]	; 	 xld.h	%r9, [%sp+0x10]			;   %r9  := init_x1                | |
	  add	%r4, %r9			;     %r4  := save_x1 += init_x1   | |
	 jrle.d	-1				;   while(save_x1 <= 0)            | |
	 add	%r3, 1				;   %r3  := save_sx++              | |		*delay*
	ld.b	[%r0]+, %r10			; <--------------------------------+ |
;//	xld.h	%r14, [%sp+22]			; %r14     := dx --------------------+
	sub	%r14,0x1	; 	xsub	%r14, %r14, 1			; %r14     := --dx
	ld.h	[%sp+0xb],%r14	; 	xld.h	[%sp+0x16], %r14			; [%sp+22] := --dx
	jrne	surface_stretch_LOOP_DX	; 	xjrne	surface_stretch_LOOP_DX		; while(--dx)
;//}}LOOP_DX
	ld.h	%r9,[%sp+0x7]	; 	xld.h	%r9, [%sp+0xe]			; %r9  := init_y3
	ld.h	%r14,[%sp+0x4]	; 	xld.h	%r14, [%sp+0x8]			; <------------------------------+		*anti-interlock*
	sub	%r2, %r9			; %r2  := save_y1 -= init_y3     |
	jrgt	6				; if(save_y1 <= 0)               |
	ld.h	%r9,[%sp+0x5]	; 	 xld.h	%r9, [%sp+0xa]			;   %r9  := init_y1              |
	ld.h	%r15,[%sp+0x3]	; 	 xld.h	%r15, [%sp+0x6]			;   %r15 := sw                   |
	  add	%r2, %r9			;     %r2  := save_y1 += init_y1 |
	 jrle.d	-1				;   while(save_y1 <= 0)          |
	 add	%r1, %r15			;   %r1  := save_sy += sw        |		*delay*
;//	xld.h	%r14, [%sp+8]			; %r14    := dy -----------------+
	sub	%r14,0x1	; 	xsub	%r14, %r14, 1			; %r14    := --dy
	ld.h	[%sp+0x4],%r14	; 	xld.h	[%sp+0x8], %r14			; [%sp+8] := --dy
	jrne	surface_stretch_LOOP_DY	; 	xjrne	surface_stretch_LOOP_DY		; while(--dy)
;//}}LOOP_DY
	add	%sp,0x6		; 	xadd	%sp, %sp, 24
	popn	%r3
	ret
surface_stretch_END:
;//}}܂FRAM4̈֓]

; NO_APP
	.align	1
	.global	soft_focus
soft_focus:
;	.frame	%sp,28,$31		# vars= 12, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	sub	%sp,0x3		; 	xsub	%sp,%sp,12
	ld.w	%r2,%r12
	ld.w	%r0,%r13
	ld.w	%r1,%r14
	ld.h	%r12,[%r2]	; 	xld.h	%r12,[%r2]
	ext	__floatsidf@rm	; 	xcall	__floatsidf
	call	__floatsidf@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r11
	ld.w	%r14,%r0
	ld.w	%r15,%r1
	ext	__muldf3@rm	; 	xcall	__muldf3
	call	__muldf3@rl
	ld.w	%r0,0x0		; 	xld.w	%r0,0x00000000		; double 5.00000000000000000000e-1
	ext	0x7fc		; 	xld.w	%r1,0x3fe00000		;
	ext	0x0
	ld.w	%r1,0x0
	ld.w	%r12,%r10
	ld.w	%r13,%r11
	ld.w	%r14,%r0
	ld.w	%r15,%r1
	ext	__adddf3@rm	; 	xcall	__adddf3
	call	__adddf3@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r11
	ext	__fixdfsi@rm	; 	xcall	__fixdfsi
	call	__fixdfsi@rl
	ld.h	[%sp+0x0],%r10	; 	xld.h	[%sp],%r10
	ld.h	%r10,%r10
	cmp	%r10,0x0
	jrgt	__LX88		; 	xjrgt	__L88
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ld.h	[%sp+0x0],%r10	; 	xld.h	[%sp],%r10
__LX88:				; __L88:
	ld.uh	%r12,[%r2]	; 	xld.uh	%r12,[%r2]
	ld.h	%r11,[%sp+0x0]	; 	xld.h	%r11,[%sp]
	ld.h	%r10,%r12
	cmp	%r11,%r10
	jrle	__LX89		; 	xjrle	__L89
	ld.h	[%sp+0x0],%r12	; 	xld.h	[%sp],%r12
__LX89:				; __L89:
	ext	0x2		; 	xld.h	%r12,[%r2+0x2]
	ld.h	%r12,[%r2]
	ext	__floatsidf@rm	; 	xcall	__floatsidf
	call	__floatsidf@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r11
	ld.w	%r14,[%sp+0x7]	; 	xld.w	%r14,[%sp+0x1c]
	ld.w	%r15,[%sp+0x8]	; 	xld.w	%r15,[%sp+0x20]
	ext	__muldf3@rm	; 	xcall	__muldf3
	call	__muldf3@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r11
	ld.w	%r14,%r0
	ld.w	%r15,%r1
	ext	__adddf3@rm	; 	xcall	__adddf3
	call	__adddf3@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r11
	ext	__fixdfsi@rm	; 	xcall	__fixdfsi
	call	__fixdfsi@rl
	ld.h	[%sp+0x1],%r10	; 	xld.h	[%sp+0x2],%r10
	ld.h	%r10,%r10
	cmp	%r10,0x0
	jrgt	__LX90		; 	xjrgt	__L90
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ld.h	[%sp+0x1],%r10	; 	xld.h	[%sp+0x2],%r10
__LX90:				; __L90:
	ext	0x2		; 	xld.uh	%r12,[%r2+0x2]
	ld.uh	%r12,[%r2]
	ld.h	%r11,[%sp+0x1]	; 	xld.h	%r11,[%sp+0x2]
	ld.h	%r10,%r12
	cmp	%r11,%r10
	jrle	__LX91		; 	xjrle	__L91
	ld.h	[%sp+0x1],%r12	; 	xld.h	[%sp+0x2],%r12
__LX91:				; __L91:
	ld.w	%r11,[%sp+0x0]	; 	xld.w	%r11,[%sp]
	ld.w	%r10,[%r2]	; 	xld.w	%r10,[%r2]
	cmp	%r11,%r10
	jreq	__LX87		; 	xjreq	__L87
	ld.h	%r11,[%sp+0x0]	; 	xld.h	%r11,[%sp]
	ld.h	%r10,[%sp+0x1]	; 	xld.h	%r10,[%sp+0x2]
	mlt.w	%r11,%r10
	ld.w	%r4,%alr
	ext	0xb0		; 	xcmp	%r4,11264
	cmp	%r4,0x0
	jrule	__LX93		; 	xjrule	__L93
	int	2
	.word	__LC1
	.half	0x000005a8
__LX93:				; __L93:
	ext	_def_vbuff+0x0@h	; 	xld.w	%r10,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r10,_def_vbuff+0x0@l
	ld.w	[%sp+0x1],%r10	; 	xld.w	[%sp+0x4],%r10
	ld.w	%r12,%sp
	ld.w	%r13,%r2
	ext	surface_stretch@rm	; 	xcall	surface_stretch
	call	surface_stretch@rl
	ld.w	%r12,%r2
	ld.w	%r13,%sp
	ext	surface_stretch@rm	; 	xcall	surface_stretch
	call	surface_stretch@rl
__LX87:				; __L87:
	add	%sp,0x3		; 	xadd	%sp,%sp,12
	popn	%r2
	ret
; APP

		.code
		.align		1
		.global		texture_copy
texture_copy:
		pushn		%r3
		;// %r12 := texture
		;// %r13 := surface
		;// %r14 := x
		;// %r15 := y
		ld.w		%r0, %r12				;// %r0  := texture
		ld.w		%r1, %r13				;// %r1  := surface
		ld.w		%r2, %r14				;// %r2  := x
;//		ld.w		%r3, %r15				;// %r3  := y ----------------------------------+
	ext	0x38		; 		xld.w		%r12, 0x0e00				;// %r12 := FRAM4_START				|
	ld.w	%r12,0x0
	ext	texture_copy_NOMASK_START+0x0@h	; 		xld.w		%r13, texture_copy_NOMASK_START		;// %r13 := start = texture_copy_NOMASK_START	|
	ext	texture_copy_NOMASK_START+0x0@m
	ld.w	%r13,texture_copy_NOMASK_START+0x0@l
	ext	texture_copy_NOMASK_END+0x0@h	; 		xld.w		%r14, texture_copy_NOMASK_END		;// %r14 := end   = texture_copy_NOMASK_END	|
	ext	texture_copy_NOMASK_END+0x0@m
	ld.w	%r14,texture_copy_NOMASK_END+0x0@l
	ext	0x9		; 		xbtst		[%r0+0x9], 0x0				;// %psr[Z] := !texture->header.mask		|
	btst	[%r0],0x0
		jreq.d		texture_copy_MEMCPY			;// if(texture->header.mask) {			|
		ld.w		%r3, %r15				;// %r3  := y <---------------------------------+			*delay*
	ext	texture_copy_MASK_START+0x0@h	; 		xld.w		%r13, texture_copy_MASK_START		;//   %r13 := start = texture_copy_MASK_START
	ext	texture_copy_MASK_START+0x0@m
	ld.w	%r13,texture_copy_MASK_START+0x0@l
	ext	texture_copy_MASK_END+0x0@h	; 		xld.w		%r14, texture_copy_MASK_END		;//   %r14 := end   = texture_copy_MASK_END
	ext	texture_copy_MASK_END+0x0@m
	ld.w	%r14,texture_copy_MASK_END+0x0@l
texture_copy_MEMCPY:							;// }
	ext	memcpy@rm	; 		xcall.d		memcpy					;// %r10 := memcpy(FRAM4_START, start, size)
	call.d	memcpy@rl
		sub		%r14, %r13				;// %r14 := size  = end - start						*delay*
		;// %r0  := texture
		;// %r1  := surface
		;// %r2  := x
		;// %r3  := y
		;// %r10 := FRAM4_START
	ext	0x8		; 		xld.ub		%r4, [%r0+0x8]				;// %r4  := bpp   = texture->header.bpp
	ld.ub	%r4,[%r0]
	ext	0xa		; 		xld.h		%r5, [%r0+0xa]				;// %r5  := w     = texture->header.w
	ld.h	%r5,[%r0]
	ext	0xc		; 		xld.h		%r6, [%r0+0xc]				;// %r6  := i     = texture->header.h
	ld.h	%r6,[%r0]
	ext	0x14		; 		xld.w		%r7, [%r0+0x14]				;// %r7  := buf   = texture->buf
	ld.w	%r7,[%r0]
	ld.h	%r11,[%r1]	; 		xld.h		%r11, [%r1+0x0]				;// %r11 :=                          surface->w
	ext	0x4		; 		xld.w		%r12, [%r1+0x4]				;// %r12 :=         surface->vbuff
	ld.w	%r12,[%r1]
		mlt.h		%r11, %r3				;// %alr :=                          surface->w * y
		ld.w		%r9, %alr				;// %r9  :=                          surface->w * y
		add		%r12, %r9				;// %r12 :=         surface->vbuff + surface->w * y
		add		%r12, %r2				;// %r12 := vbuff = surface->vbuff + surface->w * y + x
		sub		%r11, %r5				;// %r11 := gap   = surface->w - w, %psr[V] := 0
		ld.w		%r13, -1				;// %r13  :=        -1U
		srl		%r13, 8					;// %r13  := c    = -1U >> 8
		;// %r0  := texture
		;// %r4  := bpp
		;// %r5  := w
		;// %r6  := i
		;// %r7  := buf
		;// %r10 := FRAM4_START
		;// %r11 := gap
		;// %r12 := vbuff
		;// %r13 := c
		;// %psr[V] := 0
		jp		%r10					;// goto FRAM4_START							(jp.d %rb͕s)
;//{{FRAM4̈֓]--------------------------------------------;
texture_copy_NOMASK_START:
		mlt.h		%r5, %r4				;// %alr := w *= bpp
texture_copy_NOMASK_LOOP_I:						;// do {
		ld.w		%r14, %alr				;//   %r14 := j = w
texture_copy_NOMASK_LOOP_J:						;//   do {
texture_copy_NOMASK_LOOP_C:						;//     do {
		;// %r4  := bpp
		;// %r6  := i
		;// %r7  := buf
		;// %r11 := gap
		;// %r12 := vbuff
		;// %r13 := c
		;// %r14 := j
		;// %psr[V] := 0
		;// %alr := w
		ld.ub		%r9, [%r12]+				;//       %r9  := s = *vbuff++
		sll		%r13, %r4				;//       %r13 := c <<= bpp, %psr[N] := c[31]
		jrge.d		texture_copy_NOMASK_LOOP_C		;//     } while(!(%psr[N] ^ %psr[V]))
		or		%r13, %r9				;//       %r13 := c | s							*delay*
		ld.b		[%r7]+, %r13				;//     *buf++ = c
		sub		%r14, 8					;//     %r14 := j -= 8, %psr[V] := 0
		jrne.d		texture_copy_NOMASK_LOOP_J		;//   } while(j != 0)
		srl		%r13, 8					;//     %r13 := c = -1U >> 8						*delay*
		sub		%r6, 1					;//   %r6  := i -= 1, %psr[V] := 0
		jrne.d		texture_copy_NOMASK_LOOP_I		;// } while(i != 0)
		add		%r12, %r11				;//   %r12 := vbuff += gap, %psr[V] := 0				*delay*
		popn		%r3
		ret
texture_copy_NOMASK_END:
;//}}܂FRAM4̈֓]--------------------------------------------;
;//{{FRAM4̈֓]--------------------------------------------;
texture_copy_MASK_START:
	ext	0x18		; 		xld.w		%r0, [%r0+0x18]				;// %r0  := mask  = texture->mask
	ld.w	%r0,[%r0]
		ld.w		%r1, 1					;// %r1  :=         1
		sll		%r1, %r4				;// %r1  := trans = 1 << bpp
		ld.w		%r2, -1					;// %r2  :=         -1U
		srl		%r2, 7					;// %r2  :=       = -1U >> 7
		ld.w		%r3, %r2				;// %r3  := m     = -1U >> 7
texture_copy_MASK_LOOP_I:						;// do {
		ld.w		%r14, %r5				;//   %r14 := j = w
texture_copy_MASK_LOOP_J:						;//   do {
texture_copy_MASK_LOOP_M:						;//     do {
texture_copy_MASK_LOOP_C:						;//       do {
		;// %r0  := mask
		;// %r1  := trans
		;// %r2  := -1U >> 7
		;// %r3  := m
		;// %r4  := bpp
		;// %r6  := i
		;// %r7  := buf
		;// %r11 := gap
		;// %r12 := vbuff
		;// %r13 := c
		;// %r14 := j
		ld.ub		%r9, [%r12]+				;//         %r9  := s = *vbuff++
		cmp		%r9, %r1				;//         %psr[C] := s < trans, %psr[V] := 0
		jrge.d		3					;//         if(s < trans)
		 sll		%r13, %r4				;//         %r13 := c <<= bpp, %psr[N] := c[31]				*delay*
		 or		%r13, %r9				;//           %r13 := c | s
		jrge.d		texture_copy_MASK_LOOP_C		;//       } while(!(%psr[N] ^ %psr[V]))
		adc		%r3, %r3				;//         %r3  := m = (m << 1) | %psr[C], %psr[C] := m[32]		*delay*
		ld.b		[%r7]+, %r13				;//       *buf++ = c
		jruge.d		texture_copy_MASK_LOOP_M		;//     } while(!%psr[C])
		srl		%r13, 8					;//       %r13 := c = -1U >> 8						*delay*
		ld.b		[%r0]+, %r3				;//     *mask++ = m
		sub		%r14, 8					;//     %r14 := j -= 8
		jrne.d		texture_copy_MASK_LOOP_J		;//   } while(j != 0)
		ld.w		%r3, %r2				;//     %r3 := m = -1U >> 7						*delay*
		sub		%r6, 1					;//   %r6  := i -= 1
		jrne.d		texture_copy_MASK_LOOP_I		;// } while(i != 0)
		add		%r12, %r11				;//   %r12 := vbuff += gap						*delay*
		popn		%r3
		ret
texture_copy_MASK_END:
;//}}܂FRAM4̈֓]--------------------------------------------;


		.code
		.align		1
		.global		surface_move
surface_move:
		;// %r12     := dst
		;// %r13     := dx
		;// %r14     := dy
		;// %r15     := src
		;// [%sp+ 4] := sx
		;// [%sp+ 8] := sy
		;// [%sp+12] := w
		;// [%sp+16] := h
	ld.w	%r4,[%sp+0x1]	; 		xld.w		%r4, [%sp+ 0x4]		;// %r4  := sx
	ld.w	%r5,[%sp+0x2]	; 		xld.w		%r5, [%sp+ 0x8]		;// %r5  := sy
	ld.w	%r6,[%sp+0x3]	; 		xld.w		%r6, [%sp+0xc]		;// %r6  := w
	ld.w	%r7,[%sp+0x4]	; 		xld.w		%r7, [%sp+0x10]		;// %r7  := h
		ld.h		%r10, [%r12]+		;// %r10 := dst->w
		ld.h		%r11, [%r12]+		;// %r11 := dst->h, %r12 := &dst->vbuff
		ld.w		%r12, [%r12]		;// %r12 := dst->vbuff
		;// %r4  := sx
		;// %r5  := sy
		;// %r6  := w
		;// %r7  := h
		;// %r10 := dst->w
		;// %r11 := dst->h
		;// %r12 := dst->vbuff
		;// %r13 := dx
		;// %r14 := dy
		;// %r15 := src
		;// ]`̐NbsOs܂B
		cmp		%r13, 0			;// if(dx < 0) {
		jrge		surface_move_CLIP_L
		add		%r6, %r13		;//   %r6  := w  += dx
		sub		%r4, %r13		;//   %r4  := sx -= dx
		ld.w		%r13, 0			;//   %r13 := dx  =  0
surface_move_CLIP_L:					;// }
		;//
		sub		%r10, %r13		;// %r10 := dst->w - dx
		cmp		%r6, %r10		;// if(w >  dst->w - dx) {
		jrle		surface_move_CLIP_R
		ld.w		%r6, %r10		;//   %r6  := w = dst->w - dx
surface_move_CLIP_R:
		add		%r10, %r13		;// %r10 := dst->w
		;//
		cmp		%r6, 0			;// if(w <= 0) return
		jrle		surface_move_RET
		;// ]`̐NbsOs܂B
		cmp		%r14, 0			;// if(dy < 0) {
		jrge		surface_move_CLIP_T
		add		%r7, %r14		;//   %r7  := h  += dy
		sub		%r5, %r14		;//   %r5  := sy -= dy
		ld.w		%r14, 0			;//   %r14 := dy  =  0
surface_move_CLIP_T:					;// }
		;//
		sub		%r11, %r14		;// %r11 := dst->h - dy
		cmp		%r7, %r11		;// if(h >  dst->h - dy) {
		jrle		surface_move_CLIP_B
		ld.w		%r7, %r11		;//   %r7  := h = dst->h - dy
surface_move_CLIP_B:
		add		%r11, %r14		;// %r11 := dst->h
		;//
		cmp		%r7, 0			;// if(h <= 0) return
		jrle		surface_move_RET
		;// ]`Ɠ]`́A擪sNZAhX߂܂B
		mlt.h		%r10, %r14		;// %alr :=                    dst->w * dy
		ld.w		%r9, %alr		;// %r9  :=                    dst->w * dy
		add		%r9, %r13		;// %r9  :=                    dst->w * dy + dx
		add		%r12, %r9		;// %r12 := dptr = &dst->vbuff[dst->w * dy + dx]
		;//
		ld.h		%r11, [%r15]		;// %r11 := src->w
	ext	0x4		; 		xld.w		%r15, [%r15+0x4]		;// %r15 := src->vbuff
	ld.w	%r15,[%r15]
		;//
		mlt.h		%r11, %r5		;// %alr :=                    src->w * sy
		ld.w		%r9, %alr		;// %r9  :=                    src->w * sy
		add		%r9, %r4		;// %r9  :=                    src->w * sy + sx
		add		%r15, %r9		;// %r12 := sptr = &src->vbuff[src->w * sy + sx]
		;// %r6  := w
		;// %r7  := h
		;// %r10 := dst->w
		;// %r11 := src->w
		;// %r12 := dptr
		;// %r15 := sptr
		cmp		%r12, %r15
		jrgt		surface_move_B
		;// ]`]`̑OȂ΁A擪Rs[܂B
		sub		%r10, %r6		;// %r10 := dst->w - w
		sub		%r11, %r6		;// %r11 := src->w - w
		;// %r6  := w
		;// %r7  := y = h
		;// %r10 := dst->w - w
		;// %r11 := src->w - w
		;// %r12 := dptr
		;// %r15 := sptr
surface_move_F_LOOP_Y:					;// do {
		ld.w		%r4, %r6		;//   %r4  := x = w
surface_move_F_LOOP_X:					;//   do {
		ld.b		%r9, [%r15]+		;//     *dptr++ = *sptr++
		ld.b		[%r12]+, %r9
		sub		%r4, 1			;//     %r4  := x--
		jrne		surface_move_F_LOOP_X	;//   } while(x)
		add		%r12, %r10		;//   %r12 := dptr += dst->w - w
;//		add		%r15, %r11		;//   %r15 := sptr += src->w - w -------+
		sub		%r7, 1			;//   %r7  := y--			|
		jrne.d		surface_move_F_LOOP_Y	;// } while(y)				|
		add		%r15, %r11		;//   %r15 := sptr += src->w - w <------+
		jp		surface_move_RET
surface_move_B:
		;// ]`]`̌Ȃ΁AERs[܂B
		sub		%r6, 1			;// %r6  := w - 1
		sub		%r7, 1			;// %r7  := h - 1
		;//
		mlt.h		%r10, %r7		;// %alr :=         dst->w * (h - 1)
		ld.w		%r9, %alr		;// %r9  :=         dst->w * (h - 1)
		add		%r9, %r6		;// %r9  :=         dst->w * (h - 1) + (w - 1)
		add		%r12, %r9		;// %r12 := dptr += dst->w * (h - 1) + (w - 1)
		;//
		mlt.h		%r11, %r7		;// %alr :=         src->w * (h - 1)
		ld.w		%r9, %alr		;// %r9  :=         src->w * (h - 1)
		add		%r9, %r6		;// %r9  :=         src->w * (h - 1) + (w - 1)
		add		%r15, %r9		;// %r15 := sptr += src->w * (h - 1) + (w - 1)
		;//
		add		%r6, 1			;// %r6  := w
		add		%r7, 1			;// %r7  := h
		;//
		sub		%r10, %r6		;// %r10 := dst->w - w
		sub		%r11, %r6		;// %r11 := src->w - w
		;// %r6  := w
		;// %r7  := y = h
		;// %r10 := dst->w - w
		;// %r11 := src->w - w
		;// %r12 := dptr
		;// %r15 := sptr
surface_move_B_LOOP_Y:					;// do {
		ld.w		%r4, %r6		;//   %r4  := x = w
surface_move_B_LOOP_X:					;//   do {
		ld.b		%r9, [%r15]		;//     *dptr-- = *sptr--
		sub		%r15, 1			;//						*anti-interlock*
		ld.b		[%r12], %r9
;//		sub		%r12, 1			;// --------------------+
		sub		%r4, 1			;//     %r4  := x--	|
		jrne.d		surface_move_B_LOOP_X	;//   } while(x)	|
		sub		%r12, 1			;// <-------------------+			*delay*
		sub		%r12, %r10		;//   %r12 := dptr -= dst->w - w
;//		sub		%r15, %r11		;//   %r15 := sptr -= src->w - w -------+
		sub		%r7, 1			;//   %r7  := y--			|
		jrne.d		surface_move_B_LOOP_Y	;// } while(y)				|
		sub		%r15, %r11		;//   %r15 := sptr -= src->w - w <------+	*delay*
surface_move_RET:
		ret


		.code
		.align		1
		.global		texture_point
texture_point:
		;// %r12 := texture
		;// %r13 := x
		;// %r14 := y
		add		%r12, 8			;// %r12 :=        &texture->header.bpp
		ld.ub		%r4, [%r12]+		;// %r4  := bpp   = texture->header.bpp
		ld.ub		%r5, [%r12]+		;// %r5  := mask  = texture->header.mask
		ld.h		%r6, [%r12]+		;// %r6  := w     = texture->header.w
		ld.h		%r7, [%r12]		;// %r7  := h     = texture->header.h
		cmp		%r13, %r6		;// if((unsigned)x >= (unsigned)w)
		jruge		texture_point_RET_M1	;//   return -1
		cmp		%r14, %r7		;// if((unsigned)y >= (unsigned)h)
		jruge		texture_point_RET_M1	;//   return -1
		add		%r12, 8			;// %r12 :=        &texture->buf
		ld.w		%r10, [%r12]+		;// %r10 := pbuf  = texture->buf
		ld.w		%r11, [%r12]		;// %r11 := pmask = texture->mask
		;// %r4  := bpp
		;// %r5  := mask
		;// %r6  := w
		;// %r7  := h
		;// %r10 := pbuf
		;// %r11 := pmask
		;// %r13 := x
		;// %r14 := y
		add		%r6, 7			;// %r6  :=                  w + 7
		and		%r6, -8			;// %r6  :=                 (w + 7) & ~7
		mlt.h		%r6, %r14		;// %alr :=                ((w + 7) & ~7) * y
		ld.w		%r6, %alr		;// %r6  :=                ((w + 7) & ~7) * y
		add		%r6, %r13		;// %r6  := texel_offset = ((w + 7) & ~7) * y + x
		ld.w		%r7, 1			;// %r7  :=               1
		sla		%r7, %r4		;// %r7  :=               1 << bpp
;//		sub		%r7, 1			;// %r7  := texel_mask = (1 << bpp) - 1 --------+
		;// %r4  := bpp										|
		;// %r5  := mask									|
		;// %r6  := texel_offset								|
		;// %r7  := texel_mask									|
		;// %r10 := pbuf									|
		;// %r11 := pmask									|
		cmp		%r5, 0			;// if(mask) {					|
		jreq.d		texture_point_NO_MASK	;//						|
		sub		%r7, 1			;// <-------------------------------------------+	*delay*
		ld.w		%r12, %r6		;//   %r12 :=                texel_offset
		sra		%r12, 3			;//   %r12 := byte_offset =  texel_offset >> 3
		not		%r13, %r6		;//   %r13 :=               ~texel_offset
;//		and		%r13, 7			;//   %r13 := shift_count = ~texel_offset &  7 -+
		add		%r11, %r12		;//   %r11 :=    &pmask[byte_offset]		|
		ld.ub		%r11, [%r11]		;//   %r11 := m = pmask[byte_offset]		|
		and		%r13, 7			;// <-------------------------------------------+	*anti-interlock*
		sra		%r11, %r13		;//   %r11 := m >>= shift_count
		and		%r11, 1			;//   if(!(m & 1))
		jreq		texture_point_RET_M1	;//     return -1
texture_point_NO_MASK:					;// }
		;// %r4  := bpp
		;// %r6  := texel_offset
		;// %r7  := texel_mask
		;// %r10 := pbuf
		mlt.h		%r6, %r4		;// %alr :=                 texel_offset * bpp
		ld.w		%r12, %alr		;// %r12 :=                 texel_offset * bpp
		sra		%r12, 3			;// %r12 := byte_offset = ( texel_offset * bpp) >> 3
		not		%r13, %r6		;// %r13 :=                ~texel_offset
		mlt.h		%r13, %r4		;// %alr :=                ~texel_offset * bpp
		ld.w		%r13, %alr		;// %r13 :=                ~texel_offset * bpp
;//		and		%r13, 7			;// %r13 := shift_count = (~texel_offset * bpp) &  7 ---+
		add		%r10, %r12		;// %r10 :=    &pbuf[byte_offset]			|
		ld.ub		%r10, [%r10]		;// %r10 := c = pbuf[byte_offset]			|
		and		%r13, 7			;// <---------------------------------------------------+	*anti-interlock*
		sra		%r10, %r13		;// %r10 := c >>= shift_count
		ret.d
		and		%r10, %r7		;// %r10 := c &= texel_mask	*delay*
texture_point_RET_M1:
		ret.d
		ld.w		%r10, -1		;// %r10 := -1	*delay*


		.code
		.align		1
		.global		texture_pset
texture_pset:
		;// %r12 := texture
		;// %r13 := x
		;// %r14 := y
		;// %r15 := color
		add		%r12, 8			;// %r12 :=        &texture->header.bpp
		ld.ub		%r4, [%r12]+		;// %r4  := bpp   = texture->header.bpp
		ld.ub		%r5, [%r12]+		;// %r5  := mask  = texture->header.mask
		ld.h		%r6, [%r12]+		;// %r6  := w     = texture->header.w
		ld.h		%r7, [%r12]		;// %r7  := h     = texture->header.h
		cmp		%r13, %r6		;// if((unsigned)x >= (unsigned)w)
		jruge		texture_pset_RET	;//   return
		cmp		%r14, %r7		;// if((unsigned)y >= (unsigned)h)
		jruge		texture_pset_RET	;//   return
		add		%r12, 8			;// %r12 :=        &texture->buf
		ld.w		%r10, [%r12]+		;// %r10 := pbuf  = texture->buf
		ld.w		%r11, [%r12]		;// %r11 := pmask = texture->mask
		;// %r4  := bpp
		;// %r5  := mask
		;// %r6  := w
		;// %r7  := h
		;// %r10 := pbuf
		;// %r11 := pmask
		;// %r13 := x
		;// %r14 := y
		;// %r15 := color
		add		%r6, 7			;// %r6  :=                  w + 7
		and		%r6, -8			;// %r6  :=                 (w + 7) & ~7
		mlt.h		%r6, %r14		;// %alr :=                ((w + 7) & ~7) * y
		ld.w		%r6, %alr		;// %r6  :=                ((w + 7) & ~7) * y
		add		%r6, %r13		;// %r6  := texel_offset = ((w + 7) & ~7) * y + x
		ld.w		%r7, 1			;// %r7  :=               1
		sla		%r7, %r4		;// %r7  :=               1 << bpp
;//		sub		%r7, 1			;// %r7  := texel_mask = (1 << bpp) - 1	--------+
		;// %r4  := bpp										|
		;// %r5  := mask									|
		;// %r6  := texel_offset								|
		;// %r7  := texel_mask									|
		;// %r10 := pbuf									|
		;// %r11 := pmask									|
		;// %r15 := color									|
		cmp		%r5, 0			;// if(mask) {					|
		jreq.d		texture_pset_NO_MASK	;//						|
		sub		%r7, 1			;// <-------------------------------------------+	*delay*
		ld.w		%r12, %r6		;//   %r12 :=                texel_offset
		sra		%r12, 3			;//   %r12 := byte_offset =  texel_offset >> 3
		not		%r13, %r6		;//   %r13 :=               ~texel_offset
;//		and		%r13, 7			;//   %r13 := shift_count = ~texel_offset &  7 -+
		add		%r11, %r12		;//   %r11 :=    &pmask[byte_offset]		|
		ld.ub		%r12, [%r11]		;//   %r12 := m = pmask[byte_offset]		|
		and		%r13, 7			;// <-------------------------------------------+	*anti-interlock*
		rr		%r12, %r13		;//   %r12 := m (rr)= shift_count
		cmp		%r15, %r7		;//   if((unsigned)color > (unsigned)texel_mask) {
		jrule.d		4			;//
		or		%r12, 1			;//   %r12 := m |= 1	*delay*
		 and		%r12, -2		;//     %r12 := m &= ~1
		 ld.w		%r15, 0			;//     %r15 := color = 0
		rl		%r12, %r13		;//   %r12 := m (rl)= shift_count
		ld.b		[%r11], %r12		;//   pmask[byte_offset] = m
texture_pset_NO_MASK:					;// }
		;// %r4  := bpp
		;// %r6  := texel_offset
		;// %r7  := texel_mask
		;// %r10 := pbuf
		;// %r15 := color
		mlt.h		%r6, %r4		;// %alr :=                 texel_offset * bpp
		ld.w		%r12, %alr		;// %r12 :=                 texel_offset * bpp
		sra		%r12, 3			;// %r12 := byte_offset = ( texel_offset * bpp) >> 3
		not		%r13, %r6		;// %r13 :=                ~texel_offset
		mlt.h		%r13, %r4		;// %alr :=                ~texel_offset * bpp
		ld.w		%r13, %alr		;// %r13 :=                ~texel_offset * bpp
;//		and		%r13, 7			;// %r13 := shift_count = (~texel_offset * bpp) &  7 ---+
		add		%r10, %r12		;// %r10 :=    &pbuf[byte_offset]			|
		ld.ub		%r11, [%r10]		;// %r11 := c = pbuf[byte_offset]			|
		and		%r13, 7			;// <---------------------------------------------------+	*anti-interlock*
		rr		%r11, %r13		;// %r10 := c (rr)= shift_count
		not		%r7, %r7		;// %r7  :=      ~texel_mask
		and		%r11, %r7		;// %r11 := c &= ~texel_mask
		or		%r11, %r15		;// %r11 := c |=  color
		rl		%r11, %r13		;// %r11 := c (rl)= shift_count
		ld.b		[%r10], %r11		;// pbuf[byte_offset] = c
texture_pset_RET:
		ret

; NO_APP
	.align	1
	.global	render_init_2d
render_init_2d:
;	.frame	%sp,28,$31		# vars= 8, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x2		; 	xsub	%sp,%sp,8
	ld.w	%r0,%r12
	ld.w	%r3,%r13
	ld.w	[%sp+0x0],%r14	; 	xld.w	[%sp],%r14
	ld.w	[%sp+0x1],%r15	; 	xld.w	[%sp+0x4],%r15
	ld.w	%r1,[%sp+0x7]	; 	xld.w	%r1,[%sp+0x1c]
	ld.w	%r2,[%sp+0x8]	; 	xld.w	%r2,[%sp+0x20]
	ld.w	%r13,0x0
	ext	0x6		; 	xld.w	%r14,0x000001b8		; 440
	ld.w	%r14,0x38
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	[%r0],%r3	; 	xld.w	[%r0],%r3
	cmp	%r1,0x0
	jrne	__LX95		; 	xjrne	__L95
	ld.h	%r1,[%r3]	; 	xld.h	%r1,[%r3]
__LX95:				; __L95:
	cmp	%r2,0x0
	jrne	__LX96		; 	xjrne	__L96
	ext	0x2		; 	xld.h	%r2,[%r3+0x2]
	ld.h	%r2,[%r3]
__LX96:				; __L96:
	ld.uh	%r4,[%sp+0x0]	; 	xld.uh	%r4,[%sp]
	ext	0x4		; 	xld.h	[%r0+0x4],%r4
	ld.h	[%r0],%r4
	ld.uh	%r4,[%sp+0x2]	; 	xld.uh	%r4,[%sp+0x4]
	ext	0x6		; 	xld.h	[%r0+0x6],%r4
	ld.h	[%r0],%r4
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	add	%r10,%r1
	ext	0x8		; 	xld.h	[%r0+0x8],%r10
	ld.h	[%r0],%r10
	ld.w	%r10,[%sp+0x1]	; 	xld.w	%r10,[%sp+0x4]
	add	%r10,%r2
	ext	0xa		; 	xld.h	[%r0+0xa],%r10
	ld.h	[%r0],%r10
	ext	0x4		; 	xld.h	%r10,[%r0+0x4]
	ld.h	%r10,[%r0]
	cmp	%r10,0x0
	jrge	__LX97		; 	xjrge	__L97
	ld.w	%r4,0x0
	ext	0x4		; 	xld.h	[%r0+0x4],%r4
	ld.h	[%r0],%r4
__LX97:				; __L97:
	ext	0x6		; 	xld.h	%r10,[%r0+0x6]
	ld.h	%r10,[%r0]
	cmp	%r10,0x0
	jrge	__LX98		; 	xjrge	__L98
	ld.w	%r4,0x0
	ext	0x6		; 	xld.h	[%r0+0x6],%r4
	ld.h	[%r0],%r4
__LX98:				; __L98:
	ld.uh	%r12,[%r3]	; 	xld.uh	%r12,[%r3]
	ext	0x8		; 	xld.h	%r11,[%r0+0x8]
	ld.h	%r11,[%r0]
	ld.h	%r10,%r12
	cmp	%r11,%r10
	jrle	__LX99		; 	xjrle	__L99
	ext	0x8		; 	xld.h	[%r0+0x8],%r12
	ld.h	[%r0],%r12
__LX99:				; __L99:
	ext	0x2		; 	xld.uh	%r13,[%r3+0x2]
	ld.uh	%r13,[%r3]
	ext	0xa		; 	xld.h	%r11,[%r0+0xa]
	ld.h	%r11,[%r0]
	ld.h	%r10,%r13
	cmp	%r11,%r10
	jrle	__LX100		; 	xjrle	__L100
	ext	0xa		; 	xld.h	[%r0+0xa],%r13
	ld.h	[%r0],%r13
__LX100:				; __L100:
	ext	0x18		; 	xadd	%r10,%r0,24
	add	%r10,%r0
	ext	0x14		; 	xld.w	[%r0+0x14],%r10
	ld.w	[%r0],%r10
	add	%sp,0x2		; 	xadd	%sp,%sp,8
	popn	%r3
	ret
	.align	1
	.global	render_save
render_save:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x14		; 	xld.w	%r10,[%r12+0x14]
	ld.w	%r10,[%r12]
	ext	0x0		; 	xld.w	%r14,0x00000034		; 52
	ld.w	%r14,0x34
	add	%r10,%r14
	ext	0x14		; 	xld.w	[%r12+0x14],%r10
	ld.w	[%r12],%r10
	ext	0x6		; 	xadd	%r12,%r12,440
	add	%r12,0x38
	cmp	%r10,%r12
	jrne	__LX102		; 	xjrne	__L102
	int	2
	.word	__LC1
	.half	0x00000868
__LX102:				; __L102:
	ld.w	%r12,%r10
	ext	0x34		; 	xsub	%r13,%r12,52
	sub	%r13,%r12
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ret
	.align	1
	.global	render_restore
render_restore:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x14		; 	xld.w	%r11,[%r12+0x14]
	ld.w	%r11,[%r12]
	ext	0x34		; 	xsub	%r10,%r11,52
	sub	%r10,%r11
	ext	0x14		; 	xld.w	[%r12+0x14],%r10
	ld.w	[%r12],%r10
	add	%r12,0x18	; 	xadd	%r12,%r12,24
	cmp	%r11,%r12
	jrne	__LX104		; 	xjrne	__L104
	int	2
	.word	__LC1
	.half	0x00000870
__LX104:				; __L104:
	ret
; APP

	.code
	.align	1
	.global	render_point
render_point:
	ld.w	%r4, [%r12]+		; %r4  = surface
	;
	ld.h	%r9, [%r12]+		; %r9  = left
	cmp	%r13, %r9		; if(x < left) return
	jrlt	render_point_RET
	ld.h	%r9, [%r12]+		; %r9  = top
	cmp	%r14, %r9		; if(y < top) return
	jrlt	render_point_RET
	ld.h	%r9, [%r12]+		; %r9  = right
	cmp	%r13, %r9		; if(x >= right) return
	jrge	render_point_RET
	ld.h	%r9, [%r12]		; %r9  = bottom
	cmp	%r14, %r9		; if(y >= bottom) return	!INTERLOCK!
	jrge	render_point_RET
	;
	ld.w	%r5, [%r4]+		; %r5  = w | (h<<16)		(h<<16)mlt.hŖ
	ld.w	%r4, [%r4]		; %r4  = vbuff
	mlt.h	%r5, %r14		; %alr =         w * y
	ld.w	%r9, %alr		; %r9  =         w * y
	add	%r4, %r9		; %r4  = vbuff + w * y
	add	%r4, %r13		; %r4  = vbuff + w * y + x
	ld.b	[%r4], %r15
render_point_RET:
	ret

; NO_APP
	.align	1
	.global	render_paint
render_paint:
;	.frame	%sp,292,$31		# vars= 272, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x44	; 	xsub	%sp,%sp,272
	ext	0x4		; 	xld.w	[%sp+0x100],%r12
	ld.w	[%sp+0x0],%r12
	ld.w	%r1,%r14
	ext	0x4		; 	xld.w	[%sp+0x104],%r15
	ld.w	[%sp+0x4],%r15
	ld.w	%r3,0x0
	ext	0x4		; 	xld.w	[%sp+0x108],%r3
	ld.w	[%sp+0x8],%r3
	ld.w	%r12,[%r12]	; 	xld.w	%r12,[%r12]
	ext	0x4		; 	xld.w	%r3,[%sp+0x100]
	ld.w	%r3,[%sp+0x0]
	ext	0x4		; 	xld.h	%r10,[%r3+0x4]
	ld.h	%r10,[%r3]
	cmp	%r13,%r10
	ext	__LX169@rm	; 	xjrlt	__L169
	jrlt	__LX169@rl
	ext	0x8		; 	xld.h	%r10,[%r3+0x8]
	ld.h	%r10,[%r3]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	cmp	%r10,%r13
	ext	__LX169@rm	; 	xjrlt	__L169
	jrlt	__LX169@rl
	ext	0x4		; 	xld.w	%r3,[%sp+0x100]
	ld.w	%r3,[%sp+0x0]
	ext	0x6		; 	xld.h	%r10,[%r3+0x6]
	ld.h	%r10,[%r3]
	cmp	%r1,%r10
	ext	__LX169@rm	; 	xjrlt	__L169
	jrlt	__LX169@rl
	ext	0xa		; 	xld.h	%r10,[%r3+0xa]
	ld.h	%r10,[%r3]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	cmp	%r10,%r1
	ext	__LX169@rm	; 	xjrlt	__L169
	jrlt	__LX169@rl
	ld.h	%r10,[%r12]	; 	xld.h	%r10,[%r12]
	mlt.w	%r10,%r1
	ld.w	%r11,%alr
	add	%r11,%r13
	ext	0x4		; 	xld.w	%r10,[%r12+0x4]
	ld.w	%r10,[%r12]
	add	%r10,%r11
	ld.ub	%r10,[%r10]	; 	xld.ub	%r10,[%r10]
	ld.h	[%sp+0x0],%r13	; 	xld.h	[%sp],%r13
	ld.h	[%sp+0x1],%r1	; 	xld.h	[%sp+0x2],%r1
	ld.w	%r0,0x1		; 	xld.w	%r0,0x00000001		; 1
	ld.ub	%r2,%r10
	ld.w	%r3,%sp		; 	xadd	%r3,%sp,4
	add	%r3,0x4
	ext	0x4		; 	xld.w	[%sp+0x10c],%r3
	ld.w	[%sp+0xc],%r3
__LX112:				; __L112:
	ext	0x4		; 	xld.w	%r3,[%sp+0x10c]
	ld.w	%r3,[%sp+0xc]
	sub	%r3,0x4		; 	xsub	%r3,%r3,4
	ext	0x4		; 	xld.w	[%sp+0x10c],%r3
	ld.w	[%sp+0xc],%r3
	sub	%r0,0x1		; 	xsub	%r0,%r0,1
	ld.h	%r13,[%r3]	; 	xld.h	%r13,[%r3]
	ext	0x2		; 	xld.h	%r1,[%r3+0x2]
	ld.h	%r1,[%r3]
	ld.h	%r10,[%r12]	; 	xld.h	%r10,[%r12]
	mlt.w	%r10,%r1
	ld.w	%r5,%alr
	ld.w	%r11,%r5
	add	%r11,%r13
	ext	0x4		; 	xld.w	%r4,[%r12+0x4]
	ld.w	%r4,[%r12]
	ld.w	%r10,%r4
	add	%r10,%r11
	ld.ub	%r10,[%r10]	; 	xld.ub	%r10,[%r10]
	ext	0x4		; 	xld.w	%r3,[%sp+0x104]
	ld.w	%r3,[%sp+0x4]
	cmp	%r10,%r3
	ext	__LX110@rm	; 	xjreq	__L110
	jreq	__LX110@rl
	ext	0x1		; 	xsub	%r7,%r13,1
	sub	%r7,%r13
	ext	0x4		; 	xld.w	%r3,[%sp+0x100]
	ld.w	%r3,[%sp+0x0]
	ext	0x4		; 	xld.h	%r10,[%r3+0x4]
	ld.h	%r10,[%r3]
	cmp	%r7,%r10
	jrlt	__LX115		; 	xjrlt	__L115
	ld.w	%r6,%r5
	ld.w	%r5,%r4
	ld.w	%r4,%r10
__LX117:				; __L117:
	ld.w	%r11,%r6
	add	%r11,%r7
	ld.w	%r10,%r5
	add	%r10,%r11
	ld.ub	%r10,[%r10]	; 	xld.ub	%r10,[%r10]
	cmp	%r10,%r2
	jrne	__LX115		; 	xjrne	__L115
	sub	%r7,0x1		; 	xsub	%r7,%r7,1
	cmp	%r7,%r4
	jrge	__LX117		; 	xjrge	__L117
__LX115:				; __L115:
	add	%r7,0x1		; 	xadd	%r7,%r7,1
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	ext	0x4		; 	xld.w	%r3,[%sp+0x100]
	ld.w	%r3,[%sp+0x0]
	ext	0x8		; 	xld.h	%r10,[%r3+0x8]
	ld.h	%r10,[%r3]
	ext	0x1		; 	xsub	%r11,%r10,1
	sub	%r11,%r10
	cmp	%r13,%r11
	jrgt	__LX121		; 	xjrgt	__L121
	ld.h	%r10,[%r12]	; 	xld.h	%r10,[%r12]
	mlt.w	%r10,%r1
	ld.w	%r6,%alr
	ext	0x4		; 	xld.w	%r5,[%r12+0x4]
	ld.w	%r5,[%r12]
	ld.w	%r4,%r11
__LX123:				; __L123:
	ld.w	%r11,%r6
	add	%r11,%r13
	ld.w	%r10,%r5
	add	%r10,%r11
	ld.ub	%r10,[%r10]	; 	xld.ub	%r10,[%r10]
	cmp	%r10,%r2
	jrne	__LX121		; 	xjrne	__L121
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	cmp	%r13,%r4
	jrle	__LX123		; 	xjrle	__L123
__LX121:				; __L121:
	sub	%r13,0x1	; 	xsub	%r13,%r13,1
	ld.w	%r4,%r7
	cmp	%r4,%r13
	jrgt	__LX127		; 	xjrgt	__L127
__LX129:				; __L129:
	ld.h	%r10,[%r12]	; 	xld.h	%r10,[%r12]
	mlt.w	%r10,%r1
	ld.w	%r11,%alr
	add	%r11,%r4
	ext	0x4		; 	xld.w	%r10,[%r12+0x4]
	ld.w	%r10,[%r12]
	add	%r10,%r11
	ext	0x4		; 	xld.ub	%r3,[%sp+0x104]
	ld.ub	%r3,[%sp+0x4]
	ld.b	[%r10],%r3	; 	xld.b	[%r10],%r3
	ext	0x4		; 	xld.w	%r3,[%sp+0x108]
	ld.w	%r3,[%sp+0x8]
	add	%r3,0x1		; 	xadd	%r3,%r3,1
	ext	0x4		; 	xld.w	[%sp+0x108],%r3
	ld.w	[%sp+0x8],%r3
	add	%r4,0x1		; 	xadd	%r4,%r4,1
	cmp	%r4,%r13
	jrle	__LX129		; 	xjrle	__L129
__LX127:				; __L127:
	ext	0x4		; 	xld.w	%r3,[%sp+0x100]
	ld.w	%r3,[%sp+0x0]
	ext	0x6		; 	xld.h	%r10,[%r3+0x6]
	ld.h	%r10,[%r3]
	cmp	%r1,%r10
	jreq	__LX131		; 	xjreq	__L131
	ext	0x1		; 	xsub	%r15,%r1,1
	sub	%r15,%r1
	ld.w	%r4,%r7
	ld.w	%r10,%r0
	sll	%r10,0x2	; 	xsll	%r10,2
	ld.w	%r14,%r10
	ld.w	%r9,%sp		; 	xadd	%r14,%r14,%sp
	add	%r14,%r9
__LX132:				; __L132:
	cmp	%r4,%r13
	jrgt	__LX131		; 	xjrgt	__L131
	ld.h	%r10,[%r12]	; 	xld.h	%r10,[%r12]
	mlt.w	%r10,%r15
	ld.w	%r6,%alr
	ext	0x4		; 	xld.w	%r5,[%r12+0x4]
	ld.w	%r5,[%r12]
__LX138:				; __L138:
	ld.w	%r11,%r6
	add	%r11,%r4
	ld.w	%r10,%r5
	add	%r10,%r11
	ld.ub	%r10,[%r10]	; 	xld.ub	%r10,[%r10]
	cmp	%r10,%r2
	jreq	__LX136		; 	xjreq	__L136
	add	%r4,0x1		; 	xadd	%r4,%r4,1
	cmp	%r4,%r13
	jrle	__LX138		; 	xjrle	__L138
__LX136:				; __L136:
	cmp	%r4,%r13
	jrgt	__LX131		; 	xjrgt	__L131
	ld.h	%r10,[%r12]	; 	xld.h	%r10,[%r12]
	mlt.w	%r10,%r15
	ld.w	%r6,%alr
	ext	0x4		; 	xld.w	%r5,[%r12+0x4]
	ld.w	%r5,[%r12]
__LX145:				; __L145:
	ld.w	%r11,%r6
	add	%r11,%r4
	ld.w	%r10,%r5
	add	%r10,%r11
	ld.ub	%r10,[%r10]	; 	xld.ub	%r10,[%r10]
	cmp	%r10,%r2
	jrne	__LX143		; 	xjrne	__L143
	add	%r4,0x1		; 	xadd	%r4,%r4,1
	cmp	%r4,%r13
	jrle	__LX145		; 	xjrle	__L145
__LX143:				; __L143:
	ext	0x0		; 	xcmp	%r0,63
	cmp	%r0,0x3f
	jrgt	__LX132		; 	xjrgt	__L132
	ext	0x1		; 	xsub	%r10,%r4,1
	sub	%r10,%r4
	ld.h	[%r14],%r10	; 	xld.h	[%r14],%r10
	ext	0x2		; 	xld.h	[%r14+0x2],%r15
	ld.h	[%r14],%r15
	add	%r14,0x4	; 	xadd	%r14,%r14,4
	ext	0x4		; 	xld.w	%r3,[%sp+0x10c]
	ld.w	%r3,[%sp+0xc]
	add	%r3,0x4		; 	xadd	%r3,%r3,4
	ext	0x4		; 	xld.w	[%sp+0x10c],%r3
	ld.w	[%sp+0xc],%r3
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	jp	__LX132		; 	xjp	__L132
__LX131:				; __L131:
	ext	0x4		; 	xld.w	%r3,[%sp+0x100]
	ld.w	%r3,[%sp+0x0]
	ext	0xa		; 	xld.h	%r10,[%r3+0xa]
	ld.h	%r10,[%r3]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	cmp	%r1,%r10
	jreq	__LX110		; 	xjreq	__L110
	ext	0x1		; 	xadd	%r15,%r1,1
	add	%r15,%r1
	ld.w	%r4,%r7
	ld.w	%r10,%r0
	sll	%r10,0x2	; 	xsll	%r10,2
	ld.w	%r6,%r10
	ld.w	%r9,%sp		; 	xadd	%r6,%r6,%sp
	add	%r6,%r9
__LX150:				; __L150:
	cmp	%r4,%r13
	jrgt	__LX110		; 	xjrgt	__L110
	ld.h	%r10,[%r12]	; 	xld.h	%r10,[%r12]
	mlt.w	%r10,%r15
	ld.w	%r5,%alr
	ext	0x4		; 	xld.w	%r14,[%r12+0x4]
	ld.w	%r14,[%r12]
__LX156:				; __L156:
	ld.w	%r11,%r5
	add	%r11,%r4
	ld.w	%r10,%r14
	add	%r10,%r11
	ld.ub	%r10,[%r10]	; 	xld.ub	%r10,[%r10]
	cmp	%r10,%r2
	jreq	__LX154		; 	xjreq	__L154
	add	%r4,0x1		; 	xadd	%r4,%r4,1
	cmp	%r4,%r13
	jrle	__LX156		; 	xjrle	__L156
__LX154:				; __L154:
	cmp	%r4,%r13
	jrgt	__LX110		; 	xjrgt	__L110
	ld.h	%r10,[%r12]	; 	xld.h	%r10,[%r12]
	mlt.w	%r10,%r15
	ld.w	%r5,%alr
	ext	0x4		; 	xld.w	%r14,[%r12+0x4]
	ld.w	%r14,[%r12]
__LX163:				; __L163:
	ld.w	%r11,%r5
	add	%r11,%r4
	ld.w	%r10,%r14
	add	%r10,%r11
	ld.ub	%r10,[%r10]	; 	xld.ub	%r10,[%r10]
	cmp	%r10,%r2
	jrne	__LX161		; 	xjrne	__L161
	add	%r4,0x1		; 	xadd	%r4,%r4,1
	cmp	%r4,%r13
	jrle	__LX163		; 	xjrle	__L163
__LX161:				; __L161:
	ext	0x0		; 	xcmp	%r0,63
	cmp	%r0,0x3f
	jrgt	__LX150		; 	xjrgt	__L150
	ext	0x1		; 	xsub	%r10,%r4,1
	sub	%r10,%r4
	ld.h	[%r6],%r10	; 	xld.h	[%r6],%r10
	ext	0x2		; 	xld.h	[%r6+0x2],%r15
	ld.h	[%r6],%r15
	add	%r6,0x4		; 	xadd	%r6,%r6,4
	ext	0x4		; 	xld.w	%r3,[%sp+0x10c]
	ld.w	%r3,[%sp+0xc]
	add	%r3,0x4		; 	xadd	%r3,%r3,4
	ext	0x4		; 	xld.w	[%sp+0x10c],%r3
	ld.w	[%sp+0xc],%r3
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	jp	__LX150		; 	xjp	__L150
__LX110:				; __L110:
	cmp	%r0,0x0
	ext	__LX112@rm	; 	xjrne	__L112
	jrne	__LX112@rl
__LX169:				; __L169:
	ext	0x4		; 	xld.w	%r10,[%sp+0x108]
	ld.w	%r10,[%sp+0x8]
	add	%sp,0x44	; 	xadd	%sp,%sp,272
	popn	%r3
	ret
	.align	1
	.global	render_dashes
render_dashes:
;	.frame	%sp,36,$31		# vars= 16, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x4		; 	xsub	%sp,%sp,16
	ld.w	[%sp+0x0],%r12	; 	xld.w	[%sp],%r12
	ld.w	%r1,%r13
	ld.w	%r3,%r14
	ld.w	%r2,%r15
	ld.w	%r6,0x0
	ld.w	[%sp+0x2],%r6	; 	xld.w	[%sp+0x8],%r6
	ld.w	%r7,[%r12]	; 	xld.w	%r7,[%r12]
	ld.w	[%sp+0x1],%r7	; 	xld.w	[%sp+0x4],%r7
	ext	0x4		; 	xld.h	%r0,[%r12+0x4]
	ld.h	%r0,[%r12]
	cmp	%r1,%r0
	jrge	__LX171		; 	xjrge	__L171
	cmp	%r2,%r0
	ext	__LX209@rm	; 	xjrlt	__L209
	jrlt	__LX209@rl
	ld.w	%r11,[%sp+0x9]	; 	xld.w	%r11,[%sp+0x24]
	sub	%r11,%r3
	ld.w	%r10,%r0
	sub	%r10,%r1
	mlt.w	%r11,%r10
	ld.w	%r12,%alr
	ld.w	%r13,%r2
	sub	%r13,%r1
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	add	%r3,%r10
	ld.w	%r1,%r0
__LX171:				; __L171:
	ld.w	%r6,[%sp+0x0]	; 	xld.w	%r6,[%sp]
	ext	0x4		; 	xld.h	%r0,[%r6+0x4]
	ld.h	%r0,[%r6]
	cmp	%r2,%r0
	jrge	__LX174		; 	xjrge	__L174
	cmp	%r1,%r0
	ext	__LX209@rm	; 	xjrlt	__L209
	jrlt	__LX209@rl
	ld.w	%r11,%r3
	ld.w	%r7,[%sp+0x9]	; 	xld.w	%r7,[%sp+0x24]
	sub	%r11,%r7
	ld.w	%r10,%r0
	sub	%r10,%r2
	mlt.w	%r11,%r10
	ld.w	%r12,%alr
	ld.w	%r13,%r1
	sub	%r13,%r2
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r6,[%sp+0x9]	; 	xld.w	%r6,[%sp+0x24]
	add	%r6,%r10
	ld.w	[%sp+0x9],%r6	; 	xld.w	[%sp+0x24],%r6
	ld.w	%r2,%r0
	ld.w	%r7,[%sp+0x2]	; 	xld.w	%r7,[%sp+0x8]
	or	%r7,0x1		; 	xoor	%r7,%r7,0x00000001
	ld.w	[%sp+0x2],%r7	; 	xld.w	[%sp+0x8],%r7
__LX174:				; __L174:
	ld.w	%r6,[%sp+0x0]	; 	xld.w	%r6,[%sp]
	ext	0x8		; 	xld.h	%r12,[%r6+0x8]
	ld.h	%r12,[%r6]
	ext	0x1		; 	xsub	%r0,%r12,1
	sub	%r0,%r12
	cmp	%r1,%r0
	jrle	__LX177		; 	xjrle	__L177
	cmp	%r2,%r0
	ext	__LX209@rm	; 	xjrgt	__L209
	jrgt	__LX209@rl
	ld.w	%r11,[%sp+0x9]	; 	xld.w	%r11,[%sp+0x24]
	sub	%r11,%r3
	ext	0x1		; 	xadd	%r10,%r1,1
	add	%r10,%r1
	sub	%r12,%r10
	ld.w	%r10,%r12
	mlt.w	%r11,%r10
	ld.w	%r12,%alr
	ld.w	%r13,%r2
	sub	%r13,%r1
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	add	%r3,%r10
	ld.w	%r1,%r0
__LX177:				; __L177:
	ld.w	%r7,[%sp+0x0]	; 	xld.w	%r7,[%sp]
	ext	0x8		; 	xld.h	%r12,[%r7+0x8]
	ld.h	%r12,[%r7]
	ext	0x1		; 	xsub	%r0,%r12,1
	sub	%r0,%r12
	cmp	%r2,%r0
	jrle	__LX180		; 	xjrle	__L180
	cmp	%r1,%r0
	ext	__LX209@rm	; 	xjrgt	__L209
	jrgt	__LX209@rl
	ld.w	%r11,%r3
	ld.w	%r6,[%sp+0x9]	; 	xld.w	%r6,[%sp+0x24]
	sub	%r11,%r6
	ext	0x1		; 	xadd	%r10,%r2,1
	add	%r10,%r2
	sub	%r12,%r10
	ld.w	%r10,%r12
	mlt.w	%r11,%r10
	ld.w	%r12,%alr
	ld.w	%r13,%r1
	sub	%r13,%r2
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r7,[%sp+0x9]	; 	xld.w	%r7,[%sp+0x24]
	add	%r7,%r10
	ld.w	[%sp+0x9],%r7	; 	xld.w	[%sp+0x24],%r7
	ld.w	%r2,%r0
	ld.w	%r6,[%sp+0x2]	; 	xld.w	%r6,[%sp+0x8]
	or	%r6,0x1		; 	xoor	%r6,%r6,0x00000001
	ld.w	[%sp+0x2],%r6	; 	xld.w	[%sp+0x8],%r6
__LX180:				; __L180:
	ld.w	%r7,[%sp+0x0]	; 	xld.w	%r7,[%sp]
	ext	0x6		; 	xld.h	%r0,[%r7+0x6]
	ld.h	%r0,[%r7]
	cmp	%r3,%r0
	jrge	__LX183		; 	xjrge	__L183
	ld.w	%r6,[%sp+0x9]	; 	xld.w	%r6,[%sp+0x24]
	cmp	%r6,%r0
	ext	__LX209@rm	; 	xjrlt	__L209
	jrlt	__LX209@rl
	ld.w	%r11,%r2
	sub	%r11,%r1
	ld.w	%r10,%r0
	sub	%r10,%r3
	mlt.w	%r11,%r10
	ld.w	%r12,%alr
	ld.w	%r13,[%sp+0x9]	; 	xld.w	%r13,[%sp+0x24]
	sub	%r13,%r3
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	add	%r1,%r10
	ld.w	%r3,%r0
__LX183:				; __L183:
	ld.w	%r7,[%sp+0x0]	; 	xld.w	%r7,[%sp]
	ext	0x6		; 	xld.h	%r0,[%r7+0x6]
	ld.h	%r0,[%r7]
	ld.w	%r6,[%sp+0x9]	; 	xld.w	%r6,[%sp+0x24]
	cmp	%r6,%r0
	jrge	__LX186		; 	xjrge	__L186
	cmp	%r3,%r0
	ext	__LX209@rm	; 	xjrlt	__L209
	jrlt	__LX209@rl
	ld.w	%r11,%r1
	sub	%r11,%r2
	ld.w	%r10,%r0
	ld.w	%r7,[%sp+0x9]	; 	xld.w	%r7,[%sp+0x24]
	sub	%r10,%r7
	mlt.w	%r11,%r10
	ld.w	%r12,%alr
	ld.w	%r13,%r3
	sub	%r13,%r7
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	add	%r2,%r10
	ld.w	[%sp+0x9],%r0	; 	xld.w	[%sp+0x24],%r0
	ld.w	%r6,[%sp+0x2]	; 	xld.w	%r6,[%sp+0x8]
	or	%r6,0x1		; 	xoor	%r6,%r6,0x00000001
	ld.w	[%sp+0x2],%r6	; 	xld.w	[%sp+0x8],%r6
__LX186:				; __L186:
	ld.w	%r7,[%sp+0x0]	; 	xld.w	%r7,[%sp]
	ext	0xa		; 	xld.h	%r12,[%r7+0xa]
	ld.h	%r12,[%r7]
	ext	0x1		; 	xsub	%r0,%r12,1
	sub	%r0,%r12
	cmp	%r3,%r0
	jrle	__LX189		; 	xjrle	__L189
	ld.w	%r6,[%sp+0x9]	; 	xld.w	%r6,[%sp+0x24]
	cmp	%r6,%r0
	ext	__LX209@rm	; 	xjrgt	__L209
	jrgt	__LX209@rl
	ld.w	%r11,%r2
	sub	%r11,%r1
	ext	0x1		; 	xadd	%r10,%r3,1
	add	%r10,%r3
	sub	%r12,%r10
	ld.w	%r10,%r12
	mlt.w	%r11,%r10
	ld.w	%r12,%alr
	ld.w	%r13,[%sp+0x9]	; 	xld.w	%r13,[%sp+0x24]
	sub	%r13,%r3
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	add	%r1,%r10
	ld.w	%r3,%r0
__LX189:				; __L189:
	ld.w	%r7,[%sp+0x0]	; 	xld.w	%r7,[%sp]
	ext	0xa		; 	xld.h	%r12,[%r7+0xa]
	ld.h	%r12,[%r7]
	ext	0x1		; 	xsub	%r0,%r12,1
	sub	%r0,%r12
	ld.w	%r6,[%sp+0x9]	; 	xld.w	%r6,[%sp+0x24]
	cmp	%r6,%r0
	jrle	__LX192		; 	xjrle	__L192
	cmp	%r3,%r0
	jrgt	__LX209		; 	xjrgt	__L209
	ld.w	%r11,%r1
	sub	%r11,%r2
	ld.w	%r10,[%sp+0x9]	; 	xld.w	%r10,[%sp+0x24]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	sub	%r12,%r10
	ld.w	%r10,%r12
	mlt.w	%r11,%r10
	ld.w	%r12,%alr
	ld.w	%r13,%r3
	ld.w	%r7,[%sp+0x9]	; 	xld.w	%r7,[%sp+0x24]
	sub	%r13,%r7
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	add	%r2,%r10
	ld.w	[%sp+0x9],%r0	; 	xld.w	[%sp+0x24],%r0
	ld.w	%r6,[%sp+0x2]	; 	xld.w	%r6,[%sp+0x8]
	or	%r6,0x1		; 	xoor	%r6,%r6,0x00000001
	ld.w	[%sp+0x2],%r6	; 	xld.w	[%sp+0x8],%r6
__LX192:				; __L192:
	ld.w	%r7,[%sp+0x1]	; 	xld.w	%r7,[%sp+0x4]
	ld.h	%r10,[%r7]	; 	xld.h	%r10,[%r7]
	mlt.w	%r10,%r3
	ld.w	%r11,%alr
	add	%r11,%r1
	ext	0x4		; 	xld.w	%r10,[%r7+0x4]
	ld.w	%r10,[%r7]
	ld.w	%r0,%r10
	add	%r0,%r11
	cmp	%r2,%r1
	jrlt	__LX195		; 	xjrlt	__L195
	sub	%r2,%r1
	ld.w	%r5,0x1		; 	xld.w	%r5,0x00000001		; 1
	jp	__LX196		; 	xjp	__L196
__LX195:				; __L195:
	sub	%r1,%r2
	ld.w	%r2,%r1
	ld.w	%r5,0x3f	; 	xld.w	%r5,-1			; 0xffffffff
__LX196:				; __L196:
	ld.w	%r6,[%sp+0x9]	; 	xld.w	%r6,[%sp+0x24]
	cmp	%r6,%r3
	jrlt	__LX197		; 	xjrlt	__L197
	ld.w	%r1,%r6
	sub	%r1,%r3
	ld.w	%r7,[%sp+0x1]	; 	xld.w	%r7,[%sp+0x4]
	ld.h	%r3,[%r7]	; 	xld.h	%r3,[%r7]
	jp	__LX198		; 	xjp	__L198
__LX197:				; __L197:
	ld.w	%r1,%r3
	ld.w	%r6,[%sp+0x9]	; 	xld.w	%r6,[%sp+0x24]
	sub	%r1,%r6
	ld.w	%r7,[%sp+0x1]	; 	xld.w	%r7,[%sp+0x4]
	ld.h	%r10,[%r7]	; 	xld.h	%r10,[%r7]
	not	%r3,%r10
	add	%r3,1
__LX198:				; __L198:
	cmp	%r2,%r1
	jrge	__LX199		; 	xjrge	__L199
	ld.w	%r10,%r2
	ld.w	%r2,%r1
	ld.w	%r1,%r10
	ld.w	%r10,%r5
	ld.w	%r5,%r3
	ld.w	%r3,%r10
__LX199:				; __L199:
	cmp	%r2,0x0
	jreq	__LX209		; 	xjreq	__L209
	ld.w	%r12,[%sp+0xa]	; 	xld.w	%r12,[%sp+0x28]
	ld.w	%r13,[%sp+0xc]	; 	xld.w	%r13,[%sp+0x30]
	ld.w	[%sp+0x3],%r5	; 	xld.w	[%sp+0xc],%r5
	ext	__umodsi3@rm	; 	xcall	__umodsi3
	call	__umodsi3@rl
	ld.w	[%sp+0xa],%r10	; 	xld.w	[%sp+0x28],%r10
	ld.w	%r11,%r2
	ld.w	%r4,%r11
	ld.w	%r6,[%sp+0x2]	; 	xld.w	%r6,[%sp+0x8]
	add	%r4,%r6
	ld.w	%r13,%r1
	sll	%r13,0x1	; 	xsll	%r13,1
	ld.w	%r1,%r11
	sll	%r1,0x1		; 	xsll	%r1,1
	ld.w	%r12,%r10
	ld.w	%r7,[%sp+0xb]	; 	xld.w	%r7,[%sp+0x2c]
	add	%r12,%r7
	ld.w	%r5,[%sp+0x3]	; 	xld.w	%r5,[%sp+0xc]
__LX201:				; __L201:
	ld.ub	%r15,[%r12]	; 	xld.ub	%r15,[%r12]
	add	%r12,0x1	; 	xadd	%r12,%r12,1
	ld.w	%r6,[%sp+0xa]	; 	xld.w	%r6,[%sp+0x28]
	add	%r6,0x1		; 	xadd	%r6,%r6,1
	ld.w	[%sp+0xa],%r6	; 	xld.w	[%sp+0x28],%r6
	ld.w	%r7,[%sp+0xc]	; 	xld.w	%r7,[%sp+0x30]
	cmp	%r6,%r7
	jrne	__LX204		; 	xjrne	__L204
	ld.w	%r12,[%sp+0xb]	; 	xld.w	%r12,[%sp+0x2c]
	ld.w	%r6,0x0
	ld.w	[%sp+0xa],%r6	; 	xld.w	[%sp+0x28],%r6
__LX204:				; __L204:
	ld.ub	%r10,%r15
	cmp	%r10,0xf	; 	xcmp	%r10,15
	jrugt	__LX205		; 	xjrugt	__L205
	ld.b	[%r0],%r15	; 	xld.b	[%r0],%r15
__LX205:				; __L205:
	add	%r0,%r5
	sub	%r11,%r13
	jrgt	__LX203		; 	xjrgt	__L203
	add	%r0,%r3
	add	%r11,%r1
__LX203:				; __L203:
	sub	%r4,0x1		; 	xsub	%r4,%r4,1
	jrne	__LX201		; 	xjrne	__L201
__LX209:				; __L209:
	ld.w	%r10,[%sp+0xa]	; 	xld.w	%r10,[%sp+0x28]
	add	%sp,0x4		; 	xadd	%sp,%sp,16
	popn	%r3
	ret
	.align	1
	.global	render_rectangle
render_rectangle:
;	.frame	%sp,32,$31		# vars= 4, regs= 5/0, args= 8, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x3		; 	xsub	%sp,%sp,12
	ld.w	[%sp+0x2],%r12	; 	xld.w	[%sp+0x8],%r12
	ld.w	%r3,%r13
	ld.w	%r2,%r14
	ld.w	%r10,[%sp+0x8]	; 	xld.w	%r10,[%sp+0x20]
	cmp	%r15,0x0
	jreq	__LX210		; 	xjreq	__L210
	cmp	%r10,0x0
	jreq	__LX210		; 	xjreq	__L210
	cmp	%r15,0x0
	jrge	__LX213		; 	xjrge	__L213
	add	%r3,%r15
	not	%r15,%r15
	add	%r15,1
__LX213:				; __L213:
	cmp	%r10,0x0
	jrge	__LX214		; 	xjrge	__L214
	add	%r2,%r10
	not	%r10,%r10
	add	%r10,1
__LX214:				; __L214:
	cmp	%r15,0x1	; 	xcmp	%r15,1
	jrne	__LX215		; 	xjrne	__L215
	cmp	%r10,0x1	; 	xcmp	%r10,1
	jrne	__LX215		; 	xjrne	__L215
	ld.w	%r12,[%sp+0x2]	; 	xld.w	%r12,[%sp+0x8]
	ld.w	%r13,%r3
	ld.w	%r14,%r2
	ld.w	%r15,[%sp+0x9]	; 	xld.w	%r15,[%sp+0x24]
	ext	render_point@rm	; 	xcall	render_point
	call	render_point@rl
	jp	__LX210		; 	xjp	__L210
__LX215:				; __L215:
	ld.w	%r0,%r3
	add	%r0,%r15
	sub	%r0,0x1		; 	xsub	%r0,%r0,1
	ld.w	%r1,%r2
	add	%r1,%r10
	sub	%r1,0x1		; 	xsub	%r1,%r1,1
	ld.w	[%sp+0x0],%r2	; 	xld.w	[%sp],%r2
	ld.w	%r11,[%sp+0x9]	; 	xld.w	%r11,[%sp+0x24]
	ld.w	[%sp+0x1],%r11	; 	xld.w	[%sp+0x4],%r11
	ld.w	%r12,[%sp+0x2]	; 	xld.w	%r12,[%sp+0x8]
	ld.w	%r13,%r3
	ld.w	%r14,%r2
	ld.w	%r15,%r0
	ext	render_line@rm	; 	xcall	render_line
	call	render_line@rl
	ld.w	[%sp+0x0],%r1	; 	xld.w	[%sp],%r1
	ld.w	%r11,[%sp+0x9]	; 	xld.w	%r11,[%sp+0x24]
	ld.w	[%sp+0x1],%r11	; 	xld.w	[%sp+0x4],%r11
	ld.w	%r12,[%sp+0x2]	; 	xld.w	%r12,[%sp+0x8]
	ld.w	%r13,%r0
	ld.w	%r14,%r2
	ld.w	%r15,%r0
	ext	render_line@rm	; 	xcall	render_line
	call	render_line@rl
	ld.w	[%sp+0x0],%r1	; 	xld.w	[%sp],%r1
	ld.w	%r11,[%sp+0x9]	; 	xld.w	%r11,[%sp+0x24]
	ld.w	[%sp+0x1],%r11	; 	xld.w	[%sp+0x4],%r11
	ld.w	%r12,[%sp+0x2]	; 	xld.w	%r12,[%sp+0x8]
	ld.w	%r13,%r0
	ld.w	%r14,%r1
	ld.w	%r15,%r3
	ext	render_line@rm	; 	xcall	render_line
	call	render_line@rl
	ld.w	[%sp+0x0],%r2	; 	xld.w	[%sp],%r2
	ld.w	%r11,[%sp+0x9]	; 	xld.w	%r11,[%sp+0x24]
	ld.w	[%sp+0x1],%r11	; 	xld.w	[%sp+0x4],%r11
	ld.w	%r12,[%sp+0x2]	; 	xld.w	%r12,[%sp+0x8]
	ld.w	%r13,%r3
	ld.w	%r14,%r1
	ld.w	%r15,%r13
	ext	render_line@rm	; 	xcall	render_line
	call	render_line@rl
__LX210:				; __L210:
	add	%sp,0x3		; 	xadd	%sp,%sp,12
	popn	%r3
	ret
; APP

	.code
	.align	1
	.global render_rectangle_clip
render_rectangle_clip:
	;// %r12    := render
	;// %r13    := px
	;// %r14    := py
	;// %r15    := pw
	;// [%sp+4] := ph
	add	%r12, 4				; %r12 := &render->left
	ld.h	%r4, [%r12]+			; %r4  := left
	ld.h	%r5, [%r12]+			; %r5  := top
	ld.h	%r6, [%r12]+			; %r6  := right
	ld.h	%r7, [%r12]			; %r7  := bottom
	ld.w	%r12,[%sp+0x1]	; 	xld.w	%r12, [%sp+0x4]			; %r12 := ph
	;// %r4  := left
	;// %r5  := top
	;// %r6  := right
	;// %r7  := bottom
	;// %r12 := ph
	;// %r13 := px
	;// %r14 := py
	;// %r15 := pw
	;---------------------------------------;
;//	ld.w	%r10, [%r13]			; %r10 := x = *px -+
	ld.w	%r11, [%r15]			; %r11 := w = *pw  |
	ld.w	%r10, [%r13]			; <----------------+	*anti-interlock*
	cmp	%r11, 0				; if(w < 0)
	jrge	4
	 add	%r10, %r11			;   x += w
	 not	%r11, %r11			;   w = -w
	 add	%r11, 1
	sub	%r4, %r10			; %r4 := n = left - x
	jrle	3				; if(n > 0)		// if(x < left)
	 add	%r10, %r4			;   %r10 := x += n	//   x += (left - x) = left
	 sub	%r11, %r4			;   %r11 := w -= n
	sub	%r6, %r10			; %r6 := right - x
	cmp	%r11, %r6			; if(w > right - x)	// if(x + w > right)
	jrle	2
	 ld.w	%r11, %r6			;   %r11 := w = right - x
	cmp	%r11, 0				; if(w <= 0)
	jrle	render_rectangle_clip_RET0	;   return 0
	;// %r5  := top
	;// %r7  := bottom
	;// %r10 := x
	;// %r11 := w
	;// %r12 := ph
	;// %r13 := px
	;// %r14 := py
	;// %r15 := pw
	;---------------------------------------;
;//	ld.w	%r4, [%r14]			; %r4 := y = *py -+
	ld.w	%r6, [%r12]			; %r6 := h = *ph  |
	ld.w	%r4, [%r14]			; <---------------+	*anti-interlock*
	cmp	%r6, 0				; if(h < 0)
	jrge	4
	 add	%r4, %r6			;   y += h
	 not	%r6, %r6			;   h = -h
	 add	%r6, 1
	sub	%r5, %r4			; %r5 := n = top - y
	jrle	3				; if(n > 0)		// if(y < top)
	 add	%r4, %r5			;   %r4 := y += n	//   y += (top - y) = top
	 sub	%r6, %r5			;   %r6 := h -= n
	sub	%r7, %r4			; %r7 := bottom - y
	cmp	%r6, %r7			; if(h > bottom - y)	// if(y + h > bottom)
	jrle	2
	 ld.w	%r6, %r7			;   %r6 := h = bottom - y
	cmp	%r6, 0				; if(h <= 0)
	jrle	render_rectangle_clip_RET0	;   return 0
	;// %r4  := y
	;// %r6  := h
	;// %r10 := x
	;// %r11 := w
	;// %r12 := ph
	;// %r13 := px
	;// %r14 := py
	;// %r15 := pw
	;---------------------------------------;
	ld.w	[%r13], %r10 			; *px := x
	ld.w	[%r14], %r4 			; *py := y
	ld.w	[%r15], %r11 			; *pw := w
	ld.w	[%r12], %r6 			; *ph := h
	ret.d					; return 1
	ld.w	%r10, 1				;			*delay
render_rectangle_clip_RET0:
	ret.d					; return 0
	ld.w	%r10, 0				;			*delay

; NO_APP
	.align	1
	.global	render_rectangle_fill
render_rectangle_fill:
;	.frame	%sp,32,$31		# vars= 12, regs= 4/0, args= 4, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	sub	%sp,0x4		; 	xsub	%sp,%sp,16
	ld.w	%r0,%r12
	ld.w	[%sp+0x1],%r13	; 	xld.w	[%sp+0x4],%r13
	ld.w	[%sp+0x2],%r14	; 	xld.w	[%sp+0x8],%r14
	ld.w	[%sp+0x3],%r15	; 	xld.w	[%sp+0xc],%r15
	ld.w	%r2,[%sp+0x9]	; 	xld.w	%r2,[%sp+0x24]
	ld.w	%r4,%sp		; 	xadd	%r4,%sp,32
	add	%r4,0x20
	ld.w	[%sp+0x0],%r4	; 	xld.w	[%sp],%r4
	ld.w	%r13,%sp	; 	xadd	%r13,%sp,4
	add	%r13,0x4
	ld.w	%r14,%sp	; 	xadd	%r14,%sp,8
	add	%r14,0x8
	ld.w	%r15,%sp	; 	xadd	%r15,%sp,12
	add	%r15,0xc
	call	render_rectangle_clip	; 	xcall	render_rectangle_clip
	cmp	%r10,0x0
	jreq	__LX216		; 	xjreq	__L216
	ld.w	%r1,[%r0]	; 	xld.w	%r1,[%r0]
	ld.h	%r11,[%r1]	; 	xld.h	%r11,[%r1]
	ld.w	%r10,[%sp+0x2]	; 	xld.w	%r10,[%sp+0x8]
	mlt.w	%r11,%r10
	ld.w	%r10,[%sp+0x1]	; 	xld.w	%r10,[%sp+0x4]
	ld.w	%r4,%alr
	add	%r4,%r10
	ld.w	%r10,%r4
	ext	0x4		; 	xld.w	%r11,[%r1+0x4]
	ld.w	%r11,[%r1]
	ld.w	%r0,%r11
	add	%r0,%r10
__LX218:				; __L218:
	ld.w	%r12,%r0
	ld.w	%r13,%r2
	ld.w	%r14,[%sp+0x3]	; 	xld.w	%r14,[%sp+0xc]
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.h	%r10,[%r1]	; 	xld.h	%r10,[%r1]
	add	%r0,%r10
	ld.w	%r10,[%sp+0x8]	; 	xld.w	%r10,[%sp+0x20]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ld.w	[%sp+0x8],%r10	; 	xld.w	[%sp+0x20],%r10
	jrne	__LX218		; 	xjrne	__L218
__LX216:				; __L216:
	add	%sp,0x4		; 	xadd	%sp,%sp,16
	popn	%r2
	ret
; APP

	.code
	.align	1
	.global render_rectangle_shadow
render_rectangle_shadow:
	;// %r12     := render
	;// %r13     := x
	;// %r14     := y
	;// %r15     := w
	;// [%sp+0]  := retp
	;// [%sp+4]  := h
	;// [%sp+8]  := adjust
	;// [%sp+12] := limit
	pushn	%r0
	sub	%sp,0x4		; 	xsub	%sp, %sp, 16
	;// %r4      := h
	;// %r12     := render
	;// %r13     := x
	;// %r14     := y
	;// %r15     := w
	;// [%sp+16] := %r0
	;// [%sp+20] := retp
	;// [%sp+24] := h
	;// [%sp+28] := adjust
	;// [%sp+32] := limit
	ld.w	%r0, [%r12]			; %r0      := surface
	ld.w	[%sp+0x1],%r13	; 	xld.w	[%sp+0x4], %r13			; [%sp+4]  := x
	ld.w	[%sp+0x2],%r14	; 	xld.w	[%sp+0x8], %r14			; [%sp+8]  := y
	ld.w	[%sp+0x3],%r15	; 	xld.w	[%sp+0xc], %r15			; [%sp+12] := w
	ld.w	%r13,%sp	; 	xadd	%r13, %sp, 4			; %r13     := &x
	add	%r13,0x4
	ld.w	%r14,%sp	; 	xadd	%r14, %sp, 8			; %r14     := &y
	add	%r14,0x8
;//	xadd	%r15, %sp, 12			; %r15     := &w -+
	ld.w	%r4,%sp		; 	xadd	%r4, %sp, 24			; %r4      := &h  |
	add	%r4,0x18
	ld.w	[%sp+0x0],%r4	; 	xld.w	[%sp+0x0], %r4			; [%sp+0]  := &h  |
	;// %r0      := surface			;                 |
	;// %r12     := render			;                 |
	;// %r13     := &x			;                 |
	;// %r14     := &y			;                 |
	;// %r15     := &w			;                 |
	;// [%sp+0]  := &h			;                 |
	;// [%sp+4]  := x			;                 |
	;// [%sp+8]  := y			;                 |
	;// [%sp+12] := w			;                 |
	;// [%sp+16] := %r0			;                 |
	;// [%sp+20] := retp			;                 |
	;// [%sp+24] := h			;                 |
	;// [%sp+28] := adjust			;                 |
	;// [%sp+32] := limit			;                 |
	ld.w	%r15, %sp			; <---------------+
	call.d	render_rectangle_clip	; 	xcall.d	render_rectangle_clip		;                 |
	add	%r15, 12			; <---------------+		*delay*
	cmp	%r10, 0
	jreq	render_rectangle_shadow_RET	; SɉʊO
	;// %r0      := surface
	;// [%sp+4]  := x
	;// [%sp+8]  := y
	;// [%sp+12] := w
	;// [%sp+16] := %r0
	;// [%sp+20] := retp
	;// [%sp+24] := h
	;// [%sp+28] := adjust
	;// [%sp+32] := limit
	ld.h	%r4,[%r0]	; 	xld.h	%r4, [%r0+0x0]			; %r4  := surface->w
	ext	0x4		; 	xld.w	%r5, [%r0+0x4]			; %r5  := surface->vbuff
	ld.w	%r5,[%r0]
	ld.w	%r6,[%sp+0x1]	; 	xld.w	%r6, [%sp+0x4]			; %r6  := x
	ld.w	%r7,[%sp+0x2]	; 	xld.w	%r7, [%sp+0x8]			; %r7  := y
	ld.w	%r10,[%sp+0x3]	; 	xld.w	%r10, [%sp+0xc]			; %r10 := w
	ld.w	%r11,[%sp+0x6]	; 	xld.w	%r11, [%sp+0x18]			; %r11 := h
	ld.w	%r12,[%sp+0x7]	; 	xld.w	%r12, [%sp+0x1c]			; %r12 := adjust
	ld.w	%r13,[%sp+0x8]	; 	xld.w	%r13, [%sp+0x20]			; %r13 := limit
	mlt.h	%r4, %r7			; %alr :=                     surface->w * y
	ld.w	%r9, %alr			; %r9  :=                     surface->w * y
	add	%r9, %r6			; %r9  :=                     surface->w * y + x
	add	%r5, %r9			; %r5  := p = &surface->vbuff[surface->w * y + x]
	sub	%r4, %r10			; %r4  := surface->w - w
	;// %r4      := surface->w - w
	;// %r5      := p
	;// %r10     := w
	;// %r11     := h
	;// %r12     := adjust
	;// %r13     := limit
	;// [%sp+16] := %r0
	;// [%sp+20] := retp
	;// [%sp+28] := adjust
	;// [%sp+32] := limit
	cmp	%r12, 0				; if adjust = 0 : goto RET
	jreq	render_rectangle_shadow_RET	; if adjust > 0 : goto INC
	jrlt	render_rectangle_shadow_DEC_DOY	; if adjust < 0 : goto DEC
	;---------------------------------------;
render_rectangle_shadow_INC_DOY:		; do {
	ld.w	%r14, %r10			;   %r14 := x = w
render_rectangle_shadow_INC_DOX:		;   do {
	ld.ub	%r15, [%r5]			;     %r15 := c = *p
	add	%r15, %r12			;     %r15 := c += adjust	!INTERLOCK!
	cmp	%r15, %r13			;     if(c > limit) {
	jrle.d	3
	 sub	%r14, 1				;     %r14 := x--		*delay*
	 ld.w	%r15, %r13			;       %r15 := c = limit
	ld.b	[%r5]+, %r15			;   } while(x)
	jrne	render_rectangle_shadow_INC_DOX
	sub	%r11, 1				; } while(--h)
	jrne.d	render_rectangle_shadow_INC_DOY
	add	%r5, %r4			; %r5  := p += surface->w - w	*delay*
	jp	render_rectangle_shadow_RET
	;---------------------------------------;
render_rectangle_shadow_DEC_DOY:		; do {
	ld.w	%r14, %r10			;   %r14 := x = w
render_rectangle_shadow_DEC_DOX:		;   do {
	ld.ub	%r15, [%r5]			;     %r15 := c = *p
	add	%r15, %r12			;     %r15 := c += adjust	!INTERLOCK!
	cmp	%r15, %r13			;     if(c < limit) {
	jrge.d	3
	 sub	%r14, 1				;     %r14 := x--		*delay*
	 ld.w	%r15, %r13			;       %r15 := c = limit
	ld.b	[%r5]+, %r15			;   } while(x)
	jrne	render_rectangle_shadow_DEC_DOX
	sub	%r11, 1				; } while(--h)
	jrne.d	render_rectangle_shadow_DEC_DOY
	add	%r5, %r4			; %r5  := p += surface->w - w	*delay*
	;---------------------------------------;
render_rectangle_shadow_RET:
	add	%sp,0x4		; 	xadd	%sp, %sp, 16
	popn	%r0
	ret

; NO_APP
	.align	1
render_ellipse_sub2:
;	.frame	%sp,48,$31		# vars= 20, regs= 5/0, args= 8, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x7		; 	xsub	%sp,%sp,28
	ld.w	%r2,%r12
	ld.w	%r10,[%sp+0xc]	; 	xld.w	%r10,[%sp+0x30]
	ld.w	%r11,[%sp+0xd]	; 	xld.w	%r11,[%sp+0x34]
	ld.w	%r12,[%sp+0xe]	; 	xld.w	%r12,[%sp+0x38]
	ld.w	%r5,[%sp+0xf]	; 	xld.w	%r5,[%sp+0x3c]
	ld.w	%r4,[%sp+0x10]	; 	xld.w	%r4,[%sp+0x40]
	ld.w	%r6,[%sp+0x12]	; 	xld.w	%r6,[%sp+0x48]
	ld.w	%r1,%r15
	sub	%r1,%r11
	ld.w	%r7,%r15
	add	%r7,%r13
	ld.w	%r13,%r7
	ld.w	%r0,%r13
	add	%r0,%r11
	sub	%r15,%r12
	ld.w	[%sp+0x2],%r15	; 	xld.w	[%sp+0x8],%r15
	add	%r13,%r12
	ld.w	[%sp+0x3],%r13	; 	xld.w	[%sp+0xc],%r13
	ld.w	%r3,%r10
	sub	%r3,%r4
	ld.w	%r7,%r10
	add	%r7,%r14
	ld.w	%r14,%r7
	add	%r7,%r4
	ld.w	[%sp+0x4],%r7	; 	xld.w	[%sp+0x10],%r7
	sub	%r10,%r5
	ld.w	[%sp+0x5],%r10	; 	xld.w	[%sp+0x14],%r10
	add	%r14,%r5
	ld.w	[%sp+0x6],%r14	; 	xld.w	[%sp+0x18],%r14
	cmp	%r6,0x0
	jrne	__LX223		; 	xjrne	__L223
	ld.w	%r12,%r2
	ld.w	%r13,%r1
	ld.w	%r14,%r3
	ld.w	%r15,[%sp+0x11]	; 	xld.w	%r15,[%sp+0x44]
	ext	render_point@rm	; 	xcall	render_point
	call	render_point@rl
	ld.w	%r12,%r2
	ld.w	%r13,%r0
	ld.w	%r14,%r3
	ld.w	%r15,[%sp+0x11]	; 	xld.w	%r15,[%sp+0x44]
	ext	render_point@rm	; 	xcall	render_point
	call	render_point@rl
	ld.w	%r12,%r2
	ld.w	%r13,%r1
	ld.w	%r14,[%sp+0x4]	; 	xld.w	%r14,[%sp+0x10]
	ld.w	%r15,[%sp+0x11]	; 	xld.w	%r15,[%sp+0x44]
	ext	render_point@rm	; 	xcall	render_point
	call	render_point@rl
	ld.w	%r12,%r2
	ld.w	%r13,%r0
	ld.w	%r14,[%sp+0x4]	; 	xld.w	%r14,[%sp+0x10]
	ld.w	%r15,[%sp+0x11]	; 	xld.w	%r15,[%sp+0x44]
	ext	render_point@rm	; 	xcall	render_point
	call	render_point@rl
	ld.w	%r12,%r2
	ld.w	%r13,[%sp+0x2]	; 	xld.w	%r13,[%sp+0x8]
	ld.w	%r14,[%sp+0x5]	; 	xld.w	%r14,[%sp+0x14]
	ld.w	%r15,[%sp+0x11]	; 	xld.w	%r15,[%sp+0x44]
	ext	render_point@rm	; 	xcall	render_point
	call	render_point@rl
	ld.w	%r12,%r2
	ld.w	%r13,[%sp+0x3]	; 	xld.w	%r13,[%sp+0xc]
	ld.w	%r14,[%sp+0x5]	; 	xld.w	%r14,[%sp+0x14]
	ld.w	%r15,[%sp+0x11]	; 	xld.w	%r15,[%sp+0x44]
	ext	render_point@rm	; 	xcall	render_point
	call	render_point@rl
	ld.w	%r12,%r2
	ld.w	%r13,[%sp+0x2]	; 	xld.w	%r13,[%sp+0x8]
	ld.w	%r14,[%sp+0x6]	; 	xld.w	%r14,[%sp+0x18]
	ld.w	%r15,[%sp+0x11]	; 	xld.w	%r15,[%sp+0x44]
	ext	render_point@rm	; 	xcall	render_point
	call	render_point@rl
	ld.w	%r12,%r2
	ld.w	%r13,[%sp+0x3]	; 	xld.w	%r13,[%sp+0xc]
	ld.w	%r14,[%sp+0x6]	; 	xld.w	%r14,[%sp+0x18]
	ld.w	%r15,[%sp+0x11]	; 	xld.w	%r15,[%sp+0x44]
	ext	render_point@rm	; 	xcall	render_point
	call	render_point@rl
	jp	__LX224		; 	xjp	__L224
__LX223:				; __L223:
	sub	%r0,%r1
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	ld.w	%r7,0x1		; 	xld.w	%r7,0x00000001		; 1
	ld.w	[%sp+0x0],%r7	; 	xld.w	[%sp],%r7
	ld.w	%r7,[%sp+0x11]	; 	xld.w	%r7,[%sp+0x44]
	ld.w	[%sp+0x1],%r7	; 	xld.w	[%sp+0x4],%r7
	ld.w	%r12,%r2
	ld.w	%r13,%r1
	ld.w	%r14,%r3
	ld.w	%r15,%r0
	ext	render_rectangle_fill@rm	; 	xcall	render_rectangle_fill
	call	render_rectangle_fill@rl
	ld.w	%r7,0x1		; 	xld.w	%r7,0x00000001		; 1
	ld.w	[%sp+0x0],%r7	; 	xld.w	[%sp],%r7
	ld.w	%r7,[%sp+0x11]	; 	xld.w	%r7,[%sp+0x44]
	ld.w	[%sp+0x1],%r7	; 	xld.w	[%sp+0x4],%r7
	ld.w	%r12,%r2
	ld.w	%r13,%r1
	ld.w	%r14,[%sp+0x4]	; 	xld.w	%r14,[%sp+0x10]
	ld.w	%r15,%r0
	ext	render_rectangle_fill@rm	; 	xcall	render_rectangle_fill
	call	render_rectangle_fill@rl
	ld.w	%r0,[%sp+0x3]	; 	xld.w	%r0,[%sp+0xc]
	ld.w	%r7,[%sp+0x2]	; 	xld.w	%r7,[%sp+0x8]
	sub	%r0,%r7
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	ld.w	%r7,0x1		; 	xld.w	%r7,0x00000001		; 1
	ld.w	[%sp+0x0],%r7	; 	xld.w	[%sp],%r7
	ld.w	%r7,[%sp+0x11]	; 	xld.w	%r7,[%sp+0x44]
	ld.w	[%sp+0x1],%r7	; 	xld.w	[%sp+0x4],%r7
	ld.w	%r12,%r2
	ld.w	%r13,[%sp+0x2]	; 	xld.w	%r13,[%sp+0x8]
	ld.w	%r14,[%sp+0x5]	; 	xld.w	%r14,[%sp+0x14]
	ld.w	%r15,%r0
	ext	render_rectangle_fill@rm	; 	xcall	render_rectangle_fill
	call	render_rectangle_fill@rl
	ld.w	%r7,0x1		; 	xld.w	%r7,0x00000001		; 1
	ld.w	[%sp+0x0],%r7	; 	xld.w	[%sp],%r7
	ld.w	%r7,[%sp+0x11]	; 	xld.w	%r7,[%sp+0x44]
	ld.w	[%sp+0x1],%r7	; 	xld.w	[%sp+0x4],%r7
	ld.w	%r12,%r2
	ld.w	%r13,[%sp+0x2]	; 	xld.w	%r13,[%sp+0x8]
	ld.w	%r14,[%sp+0x6]	; 	xld.w	%r14,[%sp+0x18]
	ld.w	%r15,%r0
	ext	render_rectangle_fill@rm	; 	xcall	render_rectangle_fill
	call	render_rectangle_fill@rl
__LX224:				; __L224:
	add	%sp,0x7		; 	xadd	%sp,%sp,28
	popn	%r3
	ret
	.align	1
render_ellipse_sub1:
;	.frame	%sp,88,$31		# vars= 40, regs= 5/0, args= 28, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x11	; 	xsub	%sp,%sp,68
	ld.w	[%sp+0x7],%r12	; 	xld.w	[%sp+0x1c],%r12
	ld.w	%r11,[%sp+0x16]	; 	xld.w	%r11,[%sp+0x58]
	cmp	%r15,0x0
	jrgt	__LX226		; 	xjrgt	__L226
	ext	__LX225@rm	; 	xjreq	__L225
	jreq	__LX225@rl
	not	%r15,%r15
	add	%r15,1
	sub	%r13,%r15
__LX226:				; __L226:
	ld.w	%r4,%r15
	xor	%r4,0x1		; 	xxor	%r4,%r4,0x00000001
	and	%r4,0x1		; 	xand	%r4,%r4,0x00000001
	ld.w	[%sp+0x8],%r4	; 	xld.w	[%sp+0x20],%r4
	ld.w	%r10,%r15
	srl	%r10,0x8	; 	xsrl	%r10,31
	srl	%r10,0x8
	srl	%r10,0x8
	srl	%r10,0x7
	add	%r15,%r10
	ld.w	%r10,%r15
	sra	%r10,0x1	; 	xsra	%r10,1
	ld.w	%r4,%r13
	add	%r4,%r10
	ld.w	%r10,%r4
	ld.w	%r4,[%sp+0x8]	; 	xld.w	%r4,[%sp+0x20]
	sub	%r10,%r4
	ld.w	[%sp+0xa],%r10	; 	xld.w	[%sp+0x28],%r10
	ld.w	%r4,%r10
	sub	%r4,%r13
	ld.w	%r13,%r4
	cmp	%r11,0x0
	jrgt	__LX229		; 	xjrgt	__L229
	ext	__LX225@rm	; 	xjreq	__L225
	jreq	__LX225@rl
	not	%r11,%r11
	add	%r11,1
	sub	%r14,%r11
__LX229:				; __L229:
	ld.w	%r4,%r11
	xor	%r4,0x1		; 	xxor	%r4,%r4,0x00000001
	and	%r4,0x1		; 	xand	%r4,%r4,0x00000001
	ld.w	[%sp+0x9],%r4	; 	xld.w	[%sp+0x24],%r4
	ld.w	%r10,%r11
	srl	%r10,0x8	; 	xsrl	%r10,31
	srl	%r10,0x8
	srl	%r10,0x8
	srl	%r10,0x7
	add	%r11,%r10
	ld.w	%r10,%r11
	sra	%r10,0x1	; 	xsra	%r10,1
	ld.w	%r4,%r14
	add	%r4,%r10
	ld.w	%r10,%r4
	ld.w	%r4,[%sp+0x9]	; 	xld.w	%r4,[%sp+0x24]
	sub	%r10,%r4
	ld.w	[%sp+0xb],%r10	; 	xld.w	[%sp+0x2c],%r10
	ld.w	%r4,%r10
	sub	%r4,%r14
	ld.w	%r14,%r4
	cmp	%r13,%r14
	jrlt	__LX232		; 	xjrlt	__L232
	ld.w	%r1,%r13
	ld.w	%r2,0x0
	ld.w	%r11,%r1
	sll	%r11,0x1	; 	xsll	%r11,1
	ld.w	%r10,0x3	; 	xld.w	%r10,0x00000003		; 3
	sub	%r10,%r11
	ld.w	[%sp+0xc],%r10	; 	xld.w	[%sp+0x30],%r10
	add	%r14,0x1	; 	xadd	%r14,%r14,1
	ld.w	[%sp+0xd],%r14	; 	xld.w	[%sp+0x34],%r14
	ext	0x1		; 	xadd	%r4,%r1,1
	add	%r4,%r1
	ld.w	[%sp+0xe],%r4	; 	xld.w	[%sp+0x38],%r4
__LX233:				; __L233:
	ld.w	%r4,[%sp+0xd]	; 	xld.w	%r4,[%sp+0x34]
	mlt.w	%r1,%r4
	ld.w	%r12,%alr
	ld.w	%r13,[%sp+0xe]	; 	xld.w	%r13,[%sp+0x38]
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r3,%r10
	ld.w	%r4,[%sp+0xd]	; 	xld.w	%r4,[%sp+0x34]
	mlt.w	%r2,%r4
	ld.w	%r12,%alr
	ld.w	%r13,[%sp+0xe]	; 	xld.w	%r13,[%sp+0x38]
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r0,%r10
	ld.w	%r4,[%sp+0xb]	; 	xld.w	%r4,[%sp+0x2c]
	ld.w	[%sp+0x0],%r4	; 	xld.w	[%sp],%r4
	ld.w	[%sp+0x1],%r1	; 	xld.w	[%sp+0x4],%r1
	ld.w	[%sp+0x2],%r2	; 	xld.w	[%sp+0x8],%r2
	ld.w	[%sp+0x3],%r3	; 	xld.w	[%sp+0xc],%r3
	ld.w	[%sp+0x4],%r0	; 	xld.w	[%sp+0x10],%r0
	ld.w	%r4,[%sp+0x17]	; 	xld.w	%r4,[%sp+0x5c]
	ld.w	[%sp+0x5],%r4	; 	xld.w	[%sp+0x14],%r4
	ld.w	%r4,[%sp+0x18]	; 	xld.w	%r4,[%sp+0x60]
	ld.w	[%sp+0x6],%r4	; 	xld.w	[%sp+0x18],%r4
	ld.w	%r12,[%sp+0x7]	; 	xld.w	%r12,[%sp+0x1c]
	ld.w	%r13,[%sp+0x8]	; 	xld.w	%r13,[%sp+0x20]
	ld.w	%r14,[%sp+0x9]	; 	xld.w	%r14,[%sp+0x24]
	ld.w	%r15,[%sp+0xa]	; 	xld.w	%r15,[%sp+0x28]
	ext	render_ellipse_sub2@rm	; 	xcall	render_ellipse_sub2
	call	render_ellipse_sub2@rl
	ld.w	%r4,[%sp+0xc]	; 	xld.w	%r4,[%sp+0x30]
	cmp	%r4,0x0
	jrlt	__LX236		; 	xjrlt	__L236
	ld.w	%r10,%r1
	sll	%r10,0x2	; 	xsll	%r10,2
	sub	%r4,%r10
	ld.w	[%sp+0xc],%r4	; 	xld.w	[%sp+0x30],%r4
	sub	%r1,0x1		; 	xsub	%r1,%r1,1
__LX236:				; __L236:
	ld.w	%r11,[%sp+0xc]	; 	xld.w	%r11,[%sp+0x30]
	add	%r11,0x2	; 	xadd	%r11,%r11,2
	ld.w	%r10,%r2
	sll	%r10,0x2	; 	xsll	%r10,2
	add	%r11,%r10
	ld.w	[%sp+0xc],%r11	; 	xld.w	[%sp+0x30],%r11
	add	%r2,0x1		; 	xadd	%r2,%r2,1
	cmp	%r1,%r2
	jrge	__LX233		; 	xjrge	__L233
	jp	__LX225		; 	xjp	__L225
__LX232:				; __L232:
	ld.w	%r3,0x0
	ld.w	%r0,%r14
	ld.w	%r11,%r0
	sll	%r11,0x1	; 	xsll	%r11,1
	ld.w	%r10,0x3	; 	xld.w	%r10,0x00000003		; 3
	sub	%r10,%r11
	ld.w	[%sp+0xc],%r10	; 	xld.w	[%sp+0x30],%r10
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	ld.w	[%sp+0xf],%r13	; 	xld.w	[%sp+0x3c],%r13
	ext	0x1		; 	xadd	%r4,%r0,1
	add	%r4,%r0
	ld.w	[%sp+0x10],%r4	; 	xld.w	[%sp+0x40],%r4
__LX239:				; __L239:
	ld.w	%r4,[%sp+0xf]	; 	xld.w	%r4,[%sp+0x3c]
	mlt.w	%r3,%r4
	ld.w	%r12,%alr
	ld.w	%r13,[%sp+0x10]	; 	xld.w	%r13,[%sp+0x40]
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r1,%r10
	ld.w	%r4,[%sp+0xf]	; 	xld.w	%r4,[%sp+0x3c]
	mlt.w	%r0,%r4
	ld.w	%r12,%alr
	ld.w	%r13,[%sp+0x10]	; 	xld.w	%r13,[%sp+0x40]
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r2,%r10
	ld.w	%r4,[%sp+0xb]	; 	xld.w	%r4,[%sp+0x2c]
	ld.w	[%sp+0x0],%r4	; 	xld.w	[%sp],%r4
	ld.w	[%sp+0x1],%r1	; 	xld.w	[%sp+0x4],%r1
	ld.w	[%sp+0x2],%r2	; 	xld.w	[%sp+0x8],%r2
	ld.w	[%sp+0x3],%r3	; 	xld.w	[%sp+0xc],%r3
	ld.w	[%sp+0x4],%r0	; 	xld.w	[%sp+0x10],%r0
	ld.w	%r4,[%sp+0x17]	; 	xld.w	%r4,[%sp+0x5c]
	ld.w	[%sp+0x5],%r4	; 	xld.w	[%sp+0x14],%r4
	ld.w	%r4,[%sp+0x18]	; 	xld.w	%r4,[%sp+0x60]
	ld.w	[%sp+0x6],%r4	; 	xld.w	[%sp+0x18],%r4
	ld.w	%r12,[%sp+0x7]	; 	xld.w	%r12,[%sp+0x1c]
	ld.w	%r13,[%sp+0x8]	; 	xld.w	%r13,[%sp+0x20]
	ld.w	%r14,[%sp+0x9]	; 	xld.w	%r14,[%sp+0x24]
	ld.w	%r15,[%sp+0xa]	; 	xld.w	%r15,[%sp+0x28]
	ext	render_ellipse_sub2@rm	; 	xcall	render_ellipse_sub2
	call	render_ellipse_sub2@rl
	ld.w	%r4,[%sp+0xc]	; 	xld.w	%r4,[%sp+0x30]
	cmp	%r4,0x0
	jrlt	__LX242		; 	xjrlt	__L242
	ld.w	%r10,%r0
	sll	%r10,0x2	; 	xsll	%r10,2
	sub	%r4,%r10
	ld.w	[%sp+0xc],%r4	; 	xld.w	[%sp+0x30],%r4
	sub	%r0,0x1		; 	xsub	%r0,%r0,1
__LX242:				; __L242:
	ld.w	%r11,[%sp+0xc]	; 	xld.w	%r11,[%sp+0x30]
	add	%r11,0x2	; 	xadd	%r11,%r11,2
	ld.w	%r10,%r3
	sll	%r10,0x2	; 	xsll	%r10,2
	add	%r11,%r10
	ld.w	[%sp+0xc],%r11	; 	xld.w	[%sp+0x30],%r11
	add	%r3,0x1		; 	xadd	%r3,%r3,1
	cmp	%r0,%r3
	jrge	__LX239		; 	xjrge	__L239
__LX225:				; __L225:
	add	%sp,0x11	; 	xadd	%sp,%sp,68
	popn	%r3
	ret
	.align	1
	.global	render_ellipse
render_ellipse:
;	.frame	%sp,16,$31		# vars= 0, regs= 1/0, args= 12, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x3		; 	xsub	%sp,%sp,12
	ld.w	%r10,[%sp+0x4]	; 	xld.w	%r10,[%sp+0x10]
	ld.w	%r11,[%sp+0x5]	; 	xld.w	%r11,[%sp+0x14]
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	[%sp+0x1],%r11	; 	xld.w	[%sp+0x4],%r11
	ld.w	%r4,0x0
	ld.w	[%sp+0x2],%r4	; 	xld.w	[%sp+0x8],%r4
	ext	render_ellipse_sub1@rm	; 	xcall	render_ellipse_sub1
	call	render_ellipse_sub1@rl
	add	%sp,0x3		; 	xadd	%sp,%sp,12
	ret
	.align	1
	.global	render_ellipse_fill
render_ellipse_fill:
;	.frame	%sp,16,$31		# vars= 0, regs= 1/0, args= 12, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x3		; 	xsub	%sp,%sp,12
	ld.w	%r10,[%sp+0x4]	; 	xld.w	%r10,[%sp+0x10]
	ld.w	%r11,[%sp+0x5]	; 	xld.w	%r11,[%sp+0x14]
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	[%sp+0x1],%r11	; 	xld.w	[%sp+0x4],%r11
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ld.w	[%sp+0x2],%r10	; 	xld.w	[%sp+0x8],%r10
	ext	render_ellipse_sub1@rm	; 	xcall	render_ellipse_sub1
	call	render_ellipse_sub1@rl
	add	%sp,0x3		; 	xadd	%sp,%sp,12
	ret

