/*	
 *	clipmath.c
 *
 *	[eBeBFw֐
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Thu Dec 31 09:54:58 JST 2015 Naoyuki Sawa
 *	- 쐬JnB
 *	- math.hɂ͊܂܂ȂẂAw֐܂Ƃ߂邽߂̃W[łB
 *	  AW̐w֐ǉꍇ́AW[ɒǉĉB
 *	* Sat Mar 19 21:19:21 JST 2016 Naoyuki Sawa
 *	- determinant(),cofactor(),solve()ǉ܂B
 *	* Wed May 24 21:26:30 JST 2017 Naoyuki Sawa
 *	- easeIn(),easeOut(),easeInOut()ǉ܂B
 *	* Fri Jul 28 21:55:48 JST 2017 Naoyuki Sawa
 *	- lerp_i()ǉ܂B
 *	* Sat Jul 29 22:27:07 JST 2017 Naoyuki Sawa
 *	- easeIn_i(),easeOut_i(),easeInOut_i()ǉ܂B
 *	* Tue Aug 08 21:44:58 JST 2017 Naoyuki Sawa
 *	- easeOutIn(),easeOutIn_i()ǉ܂B
 *	* Tue Aug 08 22:18:34 JST 2017 Naoyuki Sawa
 *	- easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
 *	  easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
 *	  R[hTCY팸̌ʂ́AO84oCg,12oCgŁAv96oCgȂ܂B
 */
#include "clip.h"
//*****************************************************************************
//	`
//*****************************************************************************
//Performs a Linear intERPolation.
//[in]
//	x		The first-floating point value.							xy̑召͕słB(x<y)ł(x=y)ł(x>y)ł\܂B
//	y		The second-floating point value.						
//	s		A value that Linearly intERPolates between the x parameter and the y parameter.	Iɂ(0<=s<=1)łA(s<0)(s>1)ł삵܂B
//[out]
//	return value	The result of the Linear intERPolation.
//[note]
//	- PȐ`Ԋ֐łB
//	  WC֐ł͂܂񂪁ÃQ[pCuɔĂ̂ŁAĂɂ܂B
//	- ʓIɂ'x+(s*(y-x))'ŌvZ܂A'x-(s*(x-y))'ŌvZ܂B
//	  'x+(s*(y-x))''x-(s*(x-y))'̕AAsmɃWX^̈ړ񐔂ČǂłB
#ifndef PIECE
double lerp(double x, double y, double s) {
    //{{ό`čœK܂B
    //	return (x * (1.0 - s)) + (y * s);	//Z~2,Z~2
    //ό`čœK܂B
	return x - (s * (x - y));		//Z~1,Z~2
    //}}ό`čœK܂B
}
#else //PIECE
double lerp(double x, double y, double s);
asm("
		.code
		.align		1
		.global		lerp
lerp:
		pushn		%r1
		;//%r12     := xl
		;//%r13     := xh
		;//%r14     := yl
		;//%r15     := yh
		;//[%sp+ 0] := %r0
		;//[%sp+ 4] := %r1
		;//[%sp+ 8] := retp
		;//[%sp+12] := sl
		;//[%sp+16] := sh
		ld.w		%r0, %r12		;//%r0       := xl
		xcall.d		__subdf3		;//%r11:%r10 :=          (x - y)
		ld.w		%r1, %r13		;//%r1       := xh			*delay*
		xld.w		%r12, [%sp+12]		;//%r12      :=      sl
		xld.w		%r13, [%sp+16]		;//%r13      :=      sh
		ld.w		%r14, %r10		;//%r14      :=          (x - y)l
		xcall.d		__muldf3		;//%r11:%r10 :=     (s * (x - y))
		ld.w		%r15, %r11		;//%r15      :=          (x - y)h	*delay*
		ld.w		%r12, %r0		;//%r12      := xl
		ld.w		%r13, %r1		;//%r13      := xh
		popn		%r1
		ld.w		%r14, %r10		;//%r14      :=     (s * (x - y))l
		xjp.d		__subdf3		;//%r11:%r10 := x - (s * (x - y))
		ld.w		%r15, %r11		;//%r15      :=     (s * (x - y))h	*delay*
");
#endif//PIECE
//*****************************************************************************
//	C[WO
//*****************************************************************************
//Performs a EASE-IN interpolation.
//[in]
//	x		The first-floating point value.								xy̑召͕słB(x<y)ł(x=y)ł(x>y)ł\܂B
//	y		The second-floating point value.							
//	s		A value that EASE-IN interpolates between the x parameter and the y parameter.		(s<0)(s>1)w肵ĂG[ɂ͂Ȃ܂񂪁A炭Ӑ}ƈႤʂɂȂ܂B
//[out]
//	return value	The result of the EASE-IN interpolation.
//[note]
//	- 蓮oĉ铮łB
double easeIn(double x, double y, double s) {
	return lerp(x, y, (s * s)/**/);
}
//-----------------------------------------------------------------------------
//Performs a EASE-OUT interpolation.
//[in]
//	x		The first-floating point value.								xy̑召͕słB(x<y)ł(x=y)ł(x>y)ł\܂B
//	y		The second-floating point value.							
//	s		A value that EASE-OUT interpolates between the x parameter and the y parameter.		(s<0)(s>1)w肵ĂG[ɂ͂Ȃ܂񂪁A炭Ӑ}ƈႤʂɂȂ܂B
//[out]
//	return value	The result of the EASE-OUT interpolation.
//[note]
//	- œoČ铮łB
double easeOut(double x, double y, double s) {
	return easeIn(y, x, 1.0 - s);
}
//-----------------------------------------------------------------------------
//Performs a EASE-IN-OUT interpolation.
//[in]
//	x		The first-floating point value.								xy̑召͕słB(x<y)ł(x=y)ł(x>y)ł\܂B
//	y		The second-floating point value.							
//	s		A value that EASE-IN-OUT interpolates between the x parameter and the y parameter.	(s<0)(s>1)w肵ĂG[ɂ͂Ȃ܂񂪁A炭Ӑ}ƈႤʂɂȂ܂B
//[out]
//	return value	The result of the EASE-IN-OUT interpolation.
//[note]
//	- 蓮oĉA܂铮łB
//{{2017/08/08폜:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
//double easeInOut(double x, double y, double s) {
//	double mid = (x + y) / 2.0;
//	if(s >= 0.5) {
//		x = y;
//		s = 1.0 - s;
//	}
//	return easeIn(x, mid, s * 2.0);										//easeInOut()easeOutIn()̈Ⴂ́A̍słB
//}
//}}2017/08/08폜:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
//-----------------------------------------------------------------------------
//Performs a EASE-OUT-IN interpolation.
//[in]
//	x		The first-floating point value.								xy̑召͕słB(x<y)ł(x=y)ł(x>y)ł\܂B
//	y		The second-floating point value.							
//	s		A value that EASE-OUT-IN interpolates between the x parameter and the y parameter.	(s<0)(s>1)w肵ĂG[ɂ͂Ȃ܂񂪁A炭Ӑ}ƈႤʂɂȂ܂B
//[out]
//	return value	The result of the EASE-OUT-IN interpolation.
//[note]
//	- œoČA܂铮łB
//{{2017/08/08폜:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
//double easeOutIn(double x, double y, double s) {
//	double mid = (x + y) / 2.0;
//	if(s >= 0.5) {
//		x = y;
//		s = 1.0 - s;
//	}
//	return easeOut(x, mid, s * 2.0);									//easeInOut()easeOutIn()̈Ⴂ́A̍słB
//}
//}}2017/08/08폜:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
//-----------------------------------------------------------------------------
//{{2017/08/08ǉ:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
static double easeInOut_easeOutIn(double x, double y, double s, double (*fn)(double x, double y, double s));	//OQ
double easeInOut(double x, double y, double s) { return easeInOut_easeOutIn(x, y, s, easeIn); }
double easeOutIn(double x, double y, double s) { return easeInOut_easeOutIn(x, y, s, easeOut); }
static double easeInOut_easeOutIn(double x, double y, double s, double (*fn)(double x, double y, double s)) {
	double mid = (x + y) / 2.0;
	if(s >= 0.5) {
		x = y;
		s = 1.0 - s;
	}
	return (*fn)(x, mid, s * 2.0);
}
//}}2017/08/08ǉ:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
//*****************************************************************************
//	`()
//*****************************************************************************
//x`yAn/dŕԂ܂B
//[in]
//	x		JnlB		INT_MIN`INT_MAX
//	y		IlB		INT_MIN`INT_MAX
//	n		ԌW̕qB	INT_MIN`INT_MAX
//	d		ԌW̕B	1`INT_MAX,-1`INT_MIN	0̂ݕs
//[out]
//	߂l		x+(y-x)*(n/d)		ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ́A߂l͕sƂȂB<>{x=0,y=1<<30,n=5,d=1}w肵ꍇȂǁB
//[note]
//	- ֐́A̕⊮p{ɂȂƎv̂ŁAėpdāA̒l͈݂̔͂̐Ȃ悤ɍ쐬܂B
//	  Iɂ͉Zr64rbgZsĂ̂ŁA(ʈȊO)Zrł̌ӂSzKv͗L܂B
//	  ł'lerp()'ƁAقړoŎgƎv܂B
//	  ڍׂ́Aȉ̒ʂłB
//	- xy̑召͕słB
//	  (x<y)ł(x=y)ł(x>y)ł\܂B
//	- xy͂ꂼAINT_MIN`INT_MAX̔Cӂ̒lłB
//	  (|x-y|>INT_MAX)ł\܂B				ʓIɂ(|x-y|INT_MAX)Ƃ͎v܂Aėp̂߂(|x-y|>INT_MAX)Ή܂B̑Ή̂߂ɁA⏈ȂĂ܂B
//	- n͈ʓIɂ́A0ȏdȉ(d<0̏ꍇ0ȉdȏ)̒lłB
//	  K{ł͂ȂAL͈̔͊O̒lł\܂B
//	- d͈ʓIɂ́A1`INT_MAX̒lłB
//	  K{ł͂ȂA-1`INT_MIN̒lł\܂B		ʓIɂ(1dINT_MAX)Ƃ͎v܂Aėp̂߂(-1dINT_MIN)Ή܂B̑Ή̂߂ɁA⏈ȂĂ܂B
#ifndef PIECE
int lerp_i(int x, int y, int n, int d) {
	if(d < 0) {
		n = -n;
		d = -d;
	}
	if(y < x) {
		y -= x;
		y = -y;
	    //{{ʏ
		if(n < 0) {
			n = -n;
			y = (uint64_t)(unsigned)y * (uint64_t)(unsigned)n / (uint64_t)(unsigned)d;
			y = -y;	//    ~~~~~~~~~~              ~~~~~~~~~~              ~~~~~~~~~~	X̕ϐy,n,d͕t̒lłAɕ̒lɕ␳ς݂Ȃ̂ŁAbit31bit63`32֕gȂ悤ɁA܂(unsigned)ւ̃LXgKvłB
		} else {
			y = (uint64_t)(unsigned)y * (uint64_t)(unsigned)n / (uint64_t)(unsigned)d;
		}		//    ~~~~~~~~~~              ~~~~~~~~~~              ~~~~~~~~~~	X̕ϐy,n,d͕t̒lłAɕ̒lɕ␳ς݂Ȃ̂ŁAbit31bit63`32֕gȂ悤ɁA܂(unsigned)ւ̃LXgKvłB
	    //}}ʏ
		y = -y;
	} else {
		y -= x;
	    //{{ʏ
		if(n < 0) {
			n = -n;
			y = (uint64_t)(unsigned)y * (uint64_t)(unsigned)n / (uint64_t)(unsigned)d;
			y = -y;	//    ~~~~~~~~~~              ~~~~~~~~~~              ~~~~~~~~~~	X̕ϐy,n,d͕t̒lłAɕ̒lɕ␳ς݂Ȃ̂ŁAbit31bit63`32֕gȂ悤ɁA܂(unsigned)ւ̃LXgKvłB
		} else {
			y = (uint64_t)(unsigned)y * (uint64_t)(unsigned)n / (uint64_t)(unsigned)d;
		}		//    ~~~~~~~~~~              ~~~~~~~~~~              ~~~~~~~~~~	X̕ϐy,n,d͕t̒lłAɕ̒lɕ␳ς݂Ȃ̂ŁAbit31bit63`32֕gȂ悤ɁA܂(unsigned)ւ̃LXgKvłB
	    //}}ʏ
	}
	return x + y;
}
#else //PIECE
//AZułlerp_i()ۑ郌WX^ɂ:
//AZułlerp_i()́A%r9,%r10,%r11,%r13,%r14,%r15,%alr,%ahr,%psr j󂵂܂B
//ĂяoKɂĕۑ`tĂ %r0`%r3,y,%r8 ɉāA%r4`%r7,y,%r12 ۑ܂B	!!
//Ăяo̊֐́AL̃WX^ۑ鎖OƂāAL̃WX^̑ޔȗĂ\܂B	
//AZuł̐\ɂ(2017/07/28)
//CłAZuł̕A64oCgA10{łB	!!
//Cłframdi.oRAMɒuꍇƔׂĂA3{łB	
//CłƃAZuł̑x傫ႤŔACłł́AKv܂Ńt64rbg揜ZsĂ܂Ă܂A
//AZułł́AKvŒ32rbg~32rbg64rbgZCyсC64rbg32rbg32rbgZɍœK̂ŁA
//CłƈāA\tgEFAɂ64rbg揜Z[`(framdi.o)͌ĂяoA@Bꖽ߂ōς܂ꂽłB
//xv̌ʂ̏ڍׂ́Aȉ̒ʂłB
//yxvɎgpeXgvOz
//#define N 10000
//int data[N][4];
//int app_main(int argc, char* argv[]) {
//  int i, j, t;
//  srand48(0);
//  for(i = 0; i < N; i++) {
//    double d;
//         data[i][0] = mrand48();
//         data[i][1] = mrand48();
//         data[i][2] = mrand48();
//    do { data[i][3] = mrand48(); } while(!data[i][3]);
//    d = lerp(data[i][0], data[i][1], (double)data[i][2] / (double)data[i][3]);
//    if((d < INT_MIN) || (d > INT_MAX)) { i--; }
//  }
//  t = pceTimerGetCount();
//  for(j = 0; j < 10; j++) {
//    for(i = 0; i < N; i++) {
//      lerp_i(data[i][0], data[i][1], data[i][2], data[i][3]);
//    }
//  }
//  t = pceTimerGetCount() - t;
//  die("%d", t);
//  return 0;
//}
//yxv̌ʁzTURBO[hAX^bN͍RAMɔzuĎs܂B
//EC(framdi.oSRAMɔzu)     7555~b
//EC(framdi.oRAMɔzu)  2272~b
//EAZu(framdi.o͊֌W)   767~b
int lerp_i(int x, int y, int n, int d);
asm("
		.code
		.align		1
		.global		lerp_i
lerp_i:
		;//%r12 := x
		;//%r13 := y
		;//%r14 := n
		;//%r15 := d
		cmp		%r15, 0			;//if(d < 0) {
		jrge.d		lerp_i_L10		;//  
		ld.w		%r9, 8-1		;//%r9       := i = 8-1		*delay*	
		not		%r14, %r14		;//  %r14    := n = -n			@
		add		%r14, 1			;//  					@
		not		%r15, %r15		;//  %r15    := d = -d			@
		add		%r15, 1			;//  					@
lerp_i_L10:						;//}					@
		sub		%r13, %r12		;//%r13      := y -= x			@
		jrge.d		lerp_i_L20		;//if(ύXOy < x) {			@
		ld.w		%r11, %psr		;//%psrۑ@			*delay*	@
		not		%r13, %r13		;//  %r13    := y = -y			@
		add		%r13, 1			;//  					@
lerp_i_L20:						;//}					@
		cmp		%r14, -1		;//if(ύXOn <= -1) {		@		(n>-1)Ȃ%psr(Z)=0ŕ򂷂B(n<=-1)Ȃ%psr(Z)=1̉\L邪Ả̏%psr(Z)=0ɂȂB
		jrgt.d		lerp_i_L30		;//  					@
		ld.w		%r10, %psr		;//%psrۑA			*delay*	@
		sub		%r14, 1			;//  %r14    := n = -n			@		̏ŕK%psr(Z)=0ɂȂB-10ɂȂ̂(n=1)ꍇ݂̂A(n=1)Ȃ΂ւ͗ȂB
		not		%r14, %r14		;//					@
lerp_i_L30:						;//}					@		򂵂ꍇ򂵂ȂꍇAŕK%psr(Z)=0ɂȂĂB̌̃[v̏%psr(Z)܂ŕωȂ悤ӂB
		mltu.w		%r13, %r14		;//%ahr:%alr := (y * n)			@	@
		ld.w		%r14, %ahr		;//%r14      := (y * n)[63:32]		@	@
		div0u		%r15			;//%ahr      :=    0			@	@	%psr(DS,N)=0
		ld.w		%ahr, %r14		;//%ahr:%alr := (y * n)			@	@
	;//	ld.w		%r9, 8-1		;//%r9       := i = 8-1				@
lerp_i_L40:						;//do {						@
		div1		%r15			;//  1						@	
		div1		%r15			;//  2						@	div1s鎞'%psr(DS,N)=0'ێĂKv鎖ɒӂB
		div1		%r15			;//  3						@	
		div1		%r15			;//  4						@	
		jrne.d		lerp_i_L40		;//} while(i != 0)					%psr(Z)=0ł͂Ȃ̂ŕK[vBڈȍ~͂̉ŕω%psr(Z)QƂă[vB
		sub		%r9, 1			;//  %r9     := i--		*delay*		
		ld.w		%psr, %r10		;//%psrA
		jrgt.d		lerp_i_L50		;//if(ύXOn <= -1) {
		ld.w		%r10, %alr		;//%r10      := y = (y * n) / d	*delay*
		not		%r10, %r10		;//  %r10    := y = -y
		add		%r10, 1			;//  
lerp_i_L50:						;//}
		ld.w		%psr, %r11		;//%psr@
		jrge		lerp_i_L60		;//if(ύXOn < 0) {
		not		%r10, %r10		;//  %r10    := y = -y
		add		%r10, 1			;//  
lerp_i_L60:						;//}
		ret.d					;//return       x + y
		add		%r10, %r12		;//%r10      := x + y		*delay*
");
#endif//PIECE
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#if 0
//lerp_i()̃eXgXC[g
int app_main(int argc, char* argv[]) {
	int x, y, n, d, a;
	double b;
	for(;;) {
		     x = mrand48();
		     y = mrand48();
		     n = mrand48();
		do { d = mrand48(); } while(!d);
		a = lerp_i(x, y,         n,          d);
		b = lerp(  x, y, (double)n / (double)d);
	#ifndef PIECE
		       printf(                     "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
	#else //PIECE
		surface_clear(&surface, 0);
		render_printf(&render, 0, 0, 2, 3, "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
		update();
		if(pcePadGetDirect() & PAD_SELECT) { break; }
	#endif//PIECE
		if((b >= INT_MIN) && (b <= INT_MAX)) {	//ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ΁c
			if(abs(a - lround(b)) > 1) {	//̐؂̂Č덷͈̔͂Őʂ͂B
				die("x = % 11d\n"
				    "y = % 11d\n"
				    "n = % 11d\n"
				    "d = % 11d\n"
				    "a = % 11d\n"
				    "b = % 11d\n", x, y, n, d, a, lround(b));
			}
		}
	}
	return 0;
}
#endif
//*****************************************************************************
//	C[WO()
//*****************************************************************************
//蓮oĉ铮łB
//[in]
//	x		JnlB		INT_MIN`INT_MAX
//	y		IlB		INT_MIN`INT_MAX
//	n		ԌW̕qB	0`d
//	d		ԌW̕B	1`SHRT_MAX
//[out]
//	߂l		ԌʁB
//[note]
//	- lerp_i()͊{Ȃ̂ŔėpdĈ̒l͈݂̔͂̐Ȃ悤ɂ܂A֐(easeIn_i())͖[Ǝv̂Ŕėp͏d܂łB
//	  ̂߁Alerp_i()d(ЂĂ͈n)̒l͈̔͂̐łB
//	  ʓIȎgł͏[Ǝv܂A̒l5(=?)ȏɂȂP[Xł́AӂĉB
#ifndef PIECE
int easeIn_i(int x, int y, int n, int d) {
	n *= n;	//
	d *= d;	//
	return lerp_i(x, y, n, d);
}
#else //PIECE
int easeIn_i(int x, int y, int n, int d);
asm("
		.code
		.align		1
		.global		easeIn_i
easeIn_i:
		mlt.h		%r14, %r14		;//%r14 := n *= n
		ld.w		%r14, %alr		;//
		mlt.h		%r15, %r15		;//%r15 := d *= d
		xjp.d		lerp_i			;//return lerp_i(x, y, n, d)
		ld.w		%r15, %alr		;//				*delay*
");
#endif//PIECE
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#if 0
//easeIn_i()̃eXgXC[g
int app_main(int argc, char* argv[]) {
	int x, y, n, d, a;
	double b;
	for(;;) {
		     x = mrand48();
		     y = mrand48();
		do { d = lrand48() % (SHRT_MAX + 1); } while(!d);
		     n = lrand48() % d;
		a = easeIn_i(x, y,         n,          d);
		b = easeIn(  x, y, (double)n / (double)d);
	#ifndef PIECE
		       printf(                     "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
	#else //PIECE
		surface_clear(&surface, 0);
		render_printf(&render, 0, 0, 2, 3, "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
		update();
		if(pcePadGetDirect() & PAD_SELECT) { break; }
	#endif//PIECE
		if((b >= INT_MIN) && (b <= INT_MAX)) {	//ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ΁c
			if(abs(a - lround(b)) > 1) {	//̐؂̂Č덷͈̔͂Őʂ͂B
				die("x = % 11d\n"
				    "y = % 11d\n"
				    "n = % 11d\n"
				    "d = % 11d\n"
				    "a = % 11d\n"
				    "b = % 11d\n", x, y, n, d, a, lround(b));
			}
		}
	}
	return 0;
}
#endif
//-----------------------------------------------------------------------------
//œoČ铮łB
//[in]
//	x		JnlB		INT_MIN`INT_MAX
//	y		IlB		INT_MIN`INT_MAX
//	n		ԌW̕qB	0`d
//	d		ԌW̕B	1`SHRT_MAX
//[out]
//	߂l		ԌʁB
//[note]
//	- lerp_i()͊{Ȃ̂ŔėpdĈ̒l͈݂̔͂̐Ȃ悤ɂ܂A֐(easeOut_i())͖[Ǝv̂Ŕėp͏d܂łB
//	  ̂߁Alerp_i()d(ЂĂ͈n)̒l͈̔͂̐łB
//	  ʓIȎgł͏[Ǝv܂A̒l5(=?)ȏɂȂP[Xł́AӂĉB
#ifndef PIECE
int easeOut_i(int x, int y, int n, int d) {
	n = -n;
	n += d;
	return easeIn_i(y, x, n, d);
}
#else //PIECE
int easeIn_i(int x, int y, int n, int d);
asm("
		.code
		.align		1
		.global		easeOut_i
easeOut_i:
		not		%r14, %r14		;//%r14 := n = -n
		add		%r14, 1			;//
		add		%r14, %r15		;//%r14 := n += d
		ld.w		%r9, %r12		;//%r9  :=            x
		ld.w		%r12, %r13		;//%r12 :=         y
		xjp.d		easeIn_i		;//return easeIn_i(y, x, n, d)
		ld.w		%r13, %r9		;//%r13 :=            x		*delay*
");
#endif//PIECE
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#if 0
//easeOut_i()̃eXgXC[g
int app_main(int argc, char* argv[]) {
	int x, y, n, d, a;
	double b;
	for(;;) {
		     x = mrand48();
		     y = mrand48();
		do { d = lrand48() % (SHRT_MAX + 1); } while(!d);
		     n = lrand48() % d;
		a = easeOut_i(x, y,         n,          d);
		b = easeOut(  x, y, (double)n / (double)d);
	#ifndef PIECE
		       printf(                     "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
	#else //PIECE
		surface_clear(&surface, 0);
		render_printf(&render, 0, 0, 2, 3, "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
		update();
		if(pcePadGetDirect() & PAD_SELECT) { break; }
	#endif//PIECE
		if((b >= INT_MIN) && (b <= INT_MAX)) {	//ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ΁c
			if(abs(a - lround(b)) > 1) {	//̐؂̂Č덷͈̔͂Őʂ͂B
				die("x = % 11d\n"
				    "y = % 11d\n"
				    "n = % 11d\n"
				    "d = % 11d\n"
				    "a = % 11d\n"
				    "b = % 11d\n", x, y, n, d, a, lround(b));
			}
		}
	}
	return 0;
}
#endif
//-----------------------------------------------------------------------------
//蓮oĉA܂铮łB
//[in]
//	x		JnlB		INT_MIN`INT_MAX	̓sAZrŁA(y + x)INT_MIN`INT_MAX͈̔͂𒴂ꍇAʂsɂȂ܂B
//	y		IlB		INT_MIN`INT_MAX	
//	n		ԌW̕qB	0`d
//	d		ԌW̕B	1`SHRT_MAX
//[out]
//	߂l		ԌʁB
//[note]
//	- lerp_i()͊{Ȃ̂ŔėpdĈ̒l͈݂̔͂̐Ȃ悤ɂ܂A֐(easeInOut_i())͖[Ǝv̂Ŕėp͏d܂łB
//	  ̂߁Alerp_i()d(ЂĂ͈n)̒l͈̔͂̐łB
//	  ʓIȎgł͏[Ǝv܂A̒l5(=?)ȏɂȂP[Xł́AӂĉB
//{{2017/08/08폜:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
//#ifndef PIECE
//int easeInOut_i(int x, int y, int n, int d) {
//	y += x;								//̓sAZrŁA(y + x)INT_MIN`INT_MAX͈̔͂𒴂ꍇAʂsɂȂ܂B
//	n <<= 1;
//	if(n >= d) {
//		x = -x;
//		x += y;
//		n = -n;
//		n += d << 1;
//	}
//	y >>= 1;
//	return easeIn_i(x, y, n, d);										//easeInOut_i()easeOutIn_i()̈Ⴂ́A̍słB
//}
//#else //PIECE
//int easeInOut_i(int x, int y, int n, int d);
//asm("
//		.code
//		.align		1
//		.global		easeInOut_i
//easeInOut_i:
//		sla		%r14, 1			;//%r14 := n <<= 1
//		cmp		%r14, %r15		;//if(n >= d) {
//		jrlt.d		easeInOut_i_L10		;//  
//		add		%r13, %r12		;//%r13 := y += x		*delay*
//		not		%r12, %r12		;//  %r12 := x = -x
//		add		%r12, 1			;//  
//		add		%r12, %r13		;//  %r12 := x += y
//		not		%r14, %r14		;//  %r14 := n = -n
//		add		%r14, 1			;//  
//		add		%r14, %r15		;//  %r14 := n += d << 1
//		add		%r14, %r15		;//  
//easeInOut_i_L10:					;//}
//		xjp.d		easeIn_i		;//return easeIn_i(x, y, n, d)				//easeInOut_i()easeOutIn_i()̈Ⴂ́A̍słB
//		sra		%r13, 1			;//%r13 := y >>= 1		*delay*
//");
//#endif//PIECE
//}}2017/08/08폜:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#if 0
//easeInOut_i()̃eXgXC[g
int app_main(int argc, char* argv[]) {
	int x, y, n, d, a;
	double b;
	for(;;) {
		     x = mrand48();
		     y = mrand48();
		do { d = lrand48() % (SHRT_MAX + 1); } while(!d);
		     n = lrand48() % d;
		if((((double)x + (double)y) < (double)INT_MIN) || (((double)x + (double)y) > (double)INT_MAX)) { continue; }
		a = easeInOut_i(x, y,         n,          d);
		b = easeInOut(  x, y, (double)n / (double)d);
	#ifndef PIECE
		       printf(                     "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
	#else //PIECE
		surface_clear(&surface, 0);
		render_printf(&render, 0, 0, 2, 3, "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
		update();
		if(pcePadGetDirect() & PAD_SELECT) { break; }
	#endif//PIECE
		if((b >= INT_MIN) && (b <= INT_MAX)) {	//ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ΁c
			if(abs(a - lround(b)) > 1) {	//̐؂̂Č덷͈̔͂Őʂ͂B
				die("x = % 11d\n"
				    "y = % 11d\n"
				    "n = % 11d\n"
				    "d = % 11d\n"
				    "a = % 11d\n"
				    "b = % 11d\n", x, y, n, d, a, lround(b));
			}
		}
	}
	return 0;
}
#endif
//-----------------------------------------------------------------------------
//œoČA܂铮łB
//[in]
//	x		JnlB		INT_MIN`INT_MAX	̓sAZrŁA(y + x)INT_MIN`INT_MAX͈̔͂𒴂ꍇAʂsɂȂ܂B
//	y		IlB		INT_MIN`INT_MAX	
//	n		ԌW̕qB	0`d
//	d		ԌW̕B	1`SHRT_MAX
//[out]
//	߂l		ԌʁB
//[note]
//	- lerp_i()͊{Ȃ̂ŔėpdĈ̒l͈݂̔͂̐Ȃ悤ɂ܂A֐(easeOutIn_i())͖[Ǝv̂Ŕėp͏d܂łB
//	  ̂߁Alerp_i()d(ЂĂ͈n)̒l͈̔͂̐łB
//	  ʓIȎgł͏[Ǝv܂A̒l5(=?)ȏɂȂP[Xł́AӂĉB
//{{2017/08/08폜:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
//#ifndef PIECE
//int easeOutIn_i(int x, int y, int n, int d) {
//	y += x;								//̓sAZrŁA(y + x)INT_MIN`INT_MAX͈̔͂𒴂ꍇAʂsɂȂ܂B
//	n <<= 1;
//	if(n >= d) {
//		x = -x;
//		x += y;
//		n = -n;
//		n += d << 1;
//	}
//	y >>= 1;
//	return easeOut_i(x, y, n, d);										//easeInOut_i()easeOutIn_i()̈Ⴂ́A̍słB
//}
//#else //PIECE
//int easeOutIn_i(int x, int y, int n, int d);
//asm("
//		.code
//		.align		1
//		.global		easeOutIn_i
//easeOutIn_i:
//		sla		%r14, 1			;//%r14 := n <<= 1
//		cmp		%r14, %r15		;//if(n >= d) {
//		jrlt.d		easeOutIn_i_L10		;//  
//		add		%r13, %r12		;//%r13 := y += x		*delay*
//		not		%r12, %r12		;//  %r12 := x = -x
//		add		%r12, 1			;//  
//		add		%r12, %r13		;//  %r12 := x += y
//		not		%r14, %r14		;//  %r14 := n = -n
//		add		%r14, 1			;//  
//		add		%r14, %r15		;//  %r14 := n += d << 1
//		add		%r14, %r15		;//  
//easeOutIn_i_L10:					;//}
//		xjp.d		easeOut_i		;//return easeIn_i(x, y, n, d)				//easeInOut_i()easeOutIn_i()̈Ⴂ́A̍słB
//		sra		%r13, 1			;//%r13 := y >>= 1		*delay*
//");
//#endif//PIECE
//}}2017/08/08폜:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#if 0
//easeOutIn_i()̃eXgXC[g
int app_main(int argc, char* argv[]) {
	int x, y, n, d, a;
	double b;
	for(;;) {
		     x = mrand48();
		     y = mrand48();
		do { d = lrand48() % (SHRT_MAX + 1); } while(!d);
		     n = lrand48() % d;
		if((((double)x + (double)y) < (double)INT_MIN) || (((double)x + (double)y) > (double)INT_MAX)) { continue; }
		a = easeOutIn_i(x, y,         n,          d);
		b = easeOutIn(  x, y, (double)n / (double)d);
	#ifndef PIECE
		       printf(                     "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
	#else //PIECE
		surface_clear(&surface, 0);
		render_printf(&render, 0, 0, 2, 3, "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
		update();
		if(pcePadGetDirect() & PAD_SELECT) { break; }
	#endif//PIECE
		if((b >= INT_MIN) && (b <= INT_MAX)) {	//ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ΁c
			if(abs(a - lround(b)) > 1) {	//̐؂̂Č덷͈̔͂Őʂ͂B
				die("x = % 11d\n"
				    "y = % 11d\n"
				    "n = % 11d\n"
				    "d = % 11d\n"
				    "a = % 11d\n"
				    "b = % 11d\n", x, y, n, d, a, lround(b));
			}
		}
	}
	return 0;
}
#endif
//-----------------------------------------------------------------------------
//{{2017/08/08ǉ:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
#ifndef PIECE
static int easeInOut_easeOutIn_i(int x, int y, int n, int d, int (*fn)(int x, int y, int n, int d));		//OQ
int easeInOut_i(int x, int y, int n, int d) { return easeInOut_easeOutIn_i(x, y, n, d, easeIn_i); }
int easeOutIn_i(int x, int y, int n, int d) { return easeInOut_easeOutIn_i(x, y, n, d, easeOut_i); }
static int easeInOut_easeOutIn_i(int x, int y, int n, int d, int (*fn)(int x, int y, int n, int d)) {
	y += x;								//̓sAZrŁA(y + x)INT_MIN`INT_MAX͈̔͂𒴂ꍇAʂsɂȂ܂B
	n <<= 1;
	if(n >= d) {
		x = -x;
		x += y;
		n = -n;
		n += d << 1;
	}
	y >>= 1;
	return (*fn)(x, y, n, d);
}
#else //PIECE
int easeInOut_i(int x, int y, int n, int d);
int easeOutIn_i(int x, int y, int n, int d);
asm("
		.code
		.align		1
		.global		easeInOut_i
		.global		easeOutIn_i
easeInOut_i:
		xld.w		%r9, easeIn_i			;//%r9  := fn = easeIn_i
		jp		easeInOut_easeOutIn_i
easeOutIn_i:
		xld.w		%r9, easeOut_i			;//%r9  := fn = easeOut_i
easeInOut_easeOutIn_i:
		sla		%r14, 1				;//%r14 := n <<= 1
		cmp		%r14, %r15			;//if(n >= d) {
		jrlt.d		easeInOut_easeOutIn_i_L10	;//  
		add		%r13, %r12			;//%r13 := y += x		*delay*
		not		%r12, %r12			;//  %r12 := x = -x
		add		%r12, 1				;//  
		add		%r12, %r13			;//  %r12 := x += y
		not		%r14, %r14			;//  %r14 := n = -n
		add		%r14, 1				;//  
		add		%r14, %r15			;//  %r14 := n += d << 1
		add		%r14, %r15			;//  
easeInOut_easeOutIn_i_L10:					;//}
		sra		%r13, 1				;//%r13 := y >>= 1
		jp		%r9				;//return (*fn)(x, y, n, d)	(jp.d %rb͕s)
");
#endif//PIECE
//}}2017/08/08ǉ:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
//*****************************************************************************
//	A
//*****************************************************************************
//m[ns][n]̍s(determinant)߂܂B
//[note]
//	- matnf_determinant()APx˔{xɕύX֐łB
//	  gASÝAmatnf_determinant()ƓłB
//	  ڍׂ́Aclipflt1.cmatnf_determinant()̎QƂĉB
//	- ֐ZĂՓ˂Ȃ̂ŁAv؂ĒZ܂B
//	  ֐Փ˂ꍇ́AύXĉB
double determinant(const double* m/*[n][n]*/, int n) {
	int i;
	double d;
	if(n < 1) { DIE(); }
	//]qWJpāAs(determinant)߂܂B
	d = 0.0;
	for(i = 0; i < n; i++) {
		d += (m[(n * i) + 0/*j*/] * cofactor(m, n, i, 0/*j*/));
	}
	return d;
}
//-----------------------------------------------------------------------------
//m[ns][n]isjA]q(cofactor)߂܂B
//[note]
//	- matnf_cofactor()APx˔{xɕύX֐łB
//	  gASÝAmatnf_cofactor()ƓłB
//	  ڍׂ́Aclipflt1.cmatnf_cofactor()̎QƂĉB
//	- ֐ZĂՓ˂Ȃ̂ŁAv؂ĒZ܂B
//	  ֐Փ˂ꍇ́AύXĉB
double cofactor(const double* m/*[n][n]*/, int n, int i, int j) {
	int k, l;
	double d;
	double* s/*[n-1][n-1]*/;
	double* t/*[n-1][n-1]*/;
	if((n < 1) ||
	   (i < 0) || (i > (n - 1)) ||
	   (j < 0) || (j > (n - 1))) { DIE(); }
	//m[ns][n]isjAs(submatrix)쐬܂B
	if(n == 1) { return 1; } //s0s0ɂȂꍇ
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
	s = malloc(sizeof(double) * ((n - 1) * (n - 1)));
	if(!s) { DIE(); }
#else //!(defined(_WIN32)&&defined(_MT))
//Win32}`Xbh̏ꍇɗLȃubN
	s = alloca(sizeof(double) * ((n - 1) * (n - 1)));
#endif//!(defined(_WIN32)&&defined(_MT))
	t = s;
	for(k = 0; k < n; k++) {
		for(l = 0; l < n; l++) {
			if((k != i) && (l != j)) {
				*t++ = *m;
			}
			m++;
		}
	}
	//s(minor determinant)߂܂B
	d = determinant(s, (n - 1));
	//]q(cofactor)߂܂B
	if((i ^ j) & 1) { d = -d; }
	//s܂B
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
	free(s);
#endif//!(defined(_WIN32)&&defined(_MT))
	return d;
}
//-----------------------------------------------------------------------------
//nẢ߂܂B
//[note]
//	- solve_simultaneous_equations()APx˔{xɕύX֐łB
//	  gASÝAsolve_simultaneous_equations()ƓłB
//	  ڍׂ́Aclipflt1.csolve_simultaneous_equations()̎QƂĉB
//	- Asolve_simultaneous_equations()ƊrׂāAύX_L܂B
//	  solve_simultaneous_equations()͖߂lłA֐͏̓rŋ߂s񎮂̒lԂ悤ɂ܂B
//	  ẢLs񎮂̒lĔf邽߂ɁAʓrdeterminant()ĂяoǂłB
//	  solve_simultaneous_equations()ł́ALȉA͎w肳ȂOŖ߂lɂĂ܂A
//	  ۂɂ́ALȉAw肳\LƍlďL̖߂l̎dlύXsɂ܂B
//	  ܂ł̓rŋ߂s񎮂̒lԂ悤ɂ̕ύXłAê͈ؕύXĂ܂B
//	  ܂A֐ԂlQƂ邩ǂAĂяołB
//	  LȉAw肵ȂOȂ΁A߂l𖳎Ă\܂B
//	- ֐ZĂՓ˂Ȃ̂ŁAv؂ĒZ܂B
//	  ֐Փ˂ꍇ́AύXĉB
//	  Ȃ݂MATLABɂAA֐Ƃsolve()ƂO̊֐邻łB
//	  pr͎Ă܂Adl͌݊ł͂܂B܂ܖOvłB
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
double solve(const double* A/*[n][n]*/, const double* b/*[n]*/, double* x/*[n]*/, int n) {
	int i, j;
	double d;
	//s(determinant)߂܂B
	d = determinant(A, n);
	//ŇpāAA̋ts߂ȂAb|āAx߂܂B
	for(i = 0; i < n; i++) {
		x[i] = 0.0;
		for(j = 0; j < n; j++) {
			x[i] += (cofactor(A, n, j, i) / d) * b[j];
			//            !!~~~~
		}
	}
	//s񎮂Ԃ܂B
	return d;
}
#else //!(defined(_WIN32)&&defined(_MT))
//Win32}`Xbh̏ꍇɗLȃubN
struct _ST_solve {
	const double*		A/*[n][n]*/;	//solve()̈ƓłBsolve_start_routine()͎QƐpłBĂ͂܂B
	const double*		b/*[n]*/;	//
	double*			x/*[n]*/;	//
	int			n;		//
	double			d;		//solve()li[܂Bsolve_start_routine()͎QƐpłBĂ͂܂B
	volatile int		i;		//i0nBsolve_start_routine()ǂݏ܂Biǂݏ鎞csbNĉB
	CRITICAL_SECTION 	cs;		//
};
static unsigned __stdcall solve_start_routine(void* _arg) {
	struct _ST_solve* arg = _arg;
	const double* const A = arg->A;
	const double* const b = arg->b;
	double*       const x = arg->x;
	int           const n = arg->n;
	double        const d = arg->d;
	for(;;) {
		int i, j;
	    EnterCriticalSection(&arg->cs);	//{{arg->i̓ǂݏ:
		i = arg->i;
		if(i != n) { arg->i = (i + 1); }
	    LeaveCriticalSection(&arg->cs);	//}}arg->i̓ǂݏ:܂
		if(i == n) { break; }
		x[i] = 0.0;
		for(j = 0; j < n; j++) {
			x[i] += (cofactor(A, n, j, i) / d) * b[j];
			//            !!~~~~
		}
	}
	return 0;
}
double solve(const double* A/*[n][n]*/, const double* b/*[n]*/, double* x/*[n]*/, int n) {
	struct _ST_solve arg;
	HANDLE hThread[16/**/];	//֐쐬Xbh̐͂̔zTCYƂȂB2016/03/19݂16XbhƂB16RAȏCPUʓIɂȂꍇ͂̔zTCY𑝂₹B
	int nThread, iThread;
	SYSTEM_INFO si;
	//\̂B
	arg.A = A;
	arg.b = b;
	arg.x = x;
	arg.n = n;
	arg.d = determinant(A, n);	//s(determinant)߂܂B
	arg.i = 0;
	//NeBJZNV쐬B
	InitializeCriticalSection(&arg.cs);
	//Xbh߂邽߂ɁACPU̘_RA擾B
	GetSystemInfo(&si);
	nThread = si.dwNumberOfProcessors;
	//CPU̘_RAAhThread[]z̃TCYꍇ́A؂l߂B
	if(nThread > ARRAY_SIZE(hThread)) { nThread = ARRAY_SIZE(hThread); }
	//CPU̘_RAAz̎ꍇ́A؂l߂B
	// - z̎葽Xbh𐶐ĂA͖薳AȂXbhĖʂłB
	if(nThread > n) { nThread = n; }
	//Xbh쐬B
	for(iThread = 0; iThread < nThread; iThread++) {
		hThread[iThread] = (HANDLE)_beginthreadex(NULL,
			0,
			solve_start_routine,
			&arg,
			0,
			NULL);
		if(!hThread[iThread]) { DIE(); }	//oO,,\[Xs
	}
	//Xbh̊҂B
	iThread = WaitForMultipleObjects(nThread, hThread, TRUE, INFINITE);
	if((unsigned)(iThread - WAIT_OBJECT_0) >= (unsigned)nThread) { DIE(); }	//oO
	//XbhJB
	for(iThread = 0; iThread < nThread; iThread++) {
		if(!CloseHandle(hThread[iThread])) { DIE(); }	//oO
	}
	//NeBJZNV폜B
	DeleteCriticalSection(&arg.cs);	//YȂ!!
	//s񎮂Ԃ܂B
	return arg.d;
}
#endif//!(defined(_WIN32)&&defined(_MT))
