/*
 *	clipfix.h
 *
 *	Œ菬Cu`܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2003-2017 Naoyuki Sawa
 *
 *	* Mon Mar 24 04:30:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Thu Jul  8 06:00:00 JST 2004 Naoyuki Sawa
 *	- fcom()ficom()̈A(a,b,cond)(f,cond,b)֕ύX܂B
 *	  ύXŔAvO̓ǂ݈Ղ̂߂łB
 *	* Mon Jul 12 06:00:00 JST 2004 Naoyuki Sawa
 *	- fild()̒`((a)*FIXED_SCALE))((a)<<FRACT_BITS))֕ύX܂B
 *	  ύXŔÂ߂łB
 *	* Thu Jul 22 12:30:00 JST 2004 Naoyuki Sawa
 *	- FRND()FRND_RANGE()ǉ܂B
 *	* Wed Jul 28 04:59:00 JST 2004 Naoyuki Sawa
 *	- FRND()̖߂lfixedɃLXĝYĂ̂CB
 *	* Wed Sep 15 06:36:00 JST 2004 Naoyuki Sawa
 *	- RND8/16,RND8/16_RANGẼ}N֐ɔAFRND,FRND_RANGE֐܂B
 *	  ߋ̃\[X̌݊̂߁A֐Ăяo}N`Ă܂B
 *	* Thu Dec 30 06:52:00 JST 2004 Naoyuki Sawa
 *	- DEG/RAD/GRAD}Nǉ܂B
 *	* Sat Jul 08 04:00:13 JST 2006 Naoyuki Sawa
 *	- tZufsubr()vǉ܂Bȉ̓͓̎łB
 *		fr =  fsub(f1, f2);
 *		fr = fsubr(f2, f1);
 *	  ̏tɂ邾œɂȂ̂ŁÅ֐ɗʂ͂܂薳Ǝv܂B
 *	- ̋tZufisubr()vǉ܂Bȉ̓͓̎łB
 *		fr =   fsub(fild(i1), f2);
 *		fr = fisubr(     f2,  i1);
 *	  ̏tɂ邱Ƃ̑Afild()}Nȗł̂ŁAɗƎv܂B
 *	- tZufdivr()vǉ܂Bȉ̓͓̎łB
 *		fr =  fdiv(f1, f2);
 *		fr = fdivr(f2, f1);
 *	  ̏tɂ邾œɂȂ̂ŁÅ֐ɗʂ͂܂薳Ǝv܂B
 *	- ̋tZufidivr()vǉ܂Bȉ̓͓̎łB
 *		fr =   fdiv(fild(i1), f2);
 *		fr = fidivr(     f2,  i1);
 *	  ̏tɂ邱Ƃ̑Afild()}Nȗł̂ŁAɗƎv܂B
 *	- TODO:xNgZƍs񉉎ZɂAfsubr(),fdivr()Ɠl̋tZ`ǉ܂傤B
 *	- Œ菬̎ȑZ}N`܂B
 *	  xNgƍs̎ȑZ}ŃAAKvɉĒǉ\łB 2006/09/14 ǉ܂B
 *	  TODO:ȑ`uvxform_()v쐬ꍇAEӍׂ֑ǂAvłB
 *	- TODO:80x87̏]߂́uFPREMvłB{W[ɂufprem()v֐ǉ܂傤B  2006/07/11 ǉ܂B
 *	* Tue Jul 11 07:14:35 JST 2006 Naoyuki Sawa
 *	- ]Zufprem()vǉ܂B
 *	  <math.h>fmod()֐ɑ@\łB
 *	  fprem()̖̂́A80x87̏]߁uFPREMvɗR܂B
 *	- ́A(fiprem())tZ`(fpremr())́A쐬܂łB
 *	  쐬ȂƂɂŔA]ZɂāǍ`𗘗p邱Ƃ͖낤ƍlłB
 *	  ܂A80x87ɂuFPREMv߂̐łtZ`݂͑ȂłB
 *	- FPREMfmod()̌ʂ́̕A폘ƓɂȂ܂B́AdlłB
 *	  AC̐u%vZq̌ʂ́̕AnˑƂȂ܂B
 *	  GCCVisual C++̐u%vZq́A܂܁AFPREMfmod()̎dlƓƂȂĂ܂B
 *	  ]āAfprem()̎ɂ́APC̐u%vZq𗘗p܂B
 *	  u%vZq̌ʂA폘ƓɂȂȂn݂̂ǂsłAÔߗӂׂłB
 *	* Thu Sep 14 13:36:26 JST 2006 Naoyuki Sawa
 *	- _̒萔`܂B(M_PIȂ)
 *	  Borland C++ Compiler 5.5  <math.h> q؂̂łB
 *	  Visual C++ 6.0  <math.h> ɂ͒`Ă܂B
 *	  ufixed d = fld(M_PI * 123.4 / 180.0); // 123.4\fixedlv̂悤ɗp܂B
 *	- xNgƍs̎ȑZ}Nǉ܂B
 *	* Sat Dec 30 17:42:52 JST 2006 Naoyuki Sawa
 *	- M_PI2̒`ǉ܂B
 *	  Borland C++ Compiler 5.5͂ȂAQ΂ɑV{`ĂȂ̂łA
 *	  gppxAV{댯Ȃ̂ŁA`ĂƂɂ܂B
 *	* Sat Feb 10 22:56:55 JST 2007 Naoyuki Sawa
 *	- fceil(),ffloor(),ficeil(),fifloor(),fceil_(),ffloor_()ǉ܂B
 *	* Tue Apr 03 00:33:39 JST 2007 Naoyuki Sawa
 *	- POSITIVE_MIN,POSITIVE_MAX,NEGATIVE_MIN,NEGATIVE_MAXǉ܂B
 *	* Tue Apr 03 18:29:20 JST 2007 Naoyuki Sawa
 *	- fcom()}Nficom()}N̒`ASȂ̂ɕύX܂B
 *	* Tue Jan 29 15:21:49 JST 2008 Naoyuki Sawa
 *	- fprem_()ǉ܂B
 *	* Thu Apr 02 13:37:51 JST 2009 Naoyuki Sawa
 *	- clipflt1.cW[ɁAxtof()ftox()ǉ܂B(clipfixW[̕ύX͗L܂)
 *	  xtof(),ftox()֐́Afst(),fld()}NƓłAfst(),fld()IȎƂ܂B
 *	  }NWJKvȂꍇ́Afst(),fld()Axtof(),ftox()𗘗pA҂ł܂B
 *	  ڍׂ́Aclipflt1.cW[̃RgQƂĂB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Tue Nov 24 21:15:16 JST 2015 Naoyuki Sawa
 *	- M_E,M_PI̒`Aclipfix.hmath.hֈړ܂B
 *	- M_PI2̒`͕WIł͂Ȃ̂ō폜܂B
 *	* Sat Jul 22 22:21:25 JST 2017 Naoyuki Sawa
 *	- clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
 *	  ̓Iɂ́Aȉ̂悤ȓ_C܂B
 *	- COFIX_NOASMV{̒`/`ƂŕύX悤ɂĂAAFIX_NOASM͏ɖ`ƂȂĂ܂B
 *	  ĆAP/ECEȂFIX_NOASM͖`AP/ECEȊOȂFIX_NOASM`悤ɂ܂B
 *	- Œ菬f[^^̒`AĒʏ̉ZqKpȂ悤ɖ`\̂ւ̃|C^^ƂĂ܂AWin64̏ꍇ(d)unsigned^ɂ܂B
 *	  Win64ł|C^^ɂƁA64bitɂȂĂ܂ɁAP(int)ւ̃LXgƌxoāA(intptr_t)oRKvLĎghłB
 *	  Win64ł͌Œ菬f[^^unsigned^ɂ̂ŁAĒʏ̉ZqKpĂxoȂ̂ŁAWin32,,P/ECEŃrh鎞ɌxmFĉB
 *	  Ȃ݂ɁAint^ł͂Ȃunsigned^ƂŔA|C^^ɋ߂̌^ɂŁA[Ӗ͂܂B(ǁAI(int)ɃLXgĎĝŁB)
 *	- GCCg@\̐֐gpvector,matrix\̂𐶐ĂӏAVɒ`vector_(),matrix_()gp悤ɏC܂B
 *	  vector_(),matrix_()́AGCCȂ΂܂Œʂ萶֐ɓWJAGCCȊOȂvector,matrix\̂𐶐CC֐ɓWJ܂B
 *	- 'long long'gpĂA'int64_t'ɏC܂B
 *	  TtBbNX'll'gpĂA'INT64_C'ɏC܂B
 */
#ifndef __CLIP_FIX_H__
#define __CLIP_FIX_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

//{{2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
///* FIX_NOASM`C[`A`Ȃasm[`g܂B */
//#undef FIX_NOASM	/* ܂mɖ`ɂŁc */
////#define FIX_NOASM	/* KvɉĒ`Ăi`ƒxȂ܂j */
//2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
#ifndef PIECE
#define FIX_NOASM	//P/ECEȊOȂ΁AAZu[`gp*Ȃ*߂ɁAFIX_NOASMV{`**B
#else //PIECE
#undef  FIX_NOASM	//P/ECEȂ΁AAZu[`gp**߂ɁAFIX_NOASMV{`*Ȃ*B	P/ECEłFIX_NOASM`āAAZu[`gpȂ悤ɂ鎖͉\ł(eXgȂ)Bꍇ́A̍s'#define FIX_NOASM'ɕύXĉB
#endif//PIECE
//}}2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B

/*****************************************************************************
 *	萔
 *****************************************************************************/

//{{2015/11/24폜:M_E,M_PI̒`Aclipfix.hmath.hֈړ܂BM_PI2̒`͕WIł͂Ȃ̂ō폜܂B
///* Borland C++ Compiler 5.5 <math.h>  */
//#define M_E		2.71828182845904523536		// 
//#define M_LOG2E		1.44269504088896340736		// logQ()
//#define M_LOG10E	0.434294481903251827651		// log10()
//#define M_LN2		0.693147180559945309417		// log(Q)
//#define M_LN10		2.30258509299404568402		// log(10)
//#define M_PI		3.14159265358979323846		// 
//#define M_PI_2		1.57079632679489661923		// ΁^Q 
//#define M_PI_4		0.785398163397448309616		// ΁^S
//#define M_1_PI		0.318309886183790671538		// P^
//#define M_2_PI		0.636619772367581343076		// Q^
//#define M_1_SQRTPI	0.564189583547756286948		// P^()
//#define M_2_SQRTPI	1.12837916709551257390		// Q^()
//#define M_SQRT2		1.41421356237309504880		//     (Q)
//#define M_SQRT_2	0.707106781186547524401		// P^(Q) = (P^Q)
///* * Sat Dec 30 17:42:52 JST 2006 Naoyuki Sawa
// * - M_PI2̒`ǉ܂B
// *   Borland C++ Compiler 5.5͂ȂAQ΂ɑV{`ĂȂ̂łA
// *   gppxAV{댯Ȃ̂ŁA`ĂƂɂ܂B
// */
//#define M_PI2		6.28318530717958647692 		// Q
//}}2015/11/24폜:M_E,M_PI̒`Aclipfix.hmath.hֈړ܂BM_PI2̒`͕WIł͂Ȃ̂ō폜܂B

/*****************************************************************************
 *	fixed
 *****************************************************************************/

#define FRACT_BITS	10			/* rbg */
#define VALUE_BITS	(32 - FRACT_BITS)	/* rbg */
#define FIXED_SCALE	(1 << FRACT_BITS)	/* Œ菬XP[l */
#define FRACT_MASK	((1 << FRACT_BITS) - 1)	/* rbg}XN */

/* dv: (fchs(POSITIVE_MAX) != NEGATIVE_MAX) łBӂĂ!! */
#define POSITIVE_MIN	((fixed)+1)		/* fixed^̐̍ŏl */
#define POSITIVE_MAX	((fixed)INT_MAX)	/* fixed^̐̍ől */
#define NEGATIVE_MIN	((fixed)-1)		/* fixed^̍̕ŏl */
#define NEGATIVE_MAX	((fixed)INT_MIN)	/* fixed^̍̕ől */

/* Œ菬f[^^̒`łB
 * * struct _fixed ͖`łBȂ킿Afixed̎Ԃ͖`\̂ւ̃|C^łB
 * - fixed̂悤ɒ`ŔAĒʏ̉ZqKpłȂ悤ɂ邽߂łB
 *   
 *	(1) typedef int fixed;
 *	(2) typedef void* fixed;
 *   ̂悤ɒ`ꍇÂ悤ȌZʂĂ܂܂B((1),(2))
 *	fixed f;
 *	int n;
 *	...
 *	f += n; // { f = fadd(f, fild(n)) Ƃׂ
 * - ʏ̉ZqKp邽߂̕ʂ̕@ƂāAfixed\̂ƂĒ`@܂B
 *	(3) typedef struct _fixed {
 *		unsigned fract:FRACT_BITS;
 *		int value:VALUE_BITS;
 *	    } fixed;
 *   (3)̕@̂ȂŔAs̒ቺ邽߂łB
 *   gcc33ł́A\̈̓WX^nł͂ȂX^bNnƂȂ܂B
 *   Ƃ\̃TCY32rbgȓłĂAɃX^bNnƂȂ܂B
 *   lZŃX^bNnƎs傫ቺ̂ŁA̕@͍̂܂łB
 *   ܂A|C^Ɋrׂ(int)ւ̃LXgAZ}N`̂Ȃ_A
 *   (3)̕@̂ȂR̂ЂƂłB
 */
//{{2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
//typedef struct _fixed* fixed;
//2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
#ifndef _WIN64
typedef struct _fixed* fixed;	//Win32,P/ECE,ėp
#else //_WIN64
typedef unsigned       fixed;	//Win64
#endif//_WIN64
//}}2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B

/* orŒ菬iO[oϐ̏Ɏg߁ACC֐ł͂Ȃ}NƂĒ`j */
#define  fld(a)		((fixed)(int)((a) * FIXED_SCALE))
/*           Œ菬iO[oϐ̏Ɏg߁ACC֐ł͂Ȃ}NƂĒ`j */
#define fild(a)		((fixed)     ((a) << FRACT_BITS))
/* Œ菬 */
static inline float fst(fixed a) { return (float)(int)a / FIXED_SCALE; }
/* Œ菬 */
static inline int fist(fixed a) { return (int)a >> FRACT_BITS; }
/* ] */
static inline fixed fchs(fixed a) { return (fixed)-(int)a; }
/* Βlifabs()͕WCCu̓֐ƂԂ̂ŉj */
static inline fixed ffabs(fixed a) { return (int)a >= 0 ? a : fchs(a); }
/* Z */
static inline fixed  fadd(fixed a, fixed b) { return (fixed)((int)a + (int)     b ); }
static inline fixed fiadd(fixed a, int   b) { return (fixed)((int)a + (int)fild(b)); }
/* Z */
static inline fixed   fsub(fixed a, fixed b) { return (fixed)((int)a - (int)     b ); }
static inline fixed  fisub(fixed a, int   b) { return (fixed)((int)a - (int)fild(b)); }
static inline fixed  fsubr(fixed a, fixed b) { return (fixed)((int)     b -  (int)a); } /* 2006/07/08 ǉ */
static inline fixed fisubr(fixed a, int   b) { return (fixed)((int)fild(b) - (int)a); } /* 2006/07/08 ǉ */
/* r */
//static inline int fcom (fixed a, fixed b) { return (int)fsub (a, b); }
//static inline int ficom(fixed a, int   b) { return (int)fisub(a, b); }
//ł̓_Iab̍傫ƂɃI[o[t[Ă܂Ał܂B
//#define  fcom(a, cond, b)	((int)(a) cond (int)    (b))
//#define ficom(a, cond, b)	((int)(a) cond (int)fild(b))
//* Tue Apr 03 18:29:20 JST 2007 Naoyuki Sawa
//- fcom()}Nficom()}N̒`ASȂ̂ɕύX܂B
//- `ł́Afcom()}Nficom()}N̈^ԈႦĂx\ꂸAꂪ܂B
//  <>
//	fixed a = ...;
//	int b = ...;
//	if(fcom(a, >, b)) { ... }  if((int)a > (int)b) { ... } ƓWJĂ܂Ax\ȂB
//- V`ł́Afcom()}Nficom()}N̈^ԈႦƁAx\AՂȂ܂B
//  <>
//	fixed a = ...;
//	int b = ...;
//	if(fcom(a, >, b)) { ... }  WJꂽR[h́Aufixed __b__ = (b);v̕Ōx\B
//- VisualC++łGCCg@\gȂ̂ŁA`̂܂܂łB
#ifdef PIECE
//#define  fcom(a, cond, b)	({ fixed __a__ = (a); fixed __b__ =     (b); (int)__a__ cond (int)__b__; })
//#define ficom(a, cond, b)	({ fixed __a__ = (a); fixed __b__ = fild(b); (int)__a__ cond (int)__b__; })
//* Tue Apr 01 12:10:19 JST 2008 Naoyuki Sawa
//- ̂悤ɁAGCCg\̒ŔrsƁA璷ȃR[hĂ܂ƂɋCt܂B
//  rĂɕ򂷂̂łȂArʂ0/1ƂĈꎞϐɊi[A̒lĕ򂵂Ă܂܂B
//  typecheck()𗘗pāAGCCg\̊OŔrAA^s@ɏ܂B
//- ficom()butypecheck(int,b)vŌ^Ă܂ƁAshortlongƂ̔rłȂȂĂ܂܂B
//  IɌ^ȂĂAfild(b)̃VtgZɂČ^ł̂ŁAb̌^͍s܂B
#define  fcom(a, cond, b)	(typecheck(fixed, a) && typecheck(fixed, b) && ((int)(a) cond (int)    (b)))
#define ficom(a, cond, b)	(typecheck(fixed, a)                        && ((int)(a) cond (int)fild(b)))
#else /*PIECE*/
#define  fcom(a, cond, b)	((int)(a) cond (int)    (b))
#define ficom(a, cond, b)	((int)(a) cond (int)fild(b))
#endif /*PIECE*/
/* Z */
              fixed  fmul(fixed a, fixed b);
static inline fixed fimul(fixed a, int   b) { return (fixed)((int)a * b); }
/* Z */
              fixed   fdiv(fixed a, fixed b);
static inline fixed  fidiv(fixed a, int   b) { return (fixed)((int)a / b); }
static inline fixed  fdivr(fixed a, fixed b) { return fdiv(     b,  a); } /* 2006/07/08 ǉ */
static inline fixed fidivr(fixed a, int   b) { return fdiv(fild(b), a); } /* 2006/07/08 ǉ */
/* ] */
static inline fixed  fprem(fixed a, fixed b) { return (fixed)((int)a % (int)b); } /* 2006/07/11 ǉ */
/* iw肵ꍇ̌ʂ͖`łj */
fixed fsqrt(fixed a);
/* Op֐ */
fixed fsin(fixed a);		//80387ȍ~
fixed fcos(fixed a);		//80387ȍ~
fixed ftan(fixed a);		//80x87łfptan
fixed fasin(fixed a);		//80x87ɂ͂Ȃ
fixed facos(fixed a);		//80x87ɂ͂Ȃ
fixed fatan(fixed a);		//80x87łfpatan
fixed fatan2(fixed y, fixed x);	//80x87ɂ͂Ȃ
/* ؂グA؂̂ */
static inline fixed  fceil(fixed a) { return (fixed)(((int)a + FRACT_MASK) & ~FRACT_MASK); } /* 2007/02/10ǉB80x87ɂ͗L܂BBREW 2.1ɓAPIL݂łB */
static inline fixed ffloor(fixed a) { return (fixed)(((int)a             ) & ~FRACT_MASK); } /* 2007/02/10ǉB80x87ɂ͗L܂BBREW 2.1ɓAPIL݂łB */
static inline int  ficeil(fixed a) { return ((int)a + FRACT_MASK) >> FRACT_BITS; } /* 2007/02/10ǉ */
static inline int fifloor(fixed a) { return ((int)a             ) >> FRACT_BITS; } /* 2007/02/10ǉBficeil()Ƃ̑Ώ̐̂߂ɗpӂ܂Befist()ƓłB */

/* ~
 * * {̌덷h߁A/22{,4{Ē`܂B
 * * Op֐e[uւ̃ItZbgƂĂp邽߁Aint^float^̗`܂B
 */
#if FIXED_SCALE != 1024
#error Œ菬p[^zlƈقȂ܂B
#endif
#define _PI_2	1608	/* 3.14159265358979323846 / 2 * 1024 = 1608.49543863797413809152 */
#define _PI	3216	/* 3.14159265358979323846     * 1024 = 3216.99087727594827618304 */
#define _PI2	6432	/* 3.14159265358979323846 * 2 * 1024 = 6433.98175455189655236608 ({6433łA_PI_24{ɍ킹6432Ƃ܂) */
#define PI_2	((fixed)_PI_2)
#define PI	((fixed)_PI  )
#define PI2	((fixed)_PI2 )

/* ܂͕̊px\LAŒ菬̃WApɕϊ܂B
 * [in]
 *	a		ϊ̊pxB
 *			{萔,ϐ,萔,ϐ}ɂĎw\łB
 *			{萔,萔}w肵ꍇ́ARpCɌvZ܂B
 *			{ϐ,ϐ}w肵ꍇ́AsɌvZ܂B
 * [out]
 *	߂l		ϊ̊pxB
 *			Œ菬̃WApłB
 * [note]
 *	* <>
 *	  fixed a = DEG(45);   //  45x
 *	  fixed b = RAD(3.14); // 180x
 *	  fixed c = GRAD(200); // 360x
 */
#define  RAD(a)		(fld(a))					/* WA(p= 1) */
//#define  DEG(a)	(fidiv(fmul(fld(a), PI_2),  90))		/* fO[(p=90x) */
//#define GDEG(a)	(fidiv(fmul(fld(a), PI_2), 100))		/* O[h(p=100G) */
//fmul()͊֐ĂяoȂ̂ŁA萔łsvZɂȂĂ܂܂B
//萔̏ꍇ͎svZsȂ̂ŁÂ悤ɕό`܂B
#define  DEG(a)		((fixed)((int)fld(a) * _PI_2 / (int)fld( 90)))	/* fO[(p=90x) */
#define GRAD(a)		((fixed)((int)fld(a) * _PI_2 / (int)fld(100)))	/* O[h(p=100G) */

///* 0.0ȏ1.0̗𐶐܂B */
//#define FRND(s)		((fixed)(RND16(s) & FRACT_MASK))
///* (a)ȏ(b)̗𐶐܂B */
//#define FRND_RANGE(s, a, b)	fadd(fmul(FRND(s), fsub((b), (a))), (a))
//2004/09/15 RND8/16,RND8/16_RANGẼ}N֐ɔA֐܂B
//           ߋ̃\[X̌݊̂߁A֐Ăяo}N`Ă܂B
/* 0.0ȏ1.0̗𐶐܂B */
fixed frnd(int* seed);
#define FRND(s)			(frnd(&(s)))
/* (a)ȏ(b)̗𐶐܂B */
fixed frnd_range(int* seed, fixed a, fixed b);
#define FRND_RANGE(s, a, b)	(frnd_range(&(s), (a), (b)))

/*****************************************************************************
 *	vector
 *****************************************************************************/

/* xNg\̂̒`łB */
typedef struct _vector {
	fixed x;	/* X */
	fixed y;	/* Y */
	fixed z;	/* Z */
} vector;

/* `ς݂̃xNgłB */
extern const vector VECTOR_0;	/* [xNg */
extern const vector VECTOR_X;	/* XPʃxNg */
extern const vector VECTOR_Y;	/* YPʃxNg */
extern const vector VECTOR_Z;	/* ZPʃxNg */

//{{2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
///* xNg̏֐͗pӂĂ܂B
// * GCCg@\𗘗pāÂ悤ɏ܂B
// *	vector v;
// *	...
// *	v = (vector){x_value,y_value,z_value};
// *	...
// */
//2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
/* xNg\̂𐶐܂B */
#ifdef  __GNUC__
#define vector_(x_value,y_value,z_value) ((vector){(x_value),(y_value),(z_value)})								//P/ECE
#else //__GNUC__
static inline vector vector_(fixed x_value, fixed y_value, fixed z_value) { vector __tmp__ = {x_value,y_value,z_value}; return __tmp__; }	//Win32,ėp
#endif//__GNUC__
//}}2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B

/* xNg̊e𕄍]܂B
 * [in]
 *	a		]xNgB
 * [out]
 *	߂l		ʂ̃xNgB
 */
vector vchs(vector a);

/* xNg̊eZ܂B
 * [in]
 *	a,b		ZxNgB
 * [out]
 *	߂l		ʂ̃xNgB
 */
vector vadd(vector a, vector b);

/* xNg̊eZ܂B
 * [in]
 *	a,b		ZxNgB
 * [out]
 *	߂l		ʂ̃xNgB
 */
vector vsub(vector a, vector b);

/* xNg̊eZ܂B
 * [in]
 *	a,b		ZxNgB
 * [out]
 *	߂l		ʂ̃xNgB
 */
vector vmul(vector a, vector b);

/* xNg̊e𓯂lŏZ܂B
 * [in]
 *	a		ZxNgB
 *	s		ZlB
 * [out]
 *	߂l		ʂ̃xNgB
 */
vector vfmul(vector a, fixed b); // Œ菬
vector vimul(vector a, int   b); // 

/* xNg̊eZ܂B
 * [in]
 *	a,b		ZxNgB
 * [out]
 *	߂l		ʂ̃xNgB
 */
vector vdiv(vector a, vector b);

/* xNg̊e𓯂lŏZ܂B
 * [in]
 *	a		ZxNgB
 *	s		ZlB
 * [out]
 *	߂l		ʂ̃xNgB
 */
vector vfdiv(vector a, fixed b); // Œ菬
vector vidiv(vector a, int   b); // 

/* xNg̓(dot product)߂܂B
 * [in]
 *	a,b		ς߂xNgB
 * [out]
 *	߂l		ς̒lB
 * [note]
 * 	* ς̒`: aEb = |a||b|cos
 */
fixed vdot(vector a, vector b);

/* xNg̊O(cross product)߂܂B
 * [in]
 *	a,b		Oς߂xNgB
 * [out]
 *	߂l		ʂ̃xNgB
 * [note]
 * 	* Oς̒`: a~b = |a||b|sin*c
 * 	  AcabɐȒPʃxNgƂB
 */
vector vcross(vector a, vector b);

/* xNg𐳋K(normalize)܂B
 * [in]
 *	a		KxNgB
 * [out]
 *	߂l		ʂ̃xNgB
 * [note]
 *	* Tue Dec 21 06:00:00 JST 2004 Naoyuki Sawa
 *	  [xNgw肳ꂽꍇ́Â܂܃[xNgԂ悤ɂ܂B
 *	  (܂ł́A[xNgw肳ƁA[ZG[ɂȂĂ܂B)
 */
vector vnormal(vector a);

/* xNg̒(magnitude)߂܂B
 * [in]
 *	a		߂xNgB
 * [out]
 * 	߂l		ʂ̒lB
 */
fixed vmag(vector a);

/* xNg̒̓(square magnitude)߂܂B
 * [in]
 *	a		̓߂xNgB
 * [out]
 * 	߂l		ʂ̒lB
 */
fixed vmag2(vector a);

/* ˃xNg߂܂B
 * [in]
 *	N		˖ʂ̖@xNgB
 *	E		˓_ւ̃xNgB
 *			ƁAťxNgłB
 * [out]
 *	߂l		ʂ̃xNgB
 * [note]
 *	* ˃xNǧ́A̒ʂłB
 *		R = 2(EEN)N - E
 *	  l:
 *	  xNgE,N_ƂāAEN֐낵ꍇA
 *	  ̐NƌP_
 *		P = (EEN)N
 *	  łBȂȂA(EEN)̓xNgE,N̂ȂpcoslłB
 *	  ŔAPEɓ_Ώ̂ȈʒuAȂ킿A
 *	  EAE->P̓{i񂾈ʒułB
 *		R = E + 2(P - E)
 *		  = 2P - E
 *		  = 2(EEN)N - E
 *	  ȏłB
 *	* xNgE,ŃAKĂȂ΂܂B
 *	  KĂȂꍇAԈʂƂȂ܂B
 *	  ۂɂ́AEKĂȂꍇ́A
 *	    PɌʂ̃xNg̑傫EɓȂ邾̂悤Ɏv܂B
 *	    (mF)
 *	* xNgÉA"t"xNgł邱ƂɒӂĂB
 *	  ̊֐́A˃xNg߂ƌA
 *	  NƂāAEɐΏ̂ȃxNg߂AƌmłB
 *	  ExNgƓɎg₷Ǝv̂łA
 *	  Ƃċt̕ʓIȂ悤Ȃ̂ŁAȂĂ݂܂B
 */
vector vreflect(vector N, vector E);

/*****************************************************************************
 *	matrix
 *****************************************************************************/

/* s\̂̒`łB */
typedef struct _matrix {
	/* | a00 a10 a20 |T = pxNgX */
	/* | a01 a11 a21 |T = pxNgY */
	/* | a02 a12 a22 |T = pxNgZ */
	/* | a03 a13 a23 |T = sړ        */
	fixed a00, a01, a02, a03;
	fixed a10, a11, a12, a13;
	fixed a20, a21, a22, a23;
} matrix;

/* `ς݂̍słB */
extern const matrix MATRIX_I;	/* P(identity)s */

//{{2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
///* s̏֐͗pӂĂ܂B
// * GCCg@\𗘗pāÂ悤ɏ܂B
// *	matrix m;
// *	...
// *	m = (matrix){a00_value,a01_value,...,a23_value};
// *	...
// */
//2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B
/* s\̂𐶐܂B */
#ifdef  __GNUC__
#define matrix_(a00_value,a10_value,a20_value,								\
                a01_value,a11_value,a21_value,								\
                a02_value,a12_value,a22_value,								\
                a03_value,a13_value,a23_value) ((matrix){(a00_value),(a10_value),(a20_value),		\
                                                         (a01_value),(a11_value),(a21_value),		\
                                                         (a02_value),(a12_value),(a22_value),		\
                                                         (a03_value),(a13_value),(a23_value)})								//P/ECE
#else //__GNUC__
static inline matrix matrix_(fixed a00_value, fixed a10_value, fixed a20_value,
                             fixed a01_value, fixed a11_value, fixed a21_value,
                             fixed a02_value, fixed a12_value, fixed a22_value,
                             fixed a03_value, fixed a13_value, fixed a23_value) { matrix __tmp__ = {a00_value,a10_value,a20_value,
                                                                                                    a01_value,a11_value,a21_value,
                                                                                                    a02_value,a12_value,a22_value,
                                                                                                    a03_value,a13_value,a23_value}; return __tmp__; }	//Win32,ėp
#endif//__GNUC__
//}}2017/07/22ύX:clipfix.h,clipfix.c,framfix.cWin32vWFNgɊ܂߂邽߂̏Cs܂B

/* ]u(transpose)s߂܂B
 * [in]
 *	a		]usB
 * [out]
 *	߂l		ʂ̍sB
 * [note]
 *	* sړ͏A(0,0,0)ƂȂ܂B
 */
matrix mxpose(matrix a);

/* ts(inverse)߂܂B
 * [in]
 *	a		ts߂sB
 * [out]
 *	߂l		ʂ̍sB
 * [note]
 *	* stȍsw肵ꍇ̌ʂ́A`łB
 */
matrix minv(matrix a);

/* K(normalized orthogonal)s̋ts߂܂B
 * [in]
 *	a		ts߂sB
 * [out]
 *	߂l		ʂ̍sB
 * [note]
 *	* minv()AłB
 *	* KłȂsw肵ꍇ̌ʂ́A`łB
 */
matrix minvno(matrix a);

/* xNgϊ(transform)܂B
 * [in]
 *	a		sB
 *	b		xNgB
 * [out]
 *	߂l		ʂ̃xNgB
 */
vector vxform(matrix a, vector b);

/* sϊ(transform)܂B
 * [in]
 *	a,b		sB
 *	b00`b23	s̐B
 * [out]
 *	߂l		ʂ̍sB
 */
matrix mxform(matrix a, matrix b);

/*  sړ(translate)s܂B
 * [in]
 *	a		sB
 *	x,y,z		X,Y,Z̕sړB
 * [out]
 *	߂l		ʂ̍sB
 */
matrix mxlate(matrix a, fixed x, fixed y, fixed z);

/* gEk(scale)s܂B
 * [in]
 *	a		sB
 *	x,y,z		X,Y,Z̊gEkWB
 * [out]
 *	߂l		ʂ̍sB
 */
matrix mscale(matrix a, fixed x, fixed y, fixed z);

/* X,Y,ZƂWŁAgEks܂B
 * [in]
 *	a		sB
 *	s		gEkWB
 * [out]
 *	߂l		ʂ̍sB
 */
matrix mfscale(matrix a, fixed s);

/* Cӎ](rotate)s܂B
 * [in]
 *	a		sB
 *	x,y,z		]̃xNgB
 *	d		]pxB
 * [out]
 *	߂l		ʂ̍sB
 * [note]
 *	* ]̃xNǵAKĂȂĂ\܂B
 */
matrix mrot(matrix a, fixed x, fixed y, fixed z, fixed d);

/* Œꎲ](rotate)s܂B
 * [in]
 *	a		sB
 *	d		]pxB
 * [out]
 *	߂l		ʂ̍sB
 */
matrix mrotx(matrix a, fixed d);
matrix mroty(matrix a, fixed d);
matrix mrotz(matrix a, fixed d);

/* Œ񎲉](rotate)s܂B
 * [in]
 *	a		sB
 *	x,y,z		]pxB
 * [out]
 *	߂l		ʂ̍sB
 * [note]
 *	* O̉]pxw̌ʂ͋tłB
 *	  ŒO][note]QƂĂB
 */
matrix mrotxyx(matrix a, fixed x, fixed y, fixed z);
matrix mrotxzx(matrix a, fixed x, fixed y, fixed z);
matrix mrotyxy(matrix a, fixed x, fixed y, fixed z);
matrix mrotyzy(matrix a, fixed x, fixed y, fixed z);
matrix mrotzxz(matrix a, fixed x, fixed y, fixed z);
matrix mrotzyz(matrix a, fixed x, fixed y, fixed z);

/* ŒO](rotate)s܂B
 * [in]
 *	a		sB
 *	x,y,z		]pxB
 * [out]
 *	߂l		ʂ̍sB
 * [note]
 *	* s]ûŁAťʂɂȂ܂B
 *	  Ⴆ΁A
 *		mrotxyz(o, a, x, y, z)
 *	  ́A
 *		mrotz(o, a, z);
 *		mroty(o, o, y);
 *		mrotx(o, o, x);
 *	  ƓʂƂȂ܂B
 *	  ֐̖Oς̂m܂񂪁A
 *	  őɎgȂ̂ŁAƂ肠̂܂܂ɂĂ܂B
 */
matrix mrotxyz(matrix a, fixed x, fixed y, fixed z);
matrix mrotxzy(matrix a, fixed x, fixed y, fixed z);
matrix mrotyxz(matrix a, fixed x, fixed y, fixed z);
matrix mrotyzx(matrix a, fixed x, fixed y, fixed z);
matrix mrotzxy(matrix a, fixed x, fixed y, fixed z);
matrix mrotzyx(matrix a, fixed x, fixed y, fixed z);

/* ]̃xNgƁA]px߂܂B
 * [in]
 *	v		]̃xNgi[xNgB
 *	a		ׂsB
 * [out]
 *	߂l		]pxB
 *	*v		]̃xNgB
 */
fixed mrotget(vector* v, matrix a);

/* pϊ(orientate)s܂B
 * [in]
 *	a		sB
 *	dx,dy,dz	Z̎pxNgB
 *	ux,uy,uz	Y̎pxNgB
 * [out]
 *	߂l		ʂ̍sB
 * [note]
 *	* pxNǵAKĂȂĂ\܂B
 */
matrix morient(matrix a,
	fixed dx, fixed dy, fixed dz,
	fixed ux, fixed uy, fixed uz);

/* _ϊs܂B
 * [in]
 *	a		sB
 *	ex,ey,ez	_WB
 *	cx,cy,cz	_WB
 *	bank		oNpxB
 * [out]
 *	߂l		ʂ̍sB
 */
matrix mlookat(matrix a,
	fixed ex, fixed ey, fixed ez,
	fixed cx, fixed cy, fixed cz,
	fixed bank);

/* ϊ(frustum)s܂B
 * [in]
 *	a		sB
 *	width		eʂ̕              (Wn)
 *	height		eʂ̍            (Wn)
 *	front		tgNbsO(Wn)
 * [out]
 *	߂l		ʂ̍sB
 * [note]
 *	* Sȓϊł͂ȂAZW͎Ŵ܂ܕω܂B
 *	  ȂȂÃCuł͍s3x4ŕ\Ă̂ŁA
 *	  ZW̐Klϊs\ȂłB
 *	  Azobt@ł͂ȂAz\[gz肵Ă̂ŁA
 *	  p͂ȂƎv܂B
 *	* ̍sōWϊł́AX,YW͐K܂B
 *	  x=x/z,y=y/z sāAx,y(-1,1)ɓeKv܂B
 */
matrix mfrustum(matrix a, fixed width, fixed height, fixed front);

/* ϊ(perspective)s܂B
 * [in]
 *	a		sB
 *	fovy		pxB
 *	aspect		AXyNg()
 *	front		tgNbsO(Wn)
 * [out]
 *	߂l		ʂ̍sB
 * [note]
 *	* mfrustum()̃RgQƂĂB
 */
matrix mperspect(matrix a, fixed fovy, fixed aspect, fixed front);

/* r[|[gϊ(viewport)s܂B
 * [in]
 *	a		sB
 *	left,top	r[|[g_W(XN[Wn)
 *	width,height	r[|[gTCY  (XN[Wn)
 *			^͌Œ菬ł͂Ȃł邱Ƃ
 *			  ӂĂB
 * [out]
 *	߂l		ʂ̍sB
 * [note]
 *	* ϊ -> x=x/z,y=y/z -> r[|[gϊ
 *	  ̏œKpꍇ́Amviewport()gĂB
 *	* ϊ -> r[|[gϊ -> x=x/z,y=y/z
 *	  ̏œKpꍇ́Amviewportz()gĂB
 *	* mviewport()gWϊ̎菇́ÂƂłB
 *		1. T = fϊ * _ϊ * ϊ ɂWϊ
 *		2. ZNbsO
 *		3. x = x / z, y = y / z
 *		4. T = r[|[gϊ ɂWϊ
 *		5. XYNbsO
 *	* ɑ΂Amviewportz()gꍇ́A
 *		1. T = fϊ * _ϊ * ϊ * r[|[gϊ
 *	  	   ɂAWϊ
 *		2. ZNbsO
 *		3. x = x / z, y = y / z
 *		4. XYNbsO
 *	  ƂȂA菇炷Ƃł܂B
 */
matrix mviewport (matrix a, int left, int top, int width, int height);
matrix mviewportz(matrix a, int left, int top, int width, int height);

/* eϊs܂B
 * [in]
 *	a		sB
 *	Lx,Ly,Lz	xNg
 *	Gx,Gy,Gz	eʏ̈_(C)̍W
 *	Nx,Ny,Nz	eʂ̖@xNg
 * [out]
 *	߂l		ʂ̍sB
 */
matrix mshadow(matrix a,
	fixed Lx, fixed Ly, fixed Lz,
	fixed Gx, fixed Gy, fixed Gz,
	fixed Nx, fixed Ny, fixed Nz);

/*****************************************************************************
 *	ȑZ
 *****************************************************************************/

/* fixed */
#define   fchs_(a   )	do { (a) =   fchs((a)     ); } while(0)
#define  ffabs_(a   )	do { (a) =  ffabs((a)     ); } while(0)
#define  fceil_(a   )	do { (a) =  fceil((a)     ); } while(0) /* 2007/02/10ǉ */
#define ffloor_(a   )	do { (a) = ffloor((a)     ); } while(0) /* 2007/02/10ǉ */
#define   fadd_(a, b)	do { (a) =   fadd((a), (b)); } while(0)
#define  fiadd_(a, b)	do { (a) =  fiadd((a), (b)); } while(0)
#define   fsub_(a, b)	do { (a) =   fsub((a), (b)); } while(0)
#define  fisub_(a, b)	do { (a) =  fisub((a), (b)); } while(0)
#define  fsubr_(a, b)	do { (a) =  fsubr((a), (b)); } while(0)
#define fisubr_(a, b)	do { (a) = fisubr((a), (b)); } while(0)
#define   fmul_(a, b)	do { (a) =   fmul((a), (b)); } while(0)
#define  fimul_(a, b)	do { (a) =  fimul((a), (b)); } while(0)
#define   fdiv_(a, b)	do { (a) =   fdiv((a), (b)); } while(0)
#define  fidiv_(a, b)	do { (a) =  fidiv((a), (b)); } while(0)
#define  fdivr_(a, b)	do { (a) =  fdivr((a), (b)); } while(0)
#define fidivr_(a, b)	do { (a) = fidivr((a), (b)); } while(0)
#define  fprem_(a, b)	do { (a) =  fprem((a), (b)); } while(0) /* 2008/01/29ǉ */

/* vector */
#define    vchs_(a   )	do { (a) =    vchs((a)     ); } while(0)
#define    vadd_(a, b)	do { (a) =    vadd((a), (b)); } while(0)
#define    vsub_(a, b)	do { (a) =    vsub((a), (b)); } while(0)
#define    vmul_(a, b)	do { (a) =    vmul((a), (b)); } while(0)
#define   vfmul_(a, b)	do { (a) =   vfmul((a), (b)); } while(0)
#define   vimul_(a, b)	do { (a) =   vimul((a), (b)); } while(0)
#define    vdiv_(a, b)	do { (a) =    vdiv((a), (b)); } while(0)
#define   vfdiv_(a, b)	do { (a) =   vfdiv((a), (b)); } while(0)
#define   vidiv_(a, b)	do { (a) =   vidiv((a), (b)); } while(0)
#define vnormal_(a   )	do { (a) = vnormal((a)     ); } while(0)

/* matrix */
#define     mxpose_(a)						do { (a) =     mxpose((a)); } while(0)
#define       minv_(a)						do { (a) =       minv((a)); } while(0)
#define     minvno_(a)						do { (a) =     minvno((a)); } while(0)
#define     mxform_(a, b)					do { (a) =     mxform((a), (b)); } while(0)
#define     mxlate_(a, x, y, z)					do { (a) =     mxlate((a), (x), (y), (z)); } while(0)
#define     mscale_(a, x, y, z)					do { (a) =     mscale((a), (x), (y), (z)); } while(0)
#define    mfscale_(a, s)					do { (a) =    mfscale((a), (s)); } while(0)
#define       mrot_(a, x, y, z, d)				do { (a) =       mrot((a), (x), (y), (z), (d)); } while(0)
#define      mrotx_(a, d)					do { (a) =      mrotx((a), (d)); } while(0)
#define      mroty_(a, d)					do { (a) =      mroty((a), (d)); } while(0)
#define      mrotz_(a, d)					do { (a) =      mrotz((a), (d)); } while(0)
#define    mrotxyx_(a, x, y, z)					do { (a) =    mrotxyx((a), (x), (y), (z)); } while(0)
#define    mrotxzx_(a, x, y, z)					do { (a) =    mrotxzx((a), (x), (y), (z)); } while(0)
#define    mrotyxy_(a, x, y, z)					do { (a) =    mrotyxy((a), (x), (y), (z)); } while(0)
#define    mrotyzy_(a, x, y, z)					do { (a) =    mrotyzy((a), (x), (y), (z)); } while(0)
#define    mrotzxz_(a, x, y, z)					do { (a) =    mrotzxz((a), (x), (y), (z)); } while(0)
#define    mrotzyz_(a, x, y, z)					do { (a) =    mrotzyz((a), (x), (y), (z)); } while(0)
#define    mrotxyz_(a, x, y, z)					do { (a) =    mrotxyz((a), (x), (y), (z)); } while(0)
#define    mrotxzy_(a, x, y, z)					do { (a) =    mrotxzy((a), (x), (y), (z)); } while(0)
#define    mrotyxz_(a, x, y, z)					do { (a) =    mrotyxz((a), (x), (y), (z)); } while(0)
#define    mrotyzx_(a, x, y, z)					do { (a) =    mrotyzx((a), (x), (y), (z)); } while(0)
#define    mrotzxy_(a, x, y, z)					do { (a) =    mrotzxy((a), (x), (y), (z)); } while(0)
#define    mrotzyx_(a, x, y, z)					do { (a) =    mrotzyx((a), (x), (y), (z)); } while(0)
#define    morient_(a, dx, dy, dz, ux, uy, uz)			do { (a) =    morient((a), (dx), (dy), (dz), (ux), (uy), (uz)); } while(0)
#define    mlookat_(a, ex, ey, ez, cx, cy, cz, bank)		do { (a) =    mlookat((a), (ex), (ey), (ez), (cx), (cy), (cz), (bank)); } while(0)
#define   mfrustum_(a, width, height, front)			do { (a) =   mfrustum((a), (width), (height), (front)); } while(0)
#define  mperspect_(a, fovy, aspect, front)			do { (a) =  mperspect((a), (fovy), (aspect), (front)); } while(0)
#define  mviewport_(a, left, top, width, height)		do { (a) =  mviewport((a), (left), (top), (width), (height)); } while(0)
#define mviewportz_(a, left, top, width, height)		do { (a) = mviewportz((a), (left), (top), (width), (height)); } while(0)
#define    mshadow_(a, Lx, Ly, Lz, Gx, Gy, Gz, Nx, Ny, Nz)	do { (a) =    mshadow((a), (Lx), (Ly), (Lz), (Gx), (Gy), (Gz), (Nx), (Ny), (Nz)); } while(0)

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_FIX_H__*/
