/*	
 *	clipcp8i.h
 *
 *	P/ECE CHIP-8 Interpreter
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Mar 18 21:17:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_CP8I_H__
#define __CLIP_CP8I_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/*
 *	CHIP-8RAp̃}N`܂B
 *	}NPāȂ̃}NƏՓ˂鋰ꂪ̂ŁA
 *	CHIP-8RA\[Xt@Ĉ݃CN[hĂB
 */

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	CHIP8\̃oANZX̊ȗ\L
 */
/*===== WX^ =====*/
#define V(x)		(chip8->v[x])
#define V0		(V(0x0))
#define V1		(V(0x1))
#define V2		(V(0x2))
#define V3		(V(0x3))
#define V4		(V(0x4))
#define V5		(V(0x5))
#define V6		(V(0x6))
#define V7		(V(0x7))
#define V8		(V(0x8))
#define V9		(V(0x9))
#define VA		(V(0xa))
#define VB		(V(0xb))
#define VC		(V(0xc))
#define VD		(V(0xd))
#define VE		(V(0xe))
#define VF		(V(0xf))
#define I		(chip8->i)
#define DT		(chip8->dt)
#define ST		(chip8->st)
/*=====  =====*/
#define STAT		(chip8->stat)
#define S		(chip8->s)
#define P		(chip8->p)
#define KEY		(chip8->key)
#define SEED		(chip8->seed)
#define STACK(x)	(chip8->stack[(x)])
/*=====  =====*/
#define MEM(nnn)	(chip8->mem[(nnn)&CHIP8_MEM_MASK])
#define SCR		(chip8->scr)
#define SCRLO(x,y)	(SCR[(y)&CHIP8_SCRLO_Y_MASK][(x)&CHIP8_SCRLO_X_MASK])
#define SCRHI(x,y)	(SCR[(y)&CHIP8_SCRHI_Y_MASK][(x)&CHIP8_SCRHI_X_MASK])

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	CXgNVtFb`
 *
 *	* CHIP-8̖߂16bitŒ蒷ŁABigEndianŊi[Ă܂B
 */
#define FETCH()		do {			\
	CHIP8TRACE("%03x: ", P);		\
	code  = MEM(P) << 8 | MEM(P + 1);	\
	P += 2;					\
	CHIP8TRACE("%04x ", code);		\
} while(0)

/*
 *	CXgNV֐Ăяo
 */
#define EXEC(FN)	do {					\
	CHIP8TRACE("[%s]", chip8_op_name_table[CHIP8OP_##FN]);	\
	chip8op_##FN(chip8, code);				\
	CHIP8TRACE("\n");					\
	goto L_NEXT;						\
} while(0)

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_CP8I_H__*/
