/*
 *	argz.h
 *
 *	Argz Functions - Operations on argz vectors.
 *
 *	* Thu Oct 22 21:13:48 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- uArgz Functionsv(http://www.gnu.org/software/libc/manual/html_node/Argz-Functions.html)݊W[łB
 *	  ֐dĺuArgz FunctionsvƓŁA͓ƎłB
 *	  IWił́uArgz Functionsv͑xdĂ╡GłA͒PɎ܂B
 *	- ֐dlg̐́AL̃hLg̑Aȉ̃hLgQlɂȂ܂B
 *	  uLinux Programmer's Manual - ARGZ_ADDv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/argz_add.3.html)
 *	  AuLinux Programmer's Manual - ARGZ_ADDv́Aargz_append()̐ɊԈႢL悤łB
 *	  ڍׂ́Aargz_append()̎̃RgQƂĉB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __ARGZ_H__
#define __ARGZ_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/*****************************************************************************
 *	
 *****************************************************************************/
typedef int error_t;
/*---------------------------------------------------------------------------*/
error_t argz_create(char* argv[], char** argz, size_t* argz_len);
error_t argz_create_sep(const char* str, int sep, char** argz, size_t* argz_len);
size_t argz_count(const char* argz, size_t argz_len);
void argz_extract(const char* argz, size_t argz_len, char** argv);
void argz_stringify(char* argz, size_t argz_len, int sep);
error_t argz_append(char** argz, size_t* argz_len, const char* buf, size_t buf_len);
error_t argz_add(char** argz, size_t* argz_len, const char* str);
error_t argz_add_sep(char** argz, size_t* argz_len, const char* str, int sep);
void argz_delete(char** argz, size_t* argz_len, char* entry);
error_t argz_insert(char** argz, size_t* argz_len, char* before, const char* entry);
char* argz_next(const char* argz, size_t argz_len, const char* entry);
error_t argz_replace(char** argz, size_t* argz_len, const char* str, const char* with, unsigned* replace_count);
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__ARGZ_H__
