//
//	ToolLib_Window.c
//
//	GfB^[ʏ - c[GUĨEChE
//
//	* Tue Apr 18 21:46:46 JST 2017 Naoyuki Sawa
//	- 1st [XB
//	* Wed Apr 19 22:11:14 JST 2017 Naoyuki Sawa
//	- u@DxLibɈˑȂ悤ɂvƁuACŃRpCo悤ɂvΉ܂B
//	  ڍׂ́A/clip/ToolLib/README.TXT ́ÃRgQƂĉB
//	* Thu Apr 20 21:31:57 JST 2017 Naoyuki Sawa
//	- CuIuWFNg̎ʎqAnh˃|C^ɕύX܂B
//	  IWiłł͐IuWFNgŒ蒷zɊi[ĊǗĂ̂łAߖ̂߂ɃXgŊǗ悤ɕύXÂ߂ɂ͐nh|C^̕sǂłB
//	  AtHgnhƕ̓nh́ACuIuWFNgł͂ȂobNGh̃IuWFNgȂ̂ŁA̕ύXɂ͊֌Wnĥ܂܂łB
//	* Fri Apr 21 22:01:07 JST 2017 Naoyuki Sawa
//	- ToolWindow_Create()ɂāAOݒ肳ĂꍇAO\̃Xy[Xǉ悤ɏC܂B
//	  IWiłł́AOݒ肳ĂȂĂO\̃Xy[XǉĂA㕔ɗ]ȃXy[XJ肪L܂B
//	- ToolWindow_Draw()ɂāAc̃XN[o[`悷ꍇ́AO\EChE㕔̕܂ōL悤ɕύX܂B
//	  IWiłł́Ac̃XN[o[̗LɊ֌WAO\EChE㕔͏\̈̕܂łhׂĂ炸Ac̃XN[o[̏㕔ɕsRȋ󔒂Ă܂B
//	- ToolWindow_Draw()ɂāAEChE̘gAO\EChE㕔܂߂Ĉ͂ނ悤ɕύX܂B
//	  IWiłł́Ac̃XN[o[͊܂߂Ĉ͂ނ̂ɁAO\EChE㕔͊܂߂Ĉ͂܂ȂƂsRL܂B
//	* Tue May 02 22:54:46 JST 2017 Naoyuki Sawa
//	- eW[̃TCY`̔{ꗥŒo悤ɁAToolLib.hTOOL_SCALE̒`ǉ܂B
//	  ڍׂ́AToolLib.h̓̃RgQƂĉB
//	* Sun May 14 23:23:22 JST 2017 Naoyuki Sawa
//	- ToolWindow_IsAnyHovered(),ToolWindow_IsHovered()֐ǉ܂B
//	  ڍׂ́AToolLib.h̓̃RgQƂĉB
//
#include "clip.h"
//*****************************************************************************
//	萔A}NA\
//*****************************************************************************
#define TOOL_WINDOW_NAME_HEIGHT		(TOOL_SCALE*(16))	//c[̃EChE̖O\̍B
#define TOOL_WINDOW_SCROLLBAR_WIDTH	(TOOL_SCALE*(16))	//c[̃EChẼXN[o[̕B
#define TOOL_SCROLLBAR_BUTTON_SIZE	(TOOL_SCALE*(8))	//XN[o[p̃{^̃TCYB
#define TOOL_SCROLLBAR_THUMB_SIZE	(TOOL_SCALE*(8))	//XN[o[̂܂݂̃TCYB
#define TOOL_SCROLLBAR_SPEED		(TOOL_SCALE*(180))	//XN[o[{^đ삷ꍇ̈ړxB
#define TOOL_DRAWAREA_BASERIGHT_SPACE	(TOOL_SCALE*(20))	//TCYύX\ȕ\̈gpꍇ̕\̈E[󂯂Xy[X̃TCYB
//-----------------------------------------------------------------------------
//EChE\
/*typedef*/ struct _SToolWindow {
	SToolSpaceManage*	TSpaceManage;							//Xy[XǗB
	SToolVisible*		TVisible;							//\ԏB
	char*			Name;								//{^̖O̕񂪊i[Ă郁AhXۑĂ|C^B
	RECT			InfoArea;							//EChȄ\̈B
	SIZE			ClientSize;							//EChẼNCAg̈̃TCYB
	int			DrawLeftUpX, DrawLeftUpY;					//EChẼNCAg̈̓e`悷ۂ̊_ƂȂ鍶WB(XN[o[ɂEChE̕\ʒuύX鏈Ɏgp)
	int			HScroll, VScroll;						//\ʒu肷XN[WB
	int			HScrollGrips, VScrollGrips;					//XN[o[͂ł邩ǂB
	int			Visible;							//\ԁB
	double			LastButtonBottomTime;						//ŌɃ{^XN[ԁB(P:b)
	int			UpButBottom, DownButBottom, LeftButBottom, RightButBottom;	//ꂼ㉺EXN[{^ꂽԂǂB(0ȊO:Ă,0:ĂȂ)
	int			UpButIn, DownButIn, LeftButIn, RightButIn;			//ꂼ㉺EXN[{^̋`Ƀ}EXJ[\邩ǂB
	SToolSpace		NameSpace;							//O\̃Xy[XB
	SToolSpace		InfoSpace;							//\̃Xy[XB
	SToolSpace		HScrollBarSpace;						//XN[o[̃Xy[XB
} /*SToolWindow*/;
//*****************************************************************************
//	[Jϐ
//*****************************************************************************
static GSList*	g_TWindow;
//*****************************************************************************
//	[J֐錾
//*****************************************************************************
static void ToolWindow_UpdateInfoArea(SToolWindow* TWindow);
static void ToolWindow_Step(SToolWindow* TWindow, double StepTime);
static void ToolWindow_Draw(SToolWindow* TWindow);
//*****************************************************************************
//	AvP[Vp֐
//*****************************************************************************
//EChE쐬B
//[in]
//	TSpaceManage		Xy[XǗB(Kv̂ȂꍇNULLn)
//	SpaceLast		c̃Xy[XSĎgp邩ǂB(0ȊOnƑSĎgp)	(TSpaceManageNULLȊȌꍇ̂ݗL)
//	LockSpace		Œ^CṽXy[XǂB						(TSpaceManageNULLȊȌꍇ̂ݗL)
//	HScrollSpace		XN[o[p̃Xy[Xmۂ邩ǂB			(TSpaceManageNULLȊȌꍇ̂ݗL)
//	Name			EChE̖OB
//	DrawX			EChE̍[XWB
//	DrawY			EChȄ[YWB							(TSpaceManageNULL̏ꍇ̂ݗL)
//	DrawW			EChE̕B							(TSpaceManageNULL̏ꍇ̂ݗL)
//	DrawH			EChE̍B							(TSpaceManageNULL̏ꍇ̂ݗL)
//	ClientW			EChẼNCAg̈̕B
//	ClientH			EChẼNCAg̈̍B
//[out]
//	߂l			EChEB
SToolWindow* ToolWindow_Create(SToolSpaceManage* TSpaceManage, int SpaceLast, int LockSpace, int HScrollSpace, const char* Name, int DrawX, int DrawY, int DrawW, int DrawH, int ClientW, int ClientH) {
	SToolWindow* TWindow;
	//VEChEi[邽߂̃̊mہB
	TWindow = calloc(1, sizeof(SToolWindow));
	if(!TWindow) { DIE(); }
	//mۂ̈ۑB
	g_TWindow = g_slist_append(g_TWindow, TWindow);
	//Xy[XǗۑB
	TWindow->TSpaceManage = TSpaceManage;
	//Xy[XǗ񂪗Lȏꍇ̓EChẼXy[XǉB
	if(TSpaceManage) {
		//Oݒ肳Ăꍇ͖O\̃Xy[XǉB
		if(Name) {
			ToolSpaceManage_AddSpace(TSpaceManage,
			                         &TWindow->NameSpace,
			                         TOOL_WINDOW_NAME_HEIGHT,
			                         1);
		}
		//\̈̃Xy[XǉB
		ToolSpaceManage_AddSpace(TSpaceManage,
		                         &TWindow->InfoSpace,
		                         SpaceLast ? (ToolSpaceManage_GetTotalSpace(TSpaceManage) - ToolSpaceManage_GetNextSpace(TSpaceManage) - TOOL_WINDOW_SCROLLBAR_WIDTH) : DrawH,
		                         LockSpace);
		//XN[o[p̃Xy[Xmۂw肪ꍇ͐XN[o[p̃Xy[XǉB
		if(HScrollSpace) {
			ToolSpaceManage_AddSpace(TSpaceManage,
			                         &TWindow->HScrollBarSpace,
			                         TOOL_WINDOW_SCROLLBAR_WIDTH,
			                         1);
		}
	}
	//B
//sv	TWindow->TVisible        = NULL;
	TWindow->InfoArea.left   = DrawX;
	TWindow->InfoArea.right  = DrawX + DrawW;
	if(TWindow->TSpaceManage) {
		TWindow->InfoArea.top = TWindow->InfoSpace.SpaceStart;
	} else {
		TWindow->InfoArea.top = DrawY;
	}
	TWindow->InfoArea.bottom = TWindow->InfoArea.top + DrawH;
	TWindow->ClientSize.cx   = ClientW;
	TWindow->ClientSize.cy   = ClientH;
	ToolWindow_SetName(TWindow, Name);
	TWindow->DrawLeftUpX     = 0;
	TWindow->DrawLeftUpY     = 0;
	TWindow->HScroll         = 0;
	TWindow->VScroll         = 0;
	TWindow->Visible         = 1;
	//EChEԂB
	return TWindow;
}
//-----------------------------------------------------------------------------
//EChE폜B
//[in]
//	TWindow			EChEB
void ToolWindow_Delete(SToolWindow* TWindow) {
	//OۑpɃmۂĂꍇ͉B
	free(TWindow->Name);
	//mۂĂB
	g_TWindow = g_slist_remove(g_TWindow, TWindow);
	free(TWindow);
}
//-----------------------------------------------------------------------------
//SẴEChE폜B
void ToolWindow_Delete_All() {
	//LȑSẴEChE폜B
	while(g_TWindow) { ToolWindow_Delete(g_TWindow->data); }
}
//-----------------------------------------------------------------------------
//EChEɊ֘At\ԏZbgB
//[in]
//	TWindow			EChEB
//	TVisible		\ԏB
void ToolWindow_SetVisibleHandle(SToolWindow* TWindow, SToolVisible* TVisible) {
	TWindow->TVisible = TVisible;
}
//-----------------------------------------------------------------------------
//EChESetDrawAreaŕ`̈𐧌ݒsB
//[in]
//	TWindow			EChEB
void ToolWindow_SetupDrawArea(SToolWindow* TWindow) {
	//Xy[X񂪕ύXĂ\̂ŏ\̈̍XVB
	ToolWindow_UpdateInfoArea(TWindow);
	//SetDrawAreagpĎۂɕ`̈̐ݒsB
	ToolFunc_SetDrawArea(TWindow->InfoArea.left,
	                     TWindow->InfoArea.top,
	                     TWindow->InfoArea.right,
	                     TWindow->InfoArea.bottom);
}
//-----------------------------------------------------------------------------
//EChȄ\̈擾B
//[in]
//	TWindow			EChEB
//[out]
//	߂l			`̈̋`B
RECT ToolWindow_GetInfoArea(SToolWindow* TWindow) {
	//Xy[X񂪕ύXĂ\̂ŏ\̈̍XVB
	ToolWindow_UpdateInfoArea(TWindow);
	return TWindow->InfoArea;
}
//-----------------------------------------------------------------------------
//EChẼXN[o[̏ԂlNCAg̈̕`挴_ƂȂXN[W擾B
//[in]
//	TWindow			EChEB
//	x,y			Wϐ̃AhXB(NULL)
void ToolWindow_GetDrawLeftUpPos(SToolWindow* TWindow, int* x, int* y) {
	//Xy[X񂪕ύXĂ\̂ŏ\̈̍XVB
	ToolWindow_UpdateInfoArea(TWindow);
	if(x) { *x = -TWindow->DrawLeftUpX + TWindow->InfoArea.left; }
	if(y) { *y = -TWindow->DrawLeftUpY + TWindow->InfoArea.top;  }
}
//-----------------------------------------------------------------------------
//EChẼXN[o[̏ԂlNCAg̈̕`挴_ƂȂW擾B
//[in]
//	TWindow			EChEB
//	x,y			Wϐ̃AhXB(NULL)
void ToolWindow_GetClientArea(SToolWindow* TWindow, int* x, int* y) {
	//Xy[X񂪕ύXĂ\̂ŏ\̈̍XVB
	ToolWindow_UpdateInfoArea(TWindow);
	if(x) { *x = TWindow->DrawLeftUpX; }
	if(y) { *y = TWindow->DrawLeftUpY; }
}
//-----------------------------------------------------------------------------
//EChẼNCAg̈̃TCYݒ肷B
//[in]
//	TWindow			EChEB
//	w,h			VNCAg̈̃TCYB
void ToolWindow_SetClientSize(SToolWindow* TWindow, int w, int h) {
	int InfoAreaW, InfoAreaH;
	int ScrollW, ScrollH;
	//Xy[X񂪕ύXĂ\̂ŏ\̈̍XVB
	ToolWindow_UpdateInfoArea(TWindow);
	//݂̃NCAg̈̃TCYƓꍇ͉ɏIB
	if((TWindow->ClientSize.cx == w) && (TWindow->ClientSize.cy == h)) { return; }	//܂
	//VNCAg̈̃TCYۑB
	TWindow->ClientSize.cx = w;
	TWindow->ClientSize.cy = h;
	//\̈̕ƍZoB
	InfoAreaW = TWindow->InfoArea.right - TWindow->InfoArea.left;
	InfoAreaH = TWindow->InfoArea.bottom - TWindow->InfoArea.top;
	//XN[o[̐ړ͈͂Ɛړ͈͂ZoB
	ScrollW = InfoAreaW - (TOOL_SCROLLBAR_THUMB_SIZE + (TOOL_SCROLLBAR_BUTTON_SIZE * 2));
	ScrollH = InfoAreaH - (TOOL_SCROLLBAR_THUMB_SIZE + (TOOL_SCROLLBAR_BUTTON_SIZE * 2));
	//VNCAg̈̃TCY\̈苷ꍇ̓XN[o[̈ʒu𒲐߁B
	if(InfoAreaW < TWindow->ClientSize.cx) {
		if((TWindow->DrawLeftUpX + InfoAreaW) > TWindow->ClientSize.cx) { TWindow->DrawLeftUpX = TWindow->ClientSize.cx - InfoAreaW; }
		TWindow->HScroll = TWindow->DrawLeftUpX * ScrollW / (TWindow->ClientSize.cx - InfoAreaW);
	} else {
		TWindow->DrawLeftUpX = 0;
		TWindow->HScroll     = 0;
	}
	if(InfoAreaH < TWindow->ClientSize.cy) {
		if((TWindow->DrawLeftUpY + InfoAreaH) > TWindow->ClientSize.cy) { TWindow->DrawLeftUpY = TWindow->ClientSize.cy - InfoAreaH; }
		TWindow->VScroll = TWindow->DrawLeftUpY * ScrollH / (TWindow->ClientSize.cy - InfoAreaH);
	} else {
		TWindow->DrawLeftUpY = 0;
		TWindow->VScroll     = 0;
	}
}
//-----------------------------------------------------------------------------
//EChE̖Oݒ肷B
//[in]
//	TWindow			EChEB
//	Name			OƂȂ镶̃AhXB
void ToolWindow_SetName(SToolWindow* TWindow, const char* Name) {
	//ɖOpɃmۂĂꍇ͉B
	free(TWindow->Name);
	TWindow->Name = NULL;
	//ÕAhXLȏꍇ̓mۂĕۑB
	if(Name) {
		TWindow->Name = strdup(Name);
		if(!TWindow->Name) { DIE(); }
	}
}
//-----------------------------------------------------------------------------
//EChE̕\ԂύXB
//[in]
//	TWindow			EChEB
//	Visible			V\ԁB
void ToolWindow_SetVisible(SToolWindow* TWindow, int Visible) {
	//V\ԂۑB
	TWindow->Visible = Visible;
}
//-----------------------------------------------------------------------------
//EChE̕\Ԃ擾B
//[in]
//	TWindow			EChEB(NULLBNULLw肳ꂽɁu0ȊO:\vԂ)
//[out]
//	߂l			\ԁB(0ȊO:\,0:\)
int ToolWindow_GetVisible(SToolWindow* TWindow) {
	//EChE񂪗LȂ΁c
	if(TWindow) {
		//\Ԃ0̏ꍇ0ԂB
		if(!TWindow->Visible) { return 0; }
		//\ԏ񂪓o^ĂāA\ԏ̕\Ԃ0̏ꍇ0ԂB
		if(!ToolVisible_GetVisible(TWindow->TVisible)) { return 0; }
	}
	//ɂĂ\ł͂ȂƂƂȂ̂0ȊOԂB
	return 1;
}
//-----------------------------------------------------------------------------
//w̍WEChȄ\̈ɓĂ邩ǂ𒲂ׂB
//[in]
//	TWindow			EChEB
//	x,y			EChE̕`̈ɓĂ邩ǂׂWB
//[out]
//	߂l			w̍WEChE̕`̈ɓĂ邩ǂB(0ȊO:Ă,0:ĂȂ)
int ToolWindow_CheckInfoAreaIn(SToolWindow* TWindow, int x, int y) {
	return ((TWindow->InfoArea.left <= x) && (TWindow->InfoArea.right  >= x)) &&
	       ((TWindow->InfoArea.top  <= y) && (TWindow->InfoArea.bottom >= y));
}
//-----------------------------------------------------------------------------
//SẴEChȄԐڏsB
//[in]
//	StepTime		i߂鎞ԁB(P:b)
void ToolWindow_Step_All(double StepTime) {
	GSList* list = g_TWindow;
	while(list) {
		ToolWindow_Step(list->data, StepTime);
		list = list->next;
	}
}
//-----------------------------------------------------------------------------
//SẴEChE̕`ڏsB
void ToolWindow_Draw_All() {
	GSList* list = g_TWindow;
	while(list) {
		ToolWindow_Draw(list->data);
		list = list->next;
	}
}
//-----------------------------------------------------------------------------
//}EXJ[\ꂩ̃EChE̓ɂ邩ǂ`FbNB
//[out]
//	߂l			ꂩ̃EChE̓Ƀ}EXJ[\邩ǂB(0ȊO:ɂ,0:Oɂ)
int ToolWindow_IsAnyHovered() {
	GSList* list = g_TWindow;
	while(list) {
		if(ToolWindow_IsHovered(list->data)) { return 1; }
		list = list->next;
	}
	return 0;
}
//-----------------------------------------------------------------------------
//}EXJ[\EChE̓ɂ邩ǂ`FbNB
//[in]
//	TWindow			EChEB
//[out]
//	߂l			EChE̓Ƀ}EXJ[\邩ǂB(0ȊO:ɂ,0:Oɂ)
int ToolWindow_IsHovered(SToolWindow* TWindow) {
	int x1, y1, x2, y2;
	//\Ԃ0̏ꍇ͉IB
	if(!ToolWindow_GetVisible(TWindow)) { return 0; }	//܂
	//Xy[X񂪕ύXĂ\̂ŏ\̈̍XVB
	ToolWindow_UpdateInfoArea(TWindow);
	//EChE̋`擾B
	x1 = TWindow->InfoArea.left;
	y1 = TWindow->InfoArea.top;
	x2 = TWindow->InfoArea.right;
	y2 = TWindow->InfoArea.bottom;
	//NCAg̈̕\̈傫΁AXN[o[̕AEChE̍LB
	if((TWindow->InfoArea.right - TWindow->InfoArea.left) < TWindow->ClientSize.cx) { y2 += TOOL_WINDOW_SCROLLBAR_WIDTH; }
	//NCAg̈̍\̈傫΁AcXN[o[̕AEChE̕LB
	if((TWindow->InfoArea.bottom - TWindow->InfoArea.top) < TWindow->ClientSize.cy) { x2 += TOOL_WINDOW_SCROLLBAR_WIDTH; }
	//Oݒ肳Ăꍇ́A^Cgo[̕AEChE̍LB
	if(TWindow->Name) { y1 -= TOOL_WINDOW_NAME_HEIGHT; }
	//}EXJ[\EChE̋`̓ɂ邩ǂ`FbNB
	return ToolStatic_CheckMouseIn(x1, y1, x2, y2);
}
//*****************************************************************************
//	[J֐
//*****************************************************************************
//Xy[XgpĂꍇɃXy[XɊÂ\̈̍XVsB
//[in]
//	TWindow			EChEB
static void ToolWindow_UpdateInfoArea(SToolWindow* TWindow) {
	//Xy[XǗ񂪖ȏꍇ͉ȂB
	if(!TWindow->TSpaceManage) { return; }	//܂
	//\̈Xy[XɊÂĎZoB
	TWindow->InfoArea.right  = Tool_GetBaseRightX() - TOOL_DRAWAREA_BASERIGHT_SPACE;
	TWindow->InfoArea.top    = TWindow->InfoSpace.SpaceStart;
	TWindow->InfoArea.bottom = TWindow->InfoArea.top + TWindow->InfoSpace.UseSpace;
}
//-----------------------------------------------------------------------------
//EChȄԐڏsB
//[in]
//	TWindow			EChEB
//	StepTime		i߂鎞ԁB(P:b)
static void ToolWindow_Step(SToolWindow* TWindow, double StepTime) {
	int MouseX, MouseY;
	int MouseMoveX, MouseMoveY;
	int MouseInput, MouseEdgeInput;
	int InfoAreaW, InfoAreaH;
	int SizeOverX, SizeOverY;
	int ScrollW, ScrollH;
	double DeltaTime;
	int ScrollSize;
	//\Ԃ0̏ꍇ͉IB
	if(!ToolWindow_GetVisible(TWindow)) { return; }	//܂
	//Xy[X񂪕ύXĂ\̂ŏ\̈̍XVB
	ToolWindow_UpdateInfoArea(TWindow);
	//}EXJ[\̈ʒu擾B
	ToolStatic_GetMousePosition(&MouseX, &MouseY);
	//}EXJ[\̈ړʂ擾B
	ToolStatic_GetMouseMoveVecter(&MouseMoveX, &MouseMoveY);
	//}EX̓͏Ԃ擾B
	MouseInput     = ToolStatic_GetMouseButton();
	MouseEdgeInput = ToolStatic_GetMouseEdgeButton();
	//\̈̕ƍZoB
	InfoAreaW = TWindow->InfoArea.right - TWindow->InfoArea.left;
	InfoAreaH = TWindow->InfoArea.bottom - TWindow->InfoArea.top;
	//NCAg̈̃TCY\̈̃TCY傫ǂ𒲂ׂĂB
	SizeOverX = InfoAreaW < TWindow->ClientSize.cx;
	SizeOverY = InfoAreaH < TWindow->ClientSize.cy;
	//XN[o[̐ړ͈͂Ɛړ͈͂ZoB
	ScrollW = InfoAreaW - (TOOL_SCROLLBAR_THUMB_SIZE + (TOOL_SCROLLBAR_BUTTON_SIZE * 2));
	ScrollH = InfoAreaH - (TOOL_SCROLLBAR_THUMB_SIZE + (TOOL_SCROLLBAR_BUTTON_SIZE * 2));
	//XN[o[̏㉺E{^̕\̈̒ɃJ[\邩ǂ𒲂ׂB
	TWindow->UpButIn    = SizeOverY && ToolStatic_CheckMouseIn(TWindow->InfoArea.right,
	                                                           TWindow->InfoArea.top,
	                                                           TWindow->InfoArea.right  + TOOL_WINDOW_SCROLLBAR_WIDTH,
	                                                           TWindow->InfoArea.top    + TOOL_SCROLLBAR_BUTTON_SIZE);
	TWindow->DownButIn  = SizeOverY && ToolStatic_CheckMouseIn(TWindow->InfoArea.right,
	                                                           TWindow->InfoArea.bottom - TOOL_SCROLLBAR_BUTTON_SIZE,
	                                                           TWindow->InfoArea.right  + TOOL_WINDOW_SCROLLBAR_WIDTH,
	                                                           TWindow->InfoArea.bottom);
	TWindow->LeftButIn  = SizeOverX && ToolStatic_CheckMouseIn(TWindow->InfoArea.left,
	                                                           TWindow->InfoArea.bottom,
	                                                           TWindow->InfoArea.left   + TOOL_SCROLLBAR_BUTTON_SIZE,
	                                                           TWindow->InfoArea.bottom + TOOL_WINDOW_SCROLLBAR_WIDTH);
	TWindow->RightButIn = SizeOverX && ToolStatic_CheckMouseIn(TWindow->InfoArea.right  - TOOL_SCROLLBAR_BUTTON_SIZE,
	                                                           TWindow->InfoArea.bottom,
	                                                           TWindow->InfoArea.right,
	                                                           TWindow->InfoArea.bottom + TOOL_WINDOW_SCROLLBAR_WIDTH);
	//OԐڏsĂ̌oߎԂZoB
	DeltaTime = ToolStatic_GetNowTime() - TWindow->LastButtonBottomTime;
	//݂̎ԂۑĂB
	TWindow->LastButtonBottomTime = ToolStatic_GetNowTime();
	//oߎԂXN[o[ړꍇ̈ړʂZoB
	ScrollSize = DeltaTime * TOOL_SCROLLBAR_SPEED;
	if(!ScrollSize) { ScrollSize = TOOL_SCROLLBAR_SPEED / 60; }
	//}EX̍{^ĂȂꍇ̓XN[֌W̃tOSďďIB
	if(!(MouseInput & (1<<0)/*MOUSE_INPUT_LEFT*/)) {
		TWindow->HScrollGrips   = 0;
		TWindow->VScrollGrips   = 0;
		TWindow->RightButBottom = 0;
		TWindow->LeftButBottom  = 0;
		TWindow->UpButBottom    = 0;
		TWindow->DownButBottom  = 0;
		return;	//܂
	}
	//NCAg̈̉\̈̉傫ꍇ͉̃XN[o[̏sB
	if(SizeOverX) {
		//{^ꂽuԂŁAXN[{^̕\̈Ƀ}EXJ[\ꍇ̓XN[{^Ă邩ǂ̃tO𗧂ĂB
		if(MouseEdgeInput & (1<<0)/*MOUSE_INPUT_LEFT*/) {
			if(TWindow->LeftButIn ) { TWindow->LeftButBottom  = 1; }
			if(TWindow->RightButIn) { TWindow->RightButBottom = 1; }
		}
		//XN[{^Ăꍇ̓XN[ʒuړB
		if(TWindow->LeftButIn || TWindow->RightButIn) {
			if(TWindow->LeftButBottom) {
				TWindow->DrawLeftUpX -= ScrollSize;
				if(TWindow->DrawLeftUpX < 0) { TWindow->DrawLeftUpX = 0; }
				TWindow->HScroll = TWindow->DrawLeftUpX * ScrollW / (TWindow->ClientSize.cx - InfoAreaW);
			} else if(TWindow->RightButBottom) {
				TWindow->DrawLeftUpX += ScrollSize;
				if(TWindow->DrawLeftUpX > (TWindow->ClientSize.cx - InfoAreaW)) { TWindow->DrawLeftUpX = TWindow->ClientSize.cx - InfoAreaW; }
				TWindow->HScroll = TWindow->DrawLeftUpX * ScrollW / (TWindow->ClientSize.cx - InfoAreaW);
			}
		//XN[o[̂܂݂͂łꍇ̓}EXJ[\̈ړʂɂ킹ăXN[ʒuړB
		} else if(TWindow->HScrollGrips) {
			TWindow->HScroll += MouseMoveX;
			if(TWindow->HScroll <       0) { TWindow->HScroll =       0; }
			if(TWindow->HScroll > ScrollW) { TWindow->HScroll = ScrollW; }
			TWindow->DrawLeftUpX = TWindow->HScroll * (TWindow->ClientSize.cx - InfoAreaW) / ScrollW;
		//XN[o[̗̈ɃJ[\A{^ꂽuԂ̏ꍇ̓XN[o[֌W̏B
		} else if((MouseEdgeInput & (1<<0)/*MOUSE_INPUT_LEFT*/) &&
			  (ToolStatic_CheckMouseIn(TWindow->InfoArea.left   + TOOL_SCROLLBAR_BUTTON_SIZE,
			                           TWindow->InfoArea.bottom,
			                           TWindow->InfoArea.right  - TOOL_SCROLLBAR_BUTTON_SIZE,
			                           TWindow->InfoArea.bottom + TOOL_WINDOW_SCROLLBAR_WIDTH))) {
			//J[\̊ONbNꍇ1ʕړB
			if(MouseX < (TWindow->InfoArea.left + TOOL_SCROLLBAR_BUTTON_SIZE + TWindow->HScroll)) {
				TWindow->HScroll -= InfoAreaW * ScrollW / TWindow->ClientSize.cx;
				if(TWindow->HScroll < 0) { TWindow->HScroll = 0; }
			} else if(MouseX > (TWindow->InfoArea.left + TOOL_SCROLLBAR_BUTTON_SIZE + TWindow->HScroll + TOOL_SCROLLBAR_THUMB_SIZE)) {
				TWindow->HScroll += InfoAreaW * ScrollW / TWindow->ClientSize.cx;
				if(TWindow->HScroll > ScrollW) { TWindow->HScroll = ScrollW; }
			//܂݂NbNꍇ͂܂ݒ͂ݏԂɂB
			} else {
				TWindow->HScrollGrips = 1;
			}
			//XN[ʒuXN[ʒul`_ʒuZoB
			TWindow->DrawLeftUpX = TWindow->HScroll * (TWindow->ClientSize.cx - InfoAreaW) / ScrollW;
		}
	}
	//NCAg̈̏c\̈̏c傫ꍇ͏c̃XN[o[̏sB
	if(SizeOverY) {
		//{^ꂽuԂŁAXN[{^̕\̈Ƀ}EXJ[\ꍇ̓XN[{^Ă邩ǂ̃tO𗧂ĂB
		if(MouseEdgeInput & (1<<0)/*MOUSE_INPUT_LEFT*/) {
			if(TWindow->UpButIn  ) { TWindow->UpButBottom   = 1; }
			if(TWindow->DownButIn) { TWindow->DownButBottom = 1; }
		}
		//XN[{^Ăꍇ̓XN[ʒuړB
		if(TWindow->UpButIn || TWindow->DownButIn) {
			if(TWindow->UpButBottom) {
				TWindow->DrawLeftUpY -= ScrollSize;
				if(TWindow->DrawLeftUpY < 0) { TWindow->DrawLeftUpY = 0; }
				TWindow->VScroll = TWindow->DrawLeftUpY * ScrollH / (TWindow->ClientSize.cy - InfoAreaH);
			} else if(TWindow->DownButBottom) {
				TWindow->DrawLeftUpY += ScrollSize;
				if(TWindow->DrawLeftUpY > (TWindow->ClientSize.cy - InfoAreaH)) { TWindow->DrawLeftUpY = TWindow->ClientSize.cy - InfoAreaH; }
				TWindow->VScroll = TWindow->DrawLeftUpY * ScrollH / (TWindow->ClientSize.cy - InfoAreaH);
			}
		//XN[o[̂܂݂͂łꍇ̓}EXJ[\̈ړʂɂ킹ăXN[ʒuړB
		} else if(TWindow->VScrollGrips) {
			TWindow->VScroll += MouseMoveY;
			if(TWindow->VScroll <       0) { TWindow->VScroll =       0; }
			if(TWindow->VScroll > ScrollH) { TWindow->VScroll = ScrollH; }
			TWindow->DrawLeftUpY = TWindow->VScroll * (TWindow->ClientSize.cy - InfoAreaH) / ScrollH;
		//XN[o[̗̈ɃJ[\A{^ꂽuԂ̏ꍇ̓XN[o[֌W̏B
		} else if((MouseEdgeInput & (1<<0)/*MOUSE_INPUT_LEFT*/) &&
			  ToolStatic_CheckMouseIn(TWindow->InfoArea.right,
			                          TWindow->InfoArea.top    + TOOL_SCROLLBAR_BUTTON_SIZE,
			                          TWindow->InfoArea.right  + TOOL_WINDOW_SCROLLBAR_WIDTH,
			                          TWindow->InfoArea.bottom - TOOL_SCROLLBAR_BUTTON_SIZE)) {
			//܂݂̊ONbNꍇ1ʕړB
			if(MouseY < (TWindow->InfoArea.top + TOOL_SCROLLBAR_BUTTON_SIZE + TWindow->VScroll)) {
				TWindow->VScroll -= InfoAreaH * ScrollH / TWindow->ClientSize.cy;
				if(TWindow->VScroll < 0) { TWindow->VScroll = 0; }
			} else if(MouseY > (TWindow->InfoArea.top + TOOL_SCROLLBAR_BUTTON_SIZE + TWindow->VScroll + TOOL_SCROLLBAR_THUMB_SIZE)) {
				TWindow->VScroll += InfoAreaH * ScrollH / TWindow->ClientSize.cy;
				if(TWindow->VScroll > ScrollH) { TWindow->VScroll = ScrollH; }
			//܂݂NbNꍇ͂܂ݒ͂ݏԂɂB
			} else {
				TWindow->VScrollGrips = 1;
			}
			//XN[ʒuXN[ʒul`_ʒuZoB
			TWindow->DrawLeftUpY = TWindow->VScroll * (TWindow->ClientSize.cy - InfoAreaH) / ScrollH;
		}
	}
}
//-----------------------------------------------------------------------------
//EChEʂɕ`悷B
//[in]
//	TWindow			EChEB
static void ToolWindow_Draw(SToolWindow* TWindow) {
	int InfoAreaW, InfoAreaH;
	int DrawWidth;
	int SizeOverX, SizeOverY;
	int DownButInBottom, UpButInBottom, LeftButInBottom, RightButInBottom;
	//\Ԃ0̏ꍇ͉IB
	if(!ToolWindow_GetVisible(TWindow)) { return; }	//܂
	//Xy[X񂪕ύXĂ\̂ŏ\̈̍XVB
	ToolWindow_UpdateInfoArea(TWindow);
	//XN[o[̃{^̏ɃJ[\A{^ĂԂǂ𒲂ׂĂB
	DownButInBottom  = TWindow->DownButBottom  && TWindow->DownButIn;
	UpButInBottom    = TWindow->UpButBottom    && TWindow->UpButIn;
	LeftButInBottom  = TWindow->LeftButBottom  && TWindow->LeftButIn;
	RightButInBottom = TWindow->RightButBottom && TWindow->RightButIn;
	//\̈̕ƍZoB
	InfoAreaW = TWindow->InfoArea.right - TWindow->InfoArea.left;
	InfoAreaH = TWindow->InfoArea.bottom - TWindow->InfoArea.top;
	//NCAg̈̃TCY\̈̃TCY傫ǂ𒲂ׂĂB
	SizeOverX = InfoAreaW < TWindow->ClientSize.cx;
	SizeOverY = InfoAreaH < TWindow->ClientSize.cy;
	//Oݒ肳Ăꍇ͖O\B
	if(TWindow->Name) {
		//O\EChE㕔`B
		ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 128);
		ToolFunc_DrawBox(TWindow->InfoArea.left  ,
		                 TWindow->InfoArea.top   - TOOL_WINDOW_NAME_HEIGHT,
		                 TWindow->InfoArea.right + (SizeOverY ? TOOL_WINDOW_SCROLLBAR_WIDTH : 0),
		                 TWindow->InfoArea.top   ,
		                 ToolFunc_GetColor(255,255,255),
		                 1);
		//O̕`B
		DrawWidth = ToolFunc_GetDrawStringWidthToHandle(TWindow->Name, -1, ToolStatic_GetButtonFontHandle());
		ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 200);
		ToolFunc_DrawStringToHandle(TWindow->InfoArea.left + (InfoAreaW - DrawWidth) / 2,
		                            TWindow->InfoArea.top - TOOL_WINDOW_NAME_HEIGHT + (TOOL_WINDOW_NAME_HEIGHT - TOOL_FONT_HEIGHT) / 2,
		                            TWindow->Name,
		                            ToolFunc_GetColor(0,0,0),
		                            ToolStatic_GetButtonFontHandle());
	}
	//EChE̘g`B
	ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 200);
	ToolFunc_DrawBox(TWindow->InfoArea.left   - 1,
	                 TWindow->InfoArea.top    - 1 - (TWindow->Name ? TOOL_WINDOW_NAME_HEIGHT : 0),
	                 TWindow->InfoArea.right  + 1 + (SizeOverY ? TOOL_WINDOW_SCROLLBAR_WIDTH : 0),
	                 TWindow->InfoArea.bottom + 1 + (SizeOverX ? TOOL_WINDOW_SCROLLBAR_WIDTH : 0),
	                 ToolFunc_GetColor(255,255,255),
	                 0);
	ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 64);
	ToolFunc_DrawBox(TWindow->InfoArea.left  ,
	                 TWindow->InfoArea.top   ,
	                 TWindow->InfoArea.right ,
	                 TWindow->InfoArea.bottom,
	                 ToolFunc_GetColor(0,0,0),
	                 1);
	ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 200);
	//NCAg̈̏c\̈̏c傫ꍇ͏c̃XN[o[`悷B
	if(SizeOverY) {
		//o[̏㉺ړ{^`B
		ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 200);
		ToolFunc_DrawBox(TWindow->InfoArea.right,
		                 TWindow->InfoArea.top,
		                 TWindow->InfoArea.right + TOOL_WINDOW_SCROLLBAR_WIDTH,
		                 TWindow->InfoArea.top   + TOOL_SCROLLBAR_BUTTON_SIZE,
		                 ToolFunc_GetColor(255,255,255),
		                 UpButInBottom);
		ToolFunc_DrawBox(TWindow->InfoArea.right,
		                 TWindow->InfoArea.bottom - TOOL_SCROLLBAR_BUTTON_SIZE,
		                 TWindow->InfoArea.right  + TOOL_WINDOW_SCROLLBAR_WIDTH,
		                 TWindow->InfoArea.bottom,
		                 ToolFunc_GetColor(255,255,255),
		                 DownButInBottom);
		ToolFunc_DrawTriangle(TWindow->InfoArea.right + 2,
		                      TWindow->InfoArea.top   + TOOL_SCROLLBAR_BUTTON_SIZE - 2,
		                      TWindow->InfoArea.right + TOOL_WINDOW_SCROLLBAR_WIDTH / 2,
		                      TWindow->InfoArea.top   + 2,
		                      TWindow->InfoArea.right + TOOL_WINDOW_SCROLLBAR_WIDTH - 2,
		                      TWindow->InfoArea.top   + TOOL_SCROLLBAR_BUTTON_SIZE - 2,
		                      UpButInBottom ? ToolFunc_GetColor(0,0,0) : ToolFunc_GetColor(255,255,255),
		                      1);
		ToolFunc_DrawTriangle(TWindow->InfoArea.right  + 2,
		                      TWindow->InfoArea.bottom - TOOL_SCROLLBAR_BUTTON_SIZE + 2,
		                      TWindow->InfoArea.right  + TOOL_WINDOW_SCROLLBAR_WIDTH / 2,
		                      TWindow->InfoArea.bottom - 2,
		                      TWindow->InfoArea.right  + TOOL_WINDOW_SCROLLBAR_WIDTH - 2,
		                      TWindow->InfoArea.bottom - TOOL_SCROLLBAR_BUTTON_SIZE + 2,
		                      DownButInBottom ? ToolFunc_GetColor(0,0,0) : ToolFunc_GetColor(255,255,255),
		                      1);
		//o[̘g`B
		ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 128);
		ToolFunc_DrawBox(TWindow->InfoArea.right,
		                 TWindow->InfoArea.top    + TOOL_SCROLLBAR_BUTTON_SIZE,
		                 TWindow->InfoArea.right  + TOOL_WINDOW_SCROLLBAR_WIDTH,
		                 TWindow->InfoArea.bottom - TOOL_SCROLLBAR_BUTTON_SIZE,
		                 ToolFunc_GetColor(255,255,255),
		                 1);
		//o[݂̌̃XN[ʒu܂ݕ`B
		ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 200);
		ToolFunc_DrawBox(TWindow->InfoArea.right,
		                 TWindow->InfoArea.top   + TWindow->VScroll + TOOL_SCROLLBAR_BUTTON_SIZE,
		                 TWindow->InfoArea.right + TOOL_WINDOW_SCROLLBAR_WIDTH,
		                 TWindow->InfoArea.top   + TWindow->VScroll + TOOL_SCROLLBAR_BUTTON_SIZE + TOOL_SCROLLBAR_THUMB_SIZE,
		                 ToolFunc_GetColor(255,255,255),
		                 1);
	}
	//NCAg̈̉\̈̉傫ꍇ͉̃XN[o[`悷B
	if(SizeOverX) {
		//o[̍Eړ{^`B
		ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 200);
		ToolFunc_DrawBox(TWindow->InfoArea.left,
		                 TWindow->InfoArea.bottom,
		                 TWindow->InfoArea.left   + TOOL_SCROLLBAR_BUTTON_SIZE,
		                 TWindow->InfoArea.bottom + TOOL_WINDOW_SCROLLBAR_WIDTH,
		                 ToolFunc_GetColor(255,255,255),
		                 LeftButInBottom);
		ToolFunc_DrawBox(TWindow->InfoArea.right  - TOOL_SCROLLBAR_BUTTON_SIZE,
		                 TWindow->InfoArea.bottom,
		                 TWindow->InfoArea.right,
		                 TWindow->InfoArea.bottom + TOOL_WINDOW_SCROLLBAR_WIDTH,
		                 ToolFunc_GetColor(255,255,255),
		                 RightButInBottom);
		ToolFunc_DrawTriangle(TWindow->InfoArea.left   + TOOL_SCROLLBAR_BUTTON_SIZE - 2,
		                      TWindow->InfoArea.bottom + 2,
		                      TWindow->InfoArea.left   + 2,
		                      TWindow->InfoArea.bottom + TOOL_WINDOW_SCROLLBAR_WIDTH / 2,
		                      TWindow->InfoArea.left   + TOOL_SCROLLBAR_BUTTON_SIZE - 2,
		                      TWindow->InfoArea.bottom + TOOL_WINDOW_SCROLLBAR_WIDTH - 2,
		                      LeftButInBottom ? ToolFunc_GetColor(0,0,0) : ToolFunc_GetColor(255,255,255),
		                      1);
		ToolFunc_DrawTriangle(TWindow->InfoArea.right  - TOOL_SCROLLBAR_BUTTON_SIZE + 2,
		                      TWindow->InfoArea.bottom + 2,
		                      TWindow->InfoArea.right  - 2,
		                      TWindow->InfoArea.bottom + TOOL_WINDOW_SCROLLBAR_WIDTH / 2,
		                      TWindow->InfoArea.right  - TOOL_SCROLLBAR_BUTTON_SIZE + 2,
		                      TWindow->InfoArea.bottom + TOOL_WINDOW_SCROLLBAR_WIDTH - 2,
		                      RightButInBottom ? ToolFunc_GetColor(0,0,0) : ToolFunc_GetColor(255,255,255),
		                      1);
		//o[̘g`B
		ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 128);
		ToolFunc_DrawBox(TWindow->InfoArea.left   + TOOL_SCROLLBAR_BUTTON_SIZE,
		                 TWindow->InfoArea.bottom,
		                 TWindow->InfoArea.right  - TOOL_SCROLLBAR_BUTTON_SIZE,
		                 TWindow->InfoArea.bottom + TOOL_WINDOW_SCROLLBAR_WIDTH,
		                 ToolFunc_GetColor(255,255,255),
		                 1);
		//o[݂̌̃XN[ʒu܂ݕ`B
		ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 200);
		ToolFunc_DrawBox(TWindow->InfoArea.left   + TWindow->HScroll + TOOL_SCROLLBAR_BUTTON_SIZE,
		                 TWindow->InfoArea.bottom,
		                 TWindow->InfoArea.left   + TWindow->HScroll + TOOL_SCROLLBAR_BUTTON_SIZE + TOOL_SCROLLBAR_THUMB_SIZE,
		                 TWindow->InfoArea.bottom + TOOL_WINDOW_SCROLLBAR_WIDTH,
		                 ToolFunc_GetColor(255,255,255),
		                 1);
	}
	//`uh[hɖ߂B
	ToolFunc_SetDrawBlendMode(0/*DX_BLENDMODE_NOBLEND*/, 0);
}
