#//----------------------------------------------------------------------------
BEGIN {
	FS = "\t"
	delete aSJ
	delete aUC
	delete aSJtoUC
	delete aUCtoSJ
	n = 0
	#//Unicodeݿт̢SHIFTJIS.TXTɂͤ亰ނϯݸނ܂܂ĂȂ̂Ť亰ނϯݸނ𖾎IɊi[Ă
	#//ʂ̈ĂƂĤsɐ亰ނʈĂL邪亰ނðقɊ܂߂Ăs̏ȌɂȂėǂƎv
	for(i = 0; i < 0x20; i++) {
		sj = i
		uc = i
		n++
		aSJ[n] = sj
		aUC[n] = uc
		aSJtoUC[sj] = uc
		aUCtoSJ[uc] = sj
	}
}
#//----------------------------------------------------------------------------
($1 ~ /^0x[[:xdigit:]]+$/) &&
($2 ~ /^0x[[:xdigit:]]+$/) {
	sj = strtonum($1)
	uc = strtonum($2)
	if(!sj || !uc) {
		print "###̧ق̏sł:" $0				> "/dev/stderr"
		exit 1
	}
	if(sj in aSJtoUC) {
		print "###JISނdĂ܂:" $0			> "/dev/stderr"
		exit 1
	}
	if(uc in aUCtoSJ) {
		print "###ƺނdĂ܂:" $0				> "/dev/stderr"
		exit 1
	}
	n++
	aSJ[n] = sj
	aUC[n] = uc
	aSJtoUC[sj] = uc
	aUCtoSJ[uc] = sj
}
#//----------------------------------------------------------------------------
END {
	asort(aSJ)
	asort(aUC)
	ShiftJisToUnicode()	#//k28152޲ā݈k12568޲	̕kǂްɂȂ̂łgɂ܂
#//	UnicodeToShiftJis()	#//k28152޲ā݈k16188޲
}
#//----------------------------------------------------------------------------
function ShiftJisToUnicode(fp) {
	ucNext = 0
	sjNext = 0
	print "static const unsigned char __tmp__[]={"
	for(i = 1; i <= n; i++) {
		sj = aSJ[i]
		uc = aSJtoUC[sj]
		sjDiff = sj - sjNext
		if(sjDiff < 0) {
			print "###޸ޡJIS̿Čʂsł"		> "/dev/stderr"
			exit 1
		}
		ucDiff = uc - ucNext
		if(ucDiff < 0) {
			ucDiff += 65536
		}
		printf("0x%02X,0x%02X,0x%02X,0x%02X,//%04X %04X\n",
			rshift(sjDiff,   8),	#//ޯ޴ި݂Ŋi[鎖ɂ
			and(   sjDiff, 255),	#//
			rshift(ucDiff,   8),	#//ޯ޴ި݂Ŋi[鎖ɂ
			and(   ucDiff, 255),	#//
			sj, uc)
		sjNext = sj + 1
		ucNext = uc + 1
	}
	print "};"
}
#//----------------------------------------------------------------------------
function UnicodeToShiftJis() {
	ucNext = 0
	sjNext = 0
	print "static const unsigned char __tmp__[]={"
	for(i = 1; i <= n; i++) {
		uc = aUC[i]
		sj = aUCtoSJ[uc]
		ucDiff = uc - ucNext
		if(ucDiff < 0) {
			print "###޸ޡƺނ̿Čʂsł"		> "/dev/stderr"
			exit 1
		}
		sjDiff = sj - sjNext
		if(sjDiff < 0) {
			sjDiff += 65536
		}
		printf("0x%02X,0x%02X,0x%02X,0x%02X,//%04X %04X\n",
			rshift(ucDiff,   8),	#//ޯ޴ި݂Ŋi[鎖ɂ
			and(   ucDiff, 255),	#//
			rshift(sjDiff,   8),	#//ޯ޴ި݂Ŋi[鎖ɂ
			and(   sjDiff, 255),	#//
			uc, sj)
		ucNext = uc + 1
		sjNext = sj + 1
	}
	print "};"
}
