/*
 *	game.c
 *
 *	P/ece Drivin'
 *
 *	* Thu Jun 29 00:00:00 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"
/****************************************************************************
 *	萔
 ****************************************************************************/
#define RGFX_UNIT			ARRAY_SIZE(rgfx[0])
#define RGFX_SIZE			ARRAY_SIZE(rgfx[0][0])
#define ROAD_W				160
#define ROAD_MAX			60
#define ROAD_MIN			-ROAD_MAX
#define OBSTACLE_OFS			50
/*--------------------------------------------------------------------------*/
#define ENEMY_NUM			4		//
#define OBSTACLE_NUM			SEG_NUM		//
/*--------------------------------------------------------------------------*/
#define CAM_Y				33
#define SCR_Z				8
#define SCR_W				96
#define SCR_H				66
/*--------------------------------------------------------------------------*/
#define SEG_NUM				16
#define SEG_LEN				16
#define OBJ_NUM				(1/*[XQ[g*/ + 1/**/ + ENEMY_NUM + OBSTACLE_NUM)	//ƌ炵Ă\܂BȂĂgame_draw()ɂaddObj()ŌĂяoނ̕\邾łB
/*--------------------------------------------------------------------------*/
#define PLAYER_SPD_MAX			8
#define PLAYER_MOVE_MAX			5
#define PLAYER_MOVE_DOWN		4
#define PLAYER_OFFROAD_MAX		2
#define PLAYER_ACC			((PLAYER_SPD_MAX << 4) / SEC(2.0/**/))	//4bit
#define PLAYER_DEC			((PLAYER_SPD_MAX << 4) / SEC(4.0/**/))	//4bit
#define PLAYER_BRK			((PLAYER_SPD_MAX << 4) / SEC(2.0/**/))	//4bit
#define ENEMY_SPD_MIN			4
#define ENEMY_SPD_MAX			7
/*--------------------------------------------------------------------------*/
#define GAME_STAT_READY			1
#define GAME_STAT_RUN			2
#define GAME_STAT_GAMEOVER		3
/*--------------------------------------------------------------------------*/
#define CAR_STAT_RUN			1
#define CAR_STAT_SPIN			2
#define CAR_STAT_CLASH			3
/*--------------------------------------------------------------------------*/
#define OBSTACLE_KIND_TREE		1
#define OBSTACLE_KIND_SIGNBOARD		2
/*--------------------------------------------------------------------------*/
#define OBJ_TYPE_PLAYER			1
#define OBJ_TYPE_ENEMY			2
#define OBJ_TYPE_OBSTACLE		3
#define OBJ_TYPE_RACEGATE		4
/*--------------------------------------------------------------------------*/
#define OBSTACLE_MODE_TREE_L		1
#define OBSTACLE_MODE_TREE_R		2
#define OBSTACLE_MODE_TREE_LR		3
#define OBSTACLE_MODE_SIGNBOARD_L	4
#define OBSTACLE_MODE_SIGNBOARD_R	5
#define OBSTACLE_MODE_SIGNBOARD_LR	6
#define OBSTACLE_MODE_TREE_SIGNBOARD	7
#define OBSTACLE_MODE_SIGNBOARD_TREE	8
#define OBSTACLE_MODE_MAX		8
/*--------------------------------------------------------------------------*/
#define ZOOM_UNIT			(150 / 5)
#define ZOOM_MAX			((50 / 5) - 1)
/*--------------------------------------------------------------------------*/
#define PLAYER_Z			(SCR_Z + 2)
#define AREA_TIME_INIT			SEC(30)
#define AREA_TIME			SEC(20)
#define AREA_LEN			((int)(AREA_TIME * 0.95/**/ * PLAYER_SPD_MAX / SEG_LEN))
/*--------------------------------------------------------------------------*/
#define LEVEL_MAX			10
/****************************************************************************
 *	\
 ****************************************************************************/
typedef struct _ST_Car {
	short			stat;			//CAR_STAT_*		0=
	short			anm;			//
	short			spd;			//			4bit
	short			x;			//
	short			y;			//
	short			z;			//
	short			vx;			//
	short			vy;			//
} ST_Car;
/*--------------------------------------------------------------------------*/
typedef struct _ST_Obstacle {
	short			kind;			//OBSTACLE_KIND_*	0=
	short			x;			//
	short			z;			//
} ST_Obstacle;
/*--------------------------------------------------------------------------*/
typedef struct _ST_RodObj {
	ST_RodObjBase		base;
	uint8_t			type;			//OBJ_TYPE_*
	void*			data;
} ST_RodObj;
/*--------------------------------------------------------------------------*/
typedef struct _ST_RodSeg {
	ST_RodSegBase		base;
	uint16_t		road;			//̐F(01)
} ST_RodSeg;
/*--------------------------------------------------------------------------*/
typedef struct _ST_Game {
	ST_RodGen		stRodGen;
	ST_RodStr		stRodStr;
	ST_RodSeg		TBL_RodSeg[SEG_NUM];
	ST_RodObj		TBL_RodObj[OBJ_NUM];
	//
	ST_Car			player;
	ST_Car			TBL_Enemy[ENEMY_NUM];
	ST_Obstacle		TBL_Obstacle[OBSTACLE_NUM];
	//
	int			stat;
	int			time;
	int			score;
	int			level;
	//
	int			area_cnt;
	int			bgd_x, bgd_y;
	int			curve_target, curve_add, curve_wait;
	int			slope_target, slope_add, slope_wait;
	int			obstacle_mode, obstacle_wait;
	int			enemy_wait;
	//
	int			enemy_spd_rate;		//Jn016
	int			skid;
	int			extend_play;
} ST_Game;
/*--------------------------------------------------------------------------*/
int				debugMode;		//^C0̒OŎ~܂B`FbN|Cgʉ߂ĂxȂBNbVȂB
/****************************************************************************
 *	֐錾
 ****************************************************************************/
void fnDrawSeg(const struct _ST_RodStr* pRodStr, const ST_RodSegBase* pRodSegBase, int iLine1/*܂*/, int x11, int x21, int iLine2/*܂܂*/, int x12, int x22, int iLineMax/*܂*/);
void fnDrawObj(const struct _ST_RodStr* pRodStr, const ST_RodSegBase* pRodSegBase, const ST_RodObjBase* pRodObjBase, int x, int y, int dx, int vx, int iLineMax/*܂*/);
void fnDrawBgd(const struct _ST_RodStr* pRodStr, int iLineMax/*܂*/);
/****************************************************************************
 *	ϐ
 ****************************************************************************/
ST_Game				stGame;
int				hiscore;
int				level_sel	= 1;
/****************************************************************************
 *	萔f[^
 ****************************************************************************/
const ST_RodStr initRodStr={
				//--- function ---
fnDrawSeg,			//fnDrawSeg
fnDrawObj,			//fnDrawObj
fnDrawBgd,			//fnDrawBgd
				//--- required ---
&stGame.TBL_RodSeg->base,	//TBL_RodSeg		Œ
sizeof(ST_RodSeg),		//segStride		Œ
SEG_NUM,			//segNum		Œ
SEG_LEN,			//segLen		Œ
0,				//segOfs
ROAD_W,				//roadW			Œ
0,				//camX
CAM_Y,				//camY
SCR_Z,				//scrZ			Œ
SCR_W,				//scrW			Œ
SCR_H,				//scrH			Œ
DISP_X,				//dispW			Œ
DISP_Y,				//dispH			Œ
DISP_X*0.5,			//dispC			Œ
DISP_Y*0.5/**/,		//dispM			Œ
				//--- optional ---
&stGame.TBL_RodObj->base,	//TBL_RodObj		Œ
sizeof(ST_RodObj),		//objStride		Œ
0/*`OBJ_NUM*/,			//objNum
};
/*--------------------------------------------------------------------------*/
//̃p^[
const uint8_t rgfx[][4][44]={
{{2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2},	//
 {2,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,2},	//ST_RodSeg.road=0
 {2,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,2},	//
 {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2}},	//
{{3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3},	//
 {3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3},	//ST_RodSeg.road=1
 {3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3},	//
 {3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3}}};	//
/*--------------------------------------------------------------------------*/
//Ԃ̃XvCge[uB
const uint16_t TBL_CarSpr[3/*㉺̌X*/][13/*Ẻ]*/]={{	//]0`120`180ɑΉB180𒴂]0`180̃XvCgE]ĕ`悵ĉB
//STRAIGHT
SPR_STRAIGHT00_5,
SPR_STRAIGHT01_5,
SPR_STRAIGHT02_5,
SPR_STRAIGHT03_5,
SPR_STRAIGHT04_5,
SPR_STRAIGHT05_5,
SPR_STRAIGHT06_5,
SPR_STRAIGHT07_5,
SPR_STRAIGHT08_5,
SPR_STRAIGHT09_5,
SPR_STRAIGHT10_5,
SPR_STRAIGHT11_5,
SPR_STRAIGHT12_5},{
//UP
SPR_UP00_5,
SPR_UP01_5,
SPR_UP02_5,
SPR_UP03_5,
SPR_UP04_5,
SPR_UP05_5,
SPR_UP06_5,
SPR_UP07_5,
SPR_UP08_5,
SPR_UP09_5,
SPR_UP10_5,
SPR_UP11_5,
SPR_UP12_5},{
//DOWN
SPR_DOWN00_5,
SPR_DOWN01_5,
SPR_DOWN02_5,
SPR_DOWN03_5,
SPR_DOWN04_5,
SPR_DOWN05_5,
SPR_DOWN06_5,
SPR_DOWN07_5,
SPR_DOWN08_5,
SPR_DOWN09_5,
SPR_DOWN10_5,
SPR_DOWN11_5,
SPR_DOWN12_5}};
/*--------------------------------------------------------------------------*/
//ԂNbṼXvCge[uB
const uint16_t TBL_ClashSpr[8/*Aj[Vp^[*/]={
SPR_CLASH00_5,
SPR_CLASH01_5,
SPR_CLASH02_5,
SPR_CLASH03_5,
SPR_CLASH04_5,
SPR_CLASH05_5,
SPR_CLASH06_5,
SPR_CLASH07_5};
/*--------------------------------------------------------------------------*/
//Q̃XvCge[uB̍ɕ`p^[łB̉Ȅꍇ͍E]ĕ`悵ĉB
const uint16_t TBL_ObstacleSpr[3/**/]={
SPR_TREE_5,
SPR_SIGNBOARD_5,
SPR_RACEGATE_5};	//[XQ[g͏Qł͂ȂA֋XAQ̃XvCge[uɊ܂߂B
/****************************************************************************
 *	
 ****************************************************************************/
void score_draw() {
	render_printf_framed(&render,
		1,
		1,
		4,
		0x330,
		"1P %05d",
		min(stGame.score, 99999));
	render_printf_framed(&render,
		DISP_X - (4 * 8) - 2,
		1,
		4,
		0x330,
		"HI %05d",
		min(hiscore, 99999));
}
/*--------------------------------------------------------------------------*/
void meter_draw() {
	//c莞
	{
		div_t d = div(stGame.time, FPS);
		d.rem = d.rem * 10 / FPS;
		render_printf_framed(&render,
			54,
			0,
			0,
			0x330,
			"%02d",
			d.quot);
		render_printf_framed(&render,
			54 + 11,
			0 + 5,
			4,
			0x330,
			".%d",
			d.rem);
	}
	//x
	{
		int spd = (stGame.player.spd << (8 - 4)) / PLAYER_SPD_MAX;
		render_printf_framed(&render,
			1,
			1 + 6,
			4,
			0x330,
			"%3d km/h",
			spd);
	}
	//x
	{
		render_printf_framed(&render,
			DISP_X - (4 * 8) - 2,
			1 + 6,
			4,
			0x330,
			"LEVEL %02d",
			stGame.level);
	}
}
/*--------------------------------------------------------------------------*/
//Փxݒ
typedef struct _ST_Level {
	int	curveWaitMin;
	int	curveWaitMax;
	int	curveRate;
	int	curveMin;	//4ȏƂ鎖B4ɂƃvC[ړ̏̐؂̂Ă̂߂ɃJ[ủS͌ʂoȂB
	int	curveMax;	//64ȉƂ鎖B܂傫Ƒx𗎂ƂĂȂȂȂ邩B
	int	curveAddMin;
	int	curveAddMax;
	//
	int	slopeWaitMin;
	int	slopeWaitMax;
	int	slopeRate;
	int	slopeMin;	//12ȏƂ鎖B܂菬ƌڂɔȂB
	int	slopeMax;	//48ȉƂ鎖B܂傫ƓȂȂ邩B
	int	slopeAddMin;
	int	slopeAddMax;
	//
	int	obstacleWaitMin;
	int	obstacleWaitMax;
	int	obstacleRate;
	//
	int	enemyWaitMin;
	int	enemyWaitMax;
	int	enemySpdMin;	//4(ENEMY_SPD_MIN)`7(ENEMY_SPD_MAX)
	int	enemySpdMax;	//4(ENEMY_SPD_MIN)`7(ENEMY_SPD_MAX)
	int	enemyConcurrent;
} ST_Level;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static const ST_Level TBL_Level[(LEVEL_MAX+1)]={{0}/*_~[*/,
//	curve									slope									obstacle				enemy
//	WaitMin		WaitMax		Rate	Min	Max	AddMin	AddMax	WaitMin		WaitMax		Rate	Min	Max	AddMin	AddMax	WaitMin		WaitMax		Rate	WaitMin		WaitMax		SpdMin	SpdMax	Concurrent
{	SEC(1.0),	SEC(1.5),	25,	 4,	 8,	4,	4,	SEC(0.1),	SEC(0.3),	 5,	12,	24,	3,	4,	SEG_NUM*0.3,	SEG_NUM*0.5,	 30,	SEC(0.5),	SEC(1.0),	6,	7,	1,	},	//1
{	SEC(0.9),	SEC(1.4),	30,	 8,	16,	4,	4,	SEC(0.2),	SEC(0.5),	10,	16,	32,	3,	4,	SEG_NUM*0.3,	SEG_NUM*0.6,	 35,	SEC(0.5),	SEC(0.9),	6,	7,	2,	},	//2
{	SEC(0.8),	SEC(1.3),	35,	12,	32,	4,	5,	SEC(0.3),	SEC(0.7),	15,	20,	40,	3,	5,	SEG_NUM*0.4,	SEG_NUM*0.7,	 40,	SEC(0.4),	SEC(0.8),	5,	7,	2,	},	//3
{	SEC(0.7),	SEC(1.2),	40,	16,	48,	4,	5,	SEC(0.4),	SEC(0.9),	20,	24,	48,	3,	5,	SEG_NUM*0.4,	SEG_NUM*0.8,	 45,	SEC(0.4),	SEC(0.7),	5,	7,	2,	},	//4
{	SEC(0.6),	SEC(1.1),	45,	24,	64,	4,	6,	SEC(0.5),	SEC(1.0),	25,	28,	48,	4,	5,	SEG_NUM*0.5,	SEG_NUM*0.9,	 50,	SEC(0.3),	SEC(0.6),	5,	7,	3,	},	//5
{	SEC(0.5),	SEC(1.0),	50,	32,	64,	4,	6,	SEC(0.6),	SEC(1.1),	30,	32,	48,	4,	5,	SEG_NUM*0.5,	SEG_NUM*1.0,	 60,	SEC(0.3),	SEC(0.5),	5,	7,	3,	},	//6
{	SEC(0.4),	SEC(0.9),	60,	40,	64,	5,	7,	SEC(0.7),	SEC(1.2),	35,	36,	48,	5,	6,	SEG_NUM*0.6,	SEG_NUM*1.2,	 70,	SEC(0.2),	SEC(0.4),	5,	6,	3,	},	//7
{	SEC(0.3),	SEC(0.7),	70,	48,	64,	6,	7,	SEC(0.8),	SEC(1.3),	40,	40,	48,	5,	6,	SEG_NUM*0.7,	SEG_NUM*1.4,	 80,	SEC(0.2),	SEC(0.3),	5,	6,	4,	},	//8
{	SEC(0.2),	SEC(0.5),	80,	56,	64,	7,	8,	SEC(0.9),	SEC(1.4),	45,	44,	48,	6,	6,	SEG_NUM*0.8,	SEG_NUM*1.7,	 90,	SEC(0.1),	SEC(0.2),	4,	6,	4,	},	//9
{	SEC(0.1),	SEC(0.3),	90,	64,	64,	8,	8,	SEC(1.0),	SEC(1.5),	50,	48,	48,	6,	6,	SEG_NUM*0.9,	SEG_NUM*2.0,	100,	SEC(0.1),	SEC(0.1),	4,	6,	4,	}};	//10
/****************************************************************************
 *	
 ****************************************************************************/
void fnDrawSeg(const struct _ST_RodStr* pRodStr, const ST_RodSegBase* pRodSegBase, int iLine1/*܂*/, int x11, int x21, int iLine2/*܂܂*/, int x12, int x22, int iLineMax/*܂*/) {
	const ST_RodSeg* pRodSeg = CONTAINING_RECORD(pRodSegBase, ST_RodSeg, base);
	int iRoad1 = pRodSeg->road * RGFX_UNIT;
	int iRoad2 = iRoad1        + RGFX_UNIT - 1;
	RodGen_DrawSeg(&stGame.stRodGen, iLine1, iRoad1, x11, x21,
	                                 iLine2, iRoad2, x12, x22, 0, iLineMax);
}
/*--------------------------------------------------------------------------*/
static int getObjRot(int dx, int dz, int vx) {
	//@GԂZOgɂX̌vZ
	int rot = (vx + (1 << (5/**/ - 1))) >> 5/**/;
	//AԂ猩GԂ̑ΈʒuɂX̌vZ
	if(dx <= -(dz << 1/**/)) { rot++; }	//Ԃ猩čɌ(dx<0)GԂ̕AEɌXČ(rot>0)ɒӂĉB
	if(dx >=  (dz << 1/**/)) { rot--; }	//
	//B~b^[
	return clamp(rot, -2/**/, 2/**/);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void drawCar(int x, int y, int rot, int updn, int zoom) {
	int param = DRW_NOMAL;
	rot %= 24/**/;			//-23`23
	if(rot < 0) { rot += 24/**/; }	//  0`23
	if(rot >= 12/**/) {
		rot = 24/**/ - rot;		// 13`2311`1
		param = DRW_REVX;
	}
	sprite_draw(x, y, TBL_CarSpr[updn][rot] + zoom, param);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void drawClash(int x, int y, int anm, int zoom) {
	anm &= 7/*]*/;
	sprite_draw(x, y, TBL_ClashSpr[anm] + zoom, DRW_NOMAL);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void drawPlayer(const ST_RodSegBase* pRodSegBase, const ST_RodObjBase* pRodObjBase, int x, int y, int dx, int vx, int zoom, ST_Car* pCar) {
	switch(pCar->stat) {
	default:DIE();
	case CAR_STAT_RUN:
		{
			int rot = 0;
			int updn = 0/*STRAIGHT*/;
			if((stGame.stat == GAME_STAT_RUN) && stGame.time && stGame.player.spd) {
				if(joy & PAD_LF) { rot--; }
				if(joy & PAD_RI) { rot++; }
			}
			if(pRodSegBase->slope >  23/**/) { updn = 1/*UP*/; }
			if(pRodSegBase->slope < -23/**/) { updn = 2/*DOWN*/; }
			drawCar(x, y, rot, updn, zoom);
		}
		break;
	case CAR_STAT_SPIN:
		{
			int rot = pCar->anm;
			int updn = 0/*STRAIGHT*/;
			if(pRodSegBase->slope >  23/**/) { updn = 1/*UP*/; }
			if(pRodSegBase->slope < -23/**/) { updn = 2/*DOWN*/; }
			rot = min(rot, 32);	//0->32
			rot = 32 - rot;		//32->0
			rot = rot * rot;	//32^2->0
			rot >>= 5;		//32->0;
			rot = rot + 14;
			drawCar(x, y, rot, updn, zoom);
		}
		break;
	case CAR_STAT_CLASH:
		{
			drawClash(x, y, pCar->anm & 7, zoom);
		}
		break;
	}
}
static void drawEnemy(const ST_RodSegBase* pRodSegBase, const ST_RodObjBase* pRodObjBase, int x, int y, int dx, int vx, int zoom, ST_Car* pCar) {
	switch(pCar->stat) {
	default:DIE();
	case CAR_STAT_RUN:
		{
			int rot = getObjRot(dx, pRodObjBase->z, vx);	//X:-2`+2:EX
			int updn = 0/*STRAIGHT*/;
			if(pRodSegBase->slope >  23/**/) { updn = 1/*UP*/; }
			if(pRodSegBase->slope < -23/**/) { updn = 2/*DOWN*/; }
			drawCar(x, y, rot, updn, zoom);
		}
		break;
	case CAR_STAT_SPIN:
		{
			int rot = pCar->anm;
			int updn = 0/*STRAIGHT*/;
			if(pRodSegBase->slope >  23/**/) { updn = 1/*UP*/; }
			if(pRodSegBase->slope < -23/**/) { updn = 2/*DOWN*/; }
			rot = min(rot, 32);	//0->32
			rot = 32 - rot;		//32->0
			rot = rot * rot;	//32^2->0
			rot >>= 5;		//32->0;
			rot = rot + 14;
			drawCar(x, y, -rot, updn, zoom);
		}
		break;
//	case CAR_STAT_CLASH:	GԂ̓NbVȂ͂B
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void fnDrawObj(const struct _ST_RodStr* pRodStr, const ST_RodSegBase* pRodSegBase, const ST_RodObjBase* pRodObjBase, int x, int y, int dx, int vx, int iLineMax/*܂*/) {
	int save_bottom = render.bottom;
	render.bottom = iLineMax + 1;
	{
		const ST_RodObj* pRodObj = CONTAINING_RECORD(pRodObjBase, ST_RodObj, base);
		int zoom = ZOOM_UNIT * SCR_Z / pRodObjBase->z;
		switch(pRodObj->type) {
		default:DIE();
		case OBJ_TYPE_PLAYER:
			if(zoom > ZOOM_MAX) { zoom = ZOOM_MAX; }
			{
				ST_Car* pCar = pRodObj->data;
				if(pCar != &stGame.player) { DIE(); }
				drawPlayer(pRodSegBase, pRodObjBase, x, y, dx, vx, zoom, pCar);
			}
			break;
		case OBJ_TYPE_ENEMY:
			if(zoom > ZOOM_MAX) { zoom = ZOOM_MAX; }
			{
				ST_Car* pCar = pRodObj->data;
				if((unsigned)(pCar - stGame.TBL_Enemy) >= ENEMY_NUM) { DIE(); }
				drawEnemy(pRodSegBase, pRodObjBase, x, y, dx, vx, zoom, pCar);
			}
			break;
		case OBJ_TYPE_OBSTACLE:
			if(zoom > ZOOM_MAX) { zoom = ZOOM_MAX; }
			{
				ST_Obstacle* pObstacle = pRodObj->data;
				if((unsigned)(pObstacle - stGame.TBL_Obstacle) >= OBSTACLE_NUM) { DIE(); }
				{
					int param = DRW_NOMAL;
					if(pRodObj->base.x >= 0) { param = DRW_REVX; }
					sprite_draw(x, y, TBL_ObstacleSpr[pObstacle->kind - 1] + zoom, param);
				}
			}
			break;
		case OBJ_TYPE_RACEGATE:
			if(zoom > ZOOM_MAX) { break; }
			{
				if(pRodObj->data) { DIE(); }
				{
					int param = DRW_NOMAL;
					sprite_draw(x, y, TBL_ObstacleSpr[2/*RACEGATE*/] + zoom, param);
				}
			}
			break;
		}
	}
	render.bottom = save_bottom;
}
/*--------------------------------------------------------------------------*/
void fnDrawBgd(const struct _ST_RodStr* pRodStr, int iLineMax/*܂*/) {
	int save_bottom = render.bottom;
	render.bottom = iLineMax + 1;
	{
		int x = stGame.bgd_x, y = stGame.bgd_y;
		sprite_draw(x, y, SPR_BGD, 0);
		x -= DISP_X;
		sprite_draw(x, y, SPR_BGD, 0);
		render_rectangle_fill(&render, 0, y - DISP_Y, DISP_X, DISP_Y, 0);
		render_rectangle_fill(&render, 0, y + DISP_Y, DISP_X, DISP_Y, 2);
	}
	render.bottom = save_bottom;
}
/*--------------------------------------------------------------------------*/
static void addEnemy(int spd) {
	int i;
	for(i = 0; i < ENEMY_NUM; i++) {
		ST_Car* pCar = &stGame.TBL_Enemy[i];
		if(!pCar->stat) {
			pCar->stat = CAR_STAT_RUN;
			pCar->spd = spd;
			//Ԃ̑xx΁AOoB
			if(spd < stGame.player.spd) {
				pCar->x = RND32_RANGE(seed, ROAD_MIN, ROAD_MAX + 1);
				pCar->z = SEG_LEN * SEG_NUM;	//Ō̃ZOg̉̕ӂł\L邪A薳BŃeXǵAԂƓGԂ̑Αxɂړl邩łB
			//Ԃ̑x΁AoB
			} else {
				if(stGame.player.x < 0) {			//vC[ɋc
					pCar->x = ROAD_MAX;			//E[ɏoB
				} else if(stGame.player.x > 0) {		//vC[Eɋc
					pCar->x = ROAD_MIN;			//[ɏoB
				} else {					//vC[ɋc	//ʂɗVłőɋNȂAX^[gɓȂ̓GԂ̌hǂ邽߂łB
					if(RND32_RANGE(seed, 0, 100) < 50) {	//E[,,[ɏoB
						pCar->x = ROAD_MAX;
					} else {
						pCar->x = ROAD_MIN;
					}
				}
				pCar->z = SCR_Z;
			}
			return;	//܂
		}
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void addObstacle(int kind, int side/*0=,1=E*/) {
	int i;
	for(i = 0; i < OBSTACLE_NUM; i++) {
		ST_Obstacle* pObstacle = &stGame.TBL_Obstacle[i];
		if(!pObstacle->kind) {
			pObstacle->kind = kind;
			pObstacle->x = side ? (ROAD_MAX + OBSTACLE_OFS)/*E*/ : (ROAD_MIN - OBSTACLE_OFS)/**/;
			pObstacle->z = SEG_LEN * (SEG_NUM - 1) - stGame.stRodStr.segOfs;
			return;	//܂
		}
	}
}
/*--------------------------------------------------------------------------*/
void game_init() {
	int i;
	memset(&stGame, 0, sizeof stGame);
	RodGen_Init(&stGame.stRodGen, vbuff, DISP_X, DISP_X, rgfx[0][0], RGFX_SIZE, RGFX_SIZE);
	stGame.stRodStr = initRodStr;
	stGame.stat = GAME_STAT_READY;
	stGame.time = AREA_TIME_INIT;
	stGame.level = level_sel;
	stGame.area_cnt = -2;	//X^[gʒũ`FbN|Cg悤ɏOɂB
	stGame.curve_wait = SEG_NUM * 2/**/;
	stGame.slope_wait = SEG_NUM * 2/**/;
    //	stGame.obstacle_wait = SEG_NUM * 1/**/;
	stGame.enemy_wait = SEC(5/**/);
	//ZOg̏
	for(i = 0; i < SEG_NUM; i++) {
		stGame.TBL_RodSeg[i].road = i & 1;
	}
	//Ԃ̏
	stGame.player.stat = CAR_STAT_RUN;
	stGame.player.z = PLAYER_Z;
	//GԂ̏
	{
		static_assert(ENEMY_NUM >= 4, "ENEMY_NUM too small");
		//O
		stGame.TBL_Enemy[0].stat = CAR_STAT_RUN;
		stGame.TBL_Enemy[0].x = ROAD_MIN + 16;
		stGame.TBL_Enemy[0].z = PLAYER_Z - 2;
		stGame.TBL_Enemy[0].spd = ((ENEMY_SPD_MIN << 4) * 0.7) + ((ENEMY_SPD_MAX << 4) * 0.3);
		//EO
		stGame.TBL_Enemy[1].stat = CAR_STAT_RUN;
		stGame.TBL_Enemy[1].x = ROAD_MAX - 16;
		stGame.TBL_Enemy[1].z = PLAYER_Z - 2;
		stGame.TBL_Enemy[1].spd = ((ENEMY_SPD_MIN << 4) * 0.4) + ((ENEMY_SPD_MAX << 4) * 0.6);
		//
		stGame.TBL_Enemy[2].stat = CAR_STAT_RUN;
		stGame.TBL_Enemy[2].x = ROAD_MIN + 16;
		stGame.TBL_Enemy[2].z = PLAYER_Z + 4;
		stGame.TBL_Enemy[2].spd = ((ENEMY_SPD_MIN << 4) * 0.1) + ((ENEMY_SPD_MAX << 4) * 0.9);
		//E
		stGame.TBL_Enemy[3].stat = CAR_STAT_RUN;
		stGame.TBL_Enemy[3].x = ROAD_MAX - 16;
		stGame.TBL_Enemy[3].z = PLAYER_Z + 4;
		stGame.TBL_Enemy[3].spd = ((ENEMY_SPD_MIN << 4) * 0.0) + ((ENEMY_SPD_MAX << 4) * 1.0);
		//_ŃX^[g̏Փˎ̔
		if(RND32_RANGE(seed, 0, 100) < 25) {
			int tmp = stGame.TBL_Enemy[0].spd;
			          stGame.TBL_Enemy[0].spd = stGame.TBL_Enemy[2].spd;
			                                    stGame.TBL_Enemy[2].spd = tmp;
		}
		if(RND32_RANGE(seed, 0, 100) < 25) {
			int tmp = stGame.TBL_Enemy[1].spd;
			          stGame.TBL_Enemy[1].spd = stGame.TBL_Enemy[3].spd;
			                                    stGame.TBL_Enemy[3].spd = tmp;
		}
	}
	//Q̏
	{
		static_assert(OBSTACLE_NUM >= 8, "OBSTACLE_NUM too small");
		for(i = 0; i < OBSTACLE_NUM; i++) {
			int j = 2/**/ - stGame.area_cnt + i;
			if(j >= SEG_NUM) { break; }
			stGame.TBL_Obstacle[i].kind = OBSTACLE_KIND_TREE;
			stGame.TBL_Obstacle[i].x = (i & 1) ? (ROAD_MAX + OBSTACLE_OFS) : (ROAD_MIN - OBSTACLE_OFS);
			stGame.TBL_Obstacle[i].z = SCR_Z + SEG_LEN * j;
		}
	}
}
/*--------------------------------------------------------------------------*/
static int RodObj_compar(const void* x, const void* y) {
	const ST_RodObj* px = x;
	const ST_RodObj* py = y;
	return px->base.z - py->base.z;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void addObj(int x, int y, int z, int type, void* data) {
	if(stGame.stRodStr.objNum < OBJ_NUM) {
		ST_RodObj* pRodObj = &stGame.TBL_RodObj[stGame.stRodStr.objNum++];
		pRodObj->base.x = x;
		pRodObj->base.y = y;
		pRodObj->base.z = z;
		pRodObj->type = type;
		pRodObj->data = data;
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static const ST_Level* getLevel() {
	if((stGame.level < 1) || (stGame.level > LEVEL_MAX)) { DIE(); }
	return &TBL_Level[stGame.level];
}
static int getCurveWaitMin()	{ return getLevel()->curveWaitMin; }
static int getCurveWaitMax()	{ return getLevel()->curveWaitMax; }
static int getCurveRate()	{ return getLevel()->curveRate; }
static int getCurveMin()	{ return getLevel()->curveMin; }
static int getCurveMax()	{ return getLevel()->curveMax; }
static int getCurveAddMin()	{ return getLevel()->curveAddMin; }
static int getCurveAddMax()	{ return getLevel()->curveAddMax; }
static int getSlopeWaitMin()	{ return getLevel()->slopeWaitMin; }
static int getSlopeWaitMax()	{ return getLevel()->slopeWaitMax; }
static int getSlopeRate()	{ return getLevel()->slopeRate; }
static int getSlopeMin()	{ return getLevel()->slopeMin; }
static int getSlopeMax()	{ return getLevel()->slopeMax; }
static int getSlopeAddMin()	{ return getLevel()->slopeAddMin; }
static int getSlopeAddMax()	{ return getLevel()->slopeAddMax; }
static int getObstacleWaitMin()	{ return getLevel()->obstacleWaitMin; }
static int getObstacleWaitMax()	{ return getLevel()->obstacleWaitMax; }
static int getObstacleRate()	{ return getLevel()->obstacleRate; }
static int getEnemyWaitMin()	{ return getLevel()->enemyWaitMin; }
static int getEnemyWaitMax()	{ return getLevel()->enemyWaitMax; }
static int getEnemySpdMin()	{ return getLevel()->enemySpdMin; }
static int getEnemySpdMax()	{ return getLevel()->enemySpdMax; }
static int getEnemyConcurrent()	{ return getLevel()->enemyConcurrent; }
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void hitNotify(int clash) {
//{{fobO[h
	if(debugMode) { return; }
//}}fobO[h
	if(!clash) {
		stGame.player.stat = CAR_STAT_SPIN;
		stGame.player.anm = 0;
		sound_play(0, sound_table[SND_SE_CLASH1], 1);
	} else {
		stGame.player.stat = CAR_STAT_CLASH;
		stGame.player.anm = 0;
		stGame.player.vy = 15/**/;
		stGame.player.y = stGame.player.vy;
		sound_play(0, sound_table[SND_SE_CLASH2], 1);
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void game_exec() {
	int i, save_skid, player_spd;
	//XLbh̊Ǘ
	save_skid = stGame.skid;
	            stGame.skid = 0;
	//c莞
	if(stGame.stat == GAME_STAT_RUN) {
		if(stGame.time) {
			stGame.time--;
//{{fobO[h
			if(debugMode) { if(!stGame.time) { stGame.time++; } }
//}}fobO[h
			if(stGame.time) {
				if(stGame.time <= SEC(5)) {
					if(!(stGame.time % FPS)) {
						sound_play(3, sound_table[SND_SE_WARNING], 1);
					}
				}
			}
		}
	}
	//
	{
		if(stGame.stat == GAME_STAT_RUN) {
			switch(stGame.player.stat) {
			default:DIE();
			case CAR_STAT_RUN:
				//
				{
					if((joy & PAD_B) || !stGame.time) {	//^CI[o[͎u[L
						//u[L
						stGame.player.spd -= PLAYER_BRK;
						if(stGame.player.spd < 0) {
							stGame.player.spd = 0;
						}
						if(joy & TRG_B) {
							if(!save_skid) {
								if(stGame.player.spd >= (2 << 4)/**/) {
									sound_play(1, sound_table[SND_SE_SLIP], 1);
								}
							}
						}
					} else {
						if(joy & PAD_A) {
							//ANZ
							stGame.player.spd += PLAYER_ACC;
							if(stGame.player.spd > (PLAYER_SPD_MAX << 4)) {
								stGame.player.spd = (PLAYER_SPD_MAX << 4);
							}
						} else {
							//GWu[L
							stGame.player.spd -= PLAYER_DEC;
							if(stGame.player.spd < 0) {
								stGame.player.spd = 0;
							}
						}
					}
					//It[h
					if((stGame.player.x < ROAD_MIN) ||
					   (stGame.player.x > ROAD_MAX)) {
						if(stGame.player.spd > (PLAYER_OFFROAD_MAX << 4)) {
							stGame.player.spd -= PLAYER_BRK;	//u[LƓɂB
							if(stGame.player.spd < (PLAYER_OFFROAD_MAX << 4)) {
								stGame.player.spd = (PLAYER_OFFROAD_MAX << 4);
							}
						}
					}
				}
				//Eړ
				{
					ST_RodSeg* pRodSeg;
					int enshin_ryoku, yoko_idou;
					i = (PLAYER_Z - SCR_Z + stGame.stRodStr.segOfs) / SEG_LEN;
					if((unsigned)i >= SEG_NUM) { DIE(); }
					pRodSeg = &stGame.TBL_RodSeg[i];
					enshin_ryoku = (pRodSeg->base.curve * stGame.player.spd) >> 9/**/;
					stGame.player.x -= enshin_ryoku;
					if(stGame.time) {
						int over = 0;
						yoko_idou = stGame.player.spd;
						if(yoko_idou > (PLAYER_MOVE_MAX << 4)) {	//PLAYER_MOVE_MAXȏ̑xɂȂPLAYER_MOVE_DOWN̑xłړłȂB
							yoko_idou = (PLAYER_MOVE_DOWN << 4);
							over = 1;
						}
						yoko_idou = (yoko_idou * 40/**/) >> 8;	//ȗ64̃J[ułPLAYER_MOVE_MAXȉɗƂ΋Ȃ悤ɒlłBȗ40܂łȂ΍ōłȂ܂B
						if(joy & PAD_LF) {
							stGame.player.x -= yoko_idou;
							if(enshin_ryoku <= -yoko_idou) {	//ړEւ̉S͂̕傫΁c
								if(over) {
									stGame.skid = 1;	//XLbhv
								}
							}
						} else if(joy & PAD_RI) {
							stGame.player.x += yoko_idou;
							if(enshin_ryoku >=  yoko_idou) {	//Eړւ̉S͂̕傫΁c
								if(over) {
									stGame.skid = 1;	//XLbhv
								}
							}
						}
					}
					stGame.player.x = clamp((int)stGame.player.x, ROAD_MIN - OBSTACLE_OFS, ROAD_MAX + OBSTACLE_OFS);
				}
				adpcm_rate(0, 4000 + 12000 * stGame.player.spd / (PLAYER_SPD_MAX << 4));
				break;
			case CAR_STAT_SPIN:
				//Eړ
				{
					ST_RodSeg* pRodSeg;
					int enshin_ryoku;
					i = (PLAYER_Z - SCR_Z + stGame.stRodStr.segOfs) / SEG_LEN;
					if((unsigned)i >= SEG_NUM) { DIE(); }
					pRodSeg = &stGame.TBL_RodSeg[i];
					enshin_ryoku = (pRodSeg->base.curve * stGame.player.spd) >> 9/**/;
					stGame.player.x -= enshin_ryoku;
					stGame.player.x = clamp((int)stGame.player.x, ROAD_MIN - OBSTACLE_OFS, ROAD_MAX + OBSTACLE_OFS);
				}
				{
					stGame.player.spd -= PLAYER_BRK;
					if(stGame.player.spd <= 0) {
						stGame.player.spd = 0;
						if(stGame.player.anm < SEC(1.5)) {
							stGame.player.spd = 1;	//Q[I[o[}
						}
					}
					if(stGame.player.spd >= (1 << 4)) {
						if(!(now & 3)) {
							if(stGame.player.z < PLAYER_Z + SEG_LEN * 2) {
								stGame.player.z++;
							}
						}
					}
					stGame.player.anm++;
					if(stGame.player.anm >= SEC(1.5)) {
						stGame.player.anm = SEC(1.5);
						if(stGame.time) {
							memset(&stGame.player, 0, sizeof stGame.player);
							stGame.player.stat = CAR_STAT_RUN;
							stGame.player.z = PLAYER_Z;
							sound_play(0, sound_table[SND_SE_ENGINE], -1);
							adpcm_rate(0, 4000 + 12000 * stGame.player.spd / (PLAYER_SPD_MAX << 4));
						}
					}
				}
				break;
			case CAR_STAT_CLASH:
				//Eړ
				{
					ST_RodSeg* pRodSeg;
					int enshin_ryoku;
					i = (PLAYER_Z - SCR_Z + stGame.stRodStr.segOfs) / SEG_LEN;
					if((unsigned)i >= SEG_NUM) { DIE(); }
					pRodSeg = &stGame.TBL_RodSeg[i];
					enshin_ryoku = (pRodSeg->base.curve * stGame.player.spd) >> 9/**/;
					stGame.player.x -= enshin_ryoku;
					stGame.player.x = clamp((int)stGame.player.x, ROAD_MIN - OBSTACLE_OFS, ROAD_MAX + OBSTACLE_OFS);
				}
				{
					if(stGame.player.vy || stGame.player.y) {
						stGame.player.vy -= 1/**/;
						stGame.player.y += stGame.player.vy;
						if((stGame.player.vy < 0) && (stGame.player.y <= 0)) {
							stGame.player.y = -stGame.player.y;
							stGame.player.vy = -stGame.player.vy;
							stGame.player.vy = (stGame.player.vy * 192/**/) >> 8;
							if(stGame.player.vy <= 6/**/) {
								stGame.player.vy = 0;
								stGame.player.y = 0;
							}
							sound_play(0, sound_table[SND_SE_CLASH2], 1);
						}
						if(now & 1) {
							stGame.player.anm++;
							if(stGame.player.z < PLAYER_Z + SEG_LEN * 2) {
								stGame.player.z++;
							}
						}
					}
					if(!stGame.player.vy) {
						stGame.player.spd -= PLAYER_BRK;
						if(stGame.player.spd < 0) {
							stGame.player.spd = 0;
						}
						if((stGame.player.anm & 7) != 3) {
							if(now & 1) {
								stGame.player.anm++;
							}
						} else if(!stGame.player.spd) {
							if(stGame.time) {
								memset(&stGame.player, 0, sizeof stGame.player);
								stGame.player.stat = CAR_STAT_RUN;
								stGame.player.z = PLAYER_Z;
								sound_play(0, sound_table[SND_SE_ENGINE], -1);
								adpcm_rate(0, 4000 + 12000 * stGame.player.spd / (PLAYER_SPD_MAX << 4));
							}
						}
					}
				}
				break;
			}
		}
		player_spd = stGame.player.spd >> 4;
	}
	//G
	{
		for(i = 0; i < ENEMY_NUM; i++) {
			ST_Car* pCar = &stGame.TBL_Enemy[i];
			if(pCar->stat) {
				int enemy_spd = ((pCar->spd * stGame.enemy_spd_rate) >> (4 + 4)) - player_spd;	//Αx
				int save_z = pCar->z;
				pCar->z += enemy_spd;
				switch(pCar->stat) {
				default:DIE();
				case CAR_STAT_RUN:
					if(enemy_spd <= 0) {		//GԂ̕x(ʂ͂)
						if(stGame.player.stat == CAR_STAT_RUN) {	//vC[ɃXsNbVłȂc		stGame.time͌ȂB^CI[o[łXsNbVւ̈ڍs͍sB
							if((save_z  >  PLAYER_Z) &&
							   (pCar->z <= PLAYER_Z)) {
								if(abs(stGame.player.x - pCar->x) < 24/**/) {
									hitNotify(abs(enemy_spd) > 2/**/);
									//GԂXsB
									pCar->stat = CAR_STAT_SPIN;
									pCar->anm = 0;
									pCar->spd = stGame.player.spd;
									pCar->vx = (pCar->x >= stGame.player.x) ? 4/**/ : -4/**/;
								} else {
									if(stGame.stat == GAME_STAT_RUN) {
										sound_play(2, sound_table[SND_SE_PASS], 1);
										stGame.score += 100;
									}
								}
							}
						}
						if(pCar->z < SCR_Z) {
							pCar->stat = 0;
						}
					} else if(enemy_spd > 0) {	//GԂ̕
						if(stGame.player.stat == CAR_STAT_RUN) {	//vC[ɃXsNbVłȂc		stGame.time͌ȂB^CI[o[łXsNbVւ̈ڍs͍sB
							if((save_z  <  PLAYER_Z) &&
							   (pCar->z >= PLAYER_Z)) {
								if(abs(stGame.player.x - pCar->x) < 24/**/) {
								    //{{ǂăNbV͂܂NȂ̂ŏȗB
								    //	hitNotify(abs(enemy_spd) > 2/**/);
								    //	//GԂXsB
								    //	pCar->stat = CAR_STAT_SPIN;
								    //	pCar->anm = 0;
								    //	pCar->spd = player_spd;
								    //}}ǂăNbV͂܂NȂ̂ŏȗB
								} else {
									if(stGame.enemy_spd_rate == 16) {	//Q[JnɏzuG҂ǂčs͉炳ȂɂBɃC[vŃPbgX^[g炵Ă܂B
										if(stGame.stat == GAME_STAT_RUN) {
											sound_play(2, sound_table[SND_SE_PASS], 1);
										}
									}
								}
							}
						}
						if(pCar->z > SCR_Z + SEG_LEN * SEG_NUM) {
							pCar->stat = 0;
						}
					}
					//Gԁ˓GԏՓ
					if(pCar->stat == CAR_STAT_RUN) {	//̏ł܂Փ˂łĂȂ΁c
						int j;
						for(j = i + 1; j < ENEMY_NUM; j++) {
							ST_Car* pCar2 = &stGame.TBL_Enemy[j];
							if(pCar2->stat == CAR_STAT_RUN) {
								if(abs(pCar2->x - pCar->x) < 24/**/) {
									if(abs(pCar2->z - pCar->z) <= 1/**/) {
										pCar->stat = CAR_STAT_SPIN;
										pCar->anm = 0;
										pCar->vx = (pCar->x >= pCar2->x) ? 4/**/ : -4/**/;
										pCar2->stat = CAR_STAT_SPIN;
										pCar2->anm = 0;
										pCar2->vx = -pCar->vx;
										break;	//܂
									}
								}
							}
						}
					}
					break;
				case CAR_STAT_SPIN:
					//Eړ
					{
						pCar->x += pCar->vx;
						pCar->x = clamp((int)pCar->x, ROAD_MIN - OBSTACLE_OFS, ROAD_MAX + OBSTACLE_OFS);
					}
					{
						if((pCar->x < ROAD_MIN) ||
						   (pCar->x > ROAD_MAX)) {
							pCar->spd -= PLAYER_BRK;
						} else {
							pCar->spd -= PLAYER_DEC;
						}
						if(pCar->spd < 0) {
							pCar->spd = 0;
						}
						pCar->anm++;
						if(pCar->anm >= SEC(1.5)) {
							pCar->anm = SEC(1.5);
						}
					}
					if(enemy_spd <= 0) {		//GԂ̕x(ʂ͂)
						if(pCar->z < SCR_Z) {
							pCar->stat = 0;
						}
					} else if(enemy_spd > 0) {	//GԂ̕
						if(pCar->z > SCR_Z + SEG_LEN * SEG_NUM) {
							pCar->stat = 0;
						}
					}
					break;
			//	case CAR_STAT_CLASH:	GԂ̓NbVȂ͂B
				}
			}
		}
	}
	//Q
	{
		for(i = 0; i < OBSTACLE_NUM; i++) {
			ST_Obstacle* pObstacle = &stGame.TBL_Obstacle[i];
			if(pObstacle->kind) {
				int save_z = pObstacle->z;
				pObstacle->z -= player_spd;
				if(stGame.player.stat == CAR_STAT_RUN) {	//vC[ɃXsNbVłȂc		stGame.time͌ȂB^CI[o[łXsNbVւ̈ڍs͍sB
					if((save_z       >  PLAYER_Z) &&
					   (pObstacle->z <= PLAYER_Z)) {
						if(((pObstacle->x < 0) && (stGame.player.x <= (ROAD_MIN - OBSTACLE_OFS / 2))) ||	//QŁAvC[֔ȏI[o[Ă邩A
						   ((pObstacle->x > 0) && (stGame.player.x >= (ROAD_MAX + OBSTACLE_OFS / 2)))) {	//EQŁAvC[E֔ȏI[o[Ăc
							hitNotify(player_spd > 5/**/);
						}
					}
				}
				if(pObstacle->z < SCR_Z) {
					pObstacle->kind = 0;
				}
			}
		}
	}
	//ZOg
	{
		//Ԃ̑x̕AԂ֓B
		stGame.stRodStr.segOfs += player_spd;
		//ԎÕZOgAJSɎOłԁc
		while(stGame.stRodStr.segOfs >= SEG_LEN) {
			ST_RodSeg* pRodSeg = stGame.TBL_RodSeg;
			//ZOgŜOւ炷B
			for(i = 0; i < SEG_NUM - 1; i++) {
				*pRodSeg = *(pRodSeg + 1);
				pRodSeg++;
			}
			//ZOgŜOւ炵AZOgItZbg߂B
			stGame.stRodStr.segOfs -= SEG_LEN;
			//ԉɐVZOg𐶐B
			{
				//J[u
				{
					//̖ڕWJ[uɓBĂȂ΁c
					if(pRodSeg->base.curve < stGame.curve_target) {
						//VZOg̃J[u𑝉āAڕWɓBc
						if((pRodSeg->base.curve += stGame.curve_add) >= stGame.curve_target) {
							pRodSeg->base.curve = stGame.curve_target;
							//݂̃J[üێԂݒ肷B
							stGame.curve_wait = RND32_RANGE(seed,
								getCurveWaitMin(),
								getCurveWaitMax() + 1);
						}
					//̖ڕWJ[uɓBĂȂ΁c
					} else if(pRodSeg->base.curve > stGame.curve_target) {
						//VZOg̃J[uāAڕWɓBc
						if((pRodSeg->base.curve -= stGame.curve_add) <= stGame.curve_target) {
							pRodSeg->base.curve = stGame.curve_target;
							//݂̃J[üێԂݒ肷B
							stGame.curve_wait = RND32_RANGE(seed,
								getCurveWaitMin(),
								getCurveWaitMax() + 1);
						}
					//ڕWJ[uɓBĂc
					} else {
						//ێԂ炵0ȉɂȂc
						if(--stGame.curve_wait <= 0) {
							stGame.curve_wait = 0;
							//ڕWJ[uݒ肷B
							{
								if(RND32_RANGE(seed, 0, 100) < getCurveRate()) {
									stGame.curve_target = RND32_RANGE(seed,
										getCurveMin(),
										getCurveMax() + 1);
									if(pRodSeg->base.curve < 0) {			//݂}CiXȂ΁c
										if(RND32_RANGE(seed, 0, 100) < 33) {	//33%Ń}CiXɂB
											stGame.curve_target = -stGame.curve_target;
										}
									} else if(pRodSeg->base.curve > 0) {		//݂vXȂ΁c
										if(RND32_RANGE(seed, 0, 100) < 67) {	//67%Ń}CiXɂB
											stGame.curve_target = -stGame.curve_target;
										}
									} else {					//݂0Ȃ΁c
										if(RND32_RANGE(seed, 0, 100) < 50) {	//50%Ń}CiXɂB
											stGame.curve_target = -stGame.curve_target;
										}
									}
								} else {
									stGame.curve_target = 0;
								}
								stGame.curve_add = RND32_RANGE(seed,
									getCurveAddMin(),
									getCurveAddMax() + 1);
							}
						}
					}
				}
				//X[v
				{
					//̖ڕWX[vɓBĂȂ΁c
					if(pRodSeg->base.slope < stGame.slope_target) {
						//VZOg̃X[v𑝉āAڕWɓBc
						if((pRodSeg->base.slope += stGame.slope_add) >= stGame.slope_target) {
							pRodSeg->base.slope = stGame.slope_target;
							//݂̃X[v̈ێԂݒ肷B
							stGame.slope_wait = RND32_RANGE(seed,
								getSlopeWaitMin(),
								getSlopeWaitMax() + 1);
						}
					//̖ڕWX[vɓBĂȂ΁c
					} else if(pRodSeg->base.slope > stGame.slope_target) {
						//VZOg̃X[vāAڕWɓBc
						if((pRodSeg->base.slope -= stGame.slope_add) <= stGame.slope_target) {
							pRodSeg->base.slope = stGame.slope_target;
							//݂̃X[v̈ێԂݒ肷B
							stGame.slope_wait = RND32_RANGE(seed,
								getSlopeWaitMin(),
								getSlopeWaitMax() + 1);
						}
					//ڕWX[vɓBĂc
					} else {
						//ێԂ炵0ȉɂȂc
						if(--stGame.slope_wait <= 0) {
							stGame.slope_wait = 0;
							//ڕWX[vݒ肷B
							{
								if(RND32_RANGE(seed, 0, 100) < getSlopeRate()) {
									stGame.slope_target = RND32_RANGE(seed,
										getSlopeMin(),
										getSlopeMax() + 1);
									if(pRodSeg->base.slope < 0) {			//݂}CiXȂ΁c
										if(RND32_RANGE(seed, 0, 100) < 25) {	//25%Ń}CiXɂB
											stGame.slope_target = -stGame.slope_target;
										}
									} else if(pRodSeg->base.slope > 0) {		//݂vXȂ΁c
										if(RND32_RANGE(seed, 0, 100) < 75) {	//75%Ń}CiXɂB
											stGame.slope_target = -stGame.slope_target;
										}
									} else {					//݂0Ȃ΁c
										if(RND32_RANGE(seed, 0, 100) < 50) {	//50%Ń}CiXɂB
											stGame.slope_target = -stGame.slope_target;
										}
									}
								} else {
									stGame.slope_target = 0;
								}
								stGame.slope_add = RND32_RANGE(seed,
									getSlopeAddMin(),
									getSlopeAddMax() + 1);
							}
						}
					}
				}
				//ZOg̐F݂ɂB
				pRodSeg->road ^= 1;
			}
			//ԉɐVQ𐶐B
			{
				int kind_l = 0, kind_r = 0;
				if(--stGame.obstacle_wait <= 0) {
					if(RND32_RANGE(seed, 0, 100) < getObstacleRate()) {
						stGame.obstacle_mode = RND32_RANGE(seed,
							1,
							OBSTACLE_MODE_MAX + 1);
					} else {
						stGame.obstacle_mode = 0;
					}
					stGame.obstacle_wait = RND32_RANGE(seed,
						getObstacleWaitMin(),
						getObstacleWaitMax() + 1);
				}
				switch(stGame.obstacle_mode) {
				default:DIE();
				case 0:
					/** no job */
					break;
				case OBSTACLE_MODE_TREE_L:
					kind_l = OBSTACLE_KIND_TREE;
					break;
				case OBSTACLE_MODE_TREE_R:
					kind_r = OBSTACLE_KIND_TREE;
					break;
				case OBSTACLE_MODE_TREE_LR:
					kind_l = OBSTACLE_KIND_TREE;
					kind_r = OBSTACLE_KIND_TREE;
					break;
				case OBSTACLE_MODE_SIGNBOARD_L:
					kind_l = OBSTACLE_KIND_SIGNBOARD;
					break;
				case OBSTACLE_MODE_SIGNBOARD_R:
					kind_r = OBSTACLE_KIND_SIGNBOARD;
					break;
				case OBSTACLE_MODE_SIGNBOARD_LR:
					kind_l = OBSTACLE_KIND_SIGNBOARD;
					kind_r = OBSTACLE_KIND_SIGNBOARD;
					break;
				case OBSTACLE_MODE_TREE_SIGNBOARD:
					kind_l = OBSTACLE_KIND_TREE;
					kind_r = OBSTACLE_KIND_SIGNBOARD;
					break;
				case OBSTACLE_MODE_SIGNBOARD_TREE:
					kind_l = OBSTACLE_KIND_SIGNBOARD;
					kind_r = OBSTACLE_KIND_TREE;
					break;
				}
				//Ղ̂߂ɁA[XQ[g̑O1ZOgɂ͏Q𐶐ȂɂB
				{
					int area_cnt = (stGame.area_cnt + (SEG_NUM - 1)) % AREA_LEN;
					if((area_cnt >= AREA_LEN - 1) ||
					   (area_cnt <=            1)) {
						/** no job **/
					} else {
						if(pRodSeg->road & 1) {
							if(kind_r) { addObstacle(kind_r, 1/*E*/); }
						} else {
							if(kind_l) { addObstacle(kind_l, 0/**/); }
						}
					}
				}
			}
			//XRAZB
			stGame.score++;		//2f1segi񂾂ƂāA1sec15ptsB10V񂾂ƂāA600*15=9000ptsB̓_lĂA܂S낤B
			//GAJE^i߂B
			if(++stGame.area_cnt == AREA_LEN) {	//`FbN|Cg𒴂c
				//GAJE^ZbgB
				stGame.area_cnt = 0;
			//{{
			//	//c莞ԂZbgB	Zł͂ȂZbg鎖ɂBZƍŏ̊̕ȒPȃXe[WŎc莞Ԃ҂Ă܂̂ŁB
			//	stGame.time = AREA_TIME;
			//
			//	//c莞ԂZB		ςZ鎖ɂ܂B
				stGame.time += AREA_TIME;
				if(stGame.time > SEC(60)) { stGame.time = SEC(60); }
			//}}
				stGame.extend_play = SEC(1);
				sound_play(3, sound_table[SND_SE_EXTEND], 1);
				//x𑝂₷B
				if(stGame.level < LEVEL_MAX) {
					stGame.level++;
//{{fobO[h
					if(debugMode) { stGame.level--; }
//}}fobO[h
				}
			}
		}
	}
	//G
	if(--stGame.enemy_wait <= 0) {
		int n = RND32_RANGE(seed,
			1,
			getEnemyConcurrent() + 1);
		for(i = 0; i < n; i++) {
			addEnemy(RND32_RANGE(seed,
				(getEnemySpdMin() << 4),
				(getEnemySpdMax() << 4) + 1));
		}
		stGame.enemy_wait = RND32_RANGE(seed,
			getEnemyWaitMin(),
			getEnemyWaitMax() + 1);
	}
	//wi
	stGame.bgd_x -= stGame.TBL_RodSeg[0].base.curve * player_spd >> 6/**/;
	stGame.bgd_x &= 127;
	stGame.bgd_y  = stGame.TBL_RodSeg[0].base.slope              >> 1/**/;
	//XLbh̊Ǘ
	if(stGame.skid != save_skid) {
		if(stGame.skid) {
			sound_play(1, sound_table[SND_SE_SLIP], -1);
		} else {
			sound_stop(1);
		}
	}
	//nCXRAXV
	if(stGame.score > hiscore) { hiscore = stGame.score; }
	//GNXehvC
	if(stGame.extend_play) { stGame.extend_play--; }
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void game_draw() {
	int i;
	//NA
	stGame.stRodStr.objNum = 0;
	//[XQ[g
	{
		int area_cnt = stGame.area_cnt;
		int z = SCR_Z - stGame.stRodStr.segOfs;
		for(i = 0; i < SEG_NUM; i++) {
			if(!area_cnt) {
				addObj(0,
				       0,
				       z,
				       OBJ_TYPE_RACEGATE, NULL);
			}
			if(++area_cnt == AREA_LEN) { area_cnt = 0; }
			z += SEG_LEN;
		}
	}
	//
	{
		ST_Car* pCar = &stGame.player;
		addObj(pCar->x,
		       pCar->y,
		       pCar->z,
		       OBJ_TYPE_PLAYER, pCar);
	}
	//G
	{
		for(i = 0; i < ENEMY_NUM; i++) {
			ST_Car* pCar = &stGame.TBL_Enemy[i];
			if(pCar->stat) {
				addObj(pCar->x,
				       pCar->y,
				       pCar->z,
				       OBJ_TYPE_ENEMY, pCar);
			}
		}
	}
	//Q
	{
		for(i = 0; i < OBSTACLE_NUM; i++) {
			ST_Obstacle* pObstacle = &stGame.TBL_Obstacle[i];
			if(pObstacle->kind) {
				addObj(pObstacle->x,
				       0,
				       pObstacle->z,
				       OBJ_TYPE_OBSTACLE, pObstacle);
			}
		}
	}
	//\[g
	qsort(stGame.TBL_RodObj, stGame.stRodStr.objNum, sizeof stGame.TBL_RodObj[0], RodObj_compar);
	//`
	stGame.stRodStr.camX =  stGame.player.x;
	stGame.stRodStr.camY = (stGame.player.y >> 1) + CAM_Y;
	RodStr_Draw(&stGame.stRodStr);
	//XRA
	score_draw();
	//[^[
	meter_draw();
	//GNXehvC
	if(stGame.extend_play) {
		render_printf_framed(&render,
			37,
			17,
			0,
			0x330,
			"EXTEND PLAY");
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void game_run() {
	int i;
	//
	game_init();
	//JEg_E
	sound_play(0, sound_table[SND_SE_ENGINE], -1);
	adpcm_rate(0, 4000 + 12000 * stGame.player.spd / (PLAYER_SPD_MAX << 4));
	for(i = SEC(3.5); i; i--) {
		schedule();
		if(joy & TRG_SELECT) { return; }
		game_exec();
		game_draw();
		if(i <= SEC(3)) {
			render_printf_framed(&render,
				58,
				14,
				1,
				0x330,
				"%d",
				(i + (FPS - 1)) / FPS);
			if(!(i % FPS)) {
				sound_play(3, sound_table[SND_SE_COUNT], 1);
			}
		}
	}
	sound_play(2, sound_table[SND_SE_ROCKET], 1);
	stGame.stat = GAME_STAT_RUN;
	for(;;) {
		schedule();
		if(joy & TRG_SELECT) { return; }
		if(stGame.enemy_spd_rate < 16) { stGame.enemy_spd_rate++; }
		game_exec();
		game_draw();
		if(!stGame.time && !stGame.player.spd) { break; }	//ԂȂȂāAԂSɎ~܂AQ[I[o[BԂȂȂĂAŃ`FbN|Cg𒴂\̂ŁAQ[I[o[ɂ͂ȂɒӂB
	}
	stGame.stat = GAME_STAT_GAMEOVER;
	for(i = 0; i < SEC(5); i++) {
		schedule();
		if(joy & TRG_SELECT) { return; }
		if((i >= SEC(2)) && (joy & TRG_AB)) { break; }
		game_exec();
		game_draw();
		render_printf_framed(&render,
			42,
			17,
			0,
			0x330,
			"GAME OVER");
	}
}
/****************************************************************************
 *	demo_run
 ****************************************************************************/
void demo_run() {
	int i, start = 0;
//{{fobO[h
	debugMode = 0;
//}}fobO[h
	for(i = 0; i < SOUND_MAXCH; i++) { sound_stop(i); }
	for(;;) {
		schedule();
		if(!start) {	//JnOȂ΁c
			if(joy & TRG_SELECT) { exit(EXIT_SUCCESS); }
		} else {	//JnȂ΁c
			if(++start >= SEC(1.5)) { break; }
		}
		//wi
		sprite_draw(
			-((now >> 2) & 127),
			0,
			SPR_BGD,
			DRW_NOMAL);
		sprite_draw(
			-((now >> 2) & 127) + 128,
			0,
			SPR_BGD,
			DRW_NOMAL);
		//XRA
		score_draw();
		//^Cg
		sprite_draw(
			4,
			20,
			SPR_TTL,	//h=16
			DRW_NOMAL);
		//xI
		if(!start) {	//JnOȂ΁c
			if((level_sel >  1) && (joy & TRG_LF)) {
				level_sel--;
				sound_play(3, sound_table[SND_SE_CURSOR], 1);
			}
			if((level_sel < LEVEL_MAX) && (joy & TRG_RI)) {
				level_sel++;
				sound_play(3, sound_table[SND_SE_CURSOR], 1);
			}
		}
		render_printf_framed(&render,
			(DISP_X - 4 * 19) / 2,
			48,
			4,
			0x330,
			"%c LEVEL SELECT %2d %c",
			(!start && (level_sel >         1)) ? '<' : ' ',	//JnOAAɍŏłȂ΁c
			 level_sel,
			(!start && (level_sel < LEVEL_MAX)) ? '>' : ' ');	//JnOAAɍőłȂ΁c
		//vvg
		if(!start) {	//JnOȂ΁c
			if(joy & TRG_AB) {
				start++;
				sound_play(3, sound_table[SND_SE_START], 1);
//{{fobO[h
				if((joy & PAD_DN) && (joy & PAD_B)) { debugMode = 1; }	//DnBDeBugɊ|Ă܂(^^;
//}}fobO[h
			}
		}
		if((!start && (now % SEC(1.0)) < SEC(0.5)) ||	//JnOȂ΁Aᑬ_łB
		   ( start && (start & 2))) {			//JnȂ΁A_łB
			render_printf_framed(&render,
				(DISP_X - 4 * 23) / 2,
				65,
				4,
				0x330,
				"PRESS A BUTTON TO START");
		}
	}
}
/****************************************************************************
 *	app_main
 ****************************************************************************/
int app_main(int argc, char* argv[]) {
//{{BR}hBBȂNƓdr\BfobOɓdr\₷悤ɂ邽߂łB
	delay(1);
	if(joy & PAD_B) {
		pceWaveSetMasterAtt(0);
		pcePowerSetReport(PWR_RPTOFF);
	}
//}}BR}hBBȂNƓdr\BfobOɓdr\₷悤ɂ邽߂łB
	sound_att(0, 12);	//
	sound_att(1, 12);	//fނ̉傫āÂ܂܂ł͕ɖƉꂵ̂ŁA{[B
	sound_att(2, 12);	//
	sound_att(3, 8);	//
	for(;;) {
		demo_run();
		game_run();
	}
	return EXIT_SUCCESS;
}
