#include "app.h"
/****************************************************************************
 *	[Jϐ
 ****************************************************************************/
//{{2016/08/21ǉ:'-e'IvVǉ܂B
//'-e'IvṼTuIvV
enum {
	OPT_E_HITVAL,		//-ehitval	Il(hitVal)w\ƌȂĕ\B
	OPT_E_COLUMN_ID,	//-ecolumn_id	Iid(column_id)w\ƌȂĕ\B
	OPT_E_WEIGHT,		//-eweight	Il(weight)w\ƌȂĕ\B
	//
	OPT_E_ALL,		//-eall		L̑SĂw\ƌȂĕ\B
};
static const char* const opt_e_tokens[]={
	"hitval",
	"column_id",
	"weight",
	//
	"all",
NULL};//I[
static int opt_e;	//(1<<OPT_E_HITVAL),(1<<OPT_E_COLUMN_ID),(1<<OPT_E_ALL)́A0ȏ̑gݍ킹
//}}2016/08/21ǉ:'-e'IvVǉ܂B
/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
__declspec(noreturn) static void usage();
static void dumpLotTbl(int indent, const int* TBL_LotTblNo/*[LotTblNo_Max+1]*/);
/****************************************************************************
 *	
 ****************************************************************************/
int main(int argc, char* argv[]) {
	FILE* fp;
	void* buf;
	int opt, len;
	//R}hCIvVB
	opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
	while((opt = getopt(argc, argv, "e::h")) != -1) {
		switch(opt) {
//{{2016/08/21ǉ:'-e'IvVǉ܂B
		case 'e':
			if(optarg) {
				char *optionp = optarg, *valuep;
				while(*optionp) {
					int subopt = getsubopt(&optionp, (char* const*)opt_e_tokens, &valuep);
					if(valuep) { usage(); }
					switch(subopt) {
					case OPT_E_HITVAL:	//-ehitval	Il(hitVal)w\ƌȂĕ\B
					case OPT_E_COLUMN_ID:	//-ecolumn_id	Iid(column_id)w\ƌȂĕ\B
					case OPT_E_WEIGHT:	//-eweight	Il(weight)w\ƌȂĕ\B
						opt_e |= (1<<subopt);
						break;
					case OPT_E_ALL:		//-eall		L̑SĂw\ƌȂĕ\B
						opt_e |= -1;
						break;
					default:
						usage();
					}
				}
			} else {
				opt_e |= (1<<OPT_E_WEIGHT);	//-e		-eweightƓłB(-eallƓł͂ȂɒӂĉBw\i[̂͒Ilł鎖قƂǂƎv̂ŁA-ẽftHg-eweightƓƂ鎖ɂ܂B)
			}
			break;
//}}2016/08/21ǉ:'-e'IvVǉ܂B
		case 'h':
		default:
			usage();
		}
	}
	//Ie[ũoCif[^ǂݍށB
	if(optind != (argc - 1)) { usage(); }	//̐s
	fp = fopen(argv[optind], "rb");
//{{2016/05/28ǉ:t@CI[vG[YĂoOC܂B
	if(!fp) { error(EXIT_FAILURE, errno, "%s J܂B", argv[optind]); }
//}}2016/05/28ǉ:t@CI[vG[YĂoOC܂B
	fseek(fp, 0, SEEK_END);
	len = ftell(fp);
	rewind(fp);
	buf = malloc(len);
	if(!buf) { DIE(); }	//s
	fread(buf, 1, len, fp);
	fclose(fp);
	//Ie[u_vB
	dumpLotTbl(0, buf);
	return EXIT_SUCCESS;
}
/*---------------------------------------------------------------------------*/
__declspec(noreturn) static void usage() {
	fprintf(stderr, "dLotTblD - Ie[utRpC (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2015-2017 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  dLotTblD [option] LotTbl.bin\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
	fprintf(stderr, "  -ehitval     IlAw\ƌȂĕ\܂B\n");
	fprintf(stderr, "  -ecolumn_id  IidAw\ƌȂĕ\܂B\n");
	fprintf(stderr, "  -eweight     IlAw\ƌȂĕ\܂B\n");
	fprintf(stderr, "  -eall        '-ehitval,column_id,weight'ƓłB\n");
	fprintf(stderr, "  -e           '-eweight'ƓłB\n");
	fprintf(stderr, "  -h           g\܂B\n");
	exit(EXIT_FAILURE);
}
/*--------------------------------------------------------------------------*/
static void dumpLotTbl(int indent, const int* TBL_LotTblNo/*[LotTblNo_Max+1]*/) {
	const int nLotTblNo = TBL_LotTblNo[0];								//(I\ԍ̍ől+1)擾B
	int iLotTblNo;
	for(iLotTblNo = 1; iLotTblNo < nLotTblNo; iLotTblNo++) {
		ST_Worksheet* wsHead = Worksheet_new();
		ST_Worksheet* wsBody = Worksheet_new();
		ST_Worksheet_Iterator it;
		const unsigned short* pLotTbl = (const unsigned short*)&TBL_LotTblNo[nLotTblNo];	//I\f[^ւ̃|C^߂B(I\AhXe[u̒ɒI\f[^zuO)
		const unsigned short* table = &pLotTbl[TBL_LotTblNo[iLotTblNo]];			//I\ւ̃|C^߂B
		const int table_size = *table++;							//I\̗
		const int id_size    = *table++;							//Iids
		int column_size, i_column, i_row, i_id, id, hitval, weight;
		printf(":`%05u\n", iLotTblNo);								//o:I\id		RpCɁAiLotTblNȍŌ̒I\idɈv悤A0߂5ɑĂBȂƁAf[^̒IlƂĒI\idăNĂ镔ARpCɂĂ܂B
		for(i_column = 0; i_column < table_size; i_column++) {
			for(i_id = 0; i_id < id_size; i_id++) {
				id = *table++;
				Worksheet_set_l(wsHead, id, i_id, i_column, -1);			//(Iidsԍ,ԍ)˒Iid
			}
			column_size = *table++;								//I̗vf
			for(i_row = 0; i_row < column_size; i_row++) {
				hitval = *table++;							//Il
				weight = *table++ + 1;							//Il
				Worksheet_set_l(wsBody, weight, hitval, i_column, -1);			//(Il,ԍ)˒Il
			}
		}
//{{2016/08/21폜:2016/07/18ɁA/clip/clipwkst.h̑啝ȕύXsAWorksheet_sort()p~ɔAc[Worksheet_sort()̌Ăяo폜܂B
//		Worksheet_sort(wsHead);
//		Worksheet_sort(wsBody);
//}}2016/08/21폜:2016/07/18ɁA/clip/clipwkst.h̑啝ȕύXsAWorksheet_sort()p~ɔAc[Worksheet_sort()̌Ăяo폜܂B
		for(i_id = 0; i_id < id_size; i_id++) {
			printf("id", hitval);								//o:'id'
			for(i_column = 0; i_column < table_size; i_column++) {
				id = Worksheet_get_l(wsHead, i_id, i_column, -1);			//(Iidsԍ,ԍ)
//{{2016/08/21ύX:'-e'IvVǉ܂B
//				printf("\t,%u", id);							//o:Iid
//2016/08/21ύX:'-e'IvVǉ܂B
				//'-ecolumn_id'IvVw肳Ăc
				if(opt_e & (1<<OPT_E_COLUMN_ID)) {
					//IidAw\ƌȂĕ\܂B
					printf("\t,%u", Exp10_Decode(id));				//o:Iid		w\
				//'-ecolumn_id'IvVw肳ĂȂ΁c
				} else {
					//IidÂ܂ܕ\܂B
					printf("\t,%u", id);						//o:Iid
				}
//}}2016/08/21ύX:'-e'IvVǉ܂B
			}
			printf("\n");
		}
		for(hitval = Worksheet_first_l(wsBody, &it, -1);
		    hitval != -1;
		    hitval = Worksheet_next(&it)) {
//{{2016/08/21ύX:'-e'IvVǉ܂B
//			printf("%u", hitval);								//o:Il
//2016/08/21ǉ:'-e'IvVǉ܂B
			//'-ehitval'IvVw肳Ăc
			if(opt_e & (1<<OPT_E_HITVAL)) {
				//IlAw\ƌȂĕ\܂B
				printf("%u", Exp10_Decode(hitval));					//o:Il		w\
			//'-eweight'IvVw肳ĂȂ΁c
			} else {
				//IlÂ܂ܕ\܂B
				printf("%u", hitval);							//o:Il
			}
//}}2016/08/21ǉ:'-e'IvVǉ܂B
			for(i_column = 0; i_column < table_size; i_column++) {
				weight = Worksheet_get_l(wsBody, hitval, i_column, -1);			//(Il,ԍ)
//{{2016/08/21ǉ:'-e'IvVǉ܂B
//				printf("\t,%u", weight);						//o:Il
//2016/08/21ǉ:'-e'IvVǉ܂B
				//'-eweight'IvVw肳Ăc
				if(opt_e & (1<<OPT_E_WEIGHT)) {
					//w\ƂăfR[h\ȒlłȂ΁c
					// - w\ƂĊi[ĂȂlAw\Ƃĕ\悤ƂꍇɁA肪\LB
					//   w\͈̔͂0`65535ł邪AIl͈̔͂0`65536łA65536w\ƂăfR[h悤ƂƁAExp10_Decode()G[~Ă܂B
					//   ̖邽߂ɁA65536Ȃ'#N/A'\鎖ɂB
					if(weight == 65536) {
						//'#N/A'\܂B
						printf("\t,#N/A");					//o:Il		w\ƂĖȒl
					//w\ƂăfR[h\ȒlȂ΁c
					} else {
						//IlAw\ƌȂĕ\܂B
						printf("\t,%u", Exp10_Decode(weight));			//o:Il		w\
					}
				//'-eweight'IvVw肳ĂȂ΁c
				} else {
					//IlÂ܂ܕ\܂B
					printf("\t,%u", weight);					//o:Il
				}
//}}2016/08/21ǉ:'-e'IvVǉ܂B
			}
			printf("\n");
		}
		printf("\n");
	}
}
