;******************************************************************************
;*	COPYRIGHT (C), 1999 SEIKO EPSON CORP.
;*  ALL RIGHTS RESERVED
;*
;*	File: SIN.S
;*
;*	C Standard Library Function "sin"
;*	The "sin" function calculates the sine of x which is radian.
;*
;*	Revision History
;*	12/08/1999	Created by H.Ishida
;*	10/25/2016	Modified by Naoyuki Sawa
;*			- P/ECEJtsin()́AwI[o[t[鉉ZOɍ݂ƁAsin()֐̌ʂsɂȂBxƂoOL̂ŁAC܂B
;*			  u\cc33\UTILITY\lib_src\ansilib33\math\src\sin.svRs[āAsύXłBύXӏ́Au;//{{2016/10/25`vň͂łB
;*			- Asin.sRpCɂmathf.defKvȂ̂ŁAmathf.defu\cc33\UTILITY\lib_src\ansilib33\math\src\mathf.defvRs[܂B
;*			  mathf.def͌̂܂܂ŁAؕύXĂ܂B
;******************************************************************************
;
; --- Format of floating point (double precision) ---
;
;  63|62         52|51               32|31                                0
;   -----------------------------------------------------------------------
;  | |   exponent  |                    fraction                           |
;   -----------------------------------------------------------------------
;  |    12 bits          20 bits       |             32 bits               |
;  |            lower word             |            higher word            |

;#include	"mathf.def"
;#define	TWO_PAI_L	0x6dc9c883		; 2*Pai (low).
;#define	TWO_PAI_H	0x3fe45f30		; 2*Pai (high).

;#define	LARGE_RAD_L	0x00000000		; Large radian (low).
;#define	LARGE_RAD_H	0x40dfff00		; Large radian (high).

;#define	QUARTER_L	0x00000000		; Constant 0.25 in double (low).
;#define	QUARTER_H	0x3fd00000		; Constant 0.25 in double (high).

;#define	SIGN_MASK	0x80000000		; Mask for sign bit (MSB) in a word.

;#define	FOUR_L		0x00000000		; Constant 4.0 in double (low).
;#define	FOUR_H		0x40100000		; Constant 4.0 in double (high).

;#define	ONE_L		0x00000000		; Constant 1.0 in double (low).
;#define	ONE_H		0x3ff00000		; Constant 1.0 in double (high).

;#define	CP4_L		0x389bfdc9		; double 2.80782741762206855540e0  (low).
;#define	CP4_H		0x4006766e		; double 2.80782741762206855540e0  (high).
;#define	CP3_L		0x9641f5cc		; double -2.37859324578121572813e2 (low).
;#define	CP3_H		0xc06dbb7f		; double -2.37859324578121572813e2 (high).
;#define	CP2_L		0xd63b0d8d		; double 7.06413608140068845387e3  (low).
;#define	CP2_H		0x40bb9822		; double 7.06413608140068845387e3  (high).
;#define CP1_L		0xa674eb6a		; double -7.65864156388469564263e4 (low).
;#define	CP1_H		0xc0f2b2a6		; double -7.65864156388469564263e4 (high).
;#define CP0_L		0x792deaa3		; double 2.07823684169610118261e5  (low).
;#define CP0_H		0x41095e7d		; double 2.07823684169610118261e5  (high).

;#define	CQ2_L		0xe76ea98b		; double 1.08999811037129049396e2  (low).
;#define CQ2_H		0x405b3ffc		; double 1.08999811037129049396e2  (high).
;#define CQ1_L		0xd1d16135		; double 5.65168679531691759621e3  (low).
;#define	CQ1_H		0x40b613af		; double 5.65168679531691759621e3  (high).
;#define CQ0_L		0x55027c9a		; double 1.32304666508649301250e5  (low).
;#define CQ0_H		0x41002685		; double 1.32304666508649301250e5  (high).

;==============================================================================
;	Function: double sin(double x)
;
;	Input:  %r12: Argument x in radian double (low).
;           %r13: Argument x in radian double (high).
;
;	Output: %r10: Return value, sine of x in double (low).
;			%r11: Return value, sine of x in double (high).
;
	.code
	.align	1
	.global	sin

sin:
	pushn	%r3					; Save registers %r3...%r0.
	sub	%sp,0x5		; 	xsub	%sp,%sp,20			; Presearve working area in five words.

	;[%sp+16] = Taylor series's sign parameter (high).
	;[%sp+12] = Taylor series's sign parameter (low).
	;[%sp+08] = Quadrant of trigonometric function (word).
	;[%sp+07] = 2nd argument of modf, pointer to its fraction part (high).
	;[%sp+00] = 2nd argument of modf, pointer to its fraction part (low).

	ld.w	%r2,%r12			; Low word of argument x.
	ld.w	%r3,%r13			; High word of argument x.

;##### REMOVED 12/08/1999 #############
;# ;
;# ;	Clear the sign bit of argument x in %r3:%r2 by shifting
;# ;	to make it a plus value.
;# ;
;# 	sll		%r3,1				; Shift the argument x to the left  one bit.
;#	srl		%r3,1				; Shift the argument x to the right one bit.
;##### REMOVE END #####################

	ld.w	%r4,0x0		; 	xld.w	%r4,0x0				; Initialize the quadrant to 0.
	ld.w	[%sp+0x2],%r4	; 	xld.w	[%sp+0x8],%r4			; Initialize the quadrant to 0.

;//{{2016/10/25ύX:P/ECEJtsin()́AwI[o[t[鉉ZOɍ݂ƁAsin()֐̌ʂsɂȂBxƂoOL̂ŁAC܂B
;//	sra		%r13,1				; Check if x is minus?
;//2016/10/25ύX:P/ECEJtsin()́AwI[o[t[鉉ZOɍ݂ƁAsin()֐̌ʂsɂȂBxƂoOL̂ŁAC܂B
	cmp		%r13,0				; Check if x is minus?
;//}}2016/10/25ύX:P/ECEJtsin()́AwI[o[t[鉉ZOɍ݂ƁAsin()֐̌ʂsɂȂBxƂoOL̂ŁAC܂B
	jrge	_ArgIsNotMinus	; 	xjrge	_ArgIsNotMinus		; Branch if plus or zero.
;
;	--- if the argument x is minus ---
;	Clear the sign bit of argument x in %r3:%r2 by shifting
;	to make it a plus value.
;
	sll		%r3,1				; Shift the argument x to the left  one bit.
	srl		%r3,1				; Shift the argument x to the right one bit.

	ld.w	%r4,0x2		; 	xld.w	%r4,0x2				; Set the quadrant 2.
	ld.w	[%sp+0x2],%r4	; 	xld.w	[%sp+0x8],%r4			; Set the quadrant 2.
;
;	Mutiply the argument x by the constant 2*Pai
;
_ArgIsNotMinus:
	ld.w	%r12,%r2			; Argument x (low).
	ld.w	%r13,%r3			; Argument x (high).
	ext	0xdb9		; 	xld.w	%r14,0x6dc9c883		; Multiplier, constant 2*Pai (low).
	ext	0x722
	ld.w	%r14,0x3
	ext	0x7fc		; 	xld.w	%r15,0x3fe45f30		; Multiplier, constant 2*Pai (high).
	ext	0x117c
	ld.w	%r15,0x30
								;
	ext	__muldf3@rm	; 	xcall	__muldf3			; Calculate multiplication; argument x = x * (2 * Pai).
	call	__muldf3@rl
								; The result product is %r11:%r10.
	ld.w	%r2,%r10			; Put result x in %r2 (low).
	ld.w	%r3,%r11			; Put result x in %r3 (high).
;
;	Check if the argument x is large radian.
;	If large, do some argument reduction, else skip reduction procedure.
;
	ld.w	%r0,0x0		; 	xld.w	%r0,0x00000000		; Set the large radian constant (low).
	ext	0x81b		; 	xld.w	%r1,0x40dfff00		; Set the large radian constant (high).
	ext	0x1ffc
	ld.w	%r1,0x0
	ld.w	%r12,%r2			; Argument x (low).
	ld.w	%r13,%r3			; Argument x (high).
	ld.w	%r14,%r0			; Large radian constant (low).
	ld.w	%r15,%r1			; Large radian constant (high).
								; Compare argument x and the large radian.
	ext	__fcmpd@rm	; 	xcall	__fcmpd				; to check if the argument x is large.
	call	__fcmpd@rl
	jrle	_ArgIsNotLarge	; 	xjrle	_ArgIsNotLarge		; Skip if the argument x is not large.
;
;	--- Argument x is large ---
;	Reduce the argument to avoid overflow.
;
	ld.w	%r12,%r2			; Argument x (low  word), 1st parameter of modf().
	ld.w	%r13,%r3			; Argument x (high word), 1st parameter of modf().
	ld.w	%r14,%sp			; Pointer to the fraction part [%sp+00], the 2nd parameter of modf().
								;
	ext	modf@rm		; 	xcall	modf				; Calculate the integer part and the fraction part.
	call	modf@rl
;
;	Use the integer part as a Tayler series's sign parameter.
;
	ld.w	[%sp+0x3],%r10	; 	xld.w	[%sp+0xc],%r10		; Tayler series's sign parameter (low).
	ld.w	[%sp+0x4],%r11	; 	xld.w	[%sp+0x10],%r11		; Tayler series's sign parameter (high).
;
;	Use the fraction part as a new argument x.
;
	ld.w	%r2,[%sp+0x0]	; 	xld.w	%r2,[%sp]			; Copy fraction result to the argument x (low).
	ld.w	%r3,[%sp+0x1]	; 	xld.w	%r3,[%sp+0x4]			; Copy fraction result to the argument x (high).

;
;	Adjust the new argument
;	by adding the quadrant.
;
	ld.w	%r12,[%sp+0x2]	; 	xld.w	%r12,[%sp+0x8]		; Load the quadrant integer.
								;
	ext	__floatsidf@rm	; 	xcall	__floatsidf			; Convert the quadrant to a double value.
	call	__floatsidf@rl
								;
	ld.w	%r12,%r2			; Argument x (low).
	ld.w	%r13,%r3			; Argument x (high).
	ld.w	%r14,%r10			; Quadrant in double (low).
	ld.w	%r15,%r11			; Quadrant in double (high).
								;
	ext	__adddf3@rm	; 	xcall	__adddf3			; Add the argument x and the quadrant.
	call	__adddf3@rl
								; The result is %r11:%r10.
	ld.w	%r2,%r10			; Put the result back to the argument x (low).
	ld.w	%r3,%r11			; Put the result back to the argument x (high).

	.loc	45
;# 		modf( 0.25 * x, &f );

	ld.w	%r12,%r2			; Argument x (low).
	ld.w	%r13,%r3			; Argument x (high).
	ld.w	%r14,0x0	; 	xld.w	%r14,0x00000000		; Constant 0.25 in double (low).
	ext	0x7fa		; 	xld.w	%r15,0x3fd00000		; Constant 0.25 in double (high).
	ext	0x0
	ld.w	%r15,0x0
								;
	ext	__muldf3@rm	; 	xcall	__muldf3			; Calculate multiplication x*0.25.
	call	__muldf3@rl
								;
	ld.w	%r12,%r10			; Set x*0.25 result as 1st param of modf (low).
	ld.w	%r13,%r11			; Set x*0.25 result as 1st param of modf (high).
	ld.w	%r14,%sp			; 2nd param of modf, pointer to the fraction.
								;
	ext	modf@rm		; 	xcall	modf				; call MODF, another library function.
	call	modf@rl
;
;	Calculate the new quadrant
;	by subtracting 4.0 from the argument x
;	and then multiplying by the fraction part of the argument.
;	(argument x - 4.0 * fraction)
;
	ld.w	%r12,[%sp+0x0]	; 	xld.w	%r12,[%sp]			; Load the fraction part (low).
	ld.w	%r13,[%sp+0x1]	; 	xld.w	%r13,[%sp+0x4]		; Load the fraction part (high).
	ld.w	%r14,0x0	; 	xld.w	%r14,0x00000000			; Set a constant 4.0 (low).
	ext	0x802		; 	xld.w	%r15,0x40100000			; Set a constant 4.0 (high).
	ext	0x0
	ld.w	%r15,0x0
								;
	ext	__muldf3@rm	; 	xcall	__muldf3			; Caculate fraction*4.0.
	call	__muldf3@rl
								;
	ld.w	%r12,%r2			; Set the argument x.
	ld.w	%r13,%r3			; Set the argument x.
	ld.w	%r14,%r10			; Set the result of fraction*4.0 (low).
	ld.w	%r15,%r11			; Set the result of fraction*4.0 (high).
								;
	ext	__subdf3@rm	; 	xcall	__subdf3			; Calculate fraction*4.0-x.
	call	__subdf3@rl
								;
	ld.w	%r12,%r10			; Put the result back to the argument x (low).
	ld.w	%r13,%r11			; Put the reuslt back to the argument x (high).
								;
	ext	__fixdfsi@rm	; 	xcall	__fixdfsi			; Make it into an integer (resulting quadrant).
	call	__fixdfsi@rl
								;
	ld.w	[%sp+0x2],%r10	; 	xld.w	[%sp+0x8],%r10		; Store the new quadrant.
	jp	_ChkIfQuadrant1or3	; 	xjp	_ChkIfQuadrant1or3		; Jump to the next process,
								; completing the adjustment,
								; when the argument x is large.
;
;	--- Argument x is not large ---
;
;	Obtain the integer part of the argument x in double
;	to use it for adjusting the Taylor series's sign parameter
;	accoring to the quadrant.
;
_ArgIsNotLarge:
	ld.w	%r12,%r2			; Argument x (low  word).
	ld.w	%r13,%r3			; Argument x (high word).
								;
	ext	__fixdfsi@rm	; 	xcall	__fixdfsi			; Cast the argument x in double to an integer.
	call	__fixdfsi@rl
								; %r10 <- Result integer.
	ld.w	%r0,%r10			; Keep the integer part of the argument x in %r0.
;
;	Obtain the fraction part of the argument x
;	by subtracting the integer part.
;
	ld.w	%r12,%r0			; Set the integer part value as input to "__floatsidf".
								;
	ext	__floatsidf@rm	; 	xcall	__floatsidf			; Cast the integer part back to a double value.
	call	__floatsidf@rl
								;
	ld.w	%r12,%r2			; Set the resulting double as subtrahend of __subdf3 (low).
	ld.w	%r13,%r3			; Set the resulting double as subtrahend of __subdf3 (high).
	ld.w	%r14,%r10			; Set the result of former __floatsidf as the next subtracter (low).
	ld.w	%r15,%r11			; Set the result of former __floatsidf as the next subtracter (high).
								;
	ext	__subdf3@rm	; 	xcall	__subdf3			; Subtract %14:%r15 (argument x) from %r13:%r12 (integer argument).
	call	__subdf3@rl
								;
	ld.w	[%sp+0x3],%r10	; 	xld.w	[%sp+0xc],%r10		; Set the subtraction result back to the argument x (low).
	ld.w	[%sp+0x4],%r11	; 	xld.w	[%sp+0x10],%r11		; Set the subtraction result back to the argument x (high).
;
;	Calculate the new quadtrant
;	by adding the integer part of the argument x
;	and then logically anding with a constant 3.
;
	ld.w	%r4,[%sp+0x2]	; 	xld.w	%r4,[%sp+0x8]			; Quadrant integer.
	add		%r4,%r0				; Adding integer part and the argument x.
	and	%r4,0x3		; 	xand	%r4,%r4,0x3			; Anding it with a consant 3.
	ld.w	[%sp+0x2],%r4	; 	xld.w	[%sp+0x8],%r4			; Put the result as a new quadrant.
;
;	--- Checkng according to the quadrant ---
;	Check if the quadrant is 1 or 3 (odd number).
;
_ChkIfQuadrant1or3:
	ld.w	%r10,[%sp+0x2]	; 	xld.w	%r10,[%sp+0x8]		; Load the quadrant
	and	%r10,0x1	; 	xand	%r10,%r10,0x1		; Check if the quadrant is 1 or 3?
	jreq	_ChkIfQuadMoreThan1	; 	xjreq	_ChkIfQuadMoreThan1	; Skip if the quadrant is neither 1 nor 3.
;
;	--- Quadrant is 1 or 3 ---
;	Adjust the Taylor series's sign parameter
;	by calculating "param = 1 - param".
;
	ld.w	%r12,0x0	; 	xld.w	%r12,0x00000000			; Set constant 1.0 (low  word).
	ext	0x7fe		; 	xld.w	%r13,0x3ff00000			; Set constant 1.0 (high word).
	ext	0x0
	ld.w	%r13,0x0
	ld.w	%r14,[%sp+0x3]	; 	xld.w	%r14,[%sp+0xc]		; Taylor series's sign parameter (low  word).
	ld.w	%r15,[%sp+0x4]	; 	xld.w	%r15,[%sp+0x10]		; Taylor series's sign parameter (high word).
								;
	ext	__subdf3@rm	; 	xcall	__subdf3			; Subtract %r13:%r12 - %r15:%r14, Result is %r11:r10
	call	__subdf3@rl
								;
	ld.w	[%sp+0x3],%r10	; 	xld.w	[%sp+0xc],%r10		; Store the result of calculation (low  word).
	ld.w	[%sp+0x4],%r11	; 	xld.w	[%sp+0x10],%r11		; Store the result of calculation (high word).
;
;	--- Checking if the quadrant is larger than 1 ---
;
_ChkIfQuadMoreThan1:
	ld.w	%r4,[%sp+0x2]	; 	xld.w	%r4,[%sp+0x8]			; Loading the quadrant.
	cmp	%r4,0x1		; 	xcmp	%r4,1				; Check if it is larger than 1?
	jrle	_SquareTaylorParam	; 	xjrle	_SquareTaylorParam	; If not larger than 1, skip to complete calculating Tayler's param.
;
;	--- Quadrant is larget than 1 ---
;	then, negate the Taylor series's sign parameter.
;
	ld.w	%r13,[%sp+0x4]	; 	xld.w	%r13,[%sp+0x10]			; Load the Tayler series's parameter.
	ext	0x1000		; 	XXOR	%r13,%r13,0x80000000		; Negate it.
	ext	0x0
	xor	%r13,0x0
	ld.w	[%sp+0x4],%r13	; 	xld.w	[%sp+0x10],%r13			; Store it.
;
;	--- Calculate the square of the Tayler series's sign parameter ---
;	Complete adjusting the Taylor series's sign parameter
;	by calculating its square.
;
_SquareTaylorParam:
	ld.w	%r12,[%sp+0x3]	; 	xld.w	%r12,[%sp+0xc]		; Multiplicand, the argument x (low).
	ld.w	%r13,[%sp+0x4]	; 	xld.w	%r13,[%sp+0x10]		; Multiplicand, the argument x (high).
	ld.w	%r14,[%sp+0x3]	; 	xld.w	%r14,[%sp+0xc]		; Multiplier, the argument x (low).
	ld.w	%r15,[%sp+0x4]	; 	xld.w	%r15,[%sp+0x10]		; Multiplier, the argument x (high).
								;
	ext	__muldf3@rm	; 	xcall	__muldf3			; Calculate square, the argument x * argument x
	call	__muldf3@rl
								;
	ld.w	%r2,%r10			; Put the square result in the argument x (low).
	ld.w	%r3,%r11			; Put the square result in the argument x (hig).
;
;
;
;	(((((P4 * x + P3) * x + P2) * x + P1) * x + P0) * y)
;	----------------------------------------------------
;	           (((x + Q2) * x + Q1) * x + Q0)
;
	ld.w	%r12,%r2			; Argument square x (low).
	ld.w	%r13,%r3			; Argument square x (high).
	ext	0x713		; 	xld.w	%r14,0x389bfdc9			; double 2.80782741762206855540e0 (low).
	ext	0xff7
	ld.w	%r14,0x9
	ext	0x800		; 	xld.w	%r15,0x4006766e			; double 2.80782741762206855540e0 (high).
	ext	0x19d9
	ld.w	%r15,0x2e
								;
	ext	__muldf3@rm	; 	xcall	__muldf3			;
	call	__muldf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ext	0x12c8		; 	xld.w	%r14,0x9641f5cc			; double -2.37859324578121572813e2 (low).
	ext	0x7d7
	ld.w	%r14,0xc
	ext	0x180d		; 	xld.w	%r15,0xc06dbb7f			; double -2.37859324578121572813e2 (high).
	ext	0x16ed
	ld.w	%r15,0x3f
								;
	ext	__adddf3@rm	; 	xcall	__adddf3			;
	call	__adddf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ld.w	%r14,%r2			;
	ld.w	%r15,%r3			;
								;
	ext	__muldf3@rm	; 	xcall	__muldf3			;
	call	__muldf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ext	0x1ac7		; 	xld.w	%r14,0xd63b0d8d			; double 7.06413608140068845387e3 (low).
	ext	0xc36
	ld.w	%r14,0xd
	ext	0x817		; 	xld.w	%r15,0x40bb9822			; double 7.06413608140068845387e3 (high).
	ext	0xe60
	ld.w	%r15,0x22
								;
	ext	__adddf3@rm	; 	xcall	__adddf3			;
	call	__adddf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ld.w	%r14,%r2			;
	ld.w	%r15,%r3			;
								;
	ext	__muldf3@rm	; 	xcall	__muldf3			;
	call	__muldf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ext	0x14ce		; 	xld.w	%r14,0xa674eb6a			; double -7.65864156388469564263e4 (low).
	ext	0x13ad
	ld.w	%r14,0x2a
	ext	0x181e		; 	xld.w	%r15,0xc0f2b2a6			; double -7.65864156388469564263e4 (high).
	ext	0xaca
	ld.w	%r15,0x26
								;
	ext	__adddf3@rm	; 	xcall	__adddf3			;
	call	__adddf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ld.w	%r14,%r2			;
	ld.w	%r15,%r3			;
								;
	ext	__muldf3@rm	; 	xcall	__muldf3			;
	call	__muldf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ext	0xf25		; 	xld.w	%r14,0x792deaa3			; double 2.07823684169610118261e5 (low).
	ext	0x17aa
	ld.w	%r14,0x23
	ext	0x821		; 	xld.w	%r15,0x41095e7d			; double 2.07823684169610118261e5 (high).
	ext	0x579
	ld.w	%r15,0x3d
								;
	ext	__adddf3@rm	; 	xcall	__adddf3			;
	call	__adddf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ld.w	%r14,[%sp+0x3]	; 	xld.w	%r14,[%sp+0xc]		;
	ld.w	%r15,[%sp+0x4]	; 	xld.w	%r15,[%sp+0x10]		;
								;
	ext	__muldf3@rm	; 	xcall	__muldf3			;
	call	__muldf3@rl
								;
	ld.w	%r0,%r10			;
	ld.w	%r1,%r11			;
	ld.w	%r12,%r2			;
	ld.w	%r13,%r3			;
	ext	0x1ced		; 	xld.w	%r14,0xe76ea98b			; double 1.08999811037129049396e2 (low).
	ext	0x1aa6
	ld.w	%r14,0xb
	ext	0x80b		; 	xld.w	%r15,0x405b3ffc			; double 1.08999811037129049396e2 (high).
	ext	0xcff
	ld.w	%r15,0x3c
								;
	ext	__adddf3@rm	; 	xcall	__adddf3			;
	call	__adddf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ld.w	%r14,%r2			;
	ld.w	%r15,%r3			;
								;
	ext	__muldf3@rm	; 	xcall	__muldf3			;
	call	__muldf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ext	0x1a3a		; 	xld.w	%r14,0xd1d16135			; double 5.65168679531691759621e3 (low).
	ext	0x584
	ld.w	%r14,0x35
	ext	0x816		; 	xld.w	%r15,0x40b613af			; double 5.65168679531691759621e3 (high).
	ext	0x184e
	ld.w	%r15,0x2f
								;
	ext	__adddf3@rm	; 	xcall	__adddf3			;
	call	__adddf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ld.w	%r14,%r2			;
	ld.w	%r15,%r3			;
								;
	ext	__muldf3@rm	; 	xcall	__muldf3			;
	call	__muldf3@rl
								;
	ld.w	%r12,%r10			;
	ld.w	%r13,%r11			;
	ext	0xaa0		; 	xld.w	%r14,0x55027c9a			; double 1.32304666508649301250e5 (low).
	ext	0x9f2
	ld.w	%r14,0x1a
	ext	0x820		; 	xld.w	%r15,0x41002685			; double 1.32304666508649301250e5 (high).
	ext	0x9a
	ld.w	%r15,0x5
								;
	ext	__adddf3@rm	; 	xcall	__adddf3			;
	call	__adddf3@rl
								;
	ld.w	%r12,%r0			;
	ld.w	%r13,%r1			;
	ld.w	%r14,%r10			;
	ld.w	%r15,%r11			;
								;
	ext	__divdf3@rm	; 	xcall	__divdf3			;
	call	__divdf3@rl

	add	%sp,0x5		; 	xadd	%sp,%sp,20			; Roll up the working area.
	popn	%r3					; Restore registers %r3...%r0.
	ret							;

