//
//	clipgrp_uni.cs
//
//	アプリケーションのグラフィック関数
//
//	CLiP - Common Library for P/ECE
//	Copyright (C) 2017 Naoyuki Sawa
//
//	* Mon Mar 27 22:39:32 JST 2017 Naoyuki Sawa
//	- 1st リリース。
//	  まだアプリケーションとライブラリの分離が不完全で、当モジュール内にアプリケーション依存の定数やグローバル変数への参照が残っています。
//	  そのため、現在はまだ、当モジュールを直接アプリケーションに含めて、ビルドしています。
//	  引き続き、アプリケーションとライブラリの分離を行って行きます。(※TODO:)
//	* Wed Mar 29 16:08:13 JST 2017 Naoyuki Sawa
//	- draw_spr()において、UnityのSpriteのPivotを相殺する処理が、縦軸に関して間違っていたのを修正しました。
//	* Thu Mar 30 22:26:51 JST 2017 Naoyuki Sawa
//	- 一旦、当モジュールはライブラリから除外しました。
//	  あまりにもアプリケーション依存の部分が多過ぎて、ライブラリに含めたままでは変更が行い辛い問題が生じたからです。
//	  当面は、当モジュールはアプリケーションに含めて変更を進め、いずれ、アプリケーション依存部分と非依存部分の切り分けが出来たら、あらためて非依存部分だけをライブラリに取り込もうと思います。
//	* Thu Mar 30 23:36:41 JST 2017 Naoyuki Sawa
//	- CbkQue_prep_spr()を廃止し、prep_spr()を直接呼び出せるようにしました。
//	  これまで、prep_spr()の内部で使用している処理の中に、サブスレッドからは呼び出せないUnityの処理が含まれていると思って、アプリケーションからはCbkQue_prep_spr()を経由しないとprep_spr()を呼び出せないようにしていました。
//	  しかし、実験してみた所、prep_spr()の内部で使用している処理は、全てSofdecの処理だけでUnityの処理は呼び出していなかったようで、サブスレッドからprep_spr()を呼び出しても問題無く動作しました。
//	  アプリケーションの観点からも、prep_spr()を直接呼び出せる方が都合が良いので、CbkQue_prep_spr()を廃止し、prep_spr()を直接呼び出せるようにしました。
//	  変更前は、prep_spr()は戻り値が無かった(CbkQue_prep_spr()経由では戻り値が返せないから)のですが、変更後は戻り値が返せるようになったので、C言語版と同様に、準備完了かどうかを戻り値で返すようにしました。
//	* Fri Mar 31 21:21:33 JST 2017 Naoyuki Sawa
//	- テクスチャの自動スケーリングを追加しました。
//	  おおよそ、/clip/DxlibHelper.cppの自動スケーリングの機能と同じです。
//	  ただし、/clip/DxlibHelper.cppの自動スケーリングの機能は、テクスチャファイル名から判断していましたが、当モジュールでは、レジストリから自動スケーリングの拡大率を取得するようにしました。
//	  2017/03/26に、/clip/tool/dTexDefC/に、テクスチャに汎用の属性リストを追加した事によって、任意の情報がテクスチャ定義に追加出来るようになったからです。
//	  テクスチャファイル名から判断するよりも自然だし、効率も良いと思います。
//	  いずれ、/clip/DxlibHelper.cppも、当モジュールと同様に、レジストリから自動スケーリングの拡大率を取得するように変更する予定です。	⇒{{2017/04/01コメント追記:/clip/DxlibHelper.cppに、左記の変更を適用しました。}}
//	* Tue Apr 04 23:33:32 JST 2017 Naoyuki Sawa
//	- スプライトフォント描画に回転機能を追加しました。
//	* Sun Apr 09 22:05:18 JST 2017 Naoyuki Sawa
//	- Unity 5.6.0ではLineRenderer.numPositionsがobsoleteになり、positionCountに変わった事に対応しました。
//	  numPositionsのままでもビルドは出来ますが、以下のような警告が出ます。
//	  ＞warning CS0618: `UnityEngine.LineRenderer.numPositions' is obsolete: `Use positionCount property (UnityUpgradable) -> positionCount'
//	* Mon Apr 10 21:37:40 JST 2017 Naoyuki Sawa
//	- 「スプライト描画(フォールバック有り)」を削除し、既存の「スプライト描画(フォールバック無し)」を単純に「スプライト描画」としました。
//	  「スプライト描画(フォールバック有り)」を作成した頃は、まだprep_spr()に戻り値が無かったので、アプリケーションが準備完了かどうかを知らなくても処理出来るように「スプライト描画(フォールバック有り)」を用意したのですが、
//	  もうprep_spr()に戻り値を返すようになったので、アプリケーションが明示的に準備完了かどうかを判定して描画方法を変えられるようになったので、「スプライト描画(フォールバック有り)」が無くても大丈夫になったからです。
//	  「スプライト描画(フォールバック有り)」を残しておいても構わなかったのですが、実際に少しアプリケーションから使ってみた所、かなり使い辛かったので、判り易さのために削除する方が良いと思い、削除しました。
//	* Tue Apr 11 21:34:28 JST 2017 Naoyuki Sawa
//	- 各描画関数のalpha引数を、rgba引数に変更しました。
//	  元々/clip/DxlibHelper.cppの描画関数はrgba引数だったのですが、当モジュールへ(アレンジしながら)移植する際に、簡単のためにalpha引数に変更していました。
//	  やっぱり/clip/DxlibHelper.cppの描画関数と同様に、rgba引数にする事にしました。
//	* Wed Apr 12 22:29:29 JST 2017 Naoyuki Sawa
//	- CbkQue_draw_box()を追加しました。
//	  C言語版のCbkQue_draw_box()ではなく、CbkQue_draw_box_fill()に相当します。
//	  Unityでゲームを作る時に矩形の枠だけを描画する事は無さそうなので、C言語版のCbkQue_draw_box()に相当する関数は作成せず、塗り潰す関数の名前を単純化してCbkQue_draw_box()としました。
//	- draw_spr()にて、ムービーのカラーブレンディングも対応しました。
//	  この機能を使うためには、シェーダの変更も必要です。
//	  具体的には、/clip/libclip.net/keep/Program/README.TXTの、同日のコメントを参照して下さい。
//	* Fri Apr 21 21:38:57 JST 2017 Naoyuki Sawa
//	- CbkQue_draw_polygon()を追加しました。
//	  C言語版のCbkQue_draw_polygon()ではなく、CbkQue_draw_polygon_fill()に相当します。
//	  Unityでゲームを作る時に多角形の枠だけを描画する事は無さそうなので、C言語版のCbkQue_draw_polygon()に相当する関数は作成せず、塗り潰す関数の名前を単純化してCbkQue_draw_polygon()としました。
//	- C言語版のCbkQue_draw_polygon_fill()は凹多角形も描画出来ますが、Unity版のCbkQue_draw_polygon()は凸多角形しか描画出来ません。
//	  Unityでゲームを作る時に、動的に凹多角形を描く事はまず無いと思うからです。
//	  元々、C言語版のCbkQue_draw_polygon_fill()で凹多角形に対応していた理由は、凹多角形の分割処理(vec2i_split_polygon_into_triangles())の検証のためだけで、実際にゲームで使う事はほとんど有りませんでした。
//	* Fri Apr 21 22:01:07 JST 2017 Naoyuki Sawa
//	- StableAspect()を追加しました。
//	* Mon May 01 22:50:38 JST 2017 Naoyuki Sawa
//	- 以下の関数の名前を変更しました。
//	  ・draw_line()⇒draw_polyline()
//	  ・CbkQue_draw_line()⇒CbkQue_draw_polyline()
//	  変更前の名前では、関数名が実態を表しておらず、判り辛かったからです。
//	- 以下の関数の名前を変更しました。
//	  ・draw_box()⇒draw_box_fill()
//	  ・draw_polygon()⇒draw_polygon_fill()
//	  ・CbkQue_draw_box()⇒CbkQue_draw_box_fill()
//	  ・CbkQue_draw_polygon()⇒CbkQue_draw_polygon_fill()
//	  当初、Unity版では塗り潰さない関数は作らないつもりだったので、上記のようの名前を単純化したのですが、やっぱり今後、Unity版でも塗り潰さない関数も作る事にしたので、C言語版と同じ正しい名前に戻しました。
//	- 新たに、以下の関数を追加しました。
//	  ・draw_box(),CbkQue_draw_box()
//	  ・draw_polygon(),CbkQue_draw_polygon()
//	  塗り潰さない矩形描画と多角形描画です。
//	  上で関数名を変更する前の関数と同じ名前ですが、機能は異なるので混同しないように注意して下さい。
//	* Wed May 03 22:06:25 JST 2017 Naoyuki Sawa
//	- スプライトシートに対応しました。
//	  詳細は、以下の通りです。
//	- これまでは、C言語版と違って、スプライトとテクスチャを1:1にしていたので、Resourcesから直接Spriteをロードしていました。
//	  そうしていた理由は、Resourcesフォルダ内のスプライトには、Unityのスプライトパッカーが機能しないため、やむを得ずそうしていました
//	  しかし、やはり、スプライトとテクスチャが1:1では、ドローコール(SetPass)が多過ぎて、処理が重過ぎる問題が生じました。
//	  そこで、Unityのスプライトパッカーを使わずに、C言語版と同様にdpsprsht.exeを使って自前でスプライトシートを作成し、Sprite.Create()でスプライトを作成する方法に変更しました。
//	  概ねC言語版と同じ処理内容になりました。(ただし、上記のような経緯の違いが有るので、C言語版とコードは違うのですが、結果的に、処理内容としては似た事を行うようになりました。)
//	- 上記のように変更した事で、特に、文字列描画のドローコール(SetPass)が大幅に減り、150ぐらいだったSetPassが、40～50ぐらいまで減り、負荷が小さくなりました。
//	  Web上の情報によると、目安としては、Androidでは、SetPass≦100 にするのがセオリーだそうです。
//	* Thu May 04 21:15:25 JST 2017 Naoyuki Sawa
//	- draw_polyline()を、スプライトシートに対応しました。
//	  ただし、汎用的な方法では対応出来なかったため、アプリケーション依存の方法で対応しました。
//	  詳細は、draw_polyline()関数内の、手法①,手法②,手法③のコメントを参照して下さい。
//	  現在の所は、やむを得ず手法③を使用していますが、いずれ手法①が動くようになりますように…
//	* Tue May 09 22:14:45 JST 2017 Naoyuki Sawa
//	- マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//	  マテリアルが違うとドローコールが分かれるのでドローコールが増えてしまいますが、マテリアルが同じならば(プライオリティが連続していればですが)まとめられる期待が持てるからです。
//	- 主に、ToolLibで、多くの線や矩形の描画を行った場合の性能向上を目的として上記の変更を行ったのですが、実際に試してみると期待していたほどの性能向上は得られませんでした。
//	  32が30になったぐらいです。
//	  多分、ToolLibは、連続したプライオリティにおいては、違う色で線や矩形を描画する事が多いからだと思います。
//	  期待していたほどの性能向上は得られなかったのですが、とは言え、僅かですが性能向上したので、一応、今回の変更は有益だと思います。
//	- ※TODO:要検討…今回の対策は、図形の色変えをマテリアル利用のまま高速化する工夫でしたが、それよりも、マテリアルは変えずに、個々のオブジェクトのメッシュの頂点カラーを変える方が良いのかも知れない。メッシュの頂点カラーを変えるオーバーヘッドと、ドローコールがわかれるオーバーヘッドの、どちらが小さいかによると思うが…
//	* Wed May 10 22:17:50 JST 2017 Naoyuki Sawa
//	- 加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
//	  これまで、'CriManaMovieMaterial.player.additiveMode'のフィールド名に倣って'additive'という属性名にしていたのですが、単なる属性名なので一致している必要は無いし、属性名が長すぎて冗長だと思ったので、'add'にする事にしました。
//	  Dxlib等でも加算モードの名前は'additive'ではなく'add'なので、'add'の方が判り易いと思います。
//	* Sun May 14 23:23:22 JST 2017 Naoyuki Sawa
//	- 単色テクスチャの色の設定方法を選択出来るようにしました。
//	  USE_COLOR_MATERIALを定義すると、マテリアルを使って設定します(2017/05/13以前の動作)。
//	  USE_COLOR_MATERIALを定義しないと、頂点カラーを使って設定します(2017/05/14以降の動作)。
//	  詳細は、以下の通りです。
//	- これまでは、前者の方法が早いと思っていたのですが、実際に試してみると、マデリアルの切り替えが多くてドローコールが増えて、遅くなるようです。
//	  特に、ToolLibを使うとその問題が顕著です。
//	  そこで、後者の方法を試してみた所、ドローコールが減りました。
//	  描画内容にも寄りますが、70台ぐらいだったSetPassが、20台まで減りました。
//	  従って、単色テクスチャの色の設定方法は、頂点カラーを使って設定する方が良いようです。
//	  まだ検証が十分ではないので、しばらくは、USE_COLOR_MATERIALによって切り替えられるようにしておきます。
//	  十分検証出来たら、マテリアルを使って設定していたコードを削除して、USE_COLOR_MATERIALシンボルも削除する予定です。
//	* Wed May 17 21:36:23 JST 2017 Naoyuki Sawa
//	- MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。				⇒{{2017/06/05追記:このクラッシュ対策は関係なかったので削除しました。}}
//	  詳細は、MoviePlayerクラスのbPreventFrameSkipping定義箇所のコメントを参照して下さい。
//	* Mon May 29 21:46:05 JST 2017 Naoyuki Sawa
//	- MoviePlayer()にて作成したムービーマテリアルに対するDontDestroyOnLoad()を追加しました。	⇒{{2017/06/05追記:このクラッシュ対策は関係なかったので削除しました。}}
//	  Unityのクラッシュ対策のためです。
//	  クラッシュの詳細については、当ファイル内のMoviePlayerクラス定義内の、'Mon May 22 23:09:03 JST 2017 Naoyuki Sawa'のコメント,及び,それ以前の一連のコメントを参照して下さい。
//	  今回対策した内容は、以下の通りです。
//	- Graph_Init()にて「UnityEngine.Object.DontDestroyOnLoad(Graph.goRoot)」を行っているのだから、そのコンポーネントとして「Graph.goRoot.AddComponent<CriManaMovieMaterial>()」で作成したムービーマテリアルは、初期状態でDontDestroyOnLoadであるはずだと思うのですが、
//	  実際に今回の対策(=明示的にムービーマテリアルに対してDontDestroyOnLoad()を呼ぶ)を行うと、(Direct3D9バージョンで一時間程度動作確認した限りでは)クラッシュが発生しなくなったので、何か影響が有るのだと思います。
//	  ムービーマテリアルは、明示的にDontDestroyOnLoad()を呼ばないと、勝手にアンロードされてしまうのでしょうか…?
//	  とは言え、今回の対策でクラッシュが発生しなくなったとはまだ断言出来ないので、引き続き検証しようと思います。
//	  ⇒Mon May 29 22:32:07 JST 2017 Naoyuki Sawa 追記: 上記の対策では解決しませんでした。まだクラッシュが発生する事が有りました。しかし頻度は下がったように思うので、多少効果は有るような気がするので、この対策は残しておこうと思います。引き続き解決方法を探します。
//	* Tue May 30 23:03:37 JST 2017 Naoyuki Sawa
//	- クラッシュ対策として、明示的にCriManaMovieMaterial.Update()を呼び出す時は、renderModeをNeverにして呼び出すように修正しました。
//	  そうした理由は、以下の通りです。
//	- CriManaMovieMaterial生成後のrenderModeの初期値はAlwaysです。
//	  renderModeがAlwaysの状態でCriManaMovieMaterial.Update()を呼び出すと、CriManaMovieMaterial.player.OnWillRenderObject()が呼び出され、状態がReady,又は,Playingならば「IssuePluginEvent(CriManaUnityPlayer_RenderEventAction.RENDER)」が呼ばれます。
//	  しかし、実験したところ、「IssuePluginEvent(CriManaUnityPlayer_RenderEventAction.RENDER)」が呼ばれた後に、同一フレームでCriManaMovieMaterial.Stop()を呼び出すと、クラッシュが発生し易いようでした。
//	  恐らく、描画スレッドにて描画を実行中にリソースを開放してしまってクラッシュするのではないかと思います。(リソースの開放もIssuePluginEvent()で行っているはずなのでシリアライズされると思うのですが、なぜかそうはならないようです。まだ完全には理解出来ていません。)
//	  普通の使い方ならば、CriManaMovieMaterial.Update()は当該フレームの最後にUnityによって呼び出されるのでその後でCriManaMovieMaterial.Stop()が呼ばれる事は(LateUpdate()から呼び出したりしない限り)発生しないので問題無いのですが、
//	  当モジュールは明示的にCriManaMovieMaterial.Update()を呼び出しているため、CriManaMovieMaterial.Update()の後に同一フレームでCriManaMovieMaterial.Stop()が呼ばれる事があり、クラッシュの原因となっていたようです。
//	  解決策としては、UnityからCriManaMovieMaterial.Update()が呼ばれる時以外のCriManaMovieMaterial.Update()呼び出しでは、CriManaMovieMaterial.player.OnWillRenderObject()が呼ばれないようにすれば良いのです。
//	  具体的には、明示的に明示的にCriManaMovieMaterial.Update()を呼び出す時は、一時的にrenderModeをNeverにして呼び出せば良いのです。
//	  或いは別の案として、CriManaMovieMaterial生成後にrenderModeをNeverにしてしまい、描画処理は当該フレームの最後に、描画が確定しているCriManaMovieMaterialに対して明示的にCriManaMovieMaterial.RenderMovie()を呼び出すという方法もありました。
//	  しかし、前述の方法と結果は同じになるはずであり、前述の方法の方が簡単なので、今回は前述の方法で対応する事にしました。
//	* Tue May 30 23:23:35 JST 2017 Naoyuki Sawa
//	- 上記の対応だけでは不足でした。
//	  上記の対応に加えて、Unityエディタ上で「スクリプト実行順設定」(Edit⇒Project Settings⇒Script Execution Order)を変更する必要が有りました。
//	  【変更前】
//	   │CriWareErrorHandler         -13
//	   │CriWareInitializer          -12
//	   │CriAtom                     -11
//	   │CriManaMovieMaterial        -9
//	   │CriManaMovieControllerForUI -8
//	   │CriManaMovieController      -7
//	   │(Default Time)
//	  【変更後】
//	   │CriWareErrorHandler         -13
//	   │CriWareInitializer          -12
//	   │CriAtom                     -11
//	   │GameController              -10 ←アプリケーション定義のスクリプト。GameController.Update()からGraph_Exec()を経由してMovieHelper_Exec()を呼び出している。ちなみに優先度(-10)が空いていたのは偶然ですが、ちょうどこの位置に入れるのが都合が良いです。
//	   │CriManaMovieMaterial        -9
//	   │CriManaMovieControllerForUI -8
//	   │CriManaMovieController      -7
//	   │(Default Time)
//	   なぜこうする必要が有るかと言うと、CriManaMovieMaterial.Update()よりも先にMovieHelper_Exec()が実行される必要が有るからです。
//	   そうしないと、MovieHelper_Exec()によってCriManaMovieMaterial.Update()によって描画が実行された後に、CriManaMovieMaterial.Stop()が呼ばれる可能性があり、クラッシュが発生する可能性があります。
//	   (描画した後に停止するとクラッシュが発生し易いらしい事については、上述の'Tue May 30 23:03:37 JST 2017 Naoyuki Sawa'のコメントを参照して下さい。)
//	- とりあえず、今回('Tue May 30 23:03:37 JST 2017 Naoyuki Sawa')の当モジュールの変更と、上記(Tue May 30 23:23:35 JST 2017 Naoyuki Sawa)のスクリプト実行順設定の変更を行って、現在、動作検証中です。
//	  30分間ぐらい動かしてみた限りではまだクラッシュが発生していませんが、まだわかりません。
//	* Thu Jun 01 21:52:04 JST 2017 Naoyuki Sawa
//	- 'Tue May 30 23:03:37 JST 2017 Naoyuki Sawa'と'Tue May 30 23:23:35 JST 2017 Naoyuki Sawa'の動作検証結果、クラッシュが発生しなくなりました。
//	  これまでは、PC版で描画APIにDirectX11を使うと、だいたい1時間以内ぐらいにはクラッシュしていたのですが、対策後は、20時間ぐらい連続稼動してもクラッシしなくなりました。
//	  多分、解決したと思います。
//	  ★★★★★★★★★★結論：有効なクラッシュ対策は、'Tue May 30 23:03:37 JST 2017 Naoyuki Sawa'と'Tue May 30 23:23:35 JST 2017 Naoyuki Sawa'を参照して下さい。★★★★★★★★★★		←←←←←←←←←←←←←←←←←←←←重要
//	  ちなみに、それ以前にも色々クラッシュ対策を入れてきましたが、多分、それらはすべて関係なかったのだと思います。
//	  それらの対策も害はないと思うので残したままにしてありますが、今後、一つ一つ外してもクラッシュが再発しない事を確認しながら外して行こうと思います。
//	  また、クラッシュの問題は、PC版で描画APIにDirectX9,又は,DirectX11を使った場合だけに発生していて、PC用OpenGLCore版やAndroid版では元々発生していなかったのですが、
//	  PC用OpenGLCore版やAndroid版でクラッシュが発生していなかったのは、OpenGLCoreやOpenGLESのAPIがポインタベースでなくハンドルベースで無効ポインタに対する耐性が強い(?)だけだと思います。
//	  'Tue May 30 23:03:37 JST 2017 Naoyuki Sawa'と'Tue May 30 23:23:35 JST 2017 Naoyuki Sawa'のクラッシュ対策は、全ての環境・全ての描画APIに対して適用するのが正しいと思うので、そうしました。
//	- 上で書いた事と相反しますが、実は'Tue May 30 23:03:37 JST 2017 Naoyuki Sawa'と'Tue May 30 23:23:35 JST 2017 Naoyuki Sawa'の対策だけでは、不足な場合が有ります。
//	  CRIムービーの再生中に、LoadScene()によるシーン切り替えを行うと、たまに、クラッシュする事が有るようです。											←←←←←←←←←←←←←←←←←←←←重要
//	  たとえ、CRIムービー再生に関するオブジェクトを、DontDestroyOnLoad()等の方法でアンロードされないようにしていても、です。
//	  クラッシュが発生し易いケースとしては、以下の通りです。
//	  │1. 少し長めのCRIムービーを再生開始します。
//	  │2. CRIムービー再生の途中で、LoadScene()を実行し、シーンA⇒シーンBへ遷移したとします。
//	  │3. この時、シーンBがスプライト等のテクスチャアセットを含むシーンだった場合に(大抵そうだと思います)、十回～数十回に一回ぐらいの頻度でクラッシュするようです。(PC用DirectX11版)
//	  │   シーンBがスプライト等のテクスチャアセットを含まないシーンだった場合は、これまでのところ、クラッシュが発生した事は有りません。
//	  上記から推測するに、UnityがLoadScene()の中でテクスチャアセットをロードしてテクスチャメモリへ転送する時に、既存のCRIムービーのテクスチャの処理と衝突している(?)のではないかと思います。
//	  一番単純な回避策としては、CRIムービーの再生中にLoadScene()によるシーン切り替えを行わない事ですが、演出上、どうしてもそうせざるを得ない場合も有りえます。
//	  そこで今回は逆に、LoadScene()によるシーン切り替えを一切使わないという方法で回避しました。
//	  要するに、Unityのシーンの機能を使わずに、全体で一つのシーンだけにして、シーン切り替えに相当する処理は全てコードで処理するという方法です。
//	  そうする事で実際に、20時間ぐらい連続稼動してもクラッシしなくなったので、有効な方法ではあると思うのですが、手間が増えるしUnityを使う意味が薄れるという問題も有ります。
//	  出来れば最初から、CRIムービー再生中にはシーン切り替えをしなくて済むように、演出を考えるのが正しい方法だと思います。
//	- ちなみに、上記の修正を行えば、PC用の全ての描画APIが選択出来るという訳ではありません。
//	  今の所、わかっている事は、以下の通りです。
//	  │◎DirectX11   問題ありません。元々クラッシュが発生していたのですが今回の対策でクラッシュは発生しなくなりました。少し古めのPCでも動作する事が多いので、これが最善の選択だと思います。	←←←←←←←←←←←←←←←←←←←←重要
//	  │○OpenGLCore  問題ありません。元々クラッシュも発生していませんでした。ただし、少し古めのPCでは対応していなくて起動しない事が有るようです。
//	  │△DirectX9    元々クラッシュが発生していたのですが今回の対策でクラッシュは発生しなくなりました。CRIムービーも描画されます。しかし、たまに'YUV Buffer too small'というCRIのエラーが出るのでだめです。敢えてDirectX9を選択する事も無いと思うので、この問題の回避方法については調査していません。
//	  │×OpenES2     一応起動してスプライトは描画されますが、CRIムービーが描画されなくなるのでだめです。
//	  │×OpenES3     一応起動してスプライトは描画されますが、CRIムービーが描画されなくなるのでだめです。
//	  │×Vulkan      一応起動してスプライトは描画されますが、CRIムービーが描画されなくなるのでだめです。
//	* Mon Jun 05 21:24:24 JST 2017 Naoyuki Sawa
//	- 関係なかったクラッシュ対策を削除しました。
//	  上記の対策を行った所、50時間ぐらい連続動作してもクラッシュしなくなったので、問題は解決したと思います。
//	  やはり、有効なクラッシュ対策は、以下の三点だったようです。
//	  │①明示的にCriManaMovieMaterial.Update()を呼び出す時は、renderModeをNeverにして呼び出す。	⇒Tue May 30 23:03:37 JST 2017 Naoyuki Sawa
//	  │②Unityエディタ上で「スクリプト実行順設定」を変更する。					⇒Tue May 30 23:23:35 JST 2017 Naoyuki Sawa
//	  │③CRIムービーの再生中にLoadScene()によるシーン切り替えを行わない。				⇒Thu Jun 01 21:52:04 JST 2017 Naoyuki Sawa
//	- 上記三点以外のクラッシュ対策は関係なかったので、削除しました。
//	  具体的には、以下の二点を削除しました。
//	  │×MoviePlayerクラスに、bPreventFrameSkippingフラグを追加した。				⇒Wed May 17 21:36:23 JST 2017 Naoyuki Sawa	⇒削除
//	  │×MoviePlayer()にて作成したムービーマテリアルに対するDontDestroyOnLoad()を追加した。	⇒Mon May 29 21:46:05 JST 2017 Naoyuki Sawa	⇒削除
//	- 尚、'Mon May 22 22:18:20 JST 2017 Naoyuki Sawa'に行った50%フレームスキップ処理の変更も、クラッシュ対策としては関係なかったのですが、変更後の50%フレームスキップ処理の方が連続二回スキップにならなくて望ましいので、この変更は残しておく事にしました。
//	* Mon Jun 05 21:44:29 JST 2017 Naoyuki Sawa
//	- MoviePlayer.Dispose()にて、ムービーマテリアルを削除する前に、確実に停止しておくようにしました。
//	  そうした理由は、PC用OpenGLCore版で、たまに、アプリケーションを閉じる瞬間にクラッシュする事が有ったからです。
//	  実行中には問題なく、終了時だけの問題なので、以前のクラッシュ問題よりは重大ではないのですが、とは言え対策する必要が有ります。
//	  まだ原因ははっきりしていないのですが、恐らく終了直前に非同期で描画しようとしてその描画が終わる前に終了処理の中でリソースを開放しようとしてしまいクラッシュしているのではないかと思い、今回の対策を追加してみることにしました。
//	  これで直るか、しばらく様子を見ようと思います。
//	  尚、この問題が発生しているのはPC用OpenGLCore版のみであり、PC用DirectX11版やAndroid用では問題は出ていません。
//	* Mon Jun 05 22:04:11 JST 2017 Naoyuki Sawa
//	- 上記('Mon Jun 05 21:44:29 JST 2017 Naoyuki Sawa')の対策を削除しました。
//	  PC用OpenGLCore版でアプリケーションを閉じる瞬間にクラッシュするのは、CRI側の不具合のようです。
//	  具体的には、Unity(5.6.1f1現在)とCRI(criware_sdk_unity_smartphone_v2_90_j現在)を併用し、描画APIにOpenGLCoreを選択してWindows用にビルドすると、アプリケーションを閉じる瞬間にクラッシュする事が有ります。
//	  クラッシュが発生する条件は、「アプリケーション実行中に一度でもフルスクリーンモードに切り替えたか(最初からフルスクリーンモードで起動した場合も含む)」であるようです。
//	  SDK付属のサンプルプログラムの設定を少し変えて描画APIをOpenGLCoreに変更するだけでも再現したので、多分、アプリケーション側の問題ではないです。
//	  従って、上記('Mon Jun 05 21:44:29 JST 2017 Naoyuki Sawa')の対策は関係ないので、削除しました。
//	  アプリケーション側で対策するのは難しそうなので、CRIが直るのを待つしかなさそうです。
//	  ↓訂正
//	  CRIの問題ではありませんでした。
//	  Unityそのものの問題でした。
//	  既に、Unityのフォーラムに報告されていましたので、引用します。
//	  □https://issuetracker.unity3d.com/issues/standalone-build-crashes-when-graphics-api-is-set-to-openglcore-and-games-resolution-is-not-native
//	  │Standalone build crashes when Graphics API is set to OpenGLCore and game's resolution is not native
//	  │OpenGL - Apr 04, 2017 - Priority: 7 Not yet prioritized for a release - Severity: 1 Crash or major loss of functionality
//	  │To reproduce:
//	  │1. Create new project
//	  │2. In Player Settings, set Graphics API to OpenGLCore
//	  │3. Build standalone project
//	  │4. Run project
//	  │5. In Launcher, set resolution to different than the monitors' resolution
//	  │6. Set windowed to false
//	  │7. Close the game with ALT + F4
//	  │Expected: playing the game, which was built with Graphics API set to OpenGLCore should not crash the game, if it has been set to fullscreen with some other resolution than the native resolution of the monitor and you quit from the game using ALT + F4
//	  │Actual: playing the game, which was built with Graphics API set to OpenGLCore crashes the game, if it has been set to fullscreen with some other resolution than the native resolution of the monitor and you quit from the game using ALT + F4
//	  │Reproduced in 5.5.2p4, 5.5.3f1, 5.6.0f3, 5.6.0p1, 2017.1.0b1
//	  アプリケーション側の対策では回避出来なさそうなので、Unityが直るまで描画APIにOpenGLCoreを選択しないようにするしか無さそうです。
//
#if     UNITY_5_3_OR_NEWER
//	#define USE_COLOR_MATERIAL	単色テクスチャの色の設定方法を選択出来るようにしました。USE_COLOR_MATERIALを定義すると、マテリアルを使って設定します(2017/05/13以前の動作)。USE_COLOR_MATERIALを定義しないと、頂点カラーを使って設定します(2017/05/14以降の動作)。
using System;
using System.IO;
using System.Collections.Generic;
using System.Reflection;
using UnityEngine;
using UnityEngine.SceneManagement;
using static org.piece_me.libclip;
using static Const;
public static partial class Program {
	//*****************************************************************************
	//	ローカル変数
	//*****************************************************************************
	private static class Graph {
		public static GameObject			goRoot;			//表示オブジェクトのルートGameObject
		public static int				layer;			//オブジェクトプールから次に取得するオブジェクトに設定するレイヤー	Reset()で戻す。CbkQue_SetLayer()で設定する。
		public static int				sortingOrder;		//オブジェクトプールから次に取得するオブジェクトに設定するオーダー順	Reset()で戻す。CbkQue_SetSortingOrder()で明示的に設定する。ObjectPool<T>.GetObject()で自動的に進む。
		//-----------------------------------------------------------------------------
		public static MaterialPool			materialPool		= new MaterialPool();			//マテリアルプール	//{{2017/05/09追加:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。}}
		public static ObjectPool<MovieObject>		movieObjectPool		= new ObjectPool<MovieObject>();	//Movieオブジェクトプール
		public static ObjectPool<SpriteObject>		spriteObjectPool	= new ObjectPool<SpriteObject>();	//Spriteオブジェクトプール
		public static ObjectPool<LineObject>		lineObjectPool		= new ObjectPool<LineObject>();		//Lineオブジェクトプール
		public static ObjectPool<BoxObject>		boxObjectPool		= new ObjectPool<BoxObject>();		//Boxオブジェクトプール
		public static ObjectPool<PolygonObject>		polygonObjectPool	= new ObjectPool<PolygonObject>();	//Polygonオブジェクトプール
		//-----------------------------------------------------------------------------
		public static Dictionary<int,ST_TexDef>		texDefCache		= new Dictionary<int,ST_TexDef>();	//取得済みのテクスチャ定義キャッシュ
		public static Dictionary<int,ST_SprDef>		sprDefCache		= new Dictionary<int,ST_SprDef>();	//取得済みのスプライト定義キャッシュ
		public static Dictionary<int,Texture2D>		textureCache		= new Dictionary<int,Texture2D>();	//ロード済みのテクスチャキャッシュ
		public static Dictionary<int,Sprite>		spriteCache		= new Dictionary<int,Sprite>();		//ロード済みのスプライトキャッシュ
		//-----------------------------------------------------------------------------
		public static ST_MovieHelper			pMovieHelper;
	}
//{{2017/05/09追加:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
	//*****************************************************************************
	//	マテリアルプール
	//*****************************************************************************
	private class MaterialPool {
		private List<Material>	TBL_Material	= new List<Material>();	//作成した全てのマテリアル
		private int		Count;					//マテリアルを取り出した数
		//-----------------------------------------------------------------------------
		//マテリアルを取得する。
		public Material GetMaterial(Texture texture/*null可*/, Color color) {
			Material material;
			//取り出したマテリアルの中に、同じテクスチャで同じカラーのマテリアルが有れば、それを返す。
			// - 取り出したマテリアルをハッシュテーブルで管理する方が良いとは思うが、1フレーム内にさほど多くの種類のマテリアルは存在しないと思うので、リニアサーチでも十分だろう。
			for(int i = 0; i < Count; i++) {
				material = TBL_Material[i];
				if((material.mainTexture == texture) && (material.color == color)) { return material; }
			}
			//プールが空ならば…
			if(Count == TBL_Material.Count) {
				//マテリアルを作成して、プールに追加する。
				TBL_Material.Add(new Material(Shader.Find("Sprites/Default")));	//※要検討。深度バッファを無視して背面消去もしないシェーダなら何でも良い。	【注意】シーンでこのシェーダが参照されない場合は、ProjectSettings/Graphicsで"Always Included Shaders"リストに含めておく必要が有ります。現在の所、シーンでこのシェーダが参照しているので、左記の設定は必要有りません。
			}
			//プールから、マテリアルを取得する。
			material = TBL_Material[Count++];
			//マテリアルを設定する。
			material.mainTexture = texture;
			material.color = color;
			//マテリアルを返す。
			return material;
		}
		//-----------------------------------------------------------------------------
		//プールをリセットする。
		public void Reset() {
			Count = 0;
		}
	}
//}}2017/05/09追加:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
	//*****************************************************************************
	//	オブジェクトプール
	//*****************************************************************************
	private class ObjectPool<T> where T : PoolObject, new() {
		private List<T>		TBL_PoolObject	= new List<T>();	//作成した全てのオブジェクト
		private int		Count;					//オブジェクトを取り出した数
		//-----------------------------------------------------------------------------
		//オブジェクトを取得する。
		public T GetObject() {
			//プールが空ならば…
			if(Count == TBL_PoolObject.Count) {
				//オブジェクトを作成して、プールに追加する。
				TBL_PoolObject.Add(new T());
			}
			//プールから、オブジェクトを取得する。
			T po = TBL_PoolObject[Count++];
			//オブジェクトを有効にする。
			po.SetActive(true);
			//オブジェクトのレイヤを設定する。
			po.SetLayer(Graph.layer);
			//レンダラーのオーダー順を設定する。
			po.SetSortingOrder(Graph.sortingOrder++);
			//オブジェクトを返す。
			return po;
		}
		//-----------------------------------------------------------------------------
		//プールをリセットする。
		public void Reset() {
			//取り出された各オブジェクトについて…
			while(Count != 0) {
				//オブジェクトを無効に戻す。
				T po = TBL_PoolObject[--Count];
				po.SetActive(false);
			}
		}
	}
	//*****************************************************************************
	//	プールオブジェクトの基底クラス
	//*****************************************************************************
	private abstract class PoolObject {
		public GameObject		goOuter;		//外側のオブジェクト
		public GameObject		goInner;		//内側のオブジェクト
		public abstract Renderer	renderer { get; }	//内側のオブジェクトのレンダラー
		//-----------------------------------------------------------------------------
		protected PoolObject() {
			//外側のGameObjectを作成する。
			goOuter = new GameObject();
			goOuter.transform.SetParent(Graph.goRoot.transform, false);
		}
		//-----------------------------------------------------------------------------
		public void SetActive(bool value) {
			//外側のオブジェクトを有効,又は,無効にする。
			goOuter.SetActive(value);
		}
		//-----------------------------------------------------------------------------
		public void SetLayer(int layer) {
			//内側のオブジェクトのレイヤを設定する。
			goInner.layer = layer;
		}
		//-----------------------------------------------------------------------------
		public void SetSortingOrder(int sortingOrder) {
			//レンダラーのオーダー順を設定する。
			renderer.sortingOrder = sortingOrder;
		}
	}
	//*****************************************************************************
	//	Movieオブジェクト
	//*****************************************************************************
	private class MovieObject : PoolObject {
		public MeshRenderer	meshRenderer;		//内側のオブジェクトのMeshRenderer
//{{2017/04/12追加:draw_spr()にて、ムービーのカラーブレンディングも対応しました。
		public MeshFilter	meshFilter;		//内側のオブジェクトのMeshFilter
//}}2017/04/12追加:draw_spr()にて、ムービーのカラーブレンディングも対応しました。
		//-----------------------------------------------------------------------------
		public MovieObject() {
			//内側のGameObjectを作成する。
			goInner = GameObject.CreatePrimitive(PrimitiveType.Quad);
			goInner.transform.SetParent(goOuter.transform, false);
			//MeshRendererを取得しておく。
			meshRenderer = goInner.GetComponent<MeshRenderer>();
			if(meshRenderer == null) { throw new ApplicationException(); }
//{{2017/04/12追加:draw_spr()にて、ムービーのカラーブレンディングも対応しました。
			//MeshFilterを取得しておく。
			meshFilter = goInner.GetComponent<MeshFilter>();
			if(meshFilter == null) { throw new ApplicationException(); }
//}}2017/04/12追加:draw_spr()にて、ムービーのカラーブレンディングも対応しました。
		}
		//-----------------------------------------------------------------------------
		//PoolObject
		public override Renderer renderer {
			get {
				//内側のオブジェクトのレンダラーを返す。
				return meshRenderer;
			}
		}
	}
	//*****************************************************************************
	//	Spriteオブジェクト
	//*****************************************************************************
	private class SpriteObject : PoolObject {
		public SpriteRenderer	spriteRenderer;		//内側のオブジェクトのSpriteRenderer
		//-----------------------------------------------------------------------------
		public SpriteObject() {
			//内側のGameObjectを作成する。
			goInner = new GameObject(null, typeof(SpriteRenderer));
			goInner.transform.SetParent(goOuter.transform, false);
			//SpriteRendererを取得しておく。
			spriteRenderer = goInner.GetComponent<SpriteRenderer>();
			if(spriteRenderer == null) { throw new ApplicationException(); }
		}
		//-----------------------------------------------------------------------------
		//PoolObject
		public override Renderer renderer {
			get {
				//内側のオブジェクトのレンダラーを返す。
				return spriteRenderer;
			}
		}
	}
	//*****************************************************************************
	//	Lineオブジェクト
	//*****************************************************************************
	private class LineObject : PoolObject {
		public LineRenderer	lineRenderer;		//内側のオブジェクトのLineRenderer
//{{2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//		public Material		material;		//内側のオブジェクトのLineRendererのMaterial
//}}2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
		//-----------------------------------------------------------------------------
		public LineObject() {
			//内側のGameObjectを作成する。
			goInner = new GameObject();
			goInner.transform.SetParent(goOuter.transform, false);
			goInner.transform.localPosition = new Vector2(	//位置は固定。
				(float)(-(DISP_X / 2) / PPU),
				(float)( (DISP_Y / 2) / PPU));
			goInner.transform.localScale = new Vector2(	//スケールも固定。ただし、goInner.transform.localScaleはlineRenderer.startWidth,endWidthには影響しないようなので、lineRenderer.startWidth,endWidthにもスケールを掛ける必要が有ります。
				(float)( 1.0 / PPU),
				(float)(-1.0 / PPU));
			//LineRendererを作成する。
			lineRenderer = goInner.AddComponent<LineRenderer>();
			lineRenderer.useWorldSpace = false;	//必要です!!
//{{2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//			//Materialを作成する。
//			material = new Material(Shader.Find("Sprites/Default"));	//※要検討。深度バッファを無視して背面消去もしないシェーダなら何でも良い。	【注意】シーンでこのシェーダが参照されない場合は、ProjectSettings/Graphicsで"Always Included Shaders"リストに含めておく必要が有ります。現在の所、シーンでこのシェーダが参照しているので、左記の設定は必要有りません。
//			if(material == null) { throw new ApplicationException(); }
//			lineRenderer.material = material;
//}}2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
		}
		//-----------------------------------------------------------------------------
		//PoolObject
		public override Renderer renderer {
			get {
				//内側のオブジェクトのレンダラーを返す。
				return lineRenderer;
			}
		}
	}
	//*****************************************************************************
	//	Boxオブジェクト
	//*****************************************************************************
	private class BoxObject : PoolObject {
		public MeshRenderer	meshRenderer;		//内側のオブジェクトのMeshRenderer
//{{2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//		public Material		material;		//内側のオブジェクトのMeshRendererのMaterial
//}}2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
#if     !USE_COLOR_MATERIAL
		public MeshFilter	meshFilter;		//内側のオブジェクトのMeshFilter
#endif//!USE_COLOR_MATERIAL
		//-----------------------------------------------------------------------------
		public BoxObject() {
			//内側のGameObjectを作成する。
			goInner = GameObject.CreatePrimitive(PrimitiveType.Quad);
			goInner.transform.SetParent(goOuter.transform, false);
			//内側のGameObjectのQuadが(0,0)-(1,1)になるようにしておく。
			goInner.transform.localPosition = new Vector2(
				(float)( 0.5 / PPU),
				(float)(-0.5 / PPU));
			goInner.transform.localScale = new Vector2(
				(float)( 1.0 / PPU),
				(float)( 1.0 / PPU));
			//MeshRendererを取得しておく。
			meshRenderer = goInner.GetComponent<MeshRenderer>();
			if(meshRenderer == null) { throw new ApplicationException(); }
//{{2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//			//Materialを作成する。
//			material = new Material(Shader.Find("Sprites/Default"));	//※要検討。深度バッファを無視して背面消去もしないシェーダなら何でも良い。	【注意】シーンでこのシェーダが参照されない場合は、ProjectSettings/Graphicsで"Always Included Shaders"リストに含めておく必要が有ります。現在の所、シーンでこのシェーダが参照しているので、左記の設定は必要有りません。
//			if(material == null) { throw new ApplicationException(); }
//			meshRenderer.material = material;
//}}2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
#if     !USE_COLOR_MATERIAL
			//MeshFilterを取得しておく。
			meshFilter = goInner.GetComponent<MeshFilter>();
			if(meshFilter == null) { throw new ApplicationException(); }
#endif//!USE_COLOR_MATERIAL
		}
		//-----------------------------------------------------------------------------
		//PoolObject
		public override Renderer renderer {
			get {
				//内側のオブジェクトのレンダラーを返す。
				return meshRenderer;
			}
		}
	}
	//*****************************************************************************
	//	Polygonオブジェクト
	//*****************************************************************************
	private class PolygonObject : PoolObject {
		public MeshRenderer	meshRenderer;		//内側のオブジェクトのMeshRenderer
//{{2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//		public Material		material;		//内側のオブジェクトのMeshRendererのMaterial
//}}2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
		public MeshFilter	meshFilter;		//内側のオブジェクトのMeshFilter
		//-----------------------------------------------------------------------------
		public PolygonObject() {
			//内側のGameObjectを作成する。
			goInner = new GameObject();
			goInner.transform.SetParent(goOuter.transform, false);
			goInner.transform.localPosition = new Vector2(	//位置は固定。
				(float)(-(DISP_X / 2) / PPU),
				(float)( (DISP_Y / 2) / PPU));
			goInner.transform.localScale = new Vector2(	//スケールも固定。
				(float)( 1.0 / PPU),
				(float)(-1.0 / PPU));
			//MeshRendererを作成する。
			meshRenderer = goInner.AddComponent<MeshRenderer>();
//{{2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//			//Materialを作成する。
//			material = new Material(Shader.Find("Sprites/Default"));	//※要検討。深度バッファを無視して背面消去もしないシェーダなら何でも良い。	【注意】シーンでこのシェーダが参照されない場合は、ProjectSettings/Graphicsで"Always Included Shaders"リストに含めておく必要が有ります。現在の所、シーンでこのシェーダが参照しているので、左記の設定は必要有りません。
//			if(material == null) { throw new ApplicationException(); }
//			meshRenderer.material = material;
//}}2017/05/09削除:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
			//MeshFilterを作成する。
			meshFilter = goInner.AddComponent<MeshFilter>();
			//Meshを作成する。
			meshFilter.mesh = new Mesh();
		}
		//-----------------------------------------------------------------------------
		//PoolObject
		public override Renderer renderer {
			get {
				//内側のオブジェクトのレンダラーを返す。
				return meshRenderer;
			}
		}
	}
	//*****************************************************************************
	//	テクスチャ定義
	//*****************************************************************************
	public class ST_TexDef {
		public string		sPath;			//パス			スプライトの場合はリソースパス、ムービーの場合はファイルパス
		public bool		bLoop;			//ループフラグ		ムービーの場合のみ
//{{2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
//		public bool		bAdditive;		//加算モード
//↓2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
		public bool		bAdd;			//加算モード
//}}2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
//{{2017/03/31追加:テクスチャの自動スケーリングを追加しました。
		public int		nScale;			//拡大率
//}}2017/03/31追加:テクスチャの自動スケーリングを追加しました。
		//-----------------------------------------------------------------------------
		public bool	isSprite {
			get {
				return string.IsNullOrEmpty(Path.GetExtension(sPath));	//※仮:パスに拡張子が無ければ、リソースパスであると判断して、スプライトと見なす事にした。
			}
		}
		//-----------------------------------------------------------------------------
		public bool	isMovie {
			get {
				return !isSprite;					//※仮:スプライトでなければ、ムービーと見なす事にした。
			}
		}
	}
	//*****************************************************************************
	//	スプライト定義
	//*****************************************************************************
	public class ST_SprDef {
		public int		iTexNo;			//テクスチャ番号
		public int		x, y;			//左上座標
		public int		w, h;			//幅、高さ
		public int		cx, cy;			//原点オフセット
		//-----------------------------------------------------------------------------
		public bool	isSprite {
			get {
				return GetTexDef(iTexNo).isSprite;
			}
		}
		//-----------------------------------------------------------------------------
		public bool	isMovie {
			get {
				return GetTexDef(iTexNo).isMovie;
			}
		}
	}
	//*****************************************************************************
	//	Movieプレイヤーの実装
	//*****************************************************************************
	public class MoviePlayer : IMoviePlayer {
		public CriManaMovieMaterial	criManaMovieMaterial;	//ムービーマテリアル
		//-----------------------------------------------------------------------------
		public MoviePlayer() {
			//ムービーマテリアルを作成する。
			criManaMovieMaterial = Graph.goRoot.AddComponent<CriManaMovieMaterial>();
//{{2017/06/05削除:関係なかったクラッシュ対策を削除しました。
////{{2017/05/29追加:MoviePlayer()にて作成したムービーマテリアルに対するDontDestroyOnLoad()を追加しました。
//			UnityEngine.Object.DontDestroyOnLoad(criManaMovieMaterial);
////}}2017/05/29追加:MoviePlayer()にて作成したムービーマテリアルに対するDontDestroyOnLoad()を追加しました。
//}}2017/06/05削除:関係なかったクラッシュ対策を削除しました。
		}
		//-----------------------------------------------------------------------------
		void IDisposable.Dispose() {
//{{2017/06/05削除:この対策は関係なかったので削除しました。詳細は当ファイル(clipgrp_uni.cs)の先頭部分の、'Mon Jun 05 22:04:11 JST 2017 Naoyuki Sawa'のコメントを参照して下さい。
////{{2017/06/05追加:MoviePlayer.Dispose()にて、ムービーマテリアルを削除する前に、確実に停止しておくようにしました。
//			//再生,又は,再生準備を確実に停止する。(既に停止中だった場合もStop()を呼び出して安全です。)
//			((IMoviePlayer)this).Stop();
////}}2017/06/05追加:MoviePlayer.Dispose()にて、ムービーマテリアルを削除する前に、確実に停止しておくようにしました。
//}}2017/06/05削除:この対策は関係なかったので削除しました。詳細は当ファイル(clipgrp_uni.cs)の先頭部分の、'Mon Jun 05 22:04:11 JST 2017 Naoyuki Sawa'のコメントを参照して下さい。
			//ムービーマテリアルを削除する。
			UnityEngine.Object.Destroy(criManaMovieMaterial);
		}
		//-----------------------------------------------------------------------------
		MoviePlayerStatus IMoviePlayer.GetStatus() {
			//プレイヤーの状態を取得する。
			return (MoviePlayerStatus)criManaMovieMaterial.player.status;
		}
		//-----------------------------------------------------------------------------
		void IMoviePlayer.Prepare(int iTexNo) {
			//テクスチャ番号を検査する。
			if((iTexNo < 1) || (iTexNo > TexNo_Max)) { throw new ApplicationException(); }
			//テクスチャ定義を取得する。
			ST_TexDef stTexDef = GetTexDef(iTexNo);
			//テクスチャのファイルパス,ループ設定,加算合成モード設定を設定する。
			if(!criManaMovieMaterial.player.SetFile(binder, stTexDef.sPath)) { throw new ApplicationException(); }
			criManaMovieMaterial.player.Loop(stTexDef.bLoop);
//{{2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
//			criManaMovieMaterial.player.additiveMode = stTexDef.bAdditive;
//↓2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
			criManaMovieMaterial.player.additiveMode = stTexDef.bAdd;
//}}2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
			//再生準備を開始する。
			criManaMovieMaterial.player.Prepare();
//{{2017/06/05削除:関係なかったクラッシュ対策を削除しました。
////{{2017/05/17追加:MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。
//			//今回の周期処理の直後にはフレームスキップを行わない方が安全である事を示すフラグをセットする。
//			// - クリアは、アプリケーション側のフレームスキップ処理の中で行って下さい。
//			//   詳細は、MoviePlayerクラスのbPreventFrameSkipping定義箇所のコメントを参照して下さい。
//			bPreventFrameSkipping = true;
////}}2017/05/17追加:MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。
//}}2017/06/05削除:関係なかったクラッシュ対策を削除しました。
		}
		//-----------------------------------------------------------------------------
		void IMoviePlayer.Start() {
			//再生を開始する。
			criManaMovieMaterial.player.Start();
//{{2017/06/05削除:関係なかったクラッシュ対策を削除しました。
////{{2017/05/17追加:MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。
//			//今回の周期処理の直後にはフレームスキップを行わない方が安全である事を示すフラグをセットする。
//			// - クリアは、アプリケーション側のフレームスキップ処理の中で行って下さい。
//			//   詳細は、MoviePlayerクラスのbPreventFrameSkipping定義箇所のコメントを参照して下さい。
//			bPreventFrameSkipping = true;
////}}2017/05/17追加:MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。
//}}2017/06/05削除:関係なかったクラッシュ対策を削除しました。
			//マテリアルが有効になるまで待つ。
			for(;;) {
				if(criManaMovieMaterial.player.status == CriMana.Player.Status.Error) { throw new ApplicationException(); }
				if(criManaMovieMaterial.isMaterialAvailable) { break; }
//{{2017/05/30追加:クラッシュ対策として、明示的にCriManaMovieMaterial.Update()を呼び出す時は、renderModeをNeverにして呼び出すように修正しました。
				CriManaMovieMaterial.RenderMode save_renderMode = criManaMovieMaterial.renderMode;
				criManaMovieMaterial.renderMode = CriManaMovieMaterial.RenderMode.Never;
//}}2017/05/30追加:クラッシュ対策として、明示的にCriManaMovieMaterial.Update()を呼び出す時は、renderModeをNeverにして呼び出すように修正しました。
				typeof(CriManaMovieMaterial).InvokeMember("Update", BindingFlags.InvokeMethod|BindingFlags.NonPublic, null, criManaMovieMaterial, null);	//CriManaMovieMaterial.Update()を呼び出すために左記の処理が必要です。criManaMovieMaterial.player.Update()ではマテリアルが更新されないのでダメです(Unityが落ちたりします)。
//{{2017/05/30追加:クラッシュ対策として、明示的にCriManaMovieMaterial.Update()を呼び出す時は、renderModeをNeverにして呼び出すように修正しました。
				criManaMovieMaterial.renderMode = save_renderMode;
//}}2017/05/30追加:クラッシュ対策として、明示的にCriManaMovieMaterial.Update()を呼び出す時は、renderModeをNeverにして呼び出すように修正しました。
			}
		}
		//-----------------------------------------------------------------------------
		void IMoviePlayer.Stop() {
			//再生,又は,再生準備を停止する。
			criManaMovieMaterial.Stop();
//{{2017/06/05削除:関係なかったクラッシュ対策を削除しました。
////{{2017/05/17追加:MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。
//			//今回の周期処理の直後にはフレームスキップを行わない方が安全である事を示すフラグをセットする。
//			// - クリアは、アプリケーション側のフレームスキップ処理の中で行って下さい。
//			//   詳細は、MoviePlayerクラスのbPreventFrameSkipping定義箇所のコメントを参照して下さい。
//			bPreventFrameSkipping = true;
////}}2017/05/17追加:MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。
//}}2017/06/05削除:関係なかったクラッシュ対策を削除しました。
			//プレイヤーの状態が停止中になるまで待つ。
			for(;;) {
				CriMana.Player.Status status = criManaMovieMaterial.player.status;
				if(status == CriMana.Player.Status.Error) { throw new ApplicationException(); }
				if(status == CriMana.Player.Status.Stop) { break; }
//{{2017/05/30追加:クラッシュ対策として、明示的にCriManaMovieMaterial.Update()を呼び出す時は、renderModeをNeverにして呼び出すように修正しました。
				CriManaMovieMaterial.RenderMode save_renderMode = criManaMovieMaterial.renderMode;
				criManaMovieMaterial.renderMode = CriManaMovieMaterial.RenderMode.Never;
//}}2017/05/30追加:クラッシュ対策として、明示的にCriManaMovieMaterial.Update()を呼び出す時は、renderModeをNeverにして呼び出すように修正しました。
				typeof(CriManaMovieMaterial).InvokeMember("Update", BindingFlags.InvokeMethod|BindingFlags.NonPublic, null, criManaMovieMaterial, null);	//CriManaMovieMaterial.Update()を呼び出すために左記の処理が必要です。criManaMovieMaterial.player.Update()ではマテリアルが更新されないのでダメです(Unityが落ちたりします)。
//{{2017/05/30追加:クラッシュ対策として、明示的にCriManaMovieMaterial.Update()を呼び出す時は、renderModeをNeverにして呼び出すように修正しました。
				criManaMovieMaterial.renderMode = save_renderMode;
//}}2017/05/30追加:クラッシュ対策として、明示的にCriManaMovieMaterial.Update()を呼び出す時は、renderModeをNeverにして呼び出すように修正しました。
			}
		}
//{{2017/06/05削除:関係なかったクラッシュ対策を削除しました。
////{{2017/05/17追加:MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。
//		// * Wed May 17 21:36:23 JST 2017 Naoyuki Sawa
//		// - MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。
//		//   追加した理由は、以下の通りです。
//		// - Unity Version 5.6.0f3現在、CriManaMovieMaterialやCriManaMovieMaterial.Playerを操作した直後にフレームスキップ処理を行うと、「nvwgf2um.dll caused an Access Violation (0xc0000005)」が発生して、プログラムがクラッシュする事が有るようです。
//		//   特に、CriManaMovieMaterial.Stop()を呼び出した直後にフレームスキップ処理を行うと、高頻度でクラッシュするようです。
//		//   具体的な原因はまだわからないのですが、仕方が無いので、暫定回避策として、CriManaMovieMaterialやCriManaMovieMaterial.Playerを操作した事を覚えておき、そのフレームではフレームスキップ処理を行わないようにする事しました。
//		// - アプリケーションのメインループ側の処理としては、以下のようにして下さい。
//		//   │	//GameController.cs
//		//   │	//-----------------------------------------------------------------------------
//		//   │	private static class FrameSkip {
//		//   │		public static int	t0;		//前回のEnvironment.TickCountの値。
//		//   │		public static int	f0;		//前回のフレームカウンタ。
//		//   │		public static int	fs;		//フレームスキップの残り回数。
//		//   │	}
//		//   │	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//		//   │	private void Update() {
//		//   │		bool bFrameSkip;
//		//   │		do {
//		//   │			bFrameSkip = false;	//今回のフレームでフレームスキップを行うか。
//		//   │			//フレームスキップの残り回数が有れば、○%でフレームスキップを行う。
//		//   │		    //	if((FrameSkip.fs != 0) && ((now & 3) < 1)/*25%*/) { bFrameSkip = true; }	//┐
//		//   │			if((FrameSkip.fs != 0) && ((now & 3) < 2)/*50%*/) { bFrameSkip = true; }	//├どれか一つを選択して下さい。
//		//   │		    //	if((FrameSkip.fs != 0) && ((now & 3) < 3)/*75%*/) { bFrameSkip = true; }	//┘
//		//   │			{
//		//   │				int df;
//		//   │				for(;;) {
//		//   │					//タイマ処理を実行する。
//		//   │					{
//		//   │						int t1 = Environment.TickCount;				//現在時刻を取得する。
//		//   │						if(FrameSkip.t0 == 0) { FrameSkip.t0 = t1; }		//初回ならば基準時間を格納する。厳密には二回目以降で0の場合も格納してしまうが動作上問題無い。
//		//   │						int dt = t1 - FrameSkip.t0;				//経過時間を求める。
//		//   │						FrameSkip.t0 = t1;					//次回の基準時間を更新する。
//		//   │						if((uint)dt > 1000/*調整可*/) { dt = 1000/*調整可*/; }	//リミッタ
//		//   │						while(dt-- != 0) { TimMgr_Intr(stTimMgr); }		//マイコン基板ではタイマの割り込み処理に相当する。
//		//   │						TimMgr_Exec(stTimMgr);					//タイマの周期処理を実行する。
//		//   │					}
//		//   │					//ループを抜けるかを判定する。
//		//   │					{
//		//   │						int f1 = TimMgr_GetCnt(stTimMgr, TimMgrCh_1f);		//現在のフレームカウンタを取得する。
//		//   │						df = f1 - FrameSkip.f0;					//現在の経過フレーム数を求める。
//		//   │						FrameSkip.f0 = f1;					//次回のためにフレームカウンタを記憶する。
//		//   │						if((df != 0) || bFrameSkip) { break; }			//1フレーム以上経過したか,又は,今回のフレームでフレームスキップを行うならば、ループを抜ける。
//		//   │					}
//		//   │				}
//		//   │				if((uint)df < 1) {				//フレームスキップを消化したならば…
//		//   │					UVAR_DEC(ref FrameSkip.fs);		//フレームスキップの残り回数を減らす。
//		//   │				} else if((uint)df > 1) {			//時間オーバーが発生したならば…
//		//   │					UVAR_ADD(ref FrameSkip.fs, df - 1);	//フレームスキップの残り回数を増やす。実際にフレームスキップを行うのは次回以降のフレームです。
//		//   │					if((uint)FrameSkip.fs > (uint)SEC(0.5/*調整可*/)) { FrameSkip.fs = SEC(0.5/*調整可*/); }	//リミッタ
//		//   │				}
//		//   │			}
//		//   │			//周期処理の本体を実行する。
//		//   │			Update_subr();
//		//   │	//{{2017/05/17追加:MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。
//		//   │			if(MoviePlayer.bPreventFrameSkipping) {			//今回の周期処理の中で、今回の周期処理の直後にはフレームスキップを行わない方が安全である事を示すフラグがセットされていたら…	//┐★★★★★注目★★★★★
//		//   │				MoviePlayer.bPreventFrameSkipping = false;	//次回のために、フラグをクリアする。												//│★★★★★注目★★★★★
//		//   │				break;						//今回はフレームスキップを行わずに、確実にUnityに処理を返す。									//│★★★★★注目★★★★★
//		//   │			}																							//┘★★★★★注目★★★★★
//		//   │	//}}2017/05/17追加:MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。
//		//   │		} while(bFrameSkip);	//今回のフレームでフレームスキップを行うならば、Unityに処理を返さずに(=描画を行わずに)周期処理を繰り返す。
//		//   │	}
//		// - 上記の対策を行っても、まだ完全には解決していません。
//		//   稀に、別のDLLの、「nvwgf2umx.dll caused an Access Violation (0xc0000005)」というエラーで、クラッシュする事が有るみたいです。
//		//   しかし、前述のクラッシュよりは頻度が低いので、今回の対策もいくらか効果は有ったと思います。
//		//   引き続き、具体的な原因を調査しようと思います。
//}}2017/06/05削除:関係なかったクラッシュ対策を削除しました。
		// * Mon May 22 22:18:20 JST 2017 Naoyuki Sawa
		// - 上記の、別のDLLの、「nvwgf2umx.dll caused an Access Violation (0xc0000005)」というエラーでクラッシュする問題に対する、対策を行いました。
		//   試行錯誤で実験した限りではクラッシュしない方法を見付けただけであり、クラッシュの原因が判った訳ではありません。
		//   今回取った方法の詳細は、以下の通りです。
		// - どうやら、一回のUpdate()の中で、二回フレームスキップを行うと、クラッシュし易いようです。		⇒{{2017/06/05追記:左記の推測は間違いでした。クラッシュ対策としては関係ありませんでした。ただし、クラッシュ対策としては関係なかったのですが、変更後の50%フレームスキップ処理の方が連続二回スキップにならなくて望ましいので、この変更は残しておく事にしました。}}
		//   前回までの処理では、50%フレームスキップの時に、「((now & 3) < 2)/*50%*/)」の判定がtrue,true,false,falseになり、一回のUpdate()の中で、二回フレームスキップを行う事が有り得ました。
		//   そこで今回変更して、フレームスキップ機能なUpdate()が交互に成立するような条件に変更しました。
		//   │	//GameController.cs
		//   │	//-----------------------------------------------------------------------------
		//   │	private static class FrameSkip {
		//   │		public static int	t0;		//前回のEnvironment.TickCountの値。
		//   │		public static int	f0;		//前回のフレームカウンタ。
		//   │		public static int	fs;		//フレームスキップの残り回数。
		//   │		public static bool	PrevSkip;	//前回のUpdate()でフレームスキップを実行したフラグ。
		//   │	}
		//   │	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		//   │	private void Update() {
		//   │		bool bFrameSkip = false;	//今回のUpdate()でフレームスキップを行うかのフラグ。
		//   │		if(FrameSkip.fs != 0) {			//フレームスキップの残り回数が有り…
		//   │			if(!FrameSkip.PrevSkip) {	//前回のUpdate()でフレームスキップを実行していなければ…
		//   │				bFrameSkip = true;	//今回のUpdate()でフレームスキップを行う。
		//   │			}
		//   │		}
		//   │		FrameSkip.PrevSkip = false;		//前回のUpdate()でフレームスキップを実行したフラグを確実にクリアする。
		//   │		//以下のループを一回,又は,二回実行する。
		//   │		for(;;) {
		//   │			{
		//   │				int df;
		//   │				for(;;) {
		//   │					//タイマ処理を実行する。
		//   │					{
		//   │						int t1 = Environment.TickCount;				//現在時刻を取得する。
		//   │						if(FrameSkip.t0 == 0) { FrameSkip.t0 = t1; }		//初回ならば基準時間を格納する。厳密には二回目以降で0の場合も格納してしまうが動作上問題無い。
		//   │						int dt = t1 - FrameSkip.t0;				//経過時間を求める。
		//   │						FrameSkip.t0 = t1;					//次回の基準時間を更新する。
		//   │						if((uint)dt > 1000/*調整可*/) { dt = 1000/*調整可*/; }	//リミッタ
		//   │						while(dt-- != 0) { TimMgr_Intr(stTimMgr); }		//マイコン基板ではタイマの割り込み処理に相当する。
		//   │						TimMgr_Exec(stTimMgr);					//タイマの周期処理を実行する。
		//   │					}
		//   │					//ループを抜けるかを判定する。
		//   │					{
		//   │						int f1 = TimMgr_GetCnt(stTimMgr, TimMgrCh_1f);		//現在のフレームカウンタを取得する。
		//   │						df = f1 - FrameSkip.f0;					//現在の経過フレーム数を求める。
		//   │						FrameSkip.f0 = f1;					//次回のためにフレームカウンタを記憶する。
		//   │						if((df != 0) || bFrameSkip) { break; }			//1フレーム以上経過したか,又は,今回のフレームでフレームスキップを行うならば、ループを抜ける。
		//   │					}
		//   │				}
		//   │				if((uint)df < 1) {				//フレームスキップを消化したならば…
		//   │					UVAR_DEC(ref FrameSkip.fs);		//フレームスキップの残り回数を減らす。
		//   │				} else if((uint)df > 1) {			//時間オーバーが発生したならば…
		//   │					UVAR_ADD(ref FrameSkip.fs, df - 1);	//フレームスキップの残り回数を増やす。実際にフレームスキップを行うのは次回以降のフレームです。
		//   │					if((uint)FrameSkip.fs > (uint)SEC(0.5/*調整可*/)) { FrameSkip.fs = SEC(0.5/*調整可*/); }	//リミッタ
		//   │				}
		//   │			}
		//   │			//周期処理の本体を実行する。
		//   │			Update_subr();
		//   │			if(MoviePlayer.bPreventFrameSkipping) {			//今回の周期処理の中で、今回の周期処理の直後にはフレームスキップを行わない方が安全である事を示すフラグがセットされていたら…
		//   │				MoviePlayer.bPreventFrameSkipping = false;	//次回のために、フラグをクリアする。
		//   │				break;						//今回はフレームスキップを行わずに、確実にUnityに処理を返す。
		//   │			}
		//   │			//今回のフレームでフレームスキップを行わない,又は,2ループ目ならば、ループを抜ける。
		//   │			if(!bFrameSkip) { break; }
		//   │			//今回のフレームでフレームスキップを行うならば、Unityに処理を返さずに(=描画を行わずに)周期処理を繰り返す。
		//   │			bFrameSkip = false;		//次のループで抜けるように、今回のUpdate()でフレームスキップを行うかのフラグをクリアする。
		//   │			FrameSkip.PrevSkip = true;	//次回のUpdate()のために、'前回のUpdate()でフレームスキップを実行したフラグ'をセットする。
		//   │		}
		//   │	}
		// - 一応、試した限りでは、クラッシュしないようです。(もっと試行回数を増やせば、クラッシュする可能性は有ります…)
		//   クラッシュの原因はまだわからないのですが、どうも、UnityがDirectXのリソースの管理を別スレッドで行っているようで、フレームスキップを行うとどうもそれとの競合が発生するみたいです。(推測ですが…)
		//   今回の対策で、競合条件が回避されたわけではないのですが、何か、たまたま上手く回避出来ているのかも知れません。
		//   尚、今回の対策を取ると、前回追加したbPreventFrameSkippingの対策を行わなくても、クラッシュしないようでした。
		//   しかし、bPreventFrameSkippingの対策も行う方が確実だと思うので、bPreventFrameSkippingと、今回の対策との、両方を行う事にしました。
		// * Mon May 22 23:09:03 JST 2017 Naoyuki Sawa
		// - 上記の変更を行っても、まだクラッシュが発生しました…
		//   頻度は下がったと思うのですが、まだ根本的な解決にはなっていないようです。
		//   クラッシュログを見た所、どうもD3D11関連で落ちているようなので、描画バックエンドをD3D11⇒OpenGLに変えてみる事にしました。
		//   手順は、以下の通りです。
		//   │Unityエディタの、Edit⇒ProjectSettings⇒Player⇒Settings for PC,Mac&Linux Standalone⇒OtherSettings
		//   │⇒AutoGraphics for Windowsのチェックが、デフォルトではOnになっているので、Offにする。
		//   │⇒GraphicsAPIs for Windowsの初期値がDirect3D11,Direct3D9なので、OpenGLCoreを追加して、Direct3D11,Direct3D9を削除する。
		//   これで、しばらく様子を見てみようと思います。
		// * Mon May 29 21:46:05 JST 2017 Naoyuki Sawa
		// - 別の対策を行いました。
		//   詳細は、当ファイル(clipgrp_uni.cs)の先頭部分の、'Mon May 29 21:46:05 JST 2017 Naoyuki Sawa'のコメントを参照して下さい。
		//   もし今回の対策が有効ならば、もかすると、bPreventFrameSkippingの対策は不要だったかも知れないので、削除を検討して下さい。
		//   とりあえず、bPreventFrameSkippingの対策が残っていても害は無いはずなので、当面はbPreventFrameSkippingの対策も残しておく事にしました。
		//   ⇒Mon May 29 22:32:07 JST 2017 Naoyuki Sawa 追記: 今回の対策では解決しませんでした。引き続き解決方法を探します。
		// * Tue May 30 22:52:30 JST 2017 Naoyuki Sawa
		// - 別のクラッシュ対策を行って、動作検証中です。
		//   今回取った対策は、PC版ではフレームスキップ時の空回しを行わず、タイミング待ちを早く抜けるだけにするという方法です。
		//   Update()の実装は、以下のようになりました。
		//   変更点は、以下のコードの中の、同日のコメントを参照して下さい。
		//   │	//-----------------------------------------------------------------------------
		//   │	private static class FrameSkip {
		//   │		public static int	t0;		//前回のEnvironment.TickCountの値。
		//   │		public static int	f0;		//前回のフレームカウンタ。
		//   │		public static int	fs;		//フレームスキップの残り回数。
		//   │		public static bool	PrevSkip;	//前回のUpdate()でフレームスキップを実行したフラグ。
		//   │	}
		//   │	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		//   │	private void Update() {
		//   │		bool bFrameSkip = false;	//今回のUpdate()でフレームスキップを行うかのフラグ。
		//   │		if(FrameSkip.fs != 0) {			//フレームスキップの残り回数が有り…
		//   │			if(!FrameSkip.PrevSkip) {	//前回のUpdate()でフレームスキップを実行していなければ…
		//   │				bFrameSkip = true;	//今回のUpdate()でフレームスキップを行う。
		//   │			}
		//   │		}
		//   │		FrameSkip.PrevSkip = false;		//前回のUpdate()でフレームスキップを実行したフラグを確実にクリアする。
		//   │		//以下のループを一回,又は,二回実行する。
		//   │		for(;;) {
		//   │			{
		//   │				int df;
		//   │				for(;;) {
		//   │					//タイマ処理を実行する。
		//   │					{
		//   │						int t1 = Environment.TickCount;				//現在時刻を取得する。
		//   │						if(FrameSkip.t0 == 0) { FrameSkip.t0 = t1; }		//初回ならば基準時間を格納する。厳密には二回目以降で0の場合も格納してしまうが動作上問題無い。
		//   │						int dt = t1 - FrameSkip.t0;				//経過時間を求める。
		//   │						FrameSkip.t0 = t1;					//次回の基準時間を更新する。
		//   │						if((uint)dt > 1000/*調整可*/) { dt = 1000/*調整可*/; }	//リミッタ
		//   │						while(dt-- != 0) { TimMgr_Intr(stTimMgr); }		//マイコン基板ではタイマの割り込み処理に相当する。
		//   │						TimMgr_Exec(stTimMgr);					//タイマの周期処理を実行する。
		//   │					}
		//   │					//ループを抜けるかを判定する。
		//   │					{
		//   │						int f1 = TimMgr_GetCnt(stTimMgr, TimMgrCh_1f);		//現在のフレームカウンタを取得する。
		//   │						df = f1 - FrameSkip.f0;					//現在の経過フレーム数を求める。
		//   │						FrameSkip.f0 = f1;					//次回のためにフレームカウンタを記憶する。
		//   │						if((df != 0) || bFrameSkip) { break; }			//1フレーム以上経過したか,又は,今回のフレームでフレームスキップを行うならば、ループを抜ける。
		//   │					}
		//   │				}
		//   │				if((uint)df < 1) {				//フレームスキップを消化したならば…
		//   │					UVAR_DEC(ref FrameSkip.fs);		//フレームスキップの残り回数を減らす。
		//   │				} else if((uint)df > 1) {			//時間オーバーが発生したならば…
		//   │					UVAR_ADD(ref FrameSkip.fs, df - 1);	//フレームスキップの残り回数を増やす。実際にフレームスキップを行うのは次回以降のフレームです。
		//   │					if((uint)FrameSkip.fs > (uint)SEC(0.5/*調整可*/)) { FrameSkip.fs = SEC(0.5/*調整可*/); }	//リミッタ
		//   │				}
		//   │			}
		//   │			//周期処理の本体を実行する。
		//   │			Update_subr();
		//   │			if(MoviePlayer.bPreventFrameSkipping) {			//今回の周期処理の中で、今回の周期処理の直後にはフレームスキップを行わない方が安全である事を示すフラグがセットされていたら…
		//   │				MoviePlayer.bPreventFrameSkipping = false;	//次回のために、フラグをクリアする。
		//   │				break;						//今回はフレームスキップを行わずに、確実にUnityに処理を返す。
		//   │			}
		//   │		    #if     (UNITY_EDITOR || UNITY_STANDALONE)
		//   │			// * Tue May 30 22:52:30 JST 2017 Naoyuki Sawa
		//   │			// - Windowsで実行した場合のクラッシュ対策として、フレームスキップ処理を変更しました。
		//   │			//   具体的には、以下の通りです。
		//   │			// - 「描画APIにDirect3D9,又は,Direct3D11を使用するとムービーの高負荷時(?)に時々クラッシュする問題」の回避策を、これまで色々試してきました。
		//   │			//   かなり色々試したのですが、まだ解決出来ていません。
		//   │			//   フレームスキップ処理を組み込む前は大丈夫だったような気がするので、フレームスキップ処理を変更して直るかどうか様子を見てみようと思います。
		//   │			// - フレームスキップ処理を組み込む前は、QualitySettings.vSyncCount,Application.targetFrameRateを使用してUnity自体を固定フレームにしていました。
		//   │			//   しかしそれでは、処理の遅れが出た時に吸収出来なくて演出タイミングがずれるので、フレームスキップ処理を入れていました。
		//   │			//   しかしフレームスキップ処理がクラッシュの原因のような気もして、もしかするとUnityへ処理を返さずに2回回すのが(MoviePlayer.bPreventFrameSkippingに関係無く)駄目なのかも知れません。
		//   │			//   そこで、PC版では、常にフレームスキップの空回しはせずに、Unityへ処理を返すことにしてみました。
		//   │			//   Unityは30fpsよりも早く(60fps?)回っているはずなので、この方法でも、上記のタイミング待ちを早く抜ければ処理に追い付く効果は有るはずです。
		//   │			//   ただし、描画負荷そのものが遅れの原因だった場合は、遅れは回復出来ません。(描画は飛ばさなくなったので)
		//   │			//   これでクラッシュが解決するかどうかはわからないのですが、しばらく様子を見てみようと思います。
		//   │			// - 尚、PC版でも描画APIにOpenGLCoreを選択した場合はこれまでクラッシュは発生していなかったのでこの対策は不要なのですが、描画APIによって場合分けすると却って不具合を招きそうなので、PC版は描画APIに関係無く(OpenGLCoreでも)同じ対策を適用する事にしました。
		//   │			//   ただし、Android版は描画性能が低いと思うので、効果的に遅れを回復するためにこれまで通りのフレームスキップ処理とします。
		//   │			//   Android版はこれまでクラッシュが発生していないので、そのままで大丈夫だと思います。
		//   │			break;
		//   │		    #endif//(UNITY_EDITOR || UNITY_STANDALONE)
		//   │			//今回のフレームでフレームスキップを行わない,又は,2ループ目ならば、ループを抜ける。
		//   │			if(!bFrameSkip) { break; }
		//   │			//今回のフレームでフレームスキップを行うならば、Unityに処理を返さずに(=描画を行わずに)周期処理を繰り返す。
		//   │			bFrameSkip = false;		//次のループで抜けるように、今回のUpdate()でフレームスキップを行うかのフラグをクリアする。
		//   │			FrameSkip.PrevSkip = true;	//次回のUpdate()のために、'前回のUpdate()でフレームスキップを実行したフラグ'をセットする。
		//   │		}
		//   │	}
		//   ⇒Tue May 30 22:59:53 JST 2017 Naoyuki Sawa 追記: 上記の対策でも解決しませんでした。引き続き解決方法を探します。
		// * Tue May 30 23:03:37 JST 2017 Naoyuki Sawa
		// - 別の対策を行いました。
		//   詳細は、当ファイル(clipgrp_uni.cs)の先頭部分の、'Tue May 30 23:03:37 JST 2017 Naoyuki Sawa'のコメントを参照して下さい。
		// * Thu Jun 01 21:52:04 JST 2017 Naoyuki Sawa
		// - 多分、解決したと思います。
		//   詳細は、当ファイル(clipgrp_uni.cs)の先頭部分の、'Thu Jun 01 21:52:04 JST 2017 Naoyuki Sawa'のコメントを参照して下さい。
		// * Mon Jun 05 21:24:24 JST 2017 Naoyuki Sawa
		// - 関係なかったクラッシュ対策を削除しました。
		//   詳細は、当ファイル(clipgrp_uni.cs)の先頭部分の、'Mon Jun 05 21:24:24 JST 2017 Naoyuki Sawa'のコメントを参照して下さい。
		//   関係なかったクラッシュ対策を削除した事により、最終的なUpdate()の実装は、以下のようになりました。
		//   │	//-----------------------------------------------------------------------------
		//   │	private static class FrameSkip {
		//   │		public static int	t0;		//前回のEnvironment.TickCountの値。
		//   │		public static int	f0;		//前回のフレームカウンタ。
		//   │		public static int	fs;		//フレームスキップの残り回数。
		//   │		public static bool	PrevSkip;	//前回のUpdate()でフレームスキップを実行したフラグ。
		//   │	}
		//   │	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		//   │	private void Update() {
		//   │		bool bFrameSkip = false;	//今回のUpdate()でフレームスキップを行うかのフラグ。
		//   │		if(FrameSkip.fs != 0) {			//フレームスキップの残り回数が有り…
		//   │			if(!FrameSkip.PrevSkip) {	//前回のUpdate()でフレームスキップを実行していなければ…
		//   │				bFrameSkip = true;	//今回のUpdate()でフレームスキップを行う。
		//   │			}
		//   │		}
		//   │		FrameSkip.PrevSkip = false;		//前回のUpdate()でフレームスキップを実行したフラグを確実にクリアする。
		//   │		//以下のループを一回,又は,二回実行する。
		//   │		for(;;) {
		//   │			{
		//   │				int df;
		//   │				for(;;) {
		//   │					//タイマ処理を実行する。
		//   │					{
		//   │						int t1 = Environment.TickCount;				//現在時刻を取得する。
		//   │						if(FrameSkip.t0 == 0) { FrameSkip.t0 = t1; }		//初回ならば基準時間を格納する。厳密には二回目以降で0の場合も格納してしまうが動作上問題無い。
		//   │						int dt = t1 - FrameSkip.t0;				//経過時間を求める。
		//   │						FrameSkip.t0 = t1;					//次回の基準時間を更新する。
		//   │						if((uint)dt > 1000/*調整可*/) { dt = 1000/*調整可*/; }	//リミッタ
		//   │						while(dt-- != 0) { TimMgr_Intr(stTimMgr); }		//マイコン基板ではタイマの割り込み処理に相当する。
		//   │						TimMgr_Exec(stTimMgr);					//タイマの周期処理を実行する。
		//   │					}
		//   │					//ループを抜けるかを判定する。
		//   │					{
		//   │						int f1 = TimMgr_GetCnt(stTimMgr, TimMgrCh_1f);		//現在のフレームカウンタを取得する。
		//   │						df = f1 - FrameSkip.f0;					//現在の経過フレーム数を求める。
		//   │						FrameSkip.f0 = f1;					//次回のためにフレームカウンタを記憶する。
		//   │						if((df != 0) || bFrameSkip) { break; }			//1フレーム以上経過したか,又は,今回のフレームでフレームスキップを行うならば、ループを抜ける。
		//   │					}
		//   │				}
		//   │				if((uint)df < 1) {				//フレームスキップを消化したならば…
		//   │					UVAR_DEC(ref FrameSkip.fs);		//フレームスキップの残り回数を減らす。
		//   │				} else if((uint)df > 1) {			//時間オーバーが発生したならば…
		//   │					UVAR_ADD(ref FrameSkip.fs, df - 1);	//フレームスキップの残り回数を増やす。実際にフレームスキップを行うのは次回以降のフレームです。
		//   │					if((uint)FrameSkip.fs > (uint)SEC(0.5/*調整可*/)) { FrameSkip.fs = SEC(0.5/*調整可*/); }	//リミッタ
		//   │				}
		//   │			}
		//   │			//周期処理の本体を実行する。
		//   │			Update_subr();
		//   │			//今回のフレームでフレームスキップを行わない,又は,2ループ目ならば、ループを抜ける。
		//   │			if(!bFrameSkip) { break; }
		//   │			//今回のフレームでフレームスキップを行うならば、Unityに処理を返さずに(=描画を行わずに)周期処理を繰り返す。
		//   │			bFrameSkip = false;		//次のループで抜けるように、今回のUpdate()でフレームスキップを行うかのフラグをクリアする。
		//   │			FrameSkip.PrevSkip = true;	//次回のUpdate()のために、'前回のUpdate()でフレームスキップを実行したフラグ'をセットする。
		//   │		}
		//   │	}
//{{2017/06/05削除:関係なかったクラッシュ対策を削除しました。
//		public static bool	bPreventFrameSkipping;	//今回の周期処理の直後にはフレームスキップを行わない方が安全である事を示すフラグ
//}}2017/06/05削除:関係なかったクラッシュ対策を削除しました。
//}}2017/05/17追加:MoviePlayerクラスに、bPreventFrameSkippingフラグを追加しました。
	}
	//*****************************************************************************
	//	グローバル関数
	//*****************************************************************************
	//グラフィックの初期化処理
	public static void Graph_Init() {
		//ルートGameObjectを作成する。
		Graph.goRoot = new GameObject();
	//{{任意:普段はUnityエディタ上で確認する必要が無いと思うので非表示にしておく事にした。Unityエディタ上で確認する場合はこの範囲をコメントアウトして下さい。
		Graph.goRoot.hideFlags = HideFlags.HideInHierarchy;
	//}}任意:普段はUnityエディタ上で確認する必要が無いと思うので非表示にしておく事にした。Unityエディタ上で確認する場合はこの範囲をコメントアウトして下さい。
		//新しいシーンを読み込んでもこのオブジェクトが自動で破壊されないように設定する。
		// - LoadScene()の後にそのフレーム内でGameObjectを作成した場合、DontDestroyOnLoad()を呼んでいなければそのGameObjectも削除されるようだ。
		//   LoadScene()関数の中でシーンが移行するのでなく、そのフレームの最後にシーンが移行しているのかも知れない。(※未検証)
		//   安全のためには、LoadScene()を行ったフレームでは、他の処理は何も行わない方が良さそうだ。
		//   ここでDontDestroyOnLoad()を呼び出す目的は、上記の問題を回避するためではないのだが、結果的に問題を回避出来ている。
		// - ルートGameObjectに対してDontDestroyOnLoad()を呼び出しておけば、その全トランスフォーム階層も破壊されない。
		//   従って、この後で作成してルートGameObjectの子にする個々のGameObjectに対しては、DontDestroyOnLoad()を呼び出す必要は無い。
		UnityEngine.Object.DontDestroyOnLoad(Graph.goRoot);
		//ムービー管理の初期化を実行する。
		int nCh = criWareInitializer.manaConfig.numberOfDecoders / 2;	//全てのムービーマテリアルでアルファムービーを再生してもデコーダが足りるように、デコーダの半分の数とする事にした。
		Graph.pMovieHelper = MovieHelper_New(nCh, delegate(object arg) { return new MoviePlayer(); }, null);
	}
	//-----------------------------------------------------------------------------
	//グラフィックの周期処理
	public static void Graph_Exec() {
		//オブジェクトプールをリセットする。
		Graph.layer = 0/*Default*/;		//オブジェクトプールから次に取得するオブジェクトに設定するレイヤーをDefaultに戻す。
		Graph.sortingOrder = short.MinValue;	//オブジェクトプールから次に取得するオブジェクトに設定するオーダー順を最小値に戻す。
		Graph.materialPool.Reset();		//マテリアルプールから取り出したマテリアルをプールに返す。	//{{2017/05/09追加:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。}}
		Graph.movieObjectPool.Reset();		//Movieオブジェクトプールから取り出したオブジェクトを無効にしてプールに返す。
		Graph.spriteObjectPool.Reset();		//Spriteオブジェクトプールから取り出したオブジェクトを無効にしてプールに返す。
		Graph.lineObjectPool.Reset();		//Lineオブジェクトプールから取り出したオブジェクトを無効にしてプールに返す。
		Graph.boxObjectPool.Reset();		//Boxオブジェクトプールから取り出したオブジェクトを無効にしてプールに返す。
		Graph.polygonObjectPool.Reset();	//Polygonオブジェクトプールから取り出したオブジェクトを無効にしてプールに返す。
		//ムービー管理の周期処理を実行する。
		MovieHelper_Exec(Graph.pMovieHelper);
	}
	//-----------------------------------------------------------------------------
	//グラフィックの終了処理
	public static void Graph_Exit() {
		//ムービー管理の終了処理を実行する。
		MovieHelper_Exit(Graph.pMovieHelper);
		//ルートGameObjectを削除する。
		UnityEngine.Object.Destroy(Graph.goRoot);
	}
	//-----------------------------------------------------------------------------
	//画面のアスペクト比を固定にする。
	// - GameControllerオブジェクトのUpdate()の先頭で呼び出して下さい。
	//   □参考資料:「Unity2Dで画面のアスペクト比を固定にしたい【Unity】」(http://qiita.com/kwst/items/371542a6d3892b577b41)
	public static void StableAspect() {
		//メインカメラが無ければ何もしない。
		Camera camera = Camera.main;
		if(camera == null) { return; }	//ここまで。
		//カメラの垂直サイズの視野量の半分を設定する。
		camera.orthographicSize = (float)((DISP_Y / PPU) / 2.0);
		//画面のアスペクト比を求める。
		double scrAspect = (double)Screen.height / (double)Screen.width;
		//背景のアスペクト比を求める。
		double bgAspect = (double)DISP_Y / (double)DISP_X;
		//背景のアスペクト比が画面のアスペクト比以上ならば、背景を画面の縦幅いっぱいに表示して左右に隙間を作る。
		if(bgAspect >= scrAspect) {
			double camWidth = scrAspect / bgAspect;
			camera.rect = new Rect((float)((1.0 - camWidth) / 2.0), 0, (float)camWidth, 1);
		//背景のアスペクト比が画面のアスペクト比未満ならば、背景を画面の横幅いっぱいに表示して上下に隙間を作る。
		} else {
			double camHeight = bgAspect / scrAspect;
			camera.rect = new Rect(0, (float)((1.0 - camHeight) / 2.0), 1, (float)camHeight);
		}
	}
	//*****************************************************************************
	//	ローカル関数
	//*****************************************************************************
	//ムービーマテリアルを取得する。
	private static CriManaMovieMaterial GetMovieMaterial(int iTexNo) {
		MoviePlayer moviePlayer = (MoviePlayer)MovieHelper_Draw(Graph.pMovieHelper, iTexNo);
		return moviePlayer.criManaMovieMaterial;
	}
	//-----------------------------------------------------------------------------
	//テクスチャを取得する。
	private static Texture2D GetTexture(int iTexNo) {
		Texture2D texture;
		//テクスチャ番号を検査する。
		if((iTexNo < 1) || (iTexNo > TexNo_Max)) { throw new ApplicationException(); }
		//指定された番号のテクスチャが、まだロードされていなければ…
		if(!Graph.textureCache.TryGetValue(iTexNo, out texture)) {
			//テクスチャ定義を取得する。
			ST_TexDef stTexDef = GetTexDef(iTexNo);
			//テクスチャをロードする。
			texture = Resources.Load<Texture2D>(stTexDef.sPath);
			if(texture == null) { throw new ApplicationException(); }
			//テクスチャをキャッシュに登録する。
			Graph.textureCache.Add(iTexNo, texture);
		}
		//テクスチャを返す。
		return texture;
	}
	//-----------------------------------------------------------------------------
	//スプライトを取得する。
	private static Sprite GetSprite(int iSprNo) {
		Sprite sprite;
		//スプライト番号を検査する。
		if((iSprNo < 1) || (iSprNo > SprNo_Max)) { throw new ApplicationException(); }
		//指定された番号のスプライトが、まだロードされていなければ…
		if(!Graph.spriteCache.TryGetValue(iSprNo, out sprite)) {
			//スプライト定義を取得する。
			ST_SprDef stSprDef = GetSprDef(iSprNo);
			//テクスチャを取得する。
			Texture2D texture = GetTexture(stSprDef.iTexNo);
			//スプライトを作成する。
			Rect rect = new Rect(stSprDef.x,
			   texture.height - (stSprDef.y + stSprDef.h),	//Unityのテクスチャはボトムアップなので下端原点に補正します。
			                     stSprDef.w,
			                     stSprDef.h);
			sprite = Sprite.Create(texture, rect, Vector2.zero);
			//スプライトをキャッシュに登録する。
			Graph.spriteCache.Add(iSprNo, sprite);
		}
		//スプライトを返す。
		return sprite;
	}
	//-----------------------------------------------------------------------------
	//スプライト定義を取得する。
	public static ST_SprDef GetSprDef(int iSprNo) {
		ST_SprDef stSprDef;
		//スプライト番号を検査する。
		if((iSprNo < 1) || (iSprNo > SprNo_Max)) { throw new ApplicationException(); }
		//指定された番号のスプライト定義が、まだ取得されていなければ…
		if(!Graph.sprDefCache.TryGetValue(iSprNo, out stSprDef)) {
			//スプライト定義を取得する。
			VoidPtr pSprDef = REG_open_key_l(TBL_RegTbl, RegKey_SprDef, iSprNo);
			if(!pSprDef) { throw new ApplicationException(); }
			stSprDef = new ST_SprDef() {
				iTexNo = REG_get_value(pSprDef, RegKey_TexNo),
				x      = REG_get_value(pSprDef, RegKey_x),
				y      = REG_get_value(pSprDef, RegKey_y),
				w      = REG_get_value(pSprDef, RegKey_w),
				h      = REG_get_value(pSprDef, RegKey_h),
				cx     = REG_get_value(pSprDef, RegKey_cx),
				cy     = REG_get_value(pSprDef, RegKey_cy),
			};
			if((stSprDef.iTexNo == -1) ||
			   (stSprDef.x      == -1) ||
			   (stSprDef.y      == -1) ||
			   (stSprDef.w      == -1) ||
			   (stSprDef.h      == -1) ||
			   (stSprDef.cx     == -1) ||
			   (stSprDef.cy     == -1)) { throw new ApplicationException(); }
			//スプライト定義をキャッシュに登録する。
			Graph.sprDefCache.Add(iSprNo, stSprDef);
		}
		//スプライト定義を返す。
		return stSprDef;
	}
	//-----------------------------------------------------------------------------
	//テクスチャ定義を取得する。
	private static ST_TexDef GetTexDef(int iTexNo) {
		ST_TexDef stTexDef;
		//テクスチャ番号を検査する。
		if((iTexNo < 1) || (iTexNo > TexNo_Max)) { throw new ApplicationException(); }
		//指定された番号のテクスチャ定義が、まだ取得されていなければ…
		if(!Graph.texDefCache.TryGetValue(iTexNo, out stTexDef)) {
			//テクスチャ定義を取得する。
			VoidPtr pTexDef = REG_open_key_l(TBL_RegTbl, RegKey_TexDef, iTexNo);
			if(!pTexDef) { throw new ApplicationException(); }
			string sPath = REG_get_string(pTexDef, RegKey_Path);
			if(sPath == null) { throw new ApplicationException(); }
			bool bLoop = (REG_get_value(pTexDef, RegKey_loop) == 1);		//ループ無しならばレジストリにループフラグは格納されておらず、REG_get_value()の戻り値は(-1)である。ループ有りならばレジストリに'loop=1'が格納されている。従って、REG_get_value()の戻り値が1である場合のみbLoopを1とすれば良い。
//{{2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
//			bool bAdditive = (REG_get_value(pTexDef, RegKey_additive) == 1);	//通常モードならばレジストリにモードフラグは格納されておらず、REG_get_value()の戻り値は(-1)である。加算モードならばレジストリに'additive=1'が格納されている。従って、REG_get_value()の戻り値が1である場合のみbAdditiveを1とすれば良い。
//↓2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
			bool bAdd = (REG_get_value(pTexDef, RegKey_add) == 1);			//通常モードならばレジストリにモードフラグは格納されておらず、REG_get_value()の戻り値は(-1)である。加算モードならばレジストリに'add=1'が格納されている。従って、REG_get_value()の戻り値が1である場合のみbAddを1とすれば良い。
//}}2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
//{{2017/03/31追加:テクスチャの自動スケーリングを追加しました。
			int nScale = Math.Abs(REG_get_value(pTexDef, RegKey_scale));		//自動スケーリング無しならばレジストリに拡大率は格納されておらず、REG_get_value()の戻り値は(-1)である。自動スケーリング有りならばレジストリに'scale=0～'が格納されている。従って、REG_get_value()の戻り値が-1ならば1に変換し、0～ならばそのまま拡大率と見なせば良い。明示的に-1か0～かを判断しなくても、常に絶対値を取れば左記の結果が得られる。
//}}2017/03/31追加:テクスチャの自動スケーリングを追加しました。
			stTexDef = new ST_TexDef() {
				sPath = sPath,
				bLoop = bLoop,
//{{2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
//				bAdditive = bAdditive,
//↓2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
				bAdd = bAdd,
//}}2017/05/10変更:加算モードを示すテクスチャ属性の名前を、'additive'⇒'add'に変更しました。
//{{2017/03/31追加:テクスチャの自動スケーリングを追加しました。
				nScale = nScale,
//}}2017/03/31追加:テクスチャの自動スケーリングを追加しました。
			};
			//テクスチャ定義をキャッシュに登録する。
			Graph.texDefCache.Add(iTexNo, stTexDef);
		}
		//テクスチャ定義を返す。
		return stTexDef;
	}
	//*****************************************************************************
	//	グローバル関数
	//*****************************************************************************
//{{2017/03/30追加:CbkQue_prep_spr()を廃止し、prep_spr()を直接呼び出せるようにしました。
	//スプライト準備
	public static bool prep_spr(int iSprNo) {
		//スプライト定義を取得する。
		ST_SprDef stSprDef = GetSprDef(iSprNo);
		//ムービーならば…
		if(stSprDef.isMovie) {
			//ムービーマテリアルを準備する。準備完了ならばtrue,未完了ならばfalseを返す。
			return MovieHelper_Prepare(Graph.pMovieHelper, stSprDef.iTexNo);
		//スプライトならば…
		} else {
			//スプライトは裏読み未対応なので、常に準備が出来ていると見なしてtrueを返す。
			return true;
		}
	}
//}}2017/03/30追加:CbkQue_prep_spr()を廃止し、prep_spr()を直接呼び出せるようにしました。
	//*****************************************************************************
	//	優先度付き描画
	//*****************************************************************************
	//シーンを切り替える。
	private static void LoadScene(string sceneName) {
		SceneManager.LoadScene(sceneName);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	public static void CbkQue_LoadScene(ST_CbkQue pCbkQue, int pri, string sceneName) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				LoadScene(sceneName);
			}, null);
	}
	//-----------------------------------------------------------------------------
	//オブジェクトプールから次に取得するオブジェクトに設定するレイヤーを設定する。
	private static void SetLayer(int layer) {
		Graph.layer = layer;
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	public static void CbkQue_SetLayer(ST_CbkQue pCbkQue, int pri, int layer) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				SetLayer(layer);
			}, null);
	}
	//-----------------------------------------------------------------------------
	//オブジェクトプールから次に取得するオブジェクトに設定するオーダー順を設定する。
	private static void SetSortingOrder(int sortingOrder) {
		Graph.sortingOrder = sortingOrder;
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	public static void CbkQue_SetSortingOrder(ST_CbkQue pCbkQue, int pri, int sortingOrder) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				SetSortingOrder(sortingOrder);
			}, null);
	}
	//-----------------------------------------------------------------------------
//{{2017/03/30削除:CbkQue_prep_spr()を廃止し、prep_spr()を直接呼び出せるようにしました。
//	//スプライト準備
//	private static void prep_spr(int iSprNo) {
//		//スプライト定義を取得する。
//		ST_SprDef stSprDef = GetSprDef(iSprNo);
//		//ムービーならば…
//		if(stSprDef.isMovie) {
//			//ムービーマテリアルを準備する。
//			MovieHelper_Prepare(Graph.pMovieHelper, stSprDef.iTexNo);
//		//スプライトならば…
//		} else {
//			//スプライトは裏読み未対応です。
//			/** no job **/
//		}
//	}
//	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//	public static void CbkQue_prep_spr(ST_CbkQue pCbkQue, int pri, int iSprNo) {
//		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
//				prep_spr(iSprNo);
//			}, null);
//	}
//}}2017/03/30削除:CbkQue_prep_spr()を廃止し、prep_spr()を直接呼び出せるようにしました。
	//-----------------------------------------------------------------------------
//{{2017/04/10削除:「スプライト描画(フォールバック有り)」を削除し、既存の「スプライト描画(フォールバック無し)」を単純に「スプライト描画」としました。
//	//スプライト描画(フォールバック有り)
//	private static void draw_spr(double x, double y, int[] aSprNo, double scale_x, double scale_y, double rot, double alpha) {
//		//各候補について…
//		for(int i = 0; i < aSprNo.Length; i++) {	//┬この下の処理で、最終候補かを判定する必要が有るので、foreachではなくforを使ってループする。
//			int iSprNo = aSprNo[i];			//┘
//			//スプライト定義を取得する。
//			ST_SprDef stSprDef = GetSprDef(iSprNo);
//			PoolObject po;
//			//ムービーならば…
//			if(stSprDef.isMovie) {
//				//最終候補でなければ…
//				if(i < (aSprNo.Length - 1)) {
//					//ムービーマテリアルを準備する。
//					if(!MovieHelper_Prepare(Graph.pMovieHelper, stSprDef.iTexNo)) { continue; }	//まだ準備が完了していなければ、次の候補へ進む。
//				}
//				//ムービーマテリアルを取得する。
//				CriManaMovieMaterial movieMaterial = ((MoviePlayer)MovieHelper_Draw(Graph.pMovieHelper, stSprDef.iTexNo)).criManaMovieMaterial;
//				if(movieMaterial == null) { throw new ApplicationException(); }	//バグ
//				//Movieオブジェクトを取得する。
//				MovieObject mo = Graph.movieObjectPool.GetObject();
//				//Movieオブジェクトを設定する。
//				mo.meshRenderer.material = movieMaterial.material;
//				//※TODO:alpha未対応
//				mo.goInner.transform.localPosition = new Vector2(
//					(float)(((stSprDef.w / 2) - (stSprDef.cx)) / PPU),
//					(float)(((stSprDef.cy) - (stSprDef.h / 2)) / PPU));
//				mo.goInner.transform.localScale = new Vector2(
//					(float)(stSprDef.w / PPU),
//					(float)(stSprDef.h / PPU));
//				//Poolオブジェクトの共通処理へ進む。
//				po = mo;
//			//スプライトならば…
//			} else {
//				//スプライトを取得する。
//				Sprite sprite = GetSprite(iSprNo);
//				//Spriteオブジェクトを取得する。
//				SpriteObject so = Graph.spriteObjectPool.GetObject();
//				//Spriteオブジェクトを設定する。
//				so.spriteRenderer.sprite = sprite;
//				so.spriteRenderer.color = new Color(1, 1, 1, (float)alpha);
//				so.goInner.transform.localPosition = new Vector2(
//					(sprite.pivot.x - stSprDef.cx) / sprite.pixelsPerUnit,
////{{2017/03/29変更:draw_spr()において、UnityのSpriteのPivotを相殺する処理が、縦軸に関して間違っていたのを修正しました。
////					(stSprDef.cy - sprite.pivot.y) / sprite.pixelsPerUnit);
////↓2017/03/29変更:draw_spr()において、UnityのSpriteのPivotを相殺する処理が、縦軸に関して間違っていたのを修正しました。
//					(stSprDef.cy - (sprite.rect.height - sprite.pivot.y)) / sprite.pixelsPerUnit);
////{{2017/03/29変更:draw_spr()において、UnityのSpriteのPivotを相殺する処理が、縦軸に関して間違っていたのを修正しました。
//				//Poolオブジェクトの共通処理へ進む。
//				po = so;
//			}
////{{2017/03/31追加:テクスチャの自動スケーリングを追加しました。
//			//テクスチャ定義を取得する。
//			// - この処理を、このforループの先頭で行わないように注意して下さい。
//			//   ムービーだった場合、ムービーマテリアルの準備が完了していなければ、そのテクスチャを描画しない可能性が有るからです。
//			//   もし、この処理をこのforループの先頭で行ってしまうと、最終候補ではないムービーでcontinueで次のループへ進んだ場合に、自動スケーリングが設定されていないスプライトに適用してしまうバグが生じる可能性が有ります。
//			//   そうならないよう、自動スケーリングを適用する処理は、描画するテクスチャが決定した後、この場所で行う必要が有ります。
//			ST_TexDef stTexDef = GetTexDef(stSprDef.iTexNo);
//			if(stTexDef.nScale != 1) {	//この判断を行わずに無条件に乗算を行っても同じ結果ではあるが、ほとんどの場合は(stTexDef.nScale==1)だと思うので、この判断を行う方が乗算二回分のコストよりも僅かに効率が良いだろう。
//				scale_x *= stTexDef.nScale;
//				scale_y *= stTexDef.nScale;
//			}
////}}2017/03/31追加:テクスチャの自動スケーリングを追加しました。
//			//Poolオブジェクトを設定する。
//			po.goOuter.transform.localPosition = new Vector2(
//				(float)((x - (DISP_X / 2)) / PPU),
//				(float)(((DISP_Y / 2) - y) / PPU));
//			po.goOuter.transform.localScale = new Vector2(
//				(float)scale_x,
//				(float)scale_y);
//			po.goOuter.transform.localEulerAngles = new Vector3(
//				0,
//				0,
//				(float)rot * -Mathf.Rad2Deg);
//			return;	//ここまで。	忘れないで!!これを忘れると無条件に全ての候補を表示してしまうバグになる。
//		}
//	}
//	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//	public static void CbkQue_draw_spr(ST_CbkQue pCbkQue, int pri, double x, double y, int[] aSprNo, double scale_x = 1, double scale_y = 1, double rot = 0, double alpha = 1) {
//		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
//				draw_spr(x, y, aSprNo, scale_x, scale_y, rot, alpha);
//			}, null);
//	}
//}}2017/04/10削除:「スプライト描画(フォールバック有り)」を削除し、既存の「スプライト描画(フォールバック無し)」を単純に「スプライト描画」としました。
	//-----------------------------------------------------------------------------
//{{2017/04/10変更:「スプライト描画(フォールバック有り)」を削除し、既存の「スプライト描画(フォールバック無し)」を単純に「スプライト描画」としました。
//	//スプライト描画(フォールバック無し)
//	private static void draw_spr(double x, double y, int iSprNo, double scale_x, double scale_y, double rot, double alpha) {
//		draw_spr(x, y, new int[] { iSprNo }, scale_x, scale_y, rot, alpha);
//	}
//	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//	public static void CbkQue_draw_spr(ST_CbkQue pCbkQue, int pri, double x, double y, int iSprNo, double scale_x = 1, double scale_y = 1, double rot = 0, double alpha = 1) {
//		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
//				draw_spr(x, y, iSprNo, scale_x, scale_y, rot, alpha);
//			}, null);
//	}
//↓2017/04/10変更:「スプライト描画(フォールバック有り)」を削除し、既存の「スプライト描画(フォールバック無し)」を単純に「スプライト描画」としました。
	//スプライト描画
//{{2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
//	private static void draw_spr(double x, double y, int iSprNo, double scale_x, double scale_y, double rot, double alpha) {
//↓2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
	private static void draw_spr(double x, double y, int iSprNo, double scale_x, double scale_y, double rot, int rgba) {
//}}2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
		//スプライト定義を取得する。
		ST_SprDef stSprDef = GetSprDef(iSprNo);
		PoolObject po;
		//ムービーならば…
		if(stSprDef.isMovie) {
			//ムービーマテリアルを取得する。
			CriManaMovieMaterial movieMaterial = GetMovieMaterial(stSprDef.iTexNo);
			if(movieMaterial == null) { throw new ApplicationException(); }	//バグ
			//Movieオブジェクトを取得する。
			MovieObject mo = Graph.movieObjectPool.GetObject();
			//Movieオブジェクトを設定する。
			mo.meshRenderer.material = movieMaterial.material;
//{{2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
//			//※TODO:alpha未対応
//↓2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
//			//※TODO:rgba未対応
//↓2017/04/12変更:draw_spr()にて、ムービーのカラーブレンディングも対応しました。
			Mesh mesh = mo.meshFilter.mesh;	//sharedMeshとの使い分けがいまいち良く判らない…この下でmesh.colors32を変更しているが、どの時点からsharedMeshへの変更ではなく複製への変更と見なされるのだろうか?(※要確認)
			Color32 c = RGBA_TOCOLOR(rgba);
			mesh.colors32 = new Color32[] { c,c,c,c };
			mo.meshFilter.mesh = mesh;	//sharedMeshとの使い分けがいまいち良く判らない…この上でmesh.colors32を変更しているが、どの時点からsharedMeshへの変更ではなく複製への変更と見なされるのだろうか?(※要確認)
//}}2017/04/12変更:draw_spr()にて、ムービーのカラーブレンディングも対応しました。
			mo.goInner.transform.localPosition = new Vector2(
				(float)(((stSprDef.w / 2) - (stSprDef.cx)) / PPU),
				(float)(((stSprDef.cy) - (stSprDef.h / 2)) / PPU));
			mo.goInner.transform.localScale = new Vector2(
				(float)(stSprDef.w / PPU),
				(float)(stSprDef.h / PPU));
			//Poolオブジェクトの共通処理へ進む。
			po = mo;
		//スプライトならば…
		} else {
			//スプライトを取得する。
			Sprite sprite = GetSprite(iSprNo);
			//Spriteオブジェクトを取得する。
			SpriteObject so = Graph.spriteObjectPool.GetObject();
			//Spriteオブジェクトを設定する。
			so.spriteRenderer.sprite = sprite;
//{{2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
//			so.spriteRenderer.color = new Color(1, 1, 1, (float)alpha);
//↓2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
			so.spriteRenderer.color = RGBA_TOCOLOR(rgba);
//}}2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
			so.goInner.transform.localPosition = new Vector2(
				(sprite.pivot.x - stSprDef.cx) / sprite.pixelsPerUnit,
				(stSprDef.cy - (sprite.rect.height - sprite.pivot.y)) / sprite.pixelsPerUnit);
			//Poolオブジェクトの共通処理へ進む。
			po = so;
		}
		//テクスチャ定義を取得する。
		// - この処理を、このforループの先頭で行わないように注意して下さい。
		//   ムービーだった場合、ムービーマテリアルの準備が完了していなければ、そのテクスチャを描画しない可能性が有るからです。
		//   もし、この処理をこのforループの先頭で行ってしまうと、最終候補ではないムービーでcontinueで次のループへ進んだ場合に、自動スケーリングが設定されていないスプライトに適用してしまうバグが生じる可能性が有ります。
		//   そうならないよう、自動スケーリングを適用する処理は、描画するテクスチャが決定した後、この場所で行う必要が有ります。
		ST_TexDef stTexDef = GetTexDef(stSprDef.iTexNo);
		if(stTexDef.nScale != 1) {	//この判断を行わずに無条件に乗算を行っても同じ結果ではあるが、ほとんどの場合は(stTexDef.nScale==1)だと思うので、この判断を行う方が乗算二回分のコストよりも僅かに効率が良いだろう。
			scale_x *= stTexDef.nScale;
			scale_y *= stTexDef.nScale;
		}
		//Poolオブジェクトを設定する。
		po.goOuter.transform.localPosition = new Vector2(
			(float)((x - (DISP_X / 2)) / PPU),
			(float)(((DISP_Y / 2) - y) / PPU));
		po.goOuter.transform.localScale = new Vector2(
			(float)scale_x,
			(float)scale_y);
		po.goOuter.transform.localEulerAngles = new Vector3(
			0,
			0,
			(float)rot * -Mathf.Rad2Deg);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//{{2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
//	public static void CbkQue_draw_spr(ST_CbkQue pCbkQue, int pri, double x, double y, int iSprNo, double scale_x = 1, double scale_y = 1, double rot = 0, double alpha = 1) {
//		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
//				draw_spr(x, y, iSprNo, scale_x, scale_y, rot, alpha);
//			}, null);
//	}
//↓2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
	public static void CbkQue_draw_spr(ST_CbkQue pCbkQue, int pri, double x, double y, int iSprNo, double scale_x = 1, double scale_y = 1, double rot = 0, int rgba = -1) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				draw_spr(x, y, iSprNo, scale_x, scale_y, rot, rgba);
			}, null);
	}
//}}2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
//{{2017/04/10変更:「スプライト描画(フォールバック有り)」を削除し、既存の「スプライト描画(フォールバック無し)」を単純に「スプライト描画」としました。
	//-----------------------------------------------------------------------------
	//スプライトフォント描画
//{{2017/04/04変更:スプライトフォント描画に回転機能を追加しました。
//	private static void draw_sprf_fn(object user_data, int x, int y, double scale_x, double scale_y, int rgba, int iSprNo) {
//		double alpha = (double)RGBA_GETALPHA(rgba) / (double)byte.MaxValue;
//		draw_spr(x, y, iSprNo, scale_x, scale_y, 0, alpha);
//	}
//	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//	private static void draw_sprf(VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double ax, double ay, double alpha, string s) {
//		SprFnt_Print(pSprFnt, draw_sprf_fn, null, (int)x, (int)y, scale_x, scale_y, ax, ay, D3DRGBA(1,1,1,alpha), s);
//	}
//	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//	public static void CbkQue_draw_sprf(ST_CbkQue pCbkQue, int pri, VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double ax, double ay, double alpha, string s) {
//		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
//				draw_sprf(pSprFnt, x, y, scale_x, scale_y, ax, ay, alpha, s);
//			}, null);
//	}
//↓2017/04/04変更:スプライトフォント描画に回転機能を追加しました。
//	private static void draw_sprf_fn(object user_data, int x, int y, double scale_x, double scale_y, double rot, int rgba, int iSprNo) {
//		double alpha = (double)RGBA_GETALPHA(rgba) / (double)byte.MaxValue;
//		draw_spr(x, y, iSprNo, scale_x, scale_y, rot, alpha);
//	}
//	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//	private static void draw_sprf(VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, double alpha, string s) {
//		SprFnt_Print(pSprFnt, draw_sprf_fn, null, (int)x, (int)y, scale_x, scale_y, rot, ax, ay, D3DRGBA(1,1,1,alpha), s);
//	}
//	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//	public static void CbkQue_draw_sprf(ST_CbkQue pCbkQue, int pri, VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, double alpha, string s) {
//		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
//				draw_sprf(pSprFnt, x, y, scale_x, scale_y, rot, ax, ay, alpha, s);
//			}, null);
//	}
//↓2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
	private static void draw_sprf_fn(object user_data, int x, int y, double scale_x, double scale_y, double rot, int rgba, int iSprNo) {
		draw_spr(x, y, iSprNo, scale_x, scale_y, rot, rgba);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	private static void draw_sprf(VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, int rgba, string s) {
		SprFnt_Print(pSprFnt, draw_sprf_fn, null, (int)x, (int)y, scale_x, scale_y, rot, ax, ay, rgba, s);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	public static void CbkQue_draw_sprf(ST_CbkQue pCbkQue, int pri, VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, int rgba, string s) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				draw_sprf(pSprFnt, x, y, scale_x, scale_y, rot, ax, ay, rgba, s);
			}, null);
	}
//}}2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
	//-----------------------------------------------------------------------------
	//スプライトフォント描画(書式付き)
//{{2017/04/04変更:スプライトフォント描画に回転機能を追加しました。
//	private static void draw_sprf(VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double ax, double ay, double alpha, string fmt, params object[] ap) {
//		SprFnt_PrintF(pSprFnt, draw_sprf_fn, null, (int)x, (int)y, scale_x, scale_y, ax, ay, D3DRGBA(1,1,1,alpha), fmt, ap);
//	}
//	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//	public static void CbkQue_draw_sprf(ST_CbkQue pCbkQue, int pri, VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double ax, double ay, double alpha, string fmt, params object[] ap) {
//		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
//				draw_sprf(pSprFnt, x, y, scale_x, scale_y, ax, ay, alpha, fmt, ap);
//			}, null);
//	}
//↓2017/04/04変更:スプライトフォント描画に回転機能を追加しました。
//	private static void draw_sprf(VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, double alpha, string fmt, params object[] ap) {
//		SprFnt_PrintF(pSprFnt, draw_sprf_fn, null, (int)x, (int)y, scale_x, scale_y, rot, ax, ay, D3DRGBA(1,1,1,alpha), fmt, ap);
//	}
//	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//	public static void CbkQue_draw_sprf(ST_CbkQue pCbkQue, int pri, VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, double alpha, string fmt, params object[] ap) {
//		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
//				draw_sprf(pSprFnt, x, y, scale_x, scale_y, rot, ax, ay, alpha, fmt, ap);
//			}, null);
//	}
//↓2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
	private static void draw_sprf(VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, int rgba, string fmt, params object[] ap) {
		SprFnt_PrintF(pSprFnt, draw_sprf_fn, null, (int)x, (int)y, scale_x, scale_y, rot, ax, ay, rgba, fmt, ap);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	public static void CbkQue_draw_sprf(ST_CbkQue pCbkQue, int pri, VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, int rgba, string fmt, params object[] ap) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				draw_sprf(pSprFnt, x, y, scale_x, scale_y, rot, ax, ay, rgba, fmt, ap);
			}, null);
	}
//}}2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
	//-----------------------------------------------------------------------------
	//スプライトフォント描画(クロスフェード)
//{{2017/04/04変更:スプライトフォント描画に回転機能を追加しました。
//	private static void draw_sprf_xf(VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double ax, double ay, double alpha, string s1, string s2, double transition/*0.0～1.0*/) {
//		SprFnt_PrintXF(pSprFnt, draw_sprf_fn, null, (int)x, (int)y, scale_x, scale_y, ax, ay, D3DRGBA(1,1,1,alpha), s1, s2, transition);
//	}
//	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//	public static void CbkQue_draw_sprf_xf(ST_CbkQue pCbkQue, int pri, VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double ax, double ay, double alpha, string s1, string s2, double transition/*0.0～1.0*/) {
//		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
//				draw_sprf_xf(pSprFnt, x, y, scale_x, scale_y, ax, ay, alpha, s1, s2, transition);
//			}, null);
//	}
//↓2017/04/04変更:スプライトフォント描画に回転機能を追加しました。
//	private static void draw_sprf_xf(VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, double alpha, string s1, string s2, double transition/*0.0～1.0*/) {
//		SprFnt_PrintXF(pSprFnt, draw_sprf_fn, null, (int)x, (int)y, scale_x, scale_y, rot, ax, ay, D3DRGBA(1,1,1,alpha), s1, s2, transition);
//	}
//	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//	public static void CbkQue_draw_sprf_xf(ST_CbkQue pCbkQue, int pri, VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, double alpha, string s1, string s2, double transition/*0.0～1.0*/) {
//		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
//				draw_sprf_xf(pSprFnt, x, y, scale_x, scale_y, rot, ax, ay, alpha, s1, s2, transition);
//			}, null);
//	}
//↓2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
	private static void draw_sprf_xf(VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, int rgba, string s1, string s2, double transition/*0.0～1.0*/) {
		SprFnt_PrintXF(pSprFnt, draw_sprf_fn, null, (int)x, (int)y, scale_x, scale_y, rot, ax, ay, rgba, s1, s2, transition);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	public static void CbkQue_draw_sprf_xf(ST_CbkQue pCbkQue, int pri, VoidPtr pSprFnt, double x, double y, double scale_x, double scale_y, double rot, double ax, double ay, int rgba, string s1, string s2, double transition/*0.0～1.0*/) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				draw_sprf_xf(pSprFnt, x, y, scale_x, scale_y, rot, ax, ay, rgba, s1, s2, transition);
			}, null);
	}
//}}2017/04/11変更:各描画関数のalpha引数を、rgba引数に変更しました。
	//-----------------------------------------------------------------------------
#if false//{{手法②:一応動作するが、UnityエディタでテクスチャのAdvanced⇒Read/Write EnabledをOnにしておく必要が有り、そうするとテクスチャのメモリ消費量が2倍になってしまうらしいので、実質、この方法は使えない。
	private static Dictionary<int,Texture2D> draw_polyline_partialTextureCache = new Dictionary<int,Texture2D>();	//スプライト番号⇒部分テクスチャ
	private static Texture2D draw_polyline_GetPartialTexture(int iSprNo) {
		Texture2D partialTexture;
		//スプライト番号を検査する。
		if((iSprNo < 1) || (iSprNo > SprNo_Max)) { throw new ApplicationException(); }
		//指定されたスプライトの部分テクスチャがまだ作成されていなければ…
		if(!draw_polyline_partialTextureCache.TryGetValue(iSprNo, out partialTexture)) {
			//スプライト定義を取得する。
			ST_SprDef stSprDef = GetSprDef(iSprNo);
			//テクスチャを取得する。
			Texture2D texture = GetTexture(stSprDef.iTexNo);
			//部分テクスチャを作成する。
			partialTexture = new Texture2D(stSprDef.w, stSprDef.h);
			Color[] pixels = texture.GetPixels(stSprDef.x,	//Unityエディタで、テクスチャのAdvanced⇒Read/Write EnabledをOnにしておかないと、GetPixels()がエラーが発生します。
			                 texture.height - (stSprDef.y + stSprDef.h),	//Unityのテクスチャはボトムアップなので下端原点に補正します。
			                                   stSprDef.w,
			                                   stSprDef.h);
			partialTexture.SetPixels(0, 0, stSprDef.w, stSprDef.h, pixels);
			partialTexture.Apply();	//忘れないで!!
			//部分テクスチャをキャッシュに登録する。
			draw_polyline_partialTextureCache.Add(iSprNo, partialTexture);
		}
		//部分テクスチを返す。
		return partialTexture;
	}
#endif   //}}手法②:一応動作するが、UnityエディタでテクスチャのAdvanced⇒Read/Write EnabledをOnにしておく必要が有り、そうするとテクスチャのメモリ消費量が2倍になってしまうらしいので、実質、この方法は使えない。
#if true //{{手法③:仕方が無いので、特定のテクスチャだけスプライトシートにせず、単独でResourcesフォルダに入れておくという、アプリケーションにべったり依存する方法で対応した。いずれ、手法①で動くようになりますように。。。
	private static Dictionary<int,Texture2D> draw_polyline_singleTextureCache = new Dictionary<int,Texture2D>();	//スプライト番号⇒単独テクスチャ
	private static Texture2D draw_polyline_GetSingleTexture(int iSprNo) {
		Texture2D singleTexture;
		//スプライト番号を検査する。
		if((iSprNo < 1) || (iSprNo > SprNo_Max)) { throw new ApplicationException(); }
		//指定されたスプライトの単独テクスチャがまだ作成されていなければ…
		if(!draw_polyline_singleTextureCache.TryGetValue(iSprNo, out singleTexture)) {
			//単独テクスチャをロードする。
			// - 例えば、「G_FOO_BAR」というスプライトの単独テクスチャを使用する場合は、「Resources/foo_bar.png」に入れておいて下さい。
			string path = EnmDef_GetName(pEnmKey, RegKey_SprNo, iSprNo);
			if(path.StartsWith("G_")) { path = path.Substring(2); }
			path = path.ToLower();
			singleTexture = Resources.Load<Texture2D>(path);
			if(singleTexture == null) { throw new ApplicationException(); }
			//単独テクスチャをキャッシュに登録する。
			draw_polyline_singleTextureCache.Add(iSprNo, singleTexture);
		}
		//単独テクスチを返す。
		return singleTexture;
	}
#endif   //}}手法③:仕方が無いので、特定のテクスチャだけスプライトシートにせず、単独でResourcesフォルダに入れておくという、アプリケーションにべったり依存する方法で対応した。いずれ、手法①で動くようになりますように。。。
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	private static void draw_polyline(double[,] xy, double w, int iSprNo, int rgba) {
		//Lineオブジェクトを取得する。
		LineObject lo = Graph.lineObjectPool.GetObject();
		//Lineオブジェクトを設定する。
		int n = xy.GetLength(0);
//{{2017/04/09変更:Unity 5.6.0ではLineRenderer.numPositionsがobsoleteになり、positionCountに変わった事に対応しました。
//		lo.lineRenderer.numPositions = n;
//↓2017/04/09変更:Unity 5.6.0ではLineRenderer.numPositionsがobsoleteになり、positionCountに変わった事に対応しました。
		lo.lineRenderer.positionCount = n;
//}}2017/04/09変更:Unity 5.6.0ではLineRenderer.numPositionsがobsoleteになり、positionCountに変わった事に対応しました。
		lo.lineRenderer.startWidth = lo.lineRenderer.endWidth = (float)(w / PPU);	//goInner.transform.localScaleはlineRenderer.startWidth,endWidthには影響しないようなので、lineRenderer.startWidth,endWidthにもスケールを掛ける必要が有ります。
		lo.lineRenderer.startColor = lo.lineRenderer.endColor = RGBA_TOCOLOR(rgba);
		Vector3[] positions = new Vector3[n];
		for(int i = 0; i < n; i++) {
			positions[i] = new Vector2(
				(float)xy[i,0/*x*/],
				(float)xy[i,1/*y*/]);
		}
		lo.lineRenderer.SetPositions(positions);
		lo.lineRenderer.loop = false;
		//スプライト番号が指定されていたら…
		if(iSprNo != -1) {
			//スプライト定義を取得する。
			ST_SprDef stSprDef = GetSprDef(iSprNo);
			//ムービーならば…
			if(stSprDef.isMovie) {
				throw new ApplicationException();	//※未対応。多分、対応するのはそんなに難しくないと思う。CRIが返したマテリアルをlo.material.mainTextureに格納すれば良いだけなはずなので。
			//スプライトならば…
			} else {
#if false//{{手法①:理論上は正しいはずだが現時点(Unity Version 5.6.0f3)では上手く動かない。どうもLineRendererはmaterial.mainTextureOffsetやmaterial.mainTextureScaleを無視する(或いはオーバーライドする)ようだ。
				//スプライトを取得する。
				Sprite sprite = GetSprite(iSprNo);
				//Materialを設定する。
				Texture2D texture = sprite.texture;
				lo.material.mainTexture = texture;
				lo.material.mainTextureOffset = new Vector2((float)stSprDef.x                / (float)texture.width,
				                         (float)(texture.height - (stSprDef.y + stSprDef.h)) / (float)texture.height);
				lo.material.mainTextureScale = new Vector2((float)texture.width  / (float)stSprDef.w,
				                                           (float)texture.height / (float)stSprDef.h);
#endif   //}}手法①:理論上は正しいはずだが現時点(Unity Version 5.6.0f3)では上手く動かない。どうもLineRendererはmaterial.mainTextureOffsetやmaterial.mainTextureScaleを無視する(或いはオーバーライドする)ようだ。
#if false//{{手法②:一応動作するが、UnityエディタでテクスチャのAdvanced⇒Read/Write EnabledをOnにしておく必要が有り、そうするとテクスチャのメモリ消費量が2倍になってしまうらしいので、実質、この方法は使えない。
				//部分テクスチャを取得する。
				Texture2D partialTexture = draw_polyline_GetPartialTexture(iSprNo);
				//Materialを設定する。
				lo.material.mainTexture = partialTexture;
#endif   //}}手法②:一応動作するが、UnityエディタでテクスチャのAdvanced⇒Read/Write EnabledをOnにしておく必要が有り、そうするとテクスチャのメモリ消費量が2倍になってしまうらしいので、実質、この方法は使えない。
#if true //{{手法③:仕方が無いので、特定のテクスチャだけスプライトシートにせず、単独でResourcesフォルダに入れておくという、アプリケーションにべったり依存する方法で対応した。いずれ、手法①で動くようになりますように。。。
				//単独テクスチャを取得する。
				Texture2D singleTexture = draw_polyline_GetSingleTexture(iSprNo);
				//Materialを設定する。
//{{2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//				lo.material.mainTexture = singleTexture;
//↓2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
				lo.lineRenderer.material = Graph.materialPool.GetMaterial(singleTexture, Color.white);
//}}2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
#endif   //}}手法③:仕方が無いので、特定のテクスチャだけスプライトシートにせず、単独でResourcesフォルダに入れておくという、アプリケーションにべったり依存する方法で対応した。いずれ、手法①で動くようになりますように。。。
			}
		//スプライト番号が指定されていなければ…
		} else {
			//Materialを設定する。
//{{2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//			lo.material.mainTexture = null;
//↓2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
			lo.lineRenderer.material = Graph.materialPool.GetMaterial(null, Color.white);
//}}2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
		}
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	public static void CbkQue_draw_polyline(ST_CbkQue pCbkQue, int pri, double[,] xy, double w, int iSprNo, int rgba = -1) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				draw_polyline(xy, w, iSprNo, rgba);
			}, null);
	}
	//-----------------------------------------------------------------------------
	private static void draw_box(double x, double y, double w, double h, int rgba) {
		//Lineオブジェクトを取得する。
		LineObject lo = Graph.lineObjectPool.GetObject();
		//Lineオブジェクトを設定する。
		lo.lineRenderer.positionCount = 4;
		lo.lineRenderer.startWidth = lo.lineRenderer.endWidth = (float)(1.0 / PPU);	//goInner.transform.localScaleはlineRenderer.startWidth,endWidthには影響しないようなので、lineRenderer.startWidth,endWidthにもスケールを掛ける必要が有ります。		LineRendererに対する幅0はデフォルト幅という意味ではなく本当に0(=見えない)なので、左記のように0ではなく1を指定する必要が有ります。
		lo.lineRenderer.startColor = lo.lineRenderer.endColor = RGBA_TOCOLOR(rgba);
		Vector3[] positions = new Vector3[4];
		positions[0] = new Vector2((float)(x    ), (float)(y    ));
		positions[1] = new Vector2((float)(x + w), (float)(y    ));
		positions[2] = new Vector2((float)(x + w), (float)(y + h));
		positions[3] = new Vector2((float)(x    ), (float)(y + h));
		lo.lineRenderer.SetPositions(positions);
		lo.lineRenderer.loop = true;
//{{2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//		lo.material.mainTexture = null;
//↓2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
		lo.lineRenderer.material = Graph.materialPool.GetMaterial(null, Color.white);
//}}2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	public static void CbkQue_draw_box(ST_CbkQue pCbkQue, int pri, double x, double y, double w, double h, int rgba = -1) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				draw_box(x, y, w, h, rgba);
			}, null);
	}
	//-----------------------------------------------------------------------------
	private static void draw_box_fill(double x, double y, double w, double h, int rgba) {
		//Boxオブジェクトを取得する。
		BoxObject bo = Graph.boxObjectPool.GetObject();
		//Boxオブジェクトを設定する。
		bo.goOuter.transform.localPosition = new Vector2(
			(float)((x - (DISP_X / 2)) / PPU),
			(float)(((DISP_Y / 2) - y) / PPU));
		bo.goOuter.transform.localScale = new Vector2(
			(float)w,
			(float)h);
#if     USE_COLOR_MATERIAL
//{{2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//		bo.material.color = RGBA_TOCOLOR(rgba);
//↓2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
		bo.meshRenderer.material = Graph.materialPool.GetMaterial(null, RGBA_TOCOLOR(rgba));
//}}2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
#else //USE_COLOR_MATERIAL
		bo.meshRenderer.material = Graph.materialPool.GetMaterial(null, Color.white);
		Mesh mesh = bo.meshFilter.mesh;	//sharedMeshとの使い分けがいまいち良く判らない…この下でmesh.colors32を変更しているが、どの時点からsharedMeshへの変更ではなく複製への変更と見なされるのだろうか?(※要確認)
		Color32 c = RGBA_TOCOLOR(rgba);
		mesh.colors32 = new Color32[] { c,c,c,c };
		bo.meshFilter.mesh = mesh;	//sharedMeshとの使い分けがいまいち良く判らない…この上でmesh.colors32を変更しているが、どの時点からsharedMeshへの変更ではなく複製への変更と見なされるのだろうか?(※要確認)
#endif//USE_COLOR_MATERIAL
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	public static void CbkQue_draw_box_fill(ST_CbkQue pCbkQue, int pri, double x, double y, double w, double h, int rgba = -1) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				draw_box_fill(x, y, w, h, rgba);
			}, null);
	}
	//-----------------------------------------------------------------------------
	private static void draw_polygon(double[,] xy, int rgba = -1) {
		//Lineオブジェクトを取得する。
		LineObject lo = Graph.lineObjectPool.GetObject();
		//Lineオブジェクトを設定する。
		int n = xy.GetLength(0);
		lo.lineRenderer.positionCount = n;
		lo.lineRenderer.startWidth = lo.lineRenderer.endWidth = (float)(1.0 / PPU);	//goInner.transform.localScaleはlineRenderer.startWidth,endWidthには影響しないようなので、lineRenderer.startWidth,endWidthにもスケールを掛ける必要が有ります。		LineRendererに対する幅0はデフォルト幅という意味ではなく本当に0(=見えない)なので、左記のように0ではなく1を指定する必要が有ります。
		lo.lineRenderer.startColor = lo.lineRenderer.endColor = RGBA_TOCOLOR(rgba);
		Vector3[] positions = new Vector3[n];
		for(int i = 0; i < n; i++) {
			positions[i] = new Vector2(
				(float)xy[i,0/*x*/],
				(float)xy[i,1/*y*/]);
		}
		lo.lineRenderer.SetPositions(positions);
		lo.lineRenderer.loop = true;
//{{2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//		lo.material.mainTexture = null;
//↓2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
		lo.lineRenderer.material = Graph.materialPool.GetMaterial(null, Color.white);
//}}2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	public static void CbkQue_draw_polygon(ST_CbkQue pCbkQue, int pri, double[,] xy, int rgba = -1) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				draw_polygon(xy, rgba);
			}, null);
	}
	//-----------------------------------------------------------------------------
	private static void draw_polygon_fill(double[,] xy, int rgba = -1) {
		//Polygonオブジェクトを取得する。
		PolygonObject po = Graph.polygonObjectPool.GetObject();
		//Polygonオブジェクトを設定する。
		{
			Mesh mesh = po.meshFilter.mesh;
			int n = xy.GetLength(0);
			if(n < 3) { throw new ApplicationException(); }	//少なくとも三角形以上でなくてはなりません。
			{
				Vector3[] vertices = new Vector3[n];
				for(int i = 0; i < n; i++) { vertices[i] = new Vector2((float)xy[i,0/*x*/], (float)xy[i,1/*y*/]); }
				mesh.vertices = vertices;
			}
			{
				int[] triangles = new int[(n - 2) * 3];
				for(int i = 0; i < n - 2; i++) {	//┐
					triangles[(i * 3) + 0] = 0;	//│
					triangles[(i * 3) + 1] = i + 1;	//├実装を簡単にするためにトライアングルファンの形に分割する事にしました。本当はトライアングルストリップの形に分割する方が良いとは思うのですが、実際の所当関数で描画するのはせいぜい3～4角形程度だと思うのでどちらでもさほど違いは無いと思います。
					triangles[(i * 3) + 2] = i + 2;	//│
				}					//┘
				mesh.triangles = triangles;
			}
#if     !USE_COLOR_MATERIAL
			{
				Color32 c = RGBA_TOCOLOR(rgba);
				Color32[] colors32 = new Color32[n];
				for(int i = 0; i < n; i++) { colors32[i] = c; }
				mesh.colors32 = colors32;
			}
#endif//!USE_COLOR_MATERIAL
			po.meshFilter.mesh = mesh;
		}
#if     USE_COLOR_MATERIAL
//{{2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
//		po.material.color = RGBA_TOCOLOR(rgba);	//Mesh.colors32はnullのままでマテリアルで色を設定する方が簡単です。(MovieObjectの場合は複数のオブジェクトでマテリアルを共有しているのでMesh.colors32を使わざるを得ませんが…)
//↓2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
		po.meshRenderer.material = Graph.materialPool.GetMaterial(null, RGBA_TOCOLOR(rgba));	//Mesh.colors32はnullのままでマテリアルで色を設定する方が簡単です。(MovieObjectの場合は複数のオブジェクトでマテリアルを共有しているのでMesh.colors32を使わざるを得ませんが…)
//}}2017/05/09変更:マテリアルプールを設けて、個々のオブジェクト毎にマテリアルを作成するのをやめて、同じマテリアルは共通化するように変更しました。
#else //USE_COLOR_MATERIAL
		po.meshRenderer.material = Graph.materialPool.GetMaterial(null, Color.white);
#endif//USE_COLOR_MATERIAL
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	public static void CbkQue_draw_polygon_fill(ST_CbkQue pCbkQue, int pri, double[,] xy, int rgba = -1) {
		CbkQue_Add(pCbkQue, pri, delegate(ST_CbkQue _pCbkQue, int _pri, object param) {
				draw_polygon_fill(xy, rgba);
			}, null);
	}
	//-----------------------------------------------------------------------------
	//※TODO:ここに追加して下さい。
}
#endif//UNITY_5_3_OR_NEWER
