/*
 *	jtbinexpr.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTBINEXPR
 *****************************************************************************/

typedef struct _JTBINEXPR {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	//
	int op;				/* Zq */
	JTCODE_INTERFACE** code1;	/* Ӓl */
	JTCODE_INTERFACE** code2;	/* EӒl */
} JTBINEXPR;

IMPLEMENT_JTCODE_INTERFACE(JTBINEXPR, jtbinexpr)

const INTERFACE_MAP jtbinexpr_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTBINEXPR, jtcode_interface), &jtcode_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtbinexpr_create(int op, JTCODE_INTERFACE** code1, JTCODE_INTERFACE** code2)
{
	JTBINEXPR* this = calloc(1, sizeof(JTBINEXPR));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtbinexpr_interface_map);

	/* ZqAӒlAEӒli[܂B */
	this->op = op;
	safe_assign(this->code1, code1);
	safe_assign(this->code2, code2);

	return &this->jtcode_interface;
}

static void
jtbinexpr_delete(JTBINEXPR* this)
{
	/* ӒlAEӒl܂B */
	safe_release(this->code1);
	safe_release(this->code2);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTBINEXPR* this = CONTAINING_RECORD(intf, JTBINEXPR, jtcode_interface);
	//
	JTCODE_INTERFACE** code1 = NULL;
	JTCODE_INTERFACE** code2 = NULL;
	ARITHMETIC_INTERFACE** arithmetic = NULL;
	LOGICAL_INTERFACE** logical = NULL;
	COMPARE_INTERFACE** compare = NULL;
	JTSYMBOL_INTERFACE** symbol = NULL;
	//
	int retval;

	switch(this->op) {
	case '+':
	case '-':
	case '*':
	case '/':
		/* ӒlAEӒl܂B */
		safe_attach(code1, (*this->code1)->run(this->code1));
		safe_attach(code2, (*this->code2)->run(this->code2));

		/* Ӓl̎ZpZC^[tFCX擾܂B */
		safe_assign_interface(arithmetic, code1, ARITHMETIC_INTERFACE);
		if(!arithmetic) {
			DIE(); /* ZpZs */
		}

		/* Zqɂ... */
		switch(this->op) {
		case '+':
			safe_attach(code1, (*arithmetic)->add(arithmetic, code2));
			break;
		case '-':
			safe_attach(code1, (*arithmetic)->sub(arithmetic, code2));
			break;
		case '*':
			safe_attach(code1, (*arithmetic)->mul(arithmetic, code2));
			break;
		case '/':
			safe_attach(code1, (*arithmetic)->div(arithmetic, code2));
			break;
		default:
			DIE(); /* sȉZq */
		}

		goto L_EXIT;

	case TOKEN_TYPE_OR:
	case TOKEN_TYPE_AND:
		/* ӒlAEӒl܂B */
		safe_attach(code1, (*this->code1)->run(this->code1));
		safe_attach(code2, (*this->code2)->run(this->code2));

		/* Ӓl̘_ZC^[tFCX擾܂B */
		safe_assign_interface(logical, code1, LOGICAL_INTERFACE);
		if(!logical) {
			DIE(); /* ZpZs */
		}

		/* Zqɂ... */
		switch(this->op) {
		case TOKEN_TYPE_OR:
			safe_attach(code1, (*logical)->or(logical, code2));
			break;
		case TOKEN_TYPE_AND:
			safe_attach(code1, (*logical)->and(logical, code2));
			break;
		default:
			DIE(); /* sȉZq */
		}

		goto L_EXIT;

	case TOKEN_TYPE_EQ:
	case TOKEN_TYPE_NE:
	case TOKEN_TYPE_LE:
	case TOKEN_TYPE_GE:
	case '<':
	case '>':
		/* ӒlAEӒl܂B */
		safe_attach(code1, (*this->code1)->run(this->code1));
		safe_attach(code2, (*this->code2)->run(this->code2));

		/* Ӓl̔rZC^[tFCX擾܂B */
		safe_assign_interface(compare, code1, COMPARE_INTERFACE);
		if(!compare) {
			DIE(); /* rZs */
		}

		/* ӒlƉEӒl̔rʂ擾܂B */
		retval = (*compare)->compare(compare, code2);

		/* Zqɂ... */
		switch(this->op) {
		case TOKEN_TYPE_EQ:
			safe_attach(code1, jtbool_create(retval == 0));
			break;
		case TOKEN_TYPE_NE:
			safe_attach(code1, jtbool_create(retval != 0));
			break;
		case TOKEN_TYPE_LE:
			safe_attach(code1, jtbool_create(retval <= 0));
			break;
		case TOKEN_TYPE_GE:
			safe_attach(code1, jtbool_create(retval >= 0));
			break;
		case '<':
			safe_attach(code1, jtbool_create(retval < 0));
			break;
		case '>':
			safe_attach(code1, jtbool_create(retval > 0));
			break;
		default:
			DIE(); /* sȉZq */
		}

		goto L_EXIT;

	case '=':
		/* EӒl܂B */
		safe_attach(code1, (*this->code2)->run(this->code2));

		/* Ӓl̃V{C^[tFCX擾܂B */
		safe_assign_interface(symbol, this->code1, JTSYMBOL_INTERFACE);
		if(!symbol) {
			DIE(); /* ӒlV{łȂ */
		}

		/* [JϐA܂́AtB[hϐA܂́AO[oϐ̒lݒ肵܂B */
		joytoy_set_symbol_value(symbol, code1);

		/* lcode1Â܂܁A߂lɂȂ܂B */

		goto L_EXIT;

	default:
		DIE(); /* sȉZq */
	}
L_EXIT:

	/* svɂȂC^[tFCX܂B */
	safe_release(code2);
	safe_release(arithmetic);
	safe_release(logical);
	safe_release(compare);
	safe_release(symbol);

	return code1;
}

