/*
 *	gnode.c
 *
 *	N-ary Trees - trees of data with any number of branches
 *
 *	* Sat Feb 06 21:09:21 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- GLibN-ary Trees(http://developer.gnome.org/glib/stable/glib-N-ary-Trees.html)قƂǂ̂܂܎g킹Ē܂B
 *	  ׋̂߂ɁA\[Xǂ݂ȂRgt肵܂A͂قƂǕςĂ܂B
 *	  AsvƎv폜ȗ̂ŁAsȓ삪oꍇ͂̕ύX_^ĉB
 *	* Sat Aug 27 21:24:43 JST 2016 Naoyuki Sawa
 *	- g_node_traverse(`G_PRE_ORDER`)ĂяoꂽR[obN֐AR[obN֐ɓnꂽnodeg폜o悤ɂ܂B
 *	  ڍׂ́Agnode.h́AGNODE_SAFE_SELF_DESTRUCTION_DURING_PRE_ORDER_TRAVERSINGV{`ӏ̃RgQƂĉB
 *	- ActObj_ApplyTransToTree()AL̕ύXɈˑ悤ɂȂ܂B
 *	  ڍׂ́Aclipact.h̓̃RgQƂĉB
 */
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
//Creates a new GNode containing the given data.
//Used to create the first node in a tree.
//Parameters
//		data		The data of the new node.
//Returns
//		A new GNode.
GNode* g_node_new(void* data) {
	//Vm[h̃mۂB
	GNode* node = calloc(1, sizeof(GNode));
	if(!node) { DIE(); }
	//Vm[hɃf[^i[B
	node->data = data;
	//Vm[hԂB
	return node;
}
/*--------------------------------------------------------------------------*/
//Recursively copies a GNode.
//But does not deep-copy the data inside the nodes, see g_node_copy_deep() if you need that.
//Parameters
//		node		A GNode.
//Returns
//		A new GNode containing the same data pointers.
GNode* g_node_copy(GNode* node) {
	return g_node_copy_deep(node, NULL/*copy_func*/, NULL/*data*/);
}
/*--------------------------------------------------------------------------*/
//Recursively copies a GNode and its data.
//Parameters
//		node		A GNode.
//		copy_func	The function which is called to copy the data inside each node, or NULL to use the original data.
//		data		Data to pass to copy_func.
//Returns
//		A new GNode containing copies of the data in node.
GNode* g_node_copy_deep(GNode* node, void* (*copy_func)(const void* src, void* data), void* data) {
	void* new_data;
	GNode *new_node, *child, *new_child;
	//w肳ꂽm[h̃f[^擾B
	new_data = node->data;
	//Rs[֐w肳ĂAf[^𕡐B
	if(copy_func) { new_data = (*copy_func)(new_data, data); }
	//Vm[h쐬B
	new_node = g_node_new(new_data);
	//w肳ꂽm[h̑SĂ̎qm[hɂāc
	for(child = g_node_first_child(node);
	    child;
	    child = g_node_next_sibling(child)) {
		//qm[hƃf[^𕡐āAVqm[h쐬B
		new_child = g_node_copy_deep(child, copy_func, data);
		//Vm[hɁAVqm[hǉB
		g_node_append(new_node, new_child);
	}
	//Vm[hԂB
	return new_node;
}
/*--------------------------------------------------------------------------*/
//Inserts a GNode beneath the parent at the given position.
//Parameters
//		parent		The GNode to place node under.
//		position	The position to place node at, with respect to its siblings.
//				If position is -1, the node is inserted as the last child of parent.
//		node		The GNode to insert.
//Returns
//		The inserted GNode.
GNode* g_node_insert(GNode* parent, int position, GNode* node) {
	//w肳ꂽem[h́ApositionԖڂ̎qm[h̑OɁAw肳ꂽm[hǉB
	return g_node_insert_before(parent, g_node_nth_child(parent, position), node);
	//                                  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ ((unsigned)position>=(unsigned)g_node_n_children(node)) ꍇ́A߂lNULLƂȂB
	//                                                                    g_node_insert_before(parent,NULL,node) ƂȂāAnodeparent̍Ō̎qm[hƂĒǉB
}
/*--------------------------------------------------------------------------*/
//Inserts a GNode beneath the parent before the given sibling.
//Parameters
//		parent		The GNode to place node under.
//		sibling		The sibling GNode to place node before.
//				If sibling is NULL, the node is inserted as the last child of parent.
//		node		The GNode to insert.
//Returns
//		The inserted GNode.
GNode* g_node_insert_before(GNode* parent, GNode* sibling, GNode* node) {
	//w肳ꂽm[hɁAw肳ꂽem[hi[B
	node->parent = parent;
	//ǉʒũm[hw肳Ăc
	if(sibling) {
		//ǉʒũm[hAŏ̎qm[hłȂ΁c
		if(sibling->prev) {			//<------------sibling
			node->prev = sibling->prev;	//<-----node
			node->prev->next = node;	//<---->node
		//ǉʒũm[hAŏ̎qm[hȂ΁c
		} else {				//parent========>sibling
			parent->children = node;	//parent=>node
		}
		node->next = sibling;			//<---->node-->sibling
		sibling->prev = node;			//<---->node<->sibling
	//ǉʒuw肳ĂȂ΁c
	} else {
		//w肳ꂽem[h́Aqm[hL΁c
		if(parent->children) {
			//w肳ꂽem[h́AŌ̎qm[h擾B
			sibling = g_node_last_child(parent);
			//Ō̎qm[h̎ɁAw肳ꂽm[hǉB
			node->prev = sibling;		//sibling<--node
			sibling->next = node;		//sibling<->node
		//w肳ꂽem[h́Aqm[h΁c
		} else {
			//w肳ꂽem[h́Aŏ̎qm[hƂāAw肳ꂽm[hǉB
			parent->children = node;	//parent===>node
		}
	}
	//w肳ꂽm[hÂ܂ܕԂB
	return node;
}
/*--------------------------------------------------------------------------*/
//Inserts a GNode beneath the parent after the given sibling.
//Parameters
//		parent		The GNode to place node under.
//		sibling		The sibling GNode to place node after.
//				If sibling is NULL, the node is inserted as the first child of parent.
//		node		The GNode to insert.
//Returns
//		The inserted GNode.
GNode* g_node_insert_after(GNode* parent, GNode* sibling, GNode* node) {
	//w肳ꂽm[hɁAw肳ꂽem[hi[B
	node->parent = parent;
	//ǉʒũm[hw肳Ăc
	if(sibling) {
		//ǉʒũm[hAŌ̎qm[hłȂ΁c
		if(sibling->next) {			//sibling--------->
			sibling->next->prev = node;	//          node<--
		}
		node->next = sibling->next;		//          node<->
		node->prev = sibling;			//sibling<--node<->
		sibling->next = node;			//sibling<->node<->
	//ǉʒuw肳ĂȂ΁c
	} else {
		//w肳ꂽem[h́Aqm[hL΁c
		if(parent->children) {			//parent==========>
			node->next = parent->children;	//          node-->
			parent->children->prev = node;	//          node<->
		}
		parent->children = node;		//parent===>node<->
	}
	//w肳ꂽm[hÂ܂ܕԂB
	return node;
}
/*--------------------------------------------------------------------------*/
//Inserts a GNode as the last child of the given parent.
//Parameters
//		parent		The GNode to place the new GNode under.
//		node		The GNode to insert.
//Returns
//		The inserted GNode.
GNode* g_node_append(GNode* parent, GNode* node) {
	return g_node_insert_before(parent, NULL/*sibling*/, node);
}
/*--------------------------------------------------------------------------*/
//Inserts a GNode as the first child of the given parent.
//Parameters
//		parent		The GNode to place the new GNode under.
//		node		The GNode to insert.
//Returns
//		The inserted GNode.
GNode* g_node_prepend(GNode* parent, GNode* node) {
	return g_node_insert_before(parent, parent->children, node);
}
/*--------------------------------------------------------------------------*/
//Inserts a new GNode at the given position.
//Parameters
//		parent		The GNode to place the new GNode under.
//		position	The position to place the new GNode at.
//				If position is -1, the new GNode is inserted as the last child of parent.
//		data		The data for the new GNode.
//Returns
//		The new GNode.
GNode* g_node_insert_data(GNode* parent, int position, void* data) {
	return g_node_insert(parent, position, g_node_new(data));
}
/*--------------------------------------------------------------------------*/
//Inserts a new GNode after the given sibling.
//Parameters
//		parent		The GNode to place the new GNode under.
//		sibling		The sibling GNode to place the new GNode after.
//		data		The data for the new GNode.
//Returns
//		The new GNode.
GNode* g_node_insert_data_after(GNode* parent, GNode* sibling, void* data) {
	return g_node_insert_after(parent, sibling, g_node_new(data));
}
/*--------------------------------------------------------------------------*/
//Inserts a new GNode before the given sibling.
//Parameters
//		parent		The GNode to place the new GNode under.
//		sibling		The sibling GNode to place the new GNode before.
//		data		The data for the new GNode.
//Returns
//		The new GNode.
GNode* g_node_insert_data_before(GNode* parent, GNode* sibling, void* data) {
	return g_node_insert_before(parent, sibling, g_node_new(data));
}
/*--------------------------------------------------------------------------*/
//Inserts a new GNode as the last child of the given parent.
//Parameters
//		parent		The GNode to place the new GNode under.
//		data		The data for the new GNode.
//Returns
//		The new GNode.
GNode* g_node_append_data(GNode* parent, void* data) {
	return g_node_insert_before(parent, NULL/*sibling*/, g_node_new(data));
}
/*--------------------------------------------------------------------------*/
//Inserts a new GNode as the first child of the given parent.
//Parameters
//		parent		The GNode to place the new GNode under.
//		data		The data for the new GNode.
//Returns
//		The new GNode.
GNode* g_node_prepend_data(GNode* parent, void* data) {
	return g_node_prepend(parent, g_node_new(data));
}
/*--------------------------------------------------------------------------*/
//Reverses the order of the children of a GNode.
//It doesn't change the order of the grandchildren.
//Parameters
//		node		A GNode.
void g_node_reverse_children(GNode* node) {
	GNode* child = node->children;
	while(child) {
		node->children = child;
		                 child = node->children->next;
		                         node->children->next = node->children->prev;
		                                                node->children->prev = child;
	}
}
/*--------------------------------------------------------------------------*/
static int g_node_traverse_pre_or_post_order(GNode* node, int order, int flags, int depth, int (*func)(GNode* node, void* data), void* data) {
	//w肳ꂽm[h́Aqm[hL΁c
	if(node->children) {
		//Pre orderȂ΁c
		if(order == G_PRE_ORDER) {
//{{2016/08/27ǉ:g_node_traverse(`G_PRE_ORDER`)ĂяoꂽR[obN֐AR[obN֐ɓnꂽnodeg폜o悤ɂ܂B
#ifndef GNODE_SAFE_SELF_DESTRUCTION_DURING_PRE_ORDER_TRAVERSING
//}}2016/08/27ǉ:g_node_traverse(`G_PRE_ORDER`)ĂяoꂽR[obN֐AR[obN֐ɓnꂽnodeg폜o悤ɂ܂B
			//G_TRAVERSE_NON_LEAVEStOw肳ĂAR[obN֐ĂяoB
			if((flags & G_TRAVERSE_NON_LEAVES) && (*func)(node, data)) { return 1/*TRUE*/; }				//yPre orderz̃R[obN֐AR[obN֐ɓnꂽm[h폜ƁAȉ̏ɓ삵܂Bȉ̏̒ŁA폜ꂽnodeɃANZXĂ܂łBAR[obN֐ɓnꂽm[h'qm[h'͍폜ĂSłBȉ̏̒ŁAnode->childrenĎ擾Ă邩łB
//{{2016/08/27ǉ:g_node_traverse(`G_PRE_ORDER`)ĂяoꂽR[obN֐AR[obN֐ɓnꂽnodeg폜o悤ɂ܂B
#else //GNODE_SAFE_SELF_DESTRUCTION_DURING_PRE_ORDER_TRAVERSING
			//G_TRAVERSE_NON_LEAVEStOw肳ĂAR[obN֐ĂяoB
			if(flags & G_TRAVERSE_NON_LEAVES) {
				int retval;
			    #ifdef  _DEBUG
				int save_prevent_memory_free;
			    #endif//_DEBUG
				if(node->_prevent_memory_free >= USHRT_MAX) { DIE(); }			//g_tree_traverse()̃lXg[߂B
				if(node->_request_memory_free) { DIE(); }				//ɃJvtOZbgĂ鎖͖͂B
				node->_prevent_memory_free++;						//J}JE^𑝂₷B
			    #ifdef  _DEBUG
				save_prevent_memory_free = node->_prevent_memory_free;			//fobÔ߂ɁAR[obN֐ĂяoÓAJ}JE^̌̒lLĂB
			    #endif//_DEBUG
				retval = (*func)(node, data);						//R[obN֐ĂяoB
			    #ifdef  _DEBUG
				if(node->_prevent_memory_free != save_prevent_memory_free) { DIE(); }	//R[obN֐̌ĂяoɂāAJ}JE^ω鎖͖͂B(g_tree_traverse()lXgĂĂA}Ōɖ߂Ă͂B)
			    #endif//_DEBUG
				node->_prevent_memory_free--;						//J}JE^炷B
				if(node->_request_memory_free) {					//JvtOZbgĂc(=nodẽ͖Jł邪A_prevent_memory_free_request_memory_freeȊÕtB[h͂łB)
					if(!node->_prevent_memory_free) {				//J}JE^0Ȃ΁c(=g_tree_traverse()lXgĂꍇ́AԊOg_tree_traverse()Ȃ΁c)
						free(node);						//BJȊȌ(em[h̎Oqm[h̃Xg폜)́Ag_node_destroy(),y,g_nodes_free()ōsĂ̂ŁAł͒PɃ邾ŗǂB
					}
					return retval;							//̃m[h(=폜ς)̎qm[hXg(=폜ς)̃go[XLZāAR[obN֐̖߂lԂBLẐ͂̃m[h(=폜ς)̎qm[hXg(=폜ς)̃go[XłAgo[XŜp邩ǂ̓R[obN֐̖߂lɂ鎖ɒӂB
				}
				if(retval) { return 1/*TRUE*/; }					//R[obN֐0ȊOԂAgo[X𒆎~B
			}
#endif//GNODE_SAFE_SELF_DESTRUCTION_DURING_PRE_ORDER_TRAVERSING
//}}2016/08/27ǉ:g_node_traverse(`G_PRE_ORDER`)ĂяoꂽR[obN֐AR[obN֐ɓnꂽnodeg폜o悤ɂ܂B
		}
		//ڕWxɓBĂȂ΁c
		if(--depth) {
			//w肳ꂽm[h́Aŏ̎qm[h,,NULL擾B
			GNode* child = node->children;											//yPre orderz̃R[obN֐AR[obN֐ɓnꂽm[h'qm[h'폜\L̂ŁAnode->childrenĎ擾KvL܂B
			//qm[h̃Xg̖ɓB܂Łc
			while(child) {
				//݂̎qm[hLĂB
				GNode* current = child;
				//R[obN֐ĂяoOɁA̎qm[h擾ĂB
				child = child->next;
				//݂̎qm[hɂāAċAB
				if(g_node_traverse_pre_or_post_order(current, order, flags, depth, func, data)) { return 1/*TRUE*/; }	//yPre orderzyPost orderz̍ċA̒ŌĂяoꂽR[obN֐AR[obN֐ɓnꂽm[h폜ĂSłB
			}
		}
		//Post orderȂ΁c
		if(order == G_POST_ORDER) {
			//G_TRAVERSE_NON_LEAVEStOw肳ĂAR[obN֐ĂяoB
			if((flags & G_TRAVERSE_NON_LEAVES) && (*func)(node, data)) { return 1/*TRUE*/; }				//yPost orderz̃R[obN֐AR[obN֐ɓnꂽm[h폜ĂSłB
		}
	//w肳ꂽm[h́Aqm[h΁c
	} else {
		//G_TRAVERSE_LEAVEStOw肳ĂAR[obN֐ĂяoB
		if((flags & G_TRAVERSE_LEAVES) && (*func)(node, data)) { return 1/*TRUE*/; }						//yPre orderzyPost orderz̃R[obN֐AR[obN֐ɓnꂽm[h폜ĂSłB
	}
	return 0/*FALSE*/;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int g_node_traverse_level(GNode* node, int flags, int level, int (*func)(GNode* node, void* data), void* data) {
	//ڕWxɓBĂȂ΁c
	if(--level) {
		//w肳ꂽm[h́Aŏ̎qm[h,,NULL擾B
		node = node->children;
		//qm[h̃Xg̖ɓB܂Łc
		while(node) {
			//݂̎qm[hLĂB
			GNode* current = node;
			//R[obN֐ĂяoOɁA̎qm[h擾ĂB
			node = node->next;
			//݂̎qm[hɂāAċAB
			if(g_node_traverse_level(current, flags, level, func, data)) { return 1/*TRUE*/; }				//yLevel orderz̍ċA̒ŌĂяoꂽR[obN֐AR[obN֐ɓnꂽm[h폜ĂSłB
		}
	//ڕWxɓBc
	} else {
		//w肳ꂽm[h́Aqm[hL΁c
		if(node->children) {
			//G_TRAVERSE_NON_LEAVEStOw肳ĂAR[obN֐ĂяoB
			if((flags & G_TRAVERSE_NON_LEAVES) && (*func)(node, data)) { return 1/*TRUE*/; }				//yLevel orderz̃R[obN֐AR[obN֐ɓnꂽm[h폜ĂSłB
		//w肳ꂽm[h́Aqm[h΁c
		} else {
			//G_TRAVERSE_LEAVEStOw肳ĂAR[obN֐ĂяoB
			if((flags & G_TRAVERSE_LEAVES) && (*func)(node, data)) { return 1/*TRUE*/; }					//yLevel orderz̃R[obN֐AR[obN֐ɓnꂽm[h폜ĂSłB
		}
	}
	return 0/*FALSE*/;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Traverses a tree starting at the given root GNode.
//It calls the given function for each node visited.
//The traversal can be halted at any point by returning TRUE from func.
//Parameters
//		root		The root GNode of the tree to traverse.
//		order		The order in which nodes are visited - G_IN_ORDER, G_PRE_ORDER, G_POST_ORDER, or G_LEVEL_ORDER.
//		flags		Which types of children are to be visited, one of G_TRAVERSE_ALL, G_TRAVERSE_LEAVES and G_TRAVERSE_NON_LEAVES.
//		depth		The maximum depth of the traversal.
//				Nodes below this depth will not be visited.
//				If depth is -1 all nodes in the tree are visited.
//				If depth is 1, only the root is visited.
//				If depth is 2, the root and its children are visited.
//				And so on.
//		func		The function to call for each visited GNode.
//		data		User data to pass to the function.
//[note]
//	- yPre orderz̏ꍇ
//	  ~R[obN֐A'R[obN֐ɓnꂽm[h'폜Ă͂܂B		vӁ			//{{2016/08/27RgǋL:g_node_traverse(`G_PRE_ORDER`)ĂяoꂽR[obN֐AR[obN֐ɓnꂽnodeg폜o悤ɂ܂B}}
//	  R[obN֐A'R[obN֐ɓnꂽm[h̎qm[h'폜ĂSłB
//	  ~R[obN֐ALȊÕc[\ωꍇ͖̓`łB
//	- yPost orderźyLevel orderz̏ꍇ
//	  R[obN֐A'R[obN֐ɓnꂽm[h'폜ĂSłB
//	  R[obN֐A'R[obN֐ɓnꂽm[h̎qm[h'폜ĂSłB
//	  ~R[obN֐ALȊÕc[\ωꍇ͖̓`łB
void g_node_traverse(GNode* root, int order, int flags, int depth, int (*func)(GNode* node, void* data), void* data) {
	switch(order) {
	default:DIE();
//ȗ	case G_IN_ORDER:
//ȗ		g_node_depth_traverse_in_order(root, flags, depth, func, data);
//ȗ		break;
	case G_PRE_ORDER:
	case G_POST_ORDER:
		{
			//ő[x0ȊOȂ΁c
			if(depth) {
				//go[X֐ĂяoB
				g_node_traverse_pre_or_post_order(root, order, flags, depth, func, data);
			}
		}
		break;
	case G_LEVEL_ORDER:
		{
			//c[̍ő[x߂܂B
			int level, height = g_node_max_height(root);
			//w肳ꂽő[x(,,-1=)Ac[̍ő[xɐ؂l߂܂B
			if((unsigned)depth > (unsigned)height) { depth = height; }
			//ő[x0ȊOȂ΁Aő[x܂ł̊exɂāc
			for(level = 1; level <= depth; level++) {
				//go[X֐ĂяoB
				if(g_node_traverse_level(root, flags, level, func, data)) { break; }
			}
		}
		break;
	}
}
/*--------------------------------------------------------------------------*/
//Calls a function for each of the children of a GNode.
//Note that it doesn't descend beneath the child nodes.
//Parameters
//		node		A GNode.
//		flags		Which types of children are to be visited, one of G_TRAVERSE_ALL, G_TRAVERSE_LEAVES and G_TRAVERSE_NON_LEAVES.
//		func		The function to call for each visited node.
//		data		User data to pass to the function.
//[note]
//	- R[obN֐A'R[obN֐ɓnꂽm[h'폜ĂSłB
//	  R[obN֐A'R[obN֐ɓnꂽm[h̎qm[h'폜ĂSłB
//	  ~R[obN֐ALȊÕc[\ωꍇ͖̓`łB
void g_node_children_foreach(GNode* node, int flags, void (*func)(GNode* node, void* data), void* data) {
	//w肳ꂽm[h́Aŏ̎qm[h,,NULL擾B
	node = node->children;
	//qm[h̃Xg̖ɓB܂Łc
	while(node) {
		//݂̎qm[hLĂB
		GNode* current = node;
		//R[obN֐ĂяoOɁA̎qm[h擾ĂB
		// - Ɏ̎qm[h֐i߂ĂŔAR[obN֐݂̎qm[h폜ĂAɓo悤ɂ邽߂łB
		//   AR[obN֐̎qm[h폜ꍇ́Aɓo܂B
		//   ݂̎qm[h폜P[X͑A̎qm[h폜P[X͏ȂƑz肵āAO҂̂ݑ΍􂵂Ă܂B
		node = node->next;
		//݂̎qm[h[tȂ΁c
		if(G_NODE_IS_LEAF(current)) {
			//G_TRAVERSE_LEAVEStOw肳ĂAR[obN֐ĂяoB
			if(flags & G_TRAVERSE_LEAVES) { (*func)(current, data); }
		//݂̎qm[h[tłȂ΁c
		} else {
			//G_TRAVERSE_NON_LEAVEStOw肳ĂAR[obN֐ĂяoB
			if(flags & G_TRAVERSE_NON_LEAVES) { (*func)(current, data); }
		}
	}
}
/*--------------------------------------------------------------------------*/
//Gets the root of a tree.
//Parameters
//		node		A GNode.
//Returns
//		The root of the tree.
GNode* g_node_get_root(GNode* node) {
	while(node->parent) {
		node = node->parent;
	}
	return node;
}
/*--------------------------------------------------------------------------*/
static int g_node_find_func(GNode* node, void* data) {
	void** d = data;
	if(d[0] == node->data) {
		d[1] = node;
		return 1/*TRUE*/;
	} else {
		return 0/*FALSE*/;
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Finds a GNode in a tree.
//Parameters
//		root		The root GNode of the tree to search.
//		order		The order in which nodes are visited - G_IN_ORDER, G_PRE_ORDER, G_POST_ORDER, or G_LEVEL_ORDER.
//		flags		Which types of children are to be searched, one of G_TRAVERSE_ALL, G_TRAVERSE_LEAVES and G_TRAVERSE_NON_LEAVES.
//		data		The data to find.
//Returns
//		The found GNode, or NULL if the data is not found.
GNode* g_node_find(GNode* root, int order, int flags, void* data) {
	void* d[2];
	d[0] = data;
	d[1] = NULL;
	g_node_traverse(root, order, flags, -1/*depth*/, g_node_find_func, d);
	return d[1];
}
/*--------------------------------------------------------------------------*/
//Finds the first child of a GNode with the given data.
//Parameters
//		node		A GNode.
//		flags		Which types of children are to be searched, one of G_TRAVERSE_ALL, G_TRAVERSE_LEAVES and G_TRAVERSE_NON_LEAVES.
//		data		The data to find.
//Returns
//		The found child GNode, or NULL if the data is not found.
GNode* g_node_find_child(GNode* node, int flags, void* data) {
	//w肳ꂽm[h́Aŏ̎qm[h,,NULL擾B
	node = node->children;
	//qm[h̃Xg̖ɓB܂Łc
	while(node) {
		//̎qm[h̃f[^Aw肳ꂽf[^Ɉvc
		if(node->data == data) {
			//̎qm[h[tȂ΁c
			if(G_NODE_IS_LEAF(node)) {
				//G_TRAVERSE_LEAVEStOw肳ĂA̎qm[hԂB
				if(flags & G_TRAVERSE_LEAVES) { return node; }
			//̎qm[h[tłȂ΁c
			} else {
				//G_TRAVERSE_NON_LEAVEStOw肳ĂA̎qm[hԂB
				if(flags & G_TRAVERSE_NON_LEAVES) { return node; }
			}
		}
		//̎qm[h֐i߂B
		node = node->next;
	}
	//Ɉvqm[hȂ΁ANULLԂB
	return NULL;
}
/*--------------------------------------------------------------------------*/
//Gets the position of the first child of a GNode which contains the given data.
//Parameters
//		node		A GNode.
//		data		The data to find.
//Returns
//		The index of the child of node which contains data, or -1 if the data is not found.
int g_node_child_index(GNode* node, void* data) {
	int n = 0;
	//w肳ꂽm[h́Aŏ̎qm[h,,NULL擾B
	node = node->children;
	//qm[h̃Xg̖ɓB܂Łc
	while(node) {
		//̎qm[h̃f[^Aw肳ꂽf[^ɈvA̎qm[h̃CfNXԂB
		if(node->data == data) { return n; }
		//CfNXi߂B
		n++;
		//̎qm[h֐i߂B
		node = node->next;
	}
	//w肳ꂽf[^Ɉvqm[hȂ΁A-1ԂB
	return -1;
}
/*--------------------------------------------------------------------------*/
//Gets the position of a GNode with respect to its siblings. child must be a child of node.
//The first child is numbered 0, the second 1, and so on.
//Parameters
//		node		A GNode.
//		child		A child of node.
//Returns
//		The position of child with respect to its siblings.
int g_node_child_position(GNode* node, GNode* child) {
	int n = 0;
	//w肳ꂽm[h́Aŏ̎qm[h,,NULL擾B
	node = node->children;
	//qm[h̃Xg̖ɓB܂Łc
	while(node) {
		//̎qm[hAw肳ꂽm[hɈvA̎qm[h̃CfNXԂB
		if(node == child) { return n; }
		//CfNXi߂B
		n++;
		//̎qm[h֐i߂B
		node = node->next;
	}
	//w肳ꂽm[hɈvqm[hȂ΁A-1ԂB
	return -1;
}
/*--------------------------------------------------------------------------*/
//Gets the first child of a GNode.
//Parameters
//		node		A GNode.
//Returns
//		The first child of node, or NULL if node is NULL or has no children.
GNode* g_node_first_child(GNode* node) {
	return node ? node->children : NULL;
}
/*--------------------------------------------------------------------------*/
//Gets the last child of a GNode.
//Parameters
//		node		A GNode (must not be NULL).
//
//Returns
//		The last child of node, or NULL if node has no children.
GNode* g_node_last_child(GNode* node) {
	return node->children ? g_node_last_sibling(node->children) : NULL;
}
/*--------------------------------------------------------------------------*/
//Gets a child of a GNode, using the given index.
//The first child is at index 0.
//If the index is too big, NULL is returned.
//Parameters
//		node		A GNode.
//		n		The index of the desired child.
//Returns
//		The child of node at index n.
GNode* g_node_nth_child(GNode* node, int n) {
	//w肳ꂽm[h́Aŏ̎qm[h,,NULL擾B
	node = node->children;
	//qm[h̃Xg̖ɓB܂Łc
	while(node) {
		//w肳ꂽCfNXɓBAB
		if(!n--) { break; }
		//̎qm[h֐i߂B
		node = node->next;
	}
	//w肳ꂽCfNX̎qm[h,,NULLԂB
	return node;
}
/*--------------------------------------------------------------------------*/
//Gets the first sibling of a GNode.
//This could possibly be the node itself.
//Parameters
//		node		A GNode.
//Returns
//		The first sibling of node.
GNode* g_node_first_sibling(GNode* node) {
//sv	if(node->parent) { return node->parent->children; }	//͍̏̂߂łAsĂsȂĂʂ͓łB
	while(node->prev) { node = node->prev; }
	return node;
}
/*--------------------------------------------------------------------------*/
//Gets the next sibling of a GNode.
//Parameters
//		node		A GNode.
//Returns
//		The next sibling of node, or NULL if node is the last node or NULL.
GNode* g_node_next_sibling(GNode* node) {
	return node ? node->next : NULL;
}
/*--------------------------------------------------------------------------*/
//Gets the previous sibling of a GNode.
//Parameters
//		node		A GNode.
//Returns
//		The previous sibling of node, or NULL if node is the first node or NULL.
GNode* g_node_prev_sibling(GNode* node) {
	return node ? node->prev : NULL;
}
/*--------------------------------------------------------------------------*/
//Gets the last sibling of a GNode.
//This could possibly be the node itself.
//Parameters
//		node		A GNode.
//Returns
//		The last sibling of node.
GNode* g_node_last_sibling(GNode* node) {
	while(node->next) { node = node->next; }
	return node;
}
/*--------------------------------------------------------------------------*/
//Gets the depth of a GNode.
//If node is NULL the depth is 0.
//The root node has a depth of 1.
//For the children of the root node the depth is 2.
//And so on.
//Parameters
//		node		A GNode.
//Returns
//		The depth of the GNode.
int g_node_depth(GNode* node) {
	int depth = 0;
	while(node) {
		depth++;
		node = node->parent;
	}
	return depth;
}
/*--------------------------------------------------------------------------*/
static int g_node_count_func(GNode* node, int flags, int n) {
	//w肳ꂽm[h́Aŏ̎qm[h,,NULL擾B
	node = node->children;
	//w肳ꂽm[h́Aqm[hL΁c
	if(node) {
		//G_TRAVERSE_NON_LEAVEStOw肳ĂAm[h̐𑝂₷B
		if(flags & G_TRAVERSE_NON_LEAVES) { n++; }
		//qm[h̃Xg̖ɓB܂Łc
		do {
			//̎qm[hɂāAċAB
			n = g_node_count_func(node, flags, n);
			//̎qm[h֐i߂B
			node = node->next;
		} while(node);
	//w肳ꂽm[h́Aqm[h΁c
	} else {
		//G_TRAVERSE_LEAVEStOw肳ĂAm[h̐𑝂₷B
		if(flags & G_TRAVERSE_LEAVES) { n++; }
	}
	//m[h̐𑝂₵ʂԂB
	return n;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Gets the number of nodes in a tree.
//Parameters
//		root		A GNode.
//		flags		Which types of children are to be counted, one of G_TRAVERSE_ALL, G_TRAVERSE_LEAVES and G_TRAVERSE_NON_LEAVES.
//Returns
//		The number of nodes in the tree.
int g_node_n_nodes(GNode* root, int flags) {
	return g_node_count_func(root, flags, 0);
}
/*--------------------------------------------------------------------------*/
//Gets the number of children of a GNode.
//Parameters
//		node		A GNode.
//Returns
//		The number of children of node.
int g_node_n_children(GNode* node) {
	int n = 0;
	//w肳ꂽm[h́Aŏ̎qm[h,,NULL擾B
	node = node->children;
	//qm[h̃Xg̖ɓB܂Łc
	while(node) {
		//qm[h̐𑝂₷B
		n++;
		//̎qm[h֐i߂B
		node = node->next;
	}
	//qm[h̐ԂB
	return n;
}
/*--------------------------------------------------------------------------*/
//Returns TRUE if node is an ancestor of descendant.
//This is true if node is the parent of descendant, or if node is the grandparent of descendant etc.
//Parameters
//		node		A GNode.
//		descendant	A GNode.
//Returns
//		TRUE if node is an ancestor of descendant.
int g_node_is_ancestor(GNode* node, GNode* descendant) {
	while(descendant) {
		descendant = descendant->parent;
		if(descendant == node) { return 1/*TRUE*/; }
	}
	return 0/*FALSE*/;
}
/*--------------------------------------------------------------------------*/
//Gets the maximum height of all branches beneath a GNode.
//This is the maximum distance from the GNode to all leaf nodes.
//If root is NULL, 0 is returned.
//If root has no children, 1 is returned.
//If root has children, 2 is returned.
//And so on.
//Parameters
//		root		A GNode.
//Returns
//		The maximum height of the tree beneath root.
int g_node_max_height(GNode* root) {
	int max_height = 0;	//(root==NULL)Ȃ0ԂB
	if(root) {
		GNode* child = root->children;
		while(child) {
			int tmp_height = g_node_max_height(child);
			if(tmp_height > max_height) { max_height = tmp_height; }
			child = child->next;
		}
		max_height++;	//(root!=NULL)Ȃ1`ԂB
	}
	return max_height;
}
/*--------------------------------------------------------------------------*/
//Unlinks a GNode from a tree, resulting in two separate trees.
//Parameters
//		node		The GNode to unlink, which becomes the root of a new tree.
void g_node_unlink(GNode* node) {
	//w肳ꂽm[hAŌ̃m[hłȂ΁c
	if(node->next) {				//prev<----->node<--->next
		node->next->prev = node->prev;		//prev<---------------next
	}
	//w肳ꂽm[hAŏ̃m[hłȂ΁c
	if(node->prev) {				//prev<----->node---->next
		node->prev->next = node->next;		//prev--------------->next
	//w肳ꂽm[hAem[h̍ŏ̎qm[hȂ΁c
	} else if(node->parent) {			//parent<===>node---->next
		node->parent->children = node->next;	//parent=============>next
	}
	//w肳ꂽm[h́Anext,prev,parentmɃNAB
	node->next   = NULL;				//prev<------node-~->next
	node->prev   = NULL;				//prev<---~-node
	node->parent = NULL;				//parent<=~=node
}
/*--------------------------------------------------------------------------*/
static void g_nodes_free(GNode* node) {
	while(node) {
		//݂̃m[hLĂB
		GNode* current = node;
		//݂̃m[h̃JOɁA̎qm[h擾ĂB
		node = node->next;
		//݂̃m[h́Aqm[h폜B
	//sv	if(current->children) {	//̔fg_nodes_free()̏Ɋ܂܂Ă̂ŕsvłB
			g_nodes_free(current->children);
	//sv	}
//{{2016/08/27ǉ:g_node_traverse(`G_PRE_ORDER`)ĂяoꂽR[obN֐AR[obN֐ɓnꂽnodeg폜o悤ɂ܂B
#ifndef GNODE_SAFE_SELF_DESTRUCTION_DURING_PRE_ORDER_TRAVERSING
//}}2016/08/27ǉ:g_node_traverse(`G_PRE_ORDER`)ĂяoꂽR[obN֐AR[obN֐ɓnꂽnodeg폜o悤ɂ܂B
		//݂̃m[h̃JB
		free(current);
//{{2016/08/27ǉ:g_node_traverse(`G_PRE_ORDER`)ĂяoꂽR[obN֐AR[obN֐ɓnꂽnodeg폜o悤ɂ܂B
#else //GNODE_SAFE_SELF_DESTRUCTION_DURING_PRE_ORDER_TRAVERSING
		//݂̃m[h̃JB
		if(current->_request_memory_free) { DIE(); }	//ɃJvtOZbgĂ鎖͖͂B
		if(current->_prevent_memory_free) {		//J}JE^₳Ăc(=(g_node_traverse(G_PRE_ORDER)˂̃m[hɑ΂g_node_traverse_pre_or_post_order()PreOrder̃^C~Oł̃R[obN֐Ăяo){1,}˂̃m[hɑ΂g_node_destroy()g_nodes_free()ƂoHŌĂяoꂽȂ΁c)
			current->_request_memory_free = 1;	//JvtOZbgA܂͊JȂB
		} else {					//J}JE^₳ĂȂ΁c(=LȊǑoHŌĂяoꂽꍇc)
			free(current);				//B
		}
#endif//GNODE_SAFE_SELF_DESTRUCTION_DURING_PRE_ORDER_TRAVERSING
//}}2016/08/27ǉ:g_node_traverse(`G_PRE_ORDER`)ĂяoꂽR[obN֐AR[obN֐ɓnꂽnodeg폜o悤ɂ܂B
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Removes root and its children from the tree, freeing any memory allocated.
//Parameters
//		root		The root of the tree/subtree to destroy.
void g_node_destroy(GNode* root) {
//sv	if(!G_NODE_IS_ROOT(root)) {	//̔fg_node_unlink()̏Ɋ܂܂Ă̂ŕsvłB
		g_node_unlink(root);
//sv	}
	g_nodes_free(root);
}
