/*	
 *	framit.c
 *
 *	P/ECE IT Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Nov 18 18:59:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/* * G[R[h̒ĺAsԍ𕉒lɂ̂łB
 *   vOCƁAG[R[hς\܂B
 *   G[R[h̒ĺAfobÔ߂ɗpĂB
 */
#define ERRNO	(-__LINE__)

/*
 *	-------	-------	-----------------------	-------	-----------------------
 *						PlayIT	
 *	Command	Name	Description		Support	Comment
 *	-------	-------	-----------------------	-------	-----------------------
 *	 1	Axy	Set speed			
 *	 2	Bxy	Position jump			
 *	 3	Cxy	Pattern break			
 *	 4	Dxy	Volume slide			
 *	 5	Exy	Portamento down			
 *	 6	Fxy	Portamento up			
 *	 7	Gxy	Tone portamento			
 *	 8	Hxy	Vibrato				
 *	 9	Ixy	Tremor				
 *	10	Jxy	Arpeggio			
 *	11	Kxy	Volslide+Vibrato		
 *	12	Lxy	Volslide+Toneporta		
 *	13	Mxy	Set channel volume		
 *	14	Nxy	Channel volslide		
 *	15	Oxy	Set offset			
 *	16	Pxy	Panning slide			
 *	17	Qxy	Retrigger note			
 *	18	Rxy	Tremolo				
 *	19	Sxy	Extended IT commands		
 *	20	Txy	Set tempo			
 *	21	Uxy	Fine vibrato			
 *	22	Vxy	Set global volume		
 *	23	Wxy	Global volume slide		
 *	24	Xxy	Set panning			
 *	25	Yxy	Panbrello			
 *	26	Zxy	Midi macro			
 *	-------	-------	-----------------------	-------	-----------------------
 *	19	S0x	---				
 *	19	S1x	Glissando control		
 *	19	S2x	---				
 *	19	S3x	Vibrato waveform		
 *	19	S4x	Tremolo waveform		
 *	19	S5x	Panbrello waveform		
 *	19	S6x	Fine pattern delay		
 *	19	S7x	Instr. control			
 *	19	S8x	Set panning			
 *	19	S9x	Sound control			
 *	19	SAx	Set high offset			
 *	19	SBx	Pattern loop			
 *	19	SCx	Note cut			
 *	19	SDx	Note delay			
 *	19	SEx	Pattern delay			
 *	19	SFx	Set active macro		
 *	-------	-------	-----------------------	-------	-----------------------
 */

/****************************************************************************
 *	P/ECE IT Driver
 ****************************************************************************/

void it_mix1_8bit(ITCHANNEL* channel, int volume, int frequency, int* mixbuf);
void it_mix1_16bit(ITCHANNEL* channel, int volume, int frequency, int* mixbuf);
void it_mix2(short* wbuff, const int* mixbuf);

static ITCHANNEL*
get_next_channel_marker(ITDRIVER* driver, ITCHANNELMARKER* channel_marker)
{
	const unsigned char* pattern_position;
	int channel_variable;
	int mask_variable;
	int i_channel;
	ITCHANNEL* channel;

	pattern_position = driver->pattern_position; /* o */

	/* Channel variable擾܂B */
	channel_variable = *pattern_position++;
	if(!channel_variable) { /* end of row */
		channel = NULL;
		goto L_EXIT;
	}
	i_channel = (channel_variable - 1) & 63;
	channel = &driver->channels[i_channel];

	/* Mask variable擾܂B */
	if(channel_variable & 128) {
		mask_variable = *pattern_position++;
		channel->previous_mask_variable = mask_variable;
	} else {
		mask_variable = channel->previous_mask_variable;
	}

	/* Note擾܂B */
	if(mask_variable & 1) {
		channel_marker->note = *pattern_position++;
		channel->last_channel_marker.note = channel_marker->note;
	} else if(mask_variable & 16) {
		channel_marker->note = channel->last_channel_marker.note;
	} else {
		channel_marker->note = -1;
	}

	/* Instrument擾܂B */
	if(mask_variable & 2) {
		channel_marker->instrument = *pattern_position++;
		channel->last_channel_marker.instrument = channel_marker->instrument;
	} else if(mask_variable & 32) {
		channel_marker->instrument = channel->last_channel_marker.instrument;
	} else {
		channel_marker->instrument = -1;
	}

	/* Volume/Panning擾܂B */
	if(mask_variable & 4) {
		channel_marker->volume_panning = *pattern_position++;
		channel->last_channel_marker.volume_panning = channel_marker->volume_panning;
	} else if(mask_variable & 64) {
		channel_marker->volume_panning = channel->last_channel_marker.volume_panning;
	} else {
		channel_marker->volume_panning = -1;
	}

	/* CommandACommand value擾܂B */
	if(mask_variable & 8) {
		channel_marker->command       = *pattern_position++;
		channel_marker->command_value = *pattern_position++;
		channel->last_channel_marker.command       = channel_marker->command;
		channel->last_channel_marker.command_value = channel_marker->command_value;
	} else if(mask_variable & 128) {
		channel_marker->command       = channel->last_channel_marker.command;
		channel_marker->command_value = channel->last_channel_marker.command_value;
	} else {
		channel_marker->command       = -1;
		channel_marker->command_value = -1;
	}

L_EXIT:
	driver->pattern_position = pattern_position; /* ߂ */

	return channel;
}

int
it_run(ITDRIVER* driver)
{
	ITCHANNELMARKER channel_marker;
	int i_channel;
	int i_pattern;
	int i_sample;
	ITCHANNEL* channel;
	ITINSTRUMENT* instrument;
	ITSAMPLE* sample;

	if(driver->stat) goto L_EXIT;

	/* 1[Tick]̎Ԍo߂JEgAbv܂B
	 * Tempo̐ݒl125̏ꍇɁA1[Tick]=1/50[Sec]ƂȂ܂B
	 */
	driver->progress += driver->tempo;
	while(driver->progress >= 125) {
		driver->progress -= 125;

		/* 1[Tick]o߂܂B
		 * oTickSpeed̐ݒlɒBA1[Row]i݂܂B
		 */
		driver->tick++;
		while(driver->tick >= driver->speed) {
			driver->tick -= driver->speed;

			/* Position jumpvĂ... */
			if(driver->position_jump != -1) {

				/* Orderݒ肵܂B
				 * * sOrderւPosition jumṕAPattern擾SongI[ƂČo܂B
				 */
				driver->order = driver->position_jump;
				driver->row = 0; /* Kv!! */

				/* Pattern擾܂B */
				for(;;) {
					if((driver->order < 0) ||
					   (driver->order > driver->ordnum - 1)) {
						driver->stat = ERRNO; /* SongI[ */
						goto L_EXIT;
					}
					i_pattern = driver->orders[driver->order];
					if(i_pattern != 254) { /* SkipłȂ */
						if((i_pattern < 0) ||
						   (i_pattern > driver->patnum - 1)) {
							driver->stat = ERRNO; /* Patterns */
							goto L_EXIT;
						}
						driver->pattern = &driver->patterns[i_pattern];
						if(driver->pattern->rows) { /* ԂłȂ */
							driver->pattern_position = driver->pattern->packed_data;
							break;
						}
					}
					driver->order++;
				}

				/* Position jump܂B */
				driver->position_jump = -1;
			}

			/* Pattern breakvĂ邩A܂PatternI... */
			if((driver->pattern_break != -1) ||
			   (driver->row >= driver->pattern->rows)) {

				/* Order̐擪Row֐i߂܂B
				 * * SongI[́APattern擾Ɍo܂B
				 * * ITɂ́AMODXMɂ悤ȁASongI[ł̃[v䂪܂B
				 *   [vSongɂ́AIPosition jumpݒKvłB
				 */
				driver->order++;
				driver->row = 0;

				/* Pattern擾܂B */
				for(;;) {
					if((driver->order < 0) ||
					   (driver->order > driver->ordnum - 1)) {
						driver->stat = ERRNO; /* SongI[ */
						goto L_EXIT;
					}
					i_pattern = driver->orders[driver->order];
					if(i_pattern != 254) { /* SkipłȂ */
						if((i_pattern < 0) ||
						   (i_pattern > driver->patnum - 1)) {
							driver->stat = ERRNO; /* Patterns */
							goto L_EXIT;
						}
						driver->pattern = &driver->patterns[i_pattern];
						if(driver->pattern->rows) { /* ԂłȂ */
							driver->pattern_position = driver->pattern->packed_data;
							break;
						}
					}
					driver->order++;
				}

				/* Pattern breakvĂ... */
				if(driver->pattern_break != -1) {

					/* Pattern breakɂĎw肳ꂽRow܂Ői߂܂B */
					if((driver->pattern_break < 0) ||
					   (driver->pattern_break > driver->pattern->rows - 1)) {
						driver->stat = ERRNO; /* Pattern breaks */
						goto L_EXIT;
					}
					while(driver->row < driver->pattern_break) {
						for(;;) {
							channel = get_next_channel_marker(driver, &channel_marker);
							if(!channel) {
								break; /* end of row */
							}
						}
						driver->row++;
					}

					/* Pattern break܂B */
					driver->pattern_break = -1;
				}
			}

			/* ̂߂ɁARowi߂Ă܂B */
			driver->row++;

			/* ܂AmVolume/PanningCommand܂B */
			for(i_channel = 0, channel = driver->channels;
			    i_channel < 64;
			    i_channel++, channel++) {
				channel->volume_panning = -1; /*  */
				channel->command = -1; /*  */
				/* Command value͌p\̂ŁANAĂ̓_!! */
			}

			/* 1[Row]Pattern data܂B */
			for(;;) {

				/* Channel marker擾܂B */
				channel = get_next_channel_marker(driver, &channel_marker);
				if(!channel) {
					break; /* end of row */
				}

				/* ChannelȂ΃XLbv܂B */
				if(channel->stat == ITCHANNEL_DISABLED) {
					continue;
				}

				/* Instruments܂B */
				if(channel_marker.instrument != -1) {
					if((channel_marker.instrument >= 1) &&
					   (channel_marker.instrument <= driver->insnum)) {
						channel->pending_instrument = &driver->instruments[channel_marker.instrument - 1];
					}
				}

				/* Notes܂B */
				if(channel_marker.note != -1) {
					switch(channel_marker.note) {
					case 255: /* note off */
						/* TODO:łB */
						channel->stat = ITCHANNEL_SILENT;
						break;

					case 254: /* notecut */
						/* TODO:łB */
						channel->stat = ITCHANNEL_SILENT;
						break;

					default: /* note on */
						if((channel_marker.note >= 0) &&
						   (channel_marker.note <= 119)) { /* C-0 -> B-9 */

							/* NoteSample擾܂B */
							instrument = channel->pending_instrument;
							i_sample = instrument->note_sample_keyboard_table[channel_marker.note].sample;
							/*̏ԕK{!! tɂchannel_marker.noteɔj󂳂Ă܂܂*/
							channel_marker.note = instrument->note_sample_keyboard_table[channel_marker.note].note;
							if(((channel_marker.note >= 0) && (channel_marker.note <= 119)) && /* C-0 -> B-9 */
							   ((i_sample >= 1) && (i_sample <= driver->smpnum))) {

								/* LSampleȂ... */
								sample = &driver->samples[i_sample - 1/*YȂ!!*/];
								if(sample->sample_data) {

									/* Jn܂B */
									channel->stat = ITCHANNEL_NOTEON;
									channel->playing_instrument = instrument;
									channel->playing_sample = sample;
									channel->vol = sample->vol;
									channel->sample_position = sample->sample_data;
									channel->sample_direction = 0;
									channel->progress = 0;
									channel->pitch = channel_marker.note << 8;
								}
							}
						}
						break;
					}
				}

				/* Volume/PanningLȂ΁Ai[܂B */
				if(channel_marker.volume_panning != -1) {
					channel->volume_panning = channel_marker.volume_panning;
				}

				/* CommandLȂ΁Ai[܂B */
				if(channel_marker.command != -1) {
					channel->command = channel_marker.command;
					channel->command_value = channel_marker.command_value;
				}
			}
		}

		/* e`lɂ... */
		for(i_channel = 0, channel = driver->channels;
		    i_channel < 64;
		    i_channel++, channel++) {

			/* Volume/PanningLȂ΁As܂B */
			channel_marker.volume_panning = channel->volume_panning;
			if(channel_marker.volume_panning != -1) {
				if((channel_marker.volume_panning >= 0) &&
				   (channel_marker.volume_panning <= 64)) {
					channel->vol = channel_marker.volume_panning;
				} else {
					/* TODO: */
				}
			}

			/* CommandLȂ΁As܂B */
			channel_marker.command = channel->command; /* o */
			if(channel_marker.command) {
				channel_marker.command_value = channel->command_value;
				switch(channel_marker.command) {
				case  1: /* Axy Set speed */
					driver->speed = channel_marker.command_value;
					if(driver->speed < 1) {
						driver->stat = ERRNO; /* Speeds */
						goto L_EXIT;
					}
					channel_marker.command = -1; /*  */
					break;
				case  2: /* Bxy Position jump */
					driver->position_jump = channel_marker.command_value;
					channel_marker.command = -1; /*  */
					break;
				case  3: /* Cxy Pattern break */
					driver->pattern_break = channel_marker.command_value;
					channel_marker.command = -1; /*  */
					break;
				//case  4: /* Dxy Volume slide */
				//case  5: /* Exy Portamento down */
				//case  6: /* Fxy Portamento up */
				//case  7: /* Gxy Tone portamento */
				//case  8: /* Hxy Vibrato */
				//case  9: /* Ixy Tremor */
				//case 10: /* Jxy Arpeggio */
				//case 11: /* Kxy Volslide+Vibrato */
				//case 12: /* Lxy Volslide+Toneporta */
				case 13: /* Mxy Set channel volume */
					channel->chnl_vol = channel_marker.command_value;
					channel_marker.command = -1; /*  */
					break;
				//case 14: /* Nxy Channel volslide */
				//case 15: /* Oxy Set offset */
				//case 16: /* Pxy Panning slide */
				//case 17: /* Qxy Retrigger note */
				//case 18: /* Rxy Tremolo */
				//case 19: /* Sxy Extended IT commands */
				case 20: /* Txy Set tempo */
					driver->tempo = channel_marker.command_value;
					if(driver->tempo < 1) {
						driver->stat = ERRNO; /* Tempos */
						goto L_EXIT;
					}
					channel_marker.command = -1; /*  */
					break;
				//case 21: /* Uxy Fine vibrato */
				case 22: /* Vxy Set global volume */
					driver->gv = channel_marker.command_value;
					channel_marker.command = -1; /*  */
					break;
				//case 23: /* Wxy Global volume slide */
				//case 24: /* Xxy Set panning */
				//case 25: /* Yxy Panbrello */
				//case 26: /* Zxy Midi macro */
				}
				channel->command = channel_marker.command; /* ߂ */
			}
		}
	}

L_EXIT:
	return driver->stat;
}

int
it_mix(ITDRIVER* driver, short wbuff[/*ITBUFLEN*/])
{
	static int mixbuf[ITBUFLEN]; /* ~LVOobt@Ars`shbłI */
	//
	int i_channel;
	int final_volume;
	int pitch;
	int frequency;
	ITCHANNEL* channel;
	ITINSTRUMENT* instrument;
	ITSAMPLE* sample;

	if(driver->stat) goto L_EXIT;

	/* ܂A~LVOobt@NA܂B */
	memset(mixbuf, 0, sizeof mixbuf);

	/* ̊e`lɂ... */
	for(i_channel = 0, channel = driver->channels;
	    i_channel < 64;
	    i_channel++, channel++) {

		/* Disabled܂SilentȂΔ΂܂B */
		if(channel->stat <= ITCHANNEL_SILENT) continue;

		instrument = channel->playing_instrument;
		sample = channel->playing_sample;

		/* {[߂܂B */
		final_volume  = channel->vol;		/* Volume at which note is to be played (Ranges from 0 to  64) + 6   bit= 6bit */
		final_volume *= sample->gvl;		/* Sample volume                        (Ranges from 0 to  64) + 6   bit=12bit */
		final_volume *= instrument->gbv >> 1;	/* Instrument volume                    (Ranges from 0 to 128) +(7-1)bit=18bit */
		final_volume *= channel->chnl_vol;	/* Channel volume                       (Ranges from 0 to  64) + 6   bit=24bit */
		final_volume *= driver->gv >> 1;	/* Global volume                        (Ranges from 0 to 128) +(7-1)bit=30bit */
		final_volume >>= 20;			/*                                                             - 20  bit=10bit */
		if(!final_volume) continue; /*  */

		/* Đg߂܂B */
		pitch = channel->pitch >> 8;
		if((pitch < 0) ||
		   (pitch > 119)) continue;
		frequency = sample->c5speed;
		frequency *= it_pitch_table[pitch % 12];
		frequency >>= (10 - pitch / 12) + (10/*bit*/ - 5);

		if(sample->flg & (1 << 1/*16 bit sample*/)) {
			it_mix1_16bit(channel, final_volume, frequency, mixbuf);
		} else { /* 8 bit sample */
			it_mix1_8bit(channel, final_volume, frequency, mixbuf);
		}
	}

	/* ~LVOobt@NbsOāAo̓obt@֏݂܂B */
	it_mix2(wbuff, mixbuf);

L_EXIT:
	return driver->stat;
}

void
it_mix1_8bit(ITCHANNEL* channel, int volume, int frequency, int* mixbuf)
{
	int n;
	int stat;
	ITSAMPLE* sample;
	int flg;
	const unsigned char* sample_end;
	const unsigned char* loop_begin;
	const unsigned char* loop_end;
	const unsigned char* susloop_begin;
	const unsigned char* susloop_end;
	const unsigned char* sample_position;
	int sample_direction;
	int progress;

	/* 8bit sample -> 16bit sample */
	volume <<= 8;

	/* ߂sv */
	stat = channel->stat;
	sample = channel->playing_sample;
	flg = sample->flg;
	sample_end = sample->sample_end;
	loop_begin = sample->loop_begin;
	loop_end = sample->loop_end;
	susloop_begin = sample->susloop_begin;
	susloop_end = sample->susloop_end;

	/* ߂Kv */
	sample_position = channel->sample_position;
	sample_direction = channel->sample_direction;
	progress = channel->progress;

	n = ITBUFLEN;
	do {
		progress += frequency;
		while(progress >= SPEAKER_FREQUENCY) {
			progress -= SPEAKER_FREQUENCY;

			if(sample_direction == 0/*Forward*/) {
				sample_position += sizeof(char);
				if((stat == ITCHANNEL_NOTEON) &&
				   (flg & (1 << 5/*Sustain loop on*/)) &&
				   (sample_position >= susloop_end)) {
					if(flg & (1 << 7/*Ping Pong sustain loop*/)) {
						sample_position = susloop_end - 1;
						sample_direction = 1;
					} else { /* Forward sustain loop */
						sample_position = susloop_begin;
					}
				} else if((flg & (1 << 4/*Loop On*/)) &&
					  (sample_position >= loop_end)) {
					if(flg & (1 << 6/*Ping Pong loop*/)) {
						sample_position = loop_end - 1;
						sample_direction = 1;
					} else { /* Forward loop */
						sample_position = loop_begin;
					}
				} else { /* Loop Off, Sustain loop Off */
					if(sample_position >= sample_end) {
						channel->stat = ITCHANNEL_SILENT;
						return;
					}
				}

			} else { /* Backword */
				sample_position -= sizeof(char);
				if((stat == ITCHANNEL_NOTEON) &&
				   (flg & (1 << 5/*Sustain loop on*/)) &&
				   (sample_position < susloop_begin)) {
					sample_position = susloop_begin;
					sample_direction = 0;
				} else if((flg & (1 << 4/*Loop On*/)) &&
					  (sample_position < loop_begin)) {
					sample_position = loop_begin;
					sample_direction = 0;
				}
			}
		}

		*mixbuf++ += (char)LEBYTE(sample_position) * volume;
	} while(--n);

	/* ߂ */
	channel->sample_position = sample_position;
	channel->sample_direction = sample_direction;
	channel->progress = progress;
}

void
it_mix1_16bit(ITCHANNEL* channel, int volume, int frequency, int* mixbuf)
{
	int n;
	int stat;
	ITSAMPLE* sample;
	int flg;
	const unsigned char* sample_end;
	const unsigned char* loop_begin;
	const unsigned char* loop_end;
	const unsigned char* susloop_begin;
	const unsigned char* susloop_end;
	const unsigned char* sample_position;
	int sample_direction;
	int progress;

	/* ߂sv */
	stat = channel->stat;
	sample = channel->playing_sample;
	flg = sample->flg;
	sample_end = sample->sample_end;
	loop_begin = sample->loop_begin;
	loop_end = sample->loop_end;
	susloop_begin = sample->susloop_begin;
	susloop_end = sample->susloop_end;

	/* ߂Kv */
	sample_position = channel->sample_position;
	sample_direction = channel->sample_direction;
	progress = channel->progress;

	n = ITBUFLEN;
	do {
		progress += frequency;
		while(progress >= SPEAKER_FREQUENCY) {
			progress -= SPEAKER_FREQUENCY;

			if(sample_direction == 0/*Forward*/) {
				sample_position += sizeof(short);
				if((stat == ITCHANNEL_NOTEON) &&
				   (flg & (1 << 5/*Sustain loop on*/)) &&
				   (sample_position >= susloop_end)) {
					if(flg & (1 << 7/*Ping Pong sustain loop*/)) {
						sample_position = susloop_end - 1;
						sample_direction = 1;
					} else { /* Forward sustain loop */
						sample_position = susloop_begin;
					}
				} else if((flg & (1 << 4/*Loop On*/)) &&
					  (sample_position >= loop_end)) {
					if(flg & (1 << 6/*Ping Pong loop*/)) {
						sample_position = loop_end - 1;
						sample_direction = 1;
					} else { /* Forward loop */
						sample_position = loop_begin;
					}
				} else { /* Loop Off, Sustain loop Off */
					if(sample_position >= sample_end) {
						channel->stat = ITCHANNEL_SILENT;
						return;
					}
				}

			} else { /* Backword */
				sample_position -= sizeof(short);
				if((stat == ITCHANNEL_NOTEON) &&
				   (flg & (1 << 5/*Sustain loop on*/)) &&
				   (sample_position < susloop_begin)) {
					sample_position = susloop_begin;
					sample_direction = 0;
				} else if((flg & (1 << 4/*Loop On*/)) &&
					  (sample_position < loop_begin)) {
					sample_position = loop_begin;
					sample_direction = 0;
				}
			}
		}

		*mixbuf++ += (short)LEHALF(sample_position) * volume;
	} while(--n);

	/* ߂ */
	channel->sample_position = sample_position;
	channel->sample_direction = sample_direction;
	channel->progress = progress;
}

void
it_mix2(short* wbuff, const int* mixbuf)
{
	int n;
	int output;

	n = ITBUFLEN;
	do {
		/*   final_volume      (10bit)
		 * x sample_output     (16bit)
		 * x max_channels(=64) ( 6bit)
		 * ---------------------------
		 *                     (32bit)
		 */
		output = *mixbuf++ >> ((32 - 16) - 4/**/);
		if(output >  32767) output =  32767;
		if(output < -32768) output = -32768;
		*wbuff++ = output;
	} while(--n);
}
