/*
 *	clipsndm.c
 *
 *	Sound Manager
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2013 Naoyuki Sawa
 *
 *	* Sat Jul 27 21:43:04 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	* Thu Aug 01 00:52:48 JST 2013 Naoyuki Sawa
 *	- ֐̐ǋL܂B
 *	* Thu Sep 12 23:08:12 JST 2013 Naoyuki Sawa
 *	- SndMgr_AttCh()A`lĐ̏ꍇ̂ݏs悤ɁAC܂B
 *	- CÕR[h́A`l~łĂAsĂ܂Ă܂B
 *	  ĂȂ`lɑ΂fnAtt()sƂAʂ܂B(Q͖)
 *	* Fri Sep 13 01:48:44 JST 2013 Naoyuki Sawa
 *	- SndMgr_AttMaster()ǉ܂B
 */
#include "clip.h"

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

ST_SndMgr* SndMgr_Init(const ST_SndMgrInfo* pInfo, int MinCh, int MaxCh) {
	ST_SndMgr* pSndMgr;
	/* 񂪖Ȃ΁AG[I܂B */
	if(!pInfo || !pInfo->fnPlay || !pInfo->fnStop || !pInfo->fnStat || !pInfo->fnAtt ||
	   ((unsigned)MinCh > UCHAR_MAX) || ((unsigned)MaxCh > UCHAR_MAX) || (MinCh > MaxCh)) { DIE(); }
	/* \̂̃mۂ܂B */
	pSndMgr = calloc(sizeof(ST_SndMgr) + sizeof(ST_SndMgrCh) * (MaxCh - MinCh + 1), 1);
	if(!pSndMgr) { DIE(); } /* s */
	/* i[܂B */
	pSndMgr->pInfo = pInfo;
	pSndMgr->MinCh = MinCh;
	pSndMgr->MaxCh = MaxCh;
	return pSndMgr;
}

/*--------------------------------------------------------------------------*/

void SndMgr_Free(ST_SndMgr* pSndMgr) {
	/* ȂΉ܂B */
	if(!pSndMgr) { return; }
	/* S`lĐ~܂B */
	SndMgr_StopAll(pSndMgr);
	/* \̂̃J܂B */
	free(pSndMgr);
}

/*--------------------------------------------------------------------------*/

void SndMgr_Exec(ST_SndMgr* pSndMgr) {
	int iCh;
	ST_SndMgrCh* pCh;
	/* Ȃ΁AG[I܂B */
	if(!pSndMgr) { DIE(); }
	/* S`l𑖍āc */
	for(iCh = pSndMgr->MinCh; iCh <= pSndMgr->MaxCh; iCh++) {
		/* `l|C^擾܂B */
		pCh = &pSndMgr->Ch[iCh - pSndMgr->MinCh];
		/* ĐȂ΁c */
		if(pCh->iLoop) {
			/* ĐpȂ΁c */
			if((*pSndMgr->pInfo->fnStat)(iCh)) {
				/* Đێdvx炵܂B */
				if(pCh->uKeep) { pCh->uKeep--; }
				/* ʕωȂ΁c
				 * - Đ~̃`lɑ΂ẮAʕω̏sKv܂B
				 *   ĂȂ`ľʂݒ肵ĂAɂ斳łB
				 *   Đ~̃`ĺA̍ĐJnɁAʂZbg܂B
				 *   ]āAĐ~̃`ľʕωsĂAӖ܂B
				 */
				if(pCh->attPeriod) {
					/* ݂̌ʂvZ܂B */
					int attNow = pCh->attNew;		/* ŏIʂƂĂ */
					if(++pCh->attTime < pCh->attPeriod) {	/* ωrȂ΁c */
						attNow = ((     attNow *                   pCh->attTime ) +
							  (pCh->attOld * (pCh->attPeriod - pCh->attTime))) / pCh->attPeriod;
					} else {				/* ωȂ΁c */
						pCh->attPeriod = 0;		/* ω}[N */
					}
					/* Ŝ̌ʂZ܂B */
					if((attNow += pSndMgr->attMaster) > 64) { attNow = 64; }
					/* ʂݒ肵܂B */
					(*pSndMgr->pInfo->fnAtt)(iCh, attNow);
				}
			/* ĐȂ΁c */
			} else {
				/* ~}[N܂B */
				pCh->iLoop = 0;
			}
		}
	}
}

/*--------------------------------------------------------------------------*/

void SndMgr_PlayCh(ST_SndMgr* pSndMgr, int iCh, int iData, int iLoop) {
	ST_SndMgrCh* pCh;
	/* ÁA`lԍC[vw肪Ȃ΁AG[I܂B */
	if(!pSndMgr || (iCh < pSndMgr->MinCh) || (iCh > pSndMgr->MaxCh) || !iLoop) { DIE(); }
	/* `l|C^擾܂B */
	pCh = &pSndMgr->Ch[iCh - pSndMgr->MinCh];
	/* ĐJn܂B */
	(*pSndMgr->pInfo->fnPlay)(iCh, iData, iLoop);
	/* Đi[܂B */
	pCh->iLoop = iLoop;
	pCh->iData = iData;
	pCh->uKeep = USHRT_MAX;
	/* ʂZbg܂B */
	SndMgr_AttCh(pSndMgr, iCh, 0, 0);
}

/*--------------------------------------------------------------------------*/

void SndMgr_PlayData(ST_SndMgr* pSndMgr, int iData, int iLoop) {
	int iCh;
	ST_SndMgrCh* pCh;
	ST_SndMgrCh* pCh1 = NULL; /* ւ`l1BĐf[^Ɠf[^ĐŒ~ꂽÁAɒ~`l */
	ST_SndMgrCh* pCh2 = NULL; /* ւ`l2BĐf[^ƈႤf[^L[vĐŁAĐێdvxŒ̃`l */
	ST_SndMgrCh* pCh3 = NULL; /* ւ`l3BĐf[^ƈႤf[^𖳌[vĐŁAĐێdvxŒ̃`l */
	/* ÁA[vw肪Ȃ΁AG[I܂B */
	if(!pSndMgr || !iLoop) { DIE(); }
	/* Đf[^Ɠf[^Đ̃`lSĒ~܂B */
	SndMgr_StopData(pSndMgr, iData);
	/* S`l𑖍āc */
	for(iCh = pSndMgr->MinCh; iCh <= pSndMgr->MaxCh; iCh++) {
		/* `l|C^擾܂B */
		pCh = &pSndMgr->Ch[iCh - pSndMgr->MinCh];
		/* ~Ȃ΁c */
		if(!pCh->iLoop) {
			/* ւ`l1XV܂B */
			if(!pCh1) { pCh1 = pCh; }
		/* L[vĐȂ΁c */
		} else if(pCh->iLoop > 0) {
			/* ւ`l2XV܂B */
			if(!pCh2 || (pCh->uKeep < pCh2->uKeep)) { pCh2 = pCh; }
		/* [vĐȂ΁c */
		} else /*if(pCh->iLoop < 0)*/ {
			/* V[vw肪A[vȂ΁c */
			if(iLoop < 0) {
				/* ւ`l3XV܂B */
				if(!pCh3 || (pCh->uKeep < pCh3->uKeep)) { pCh3 = pCh; }
			/* V[vw肪AL[vȂ΁c */
			} else {
				/* ̖[vAVL[vɍւ邱Ƃ͂܂B */
			}
		}
	}
	/* ւ`l123̗D揇ŁAւ`lI܂B */
//{{2013/07/26:gcc33̍œKoO (P/ECEL^ 2013/7/30ugcc33 Zq̍œKoOvQ)
#ifndef PIECE
	pCh = pCh1 ?  pCh1  : pCh2 ?  pCh2  : pCh3; /* gcc33̍œKoOBua?a:b?b:cvɑ΂Aua=0,b=1,c=0vnƁAʂāu0vɂȂB */
#else //PIECE
	pCh = pCh1 ?/*pCh1*/: pCh2 ?/*pCh2*/: pCh3; /* gcc33̊g@\gāua?:b?:cvƏ΁Agcc33̍œKoOłAʂu1vɂȂB */
#endif//PIECE
//}}2013/07/26:gcc33̍œKoO (P/ECEL^ 2013/7/30ugcc33 Zq̍œKoOvQ)
	/* ւ`lL΁c */
	if(pCh) {
		/* `lԍtZ܂B */
		iCh = (pCh - pSndMgr->Ch) + pSndMgr->MinCh;
		/* ĐJn܂B */
		SndMgr_PlayCh(pSndMgr, iCh, iData, iLoop);
	}
}

/*--------------------------------------------------------------------------*/

void SndMgr_StopCh(ST_SndMgr* pSndMgr, int iCh) {
	ST_SndMgrCh* pCh;
	/* ÁA`lԍȂ΁AG[I܂B */
	if(!pSndMgr || (iCh < pSndMgr->MinCh) || (iCh > pSndMgr->MaxCh)) { DIE(); }
	/* `l|C^擾܂B */
	pCh = &pSndMgr->Ch[iCh - pSndMgr->MinCh];
	/* ĐȂ΁c */
	if(pCh->iLoop) {
		/* Đ~܂B */
		(*pSndMgr->pInfo->fnStop)(iCh);
		/* ~}[N܂B */
		pCh->iLoop = 0;
	}
}

/*--------------------------------------------------------------------------*/

void SndMgr_StopData(ST_SndMgr* pSndMgr, int iData) {
	int iCh;
	ST_SndMgrCh* pCh;
	/* Ȃ΁AG[I܂B */
	if(!pSndMgr) { DIE(); }
	/* S`l𑖍āc */
	for(iCh = pSndMgr->MinCh; iCh <= pSndMgr->MaxCh; iCh++) {
		/* `l|C^擾܂B */
		pCh = &pSndMgr->Ch[iCh - pSndMgr->MinCh];
		/* ĐAAĐ̃f[^ƒ~f[^vc */
		if(pCh->iLoop && (pCh->iData == iData)) {
			/* Đ~܂B */
			SndMgr_StopCh(pSndMgr, iCh);
		}
	}
}

/*--------------------------------------------------------------------------*/

void SndMgr_StopAll(ST_SndMgr* pSndMgr) {
	int iCh;
	/* Ȃ΁AG[I܂B */
	if(!pSndMgr) { DIE(); }
	/* S`l𑖍āc */
	for(iCh = pSndMgr->MinCh; iCh <= pSndMgr->MaxCh; iCh++) {
		/* Đ~܂B */
		SndMgr_StopCh(pSndMgr, iCh);
	}
}

/*--------------------------------------------------------------------------*/

void SndMgr_AttCh(ST_SndMgr* pSndMgr, int iCh, int attNew, int attPeriod) {
	ST_SndMgrCh* pCh;
	/* ÁA`lԍCʁCωԂȂ΁AG[I܂B */
	if(!pSndMgr || (iCh < pSndMgr->MinCh) || (iCh > pSndMgr->MaxCh) || ((unsigned)attNew > 64) || ((unsigned)attPeriod > USHRT_MAX)) { DIE(); }
	/* `l|C^擾܂B */
	pCh = &pSndMgr->Ch[iCh - pSndMgr->MinCh];
	/* ĐȂ΁c
	 * - Đ~̃`lɑ΂ẮAʕω̏sKv܂B
	 *   ĂȂ`ľʂݒ肵ĂAɂ斳łB
	 *   Đ~̃`ĺA̍ĐJnɁAʂZbg܂B
	 *   ]āAĐ~̃`ľʕωsĂAӖ܂B
	 */
	if(pCh->iLoop) {
		/* SndMgr_AttCh()Ă΂ꂽASndMgr_Exec()Ă΂܂ł̊Ԃ́Aʂݒ肵܂B
		 * - ωłȂ΁Ȁ(=O̍ŏI)ݒ肵܂B
		 * - ωȂ΁A̍ŏIʂݒ肵܂B
		 */
		int attNow = attPeriod ? pCh->attNew/*O̍ŏI*/ : attNew/*̍ŏI*/;
		/* Ŝ̌ʂZ܂B */
		if((attNow += pSndMgr->attMaster) > 64) { attNow = 64; }
		/* ʂݒ肵܂B */
		(*pSndMgr->pInfo->fnAtt)(iCh, attNow);
		/* ωi[܂B */
		pCh->attPeriod = attPeriod;
		pCh->attTime   = 0;
		pCh->attOld    = pCh->attNew; /* ̏=O̍ŏI */
		pCh->attNew    = attNew;
	}
}

/*--------------------------------------------------------------------------*/

void SndMgr_AttData(ST_SndMgr* pSndMgr, int iData, int attNew, int attPeriod) {
	int iCh;
	ST_SndMgrCh* pCh;
	/* ÁAΏۃf[^CʁCωԂȂ΁AG[I܂B */
	if(!pSndMgr || ((unsigned)attNew > 64) || ((unsigned)attPeriod > USHRT_MAX)) { DIE(); }
	/* S`l𑖍āc */
	for(iCh = pSndMgr->MinCh; iCh <= pSndMgr->MaxCh; iCh++) {
		/* `l|C^擾܂B */
		pCh = &pSndMgr->Ch[iCh - pSndMgr->MinCh];
		/* ĐAAĐ̃f[^Ɛݒf[^vc */
		if(pCh->iLoop && (pCh->iData == iData)) {
			/* ʂݒ肵܂B */
			SndMgr_AttCh(pSndMgr, iCh, attNew, attPeriod);
		}
	}
}

/*--------------------------------------------------------------------------*/

void SndMgr_AttAll(ST_SndMgr* pSndMgr, int attNew, int attPeriod) {
	int iCh;
	/* Ȃ΁AG[I܂B */
	if(!pSndMgr) { DIE(); }
	/* S`l𑖍āc */
	for(iCh = pSndMgr->MinCh; iCh <= pSndMgr->MaxCh; iCh++) {
		/* ʂݒ肵܂B */
		SndMgr_AttCh(pSndMgr, iCh, attNew, attPeriod);
	}
}

/*--------------------------------------------------------------------------*/

void SndMgr_AttMaster(ST_SndMgr* pSndMgr, int attMaster) {
	int iCh;
	ST_SndMgrCh* pCh;
	/* ÁAʂȂ΁AG[I܂B */
	if(!pSndMgr || ((unsigned)attMaster > 64)) { DIE(); }
	/* Ŝ̌ʂi[܂B */
	pSndMgr->attMaster = attMaster;
	/* S`l𑖍āc */
	for(iCh = pSndMgr->MinCh; iCh <= pSndMgr->MaxCh; iCh++) {
		/* `l|C^擾܂B */
		pCh = &pSndMgr->Ch[iCh - pSndMgr->MinCh];
		/* ĐȂ΁c
		 * - Đ~̃`lɑ΂ẮAʕω̏sKv܂B
		 *   ĂȂ`ľʂݒ肵ĂAɂ斳łB
		 *   Đ~̃`ĺA̍ĐJnɁAʂZbg܂B
		 *   ]āAĐ~̃`ľʕωsĂAӖ܂B
		 */
		if(pCh->iLoop) {
			/* ݂̌ʂvZ܂B */
			int attNow = pCh->attNew;	/* ŏIʂƂĂ */
			if(pCh->attPeriod) {		/* ʕωȂ΁c */
				attNow = ((     attNow *                   pCh->attTime ) +
					  (pCh->attOld * (pCh->attPeriod - pCh->attTime))) / pCh->attPeriod;
			}
			/* Ŝ̌ʂZ܂B */
			if((attNow += pSndMgr->attMaster) > 64) { attNow = 64; }
			/* ʂݒ肵܂B */
			(*pSndMgr->pInfo->fnAtt)(iCh, attNow);
		}
	}
}

