/*
 *	cliprrs.c
 *
 *	Round Robin Scheduler (RRS)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Sun Jan 17 21:27:14 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Jan 19 21:44:45 JST 2016 Naoyuki Sawa
 *	- cliprrs.c̈ԉɁwӎxǋL܂B
 *	  vO̕ύX͗L܂B
 *	* Fri Feb 19 21:59:00 JST 2016 Naoyuki Sawa
 *	- RRS_new_l(),RRS_new_a(),RRS_new_v()̈ύX܂B
 *	  ܂ł͍\̂̃|C^߂lŕԂĂ܂AύX͑Ŏw肷ϐɊi[悤ɂ܂B
 *	  ύXŔAwӎx2016/02/19̒ǋLQƂĉB
 *	* Sun Feb 28 23:18:54 JST 2016 Naoyuki Sawa
 *	- RRS_n_job(),RRS_i_job()ǉ܂B
 *	  AvP[V̓Wu̐mĂ܂AeWȕ͎gFĂ܂̂ŁAʂ͂̊֐ĂяoKv͗L܂B
 *	  񓖊֐ǉړÍAeWu狤ʂŌĂяo郍OŁAԖڂ̃WuĂяoꂽL^Kv߂łB
 *	  Ƃ΁Aȉ̂悤ɋL^鎖o܂B
 *	  syslog(LOG_DEBUG, "call from job#%d/%d", RRS_i_job()+1, RRS_n_job()); //̉Ԗڂ̃WuĂ΂ꂽL^B
 *	* Wed Jun 15 21:27:07 JST 2016 Naoyuki Sawa
 *	- uWup̊֐vƂāARRS_sync()ǉ܂B
 *	  gṕAcliprrs.ćuWup̊֐̎gpvQƂĉB
 *	- RRS_sync()ǉŔApthread_barrier_wait()Ɠl̐䂪słB
 *	  clipmsgh.cW[̃bZ[WnhVFCN@\gē鎖s\ł͂Ȃ̂łAM̃tF[YGɂȂăoO𐶂Ղ肪L܂B
 *	  ɁAbZ[WnhVFCN@\gĎOȏ̃Wu𓯊鎖́AɍƎv܂B
 *	  ŁAWupɓ@\ƂāARRS_sync()ǉ鎖ɂ܂B
 *	  RRS_sync()g΁AOȏ̃Wu𓯊鎖eՂłA̃Wu𓯊鏈AbZ[WnhVFCN@\gVvɏ܂B
 *	  ̗́Acliprrs.ćuWup̊֐̎gpvQƂĉB
 *	* Thu Jun 16 20:40:56 JST 2016 Naoyuki Sawa
 *	- 'oAꂽtOZbg܂Ń[vđ҂'̒ŁAm[h`FCj󂳂ĂȂfobOǉ܂B
 *	  ڍׂ́ARRS_sync()'Thu Jun 16 20:40:56 JST 2016'̃RgQƂĉB
 *	* Fri Sep 30 21:41:38 JST 2016 Naoyuki Sawa
 *	- RRS_new_v(),RRS_yield()́AHewp̎쐬܂B
 *	  u/clip/keep/RX}CRp_ReLXgXCb`.7zv́A2016/09/30o[W𗘗pĂ܂B
 *	  I蓖Ă邽߂ɁAX^bNobt@TCY͌ŒƂ܂B
 *	- RRS_sync_idle()ǉ܂B
 *	  ܂ŁARRS_sync()ŃubNĂԂ́AAvP[V`̎ĂяoȂ肪L܂B
 *	  ̖邽߂ɁAubNĂԂɌĂяoAvP[V`̃AChO֐woo[W̊֐ǉ܂B
 *	* Sat Oct 01 21:11:57 JST 2016 Naoyuki Sawa
 *	- RRS_new_v(),RRS_yield()Hewp̎ŁAContext.srcoCiC\[Xɖߍ݂܂B
 *	  AContext.hContext.srcAvWFNgɊ܂߂Kv͖Ȃ܂B
 *	  u/clip/keep/RX}CRp_ReLXgXCb`.7zv́A2016/10/01o[W𗘗pĂ܂B
 *	  ڍׂ́A/clip/keep/RX}CRp_ReLXgXCb`.7zREADME.TXT́ÃRgQƂĉB
 *	* Sat Dec 03 21:41:01 JST 2016 Naoyuki Sawa
 *	- vbgtH[ˑ̎@Io悤ɂ܂B
 *	  ܂ł́AWindowsłPthreadsAP/ECEłucontextɌߑłɂĂ̂łA̎@Io悤ɂȂ܂B
 *	- ܂ŁAWindowsPthreadsߑłɂĂŔABoehm GCucontext,y,Boehm GCFiber𕹗poȂłB
 *	  A2016/12/01ɁApcl.cW[ɂāABoehm GCƃR[`𕹗p@A@W[ɂKpo鎖ɋCt܂B
 *	  W[łAWindowsłucontextFibergpɁApcl.cW[Ɠ@Kp̂ŁAWindowsłucontextFiberg悤ɂȂ܂B
 *	- PthreadsAucontext(Fiber)g̗_́AReLXgXCb`̏łB
 *	  ܂ɌvĂ݂ƂAPthreadsucontext̕A100{ȏ㑁悤łB
 *	  Ƃ͌APthreadsɂReLXgXCb`łA}CNbxĂȂ悤Ȃ̂ŁAPthreadsł͖łB
 *	- _beginthreadexɂƁAPCLɂǉ܂B
 *	  _beginthreadexɂǉŔA'POSIX Threads Library for Win32'CuĂA{̃Xbhɂ\ł鎖؂邽߂łB
 *	  A'POSIX Threads Library for Win32'CupoȂȂꍇ̂߂̕یłȀ݂͂܂dvł͂܂B
 *	  PCLɂǉŔApcl.cW[̓쌟؂̈ƂĎłȀ݂͂܂dvł͂܂B
 */
#include "clip.h"
/****************************************************************************
 *	vbgtH[ˑ̎@IB
 ****************************************************************************/
//
//				Win32	P/ECE	Hew	WindowsɂBoehm GCƕp邽߂̑΍				ReLXgXCb`(Windows10 64bit Core i7-4500UŌv)
//
//Pthreadsɂ		Z	~	~	{̃XbhłABoehm GCFôŁAp̑΍͕svłB	4146.500000[imb/]
//_beginthreadexɂ	Z	~	~	{̃XbhłABoehm GCFôŁAp̑΍͕svłB	4218.750000[imb/]
//ucontextɂ		Z	Z	~	W[RRS_yield()ōsĂ܂B					  29.250000[imb/]
//Fiberɂ		Z	Z	~	W[RRS_yield()ōsĂ܂B					  31.250000[imb/]
//PCLɂ		Z	Z	~	pcl.cW[co_call()ōsĂ̂ŁAW[ł͑΍svłB	  50.750000[imb/]
//RX}CRɂ	~	~	Z											
//
#ifdef  WIN32
//{{ǂꂩIĉB
//	#define RRS_USE_PTHREADS	//Pthreadsɂ		2016/12/02܂ł͂gpĂ܂Bۂ̉pŁA肵ē삵Ă܂B
//	#define RRS_USE_BEGINTHREADEX	//_beginthreadexɂ	ymFł͐삵܂B
	#define RRS_USE_UCONTEXT	//ucontextɂ		2016/12/03ȍ~͂gp܂B肵ē삷邩AA쌟ؒłB
//	#define RRS_USE_FIBER		//Fiberɂ		ymFł͐삵܂B
//	#define RRS_USE_PCL		//PCLɂ			ymFł͐삵܂B
//}}ǂꂩIĉB
#endif//WIN32
/*--------------------------------------------------------------------------*/
#ifdef  PIECE
//{{ǂꂩIĉB
	#define RRS_USE_UCONTEXT	//ucontextɂ		2016/12/02܂łA2016/12/03ȍ~Agp܂BA쌟ؒłB
//	#define RRS_USE_FIBER		//Fiberɂ		ymFł͐삵܂B
//	#define RRS_USE_PCL		//PCLɂ			ymFł͐삵܂B
//}}ǂꂩIĉB
#endif//PIECE
/*--------------------------------------------------------------------------*/
#ifdef  __RENESAS__
//{{ǂꂩIĉB
	#define RRS_USE_RXMCU		//RX}CRɂ		2016/12/02܂łA2016/12/03ȍ~Agp܂B肵ē삵Ă܂B
//}}ǂꂩIĉB
#endif//__RENESAS__
/****************************************************************************
 *	vbgtH[ˑ - Pthreadsɂ
 ****************************************************************************/
#ifdef  RRS_USE_PTHREADS
/*typedef*/ struct _ST_RRS {
	uint16_t	n_job;			//Wu̐					   =RRS_new_*()Ɏw肵֐̐+1/*RRS_new_*()ĂяoReLXg̃Wu
	uint16_t	i_job;			//ݎs̃Wȕ			 0 =RRS_new_*()Ɏw肵1Ԗڂ̊֐̃Wu      , 1 =RRS_new_*()Ɏw肵2Ԗڂ̊֐̃Wu      ,c, n_job-1 = RRS_new_*()ĂяoReLXg̃Wu
	sem_t		TBL_sem[0/*n_job*/];	//eWuɑΉZ}tH			[0]=RRS_new_*()Ɏw肵1Ԗڂ̊֐̃WuɑΉ,[1]=RRS_new_*()Ɏw肵2Ԗڂ̊֐̃WuɑΉ,c,[n_job-1]= RRS_new_*()ĂяoReLXg̃WuɑΉ
} /*ST_RRS*/;
/*--------------------------------------------------------------------------*/
void RRS_new_v(ST_RRS** ppRRS/*NULLs*/, int stacksize/*0*/, void (* const aFn[])(ST_RRS*)/*[fn1,[fn2,[...,fnN]]]NULL*/) {
	//֐̐(=ȊÕWu̐)𐔂B
	int i = 0;
	while(aFn[i]) { i++; }
//sv	if(!i) { DIE(); }	//֐̐0ł(Ӗ)͖薳̂ŁAG[ɂȂɂB̏ꍇÃWu鎖ɂȂB
	//\̂̃mۂB
	*ppRRS = calloc(sizeof(ST_RRS) + sizeof((*ppRRS)->TBL_sem[0]) * (i + 1/**/), 1);
	if(!*ppRRS) { DIE(); }
	//Wu̐i[B
	(*ppRRS)->n_job = i + 1/**/;
	//Z}tHB
	for(i = 0; i < (*ppRRS)->n_job; i++) {
		if(sem_init(&(*ppRRS)->TBL_sem[i], 0, 0)) { DIE(); }
	}
	//ȊO̊eWuɂāc
	for(i = 0; i < (*ppRRS)->n_job - 1/**/; i++) {
		pthread_t tid;
		pthread_attr_t attr;
		//Xbh쐬B
		if(pthread_attr_init(&attr)) { DIE(); }
		if(stacksize) { if(pthread_attr_setstacksize(&attr, stacksize)) { DIE(); } }
		if(pthread_create(&tid, &attr, (void* (*)(void*))aFn[i], *ppRRS)) { DIE(); }
		if(pthread_attr_destroy(&attr)) { DIE(); }
		if(pthread_detach(tid)) { DIE(); }	//̌XbhʎqgȂ̂łf^b`č\ȂB
		//̃Xbhyields܂ő҂B
		if(sem_wait(&(*ppRRS)->TBL_sem[i + 1])) { DIE(); }
	}
	//Ŏ̏ԂɂȂĂ܂B
}
void RRS_yield(ST_RRS* pRRS) {
	sem_t *p_sem1, *p_sem2;
	//̃WũZ}tH擾B
	p_sem1 = &pRRS->TBL_sem[pRRS->i_job];
	//Ԃ֐i߂B
	if(++pRRS->i_job == pRRS->n_job) { pRRS->i_job = 0; }
	//̃WũZ}tH擾B
	p_sem2 = &pRRS->TBL_sem[pRRS->i_job];
	//̃WuANeBuɂB
	if(sem_post(p_sem2)) { DIE(); }
	//̏Ԃ܂ő҂B
	if(sem_wait(p_sem1)) { DIE(); }
}
#endif//RRS_USE_PTHREADS
/****************************************************************************
 *	vbgtH[ˑ - _beginthreadexɂ
 ****************************************************************************/
#ifdef  RRS_USE_BEGINTHREADEX
/*typedef*/ struct _ST_RRS {
	uint16_t	n_job;			//Wu̐					   =RRS_new_*()Ɏw肵֐̐+1/*RRS_new_*()ĂяoReLXg̃Wu
	uint16_t	i_job;			//ݎs̃Wȕ			 0 =RRS_new_*()Ɏw肵1Ԗڂ̊֐̃Wu      , 1 =RRS_new_*()Ɏw肵2Ԗڂ̊֐̃Wu      ,c, n_job-1 = RRS_new_*()ĂяoReLXg̃Wu
	HANDLE		TBL_evt[0/*n_job*/];	//eWuɑΉCxg			[0]=RRS_new_*()Ɏw肵1Ԗڂ̊֐̃WuɑΉ,[1]=RRS_new_*()Ɏw肵2Ԗڂ̊֐̃WuɑΉ,c,[n_job-1]= RRS_new_*()ĂяoReLXg̃WuɑΉ
} /*ST_RRS*/;
/*--------------------------------------------------------------------------*/
void RRS_new_v(ST_RRS** ppRRS/*NULLs*/, int stacksize/*0*/, void (* const aFn[])(ST_RRS*)/*[fn1,[fn2,[...,fnN]]]NULL*/) {
	//֐̐(=ȊÕWu̐)𐔂B
	int i = 0;
	while(aFn[i]) { i++; }
//sv	if(!i) { DIE(); }	//֐̐0ł(Ӗ)͖薳̂ŁAG[ɂȂɂB̏ꍇÃWu鎖ɂȂB
	//\̂̃mۂB
	*ppRRS = calloc(sizeof(ST_RRS) + sizeof((*ppRRS)->TBL_evt[0]) * (i + 1/**/), 1);
	if(!*ppRRS) { DIE(); }
	//Wu̐i[B
	(*ppRRS)->n_job = i + 1/**/;
	//Cxg쐬B
	for(i = 0; i < (*ppRRS)->n_job; i++) {
		(*ppRRS)->TBL_evt[i] = CreateEvent(NULL, FALSE/*ZbgIuWFNg*/, FALSE/*VOi*/, NULL);
		if(!(*ppRRS)->TBL_evt[i]) { DIE(); }
	}
	//ȊO̊eWuɂāc
	for(i = 0; i < (*ppRRS)->n_job - 1/**/; i++) {
		//Xbh쐬B
		if(!_beginthreadex(NULL, stacksize, (unsigned (__stdcall *)(void*))aFn[i], *ppRRS, 0, NULL)) { DIE(); }	//ɂ__cdecl__stdcallփLXg鎖͈Sł͂ȂB̏ꍇ͈1ł鎖,y,֐ԂȂOƂĂ̂œ薳B
		//̃Xbhyields܂ő҂B
		if(WaitForSingleObject((*ppRRS)->TBL_evt[i + 1], INFINITE) != WAIT_OBJECT_0) { DIE(); }
	}
	//Ŏ̏ԂɂȂĂ܂B
}
void RRS_yield(ST_RRS* pRRS) {
	HANDLE hEvent1, hEvent2;
	//̃WũCxg擾B
	hEvent1 = pRRS->TBL_evt[pRRS->i_job];
	//Ԃ֐i߂B
	if(++pRRS->i_job == pRRS->n_job) { pRRS->i_job = 0; }
	//̃WũZ}tH擾B
	hEvent2 = pRRS->TBL_evt[pRRS->i_job];
	//̃WuANeBuɂB
	if(!SetEvent(hEvent2)) { DIE(); }
	//̏Ԃ܂ő҂B
	if(WaitForSingleObject(hEvent1, INFINITE) != WAIT_OBJECT_0) { DIE(); }
}
#endif//RRS_USE_BEGINTHREADEX
/****************************************************************************
 *	vbgtH[ˑ - ucontextɂ
 ****************************************************************************/
#ifdef  RRS_USE_UCONTEXT
/*typedef*/ struct _ST_RRS {
	uint16_t	n_job;			//Wu̐					   =RRS_new_*()Ɏw肵֐̐+1/*RRS_new_*()ĂяoReLXg̃Wu
	uint16_t	i_job;			//ݎs̃Wȕ			 0 =RRS_new_*()Ɏw肵1Ԗڂ̊֐̃Wu      , 1 =RRS_new_*()Ɏw肵2Ԗڂ̊֐̃Wu      ,c, n_job-1 = RRS_new_*()ĂяoReLXg̃Wu
	ucontext_t	TBL_ucx[0/*n_job*/];	//eWuɑΉ郆[U[ReLXg	[0]=RRS_new_*()Ɏw肵1Ԗڂ̊֐̃WuɑΉ,[1]=RRS_new_*()Ɏw肵2Ԗڂ̊֐̃WuɑΉ,c,[n_job-1]= RRS_new_*()ĂяoReLXg̃WuɑΉ
} /*ST_RRS*/;
/*--------------------------------------------------------------------------*/
void RRS_new_v(ST_RRS** ppRRS/*NULLs*/, int stacksize/*0*/, void (* const aFn[])(ST_RRS*)/*[fn1,[fn2,[...,fnN]]]NULL*/) {
	//֐̐(=ȊÕWu̐)𐔂B
	int i = 0;
	while(aFn[i]) { i++; }
//sv	if(!i) { DIE(); }	//֐̐0ł(Ӗ)͖薳̂ŁAG[ɂȂɂB̏ꍇÃWu鎖ɂȂB
	//\̂̃mۂB
	*ppRRS = calloc(sizeof(ST_RRS) + sizeof((*ppRRS)->TBL_ucx[0]) * (i + 1/**/), 1);
	if(!*ppRRS) { DIE(); }
	//Wu̐i[B
	(*ppRRS)->n_job = i + 1/**/;
	//[U[ReLXg쐬B	//̃[U[ReLXg((*ppRRS)->TBL_ucx[(*ppRRS)->n_job-1])͂܂쐬ȂB
	if(!stacksize) {
#ifdef  WIN32	//Win32
		stacksize = 1048576/**/;	//l1MBƂ(2016/12/03)BRpcl.cco_create()̃RgQƂB
#else //WIN32	//P/ECE,Generic
		stacksize = 4096/**/;	//l4KBƂ(2016/12/03)BRpcl.cco_create()̃RgQƂB
#endif//WIN32
	}
	for(i = 0; i < (*ppRRS)->n_job - 1/**/; i++) {
		ucontext_t* p_ucx = &(*ppRRS)->TBL_ucx[i];
		getcontext(p_ucx);
		p_ucx->uc_stack.ss_size = stacksize;
		p_ucx->uc_stack.ss_sp   = malloc(stacksize);
		if(!p_ucx->uc_stack.ss_sp) { DIE(); }
		makecontext(p_ucx, aFn[i], 1, *ppRRS);
	}
	//ŏ̃WuANeBuɂB
	(*ppRRS)->i_job = i/*=((*ppRRS)->n_job-1)*/;
	RRS_yield(*ppRRS);			//̃[U[ReLXg((*ppRRS)->TBL_ucx[(*ppRRS)->n_job-1])͂ō쐬B
	//Ŏ̏ԂɂȂĂ܂B
}
void RRS_yield(ST_RRS* pRRS) {
	ucontext_t* p_ucx1, *p_ucx2;
#if     (defined(WIN32) && defined(GC_H))
	//؂ւÕWuAŌ̃Wu(=RRS_new_*()ĂяoReLXg̃Wu)Ȃ΁c
	if(pRRS->i_job == (pRRS->n_job - 1)) {
		//'GC_dont_gc'fNgB
		GC_disable();
	}
#endif//(defined(WIN32) && defined(GC_H))
	//̃Wũ[U[ReLXg擾B
	p_ucx1 = &pRRS->TBL_ucx[pRRS->i_job];
	//Ԃ֐i߂B
	if(++pRRS->i_job == pRRS->n_job) { pRRS->i_job = 0; }
	//̃Wũ[U[ReLXg擾B
	p_ucx2 = &pRRS->TBL_ucx[pRRS->i_job];
	//̃WuANeBuɂB
	swapcontext(p_ucx1, p_ucx2);
	//Ŏ̏ԂɂȂĂ܂B
#if     (defined(WIN32) && defined(GC_H))
	//؂߂̃WuAŌ̃Wu(=RRS_new_*()ĂяoReLXg̃Wu)Ȃ΁c
	if(pRRS->i_job == (pRRS->n_job - 1)) {
		//'GC_dont_gc'fNgB
		GC_enable();
		//ŏ̃K[x[WRNVsB
		GC_collect_a_little();
	}
#endif//(defined(WIN32) && defined(GC_H))
}
#endif//RRS_USE_UCONTEXT
/****************************************************************************
 *	vbgtH[ˑ - Fiberɂ
 ****************************************************************************/
#ifdef  RRS_USE_FIBER
/*typedef*/ struct _ST_RRS {
	uint16_t	n_job;			//Wu̐					   =RRS_new_*()Ɏw肵֐̐+1/*RRS_new_*()ĂяoReLXg̃Wu
	uint16_t	i_job;			//ݎs̃Wȕ			 0 =RRS_new_*()Ɏw肵1Ԗڂ̊֐̃Wu      , 1 =RRS_new_*()Ɏw肵2Ԗڂ̊֐̃Wu      ,c, n_job-1 = RRS_new_*()ĂяoReLXg̃Wu
	void*		TBL_fib[0/*n_job*/];	//eWuɑΉt@Co[			[0]=RRS_new_*()Ɏw肵1Ԗڂ̊֐̃WuɑΉ,[1]=RRS_new_*()Ɏw肵2Ԗڂ̊֐̃WuɑΉ,c,[n_job-1]= RRS_new_*()ĂяoReLXg̃WuɑΉ
} /*ST_RRS*/;
/*--------------------------------------------------------------------------*/
void RRS_new_v(ST_RRS** ppRRS/*NULLs*/, int stacksize/*0*/, void (* const aFn[])(ST_RRS*)/*[fn1,[fn2,[...,fnN]]]NULL*/) {
	//֐̐(=ȊÕWu̐)𐔂B
	int i = 0;
	while(aFn[i]) { i++; }
//sv	if(!i) { DIE(); }	//֐̐0ł(Ӗ)͖薳̂ŁAG[ɂȂɂB̏ꍇÃWu鎖ɂȂB
	//\̂̃mۂB
	*ppRRS = calloc(sizeof(ST_RRS) + sizeof((*ppRRS)->TBL_fib[0]) * (i + 1/**/), 1);
	if(!*ppRRS) { DIE(); }
	//Wu̐i[B
	(*ppRRS)->n_job = i + 1/**/;
	//t@Co[쐬B
	// - ȉ̏ŁAConvertThreadToFiber()ĂяoOCreateFiber()ĂяoĂ܂ȀłSłB
	//   ConvertThreadToFiber()́ASwitchToFiber()ɌĂяoĂΗǂACreateFiber()ɌĂяoKv͖łB
	//   uMSDN - CreateFiberv(https://msdn.microsoft.com/ja-jp/library/cc429060.aspx)ɁA
	//   XbhSwitchToFiber֐găt@CoXPW[O邽߂ɂ́AConvertThreadToFiber֐ĂяoÃXbhɊ֘Atꂽt@Co݂悤ɂĂKv܂B
	//   ƏĂA(LĂ͂܂)ACreateFiber()ConvertThreadToFiber()ɈˑĂȂǂݎ܂B
	// - WindowsɂēXbhConvertThreadToFiber()𕡐ĂяoƎsNULLԂ悤łB
	//   ]ăAvP[VƎConvertThreadToFiber()gpĂꍇRRSFiberɂ͎gpo܂B
	//   ́Aȉ̂悤ɏΉł邩Ƃl̂łc
	//   (*ppRRS)->TBL_fib[i/*=((*ppRRS)->n_job-1)*/] = GetCurrentFiber();		//ɃAvP[VConvertThreadToFiber()ĂяoĂƉ肵Ă܂݂̃t@Co[擾Ă݂B
	//   if(!(*ppRRS)->TBL_fib[i/*=((*ppRRS)->n_job-1)*/]) {				//ɃAvP[VConvertThreadToFiber()ĂяoĂȂ΁c
	//     (*ppRRS)->TBL_fib[i/*=((*ppRRS)->n_job-1)*/] = ConvertThreadToFiber(*ppRRS);	//
	//     if(!(*ppRRS)->TBL_fib[i/*=((*ppRRS)->n_job-1)*/]) { DIE(); }
	//   }
	//   cۂɎĂ݂ƁAConvertThreadToFiber()ĂяoOGetCurrentFiber()ĂяoƁAGetCurrentFiber()NULLԂ̂ł͂Ȃf^ȒlԂ悤ŁAL̕@ł͉o܂łB
	//   ͂AAvP[VƎConvertThreadToFiber()gpĂꍇRRSFiberɂgp@͖悤łB
	for(i = 0; i < (*ppRRS)->n_job - 1/**/; i++) {
#ifdef  WIN32	//Win32
		(*ppRRS)->TBL_fib[i] = CreateFiber(stacksize, (void (__stdcall *)(void*))aFn[i], *ppRRS);	//ɂ__cdecl__stdcallփLXg鎖͈Sł͂ȂB̏ꍇ͈1ł鎖,y,֐ԂȂOƂĂ̂œ薳B
#else //WIN32	//P/ECE,Generic
		(*ppRRS)->TBL_fib[i] = CreateFiber(stacksize, (void (          *)(void*))aFn[i], *ppRRS);
#endif//WIN32
		if(!(*ppRRS)->TBL_fib[i]) { DIE(); }
	}
	(*ppRRS)->TBL_fib[i/*=((*ppRRS)->n_job-1)*/] = ConvertThreadToFiber(*ppRRS);	//
	if(!(*ppRRS)->TBL_fib[i/*=((*ppRRS)->n_job-1)*/]) { DIE(); }	//֐ĂтOɁAAvP[VConvertThreadToFiber()ĂяoĂꍇAWindowsł͂ŃG[~܂B
	//ŏ̃WuANeBuɂB
	(*ppRRS)->i_job = i/*=((*ppRRS)->n_job-1)*/;
	RRS_yield(*ppRRS);
	//Ŏ̏ԂɂȂĂ܂B
}
void RRS_yield(ST_RRS* pRRS) {
#if     (defined(WIN32) && defined(GC_H))
	//؂ւÕWuAŌ̃Wu(=RRS_new_*()ĂяoReLXg̃Wu)Ȃ΁c
	if(pRRS->i_job == (pRRS->n_job - 1)) {
		//'GC_dont_gc'fNgB
		GC_disable();
	}
#endif//(defined(WIN32) && defined(GC_H))
	//Ԃ֐i߂B
	if(++pRRS->i_job == pRRS->n_job) { pRRS->i_job = 0; }
	//̃WuANeBuɂB
	SwitchToFiber(pRRS->TBL_fib[pRRS->i_job]);
	//Ŏ̏ԂɂȂĂ܂B
#if     (defined(WIN32) && defined(GC_H))
	//؂߂̃WuAŌ̃Wu(=RRS_new_*()ĂяoReLXg̃Wu)Ȃ΁c
	if(pRRS->i_job == (pRRS->n_job - 1)) {
		//'GC_dont_gc'fNgB
		GC_enable();
		//ŏ̃K[x[WRNVsB
		GC_collect_a_little();
	}
#endif//(defined(WIN32) && defined(GC_H))
}
#endif//RRS_USE_FIBER
/****************************************************************************
 *	vbgtH[ˑ - PCLɂ
 ****************************************************************************/
#ifdef  RRS_USE_PCL
/*typedef*/ struct _ST_RRS {
	uint16_t	n_job;			//Wu̐					   =RRS_new_*()Ɏw肵֐̐+1/*RRS_new_*()ĂяoReLXg̃Wu
	uint16_t	i_job;			//ݎs̃Wȕ			 0 =RRS_new_*()Ɏw肵1Ԗڂ̊֐̃Wu      , 1 =RRS_new_*()Ɏw肵2Ԗڂ̊֐̃Wu      ,c, n_job-1 = RRS_new_*()ĂяoReLXg̃Wu
	coroutine_t	TBL_co[0/*n_job*/];	//eWuɑΉR[`			[0]=RRS_new_*()Ɏw肵1Ԗڂ̊֐̃WuɑΉ,[1]=RRS_new_*()Ɏw肵2Ԗڂ̊֐̃WuɑΉ,c,[n_job-1]= RRS_new_*()ĂяoReLXg̃WuɑΉ
} /*ST_RRS*/;
/*--------------------------------------------------------------------------*/
void RRS_new_v(ST_RRS** ppRRS/*NULLs*/, int stacksize/*0*/, void (* const aFn[])(ST_RRS*)/*[fn1,[fn2,[...,fnN]]]NULL*/) {
	//֐̐(=ȊÕWu̐)𐔂B
	int i = 0;
	while(aFn[i]) { i++; }
//sv	if(!i) { DIE(); }	//֐̐0ł(Ӗ)͖薳̂ŁAG[ɂȂɂB̏ꍇÃWu鎖ɂȂB
	//\̂̃mۂB
	*ppRRS = calloc(sizeof(ST_RRS) + sizeof((*ppRRS)->TBL_co[0]) * (i + 1/**/), 1);
	if(!*ppRRS) { DIE(); }
	//Wu̐i[B
	(*ppRRS)->n_job = i + 1/**/;
	//R[`쐬B
	co_thread_init();	//pcl.W[ɂPCL̎łco_thread_init()𕡐ĂяoĂSłB]ăAvP[VƎco_thread_init()gpĂꍇRRSPCLɂ͎gp\łB
	for(i = 0; i < (*ppRRS)->n_job - 1/**/; i++) {
		(*ppRRS)->TBL_co[i] = co_create((void (*)(void*))aFn[i], *ppRRS, NULL, stacksize);
		if(!(*ppRRS)->TBL_co[i]) { DIE(); }
	}
	(*ppRRS)->TBL_co[i/*=((*ppRRS)->n_job-1)*/] = co_current();	//
	if(!(*ppRRS)->TBL_co[i/*=((*ppRRS)->n_job-1)*/]) { DIE(); }
	//ŏ̃WuANeBuɂB
	(*ppRRS)->i_job = i/*=((*ppRRS)->n_job-1)*/;
	RRS_yield(*ppRRS);
	//Ŏ̏ԂɂȂĂ܂B
}
void RRS_yield(ST_RRS* pRRS) {
	//Ԃ֐i߂B
	if(++pRRS->i_job == pRRS->n_job) { pRRS->i_job = 0; }
	//̃WuANeBuɂB
	co_call(pRRS->TBL_co[pRRS->i_job]);
	//Ŏ̏ԂɂȂĂ܂B
}
#endif//RRS_USE_PCL
/****************************************************************************
 *	vbgtH[ˑ - RX}CRɂ
 ****************************************************************************/
#ifdef  RRS_USE_RXMCU
// * Fri Sep 30 21:41:38 JST 2016 Naoyuki Sawa
// - RRS_new_v(),RRS_yield()́AHewp̎쐬܂B
//   u/clip/keep/RX}CRp_ReLXgXCb`.7zv́A2016/09/30o[W𗘗pĂ܂B
//   I蓖Ă邽߂ɁAX^bNobt@TCY͌ŒƂ܂B
// * Sat Oct 01 21:11:57 JST 2016 Naoyuki Sawa
// - RRS_new_v(),RRS_yield()Hewp̎ŁAContext.srcoCiC\[Xɖߍ݂܂B
//   AContext.hContext.srcAvWFNgɊ܂߂Kv͖Ȃ܂B
//   u/clip/keep/RX}CRp_ReLXgXCb`.7zv́A2016/10/01o[W𗘗pĂ܂B
//   ڍׂ́A/clip/keep/RX}CRp_ReLXgXCb`.7zREADME.TXT́ÃRgQƂĉB
//{{2016/10/01ύX:RRS_new_v(),RRS_yield()Hewp̎ŁAContext.srcoCiC\[Xɖߍ݂܂B
//#include "Context.h"	//u/clip/keep/RX}CRp_ReLXgXCb`.7zv́A2016/09/30o[W𗘗pĂ܂B
//2016/10/01ύX:RRS_new_v(),RRS_yield()Hewp̎ŁAContext.srcoCiC\[Xɖߍ݂܂B
/*static*/ const unsigned char TBL_Context_src[]={0xEF,0x05,0xFF,0x20,0x21,0x7E,0xA3,0x7E,0xA4,0x39,0x06,0x00,0x7E,0xB1,0x02,0x6E,0x6D,0xE3,0x10,0xEF,0x50,0x02,0x6E,0x6D,0x06,0xA0,0x10,0x10,0x6F,0x6D,0x02};	//staticɂHewuC5550 (W) Variable "TBL_Context_src" was set but never usedvƂxôŎdstatic폜܂BǂHew͔zf[^R[hƂĎgpĂgpĂ鎖FoȂ悤łB
#define Context_Init(StackBuffer, StackBufferBytes, StartupFunction, StartupArgument)	(*(void (*)(void*, int, void (*)(void*), void*))(&TBL_Context_src[0]))((StackBuffer), (StackBufferBytes), (StartupFunction), (StartupArgument))
#define Context_Switch(StackBuffer)							(*(void (*)(void*))(&TBL_Context_src[22]))(StackBuffer)
//}}2016/10/01ύX:RRS_new_v(),RRS_yield()Hewp̎ŁAContext.srcoCiC\[Xɖߍ݂܂B
#ifndef StackBufferBytes
#define StackBufferBytes	4096	//
#endif//StackBufferBytes
/*typedef*/ struct _ST_RRS {
	uint16_t	n_job;			//Wu̐					   =RRS_new_*()Ɏw肵֐̐+1/*RRS_new_*()ĂяoReLXg̃Wu
	uint16_t	i_job;			//ݎs̃Wȕ			 0 =RRS_new_*()Ɏw肵1Ԗڂ̊֐̃Wu      , 1 =RRS_new_*()Ɏw肵2Ԗڂ̊֐̃Wu      ,c, n_job-1 = RRS_new_*()ĂяoReLXg̃Wu
	int		StackBuffer[StackBufferBytes/sizeof(int)];	//ReLXgp̃X^bNobt@
} /*ST_RRS*/;
/*--------------------------------------------------------------------------*/
void RRS_new_v(ST_RRS** ppRRS/*NULLs*/, int stacksize/*0*/, void (* const aFn[])(ST_RRS*)/*[fn1,[fn2,[...,fnN]]]NULL*/) {
	//Hewp̎́AVOCX^XłB
	static ST_RRS stRRS;
	if(stRRS.n_job) { DIE(); }	//Hewp̎ł́ARRS_new_v()ȏĂяo͏o܂B
	if(stacksize && (stacksize != StackBufferBytes)) { DIE(); }	//Hewp̎ł́AX^bNTCY̎wȗ(stacksize==0)ÁAStackBufferBytesɈvX^bNTCY(stacksize==StackBufferBytes)Awo܂B
	{
		//֐̐(=ȊÕWu̐)𐔂B
		int i = 0;
		while(aFn[i]) { i++; }
		if(i > 1) { DIE(); }	//Hewp̎ł́AuReLXg+ReLXg0(i==0)v,,uReLXg+ReLXg1(i==1)v̍\Awo܂B
		//\̂̃|C^i[B
		*ppRRS = &stRRS;
		//Wu̐i[B
		(*ppRRS)->n_job = i + 1/**/;
		//ReLXgL΁c
		if((*ppRRS)->n_job == 2) {
			//ReLXg쐬B
			Context_Init((*ppRRS)->StackBuffer, StackBufferBytes, (void (*)(void*))aFn[0], *ppRRS);
		}
		//ŏ̃WuANeBuɂB
		(*ppRRS)->i_job = i/*=((*ppRRS)->n_job-1)*/;
		RRS_yield(*ppRRS);
		//Ŏ̏ԂɂȂĂ܂B
	}
}
void RRS_yield(ST_RRS* pRRS) {
	//Ԃ֐i߂B
	if(++pRRS->i_job == pRRS->n_job) { pRRS->i_job = 0; }
	//ReLXgL΁c
	if(pRRS->n_job == 2) {
		//̃WuANeBuɂB
		Context_Switch(pRRS->StackBuffer);
	}
	//Ŏ̏ԂɂȂĂ܂B
}
#endif//RRS_USE_RXMCU
/****************************************************************************
 *	vbgtH[ʕ
 ****************************************************************************/
#ifndef PIECE
void RRS_new_l(ST_RRS** ppRRS/*NULLs*/, int stacksize/*0*/, ...) {
	va_list ap;
	va_start(ap, stacksize);
	RRS_new_a(ppRRS, stacksize, ap);
	va_end(ap);
}
void RRS_new_a(ST_RRS** ppRRS/*NULLs*/, int stacksize/*0*/, va_list ap) {
	void (*aFn[(7+1)/**/])(ST_RRS*);	//pAWu̐7ȉ(I[(NULL)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	int i = 0;
	for(;;) {
	    //	if(!(aFn[i] =                    va_arg(ap, void (*)(ST_RRS*)))) { break; }	//{͂Ava_arg()Ɋ֐|C^woȂ̂Łc
#ifndef __RENESAS__
//Win32P/ECȄꍇ
		if(!(aFn[i] =                    va_arg(ap, void  *          ))) { break; }	//BR[h͓łB
#else //__RENESAS__
//Hew̏ꍇ
		if(!(aFn[i] = (void (*)(ST_RRS*))va_arg(ap, void  *          ))) { break; }	//BR[h͓łB	(void*)֐|C^ɑ͈̂SȂ͂Ȃ̂AHewł͉̂uC5513 (W) A value of type "void *" cannot be assigned to an entity of type "void (*)(ST_RRS *)"vƂxoBd̂ŁAHew̏ꍇIɃLXg鎖ɂB
#endif//__RENESAS__
		if(++i >= ARRAY_SIZE(aFn)) { DIE(); }	//Œ~ꍇ́AaFn[]s,,ďoI[YĂB炭҂낤B
	}
	RRS_new_v(ppRRS, stacksize, aFn);
}
#else //PIECE
void RRS_new_l(ST_RRS** ppRRS/*NULLs*/, int stacksize/*0*/, ...);
void RRS_new_a(ST_RRS** ppRRS/*NULLs*/, int stacksize/*0*/, va_list ap);
asm("
		.code
		.align		1
		.global		RRS_new_l
		.global		RRS_new_a
RRS_new_l:
		;//%r12     := ppRRS
		;//[%sp+ 0] := retp
		;//[%sp+ 4] := stacksize
		;//[%sp+ 8] := ...
		xld.w		%r13, [%sp+4]				;//%r13 := stacksize
		xadd		%r14, %sp, 8				;//%r14 := ap = &...
RRS_new_a:
		;//%r12     := ppRRS
		;//%r13     := stacksize
		;//%r14     := ap
		xjp		RRS_new_v
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
int RRS_n_job(ST_RRS* pRRS) {
	//Wu̐ԂB
	return pRRS->n_job;
}
int RRS_i_job(ST_RRS* pRRS) {
	//ݎs̃WȕԂԂB
	return pRRS->i_job;
}
/****************************************************************************
 *	ӎ
 ****************************************************************************/
#if 0
//{{2016/02/19폜:̒ӎ͌ÂȂ܂BAAv[V̓_ɒӂKv͂܂B
//
//@pRRSO[oϐɊi[AeWu'pRRS'ł͂Ȃ'O[oϐpRRS'QƂꍇA'O[oϐpRRS'i[^C~OɒӂB
//Ԉ
//@RRS_new_l()Ԃ܂ŁARRS_new_l()'߂lpRRS'͎󂯎ȂB̓_YƁAȉ̃oOB
//@ST_RRS* pRRS;			//O[oϐ
//@void app_main() {
//@  pRRS = RRS_new_l(0,jobA,NULL);	//̊֐ԂOjobA()ĂяoB
//@  for(;;) { jobB_subr(); }
//@}
//@void jobA(ST_RRS* pRRS) {
//@  for(;;) { jobA_subr(); }
//@}
//@void jobA_subr() {
//@  puts("jobA_subr");
//@  RRS_yield(pRRS);			//'O[oϐpRRS'QƂĂBɂ֗'O[oϐpRRS'͂܂i[ĂȂ̂ŁANULLtQƃG[B
//@}
//@void jobB_subr() {
//@  puts("jobB_subr");
//@  RRS_yield(pRRS);			//'O[oϐpRRS'QƂĂB
//@}
//@
//@pRRSO[oϐɊi[Ȃ΁AOq̃oO͔ȂB
//@void app_main() {
//@  ST_RRS* pRRS = RRS_new_l(0,jobA,NULL);
//@  for(;;) {
//@    puts("jobB_subr");
//@    RRS_yield(pRRS);		//RRS_new_l()Ԃ'[JϐpRRS'QƂĂB
//@  }
//@}
//@void jobA(ST_RRS* pRRS) {
//@  for(;;) {
//@    puts("jobA_subr");
//@    RRS_yield(pRRS);		//jobA()'pRRS'QƂĂB
//@  }
//@}
//A
//@pRRSO[oϐɊi[ꍇAŏ̃Wȕ̐擪Ŋi[̂SB
//@ST_RRS* pRRS;			//O[oϐ
//@void app_main() {
//@  /*ST_RRS* pRRS=*/ RRS_new_l(0,jobA,NULL);	//RRS_new_l()̖߂ĺAjobA()'O[oϐpRRS'Ɋi[lƓȂ̂ŁARRS_new_l()̖߂l󂯎Kv͖B
//@  for(;;) {
//@    puts("jobB_subr");
//@    RRS_yield(pRRS);		//'O[oϐpRRS'QƂĂB
//@  }
//@}
//@void jobA(ST_RRS* _pRRS) {
//@  pRRS = _pRRS;			//'O[oϐpRRS'i[B
//@  for(;;) {
//@    puts("jobA_subr");
//@    RRS_yield(pRRS);		//'O[oϐpRRS'QƂĂB
//@  }
//@}
//}}2016/02/19폜:̒ӎ͌ÂȂ܂BAAv[V̓_ɒӂKv͂܂B
#endif
//{{2016/02/19ǋL
#if 0
΂炭̊ԁAL̕@ŃAvP[VŉĂ̂łAԈႦăoỎɂȂՂ̂ŁA͂蓖W[ŉ鎖ɂ܂B
̂߂ɁARRS_new_l(),RRS_new_a(),RRS_new_v()̈ύX܂B
ύXO͍\̂̃|C^߂lŕԂĂ܂AύX͑Ŏw肳ꂽϐɊi[悤ɂ܂B
́ARRS_new_v()\̂̃mۂɑŎw肳ꂽϐɍ\̂̃|C^i[̂ŁAAvP[VňӎKv͗L܂B
ύX̗
@ST_RRS* pRRS;			//O[oϐ
@void app_main() {
@  RRS_new_l(&pRRS,0,jobA,NULL);	//RRS_new_l()\̂̃mۂpRRSɍ\̂̃|C^i[B
@  for(;;) { jobB_subr(); }
@}
@void jobA(ST_RRS* pRRS) {
@  for(;;) { jobA_subr(); }
@}
@void jobA_subr() {
@  puts("jobA_subr");
@  RRS_yield(pRRS);			//'O[oϐpRRS'QƂĂBRRS_new_l()ԂOɌĂяo邪A̎_'O[oϐpRRS'͊Ɋi[Ă̂ŁA삷B
@}
@void jobB_subr() {
@  puts("jobB_subr");
@  RRS_yield(pRRS);			//'O[oϐpRRS'QƂĂB
@}
#endif
//}}2016/02/19ǋL
/****************************************************************************
 *	Wup̊֐
 ****************************************************************************/
/*typedef*/ struct _ST_RRS_sync_node {
	int			done;		//oAꂽtO
	ST_RRS_sync_node*	next;		//m[h`FC̎̃m[h
} /*ST_RRS_sync_node*/;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void RRS_sync(ST_RRS* pRRS, ST_RRS_sync_root* root) {
//{{2016/09/30ǉ:RRS_sync_idle()ǉ܂B
	//RRS_sync()́AAChO֐w肹RRS_sync_idle()ĂяoƓłB
	RRS_sync_idle(pRRS, root, NULL, NULL);
}
void RRS_sync_idle(ST_RRS* pRRS, ST_RRS_sync_root* root, void (*idle/*NULL*/)(void* arg), void* arg) {
//}}2016/09/30ǉ:RRS_sync_idle()ǉ܂B
	ST_RRS_sync_node node;
	//ɁAWu̐AWu̐ȏɂȂĂAG[łB
	// - Œ~AAvP[Vroot->req̏YāA(root->req==0)ł\L܂B
	if(root->cnt >= root->req) { DIE(); }
	//[JϐnodeAWũm[h`FC̃`FCB
	// - `FC̏͌ʂɉeȂ̂ŁA擪Ƀ`FCĂɃ`FCĂ\܂B
	//   擪Ƀ`FCǂ̂ŁA݂̎ł́A擪Ƀ`FC悤ɂĂ܂B
	node.done = 0;	//YȂ!!
	node.next = root->first;
	            root->first = &node;
	//Wu̐𑝂₵āAWu̐ɓBc
	if(++root->cnt == root->req) {
		//Wũm[h`FCɃ`FCĂASẴm[hɁAoAꂽtOZbgB
		do {
#ifdef  _DEBUG
			//fobOrhȂ΁Am[h`FC̒ƓWu̐vĂ鎖mF邽߂ɁAWu̐炵čsB
			// - ̃[v𔲂ŁAWu̐0ɂȂmF܂B
			root->cnt--;
			//fobOrhȂ΁AoAꂽtO܂ZbgĂȂmFB
			// - Œ~AW[̃oOłB
			if(root->first->done) { DIE(); }
#endif//_DEBUG
			root->first->done = 1;
			root->first = root->first->next;
		} while(root->first);
#ifdef  _DEBUG
		//fobOrhȂ΁Am[h`FC̒ƓWu̐vĂ鎖mFB
		// - Œ~AW[̃oO,,ʂ̃WuĎgprootď\L܂B	{{2016/06/16RgǋL:L̃oÓA'Thu Jun 16 20:40:56 JST 2016'ɒǉu'oAꂽtOZbg܂Ń[vđ҂'̒ŁAm[h`FCj󂳂ĂȂfobOv̕ŐɌoƎv܂AŜ߂ɂł̌cĂɂ܂B}}
		//   ƂẮArootO[oϐƂĒ`AreqtB[hÓIɏĂ΁AAvP[Vroot𖾎Iɍď鏈͕Kv͂łB
		if(root->cnt) { DIE(); }
#endif//_DEBUG
		root->cnt = 0;	//fobOrhł͏Ŋ(root->cnt=0)ł鎖mFς݂Ȃ̂ŁȀ̓_~[ƂȂ܂B
	}
	//``````````dv!!֐̂艺̏ł́ArootQƂĂ͂܂BsăoAꂽWuArootgĎ̓JnĂ\L邩łB``````````
	//oAꂽtOZbg܂Ń[vđ҂B
	// - RRS_sync()ĂяoɂēWu̐Wu̐ɓBꍇ́ȀŊɃoAꂽtOZbgĂAL̃[v͈xs܂B
	while(!node.done) {
#ifdef  _DEBUG
		// * Thu Jun 16 20:40:56 JST 2016 Naoyuki Sawa
		// - 'oAꂽtOZbg܂Ń[vđ҂'̒ŁAm[h`FCj󂳂ĂȂfobOǉ܂B
		//   ڍׂ́Aȉ̒ʂłB
		// - ŁAudv!!֐̂艺̏ł́ArootQƂĂ͂܂BvƏ̂łAɂ́ArootQƂ鎖͉\łB
		//   ȂȂA'while(!node.done)'FalseƔ肳ꂽȂ̂ŁA܂root̍̃oAsĂȂmłB
		//   ]āAŁArootm[h`FCǂČs͉\łB
		//   ([v́A'while(!node.done)'FalseƔ肳ꂽC'RRS_yield(pRRS)'ĂԑOɍsKvL鎖ɒӂĉ!!'RRS_yield(pRRS)'ĂԂƁA̒ŃoAs\L邩łB)
		// - _ƂẮAm[h`FCɎ̃m[h܂܂Ă邩mF鎖ɂ܂B
		//   炩̃oOŁAm[h`FC玩̃m[hOƁAoAsꂽɎ̃m[h̃tOZbgꂸAivɑ҂ƂoÂ炢ǏɂȂ̂ŁȂOɔłB
		//   m[h`FC玩̃m[hOoOP[XƂẮAgproot𑼂̃WuďꍇȂǂłB
		//   <>
		//   ST_RRS_sync_root r = {2};
		//   void job1(ST_RRS* pRRS) { RRS_sync(pRRS, &r); ` }
		//   void job2(ST_RRS* pRRS) { r = (ST_RRS_sync_root){2}; }	job1rŃoA҂ĂrɁArďĂoOłB̌Ajob1RRS_sync()̃[v̒ŁAoOo͂łB
		ST_RRS_sync_node* pnode;
		for(pnode = root->first; pnode; pnode = pnode->next) {	//m[h`FCǂāc
			if(pnode == &node) { break; }			//̃m[h܂܂Ă甲B
		}
		if(!pnode) { DIE(); }					//̃m[h܂܂ĂȂAG[~B
#endif//_DEBUG
//{{2016/09/30ǉ:RRS_sync_idle()ǉ܂B
		//AvP[V`̃AChO֐w肳ĂAAChO֐ĂяoB
		// - AvP[V`̃AChO֐̒ł́ARRS_yield()ĂяoȂ悤ɒӂĉB(vɁAAChO֐Ƃschedule()w肵Ă͂ȂƌłB)	
		//   AAvP[V`̃AChO֐̒RRS_yield()ĂяoƁẢōsRRS_yield()Ăяoƍ킹āARRS_yield()sĂ܂܂B			ydvz
		//   KvIȖɂȂƂ͌Ȃ̂łÃWu̐\ቺAAvP[V̓^C~Oz肵Ăꍇ͒vIȖɂȂ\L܂B	
		// - Aꍇ́ÃubNʂȂ̂ŁAAChO֐xĂяo܂B
		//   ȂƁARRS_sync_idle()ĂяoxɕKAChO֐sāA\ቺĂ܂肪邩łB
		if(idle) { (*idle)(arg); }
//}}2016/09/30ǉ:RRS_sync_idle()ǉ܂B
		//XPW[OsB
		RRS_yield(pRRS);
	}
}
/****************************************************************************
 *	Wup̊֐̎gp
 ****************************************************************************/
#if 0
//eXgvO
	#define TEST_SYNC	//̃V{`Ȃ΁AŃeXgs܂B̃V{`ƁALŃeXgs܂B
void job1(ST_RRS* pRRS);	//OQ
void job2(ST_RRS* pRRS);	//OQ
void job3(ST_RRS* pRRS);	//OQ
void job4(ST_RRS* pRRS);	//OQ
int app_main(int argc, char* argv[]) {
	int exitCode = EXIT_SUCCESS;
	RRS_new_l(&pRRS, 0/*stacksize*/,
		job1,
		job2,
		job3,
		job4,
		NULL/*I[*/);
	while(!_kbhit()) { RRS_yield(pRRS); }
	return exitCode;
}
#ifdef  TEST_SYNC
ST_RRS_sync_root sr3 = { 3 };	//3Wup	̗ł́AWuroot݂܂AKAWuɈroot݂ł͗L܂BgɁAgroot݂ĉB
ST_RRS_sync_root sr4 = { 4 };	//4Wup	Ⴆ΁AŜ4WuLA2Wu~2̑gœꍇ́A2Wuprootg݂ĉBAg̓ɔȂꍇ́AŜňgrootpĂ\܂B
#endif//TEST_SYNC
void job1(ST_RRS* pRRS) {
	int i;
	puts("job1 start");
	//5TCN鏈sz
	for(i = 0; i < 5; i++) { RRS_yield(pRRS); }
	puts("job1 calcA done");
#ifdef  TEST_SYNC
	//3Wu
	RRS_sync(pRRS, &sr3);
	puts("job1 syncA done");
#endif//TEST_SYNC
	//9TCN鏈sz
	for(i = 0; i < 9; i++) { RRS_yield(pRRS); }
	puts("job1 calcB done");
#ifdef  TEST_SYNC
	//3Wu
	RRS_sync(pRRS, &sr3);
	puts("job1 syncB done");
	//4Wu
	RRS_sync(pRRS, &sr4);
#endif//TEST_SYNC
	puts("job1 end");
	for(;;) { RRS_yield(pRRS); }
}
void job2(ST_RRS* pRRS) {
	int i;
	puts("job2 start");
	//7TCN鏈sz
	for(i = 0; i < 7; i++) { RRS_yield(pRRS); }
	puts("job2 calcA done");
#ifdef  TEST_SYNC
	//3Wu
	RRS_sync(pRRS, &sr3);
	puts("job2 syncA done");
#endif//TEST_SYNC
	//3TCN鏈sz
	for(i = 0; i < 3; i++) { RRS_yield(pRRS); }
	puts("job2 calcB done");
#ifdef  TEST_SYNC
	//3Wu
	RRS_sync(pRRS, &sr3);
	puts("job2 syncB done");
	//4Wu
	RRS_sync(pRRS, &sr4);
#endif//TEST_SYNC
	puts("job2 end");
	for(;;) { RRS_yield(pRRS); }
}
void job3(ST_RRS* pRRS) {
	puts("job3 start");
#ifdef  TEST_SYNC
	//3Wu
	RRS_sync(pRRS, &sr3);
	puts("job3 syncA done");
	//3Wu
	RRS_sync(pRRS, &sr3);
	puts("job3 syncB done");
	//4Wu
	RRS_sync(pRRS, &sr4);
#endif//TEST_SYNC
	puts("job3 end");
	for(;;) { RRS_yield(pRRS); }
}
void job4(ST_RRS* pRRS) {
	puts("job4 start");
#ifdef  TEST_SYNC
	//4Wu
	RRS_sync(pRRS, &sr4);
#endif//TEST_SYNC
	puts("job4 end");
	for(;;) { RRS_yield(pRRS); }
}
//
//ŃeXgs(TEST_SYNC`)
job1 start		job1JnA5TCN鏈̎sJnB
job2 start		job2JnA7TCN鏈̎sJnB
job3 start		job3JnB
job3 end		job3͉ȂWuȂ̂ŁAɏIB
job4 start		job4JnB
job4 end		job4ȂWuȂ̂ŁAɏIB
job1 calcA done		job15TCN鏈BɁA9TCN鏈̎sJnB	Ύ=5
job2 calcA done		job27TCN鏈BɁA3TCN鏈̎sJnB	Ύ=7
job2 calcB done		job23TCN鏈B								Ύ=7+3=10
job2 end		job2IB
job1 calcB done		job19TCN鏈B								Ύ=5+9=14
job1 end		job1IB
//LŃeXgs(TEST_SYNC`L)
job1 start		job1JnA5TCN鏈̎sJnB
job2 start		job2JnA7TCN鏈̎sJnB
job3 start		job3JnA3WuJnB
job4 start		job4JnA4WuJnB
job1 calcA done		job15TCN鏈B3WuJnB					Ύ=5
job2 calcA done		job27TCN鏈B3WuJnB					Ύ=7
job2 syncA done		job2́A3WuꂽBɁA3TCN鏈̎sJnB
job3 syncA done		job3́A3WuꂽBɁA3WuJnB						job11ڂ3WuRRS_sync(pRRS,&sr3)ԂOɁAjob3sr3g2ڂ3WuRRS_sync(pRRS,&sr3)JnĂ鎖ɒڂB
job1 syncA done		job1́A3WuꂽBɁA9TCN鏈̎sJnB					sr3̎gpԂA1ڂ3Wu2ڂ3WuŏdĂ邪A薳Bڍׂ́ARRS_sync()֐́udv!!ṽRgQƂB
job2 calcB done		job23TCN鏈B3WuJnB					Ύ=7+3=10
job1 calcB done		job19TCN鏈B3WuJnB					Ύ=7+9=16
job1 syncB done		job1́A3WuꂽBɁA4WuJnB
job2 syncB done		job2́A3WuꂽBɁA4WuJnB
job3 syncB done		job3́A3WuꂽBɁA4WuJnB
job3 end		job3́A4WuꂽBjob3IB
job4 end		job4́A4WuꂽBjob4IB
job1 end		job1́A4WuꂽBjob1IB
job2 end		job2́A4WuꂽBjob2IB
#endif
